import { AfterViewInit, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
import { NwfSchemaColumn } from '../schema/schema';
export declare class NwfFilterComponent implements OnInit, AfterViewInit {
    private _fb;
    ngbDropDown: NgbDropdown;
    dataGrid: DxDataGridComponent;
    nwfFilters: any[];
    filterableColumns: NwfSchemaColumn[];
    filterFormGrp: FormGroup;
    private config;
    private gridInstance;
    private initialColumns;
    constructor(_fb: FormBuilder);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    /**
     * @description adds a new default criterion on click of "Add Filter" button, or being called externally
     */
    addCriterion(schemaColumnObject?: any): void;
    /**
     * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param id
     */
    deleteCriterion(criterionIndex: any): void;
    /**
     * @description deletes all the criterion.
     */
    reset(): void;
    /**
     * @description applies the filter on dx grid instance on hitting Apply button.
     */
    apply(): void;
    /**
     * @description cancel on hitting 'Cancel' button.
     */
    cancel(): void;
    private initPopover;
    private setDxGridFilterOnNwfFilterWidget;
    /**
     * Creates the form that holds all the filter criterion as formControl inside it.
     * FormGroup holds the state of the filter widget.
     */
    private createFormGroup;
    private setFilterFormGrp;
    /**
     * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
     * 1. property, 2. operator, 3. value.
     * @param criterion new filter criterion
     */
    private initCriterion;
    private getCriterionsArray;
    private validateAllFormFields;
    private setFiltersOnDxGridInstance;
    private getCriterionObject;
    /**
     * @description fetch the property from the original params passed into the widget.
     * @param id
     */
    private getPropertyById;
    /**
     * @description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     */
    private getOperatorOptions;
    /**
     * @description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @param
     */
    private dxToNwfFilterConverter;
    private getFilterCriterionFromDxFilter;
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
     */
    private getAllColumnsOnDxGrid;
}
