"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ng = require("angular");
var elipsizer = function ($timeout) {
    return {
        restrict: 'A',
        scope: {
            nwfElipsizeContents: '@'
        },
        link: function (scope, element, attrs) {
            var eventName = 'nwfElipsizeContents';
            var domNode = element[0];
            var truncateContentsToFit = function (invalidateNotChangeTest) {
                /* This check, compares the width that my parent is now, with what I was when I was last set by this directive below
                 It saves the processing at all, if my size has not changed and I don't have to reprocess them. The parameter
                 invalideNotChangeTest is because I want the caller of this func to be able to bypass my optimization if need be.
                 */
                if (invalidateNotChangeTest === void 0) { invalidateNotChangeTest = true; }
                var myParentCell = domNode.parentNode;
                var myCompParentCell = window.getComputedStyle(myParentCell);
                /* I now compute the inside container, minus the padding of the parent, so I match perfectly right and left */
                var myLeftPad = parseInt(myCompParentCell.getPropertyValue('padding-left'));
                var myRightPad = parseInt(myCompParentCell.getPropertyValue('padding-right'));
                var theBiggestICanBe = myParentCell.offsetWidth - myLeftPad - myRightPad;
                if (theBiggestICanBe === scope.currentParentSize && !invalidateNotChangeTest) {
                    return;
                }
                /* Now I make one shadow tempNode off the screen as a sibling of me, stripping it to the mininum footprint */
                if (!scope.t) {
                    var t = domNode.cloneNode(true);
                    while (t.attributes.length > 0) {
                        t.removeAttribute(t.attributes[0].name);
                    }
                    t.setAttribute('style', "position:absolute; white-space: no-wrap; left: -10000px; overflow:visible; width:auto; height: " + domNode.offsetHeight + 'px');
                    domNode.parentNode.insertBefore(t, domNode.nextSibling);
                    scope.t = t;
                }
                /* set my temp node back to the original text when I was born (untruncated) */
                scope.t.textContent = scope.originalText;
                /* The logic to see if my shadow temp div is bigger than my parentNode */
                var isOverflowing = function () {
                    return scope.t.offsetWidth >= theBiggestICanBe;
                };
                var finalName = scope.originalText;
                /* I recursively keep trying to see when it does not */
                for (var i = 0; i < scope.t.textContent.length; i++) {
                    if (!isOverflowing()) {
                        /* Now I set my domNode to the text that is measured to fit */
                        domNode.textContent = finalName;
                        break;
                    }
                    else {
                        /* I am overflowing, time to trim */
                        var currentText = scope.t.textContent;
                        var half = Math.round(currentText.length / 2);
                        finalName = currentText.slice(0, half - 1) + String.fromCharCode(8230) + currentText.slice(half + 2);
                        /* set my shadow node to the sliced version, keep goin! */
                        scope.t.textContent = finalName;
                    }
                }
                /* Save my sized parent domNode's width for later comparison above */
                scope.currentParentSize = theBiggestICanBe;
            };
            /* Here I listen for someone to call my elipsizeContents */
            scope.$on(eventName, function () {
                /* I found I had to do this in a timeout, because I had to wait until the next digest cycle so the resizing had happened. */
                $timeout(function () { return truncateContentsToFit(); });
            });
            /* Here I have to listen for window resize too */
            var resizeHandle;
            var afterResizeEnd = function () {
                truncateContentsToFit();
            };
            ng.element(window).bind('resize', function () {
                clearTimeout(resizeHandle);
                resizeHandle = setTimeout(function () {
                    afterResizeEnd();
                }, 150);
            });
            /* I have to observe the nwfElipsizeContents attribute so I can get the interpolated value that is my contents to be elipsized */
            attrs.$observe(eventName, function (contents) {
                /* now, I take the contents and make it into my originalText property so I can use it for internal calculation */
                scope.originalText = contents;
                /* If I am reinterpolated, I need to set my domNode to this value. I can always count on this to be the real, un elipsized value */
                domNode.textContent = contents;
                /* I also jamb this value into my shadow temp node so that it isn't echoing an old value */
                if (scope.t) {
                    scope.t.textContent = contents;
                }
                /* Call my truncator function so that my visible innerText is updated with whatever I am. I invalidate the check
                 for optimization because now,  I am in a state where any previous interpolation is invalid, I want to clean it.
                 */
                scope.$evalAsync(function () {
                    truncateContentsToFit(true);
                });
            });
        }
    };
};
elipsizer.$inject = ['$timeout'];
exports.default = elipsizer;
//# sourceMappingURL=elipsizer-directive.js.map