"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var FeatureHighlightController = /** @class */ (function () {
    function FeatureHighlightController($scope, $templateCache, nwfFeatureHighlightService) {
        this.$scope = $scope;
        this.$templateCache = $templateCache;
        this.nwfFeatureHighlightService = nwfFeatureHighlightService;
        this.isShowing = false;
    }
    FeatureHighlightController.prototype.$onInit = function () {
        var _this = this;
        this.compCacheKey = "featureHighlight." + this.group + "." + this.component;
        var compTpl = "<" + this.component + " comp-cache-key=\"" + this.compCacheKey + "\"></" + this.component + ">";
        this.$templateCache.put(this.compCacheKey, compTpl);
        //I put this compoment into the template cache so I can reference it later in the uib-popover-template="'{{$ctrl.compCacheKey}}'"  in the component
        this.nwfFeatureHighlightService.put(this.compCacheKey, this.isShowing);
        this.$scope.$watch(function () { return _this.nwfFeatureHighlightService.store[_this.group][_this.component]; }, function (newVal, oldVal) {
            if (newVal !== oldVal) {
                _this.isShowing = newVal;
            }
        });
    };
    FeatureHighlightController.$inject = ['$scope', '$templateCache', 'nwfFeatureHighlightService'];
    return FeatureHighlightController;
}());
exports.default = FeatureHighlightController;
//# sourceMappingURL=featureHighlight-controller.js.map