"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var FeatureStore = /** @class */ (function () {
    function FeatureStore() {
        this._isEnabled = false;
        this.store = {};
    }
    Object.defineProperty(FeatureStore.prototype, "isEnabled", {
        get: function () {
            return this._isEnabled;
        },
        set: function (enabled) {
            var _this = this;
            var groups = Object.keys(this.store);
            // if I am disabling, I shut them all down.
            if (!enabled) {
                groups.forEach(function (item) {
                    var feature = _this.store[item];
                    for (var i in feature) {
                        feature[i] = false;
                    }
                });
            }
            else {
                // I am enabling, I want to show the first one in each group.
                groups.forEach(function (item) {
                    var feature = _this.store[item];
                    for (var i in feature) {
                        feature[i] = true;
                        break;
                    }
                });
            }
            this._isEnabled = enabled;
        },
        enumerable: true,
        configurable: true
    });
    FeatureStore.prototype.getFeatureKey = function (key) {
        return key.split('.');
    };
    FeatureStore.prototype.put = function (featureKey, isShowing) {
        //Check if I am complete!
        var _a = this.getFeatureKey(featureKey), ls = _a[0], groupKey = _a[1], featureId = _a[2];
        if (!this.store[groupKey]) {
            this.store[groupKey] = {};
        }
        if (!this.isEnabled) {
            isShowing = false;
        }
        this.store[groupKey][featureId] = isShowing;
    };
    FeatureStore.prototype.close = function (featureKey) {
        var _a = this.getFeatureKey(featureKey), ls = _a[0], groupKey = _a[1], featureId = _a[2];
        this.store[groupKey][featureId] = false;
        // now open the next
        var keys = Object.keys(this.store[groupKey]);
        var nextIndex = keys.indexOf(featureId) + 1;
        var nextFeature = keys[nextIndex];
        if (nextFeature) {
            this.open(ls + "." + groupKey + "." + nextFeature);
        }
    };
    FeatureStore.prototype.open = function (featureKey) {
        if (!this.isEnabled) {
            return;
        }
        var _a = this.getFeatureKey(featureKey), groupKey = _a[1], featureId = _a[2];
        this.store[groupKey][featureId] = true;
    };
    return FeatureStore;
}());
exports.default = FeatureStore;
//# sourceMappingURL=featureHighlight-service.js.map