"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var datetimePickerComponent = /** @class */ (function () {
    function datetimePickerComponent() {
        var _a;
        this.bindings = {
            changeDatetimeCallback: '&',
            dateModel: '=ngModel',
            datepickerOptions: '<'
        };
        this.controller = (_a = /** @class */ (function () {
                function datetimePickerController($scope) {
                    this.$scope = $scope;
                    //timepicker defaults
                    this.hourStep = 1;
                    this.minuteStep = 1;
                    this.isMeridian = true;
                    this.initialValue = null;
                }
                datetimePickerController.prototype.$onInit = function () {
                    var _this = this;
                    this.$scope.$watch(function () { return _this.dateModel; }, function (newValue, oldValue) {
                        if (newValue !== oldValue) {
                            _this.updateValue();
                        }
                    });
                };
                ;
                datetimePickerController.prototype.updateValue = function () {
                    this.changeDatetimeCallback({ $dateObj: this.dateModel });
                };
                return datetimePickerController;
            }()),
            _a.$inject = ['$scope'],
            _a);
        this.template = "\n        <div uib-datepicker ng-model=\"$ctrl.dateModel\" datepicker-options=\"$ctrl.datepickerOptions\"></div>\n        <div class=\"col mt-2 mb-2 p-0\">\n            <label class=\"form-label\">{{'nwfjs:time' | i18next}}:</label>\n            <div uib-timepicker ng-model=\"$ctrl.dateModel\"\n            hour-step=\"$ctrl.hourStep\" minute-step=\"$ctrl.minuteStep\" show-meridian=\"$ctrl.isMeridian\">\n            </div>\n            <div ng-if=\"!$ctrl.dateModel\" class=\"invalid-feedback\">\n                {{'nwfjs:isInvalidTimeMessage' | i18next}}\n            </div>\n        </div>\n    ";
    }
    datetimePickerComponent.NAME = 'datetimePicker';
    return datetimePickerComponent;
}());
exports.default = datetimePickerComponent;
//# sourceMappingURL=datetimePicker-component.js.map