"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var nwfValidator_1 = require("../nwfValidator");
var IsNumberValidatorController = /** @class */ (function (_super) {
    __extends(IsNumberValidatorController, _super);
    function IsNumberValidatorController($element, $i18next) {
        var _this = _super.call(this, $element) || this;
        _this.$element = $element;
        _this.$i18next = $i18next;
        var el = $element[0];
        _this.myEl.setAttribute('type', 'number');
        _this.invalidMessage = _this.invalidMessage || $i18next.t('nwfjs:isNumberInvalidMessage');
        _this.invalidMinMessage = _this.invalidMinMessage || $i18next.t('nwfjs:isNumberInvalidMinMessage') + el.getAttribute('min');
        _this.invalidMaxMessage = _this.invalidMaxMessage || $i18next.t('nwfjs:isNumberInvalidMaxMessage') + el.getAttribute('max');
        _this.emptyMessage = _this.emptyMessage || $i18next.t('nwfjs:emptyMessage');
        return _this;
    }
    IsNumberValidatorController.prototype.invalidHandler = function () {
        _super.prototype.invalidHandler.call(this);
        if (this.myEl.validity.rangeOverflow) {
            this.myEl.setCustomValidity(this.invalidMaxMessage);
        }
        else if (this.myEl.validity.rangeUnderflow) {
            this.myEl.setCustomValidity(this.invalidMinMessage);
        }
        else {
            this.myEl.setCustomValidity('');
        }
    };
    IsNumberValidatorController.$inject = ['$element', '$i18next'];
    return IsNumberValidatorController;
}(nwfValidator_1.default));
exports.IsNumberValidatorController = IsNumberValidatorController;
var IsNumberValidator = /** @class */ (function () {
    function IsNumberValidator() {
        this.bindToController = {
            emptyMessage: '@?',
            invalidMessage: '@?',
            invalidMaxMessage: '@?',
            invalidMinMessage: '@'
        };
        this.restrict = 'A';
        this.controller = IsNumberValidatorController;
        this.controllerAs = 'numberCtrl';
    }
    IsNumberValidator.NAME = 'isNumber';
    return IsNumberValidator;
}());
exports.IsNumberValidator = IsNumberValidator;
// export factory function
function IsNumberValidatorFactory() {
    return new IsNumberValidator();
}
exports.IsNumberValidatorFactory = IsNumberValidatorFactory;
//# sourceMappingURL=isNumber-directive.js.map