"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var FilterCriterionDateController = /** @class */ (function () {
    function FilterCriterionDateController($filter, $i18next) {
        this.$filter = $filter;
        this.datepickerOptions = {
            showWeeks: false,
            maxMode: 'month',
            minDate: (new Date().getDate() - 390),
            maxDate: new Date()
        };
        //List of default date selections for the user
        this.dateRangeList = [
            { id: "LAST_1h", value: "" },
            { id: "LAST_24h", value: "" },
            { id: "LAST_72h", value: "" },
            { id: "LAST_7d", value: "" },
            { id: "LAST_30d", value: "" },
            { id: "LAST_390d", value: "" }
        ];
        //single gtl or lte date
        this.gtOrLtDate = new Date();
        //range
        this.fromDate = new Date();
        this.toDate = new Date();
        this.isPopoverOpen = false;
        //i18n the values (displayed label in the drop down)
        for (var _i = 0, _a = this.dateRangeList; _i < _a.length; _i++) {
            var dateRangeList = _a[_i];
            //pop in the value (which is the label)
            dateRangeList.value = $i18next.t("nwfjs:" + dateRangeList.id.toLowerCase());
        }
    }
    FilterCriterionDateController.prototype.$onInit = function () {
        /*
        explode the bound datetimeValue to instantiate my internal state based on the value
        */
        if (this.datetimeValue) {
            var timestamp = Date.parse(this.datetimeValue);
            var isValidSingleDate = !isNaN(timestamp);
            if (this.datetimeValue.indexOf('~') !== -1) {
                // I am a range
                var _a = this.datetimeValue.split('~'), fromDate = _a[0], toDate = _a[1];
                this.fromDate = new Date(fromDate);
                this.toDate = new Date(toDate);
            }
            else if (isValidSingleDate) {
                //I am a single gtorLte Date
                this.gtOrLtDate = new Date(this.datetimeValue);
            }
            else {
                // I am just a plain string (LAST_)
                this.cannedTimeRange = this.datetimeValue;
            }
        }
        else {
            this.cannedTimeRange = this.dateRangeList[2].id;
        }
        this.setDefaultValue();
    };
    FilterCriterionDateController.prototype.$onChanges = function (changes) {
        /* If my operator changes I set my defaults for datetimeValue */
        if (changes.operator && changes.operator.currentValue !== changes.operator.previousValue && typeof (changes.operator.previousValue) !== 'object') {
            //Here I am changing from one choice to another (not the intial set!)
            this.datetimeValue = '';
            this.cannedTimeRange = this.dateRangeList[2].id;
            this.setDefaultValue();
        }
    };
    FilterCriterionDateController.prototype.setDefaultValue = function () {
        switch (this.operator) {
            case 'lst':
                this.datetimeValue = this.cannedTimeRange;
                break;
            case 'btw':
                this.datetimeValue = this.toISOStringLocal(this.fromDate) + '~' + this.toISOStringLocal(this.toDate);
                break;
            case 'gte':
            case 'lte':
                // this sets the value to what I Am set to;
                this.datetimeValue = this.toISOStringLocal(this.gtOrLtDate);
                this.datetimeVisibleValue = this.$filter('i18nextFormat')(this.gtOrLtDate);
                break;
        }
        this.updateCallback({ $value: this.datetimeValue });
    };
    FilterCriterionDateController.prototype.setDatetime = function (dateObj) {
        this.datetimeValue = this.toISOStringLocal(dateObj);
        this.setDefaultValue();
    };
    FilterCriterionDateController.prototype.setDatetimeRange = function (datetimeRange) {
        var _a = datetimeRange.split('~'), fromDate = _a[0], toDate = _a[1];
        this.fromDate = new Date(fromDate);
        this.toDate = new Date(toDate);
        this.datetimeValue = this.toISOStringLocal(this.fromDate) + '~' + this.toISOStringLocal(this.toDate);
        this.setDefaultValue();
    };
    FilterCriterionDateController.prototype.togglePopover = function () {
        this.isPopoverOpen = !this.isPopoverOpen;
    };
    /**
    * Given a date object, it will return an ISO 8601 String for the date
    * in the local time zone. Use this method if you don't want to use the
    * toISOString() method that returns the date in ISO 8601 String in UTC.
    *
    * @param date - the date object
    * @returns {string} - The ISO 8601 String in the local timezone
    */
    FilterCriterionDateController.prototype.toISOStringLocal = function (date) {
        var timezone = -date.getTimezoneOffset(), dif = timezone >= 0 ? '+' : '-', pad = function (num) {
            var norm = Math.abs(Math.floor(num));
            return (norm < 10 ? '0' : '') + norm;
        };
        return date.getFullYear() +
            '-' + pad(date.getMonth() + 1) +
            '-' + pad(date.getDate()) +
            'T' + pad(date.getHours()) +
            ':' + pad(date.getMinutes()) +
            ':' + pad(date.getSeconds()) +
            dif + pad(timezone / 60) +
            ':' + pad(timezone % 60);
    };
    FilterCriterionDateController.$inject = ['$filter', '$i18next'];
    return FilterCriterionDateController;
}());
exports.default = FilterCriterionDateController;
//# sourceMappingURL=filterCriterionDate-controller.js.map