"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var filter_multiselectList_controller_1 = require("./filter-multiselectList-controller");
/**
 * This is filter multiselect list component.
 * The component provides the attributes :
 *      options: the options object that contains all the options. Each option must have an 'id','selected' property.
 *      toggleOptionCallback: callback to execute when an option is selected/deselected in multiselectList.
 */
exports.default = {
    bindings: {
        value: '<',
        options: '<',
        toggleOptionCallback: '&'
    },
    require: { frmController: '^form' },
    template: "\n        <div class=\"filter-multiselect-list\" ng-class=\"{ 'isInvalid': $ctrl.isInvalid && $ctrl.hasBeenBlurred }\" ng-click=\"$ctrl.hasBeenBlurred = true\">\n        <div class=\"d-flex align-items-center p-1 ml-4 custom-control custom-checkbox text-nowrap\" ng-repeat=\"option in $ctrl.options\">\n            <input data-netapp-id=\"filter-multiselect-list-option-checkbox\" class=\"custom-control-input p-2\"\n            type=\"checkbox\" ng-model=\"$ctrl.valueModel[option.id]\" name=\"{{option.id}}\" id=\"{{option.id}}\">\n            <label class=\"custom-control-label d-flex align-items-center\" for=\"{{option.id}}\">\n                <nwf-icon ontap-severity=\"true\" ng-if=\"option.iconClass\" icon-class=\"{{option.iconClass}}\" class=\"option-icon mr-2\"></nwf-icon>\n                <span>{{ option.label ? option.label : option.id }}</span>\n            </label>\n            </div>\n        </div>\n        <input type=\"checkbox\" nwf-form-element is-required empty-message=\"{{'nwfjs:isRequiredAtLeastOne' | i18next}}\"\n        ng-if=\"$ctrl.isInvalid\" value=\"1\" style=\"opacity:0; position: absolute; margin-top: -14px;\">\n    ",
    controller: filter_multiselectList_controller_1.default
};
//# sourceMappingURL=filter-multiselectList-component.js.map