"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MultiselectDropdownController = /** @class */ (function () {
    function MultiselectDropdownController($scope) {
        this.$scope = $scope;
        //the private data used within
        this.optionsIcon = {
            ok: {
                iconClass: 'icon-status-ok-circlecheck'
            },
            warning: {
                iconClass: 'icon-status-warning'
            },
            critical: {
                iconClass: 'icon-status-critical'
            },
            error: {
                iconClass: 'icon-status-error-full'
            },
            information: {
                iconClass: 'icon-status-info'
            }
        };
        this.anyOptionSelected = false;
        this.isInvalid = false;
        this.valDelimiter = '|';
    }
    MultiselectDropdownController.prototype.$onInit = function () {
        var _this = this;
        /* I take my value which is in string and explode it into an object for ngModel to select the right checkboxes */
        this.setOptionIcons();
        this.valueModel = this.value; //this kicks off the setter on 70.
        this.$scope.$watchCollection(function () { return _this.valueModel; }, function (newValue, oldValue) {
            var vArr = [];
            for (var i in newValue) {
                if (!newValue[i]) {
                    continue;
                }
                //I only want the ones whose value is true.
                vArr.push(i);
            }
            _this.value = vArr.join(_this.valDelimiter);
            _this.validate();
            if (newValue !== oldValue) {
                _this.toggleOptionCallback({ $value: _this.value });
            }
        });
    };
    Object.defineProperty(MultiselectDropdownController.prototype, "valueModel", {
        get: function () {
            return this._valueModel;
        },
        set: function (value) {
            var vm = {};
            if (value) {
                value.split(this.valDelimiter).forEach(function (iValue) { return vm[iValue] = true; });
            }
            this._valueModel = vm;
        },
        enumerable: true,
        configurable: true
    });
    MultiselectDropdownController.prototype.setOptionIcons = function () {
        var _this = this;
        this.options.forEach(function (option) {
            var optionLowerase = option.id.toLowerCase();
            //set iconClass. when an option is part of optionsIcon array.
            if (Object.keys(_this.optionsIcon).indexOf(optionLowerase) !== -1) {
                option.iconClass = _this.optionsIcon[optionLowerase].iconClass;
            }
        });
    };
    MultiselectDropdownController.prototype.$onChanges = function (changes) {
        if (changes.options && !changes.options.isFirstChange()) {
            //I need to intitalize my options
            this.setOptionIcons();
            //and if my options change, my value must be reset!
            this.valueModel = '';
            this.validate();
        }
    };
    MultiselectDropdownController.prototype.validate = function () {
        this.isInvalid = false;
        if (!this.value) {
            this.isInvalid = true;
        }
    };
    MultiselectDropdownController.$inject = ['$scope'];
    return MultiselectDropdownController;
}());
exports.default = MultiselectDropdownController;
//# sourceMappingURL=filter-multiselectList-controller.js.map