"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function default_1() {
    /* The options set as vars so they are used to translate the keys */
    var containsOptions = [{
            name: i18next.t('nwfjs:contains'), value: "ct"
        }, {
            name: i18next.t('nwfjs:startsWith'), value: "sw"
        }];
    var isOption = { name: i18next.t('nwfjs:is'), value: "is" };
    var booleanOptions = [
        isOption,
        { name: i18next.t('nwfjs:isNot'), value: "nis" }
    ];
    var numericOptions = [{
            name: i18next.t('nwfjs:greaterThan'), value: "gt"
        }, {
            name: i18next.t('nwfjs:lessThan'), value: "lt"
        }];
    return {
        string: {
            inputType: "text",
            options: containsOptions
        },
        associatedObjects: {
            inputType: "text",
            options: containsOptions
        },
        volumeType: {
            inputType: "select",
            options: [
                isOption
            ]
        },
        resource: {
            inputType: "text",
            options: [{
                    name: i18next.t('nwfjs:nameContains'), value: "ct"
                }, {
                    name: i18next.t('nwfjs:nameStartsWith'), value: "sw"
                }]
        },
        metric: {
            inputType: "number",
            options: numericOptions
        },
        enum: {
            inputType: "select",
            options: booleanOptions
        },
        'enum-single': {
            inputType: "select",
            options: [
                isOption
            ]
        },
        'enum-multiple': {
            inputType: "multiselect",
            options: booleanOptions
        },
        number: {
            inputType: "number",
            options: numericOptions
        },
        dateTime: {
            inputType: "dateTime",
            options: [{
                    name: i18next.t('nwfjs:inTheLast'), value: "lst"
                }, {
                    name: i18next.t('nwfjs:between'), value: "btw"
                }, {
                    name: i18next.t('nwfjs:greaterThan'), value: "gte"
                }, {
                    name: i18next.t('nwfjs:lessThan'), value: "lte"
                }]
        }
    };
}
exports.default = default_1;
;
//# sourceMappingURL=filterWidget-config.js.map