export default class FilterWidgetController {
    params: any;
    appliedFilters: any;
    model: any;
    filterParams: any;
    isPopoverOpen: boolean;
    globalReset: boolean;
    paramsCtrl: any;
    static $inject: string[];
    constructor($scope: any);
    setCriterionValue(criterion: any, value: any): void;
    setModel(newVal: any): void;
    /**
     * @description returns the current array of criterion
     * @returns {Array}
     */
    getCriteria(): any;
    /**
     * @description adds a new default criterion on click of "Add Filter" button
     */
    addCriterion(): void;
    /**
     * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param id
     */
    deleteCriterion(criterion: any): void;
    /**
     * @description deletes all the criterion.
     */
    deleteAppliedCriteria(): void;
    /**
     * @description applies the filter grid params on hitting Apply button.
     */
    apply(): void;
    /**
     * @description creates and then returns an array of comma separated criterion to be sent to filter grid params.
     * Iterates over applied Criteria since they contain all the applied criterion.
     * @returns {Array}
     */
    createFilterParams(): any[];
    /**
     * @description cancel on hitting 'Cancel' button.
     */
    cancel(): void;
    /**
     * @description  method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     * @returns {Object}
     */
    getOperatorOptions(paramType: any): any;
    /**
     * @description generates the dropdown options for operators based on property selected.
     * @param id
     */
    updateCriterion(criterion: any): void;
    /**
     * @description returns the number of the applied criteria (count for number of filters applied).
     * @returns {*}
     */
    getNumberOfAppliedFilters(): any;
}
