"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var filterWidgetTemplate = require("./filterWidget-template.html");
var filterWidget_controller_1 = require("./filterWidget-controller");
/**
 * This is the implementation of 'filterWidgetPopover' directive
 *
 * @ngdoc directive
 * @name filterWidget directive
 * @description Implementation of filterWidgetPopover directive that contains filter widget in a popover.
 * @example <nwf-grid-filter-widget params = [{}]></nwf-grid-filter-widget>
 */
var FilterWidget = /** @class */ (function () {
    function FilterWidget() {
        this.bindings = {
            params: '=',
            appliedFilters: '=?'
        };
        this.template = filterWidgetTemplate;
        this.require = { paramsCtrl: '^nwfGridParamsController' };
        this.controller = filterWidget_controller_1.default;
    }
    FilterWidget.NAME = 'nwfGridFilterWidget';
    return FilterWidget;
}());
exports.FilterWidget = FilterWidget;
//# sourceMappingURL=filterWidget-directive.js.map