/**
 * @description This is the model for the filtering widget.
 * This code contains two major arrays known as newCriteria and appliedCriteria.
 * appliedCriteria: array of criterion(filter) that finally is submitted(sent) to grid params as filter params.
 * newCriteria: array of criteria that we work with i.e.temporary array of criteria.
 * On Initial setup of filtering widget, appliedCriteria and newCriteria both are empty.
 * We add a new default criteria in newCriteria. Subsequent criteria addition and deletion happen on newCriteria array only.
 * Only on Apply(submit), newCriteria is copied into appliedCriteria.
 */
export default class FilterWidgetModel {
    params: any;
    newCriteria: any;
    appliedCriteria: any;
    counter: number;
    config: any;
    constructor(params: any);
    /**
     * @description this method adds a new default criterion
     */
    addCriterion(): void;
    /**
     * @description delete a criterion.
     * @param id
     */
    deleteCriterion(criterion: any): void;
    /**
     * @description method to delete the applied criteria (used in reset).
     */
    deleteAppliedCriteria(): void;
    /**
     * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * @param id
     */
    updateCriterion(criterion: any): void;
    /**
     * @description method to generate new criterion.
     * This method is the start point for the entire filter widget logic.
     */
    generateNewCriteria(): void;
    /**
     * @description method to return the current criterion (edit mode).
     * @returns {Array}
     */
    getCriteria(): any;
    /**
     * @description method to cancel the applied criterion.
     */
    cancel(): void;
    /**
     * @description method to Apply(submit) the new criterion.
     */
    apply(): void;
    /**
     * @description method that fetch the property from the original params passed into the widget.
     * @param id
     * @returns {*}
     */
    getProperty(id: any): any;
    /**
     * @description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     * @returns {Object}
     */
    getOperatorOptions(paramType: any): any;
    /**
     * @description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
     * This allows to preset the filterWidget this it he VALUE of the filter widget.
     * @param appliedFilters comma separted list of filter params. this should be value of gridParams.filter.
     */
    createAppliedCriteria(appliedFilters: any): void;
}
