"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @ngdoc directive
 * @name grid footer directive
 * @description This is the implementation of grid footer directive
 * This directive is part of the the grid-footer component
 * which contains selected rows count and the paginator component.
 * @param {totalRecords} number of total records to be handled by paginator.
 * @param {title} string to be shown in the paginator.
 * @param {selectedRowsCount} number of selected rows from the grid
 * @example <nwf-grid-footer total-records=22 title="Nodes" selected-rows-count=2></nwf-grid-footer>
 *
 */
var GridFooterComponent = /** @class */ (function () {
    function GridFooterComponent() {
        this.bindings = {
            totalRecords: '@',
            title: '@',
            titlePlural: '@',
            selectedRowsCount: '@?',
            offset: '=',
            usePagination: '<?',
            limit: '<'
        };
        this.transclude = true;
        this.template = "\n    <nav class=\"navbar navbar-expand-lg px-2 py-1\">\n        <div class=\"w-100\" ng-if=\"$ctrl.isSelectionEnabled\">\n            <div data-netapp-id=\"grid-footer-row-selected-count\" ng-if=\"$ctrl.selectedRowsCount !== '0'\">{{'nwfjs:gridFooterSelectedCount' | i18next: { title: $ctrl.selectedRowsCount != '1' ? $ctrl.titlePlural : $ctrl.title, count: $ctrl.selectedRowsCount } }}</div>\n        </div>\n        <div class=\"w-100\" ng-class=\"{ 'text-center': $ctrl.isSelectionEnabled }\" ng-if=\"$ctrl.usePagination\">\n            <div class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\" ng-if=\"$ctrl.hasRecords()\">\n                {{'nwfjs:paginatorShowRecords' | i18next: { pageStart: $ctrl.offset + 1, pageEnd: $ctrl.offset + $ctrl.limit > $ctrl.totalRecords ? $ctrl.totalRecords : $ctrl.offset + $ctrl.limit , totalRecords: $ctrl.totalRecords, title: $ctrl.titlePlural || $ctrl.title } }}\n            </div>\n        </div>\n        <div class=\"w-100 d-flex justify-content-end\">\n            <ng-transclude ng-if=\"!$ctrl.usePagination\"></ng-transclude>\n            <ul uib-pagination ng-if=\"$ctrl.usePagination && $ctrl.hasRecords()\" template-url=\"nwfjs/uib-pagination.html\" total-items=\"$ctrl.totalRecords\" ng-change=\"$ctrl.onChange()\" max-size=\"5\" ng-model=\"$ctrl.currentPage\" items-per-page=\"$ctrl.limit\" num-pages=\"$ctrl.numPages\" previous-text=\"{{'nwfjs:previous' | i18next }}\" next-text=\"{{'nwfjs:next' | i18next }}\" class=\"pagination\" boundary-link-numbers=\"true\"></ul>\n        </div>\n    </nav>\n    ";
        this.controller = /** @class */ (function () {
            function GridFooterController() {
                //totalRecords is bound in as a string unfortunately from old @ binding
                this.totalRecords = '0';
                this.selectedRowsCount = undefined;
                this.isSelectionEnabled = false;
                this.usePagination = true;
                //these are internal to uib-pagination, currentPage is an ngModel.
                this.numPages = 5;
                this.currentPage = 0;
                //offset is double bound, limit one way bound in.
                this.offset = 0;
                //Set the limit to 20 if not provided
                this.limit = 20;
            }
            GridFooterController.prototype.onChange = function () {
                this.offset = (this.currentPage - 1) * this.limit;
            };
            GridFooterController.prototype.hasRecords = function () {
                return parseInt(this.totalRecords) > 0;
            };
            GridFooterController.prototype.$onInit = function () {
                /* I calculate the initial page number from offset and limit */
                this.currentPage = this.offset / this.limit + 1;
                /* I have a contract, if someone doesn't set my selectedRowsCount, they must not utilize the nwf-selection widget.
                   I set my hasSelection to false, because it is a safe assumption that I will never dynamically add the widget after birth.
                   This is so I can layout the three column or two column footer (in cases of Peformance Explorer) or where I don't have selection
                   */
                if (this.selectedRowsCount !== undefined) {
                    this.isSelectionEnabled = true;
                }
            };
            GridFooterController.prototype.$onChanges = function (changes) {
                // this checks to see if we have changed from a legit count (after a fetch) to something else (our record count has really changed )
                // we are initially set to -1, before the async fetch.
                if (changes.totalRecords && !changes.totalRecords.isFirstChange() && changes.totalRecords.previousValue !== '-1') {
                    //our record count has changed (filter or search, or timerange) so we automatically go back to page1.
                    this.currentPage = 1;
                }
            };
            return GridFooterController;
        }());
    }
    GridFooterComponent.NAME = 'nwfGridFooter';
    return GridFooterComponent;
}());
exports.GridFooterComponent = GridFooterComponent;
//# sourceMappingURL=gridFooter-component.js.map