"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var SearchController = /** @class */ (function () {
    function SearchController($scope, $element, $i18next) {
        this.$scope = $scope;
        this.$element = $element;
        this.$i18next = $i18next;
    }
    SearchController.prototype.$onInit = function () {
        var _this = this;
        // I add this class so I can specify the target and avoid collisions on the global.
        this.$element.addClass('nwfjs-angularjs');
        var placeholderText = this.$i18next.t("nwfjs:searchPlaceholderText", { type: this.type });
        this.$element.find('.grid-search-input').attr('placeholder', placeholderText);
        this.$scope.$watch(function () { return _this.searchVal; }, function (newVal, oldVal) {
            //if newVal exists, or oldVal exist and newVal!=oldVal, then only we set the q parameter.
            if ((newVal || oldVal) && (newVal !== oldVal)) {
                _this.setMyValue();
            }
        });
    };
    SearchController.prototype.$onChanges = function (changesObj) {
        // I take the searchValue bound in and set it on my old searchVal
        this.searchVal = changesObj.searchValue.currentValue;
    };
    SearchController.prototype.setMyValue = function () {
        //When doing a search, I reset the offset back to zero.
        this.paramsCtrl.params.q = this.searchVal || null;
        this.paramsCtrl.params.offset = 0;
    };
    /* Simple reset */
    SearchController.prototype.resetInput = function () {
        this.searchVal = '';
        this.setMyValue();
    };
    SearchController.$inject = ['$scope', '$element', '$i18next'];
    return SearchController;
}());
exports.default = SearchController;
//# sourceMappingURL=search-controller.js.map