"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var grid_rowSelectionMethod_1 = require("../../grid-rowSelectionMethod");
var SelectionController = /** @class */ (function () {
    function SelectionController($scope, $timeout, $i18next) {
        var _this = this;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$i18next = $i18next;
        //setting item name.
        this.itemName = this.itemName || $i18next.t("nwfjs:items");
        $scope.$watch(function () { return _this.selectedItems; }, function (newVal, oldVal) {
            // if all items are selected, we update sessionStorage with all newIds.
            if (_this.areAllItemsSelected) {
                //We clear the sessionStorage in case any selectedItems are stored in it.
                _this.clearSelectionsFromStorage();
                //Set sessionStorage with all the fetched IDs.
                _this.setSelectedObjects(newVal);
            }
            //if gridApi exists and if allSelectState is set to False
            //This case happens when we cherry pick certain items from selectAll cases.
            //Then we need to make this flag to false, as some items are cherry-picked from selectAll case.
            if (_this.gridApi && !_this.gridApi.selection.getSelectAllState()) {
                //We make areAllItemsSelected set to false.
                _this.areAllItemsSelected = false;
            }
            //we only update sessionStorage, if newVal or oldVal already exists.
            if ((newVal.length > 0) || (oldVal.length > 0)) {
                //Updating items in sessionStorage.
                _this.setSelectedObjects(newVal);
            }
        }, true);
        $scope.$on('newDataFetched', function (evt, gridData) {
            //On every new data fetch we check for two things:
            //1) We check if a row's ID of new data exists in selectedItems. If it does exist, we select that row.
            //2) If row's ID does NOT exist in selectedItem, we check if areAllItemSelected flag = true which means we want to select complete set.
            // This means we select all the newly fetched data rows from the response.
            var selectedItems = _this.getSelectedObjects();
            if (selectedItems && selectedItems.length > 0) {
                //Looping over new data response.
                gridData.forEach(function (rowData) {
                    // Finding the index of new data row from selectedItems.
                    var index;
                    //If we have array of objects stored in selectedItems (we check this by finding out type of first value in selectedItems), we send the entire 'data' object one-by-one into findItemById.
                    //Else, we have non-object type items stored in selectedItems, we send that uniqueKeys key from data object one-by-one into findItemById.
                    if (typeof selectedItems[0] === 'object') {
                        index = grid_rowSelectionMethod_1.findIndexOfItem(selectedItems, rowData, _this.uniqueKey);
                    }
                    else {
                        index = grid_rowSelectionMethod_1.findIndexOfItem(selectedItems, rowData[_this.uniqueKey], _this.uniqueKey);
                    }
                    //1)
                    if (index != -1) {
                        $timeout(function () {
                            _this.gridApi.selection.selectRow(rowData);
                        });
                    }
                    //2)
                    else {
                        if (_this.areAllItemsSelected)
                            $timeout(function () {
                                _this.gridApi.selection.selectRow(rowData);
                            });
                    }
                });
            }
        });
    }
    /**removeSelectionOnCurrentPage
     * @ngdoc function
     * @name selectAllOnCurrentPage
     * @description method to select all rows displayed on current page.
     */
    SelectionController.prototype.selectAllOnCurrentPage = function () {
        //setting allObjects to false, in case its true.
        this.areAllItemsSelected = false;
        //selecting all the rows on the current page.
        this.gridApi.selection.selectAllVisibleRows();
        // Store a string representation of object ID(s)
        this.setSelectedObjects(this.selectedItems);
    };
    /**
     * @ngdoc function
     * @ngdoc function
     * @name selectCompleteSet
     * @description method to select the complete set of records.
     */
    SelectionController.prototype.selectCompleteSet = function () {
        //setting allObjects to true.
        this.areAllItemsSelected = true;
        //emitting the event, that will be listened in page controller, which in turn fetches all the IDs and pushes the fetched IDs into objectIDs array.
        this.$scope.$emit('fetchAllItems');
        //making all rows display as selected.
        this.gridApi.selection.selectAllVisibleRows();
    };
    /**
     * @ngdoc function
     * @name removeSelections
     * @description method to De-Select the selections made.
     */
    SelectionController.prototype.deselectCompleteSet = function () {
        //setting objectIDs array to zero.
        this.selectedItems.length = 0;
        //making all the rows de-selected.
        this.gridApi.selection.clearSelectedRows();
        //setting allObjects to false, in case its true.
        this.areAllItemsSelected = false;
        //removing selected objects from sessionStorage.
        this.clearSelectionsFromStorage();
    };
    SelectionController.prototype.setSelectedObjects = function (selectedItems) {
        // Store a string representation of object ID(s)
        window.sessionStorage && window.sessionStorage.setItem('selectedItems', JSON.stringify(selectedItems));
    };
    SelectionController.prototype.getSelectedObjects = function () {
        // Returns an array of object ids
        return window.sessionStorage ? JSON.parse(window.sessionStorage.getItem('selectedItems')) : [];
    };
    SelectionController.prototype.clearSelectionsFromStorage = function () {
        window.sessionStorage.removeItem('selectedItems');
    };
    SelectionController.$inject = ['$scope', '$timeout', '$i18next'];
    return SelectionController;
}());
exports.SelectionController = SelectionController;
//# sourceMappingURL=selection-controller.js.map