"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UiGridSortMethod = function (sortColumns, gridParams) {
    var name, direction;
    // checking if gridParams does have an already sorted column.
    if (gridParams.sort) {
        //finding the previously sorted column from sort parameter in grid params.
        //splitting the value of sort parameter in grid params at '~'.
        var lastSortedColumnName = gridParams.sort.split('~')[0];
        // if sortColumns have more than one column definition.
        if (sortColumns.length > 1) {
            // we iterate over the sortColumns array.
            for (var _i = 0, sortColumns_1 = sortColumns; _i < sortColumns_1.length; _i++) {
                var col = sortColumns_1[_i];
                // we look for the column which has the same name as last sorted column.
                // and reset the sort on the last sorted column.
                if (col.name === lastSortedColumnName) {
                    col.sort = {};
                } // else, we don't have any column previously sorted, so we set the sort and col name.
                else {
                    name = col.name;
                    direction = findDirection(col.sort.direction);
                }
            }
            ;
        } // we don't have any previously sorted column, so sortColumns will return the just one column definition.
        // length of sortColumns is one.
        else {
            name = lastSortedColumnName;
            direction = findDirection(sortColumns[0].sort.direction);
        }
    }
    // if no column is sorted when we land on page.
    else {
        // we don't have any previously sorted column, so sortColumns will return the just one column definition.
        // length of sortColumns is one.
        name = sortColumns[0].name;
        direction = findDirection(sortColumns[0].sort.direction);
    }
    //setting the new value to the grid sort directive so that grid param controller can fire an event and hence new data can be fetched.
    gridParams.sort = name + '~' + direction;
    //making offset back to 0 since sort order has changed(resetting the paginator)
    gridParams.offset = 0;
    // setting the direction as required by REST API
    function findDirection(direction) {
        if (direction === 'desc') {
            return 'dsc';
        }
        else {
            return direction;
        }
    }
};
//# sourceMappingURL=grid-sortMethod.js.map