"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var icons_1 = require("@netapp/nwfjs_theme/icons/icons");
var NwfIconController = /** @class */ (function () {
    function NwfIconController($sce, $element) {
        this.$sce = $sce;
        this.$element = $element;
        //private
        this.hasLoggedDep = false;
        this.ontapSeverityCls = '';
    }
    NwfIconController.prototype.$onChanges = function (changes) {
        var ontapSeverity = changes.ontapSeverity;
        if (ontapSeverity) {
            this.ontapSeverityCls = 'ontap-severity';
        }
        var iconClass = changes.iconClass && changes.iconClass.currentValue;
        var prefix = NwfIconController.svgPrefix;
        if (iconClass && iconClass.lastIndexOf(prefix, 0) === 0) {
            iconClass = iconClass.replace(prefix, '');
        }
        if (iconClass) {
            this.iconClass = iconClass;
            this.svgContent = this.getSvgContent();
        }
    };
    NwfIconController.prototype.getSvgContent = function () {
        //this converts the kabob-string to camelCase
        var iconKey = this.iconClass;
        /* this one is special, I load via css */
        if (iconKey == 'iconInfoLoader') {
            return '';
        }
        //first check the status of this name 
        if (!this.hasLoggedDep) {
            //now actually deliver
            if (!(iconKey in icons_1.icons)) {
                console.error("You tried to load <nwf-icon icon-class=\"" + this.iconClass + "\"> but it has been deprecated.");
            }
            this.hasLoggedDep = true;
        }
        return this.$sce.trustAsHtml(icons_1.icons[iconKey]);
    };
    //statics
    NwfIconController.svgPrefix = 'svg-';
    NwfIconController.$inject = ['$sce', '$element'];
    return NwfIconController;
}());
exports.default = NwfIconController;
//# sourceMappingURL=icon-controller.js.map