"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var angular = require("angular");
var nwfHelp_module_1 = require("./help/nwfHelp-module");
var icon_component_1 = require("./icon/icon-component");
var loadingIndicator_component_1 = require("./loading-indicator/loadingIndicator-component");
var nwfPageAlert_component_1 = require("./page-alert/nwfPageAlert.component");
var nwfPageAlert_service_1 = require("./page-alert/nwfPageAlert.service");
var shell_module_1 = require("./shell/shell-module");
var form_module_1 = require("./form/form-module");
var nwfConfig_provider_1 = require("./nwfConfig-provider");
var elipsizer_directive_1 = require("./elipsizer/elipsizer-directive");
var progressIndicator_component_1 = require("./progress-indicator/progressIndicator-component");
var datepicker = require("angular-ui-bootstrap/src/datepicker/index-nocss");
var timepicker = require("angular-ui-bootstrap/src/timepicker/index-nocss");
var datetimeRangePicker_component_1 = require("./datetime-range-picker/datetimeRangePicker-component");
var featureHighlight_component_1 = require("./feature-highlight/featureHighlight-component");
var featureHighlight_service_1 = require("./feature-highlight/featureHighlight-service");
var NwfComponentsModule = /** @class */ (function () {
    function NwfComponentsModule() {
        this.initModules();
        this.native = angular.module(NwfComponentsModule.NAME, NwfComponentsModule.DEPENDENCIES);
        this.native.provider('nwfConfig', nwfConfig_provider_1.default);
        this.native.component(icon_component_1.default.NAME, new icon_component_1.default());
        this.native.component(loadingIndicator_component_1.default.NAME, new loadingIndicator_component_1.default());
        this.native.component(nwfPageAlert_component_1.default.NAME, new nwfPageAlert_component_1.default());
        this.native.service(nwfPageAlert_service_1.default.NAME, nwfPageAlert_service_1.default);
        this.native.component(progressIndicator_component_1.default.NAME, new progressIndicator_component_1.default());
        this.native.directive('nwfElipsizeContents', elipsizer_directive_1.default);
        this.native.component(datetimeRangePicker_component_1.default.NAME, new datetimeRangePicker_component_1.default());
        this.native.component(featureHighlight_component_1.default.NAME, new featureHighlight_component_1.default());
        this.native.service('nwfFeatureHighlightService', featureHighlight_service_1.default);
        /* i18next  format filter */
        this.native.filter('i18nextFormat', ['$i18next', function ($i18next) {
                return function (key, formatType) {
                    return $i18next.i18n.format(key, formatType);
                };
            }]);
    }
    NwfComponentsModule.prototype.initModules = function () {
        new shell_module_1.default();
        new form_module_1.default();
        new nwfHelp_module_1.default();
    };
    NwfComponentsModule.NAME = 'nwfComponentsModule';
    NwfComponentsModule.DEPENDENCIES = [
        shell_module_1.default.NAME,
        form_module_1.default.NAME,
        nwfHelp_module_1.default.NAME,
        datepicker,
        timepicker
    ];
    return NwfComponentsModule;
}());
exports.default = NwfComponentsModule;
__export(require("./ngLocales"));
//# sourceMappingURL=index.js.map