"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var progressIndicator_controller_1 = require("./progressIndicator-controller");
var ProgressIndicatorComponent = /** @class */ (function () {
    function ProgressIndicatorComponent() {
        this.template = "<ul class=\"progress-indicator nwf-progress-indicator\">\n        <li ng-repeat=\"step in $ctrl.stepData\" ng-class=\"{'active': step.isCurrent, 'completed': step.isComplete }\">\n            <span class=\"bubble\">\n            <nwf-icon ng-if=\"step.isComplete\" icon-class=\"icon-status-ok-circlecheck\"></nwf-icon>\n            <span class=\"nwf-progress-indicator-step-num\" ng-if=\"!step.isComplete\">{{$index + 1}}</span>\n            </span>\n            <span class=\"nwf-progress-indicator-step-label\">{{step.label}}</span>\n        </li>\n    </ul>";
        this.controller = progressIndicator_controller_1.default;
        this.bindings = {
            steps: '<',
            currentStepName: '@'
        };
    }
    ProgressIndicatorComponent.NAME = 'nwfProgressIndicator';
    return ProgressIndicatorComponent;
}());
exports.default = ProgressIndicatorComponent;
//# sourceMappingURL=progressIndicator-component.js.map