"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ProgressIndicatorCtrl = /** @class */ (function () {
    function ProgressIndicatorCtrl() {
    }
    ProgressIndicatorCtrl.prototype.currentStepIdx = function () {
        var i = 0;
        for (var i_1 = 0; i_1 < this.steps.length; i_1++) {
            var step = this.steps[i_1];
            if (step.name == this.currentStepName) {
                return i_1;
            }
        }
        return -1;
    };
    ProgressIndicatorCtrl.prototype.updateStepDataByCurrentStepIdx = function (idx) {
        var stepData = [];
        for (var i = 0; i < this.steps.length; i++) {
            var step = this.steps[i];
            var isStepComplete = (i < idx || step.isComplete);
            var isStepCurrent = (i == idx && !isStepComplete);
            step.isCurrent = isStepCurrent;
            step.isComplete = isStepComplete;
            stepData[i] = step;
        }
        this.stepData = stepData;
    };
    ProgressIndicatorCtrl.prototype.updateStepData = function () {
        var idx = this.currentStepIdx();
        if (idx >= 0) {
            this.updateStepDataByCurrentStepIdx(idx);
        }
        else {
            this.updateStepDataByCurrentStepIdx(0);
            console.log("currentStepName:" + this.currentStepName + " is not in steps array.");
        }
    };
    ProgressIndicatorCtrl.prototype.$onChanges = function () {
        this.updateStepData();
    };
    return ProgressIndicatorCtrl;
}());
exports.default = ProgressIndicatorCtrl;
//# sourceMappingURL=progressIndicator-controller.js.map