"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ng = require("angular");
var LeftNavController = /** @class */ (function () {
    function LeftNavController($rootScope) {
        this.$rootScope = $rootScope;
        this.isNavMinimized = false;
    }
    LeftNavController.prototype.$onInit = function () {
        /* Set my initial state */
        if (!this.isNavMinimized) {
            this.showOrHideNav(true);
        }
    };
    LeftNavController.prototype.toggleNav = function () {
        var showMe = this.isNavMinimized = !this.isNavMinimized;
        if (!showMe) {
            this.showOrHideNav(true);
        }
        else {
            this.showOrHideNav(false);
        }
    };
    LeftNavController.prototype.onItemMouseEnter = function ($evt) {
        if (this.isNavMinimized) {
            this.showOrHideNav(true);
        }
    };
    LeftNavController.prototype.showOrHideNav = function (showOrHide) {
        var _this = this;
        this.isNavMinimized = !showOrHide;
        var body = ng.element('body');
        var navActive = 'nav-is-active';
        if (showOrHide === true) {
            body.addClass(navActive);
        }
        else {
            /* hide the leftnav (full width) */
            body.removeClass(navActive);
        }
        setTimeout(function () { return _this.$rootScope.$broadcast('leftNav-resize'); }, 310);
    };
    LeftNavController.$inject = ['$rootScope'];
    return LeftNavController;
}());
exports.default = LeftNavController;
//# sourceMappingURL=leftnav-controller.js.map