"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ng = require("angular");
var NwfLeftNavItem = /** @class */ (function () {
    function NwfLeftNavItem() {
        this.restrict = 'A';
        this.template = "\n        <script type=\"text/ng-template\" id=\"leftnav-component-link-contents\">\n                <span ng-if=\"$ctrl.item.icon\" class=\"nwf-leftnav-item-icon\">\n                <nwf-icon icon-class=\"{{$ctrl.item.icon}}\"></nwf-icon>\n                </span>\n                <span class=\"nwf-leftnav-item-label\">\n                {{$ctrl.item.label}}\n                </span>\n                <span ng-if=\"$ctrl.item.children.length\" class=\"nwf-leftnav-item-toggle\" ng-class=\"{ 'is-collapsed': $ctrl.isCollapsed }\"></span>\n        </script>\n\n      \n\n        <!-- if no children and normal sref state -->\n        <a ng-if=\"!$ctrl.item.children.length && !$ctrl.iFrameSrc\" class=\"nwf-leftnav-item-link\" ng-click=\"$ctrl.hideIframe()\" ui-sref=\"{{$ctrl.item.sref}}\" ui-sref-opts=\"{ inherit: false }\" \n            data-netapp-id=\"leftnav-item-{{$ctrl.item.label | lowercase}}-link\" ng-include src=\"'leftnav-component-link-contents'\">\n        </a>\n\n        <!-- if no children and iframer state -->\n        <a ng-if=\"!$ctrl.item.children.length && $ctrl.iFrameSrc\" class=\"nwf-leftnav-item-link\" ng-click=\"$ctrl.goToIframeHref()\" ui-sref=\"{{$ctrl.item.sref}}\" ui-sref-opts=\"{ inherit: false }\" \n           data-netapp-id=\"leftnav-item-{{$ctrl.item.label | lowercase}}-link\" ng-include src=\"'leftnav-component-link-contents'\">\n        </a>\n\n  \n\n        <!-- if I have children -->\n        <a ng-if=\"$ctrl.item.children.length\" class=\"nwf-leftnav-item-link\" ng-include src=\"'leftnav-component-link-contents'\" ng-click=\"$ctrl.isCollapsed = !$ctrl.isCollapsed\" data-netapp-id=\"leftnav-item-{{$ctrl.item.label | lowercase}}-link\">\n        </a>\n        \n        <nwf-feature-highlight ng-if=\"$ctrl.item.highlightComponent\" group=\"leftnav\" component=\"{{$ctrl.item.highlightComponent}}\" is-showing=\"$ctrl.item.highlightComponentIsShowing\" placement=\"{{$ctrl.item.highlightComponentPosition || 'right-bottom'}}\">\n        </nwf-feature-highlight> \n\n\n\n        <ul ng-if=\"$ctrl.item.children.length\" class=\"nwf-leftnav-items\" uib-collapse=\"$ctrl.isCollapsed\" data-netapp-id=\"leftnav-item-group-{{$ctrl.item.label | lowercase}}\">\n            <li nwf-left-nav-item item=\"item\" class=\"nwf-leftnav-item\" ng-repeat=\"item in $ctrl.item.children\" data-netapp-id=\"leftnav-item-{{item.label | lowercase}}\"></li>\n        </ul>\n        \n        \n     \n\n        ";
        this.controller = ['$scope', '$state', function ($scope, $state) {
                this.parseStateRef = function (ref) {
                    var paramsOnly = ref.match(/^\s*({[^}]*})\s*$/), parsed;
                    if (paramsOnly)
                        ref = '(' + paramsOnly[1] + ')';
                    parsed = ref.replace(/\n/g, " ").match(/^\s*([^(]*?)\s*(\((.*)\))?\s*$/);
                    if (!parsed || parsed.length !== 4)
                        throw new Error("Invalid state ref '" + ref + "'");
                    return { state: parsed[1] || null, paramExpr: parsed[3] || null };
                };
                this.$onInit = function () {
                    this.isCollapsed = true;
                    /* Now I determine if the item I am rendering has an iFrameSrc associated with this state name and if so, get it so I can set it later in the template
                    This should facilitate the desired behavior of "resetting" the state to the original nav item EVEN if the internal iframes src has changed (navigated down deeper)
                    */
                    /* Some leftnav items arent links, they are groups (folders) no need to continue */
                    this.iFrameSrc = null;
                    if (!this.item.sref) {
                        return;
                    }
                    /* This sets whether or not I am an Iframe Route */
                    var sref = this.item.sref;
                    var ref, params;
                    if (sref) {
                        ref = this.parseStateRef(sref);
                    }
                    if (ref) {
                        params = ng.copy($scope.$eval(ref.paramExpr));
                    }
                    /* Now I get the state from the service based on the name, and  params I parse from the sref in the config, assigning whether
                        or not I am an Iframe
                     */
                    var stateDef = $state.get(ref.state, params);
                    if (stateDef && stateDef.data && stateDef.data.iFrameSrc) {
                        var iFrameFromState = stateDef.data.iFrameSrc;
                        var iFrameSrc = '';
                        if (ng.isFunction(iFrameFromState)) {
                            if (!params) {
                                params = {};
                            }
                            iFrameSrc = iFrameFromState(params);
                        }
                        else {
                            iFrameSrc = iFrameFromState;
                        }
                        this.iFrameSrc = iFrameSrc;
                    }
                };
                this.goToIframeHref = function () {
                    if (this.iFrameSrc) {
                        $scope.$emit('iframer.show', this.iFrameSrc);
                    }
                    else {
                        console.error("I am trying to go to an href but don't have one");
                    }
                };
                this.hideIframe = function () {
                    $scope.$emit('iframer.hide');
                };
            }];
        this.controllerAs = '$ctrl';
        this.bindToController = {
            item: '<'
        };
    }
    NwfLeftNavItem.NAME = 'nwfLeftNavItem';
    return NwfLeftNavItem;
}());
exports.default = NwfLeftNavItem;
//# sourceMappingURL=leftnavItem-component.js.map