import { filter } from 'rxjs/operators';
import { flattenArgs } from '../utils/utilities';
export function ofEntityOp() {
    var allowedEntityOps = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        allowedEntityOps[_i] = arguments[_i];
    }
    var ops = flattenArgs(allowedEntityOps);
    switch (ops.length) {
        case 0:
            return filter(function (action) {
                return action.payload && action.payload.entityOp != null;
            });
        case 1:
            var op_1 = ops[0];
            return filter(function (action) {
                return action.payload && op_1 === action.payload.entityOp;
            });
        default:
            return filter(function (action) {
                var entityOp = action.payload && action.payload.entityOp;
                return entityOp && ops.some(function (o) { return o === entityOp; });
            });
    }
}
export function ofEntityType() {
    var allowedEntityNames = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        allowedEntityNames[_i] = arguments[_i];
    }
    var names = flattenArgs(allowedEntityNames);
    switch (names.length) {
        case 0:
            return filter(function (action) {
                return action.payload && action.payload.entityName != null;
            });
        case 1:
            var name_1 = names[0];
            return filter(function (action) {
                return action.payload && name_1 === action.payload.entityName;
            });
        default:
            return filter(function (action) {
                var entityName = action.payload && action.payload.entityName;
                return !!entityName && names.some(function (n) { return n === entityName; });
            });
    }
}
//# sourceMappingURL=data:application/json;base64,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