import { InjectionToken, Optional } from '@angular/core';
import { createFeatureSelector } from '@ngrx/store';
import { ENTITY_CACHE_NAME, ENTITY_CACHE_NAME_TOKEN, } from '../reducers/constants';
export var ENTITY_CACHE_SELECTOR_TOKEN = new InjectionToken('@ngrx/data/entity-cache-selector');
export var entityCacheSelectorProvider = {
    provide: ENTITY_CACHE_SELECTOR_TOKEN,
    useFactory: createEntityCacheSelector,
    deps: [[new Optional(), ENTITY_CACHE_NAME_TOKEN]],
};
export function createEntityCacheSelector(entityCacheName) {
    entityCacheName = entityCacheName || ENTITY_CACHE_NAME;
    return createFeatureSelector(entityCacheName);
}
//# sourceMappingURL=data:application/json;base64,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