import * as tslib_1 from "tslib";
import { Inject, Injectable, Optional } from '@angular/core';
import { createSelector } from '@ngrx/store';
import { ENTITY_CACHE_SELECTOR_TOKEN, createEntityCacheSelector, } from './entity-cache-selector';
import { ENTITY_CACHE_NAME } from '../reducers/constants';
import { EntityCollectionCreator } from '../reducers/entity-collection-creator';
/** Creates EntitySelector functions for entity collections. */
var EntitySelectorsFactory = /** @class */ (function () {
    function EntitySelectorsFactory(entityCollectionCreator, selectEntityCache) {
        this.entityCollectionCreator =
            entityCollectionCreator || new EntityCollectionCreator();
        this.selectEntityCache =
            selectEntityCache || createEntityCacheSelector(ENTITY_CACHE_NAME);
    }
    /**
     * Create the NgRx selector from the store root to the named collection,
     * e.g. from Object to Heroes.
     * @param entityName the name of the collection
     */
    EntitySelectorsFactory.prototype.createCollectionSelector = function (entityName) {
        var _this = this;
        var getCollection = function (cache) {
            if (cache === void 0) { cache = {}; }
            return ((cache[entityName] ||
                _this.entityCollectionCreator.create(entityName)));
        };
        return createSelector(this.selectEntityCache, getCollection);
    };
    // createCollectionSelectors implementation
    EntitySelectorsFactory.prototype.createCollectionSelectors = function (metadataOrName) {
        var metadata = typeof metadataOrName === 'string'
            ? { entityName: metadataOrName }
            : metadataOrName;
        var selectKeys = function (c) { return c.ids; };
        var selectEntityMap = function (c) { return c.entities; };
        var selectEntities = createSelector(selectKeys, selectEntityMap, function (keys, entities) {
            return keys.map(function (key) { return entities[key]; });
        });
        var selectCount = createSelector(selectKeys, function (keys) { return keys.length; });
        // EntityCollection selectors that go beyond the ngrx/entity/EntityState selectors
        var selectFilter = function (c) { return c.filter; };
        var filterFn = metadata.filterFn;
        var selectFilteredEntities = filterFn
            ? createSelector(selectEntities, selectFilter, function (entities, pattern) { return filterFn(entities, pattern); })
            : selectEntities;
        var selectLoaded = function (c) { return c.loaded; };
        var selectLoading = function (c) { return c.loading; };
        var selectChangeState = function (c) { return c.changeState; };
        // Create collection selectors for each `additionalCollectionState` property.
        // These all extend from `selectCollection`
        var extra = metadata.additionalCollectionState || {};
        var extraSelectors = {};
        Object.keys(extra).forEach(function (k) {
            extraSelectors['select' + k[0].toUpperCase() + k.slice(1)] = function (c) { return c[k]; };
        });
        return tslib_1.__assign({ selectCount: selectCount,
            selectEntities: selectEntities,
            selectEntityMap: selectEntityMap,
            selectFilter: selectFilter,
            selectFilteredEntities: selectFilteredEntities,
            selectKeys: selectKeys,
            selectLoaded: selectLoaded,
            selectLoading: selectLoading,
            selectChangeState: selectChangeState }, extraSelectors);
    };
    // createCollectionSelectors implementation
    EntitySelectorsFactory.prototype.create = function (metadataOrName) {
        var metadata = typeof metadataOrName === 'string'
            ? { entityName: metadataOrName }
            : metadataOrName;
        var entityName = metadata.entityName;
        var selectCollection = this.createCollectionSelector(entityName);
        var collectionSelectors = this.createCollectionSelectors(metadata);
        var entitySelectors = {};
        Object.keys(collectionSelectors).forEach(function (k) {
            entitySelectors[k] = createSelector(selectCollection, collectionSelectors[k]);
        });
        return tslib_1.__assign({ entityName: entityName,
            selectCollection: selectCollection, selectEntityCache: this.selectEntityCache }, entitySelectors);
    };
    EntitySelectorsFactory = tslib_1.__decorate([
        Injectable(),
        tslib_1.__param(0, Optional()),
        tslib_1.__param(1, Optional()),
        tslib_1.__param(1, Inject(ENTITY_CACHE_SELECTOR_TOKEN)),
        tslib_1.__metadata("design:paramtypes", [EntityCollectionCreator, Function])
    ], EntitySelectorsFactory);
    return EntitySelectorsFactory;
}());
export { EntitySelectorsFactory };
//# sourceMappingURL=data:application/json;base64,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