import * as tslib_1 from "tslib";
import { NgModule, Inject, Optional } from '@angular/core';
import { createAction, Store, StoreRootModule, StoreFeatureModule, } from '@ngrx/store';
import { EffectsRunner } from './effects_runner';
import { EffectSources } from './effect_sources';
import { ROOT_EFFECTS, _ROOT_EFFECTS_GUARD } from './tokens';
export var ROOT_EFFECTS_INIT = '@ngrx/effects/init';
export var rootEffectsInit = createAction(ROOT_EFFECTS_INIT);
var EffectsRootModule = /** @class */ (function () {
    function EffectsRootModule(sources, runner, store, rootEffects, storeRootModule, storeFeatureModule, guard) {
        this.sources = sources;
        runner.start();
        rootEffects.forEach(function (effectSourceInstance) {
            return sources.addEffects(effectSourceInstance);
        });
        store.dispatch({ type: ROOT_EFFECTS_INIT });
    }
    EffectsRootModule.prototype.addEffects = function (effectSourceInstance) {
        this.sources.addEffects(effectSourceInstance);
    };
    EffectsRootModule = tslib_1.__decorate([
        NgModule({}),
        tslib_1.__param(3, Inject(ROOT_EFFECTS)),
        tslib_1.__param(4, Optional()),
        tslib_1.__param(5, Optional()),
        tslib_1.__param(6, Optional()),
        tslib_1.__param(6, Inject(_ROOT_EFFECTS_GUARD)),
        tslib_1.__metadata("design:paramtypes", [EffectSources,
            EffectsRunner,
            Store, Array, StoreRootModule,
            StoreFeatureModule, Object])
    ], EffectsRootModule);
    return EffectsRootModule;
}());
export { EffectsRootModule };
//# sourceMappingURL=data:application/json;base64,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