/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { createAction, props } from '@ngrx/store';
/**
 * An action dispatched when a router navigation request is fired.
 * @type {?}
 */
export const ROUTER_REQUEST = '@ngrx/router-store/request';
/** @type {?} */
export const routerRequestAction = createAction(ROUTER_REQUEST, props());
/**
 * An action dispatched when the router navigates.
 * @type {?}
 */
export const ROUTER_NAVIGATION = '@ngrx/router-store/navigation';
/** @type {?} */
export const routerNavigationAction = createAction(ROUTER_NAVIGATION, props());
/**
 * An action dispatched when the router cancels navigation.
 * @type {?}
 */
export const ROUTER_CANCEL = '@ngrx/router-store/cancel';
/** @type {?} */
export const routerCancelAction = createAction(ROUTER_CANCEL, props());
/**
 * An action dispatched when the router errors.
 * @type {?}
 */
export const ROUTER_ERROR = '@ngrx/router-store/error';
/** @type {?} */
export const routerErrorAction = createAction(ROUTER_ERROR, props());
/**
 * An action dispatched after navigation has ended and new route is active.
 * @type {?}
 */
export const ROUTER_NAVIGATED = '@ngrx/router-store/navigated';
/** @type {?} */
export const routerNavigatedAction = createAction(ROUTER_NAVIGATED, props());
//# sourceMappingURL=data:application/json;base64,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