/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Inject, Injectable, InjectionToken } from '@angular/core';
import { UPDATE } from '@ngrx/store';
import { empty, Observable, of } from 'rxjs';
import { catchError, concatMap, debounceTime, filter, map, share, switchMap, take, takeUntil, timeout, } from 'rxjs/operators';
import { IMPORT_STATE, PERFORM_ACTION } from './actions';
import { STORE_DEVTOOLS_CONFIG, StoreDevtoolsConfig, } from './config';
import { DevtoolsDispatcher } from './devtools-dispatcher';
import { isActionFiltered, sanitizeAction, sanitizeActions, sanitizeState, sanitizeStates, shouldFilterActions, unliftState, } from './utils';
/** @type {?} */
export const ExtensionActionTypes = {
    START: 'START',
    DISPATCH: 'DISPATCH',
    STOP: 'STOP',
    ACTION: 'ACTION',
};
/** @type {?} */
export const REDUX_DEVTOOLS_EXTENSION = new InjectionToken('Redux Devtools Extension');
/**
 * @record
 */
export function ReduxDevtoolsExtensionConnection() { }
if (false) {
    /**
     * @param {?} listener
     * @return {?}
     */
    ReduxDevtoolsExtensionConnection.prototype.subscribe = function (listener) { };
    /**
     * @return {?}
     */
    ReduxDevtoolsExtensionConnection.prototype.unsubscribe = function () { };
    /**
     * @param {?} action
     * @param {?} state
     * @return {?}
     */
    ReduxDevtoolsExtensionConnection.prototype.send = function (action, state) { };
    /**
     * @param {?=} state
     * @return {?}
     */
    ReduxDevtoolsExtensionConnection.prototype.init = function (state) { };
    /**
     * @param {?} anyErr
     * @return {?}
     */
    ReduxDevtoolsExtensionConnection.prototype.error = function (anyErr) { };
}
/**
 * @record
 */
export function ReduxDevtoolsExtensionConfig() { }
if (false) {
    /** @type {?|undefined} */
    ReduxDevtoolsExtensionConfig.prototype.features;
    /** @type {?} */
    ReduxDevtoolsExtensionConfig.prototype.name;
    /** @type {?|undefined} */
    ReduxDevtoolsExtensionConfig.prototype.maxAge;
    /** @type {?|undefined} */
    ReduxDevtoolsExtensionConfig.prototype.serialize;
}
/**
 * @record
 */
export function ReduxDevtoolsExtension() { }
if (false) {
    /**
     * @param {?} options
     * @return {?}
     */
    ReduxDevtoolsExtension.prototype.connect = function (options) { };
    /**
     * @param {?} action
     * @param {?} state
     * @param {?} options
     * @return {?}
     */
    ReduxDevtoolsExtension.prototype.send = function (action, state, options) { };
}
export class DevtoolsExtension {
    /**
     * @param {?} devtoolsExtension
     * @param {?} config
     * @param {?} dispatcher
     */
    constructor(devtoolsExtension, config, dispatcher) {
        this.config = config;
        this.dispatcher = dispatcher;
        this.devtoolsExtension = devtoolsExtension;
        this.createActionStreams();
    }
    /**
     * @param {?} action
     * @param {?} state
     * @return {?}
     */
    notify(action, state) {
        if (!this.devtoolsExtension) {
            return;
        }
        // Check to see if the action requires a full update of the liftedState.
        // If it is a simple action generated by the user's app and the recording
        // is not locked/paused, only send the action and the current state (fast).
        //
        // A full liftedState update (slow: serializes the entire liftedState) is
        // only required when:
        //   a) redux-devtools-extension fires the @@Init action (ignored by
        //      @ngrx/store-devtools)
        //   b) an action is generated by an @ngrx module (e.g. @ngrx/effects/init
        //      or @ngrx/store/update-reducers)
        //   c) the state has been recomputed due to time-traveling
        //   d) any action that is not a PerformAction to err on the side of
        //      caution.
        if (action.type === PERFORM_ACTION) {
            if (state.isLocked || state.isPaused) {
                return;
            }
            /** @type {?} */
            const currentState = unliftState(state);
            if (shouldFilterActions(this.config) &&
                isActionFiltered(currentState, action, this.config.predicate, this.config.actionsSafelist, this.config.actionsBlocklist)) {
                return;
            }
            /** @type {?} */
            const sanitizedState = this.config.stateSanitizer
                ? sanitizeState(this.config.stateSanitizer, currentState, state.currentStateIndex)
                : currentState;
            /** @type {?} */
            const sanitizedAction = this.config.actionSanitizer
                ? sanitizeAction(this.config.actionSanitizer, action, state.nextActionId)
                : action;
            this.sendToReduxDevtools((/**
             * @return {?}
             */
            () => this.extensionConnection.send(sanitizedAction, sanitizedState)));
        }
        else {
            // Requires full state update
            /** @type {?} */
            const sanitizedLiftedState = Object.assign({}, state, { stagedActionIds: state.stagedActionIds, actionsById: this.config.actionSanitizer
                    ? sanitizeActions(this.config.actionSanitizer, state.actionsById)
                    : state.actionsById, computedStates: this.config.stateSanitizer
                    ? sanitizeStates(this.config.stateSanitizer, state.computedStates)
                    : state.computedStates });
            this.sendToReduxDevtools((/**
             * @return {?}
             */
            () => this.devtoolsExtension.send(null, sanitizedLiftedState, this.getExtensionConfig(this.config))));
        }
    }
    /**
     * @private
     * @return {?}
     */
    createChangesObservable() {
        if (!this.devtoolsExtension) {
            return empty();
        }
        return new Observable((/**
         * @param {?} subscriber
         * @return {?}
         */
        subscriber => {
            /** @type {?} */
            const connection = this.devtoolsExtension.connect(this.getExtensionConfig(this.config));
            this.extensionConnection = connection;
            connection.init();
            connection.subscribe((/**
             * @param {?} change
             * @return {?}
             */
            (change) => subscriber.next(change)));
            return connection.unsubscribe;
        }));
    }
    /**
     * @private
     * @return {?}
     */
    createActionStreams() {
        // Listens to all changes
        /** @type {?} */
        const changes$ = this.createChangesObservable().pipe(share());
        // Listen for the start action
        /** @type {?} */
        const start$ = changes$.pipe(filter((/**
         * @param {?} change
         * @return {?}
         */
        (change) => change.type === ExtensionActionTypes.START)));
        // Listen for the stop action
        /** @type {?} */
        const stop$ = changes$.pipe(filter((/**
         * @param {?} change
         * @return {?}
         */
        (change) => change.type === ExtensionActionTypes.STOP)));
        // Listen for lifted actions
        /** @type {?} */
        const liftedActions$ = changes$.pipe(filter((/**
         * @param {?} change
         * @return {?}
         */
        change => change.type === ExtensionActionTypes.DISPATCH)), map((/**
         * @param {?} change
         * @return {?}
         */
        change => this.unwrapAction(change.payload))), concatMap((/**
         * @param {?} action
         * @return {?}
         */
        (action) => {
            if (action.type === IMPORT_STATE) {
                // State imports may happen in two situations:
                // 1. Explicitly by user
                // 2. User activated the "persist state accross reloads" option
                //    and now the state is imported during reload.
                // Because of option 2, we need to give possible
                // lazy loaded reducers time to instantiate.
                // As soon as there is no UPDATE action within 1 second,
                // it is assumed that all reducers are loaded.
                return this.dispatcher.pipe(filter((/**
                 * @param {?} action
                 * @return {?}
                 */
                action => action.type === UPDATE)), timeout(1000), debounceTime(1000), map((/**
                 * @return {?}
                 */
                () => action)), catchError((/**
                 * @return {?}
                 */
                () => of(action))), take(1));
            }
            else {
                return of(action);
            }
        })));
        // Listen for unlifted actions
        /** @type {?} */
        const actions$ = changes$.pipe(filter((/**
         * @param {?} change
         * @return {?}
         */
        change => change.type === ExtensionActionTypes.ACTION)), map((/**
         * @param {?} change
         * @return {?}
         */
        change => this.unwrapAction(change.payload))));
        /** @type {?} */
        const actionsUntilStop$ = actions$.pipe(takeUntil(stop$));
        /** @type {?} */
        const liftedUntilStop$ = liftedActions$.pipe(takeUntil(stop$));
        this.start$ = start$.pipe(takeUntil(stop$));
        // Only take the action sources between the start/stop events
        this.actions$ = this.start$.pipe(switchMap((/**
         * @return {?}
         */
        () => actionsUntilStop$)));
        this.liftedActions$ = this.start$.pipe(switchMap((/**
         * @return {?}
         */
        () => liftedUntilStop$)));
    }
    /**
     * @private
     * @param {?} action
     * @return {?}
     */
    unwrapAction(action) {
        return typeof action === 'string' ? eval(`(${action})`) : action;
    }
    /**
     * @private
     * @param {?} config
     * @return {?}
     */
    getExtensionConfig(config) {
        /** @type {?} */
        const extensionOptions = {
            name: config.name,
            features: config.features,
            serialize: config.serialize,
        };
        if (config.maxAge !== false /* support === 0 */) {
            extensionOptions.maxAge = config.maxAge;
        }
        return extensionOptions;
    }
    /**
     * @private
     * @param {?} send
     * @return {?}
     */
    sendToReduxDevtools(send) {
        try {
            send();
        }
        catch (err) {
            console.warn('@ngrx/store-devtools: something went wrong inside the redux devtools', err);
        }
    }
}
DevtoolsExtension.decorators = [
    { type: Injectable }
];
/** @nocollapse */
DevtoolsExtension.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: [REDUX_DEVTOOLS_EXTENSION,] }] },
    { type: StoreDevtoolsConfig, decorators: [{ type: Inject, args: [STORE_DEVTOOLS_CONFIG,] }] },
    { type: DevtoolsDispatcher }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    DevtoolsExtension.prototype.devtoolsExtension;
    /**
     * @type {?}
     * @private
     */
    DevtoolsExtension.prototype.extensionConnection;
    /** @type {?} */
    DevtoolsExtension.prototype.liftedActions$;
    /** @type {?} */
    DevtoolsExtension.prototype.actions$;
    /** @type {?} */
    DevtoolsExtension.prototype.start$;
    /**
     * @type {?}
     * @private
     */
    DevtoolsExtension.prototype.config;
    /**
     * @type {?}
     * @private
     */
    DevtoolsExtension.prototype.dispatcher;
}
//# sourceMappingURL=data:application/json;base64,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