import { isFunction, hasOwnProperty, isObjectLike } from './utils';
export function immutabilityCheckMetaReducer(reducer, checks) {
    return function (state, action) {
        var act = checks.action ? freeze(action) : action;
        var nextState = reducer(state, act);
        return checks.state ? freeze(nextState) : nextState;
    };
}
function freeze(target) {
    Object.freeze(target);
    var targetIsFunction = isFunction(target);
    Object.getOwnPropertyNames(target).forEach(function (prop) {
        if (hasOwnProperty(target, prop) &&
            (targetIsFunction
                ? prop !== 'caller' && prop !== 'callee' && prop !== 'arguments'
                : true)) {
            var propValue = target[prop];
            if ((isObjectLike(propValue) || isFunction(propValue)) &&
                !Object.isFrozen(propValue)) {
                freeze(propValue);
            }
        }
    });
    return target;
}
//# sourceMappingURL=data:application/json;base64,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