(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@ngrx/store/schematics-core/utility/config", ["require", "exports", "@angular-devkit/schematics"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const schematics_1 = require("@angular-devkit/schematics");
    function getWorkspacePath(host) {
        const possibleFiles = ['/angular.json', '/.angular.json'];
        const path = possibleFiles.filter(path => host.exists(path))[0];
        return path;
    }
    exports.getWorkspacePath = getWorkspacePath;
    function getWorkspace(host) {
        const path = getWorkspacePath(host);
        const configBuffer = host.read(path);
        if (configBuffer === null) {
            throw new schematics_1.SchematicsException(`Could not find (${path})`);
        }
        const config = configBuffer.toString();
        return JSON.parse(config);
    }
    exports.getWorkspace = getWorkspace;
});
//# sourceMappingURL=data:application/json;base64,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