import * as tslib_1 from "tslib";
import { Component, ElementRef, Inject, Injector, Input, ModuleWithProviders, NgModule } from '@angular/core';
import { downgradeComponent, UpgradeModule, getAngularJSGlobal, getAngularLib } from '@angular/upgrade/static';
import { StateObject, forEach, PathNode, Resolvable, StateRegistry, UIRouter, ViewConfig, ViewService, } from '@uirouter/core';
import { applyModuleConfig, NATIVE_INJECTOR_TOKEN, ng2LazyLoadBuilder, Ng2ViewConfig, UIView, _UIROUTER_SERVICE_PROVIDERS, UIROUTER_MODULE_TOKEN, UIROUTER_ROOT_MODULE, UIRouterModule, makeChildProviders, } from '@uirouter/angular';
import { Ng1ViewConfig } from '@uirouter/angularjs';
import { UIRouterRx } from '@uirouter/rx';
var getAngularJS = getAngularJSGlobal || getAngularLib;
var angular = getAngularJS();
if (!angular) {
    throw new Error('AngularJS not found on window.  https://github.com/ui-router/angular-hybrid/wiki/AngularJS-not-found-on-window');
}
/**
 * Create a ng1 module for the ng1 half of the hybrid application to depend on.
 *
 * Example:
 * const myApp = angular.module('myApp', ['ui.router.upgrade']);
 */
export var upgradeModule = angular.module('ui.router.upgrade', ['ui.router']);
export function objectFactory() {
    return {};
}
/**
 * UIViewNgUpgrade is a component bridge from ng1 ui-view to ng2 ui-view
 *
 * When a ui-router for ng1 is registering a state it checks if a view's
 * `component:` is an ng2 Component class. If so, it creates a special ng1 template
 * which references this component, i.e., <ui-view-ng-upgrade></ui-view-ng-upgrade>
 *
 * See that code by searching ng1-to-ng2 source for: "$stateProvider.decorator"
 *
 * ---
 *
 * ng1-to-ng2 component bridge process:
 *
 * 1)
 * When an ng1 template creates a ui-view which is targeted by a ng2 Component,
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- ui-view created in ng1 template -->
 * </div> <!-- targeted with { component: Ng2RoutedComponent } -->
 * ```
 *
 * the state decorator spits out a custom template.  That template loads this
 * ng2 Component adapter as a downgraded-to-ng1 directive.
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- decorated template references the downgraded component -->
 *   <ui-view-ng-upgrade> <!-- downgraded adapter component -->
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * This downgraded ng2 Component then creates a child UIView (ng2 component)
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- custom template references the downgraded component -->
 *   <ui-view-ng-upgrade> <!-- ng2 component adapter downgraded to ng1-->
 *     <ui-view> <!-- pure ng2 ui-view -->
 *      </ui-view>
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * which in turn is filled with the routed ng2 component.
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- ng1 ui-view -->
 *   <ui-view-ng-upgrade> <!-- ng2 component adapter (downgraded to ng1)-->
 *     <ui-view> <!-- pure ng2 ui-view -->
 *       <ng2-routed-component> <!-- ng2 component hosted in ng2 ui-view -->
 *         <h1>ng2 routed component contents</h1>
 *       </ng2-routed-component>
 *     </ui-view>
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * This adapter exposes exposes the parent view context (ParentUIViewInject)
 * as an ng2 DI Provider, which the nested ng2 UIView requires.
 *
 * It gets the ParentUIViewContext information (from the parent ng1 ui-view) by walking
 * up the DOM and grabbing the .data('$uiView') which the ng1 ui-view directive exposes.
 */
var UIViewNgUpgrade = /** @class */ (function () {
    function UIViewNgUpgrade(ref, parent, registry // access the root state
    ) {
        // From the ui-view-ng-upgrade component's element ref, walk up the DOM two elements...
        // There will first be an ng1 ui-view which hosts this element, and then that ui-view's parent element.
        // That (parent) element has access to the proper "parent viewcontext"
        // The ng2 ui-view component is inside this ui-view-ng-upgrade directive, which is inside the ng1 "host" ui-view.
        // Both ui-views share the same "view context" information (the view's fqn and created-by-state context information)
        var ng1elem = angular
            .element(ref.nativeElement)
            .parent()
            .parent();
        // Expose getters on PARENT_INJECT for context (creation state) and fqn (view address)
        // These will be used by further nested UIView
        Object.defineProperty(parent, 'context', {
            get: function () {
                var data = ng1elem['inheritedData']('$uiView');
                return data && data.$cfg ? data.$cfg.viewDecl.$context : registry.root();
            },
            enumerable: true,
        });
        Object.defineProperty(parent, 'fqn', {
            get: function () {
                var data = ng1elem['inheritedData']('$uiView');
                return data && data.$uiView ? data.$uiView.fqn : null;
            },
            enumerable: true,
        });
    }
    UIViewNgUpgrade.ctorParameters = function () { return [
        { type: ElementRef },
        { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] }] },
        { type: StateRegistry // access the root state
         }
    ]; };
    tslib_1.__decorate([
        Input()
    ], UIViewNgUpgrade.prototype, "name", void 0);
    UIViewNgUpgrade = tslib_1.__decorate([
        Component({
            selector: 'ui-view-ng-upgrade',
            template: "\n    <ui-view [name]=\"name\"></ui-view>\n  ",
            // provide a blank object as PARENT_INJECT.
            // The component will add property getters when it is constructed.
            viewProviders: [{ provide: UIView.PARENT_INJECT, useFactory: objectFactory }]
        }),
        tslib_1.__param(1, Inject(UIView.PARENT_INJECT))
    ], UIViewNgUpgrade);
    return UIViewNgUpgrade;
}());
export { UIViewNgUpgrade };
/**********************************
 * Ng2 @NgModule and bootstrap code
 **********************************/
// Register the ng1 DI '$uiRouter' object as an ng2 Provider.
export function uiRouterUpgradeFactory(router, injector) {
    var modules = injector.get(UIROUTER_MODULE_TOKEN, []);
    modules.forEach(function (module) { return applyModuleConfig(router, injector, module); });
    return router;
}
export function getUIRouter($injector) {
    return $injector.get('$uiRouter');
}
export function getParentUIViewInject(r) {
    return { fqn: null, context: r.root() };
}
var ɵ0 = {};
/**
 * This NgModule should be added to the root module of the hybrid app.
 */
var UIRouterUpgradeModule = /** @class */ (function () {
    function UIRouterUpgradeModule() {
    }
    UIRouterUpgradeModule_1 = UIRouterUpgradeModule;
    UIRouterUpgradeModule.forRoot = function (module) {
        if (module === void 0) { module = {}; }
        return {
            ngModule: UIRouterUpgradeModule_1,
            providers: makeChildProviders(module),
        };
    };
    UIRouterUpgradeModule.forChild = function (module) {
        if (module === void 0) { module = {}; }
        return {
            ngModule: UIRouterModule,
            providers: makeChildProviders(module),
        };
    };
    var UIRouterUpgradeModule_1;
    UIRouterUpgradeModule = UIRouterUpgradeModule_1 = tslib_1.__decorate([
        NgModule({
            imports: [UIRouterModule, UpgradeModule],
            declarations: [UIViewNgUpgrade],
            providers: tslib_1.__spread([
                // @uirouter/angular code will use the ng1 $uiRouter instance instead of creating its own.
                { provide: '$uiRouter', useFactory: getUIRouter, deps: ['$injector'] },
                { provide: UIRouter, useFactory: uiRouterUpgradeFactory, deps: ['$uiRouter', Injector] },
                { provide: UIROUTER_ROOT_MODULE, useValue: ɵ0, multi: true },
                { provide: UIView.PARENT_INJECT, useFactory: getParentUIViewInject, deps: [StateRegistry] }
            ], _UIROUTER_SERVICE_PROVIDERS),
            entryComponents: [UIViewNgUpgrade],
            exports: [UIViewNgUpgrade, UIRouterModule],
        })
    ], UIRouterUpgradeModule);
    return UIRouterUpgradeModule;
}());
export { UIRouterUpgradeModule };
// Downgrade the UIViewNgUpgrade ng2 Component to an ng1 directive.
// The directive is used in a (generated) view template by the (host) ng1 ui-router,
// whenever it finds a view configured with a `component: <Ng2ComponentClass>`
upgradeModule.directive('uiViewNgUpgrade', downgradeComponent({
    component: UIViewNgUpgrade,
    inputs: ['name'],
}));
upgradeModule.run([
    '$injector',
    function (ng1Injector) {
        var $uiRouter = ng1Injector.get('$uiRouter');
        /** Add support for observable state and param changes */
        $uiRouter.plugin(UIRouterRx);
        // Expose a merged ng1/ng2 injector as a Resolvable (on the root state).
        // This mimics how ui-router-ng2 exposes the root ng2 Injector, but
        // it retrieves from ng1 injector first, then ng2 injector if the token isn't found.
        var mergedInjector = {
            get: function (token, ng2NotFoundValue) {
                var ng2Injector = ng1Injector.get('$$angularInjector');
                if (ng1Injector.has(token)) {
                    return ng1Injector.get(token);
                }
                return ng2Injector.get(token, ng2NotFoundValue);
            },
        };
        var ng2InjectorResolvable = Resolvable.fromData(NATIVE_INJECTOR_TOKEN, mergedInjector);
        $uiRouter.stateRegistry.root().resolvables.push(ng2InjectorResolvable);
    },
]);
/** Adds support for `loadChildren`: Angular NgModule lazy loading via @gntools/webpack */
upgradeModule.config([
    '$stateRegistryProvider',
    function ($stateRegistry) {
        $stateRegistry.decorator('lazyLoad', ng2LazyLoadBuilder);
    },
]);
/**
 * Define a stateProvider `views` builder decorator.
 * The decorator first applies the standard views builder function.
 * Then it finds any view components which are **actually** a Ng2 Component Class.
 * It overwrites that view's config with a ng1-to-ng2 hybrid config.
 *
 * In place of the template provider, it simply puts a <ui-view-ng-upgrade/> component
 * which that provides a ng1 -> ng2 boundary in the component tree.
 */
upgradeModule.config([
    '$stateRegistryProvider',
    function ($stateRegistry) {
        $stateRegistry.decorator('views', function (state, parentFn) {
            var views = parentFn(state);
            forEach(views, function (viewDecl, viewName) {
                if (viewDecl.$type === 'ng1-to-ng2' || typeof viewDecl.component === 'function') {
                    // Update the view config.
                    // Override default ng1 `component:` behavior (of defining a templateProvider)
                    // with a <ui-view-ng-upgrade> adapter directive template
                    viewDecl.$type = 'ng1-to-ng2';
                    viewDecl.templateProvider = null;
                    viewDecl.template = "<ui-view-ng-upgrade name='" + viewDecl.$uiViewName + "'></ui-view-ng-upgrade>";
                }
            });
            return views;
        });
    },
]);
// UI-Router ViewConfig factories take a view declaration object from a state.views: { foo: <ViewDeclaration> }
// and return a runtime config object (a ViewConfig)
upgradeModule.run([
    '$view',
    '$templateFactory',
    function ($view, $templateFactory) {
        // Register a ViewConfig factory for views of type `ng2`
        $view._pluginapi._viewConfigFactory('ng2', function (path, config) { return new Ng2ViewConfig(path, config); });
        // Register a ViewConfig factory for views of type `ng1-to-ng2`.
        // Returns both an ng1 config and an ng2 config allowing either ng1 or ng2 ui-view components to be targeted.
        $view._pluginapi._viewConfigFactory('ng1-to-ng2', function (path, config) {
            var ng1ViewConfig = (new Ng1ViewConfig(path, Object.assign({}, config, { $type: 'ng1' }), $templateFactory));
            var ng2ViewConfig = (new Ng2ViewConfig(path, Object.assign({}, config, { $type: 'ng2' })));
            return [ng2ViewConfig, ng1ViewConfig];
        });
    },
]);
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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