/**
 * The UI-Router for Angular directives:
 *
 * - [[UIView]]: A viewport for routed components
 * - [[UISref]]: A state ref to a target state; navigates when clicked
 * - [[UISrefActive]]: (and `UISrefActiveEq`) Adds a css class when a UISref's target state (or a child state) is active
 *
 * @ng2api
 * @preferred
 * @module directives
 */ /** */
import { UISref, AnchorUISref } from './uiSref';
import { UISrefActive } from './uiSrefActive';
import { UIView } from './uiView';
import { UISrefStatus } from './uiSrefStatus';
export * from './uiView';
export * from './uiSref';
export * from './uiSrefStatus';
export * from './uiSrefActive';
/** @internalapi */
export const _UIROUTER_DIRECTIVES = [UISref, AnchorUISref, UIView, UISrefActive, UISrefStatus];
/**
 * References to the UI-Router directive classes, for use within a @Component's `directives:` property
 * @deprecated use [[UIRouterModule]]
 * @internalapi
 */
export const UIROUTER_DIRECTIVES = _UIROUTER_DIRECTIVES;
//# sourceMappingURL=data:application/json;base64,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