var UIView_1;
import * as tslib_1 from "tslib";
/** @ng2api @module directives */
/** */
import { Component, ComponentFactoryResolver, Inject, Input, ReflectiveInjector, ViewChild, ViewContainerRef, } from '@angular/core';
import { filter, inArray, isFunction, NATIVE_INJECTOR_TOKEN, parse, ResolveContext, trace, UIRouter, unnestR, } from '@uirouter/core';
import { Ng2ViewConfig } from '../statebuilders/views';
import { MergeInjector } from '../mergeInjector';
/** @hidden */
let id = 0;
/**
 * Given a component class, gets the inputs of styles:
 *
 * - @Input('foo') _foo
 * - `inputs: ['foo']`
 *
 * @internalapi
 */
const ng2ComponentInputs = (factory) => {
    return factory.inputs.map(input => ({ prop: input.propName, token: input.templateName }));
};
const ɵ0 = ng2ComponentInputs;
/**
 * A UI-Router viewport directive, which is filled in by a view (component) on a state.
 *
 * ### Selector
 *
 * A `ui-view` directive can be created as an element: `<ui-view></ui-view>` or as an attribute: `<div ui-view></div>`.
 *
 * ### Purpose
 *
 * This directive is used in a Component template (or as the root component) to create a viewport.  The viewport
 * is filled in by a view (as defined by a [[Ng2ViewDeclaration]] inside a [[Ng2StateDeclaration]]) when the view's
 * state has been activated.
 *
 * #### Example:
 * ```js
 * // This app has two states, 'foo' and 'bar'
 * stateRegistry.register({ name: 'foo', url: '/foo', component: FooComponent });
 * stateRegistry.register({ name: 'bar', url: '/bar', component: BarComponent });
 * ```
 * ```html
 * <!-- This ui-view will be filled in by the foo state's component or
 *      the bar state's component when the foo or bar state is activated -->
 * <ui-view></ui-view>
 * ```
 *
 * ### Named ui-views
 *
 * A `ui-view` may optionally be given a name via the attribute value: `<div ui-view='header'></div>`.  *Note:
 * an unnamed `ui-view` is internally named `$default`*.   When a `ui-view` has a name, it will be filled in
 * by a matching named view.
 *
 * #### Example:
 * ```js
 * stateRegistry.register({
 *   name: 'foo',
 *   url: '/foo',
 *   views: { header: HeaderComponent, $default: FooComponent });
 * ```
 * ```html
 * <!-- When 'foo' state is active, filled by HeaderComponent -->
 * <div ui-view="header"></div>
 *
 * <!-- When 'foo' state is active, filled by FooComponent -->
 * <ui-view></ui-view>
 * ```
 */
let UIView = UIView_1 = class UIView {
    constructor(router, parent, viewContainerRef) {
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        /** Data about the this UIView */
        this._uiViewData = {};
        this._parent = parent;
    }
    set _name(val) {
        this.name = val;
    }
    /**
     * @returns the UI-Router `state` that is filling this uiView, or `undefined`.
     */
    get state() {
        return parse('_uiViewData.config.viewDecl.$context.self')(this);
    }
    ngOnInit() {
        const router = this.router;
        const parentFqn = this._parent.fqn;
        const name = this.name || '$default';
        this._uiViewData = {
            $type: 'ng2',
            id: id++,
            name: name,
            fqn: parentFqn ? parentFqn + '.' + name : name,
            creationContext: this._parent.context,
            configUpdated: this._viewConfigUpdated.bind(this),
            config: undefined,
        };
        this._deregisterUiCanExitHook = router.transitionService.onBefore({}, trans => {
            return this._invokeUiCanExitHook(trans);
        });
        this._deregisterUiOnParamsChangedHook = router.transitionService.onSuccess({}, trans => this._invokeUiOnParamsChangedHook(trans));
        this._deregisterUIView = router.viewService.registerUIView(this._uiViewData);
    }
    /**
     * For each transition, checks the component loaded in the ui-view for:
     *
     * - has a uiCanExit() component hook
     * - is being exited
     *
     * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
     */
    _invokeUiCanExitHook(trans) {
        const instance = this._componentRef && this._componentRef.instance;
        const uiCanExitFn = instance && instance.uiCanExit;
        if (isFunction(uiCanExitFn)) {
            const state = this.state;
            if (trans.exiting().indexOf(state) !== -1) {
                trans.onStart({}, function () {
                    return uiCanExitFn.call(instance, trans);
                });
            }
        }
    }
    /**
     * For each transition, checks if any param values changed and notify component
     */
    _invokeUiOnParamsChangedHook($transition$) {
        const instance = this._componentRef && this._componentRef.instance;
        const uiOnParamsChanged = instance && instance.uiOnParamsChanged;
        if (isFunction(uiOnParamsChanged)) {
            const viewState = this.state;
            const resolveContext = new ResolveContext(this._uiViewData.config.path);
            const viewCreationTrans = resolveContext.getResolvable('$transition$').data;
            // Exit early if the $transition$ is the same as the view was created within.
            // Exit early if the $transition$ will exit the state the view is for.
            if ($transition$ === viewCreationTrans || $transition$.exiting().indexOf(viewState) !== -1)
                return;
            const toParams = $transition$.params('to');
            const fromParams = $transition$.params('from');
            const getNodeSchema = (node) => node.paramSchema;
            const toSchema = $transition$
                .treeChanges('to')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            const fromSchema = $transition$
                .treeChanges('from')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            // Find the to params that have different values than the from params
            const changedToParams = toSchema.filter((param) => {
                const idx = fromSchema.indexOf(param);
                return idx === -1 || !fromSchema[idx].type.equals(toParams[param.id], fromParams[param.id]);
            });
            // Only trigger callback if a to param has changed or is new
            if (changedToParams.length) {
                const changedKeys = changedToParams.map(x => x.id);
                // Filter the params to only changed/new to params.  `$transition$.params()` may be used to get all params.
                const newValues = filter(toParams, (val, key) => changedKeys.indexOf(key) !== -1);
                instance.uiOnParamsChanged(newValues, $transition$);
            }
        }
    }
    _disposeLast() {
        if (this._componentRef)
            this._componentRef.destroy();
        this._componentRef = null;
    }
    ngOnDestroy() {
        if (this._deregisterUIView)
            this._deregisterUIView();
        if (this._deregisterUiCanExitHook)
            this._deregisterUiCanExitHook();
        if (this._deregisterUiOnParamsChangedHook)
            this._deregisterUiOnParamsChangedHook();
        this._deregisterUIView = this._deregisterUiCanExitHook = this._deregisterUiOnParamsChangedHook = null;
        this._disposeLast();
    }
    /**
     * The view service is informing us of an updated ViewConfig
     * (usually because a transition activated some state and its views)
     */
    _viewConfigUpdated(config) {
        // The config may be undefined if there is nothing currently targeting this UIView.
        // Dispose the current component, if there is one
        if (!config)
            return this._disposeLast();
        // Only care about Ng2 configs
        if (!(config instanceof Ng2ViewConfig))
            return;
        // The "new" viewconfig is already applied, so exit early
        if (this._uiViewData.config === config)
            return;
        // This is a new ViewConfig.  Dispose the previous component
        this._disposeLast();
        trace.traceUIViewConfigUpdated(this._uiViewData, config && config.viewDecl.$context);
        this._applyUpdatedConfig(config);
        // Initiate change detection for the newly created component
        this._componentRef.changeDetectorRef.markForCheck();
    }
    _applyUpdatedConfig(config) {
        this._uiViewData.config = config;
        // Create the Injector for the routed component
        const context = new ResolveContext(config.path);
        const componentInjector = this._getComponentInjector(context);
        // Get the component class from the view declaration. TODO: allow promises?
        const componentClass = config.viewDecl.component;
        // Create the component
        const compFactoryResolver = componentInjector.get(ComponentFactoryResolver);
        const compFactory = compFactoryResolver.resolveComponentFactory(componentClass);
        this._componentRef = this._componentTarget.createComponent(compFactory, undefined, componentInjector);
        // Wire resolves to @Input()s
        this._applyInputBindings(compFactory, this._componentRef.instance, context, componentClass);
    }
    /**
     * Creates a new Injector for a routed component.
     *
     * Adds resolve values to the Injector
     * Adds providers from the NgModule for the state
     * Adds providers from the parent Component in the component tree
     * Adds a PARENT_INJECT view context object
     *
     * @returns an Injector
     */
    _getComponentInjector(context) {
        // Map resolves to "useValue: providers"
        const resolvables = context
            .getTokens()
            .map(token => context.getResolvable(token))
            .filter(r => r.resolved);
        const newProviders = resolvables.map(r => ({ provide: r.token, useValue: context.injector().get(r.token) }));
        const parentInject = { context: this._uiViewData.config.viewDecl.$context, fqn: this._uiViewData.fqn };
        newProviders.push({ provide: UIView_1.PARENT_INJECT, useValue: parentInject });
        const parentComponentInjector = this.viewContainerRef.injector;
        const moduleInjector = context.getResolvable(NATIVE_INJECTOR_TOKEN).data;
        const mergedParentInjector = new MergeInjector(moduleInjector, parentComponentInjector);
        return ReflectiveInjector.resolveAndCreate(newProviders, mergedParentInjector);
    }
    /**
     * Supplies component inputs with resolve data
     *
     * Finds component inputs which match resolves (by name) and sets the input value
     * to the resolve data.
     */
    _applyInputBindings(factory, component, context, componentClass) {
        const bindings = this._uiViewData.config.viewDecl['bindings'] || {};
        const explicitBoundProps = Object.keys(bindings);
        // Returns the actual component property for a renamed an input renamed using `@Input('foo') _foo`.
        // return the `_foo` property
        const renamedInputProp = (prop) => {
            const input = factory.inputs.find(i => i.templateName === prop);
            return (input && input.propName) || prop;
        };
        // Supply resolve data to component as specified in the state's `bindings: {}`
        const explicitInputTuples = explicitBoundProps.reduce((acc, key) => acc.concat([{ prop: renamedInputProp(key), token: bindings[key] }]), []);
        // Supply resolve data to matching @Input('prop') or inputs: ['prop']
        const implicitInputTuples = ng2ComponentInputs(factory).filter(tuple => !inArray(explicitBoundProps, tuple.prop));
        const addResolvable = (tuple) => ({
            prop: tuple.prop,
            resolvable: context.getResolvable(tuple.token),
        });
        const injector = context.injector();
        explicitInputTuples
            .concat(implicitInputTuples)
            .map(addResolvable)
            .filter(tuple => tuple.resolvable && tuple.resolvable.resolved)
            .forEach(tuple => {
            component[tuple.prop] = injector.get(tuple.resolvable.token);
        });
    }
};
UIView.PARENT_INJECT = 'UIView.PARENT_INJECT';
tslib_1.__decorate([
    ViewChild('componentTarget', { read: ViewContainerRef, static: true }),
    tslib_1.__metadata("design:type", ViewContainerRef)
], UIView.prototype, "_componentTarget", void 0);
tslib_1.__decorate([
    Input('name'),
    tslib_1.__metadata("design:type", String)
], UIView.prototype, "name", void 0);
tslib_1.__decorate([
    Input('ui-view'),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], UIView.prototype, "_name", null);
UIView = UIView_1 = tslib_1.__decorate([
    Component({
        selector: 'ui-view, [ui-view]',
        exportAs: 'uiView',
        template: `
    <ng-template #componentTarget></ng-template>
    <ng-content *ngIf="!_componentRef"></ng-content>
  `
    }),
    tslib_1.__param(1, Inject(UIView_1.PARENT_INJECT)),
    tslib_1.__metadata("design:paramtypes", [UIRouter, Object, ViewContainerRef])
], UIView);
export { UIView };
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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