/** @module ng2 */ /** */
import { isFunction } from '@uirouter/core';
import { pick, forEach } from '@uirouter/core';
import { services } from '@uirouter/core';
import { ViewService } from '@uirouter/core';
/**
 * This is a [[StateBuilder.builder]] function for Angular `views`.
 *
 * When the [[StateBuilder]] builds a [[State]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to @uirouter/angular.
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object and
 * applies the state-level configuration to a view named `$default`.
 */
export function ng2ViewsBuilder(state) {
    const views = {}, viewsObject = state.views || { $default: pick(state, ['component', 'bindings']) };
    forEach(viewsObject, function (config, name) {
        name = name || '$default'; // Account for views: { "": { template... } }
        if (isFunction(config))
            config = { component: config };
        if (Object.keys(config).length === 0)
            return;
        config.$type = 'ng2';
        config.$context = state;
        config.$name = name;
        const normalized = ViewService.normalizeUIViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
let id = 0;
export class Ng2ViewConfig {
    constructor(path, viewDecl) {
        this.path = path;
        this.viewDecl = viewDecl;
        this.$id = id++;
        this.loaded = true;
    }
    load() {
        return services.$q.when(this);
    }
}
//# sourceMappingURL=data:application/json;base64,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