import * as tslib_1 from "tslib";
import { NgModule, ANALYZE_FOR_ENTRY_COMPONENTS, InjectionToken, APP_INITIALIZER, } from '@angular/core';
import { CommonModule, LocationStrategy, HashLocationStrategy, PathLocationStrategy, } from '@angular/common';
import { _UIROUTER_DIRECTIVES } from './directives/directives';
import { UIView } from './directives/uiView';
import { TransitionService } from '@uirouter/core';
import { _UIROUTER_INSTANCE_PROVIDERS, _UIROUTER_SERVICE_PROVIDERS } from './providers';
/** @hidden */ export var UIROUTER_ROOT_MODULE = new InjectionToken('UIRouter Root Module');
/** @hidden */ export var UIROUTER_MODULE_TOKEN = new InjectionToken('UIRouter Module');
/** @hidden */ export var UIROUTER_STATES = new InjectionToken('UIRouter States');
// Delay angular bootstrap until first transition is successful, for SSR.
// See https://github.com/ui-router/angular/pull/127
export function onTransitionReady(transitionService, root) {
    var mod = root[0];
    if (!mod || !mod.deferInitialRender) {
        return function () { return Promise.resolve(); };
    }
    return function () {
        return new Promise(function (resolve) {
            var hook = function (trans) {
                trans.promise.then(resolve, resolve);
            };
            transitionService.onStart({}, hook, { invokeLimit: 1 });
        });
    };
}
export function makeRootProviders(module) {
    return [
        { provide: UIROUTER_ROOT_MODULE, useValue: module, multi: true },
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
        {
            provide: APP_INITIALIZER,
            useFactory: onTransitionReady,
            deps: [TransitionService, UIROUTER_ROOT_MODULE],
            multi: true,
        },
    ];
}
export function makeChildProviders(module) {
    return [
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
    ];
}
export function locationStrategy(useHash) {
    return { provide: LocationStrategy, useClass: useHash ? HashLocationStrategy : PathLocationStrategy };
}
/**
 * Creates UI-Router Modules
 *
 * This class has two static factory methods which create UIRouter Modules.
 * A UI-Router Module is an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
 * with support for UI-Router.
 *
 * ### UIRouter Directives
 *
 * When a UI-Router Module is imported into a `NgModule`, that module's components
 * can use the UIRouter Directives such as [[UIView]], [[UISref]], [[UISrefActive]].
 *
 * ### State Definitions
 *
 * State definitions found in the `states:` property are provided to the Dependency Injector.
 * This enables UI-Router to automatically register the states with the [[StateRegistry]] at bootstrap (and during lazy load).
 *
 * ### Entry Components
 *
 * Any routed components are added as `entryComponents:` so they will get compiled.
 */
var UIRouterModule = /** @class */ (function () {
    function UIRouterModule() {
    }
    UIRouterModule_1 = UIRouterModule;
    /**
     * Creates a UI-Router Module for the root (bootstrapped) application module to import
     *
     * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
     * An application should only create and import a single `NgModule` using `forRoot()`.
     * All other modules should be created using [[UIRouterModule.forChild]].
     *
     * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
     * This factory also accepts root-level router configuration.
     * These are the only differences between `forRoot` and `forChild`.
     *
     * Example:
     * ```js
     * let routerConfig = {
     *   otherwise: '/home',
     *   states: [homeState, aboutState]
     * };
     *
     * @ NgModule({
     *   imports: [
     *     BrowserModule,
     *     UIRouterModule.forRoot(routerConfig),
     *     FeatureModule1
     *   ]
     * })
     * class MyRootAppModule {}
     *
     * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
     * ```
     *
     * @param config declarative UI-Router configuration
     * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
     */
    UIRouterModule.forRoot = function (config) {
        if (config === void 0) { config = {}; }
        return {
            ngModule: UIRouterModule_1,
            providers: tslib_1.__spread([
                _UIROUTER_INSTANCE_PROVIDERS,
                _UIROUTER_SERVICE_PROVIDERS,
                locationStrategy(config.useHash)
            ], makeRootProviders(config)),
        };
    };
    /**
     * Creates an `NgModule` for a UIRouter module
     *
     * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * #### Example:
     * ```js
     * var homeState = { name: 'home', url: '/home', component: Home };
     * var aboutState = { name: 'about', url: '/about', component: About };
     *
     * @ NgModule({
     *   imports: [
     *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
     *     SharedModule,
     *   ],
     *   declarations: [ Home, About ],
     * })
     * export class AppModule {};
     * ```
     *
     * @param module UI-Router module options
     * @returns an `NgModule`
     */
    UIRouterModule.forChild = function (module) {
        if (module === void 0) { module = {}; }
        return {
            ngModule: UIRouterModule_1,
            providers: makeChildProviders(module),
        };
    };
    var UIRouterModule_1;
    UIRouterModule = UIRouterModule_1 = tslib_1.__decorate([
        NgModule({
            imports: [CommonModule],
            declarations: [_UIROUTER_DIRECTIVES],
            exports: [_UIROUTER_DIRECTIVES],
            entryComponents: [UIView],
        })
    ], UIRouterModule);
    return UIRouterModule;
}());
export { UIRouterModule };
//# sourceMappingURL=data:application/json;base64,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