/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
var /**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
MapChart = /** @class */ (function () {
    function MapChart(options) {
        if (options === void 0) { options = { series: [] }; }
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    MapChart.prototype.init = /**
     * @param {?} el
     * @return {?}
     */
    function (el) {
        var _this = this;
        if (!this.ref) {
            Highcharts.mapChart(el.nativeElement, this.options, (/**
             * @param {?} chart
             * @return {?}
             */
            function (chart) {
                _this.refSubject.next(chart);
                _this.ref = chart;
                _this.refSubject.complete();
            }));
        }
    };
    /**
     * @return {?}
     */
    MapChart.prototype.destroy = /**
     * @return {?}
     */
    function () {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    };
    return MapChart;
}());
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
export { MapChart };
if (false) {
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.refSubject;
    /** @type {?} */
    MapChart.prototype.ref$;
    /** @type {?} */
    MapChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,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