/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 *
 * @author Felix Itzenplitz
 * @author Timothy A. Perez (contributor)
 */
var /**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 *
 * @author Felix Itzenplitz
 * @author Timothy A. Perez (contributor)
 */
StockChart = /** @class */ (function () {
    function StockChart(options) {
        if (options === void 0) { options = { series: [] }; }
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    StockChart.prototype.init = /**
     * @param {?} el
     * @return {?}
     */
    function (el) {
        var _this = this;
        if (!this.ref) {
            Highcharts.stockChart(el.nativeElement, this.options, (/**
             * @param {?} chart
             * @return {?}
             */
            function (chart) {
                _this.refSubject.next(chart);
                _this.ref = chart;
                _this.refSubject.complete();
            }));
        }
    };
    /**
     * @return {?}
     */
    StockChart.prototype.destroy = /**
     * @return {?}
     */
    function () {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    };
    return StockChart;
}());
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 *
 * @author Felix Itzenplitz
 * @author Timothy A. Perez (contributor)
 */
export { StockChart };
if (false) {
    /**
     * @type {?}
     * @private
     */
    StockChart.prototype.refSubject;
    /** @type {?} */
    StockChart.prototype.ref$;
    /** @type {?} */
    StockChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    StockChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,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