export class NativeErrorHandlingStrategy {
    handle(resolve, reject) {
        return (err, t) => {
            let result = {
                err: err,
                t: t
            };
            resolve(result);
        };
    }
}
export class StrictErrorHandlingStrategy {
    handle(resolve, reject) {
        return (err, t) => {
            let result = {
                err: err,
                t: t
            };
            if (!err) {
                resolve(result);
                return;
            }
            reject(err);
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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