import * as tslib_1 from "tslib";
import { Inject, Injectable, Pipe } from '@angular/core';
import { I18NEXT_NAMESPACE, I18NEXT_SCOPE, I18NEXT_SERVICE } from './I18NEXT_TOKENS';
let I18NextPipe = class I18NextPipe {
    constructor(translateI18Next, ns, scope) {
        this.translateI18Next = translateI18Next;
        this.ns = ns;
        this.scope = scope;
    }
    transform(key, options) {
        options = this.prepareOptions(options);
        let i18nOpts = this.translateI18Next.options;
        if (options.prependScope === undefined || options.prependScope === true) {
            if (this.scope) {
                key = this.prependScope(key, this.scope, i18nOpts.keySeparator, i18nOpts.nsSeparator);
            }
        }
        if (options.prependNamespace === undefined || options.prependNamespace === true) {
            if (this.ns) {
                key = this.prependNamespace(key, this.ns, i18nOpts.nsSeparator);
            }
        }
        let result = this.translateI18Next.t(key, options);
        if (options.format) {
            if (result) {
                result = this.translateI18Next
                    .format(result, options.format, this.translateI18Next.language);
            }
        }
        return result;
    }
    prependScope(key, scope, keySeparator, nsSeparator) {
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (scope) === 'string') {
            scope = [scope];
        }
        let keysWithScope = [];
        for (let i = 0; i < key.length; i++) {
            const k = key[i];
            if (!this.keyContainsNsSeparator(k, nsSeparator)) { // Do not set scope, if key contains a namespace
                keysWithScope.push(...scope.map(sc => this.joinStrings(keySeparator, sc, k)));
            }
            keysWithScope.push(k);
        }
        return keysWithScope;
    }
    prependNamespace(key, ns, nsSeparator) {
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (ns) === 'string') {
            ns = [ns];
        }
        let keysWithNamespace = [];
        for (let i = 0; i < key.length; i++) {
            const k = key[i];
            if (!this.keyContainsNsSeparator(k, nsSeparator)) { // Do not set namespace, if key contains a namespace
                keysWithNamespace.push(...ns.map(n => this.joinStrings(nsSeparator, n, k)));
            }
            keysWithNamespace.push(k);
        }
        return keysWithNamespace;
    }
    joinStrings(separator, ...str) {
        return [...str].join(separator);
    }
    keyContainsNsSeparator(key, nsSeparator) {
        return key.indexOf(nsSeparator) !== -1;
    }
    prepareOptions(options) {
        options = options || {};
        if (options.context != null)
            options.context = options.context.toString();
        return options;
    }
};
I18NextPipe = tslib_1.__decorate([
    Injectable(),
    Pipe({
        name: 'i18next'
    }),
    tslib_1.__param(0, Inject(I18NEXT_SERVICE)),
    tslib_1.__param(1, Inject(I18NEXT_NAMESPACE)),
    tslib_1.__param(2, Inject(I18NEXT_SCOPE)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, Object])
], I18NextPipe);
export { I18NextPipe };
//# sourceMappingURL=data:application/json;base64,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