import * as tslib_1 from "tslib";
import { Inject, Injectable } from '@angular/core';
import * as i18n from 'i18next';
import { I18NEXT_ERROR_HANDLING_STRATEGY } from './I18NEXT_TOKENS';
import { I18NextEvents } from './I18NextEvents';
const i18next = i18n.default;
let I18NextService = class I18NextService {
    constructor(errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.events = new I18NextEvents();
        this.language = '';
        this.languages = [];
    }
    get options() {
        return i18next.options;
    }
    use(plugin) {
        i18next.use.call(i18next, plugin);
        return this;
    }
    init(options) {
        options = options || {};
        this.subscribeEvents();
        return new Promise((resolve, reject) => {
            i18next.init.call(i18next, Object.assign({}, options), this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    t(key, options) {
        options = options || {};
        return i18next.t.call(i18next, key, options);
    }
    format(value, format, lng) {
        return i18next.format.call(i18next, value, format, lng);
    }
    exists(key, options) {
        return i18next.exists.call(i18next, key, options);
    }
    getFixedT(lng, ns) {
        return i18next.getFixedT.call(i18next, lng, ns);
    }
    setDefaultNamespace(ns) {
        i18next.setDefaultNamespace.call(i18next, ns);
    }
    dir(lng = undefined) {
        return i18next.dir.call(i18next, lng);
    }
    changeLanguage(lng) {
        return new Promise((resolve, reject) => {
            i18next.changeLanguage.call(i18next, lng, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    loadNamespaces(namespaces) {
        return new Promise((resolve, reject) => {
            i18next.loadNamespaces.call(i18next, namespaces, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    loadLanguages(lngs, callback) {
        return new Promise((resolve, reject) => {
            i18next.loadLanguages.call(i18next, lngs, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    //#region resource handling
    reloadResources(...params) {
        i18next.reloadResources.apply(i18next, params);
    }
    getResource(lng, ns, key, options) {
        return i18next.getResource.call(i18next, lng, ns, key, options);
    }
    addResource(lng, ns, key, value, options) {
        i18next.addResource.call(i18next, lng, ns, key, value, options);
    }
    addResources(lng, ns, resources) {
        i18next.addResources.call(i18next, lng, ns, resources);
    }
    addResourceBundle(lng, ns, resources, deep, overwrite) {
        i18next.addResourceBundle.call(i18next, lng, ns, resources, deep, overwrite);
    }
    hasResourceBundle(lng, ns) {
        return i18next.hasResourceBundle.call(i18next, lng, ns);
    }
    getResourceBundle(lng, ns) {
        return i18next.getResourceBundle.call(i18next, lng, ns);
    }
    removeResourceBundle(lng, ns) {
        i18next.removeResourceBundle.call(i18next, lng, ns);
    }
    //#endregion
    subscribeEvents() {
        i18next.on.call(i18next, 'initialized', options => {
            this.language = i18next.language;
            this.languages = i18next.languages;
            this.events.initialized.next(options);
        });
        i18next.on.call(i18next, 'loaded', loaded => this.events.loaded.next(loaded));
        i18next.on.call(i18next, 'failedLoading', (lng, ns, msg) => this.events.failedLoading.next({ lng, ns, msg }));
        i18next.on.call(i18next, 'languageChanged', lng => {
            this.language = i18next.language;
            this.languages = i18next.languages;
            this.events.languageChanged.next(lng);
        });
        i18next.on.call(i18next, 'missingKey', (lngs, namespace, key, res) => this.events.missingKey.next({ lngs, namespace, key, res }));
        i18next.on.call(i18next, 'added', (lng, ns) => this.events.added.next({ lng, ns }));
        i18next.on.call(i18next, 'removed', (lng, ns) => this.events.removed.next({ lng, ns }));
    }
};
I18NextService = tslib_1.__decorate([
    Injectable(),
    tslib_1.__param(0, Inject(I18NEXT_ERROR_HANDLING_STRATEGY)),
    tslib_1.__metadata("design:paramtypes", [Object])
], I18NextService);
export { I18NextService };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSTE4TmV4dFNlcnZpY2UuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9hbmd1bGFyLWkxOG5leHQvIiwic291cmNlcyI6WyJJMThOZXh0U2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDbkQsT0FBTyxLQUFLLElBQUksTUFBTSxTQUFTLENBQUM7QUFFaEMsT0FBTyxFQUFFLCtCQUErQixFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFFbkUsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBTWhELE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7QUFHN0IsSUFBYSxjQUFjLEdBQTNCLE1BQWEsY0FBYztJQVV6QixZQUE2RCxxQkFBbUQ7UUFBbkQsMEJBQXFCLEdBQXJCLHFCQUFxQixDQUE4QjtRQVJoSCxXQUFNLEdBQXVCLElBQUksYUFBYSxFQUFFLENBQUM7UUFDakQsYUFBUSxHQUFXLEVBQUUsQ0FBQztRQUN0QixjQUFTLEdBQWEsRUFBRSxDQUFDO0lBTTBGLENBQUM7SUFKcEgsSUFBSSxPQUFPO1FBQ1QsT0FBTyxPQUFPLENBQUMsT0FBTyxDQUFDO0lBQ3pCLENBQUM7SUFJTSxHQUFHLENBQUMsTUFBVztRQUNwQixPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRU0sSUFBSSxDQUFDLE9BQWE7UUFDdkIsT0FBTyxHQUFHLE9BQU8sSUFBSSxFQUFFLENBQUM7UUFFeEIsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBRXZCLE9BQU8sSUFBSSxPQUFPLENBQ2QsQ0FDRSxPQUF1RCxFQUN2RCxNQUE0QixFQUM1QixFQUFFO1lBQ0YsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxNQUFNLENBQUMsRUFBRSxFQUFFLE9BQU8sQ0FBQyxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDN0csQ0FBQyxDQUNGLENBQUM7SUFFTixDQUFDO0lBRU0sQ0FBQyxDQUFDLEdBQXNCLEVBQUUsT0FBYTtRQUM1QyxPQUFPLEdBQUcsT0FBTyxJQUFJLEVBQUUsQ0FBQztRQUN4QixPQUFPLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBTyxHQUFHLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUVNLE1BQU0sQ0FBQyxLQUFVLEVBQUUsTUFBYyxFQUFFLEdBQVc7UUFDbkQsT0FBTyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxHQUFHLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBRU0sTUFBTSxDQUFDLEdBQUcsRUFBRSxPQUFPO1FBQ3hCLE9BQU8sT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRU0sU0FBUyxDQUFDLEdBQUcsRUFBRSxFQUFFO1FBQ3RCLE9BQU8sT0FBTyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRU0sbUJBQW1CLENBQUMsRUFBVTtRQUNuQyxPQUFPLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRU0sR0FBRyxDQUFDLE1BQWMsU0FBUztRQUM5QixPQUFPLE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRU0sY0FBYyxDQUFDLEdBQVc7UUFDL0IsT0FBTyxJQUFJLE9BQU8sQ0FDaEIsQ0FDRSxPQUF1RCxFQUN2RCxNQUE0QixFQUM1QixFQUFFO1lBQ0EsT0FBTyxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ2xHLENBQUMsQ0FDRixDQUFDO0lBQ0osQ0FBQztJQUVNLGNBQWMsQ0FBQyxVQUE2QjtRQUNqRCxPQUFPLElBQUksT0FBTyxDQUNoQixDQUNFLE9BQXVELEVBQ3ZELE1BQTRCLEVBQzVCLEVBQUU7WUFDQSxPQUFPLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDekcsQ0FBQyxDQUNGLENBQUM7SUFDSixDQUFDO0lBRU0sYUFBYSxDQUFDLElBQXVCLEVBQUUsUUFBa0I7UUFDOUQsT0FBTyxJQUFJLE9BQU8sQ0FDaEIsQ0FDRSxPQUF1RCxFQUN2RCxNQUE0QixFQUM1QixFQUFFO1lBQ0EsT0FBTyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ2xHLENBQUMsQ0FDRixDQUFDO0lBQ0osQ0FBQztJQUVELDJCQUEyQjtJQUVwQixlQUFlLENBQUMsR0FBRyxNQUFNO1FBQzlCLE9BQU8sQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRU0sV0FBVyxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsR0FBRyxFQUFFLE9BQU87UUFDcEMsT0FBTyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUVNLFdBQVcsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUUsT0FBTztRQUMzQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFFTSxZQUFZLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxTQUFTO1FBQ2xDLE9BQU8sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFFTSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsU0FBUztRQUN4RCxPQUFPLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFDakYsQ0FBQztJQUVNLGlCQUFpQixDQUFDLEdBQUcsRUFBRSxFQUFFO1FBQzVCLE9BQU8sT0FBTyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFFTSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsRUFBRTtRQUM1QixPQUFPLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBRU0sb0JBQW9CLENBQUMsR0FBRyxFQUFFLEVBQUU7UUFDL0IsT0FBTyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFRCxZQUFZO0lBRUosZUFBZTtRQUNyQixPQUFPLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsYUFBYSxFQUFFLE9BQU8sQ0FBQyxFQUFFO1lBQ2hELElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQztZQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7WUFDbkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3hDLENBQUMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQzlFLE9BQU8sQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxlQUFlLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEVBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLEVBQUMsQ0FBQyxDQUFDLENBQUM7UUFDNUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxFQUFFO1lBQ2hELElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQztZQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7WUFDbkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3hDLENBQUMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFlBQVksRUFBRSxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2hJLE9BQU8sQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBQyxHQUFHLEVBQUUsRUFBRSxFQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xGLE9BQU8sQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxTQUFTLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBQyxHQUFHLEVBQUUsRUFBRSxFQUFDLENBQUMsQ0FBQyxDQUFDO0lBRXhGLENBQUM7Q0FDRixDQUFBO0FBakpZLGNBQWM7SUFEMUIsVUFBVSxFQUFFO0lBV0UsbUJBQUEsTUFBTSxDQUFDLCtCQUErQixDQUFDLENBQUE7O0dBVnpDLGNBQWMsQ0FpSjFCO1NBakpZLGNBQWMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3QsIEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0ICogYXMgaTE4biBmcm9tICdpMThuZXh0JztcclxuXHJcbmltcG9ydCB7IEkxOE5FWFRfRVJST1JfSEFORExJTkdfU1RSQVRFR1kgfSBmcm9tICcuL0kxOE5FWFRfVE9LRU5TJztcclxuaW1wb3J0IHsgSTE4TmV4dEVycm9ySGFuZGxpbmdTdHJhdGVneSB9IGZyb20gJy4vSTE4TmV4dEVycm9ySGFuZGxpbmdTdHJhdGVnaWVzJztcclxuaW1wb3J0IHsgSTE4TmV4dEV2ZW50cyB9IGZyb20gJy4vSTE4TmV4dEV2ZW50cyc7XHJcbmltcG9ydCB7IEkxOE5leHRMb2FkUmVzdWx0IH0gZnJvbSAnLi9JMThOZXh0TG9hZFJlc3VsdCc7XHJcbmltcG9ydCB7IElUcmFuc2xhdGlvbkV2ZW50cyB9IGZyb20gJy4vSVRyYW5zbGF0aW9uRXZlbnRzJztcclxuaW1wb3J0IHsgSVRyYW5zbGF0aW9uU2VydmljZSB9IGZyb20gJy4vSVRyYW5zbGF0aW9uU2VydmljZSc7XHJcblxyXG5cclxuY29uc3QgaTE4bmV4dCA9IGkxOG4uZGVmYXVsdDtcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGNsYXNzIEkxOE5leHRTZXJ2aWNlIGltcGxlbWVudHMgSVRyYW5zbGF0aW9uU2VydmljZSB7XHJcblxyXG4gIGV2ZW50czogSVRyYW5zbGF0aW9uRXZlbnRzID0gbmV3IEkxOE5leHRFdmVudHMoKTtcclxuICBsYW5ndWFnZTogc3RyaW5nID0gJyc7XHJcbiAgbGFuZ3VhZ2VzOiBzdHJpbmdbXSA9IFtdO1xyXG5cclxuICBnZXQgb3B0aW9ucygpOiBhbnkge1xyXG4gICAgcmV0dXJuIGkxOG5leHQub3B0aW9ucztcclxuICB9XHJcblxyXG4gIGNvbnN0cnVjdG9yKEBJbmplY3QoSTE4TkVYVF9FUlJPUl9IQU5ETElOR19TVFJBVEVHWSkgcHJpdmF0ZSBlcnJvckhhbmRsaW5nU3RyYXRlZ3k6IEkxOE5leHRFcnJvckhhbmRsaW5nU3RyYXRlZ3kpIHt9XHJcblxyXG4gIHB1YmxpYyB1c2UocGx1Z2luOiBhbnkpIHtcclxuICAgIGkxOG5leHQudXNlLmNhbGwoaTE4bmV4dCwgcGx1Z2luKTtcclxuICAgIHJldHVybiB0aGlzO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGluaXQob3B0aW9ucz86IGFueSk6IFByb21pc2U8YW55PiB7XHJcbiAgICBvcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcclxuXHJcbiAgICB0aGlzLnN1YnNjcmliZUV2ZW50cygpO1xyXG5cclxuICAgIHJldHVybiBuZXcgUHJvbWlzZTxJMThOZXh0TG9hZFJlc3VsdD4oXHJcbiAgICAgICAgKFxyXG4gICAgICAgICAgcmVzb2x2ZTogKHRoZW5hYmxlT3JSZXN1bHQ/OiBJMThOZXh0TG9hZFJlc3VsdCkgPT4gdm9pZCxcclxuICAgICAgICAgIHJlamVjdDogKGVycm9yOiBhbnkpID0+IHZvaWRcclxuICAgICAgICApID0+IHtcclxuICAgICAgICAgIGkxOG5leHQuaW5pdC5jYWxsKGkxOG5leHQsIE9iamVjdC5hc3NpZ24oe30sIG9wdGlvbnMpLCB0aGlzLmVycm9ySGFuZGxpbmdTdHJhdGVneS5oYW5kbGUocmVzb2x2ZSwgcmVqZWN0KSk7XHJcbiAgICAgICAgfVxyXG4gICAgICApO1xyXG5cclxuICB9XHJcblxyXG4gIHB1YmxpYyB0KGtleTogc3RyaW5nIHwgc3RyaW5nW10sIG9wdGlvbnM/OiBhbnkpOiBzdHJpbmcge1xyXG4gICAgb3B0aW9ucyA9IG9wdGlvbnMgfHwge307XHJcbiAgICByZXR1cm4gaTE4bmV4dC50LmNhbGwoaTE4bmV4dCwgPGFueT5rZXksIG9wdGlvbnMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGZvcm1hdCh2YWx1ZTogYW55LCBmb3JtYXQ6IHN0cmluZywgbG5nOiBzdHJpbmcpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGkxOG5leHQuZm9ybWF0LmNhbGwoaTE4bmV4dCwgdmFsdWUsIGZvcm1hdCwgbG5nKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBleGlzdHMoa2V5LCBvcHRpb25zKSB7XHJcbiAgICByZXR1cm4gaTE4bmV4dC5leGlzdHMuY2FsbChpMThuZXh0LCBrZXksIG9wdGlvbnMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldEZpeGVkVChsbmcsIG5zKSB7XHJcbiAgICByZXR1cm4gaTE4bmV4dC5nZXRGaXhlZFQuY2FsbChpMThuZXh0LCBsbmcsIG5zKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXREZWZhdWx0TmFtZXNwYWNlKG5zOiBzdHJpbmcpIHtcclxuICAgIGkxOG5leHQuc2V0RGVmYXVsdE5hbWVzcGFjZS5jYWxsKGkxOG5leHQsIG5zKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBkaXIobG5nOiBzdHJpbmcgPSB1bmRlZmluZWQpIHtcclxuICAgICAgcmV0dXJuIGkxOG5leHQuZGlyLmNhbGwoaTE4bmV4dCwgbG5nKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBjaGFuZ2VMYW5ndWFnZShsbmc6IHN0cmluZyk6IFByb21pc2U8STE4TmV4dExvYWRSZXN1bHQ+IHtcclxuICAgIHJldHVybiBuZXcgUHJvbWlzZTxJMThOZXh0TG9hZFJlc3VsdD4oXHJcbiAgICAgIChcclxuICAgICAgICByZXNvbHZlOiAodGhlbmFibGVPclJlc3VsdD86IEkxOE5leHRMb2FkUmVzdWx0KSA9PiB2b2lkLFxyXG4gICAgICAgIHJlamVjdDogKGVycm9yOiBhbnkpID0+IHZvaWRcclxuICAgICAgKSA9PiB7XHJcbiAgICAgICAgICBpMThuZXh0LmNoYW5nZUxhbmd1YWdlLmNhbGwoaTE4bmV4dCwgbG5nLCB0aGlzLmVycm9ySGFuZGxpbmdTdHJhdGVneS5oYW5kbGUocmVzb2x2ZSwgcmVqZWN0KSk7XHJcbiAgICAgIH1cclxuICAgICk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZE5hbWVzcGFjZXMobmFtZXNwYWNlczogc3RyaW5nIHwgc3RyaW5nW10pOiBQcm9taXNlPGFueT4ge1xyXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlPEkxOE5leHRMb2FkUmVzdWx0PihcclxuICAgICAgKFxyXG4gICAgICAgIHJlc29sdmU6ICh0aGVuYWJsZU9yUmVzdWx0PzogSTE4TmV4dExvYWRSZXN1bHQpID0+IHZvaWQsXHJcbiAgICAgICAgcmVqZWN0OiAoZXJyb3I6IGFueSkgPT4gdm9pZFxyXG4gICAgICApID0+IHtcclxuICAgICAgICAgIGkxOG5leHQubG9hZE5hbWVzcGFjZXMuY2FsbChpMThuZXh0LCBuYW1lc3BhY2VzLCB0aGlzLmVycm9ySGFuZGxpbmdTdHJhdGVneS5oYW5kbGUocmVzb2x2ZSwgcmVqZWN0KSk7XHJcbiAgICAgIH1cclxuICAgICk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZExhbmd1YWdlcyhsbmdzOiBzdHJpbmcgfCBzdHJpbmdbXSwgY2FsbGJhY2s6IEZ1bmN0aW9uKSB7XHJcbiAgICByZXR1cm4gbmV3IFByb21pc2U8STE4TmV4dExvYWRSZXN1bHQ+KFxyXG4gICAgICAoXHJcbiAgICAgICAgcmVzb2x2ZTogKHRoZW5hYmxlT3JSZXN1bHQ/OiBJMThOZXh0TG9hZFJlc3VsdCkgPT4gdm9pZCxcclxuICAgICAgICByZWplY3Q6IChlcnJvcjogYW55KSA9PiB2b2lkXHJcbiAgICAgICkgPT4ge1xyXG4gICAgICAgICAgaTE4bmV4dC5sb2FkTGFuZ3VhZ2VzLmNhbGwoaTE4bmV4dCwgbG5ncywgdGhpcy5lcnJvckhhbmRsaW5nU3RyYXRlZ3kuaGFuZGxlKHJlc29sdmUsIHJlamVjdCkpO1xyXG4gICAgICB9XHJcbiAgICApO1xyXG4gIH1cclxuXHJcbiAgLy8jcmVnaW9uIHJlc291cmNlIGhhbmRsaW5nXHJcblxyXG4gIHB1YmxpYyByZWxvYWRSZXNvdXJjZXMoLi4ucGFyYW1zKSB7XHJcbiAgICBpMThuZXh0LnJlbG9hZFJlc291cmNlcy5hcHBseShpMThuZXh0LCBwYXJhbXMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldFJlc291cmNlKGxuZywgbnMsIGtleSwgb3B0aW9ucykge1xyXG4gICAgICByZXR1cm4gaTE4bmV4dC5nZXRSZXNvdXJjZS5jYWxsKGkxOG5leHQsIGxuZywgbnMsIGtleSwgb3B0aW9ucyk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgYWRkUmVzb3VyY2UobG5nLCBucywga2V5LCB2YWx1ZSwgb3B0aW9ucykge1xyXG4gICAgICBpMThuZXh0LmFkZFJlc291cmNlLmNhbGwoaTE4bmV4dCwgbG5nLCBucywga2V5LCB2YWx1ZSwgb3B0aW9ucyk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgYWRkUmVzb3VyY2VzKGxuZywgbnMsIHJlc291cmNlcykge1xyXG4gICAgICBpMThuZXh0LmFkZFJlc291cmNlcy5jYWxsKGkxOG5leHQsIGxuZywgbnMsIHJlc291cmNlcyk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgYWRkUmVzb3VyY2VCdW5kbGUobG5nLCBucywgcmVzb3VyY2VzLCBkZWVwLCBvdmVyd3JpdGUpIHtcclxuICAgICAgaTE4bmV4dC5hZGRSZXNvdXJjZUJ1bmRsZS5jYWxsKGkxOG5leHQsIGxuZywgbnMsIHJlc291cmNlcywgZGVlcCwgb3ZlcndyaXRlKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBoYXNSZXNvdXJjZUJ1bmRsZShsbmcsIG5zKSB7XHJcbiAgICAgIHJldHVybiBpMThuZXh0Lmhhc1Jlc291cmNlQnVuZGxlLmNhbGwoaTE4bmV4dCwgbG5nLCBucyk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0UmVzb3VyY2VCdW5kbGUobG5nLCBucykge1xyXG4gICAgICByZXR1cm4gaTE4bmV4dC5nZXRSZXNvdXJjZUJ1bmRsZS5jYWxsKGkxOG5leHQsIGxuZywgbnMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHJlbW92ZVJlc291cmNlQnVuZGxlKGxuZywgbnMpIHtcclxuICAgICAgaTE4bmV4dC5yZW1vdmVSZXNvdXJjZUJ1bmRsZS5jYWxsKGkxOG5leHQsIGxuZywgbnMpO1xyXG4gIH1cclxuXHJcbiAgLy8jZW5kcmVnaW9uXHJcblxyXG4gIHByaXZhdGUgc3Vic2NyaWJlRXZlbnRzKCkge1xyXG4gICAgaTE4bmV4dC5vbi5jYWxsKGkxOG5leHQsICdpbml0aWFsaXplZCcsIG9wdGlvbnMgPT4ge1xyXG4gICAgICB0aGlzLmxhbmd1YWdlID0gaTE4bmV4dC5sYW5ndWFnZTtcclxuICAgICAgdGhpcy5sYW5ndWFnZXMgPSBpMThuZXh0Lmxhbmd1YWdlcztcclxuICAgICAgdGhpcy5ldmVudHMuaW5pdGlhbGl6ZWQubmV4dChvcHRpb25zKTtcclxuICAgIH0pO1xyXG4gICAgaTE4bmV4dC5vbi5jYWxsKGkxOG5leHQsICdsb2FkZWQnLCBsb2FkZWQgPT4gdGhpcy5ldmVudHMubG9hZGVkLm5leHQobG9hZGVkKSk7XHJcbiAgICBpMThuZXh0Lm9uLmNhbGwoaTE4bmV4dCwgJ2ZhaWxlZExvYWRpbmcnLCAobG5nLCBucywgbXNnKSA9PiB0aGlzLmV2ZW50cy5mYWlsZWRMb2FkaW5nLm5leHQoe2xuZywgbnMsIG1zZ30pKTtcclxuICAgIGkxOG5leHQub24uY2FsbChpMThuZXh0LCAnbGFuZ3VhZ2VDaGFuZ2VkJywgbG5nID0+IHtcclxuICAgICAgdGhpcy5sYW5ndWFnZSA9IGkxOG5leHQubGFuZ3VhZ2U7XHJcbiAgICAgIHRoaXMubGFuZ3VhZ2VzID0gaTE4bmV4dC5sYW5ndWFnZXM7XHJcbiAgICAgIHRoaXMuZXZlbnRzLmxhbmd1YWdlQ2hhbmdlZC5uZXh0KGxuZyk7XHJcbiAgICB9KTtcclxuICAgIGkxOG5leHQub24uY2FsbChpMThuZXh0LCAnbWlzc2luZ0tleScsIChsbmdzLCBuYW1lc3BhY2UsIGtleSwgcmVzKSA9PiB0aGlzLmV2ZW50cy5taXNzaW5nS2V5Lm5leHQoe2xuZ3MsIG5hbWVzcGFjZSwga2V5LCByZXN9KSk7XHJcbiAgICBpMThuZXh0Lm9uLmNhbGwoaTE4bmV4dCwgJ2FkZGVkJywgKGxuZywgbnMpID0+IHRoaXMuZXZlbnRzLmFkZGVkLm5leHQoe2xuZywgbnN9KSk7XHJcbiAgICBpMThuZXh0Lm9uLmNhbGwoaTE4bmV4dCwgJ3JlbW92ZWQnLCAobG5nLCBucykgPT4gdGhpcy5ldmVudHMucmVtb3ZlZC5uZXh0KHtsbmcsIG5zfSkpO1xyXG5cclxuICB9XHJcbn1cclxuIl19