import * as tslib_1 from "tslib";
import { DOCUMENT } from '@angular/common';
import { Inject, Injectable } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { I18NextPipe } from './I18NextPipe';
let I18NextTitle = class I18NextTitle extends Title {
    constructor(i18nextPipe, doc) {
        super(doc);
        this.i18nextPipe = i18nextPipe;
    }
    setTitle(value) {
        return super.setTitle(this.translate(value));
    }
    translate(text) {
        return this.i18nextPipe.transform(text, { format: 'cap' });
    }
};
I18NextTitle = tslib_1.__decorate([
    Injectable(),
    tslib_1.__param(1, Inject(DOCUMENT)),
    tslib_1.__metadata("design:paramtypes", [I18NextPipe, Object])
], I18NextTitle);
export { I18NextTitle };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSTE4TmV4dFRpdGxlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vYW5ndWxhci1pMThuZXh0LyIsInNvdXJjZXMiOlsiSTE4TmV4dFRpdGxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFDM0MsT0FBTyxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDbkQsT0FBTyxFQUFFLEtBQUssRUFBRSxNQUFNLDJCQUEyQixDQUFDO0FBQ2xELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFHNUMsSUFBYSxZQUFZLEdBQXpCLE1BQWEsWUFBYSxTQUFRLEtBQUs7SUFDcEMsWUFBb0IsV0FBd0IsRUFBb0IsR0FBRztRQUNsRSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFEUSxnQkFBVyxHQUFYLFdBQVcsQ0FBYTtJQUU1QyxDQUFDO0lBRUQsUUFBUSxDQUFDLEtBQWE7UUFDckIsT0FBTyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRU8sU0FBUyxDQUFDLElBQVk7UUFDNUIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFDLENBQUMsQ0FBQztJQUM1RCxDQUFDO0NBQ0gsQ0FBQTtBQVpZLFlBQVk7SUFEeEIsVUFBVSxFQUFFO0lBRXFDLG1CQUFBLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQTs2Q0FBOUIsV0FBVztHQURsQyxZQUFZLENBWXhCO1NBWlksWUFBWSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERPQ1VNRU5UIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uJztcclxuaW1wb3J0IHsgSW5qZWN0LCBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IFRpdGxlIH0gZnJvbSAnQGFuZ3VsYXIvcGxhdGZvcm0tYnJvd3Nlcic7XHJcbmltcG9ydCB7IEkxOE5leHRQaXBlIH0gZnJvbSAnLi9JMThOZXh0UGlwZSc7XHJcblxyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBJMThOZXh0VGl0bGUgZXh0ZW5kcyBUaXRsZSB7XHJcbiAgIGNvbnN0cnVjdG9yKHByaXZhdGUgaTE4bmV4dFBpcGU6IEkxOE5leHRQaXBlLCBASW5qZWN0KERPQ1VNRU5UKSBkb2MpIHtcclxuICAgIHN1cGVyKGRvYyk7XHJcbiAgIH1cclxuXHJcbiAgIHNldFRpdGxlKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIHJldHVybiBzdXBlci5zZXRUaXRsZSh0aGlzLnRyYW5zbGF0ZSh2YWx1ZSkpO1xyXG4gICB9XHJcblxyXG4gICBwcml2YXRlIHRyYW5zbGF0ZSh0ZXh0OiBzdHJpbmcpIHtcclxuICAgICByZXR1cm4gdGhpcy5pMThuZXh0UGlwZS50cmFuc2Zvcm0odGV4dCwgeyBmb3JtYXQ6ICdjYXAnfSk7XHJcbiAgIH1cclxufVxyXG4iXX0=