import * as tslib_1 from "tslib";
import { Inject, Injectable, Pipe } from '@angular/core';
import { I18NEXT_NAMESPACE, I18NEXT_SCOPE, I18NEXT_SERVICE } from './I18NEXT_TOKENS';
var I18NextPipe = /** @class */ (function () {
    function I18NextPipe(translateI18Next, ns, scope) {
        this.translateI18Next = translateI18Next;
        this.ns = ns;
        this.scope = scope;
    }
    I18NextPipe.prototype.transform = function (key, options) {
        options = this.prepareOptions(options);
        var i18nOpts = this.translateI18Next.options;
        if (options.prependScope === undefined || options.prependScope === true) {
            if (this.scope) {
                key = this.prependScope(key, this.scope, i18nOpts.keySeparator, i18nOpts.nsSeparator);
            }
        }
        if (options.prependNamespace === undefined || options.prependNamespace === true) {
            if (this.ns) {
                key = this.prependNamespace(key, this.ns, i18nOpts.nsSeparator);
            }
        }
        var result = this.translateI18Next.t(key, options);
        if (options.format) {
            if (result) {
                result = this.translateI18Next
                    .format(result, options.format, this.translateI18Next.language);
            }
        }
        return result;
    };
    I18NextPipe.prototype.prependScope = function (key, scope, keySeparator, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (scope) === 'string') {
            scope = [scope];
        }
        var keysWithScope = [];
        var _loop_1 = function (i) {
            var k = key[i];
            if (!this_1.keyContainsNsSeparator(k, nsSeparator)) { // Do not set scope, if key contains a namespace
                keysWithScope.push.apply(// Do not set scope, if key contains a namespace
                keysWithScope, tslib_1.__spread(scope.map(function (sc) { return _this.joinStrings(keySeparator, sc, k); })));
            }
            keysWithScope.push(k);
        };
        var this_1 = this;
        for (var i = 0; i < key.length; i++) {
            _loop_1(i);
        }
        return keysWithScope;
    };
    I18NextPipe.prototype.prependNamespace = function (key, ns, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (ns) === 'string') {
            ns = [ns];
        }
        var keysWithNamespace = [];
        var _loop_2 = function (i) {
            var k = key[i];
            if (!this_2.keyContainsNsSeparator(k, nsSeparator)) { // Do not set namespace, if key contains a namespace
                keysWithNamespace.push.apply(// Do not set namespace, if key contains a namespace
                keysWithNamespace, tslib_1.__spread(ns.map(function (n) { return _this.joinStrings(nsSeparator, n, k); })));
            }
            keysWithNamespace.push(k);
        };
        var this_2 = this;
        for (var i = 0; i < key.length; i++) {
            _loop_2(i);
        }
        return keysWithNamespace;
    };
    I18NextPipe.prototype.joinStrings = function (separator) {
        var str = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            str[_i - 1] = arguments[_i];
        }
        return tslib_1.__spread(str).join(separator);
    };
    I18NextPipe.prototype.keyContainsNsSeparator = function (key, nsSeparator) {
        return key.indexOf(nsSeparator) !== -1;
    };
    I18NextPipe.prototype.prepareOptions = function (options) {
        options = options || {};
        if (options.context != null)
            options.context = options.context.toString();
        return options;
    };
    I18NextPipe = tslib_1.__decorate([
        Injectable(),
        Pipe({
            name: 'i18next'
        }),
        tslib_1.__param(0, Inject(I18NEXT_SERVICE)),
        tslib_1.__param(1, Inject(I18NEXT_NAMESPACE)),
        tslib_1.__param(2, Inject(I18NEXT_SCOPE)),
        tslib_1.__metadata("design:paramtypes", [Object, Object, Object])
    ], I18NextPipe);
    return I18NextPipe;
}());
export { I18NextPipe };
//# sourceMappingURL=data:application/json;base64,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