import * as tslib_1 from "tslib";
import { Inject, Injectable } from '@angular/core';
import * as i18n from 'i18next';
import { I18NEXT_ERROR_HANDLING_STRATEGY } from './I18NEXT_TOKENS';
import { I18NextEvents } from './I18NextEvents';
var i18next = i18n.default;
var I18NextService = /** @class */ (function () {
    function I18NextService(errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.events = new I18NextEvents();
        this.language = '';
        this.languages = [];
    }
    Object.defineProperty(I18NextService.prototype, "options", {
        get: function () {
            return i18next.options;
        },
        enumerable: true,
        configurable: true
    });
    I18NextService.prototype.use = function (plugin) {
        i18next.use.call(i18next, plugin);
        return this;
    };
    I18NextService.prototype.init = function (options) {
        var _this = this;
        options = options || {};
        this.subscribeEvents();
        return new Promise(function (resolve, reject) {
            i18next.init.call(i18next, Object.assign({}, options), _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.t = function (key, options) {
        options = options || {};
        return i18next.t.call(i18next, key, options);
    };
    I18NextService.prototype.format = function (value, format, lng) {
        return i18next.format.call(i18next, value, format, lng);
    };
    I18NextService.prototype.exists = function (key, options) {
        return i18next.exists.call(i18next, key, options);
    };
    I18NextService.prototype.getFixedT = function (lng, ns) {
        return i18next.getFixedT.call(i18next, lng, ns);
    };
    I18NextService.prototype.setDefaultNamespace = function (ns) {
        i18next.setDefaultNamespace.call(i18next, ns);
    };
    I18NextService.prototype.dir = function (lng) {
        if (lng === void 0) { lng = undefined; }
        return i18next.dir.call(i18next, lng);
    };
    I18NextService.prototype.changeLanguage = function (lng) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.changeLanguage.call(i18next, lng, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.loadNamespaces = function (namespaces) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.loadNamespaces.call(i18next, namespaces, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.loadLanguages = function (lngs, callback) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.loadLanguages.call(i18next, lngs, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    //#region resource handling
    I18NextService.prototype.reloadResources = function () {
        var params = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            params[_i] = arguments[_i];
        }
        i18next.reloadResources.apply(i18next, params);
    };
    I18NextService.prototype.getResource = function (lng, ns, key, options) {
        return i18next.getResource.call(i18next, lng, ns, key, options);
    };
    I18NextService.prototype.addResource = function (lng, ns, key, value, options) {
        i18next.addResource.call(i18next, lng, ns, key, value, options);
    };
    I18NextService.prototype.addResources = function (lng, ns, resources) {
        i18next.addResources.call(i18next, lng, ns, resources);
    };
    I18NextService.prototype.addResourceBundle = function (lng, ns, resources, deep, overwrite) {
        i18next.addResourceBundle.call(i18next, lng, ns, resources, deep, overwrite);
    };
    I18NextService.prototype.hasResourceBundle = function (lng, ns) {
        return i18next.hasResourceBundle.call(i18next, lng, ns);
    };
    I18NextService.prototype.getResourceBundle = function (lng, ns) {
        return i18next.getResourceBundle.call(i18next, lng, ns);
    };
    I18NextService.prototype.removeResourceBundle = function (lng, ns) {
        i18next.removeResourceBundle.call(i18next, lng, ns);
    };
    //#endregion
    I18NextService.prototype.subscribeEvents = function () {
        var _this = this;
        i18next.on.call(i18next, 'initialized', function (options) {
            _this.language = i18next.language;
            _this.languages = i18next.languages;
            _this.events.initialized.next(options);
        });
        i18next.on.call(i18next, 'loaded', function (loaded) { return _this.events.loaded.next(loaded); });
        i18next.on.call(i18next, 'failedLoading', function (lng, ns, msg) { return _this.events.failedLoading.next({ lng: lng, ns: ns, msg: msg }); });
        i18next.on.call(i18next, 'languageChanged', function (lng) {
            _this.language = i18next.language;
            _this.languages = i18next.languages;
            _this.events.languageChanged.next(lng);
        });
        i18next.on.call(i18next, 'missingKey', function (lngs, namespace, key, res) { return _this.events.missingKey.next({ lngs: lngs, namespace: namespace, key: key, res: res }); });
        i18next.on.call(i18next, 'added', function (lng, ns) { return _this.events.added.next({ lng: lng, ns: ns }); });
        i18next.on.call(i18next, 'removed', function (lng, ns) { return _this.events.removed.next({ lng: lng, ns: ns }); });
    };
    I18NextService = tslib_1.__decorate([
        Injectable(),
        tslib_1.__param(0, Inject(I18NEXT_ERROR_HANDLING_STRATEGY)),
        tslib_1.__metadata("design:paramtypes", [Object])
    ], I18NextService);
    return I18NextService;
}());
export { I18NextService };
//# sourceMappingURL=data:application/json;base64,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