import { __decorate, __param, __metadata } from 'tslib';
import { InjectionToken, Injectable, Pipe, Inject, NgModule } from '@angular/core';
import i18n__default from 'i18next';
import { BehaviorSubject, Subject } from 'rxjs';
import { DOCUMENT } from '@angular/common';
import { Title } from '@angular/platform-browser';

const I18NEXT_SCOPE = new InjectionToken('I18NEXT_SCOPE');
const I18NEXT_NAMESPACE = new InjectionToken('I18NEXT_NAMESPACE');
const I18NEXT_SERVICE = new InjectionToken('I18NEXT_SERVICE');
const I18NEXT_NAMESPACE_RESOLVER = new InjectionToken('I18NEXT_NAMESPACE_RESOLVER');
const I18NEXT_ERROR_HANDLING_STRATEGY = new InjectionToken('I18NEXT_ERROR_HANDLING_STRATEGY');

let I18NextPipe = class I18NextPipe {
    constructor(translateI18Next, ns, scope) {
        this.translateI18Next = translateI18Next;
        this.ns = ns;
        this.scope = scope;
    }
    transform(key, options) {
        options = this.prepareOptions(options);
        let i18nOpts = this.translateI18Next.options;
        if (options.prependScope === undefined || options.prependScope === true) {
            if (this.scope) {
                key = this.prependScope(key, this.scope, i18nOpts.keySeparator, i18nOpts.nsSeparator);
            }
        }
        if (options.prependNamespace === undefined || options.prependNamespace === true) {
            if (this.ns) {
                key = this.prependNamespace(key, this.ns, i18nOpts.nsSeparator);
            }
        }
        let result = this.translateI18Next.t(key, options);
        if (options.format) {
            if (result) {
                result = this.translateI18Next
                    .format(result, options.format, this.translateI18Next.language);
            }
        }
        return result;
    }
    prependScope(key, scope, keySeparator, nsSeparator) {
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (scope) === 'string') {
            scope = [scope];
        }
        let keysWithScope = [];
        for (let i = 0; i < key.length; i++) {
            const k = key[i];
            if (!this.keyContainsNsSeparator(k, nsSeparator)) { // Do not set scope, if key contains a namespace
                keysWithScope.push(...scope.map(sc => this.joinStrings(keySeparator, sc, k)));
            }
            keysWithScope.push(k);
        }
        return keysWithScope;
    }
    prependNamespace(key, ns, nsSeparator) {
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (ns) === 'string') {
            ns = [ns];
        }
        let keysWithNamespace = [];
        for (let i = 0; i < key.length; i++) {
            const k = key[i];
            if (!this.keyContainsNsSeparator(k, nsSeparator)) { // Do not set namespace, if key contains a namespace
                keysWithNamespace.push(...ns.map(n => this.joinStrings(nsSeparator, n, k)));
            }
            keysWithNamespace.push(k);
        }
        return keysWithNamespace;
    }
    joinStrings(separator, ...str) {
        return [...str].join(separator);
    }
    keyContainsNsSeparator(key, nsSeparator) {
        return key.indexOf(nsSeparator) !== -1;
    }
    prepareOptions(options) {
        options = options || {};
        if (options.context != null)
            options.context = options.context.toString();
        return options;
    }
};
I18NextPipe = __decorate([
    Injectable(),
    Pipe({
        name: 'i18next'
    }),
    __param(0, Inject(I18NEXT_SERVICE)),
    __param(1, Inject(I18NEXT_NAMESPACE)),
    __param(2, Inject(I18NEXT_SCOPE)),
    __metadata("design:paramtypes", [Object, Object, Object])
], I18NextPipe);

let I18NextCapPipe = class I18NextCapPipe extends I18NextPipe {
    constructor(translateI18Next, ns, scope) {
        super(translateI18Next, ns, scope);
    }
    transform(key, options) {
        options = options || {};
        options.format = 'cap';
        return super.transform(key, options);
    }
};
I18NextCapPipe = __decorate([
    Injectable(),
    Pipe({
        name: 'i18nextCap'
    }),
    __param(0, Inject(I18NEXT_SERVICE)),
    __param(1, Inject(I18NEXT_NAMESPACE)),
    __param(2, Inject(I18NEXT_SCOPE)),
    __metadata("design:paramtypes", [Object, Object, Object])
], I18NextCapPipe);

class NativeErrorHandlingStrategy {
    handle(resolve, reject) {
        return (err, t) => {
            let result = {
                err: err,
                t: t
            };
            resolve(result);
        };
    }
}
class StrictErrorHandlingStrategy {
    handle(resolve, reject) {
        return (err, t) => {
            let result = {
                err: err,
                t: t
            };
            if (!err) {
                resolve(result);
                return;
            }
            reject(err);
        };
    }
}

let I18NextFormatPipe = class I18NextFormatPipe {
    constructor(translateI18Next) {
        this.translateI18Next = translateI18Next;
    }
    transform(value, options) {
        let opts = typeof (options) === 'string' ? { format: options } : options;
        return this.translateI18Next.format(value, opts.format, opts.lng);
    }
};
I18NextFormatPipe = __decorate([
    Injectable(),
    Pipe({
        name: 'i18nextFormat'
    }),
    __param(0, Inject(I18NEXT_SERVICE)),
    __metadata("design:paramtypes", [Object])
], I18NextFormatPipe);

class I18NextEvents {
    constructor() {
        this.initialized = new BehaviorSubject(false);
        this.loaded = new BehaviorSubject(false);
        this.failedLoading = new Subject();
        this.missingKey = new Subject();
        this.added = new Subject();
        this.removed = new Subject();
        this.languageChanged = new BehaviorSubject(null);
    }
}

const i18next = i18n__default;
let I18NextService = class I18NextService {
    constructor(errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.events = new I18NextEvents();
        this.language = '';
        this.languages = [];
    }
    get options() {
        return i18next.options;
    }
    use(plugin) {
        i18next.use.call(i18next, plugin);
        return this;
    }
    init(options) {
        options = options || {};
        this.subscribeEvents();
        return new Promise((resolve, reject) => {
            i18next.init.call(i18next, Object.assign({}, options), this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    t(key, options) {
        options = options || {};
        return i18next.t.call(i18next, key, options);
    }
    format(value, format, lng) {
        return i18next.format.call(i18next, value, format, lng);
    }
    exists(key, options) {
        return i18next.exists.call(i18next, key, options);
    }
    getFixedT(lng, ns) {
        return i18next.getFixedT.call(i18next, lng, ns);
    }
    setDefaultNamespace(ns) {
        i18next.setDefaultNamespace.call(i18next, ns);
    }
    dir(lng = undefined) {
        return i18next.dir.call(i18next, lng);
    }
    changeLanguage(lng) {
        return new Promise((resolve, reject) => {
            i18next.changeLanguage.call(i18next, lng, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    loadNamespaces(namespaces) {
        return new Promise((resolve, reject) => {
            i18next.loadNamespaces.call(i18next, namespaces, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    loadLanguages(lngs, callback) {
        return new Promise((resolve, reject) => {
            i18next.loadLanguages.call(i18next, lngs, this.errorHandlingStrategy.handle(resolve, reject));
        });
    }
    //#region resource handling
    reloadResources(...params) {
        i18next.reloadResources.apply(i18next, params);
    }
    getResource(lng, ns, key, options) {
        return i18next.getResource.call(i18next, lng, ns, key, options);
    }
    addResource(lng, ns, key, value, options) {
        i18next.addResource.call(i18next, lng, ns, key, value, options);
    }
    addResources(lng, ns, resources) {
        i18next.addResources.call(i18next, lng, ns, resources);
    }
    addResourceBundle(lng, ns, resources, deep, overwrite) {
        i18next.addResourceBundle.call(i18next, lng, ns, resources, deep, overwrite);
    }
    hasResourceBundle(lng, ns) {
        return i18next.hasResourceBundle.call(i18next, lng, ns);
    }
    getResourceBundle(lng, ns) {
        return i18next.getResourceBundle.call(i18next, lng, ns);
    }
    removeResourceBundle(lng, ns) {
        i18next.removeResourceBundle.call(i18next, lng, ns);
    }
    //#endregion
    subscribeEvents() {
        i18next.on.call(i18next, 'initialized', options => {
            this.language = i18next.language;
            this.languages = i18next.languages;
            this.events.initialized.next(options);
        });
        i18next.on.call(i18next, 'loaded', loaded => this.events.loaded.next(loaded));
        i18next.on.call(i18next, 'failedLoading', (lng, ns, msg) => this.events.failedLoading.next({ lng, ns, msg }));
        i18next.on.call(i18next, 'languageChanged', lng => {
            this.language = i18next.language;
            this.languages = i18next.languages;
            this.events.languageChanged.next(lng);
        });
        i18next.on.call(i18next, 'missingKey', (lngs, namespace, key, res) => this.events.missingKey.next({ lngs, namespace, key, res }));
        i18next.on.call(i18next, 'added', (lng, ns) => this.events.added.next({ lng, ns }));
        i18next.on.call(i18next, 'removed', (lng, ns) => this.events.removed.next({ lng, ns }));
    }
};
I18NextService = __decorate([
    Injectable(),
    __param(0, Inject(I18NEXT_ERROR_HANDLING_STRATEGY)),
    __metadata("design:paramtypes", [Object])
], I18NextService);

let I18NextTitle = class I18NextTitle extends Title {
    constructor(i18nextPipe, doc) {
        super(doc);
        this.i18nextPipe = i18nextPipe;
    }
    setTitle(value) {
        return super.setTitle(this.translate(value));
    }
    translate(text) {
        return this.i18nextPipe.transform(text, { format: 'cap' });
    }
};
I18NextTitle = __decorate([
    Injectable(),
    __param(1, Inject(DOCUMENT)),
    __metadata("design:paramtypes", [I18NextPipe, Object])
], I18NextTitle);

var I18NextModule_1;
function resolver(activatedRouteSnapshot, routerStateSnapshot) {
    let namespaces = [];
    namespaces = activatedRouteSnapshot.data && activatedRouteSnapshot.data.i18nextNamespaces || namespaces;
    return this.loadNamespaces(namespaces.filter(n => n));
}
function i18nextNamespaceResolverFactory(i18next) {
    return resolver.bind(i18next);
}
let I18NextModule = I18NextModule_1 = class I18NextModule {
    static forRoot(params = {}) {
        return {
            ngModule: I18NextModule_1,
            providers: [
                {
                    provide: I18NEXT_SERVICE,
                    useClass: I18NextService
                },
                {
                    provide: I18NEXT_ERROR_HANDLING_STRATEGY,
                    useClass: params.errorHandlingStrategy || NativeErrorHandlingStrategy
                },
                I18NextService,
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle,
                {
                    provide: I18NEXT_NAMESPACE_RESOLVER,
                    useFactory: i18nextNamespaceResolverFactory,
                    deps: [I18NEXT_SERVICE]
                }
            ]
        };
    }
    static interpolationFormat(customFormat = null) {
        function formatDelegate(value, format, lng) {
            let formatedValue = defaultInterpolationFormat(value, format, lng);
            if (customFormat === null)
                return formatedValue;
            return customFormat(formatedValue, format, lng);
        }
        return formatDelegate;
    }
};
I18NextModule = I18NextModule_1 = __decorate([
    NgModule({
        providers: [
            {
                provide: I18NEXT_NAMESPACE,
                useValue: ''
            },
            {
                provide: I18NEXT_SCOPE,
                useValue: ''
            },
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe,
            I18NextTitle
        ],
        declarations: [
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe
        ],
        exports: [
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe
        ]
    })
], I18NextModule);
function defaultInterpolationFormat(value, format, lng = undefined) {
    if (!value)
        return value;
    switch (format) {
        case 'upper':
        case 'uppercase':
            return value.toUpperCase();
        case 'lower':
        case 'lowercase':
            return value.toLowerCase();
        case 'cap':
        case 'capitalize':
            return value.charAt(0).toUpperCase() + value.slice(1);
        case null:
        case undefined:
        case 'none':
        default:
            return value;
    }
}

/**
 * Generated bundle index. Do not edit.
 */

export { I18NEXT_ERROR_HANDLING_STRATEGY, I18NEXT_NAMESPACE, I18NEXT_NAMESPACE_RESOLVER, I18NEXT_SCOPE, I18NEXT_SERVICE, I18NextCapPipe, I18NextFormatPipe, I18NextModule, I18NextPipe, I18NextService, I18NextTitle, NativeErrorHandlingStrategy, StrictErrorHandlingStrategy, defaultInterpolationFormat, i18nextNamespaceResolverFactory, resolver };
//# sourceMappingURL=angular-i18next.js.map
