import { __spread, __decorate, __param, __metadata, __extends } from 'tslib';
import { InjectionToken, Injectable, Pipe, Inject, NgModule } from '@angular/core';
import i18n__default from 'i18next';
import { BehaviorSubject, Subject } from 'rxjs';
import { DOCUMENT } from '@angular/common';
import { Title } from '@angular/platform-browser';

var I18NEXT_SCOPE = new InjectionToken('I18NEXT_SCOPE');
var I18NEXT_NAMESPACE = new InjectionToken('I18NEXT_NAMESPACE');
var I18NEXT_SERVICE = new InjectionToken('I18NEXT_SERVICE');
var I18NEXT_NAMESPACE_RESOLVER = new InjectionToken('I18NEXT_NAMESPACE_RESOLVER');
var I18NEXT_ERROR_HANDLING_STRATEGY = new InjectionToken('I18NEXT_ERROR_HANDLING_STRATEGY');

var I18NextPipe = /** @class */ (function () {
    function I18NextPipe(translateI18Next, ns, scope) {
        this.translateI18Next = translateI18Next;
        this.ns = ns;
        this.scope = scope;
    }
    I18NextPipe.prototype.transform = function (key, options) {
        options = this.prepareOptions(options);
        var i18nOpts = this.translateI18Next.options;
        if (options.prependScope === undefined || options.prependScope === true) {
            if (this.scope) {
                key = this.prependScope(key, this.scope, i18nOpts.keySeparator, i18nOpts.nsSeparator);
            }
        }
        if (options.prependNamespace === undefined || options.prependNamespace === true) {
            if (this.ns) {
                key = this.prependNamespace(key, this.ns, i18nOpts.nsSeparator);
            }
        }
        var result = this.translateI18Next.t(key, options);
        if (options.format) {
            if (result) {
                result = this.translateI18Next
                    .format(result, options.format, this.translateI18Next.language);
            }
        }
        return result;
    };
    I18NextPipe.prototype.prependScope = function (key, scope, keySeparator, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (scope) === 'string') {
            scope = [scope];
        }
        var keysWithScope = [];
        var _loop_1 = function (i) {
            var k = key[i];
            if (!this_1.keyContainsNsSeparator(k, nsSeparator)) { // Do not set scope, if key contains a namespace
                keysWithScope.push.apply(// Do not set scope, if key contains a namespace
                keysWithScope, __spread(scope.map(function (sc) { return _this.joinStrings(keySeparator, sc, k); })));
            }
            keysWithScope.push(k);
        };
        var this_1 = this;
        for (var i = 0; i < key.length; i++) {
            _loop_1(i);
        }
        return keysWithScope;
    };
    I18NextPipe.prototype.prependNamespace = function (key, ns, nsSeparator) {
        var _this = this;
        if (typeof (key) === 'string') {
            key = [key];
        }
        if (typeof (ns) === 'string') {
            ns = [ns];
        }
        var keysWithNamespace = [];
        var _loop_2 = function (i) {
            var k = key[i];
            if (!this_2.keyContainsNsSeparator(k, nsSeparator)) { // Do not set namespace, if key contains a namespace
                keysWithNamespace.push.apply(// Do not set namespace, if key contains a namespace
                keysWithNamespace, __spread(ns.map(function (n) { return _this.joinStrings(nsSeparator, n, k); })));
            }
            keysWithNamespace.push(k);
        };
        var this_2 = this;
        for (var i = 0; i < key.length; i++) {
            _loop_2(i);
        }
        return keysWithNamespace;
    };
    I18NextPipe.prototype.joinStrings = function (separator) {
        var str = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            str[_i - 1] = arguments[_i];
        }
        return __spread(str).join(separator);
    };
    I18NextPipe.prototype.keyContainsNsSeparator = function (key, nsSeparator) {
        return key.indexOf(nsSeparator) !== -1;
    };
    I18NextPipe.prototype.prepareOptions = function (options) {
        options = options || {};
        if (options.context != null)
            options.context = options.context.toString();
        return options;
    };
    I18NextPipe = __decorate([
        Injectable(),
        Pipe({
            name: 'i18next'
        }),
        __param(0, Inject(I18NEXT_SERVICE)),
        __param(1, Inject(I18NEXT_NAMESPACE)),
        __param(2, Inject(I18NEXT_SCOPE)),
        __metadata("design:paramtypes", [Object, Object, Object])
    ], I18NextPipe);
    return I18NextPipe;
}());

var I18NextCapPipe = /** @class */ (function (_super) {
    __extends(I18NextCapPipe, _super);
    function I18NextCapPipe(translateI18Next, ns, scope) {
        return _super.call(this, translateI18Next, ns, scope) || this;
    }
    I18NextCapPipe.prototype.transform = function (key, options) {
        options = options || {};
        options.format = 'cap';
        return _super.prototype.transform.call(this, key, options);
    };
    I18NextCapPipe = __decorate([
        Injectable(),
        Pipe({
            name: 'i18nextCap'
        }),
        __param(0, Inject(I18NEXT_SERVICE)),
        __param(1, Inject(I18NEXT_NAMESPACE)),
        __param(2, Inject(I18NEXT_SCOPE)),
        __metadata("design:paramtypes", [Object, Object, Object])
    ], I18NextCapPipe);
    return I18NextCapPipe;
}(I18NextPipe));

var NativeErrorHandlingStrategy = /** @class */ (function () {
    function NativeErrorHandlingStrategy() {
    }
    NativeErrorHandlingStrategy.prototype.handle = function (resolve, reject) {
        return function (err, t) {
            var result = {
                err: err,
                t: t
            };
            resolve(result);
        };
    };
    return NativeErrorHandlingStrategy;
}());
var StrictErrorHandlingStrategy = /** @class */ (function () {
    function StrictErrorHandlingStrategy() {
    }
    StrictErrorHandlingStrategy.prototype.handle = function (resolve, reject) {
        return function (err, t) {
            var result = {
                err: err,
                t: t
            };
            if (!err) {
                resolve(result);
                return;
            }
            reject(err);
        };
    };
    return StrictErrorHandlingStrategy;
}());

var I18NextFormatPipe = /** @class */ (function () {
    function I18NextFormatPipe(translateI18Next) {
        this.translateI18Next = translateI18Next;
    }
    I18NextFormatPipe.prototype.transform = function (value, options) {
        var opts = typeof (options) === 'string' ? { format: options } : options;
        return this.translateI18Next.format(value, opts.format, opts.lng);
    };
    I18NextFormatPipe = __decorate([
        Injectable(),
        Pipe({
            name: 'i18nextFormat'
        }),
        __param(0, Inject(I18NEXT_SERVICE)),
        __metadata("design:paramtypes", [Object])
    ], I18NextFormatPipe);
    return I18NextFormatPipe;
}());

var I18NextEvents = /** @class */ (function () {
    function I18NextEvents() {
        this.initialized = new BehaviorSubject(false);
        this.loaded = new BehaviorSubject(false);
        this.failedLoading = new Subject();
        this.missingKey = new Subject();
        this.added = new Subject();
        this.removed = new Subject();
        this.languageChanged = new BehaviorSubject(null);
    }
    return I18NextEvents;
}());

var i18next = i18n__default;
var I18NextService = /** @class */ (function () {
    function I18NextService(errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.events = new I18NextEvents();
        this.language = '';
        this.languages = [];
    }
    Object.defineProperty(I18NextService.prototype, "options", {
        get: function () {
            return i18next.options;
        },
        enumerable: true,
        configurable: true
    });
    I18NextService.prototype.use = function (plugin) {
        i18next.use.call(i18next, plugin);
        return this;
    };
    I18NextService.prototype.init = function (options) {
        var _this = this;
        options = options || {};
        this.subscribeEvents();
        return new Promise(function (resolve, reject) {
            i18next.init.call(i18next, Object.assign({}, options), _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.t = function (key, options) {
        options = options || {};
        return i18next.t.call(i18next, key, options);
    };
    I18NextService.prototype.format = function (value, format, lng) {
        return i18next.format.call(i18next, value, format, lng);
    };
    I18NextService.prototype.exists = function (key, options) {
        return i18next.exists.call(i18next, key, options);
    };
    I18NextService.prototype.getFixedT = function (lng, ns) {
        return i18next.getFixedT.call(i18next, lng, ns);
    };
    I18NextService.prototype.setDefaultNamespace = function (ns) {
        i18next.setDefaultNamespace.call(i18next, ns);
    };
    I18NextService.prototype.dir = function (lng) {
        if (lng === void 0) { lng = undefined; }
        return i18next.dir.call(i18next, lng);
    };
    I18NextService.prototype.changeLanguage = function (lng) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.changeLanguage.call(i18next, lng, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.loadNamespaces = function (namespaces) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.loadNamespaces.call(i18next, namespaces, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    I18NextService.prototype.loadLanguages = function (lngs, callback) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            i18next.loadLanguages.call(i18next, lngs, _this.errorHandlingStrategy.handle(resolve, reject));
        });
    };
    //#region resource handling
    I18NextService.prototype.reloadResources = function () {
        var params = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            params[_i] = arguments[_i];
        }
        i18next.reloadResources.apply(i18next, params);
    };
    I18NextService.prototype.getResource = function (lng, ns, key, options) {
        return i18next.getResource.call(i18next, lng, ns, key, options);
    };
    I18NextService.prototype.addResource = function (lng, ns, key, value, options) {
        i18next.addResource.call(i18next, lng, ns, key, value, options);
    };
    I18NextService.prototype.addResources = function (lng, ns, resources) {
        i18next.addResources.call(i18next, lng, ns, resources);
    };
    I18NextService.prototype.addResourceBundle = function (lng, ns, resources, deep, overwrite) {
        i18next.addResourceBundle.call(i18next, lng, ns, resources, deep, overwrite);
    };
    I18NextService.prototype.hasResourceBundle = function (lng, ns) {
        return i18next.hasResourceBundle.call(i18next, lng, ns);
    };
    I18NextService.prototype.getResourceBundle = function (lng, ns) {
        return i18next.getResourceBundle.call(i18next, lng, ns);
    };
    I18NextService.prototype.removeResourceBundle = function (lng, ns) {
        i18next.removeResourceBundle.call(i18next, lng, ns);
    };
    //#endregion
    I18NextService.prototype.subscribeEvents = function () {
        var _this = this;
        i18next.on.call(i18next, 'initialized', function (options) {
            _this.language = i18next.language;
            _this.languages = i18next.languages;
            _this.events.initialized.next(options);
        });
        i18next.on.call(i18next, 'loaded', function (loaded) { return _this.events.loaded.next(loaded); });
        i18next.on.call(i18next, 'failedLoading', function (lng, ns, msg) { return _this.events.failedLoading.next({ lng: lng, ns: ns, msg: msg }); });
        i18next.on.call(i18next, 'languageChanged', function (lng) {
            _this.language = i18next.language;
            _this.languages = i18next.languages;
            _this.events.languageChanged.next(lng);
        });
        i18next.on.call(i18next, 'missingKey', function (lngs, namespace, key, res) { return _this.events.missingKey.next({ lngs: lngs, namespace: namespace, key: key, res: res }); });
        i18next.on.call(i18next, 'added', function (lng, ns) { return _this.events.added.next({ lng: lng, ns: ns }); });
        i18next.on.call(i18next, 'removed', function (lng, ns) { return _this.events.removed.next({ lng: lng, ns: ns }); });
    };
    I18NextService = __decorate([
        Injectable(),
        __param(0, Inject(I18NEXT_ERROR_HANDLING_STRATEGY)),
        __metadata("design:paramtypes", [Object])
    ], I18NextService);
    return I18NextService;
}());

var I18NextTitle = /** @class */ (function (_super) {
    __extends(I18NextTitle, _super);
    function I18NextTitle(i18nextPipe, doc) {
        var _this = _super.call(this, doc) || this;
        _this.i18nextPipe = i18nextPipe;
        return _this;
    }
    I18NextTitle.prototype.setTitle = function (value) {
        return _super.prototype.setTitle.call(this, this.translate(value));
    };
    I18NextTitle.prototype.translate = function (text) {
        return this.i18nextPipe.transform(text, { format: 'cap' });
    };
    I18NextTitle = __decorate([
        Injectable(),
        __param(1, Inject(DOCUMENT)),
        __metadata("design:paramtypes", [I18NextPipe, Object])
    ], I18NextTitle);
    return I18NextTitle;
}(Title));

function resolver(activatedRouteSnapshot, routerStateSnapshot) {
    var namespaces = [];
    namespaces = activatedRouteSnapshot.data && activatedRouteSnapshot.data.i18nextNamespaces || namespaces;
    return this.loadNamespaces(namespaces.filter(function (n) { return n; }));
}
function i18nextNamespaceResolverFactory(i18next) {
    return resolver.bind(i18next);
}
var I18NextModule = /** @class */ (function () {
    function I18NextModule() {
    }
    I18NextModule_1 = I18NextModule;
    I18NextModule.forRoot = function (params) {
        if (params === void 0) { params = {}; }
        return {
            ngModule: I18NextModule_1,
            providers: [
                {
                    provide: I18NEXT_SERVICE,
                    useClass: I18NextService
                },
                {
                    provide: I18NEXT_ERROR_HANDLING_STRATEGY,
                    useClass: params.errorHandlingStrategy || NativeErrorHandlingStrategy
                },
                I18NextService,
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle,
                {
                    provide: I18NEXT_NAMESPACE_RESOLVER,
                    useFactory: i18nextNamespaceResolverFactory,
                    deps: [I18NEXT_SERVICE]
                }
            ]
        };
    };
    I18NextModule.interpolationFormat = function (customFormat) {
        if (customFormat === void 0) { customFormat = null; }
        function formatDelegate(value, format, lng) {
            var formatedValue = defaultInterpolationFormat(value, format);
            if (customFormat === null)
                return formatedValue;
            return customFormat(formatedValue, format, lng);
        }
        return formatDelegate;
    };
    var I18NextModule_1;
    I18NextModule = I18NextModule_1 = __decorate([
        NgModule({
            providers: [
                {
                    provide: I18NEXT_NAMESPACE,
                    useValue: ''
                },
                {
                    provide: I18NEXT_SCOPE,
                    useValue: ''
                },
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle
            ],
            declarations: [
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe
            ],
            exports: [
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe
            ]
        })
    ], I18NextModule);
    return I18NextModule;
}());
function defaultInterpolationFormat(value, format, lng) {
    if (!value)
        return value;
    switch (format) {
        case 'upper':
        case 'uppercase':
            return value.toUpperCase();
        case 'lower':
        case 'lowercase':
            return value.toLowerCase();
        case 'cap':
        case 'capitalize':
            return value.charAt(0).toUpperCase() + value.slice(1);
        case null:
        case undefined:
        case 'none':
        default:
            return value;
    }
}

/**
 * Generated bundle index. Do not edit.
 */

export { I18NEXT_ERROR_HANDLING_STRATEGY, I18NEXT_NAMESPACE, I18NEXT_NAMESPACE_RESOLVER, I18NEXT_SCOPE, I18NEXT_SERVICE, I18NextCapPipe, I18NextFormatPipe, I18NextModule, I18NextPipe, I18NextService, I18NextTitle, NativeErrorHandlingStrategy, StrictErrorHandlingStrategy, defaultInterpolationFormat, i18nextNamespaceResolverFactory, resolver };
//# sourceMappingURL=angular-i18next.js.map
