/*!
 * DevExpress Diagram (dx-diagram)
 * Version: 0.1.31
 * Build date: Thu Oct 10 2019
 * 
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExpress licensing here: https://www.devexpress.com/Support/EULAs
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["diagram"] = factory();
	else
		root["DevExpress"] = root["DevExpress"] || {}, root["DevExpress"]["diagram"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 10);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Size = /** @class */ (function () {
    function Size(width, height) {
        this.width = width;
        this.height = height;
    }
    Size.prototype.clone = function () { return new Size(this.width, this.height); };
    Size.prototype.toString = function () { return JSON.stringify(this); };
    Size.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new Size(Math.max(0, this.width + offsetX), Math.max(0, this.height + offsetY));
    };
    Size.prototype.multiply = function (multiplierW, multiplierH) {
        if (multiplierW === void 0) { multiplierW = 1; }
        if (multiplierH === void 0) { multiplierH = multiplierW; }
        return new Size(this.width * multiplierW, this.height * multiplierH);
    };
    Size.prototype.equals = function (size) {
        return size.width === this.width && size.height === this.height;
    };
    Size.prototype.transform = function (func) {
        return new Size(func(this.width), func(this.height));
    };
    return Size;
}());
exports.Size = Size;
var Point = /** @class */ (function () {
    function Point(x, y) {
        this.x = x;
        this.y = y;
    }
    Point.prototype.clone = function () { return new Point(this.x, this.y); };
    Point.prototype.toString = function () { return JSON.stringify(this); };
    Point.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new Point(this.x + offsetX, this.y + offsetY);
    };
    Point.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new Point(this.x * multiplierX, this.y * multiplierY);
    };
    Point.prototype.equals = function (pt) {
        return pt.x === this.x && pt.y === this.y;
    };
    Point.prototype.transform = function (func) {
        return new Point(func(this.x), func(this.y));
    };
    Point.empty = function () {
        return new Point(0, 0);
    };
    Point.plus = function (a, b) {
        return new Point(a.x + b.x, a.y + b.y);
    };
    Point.minus = function (a, b) {
        return new Point(a.x - b.x, a.y - b.y);
    };
    return Point;
}());
exports.Point = Point;
var Offset = /** @class */ (function () {
    function Offset(left, top, right, bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }
    Object.defineProperty(Offset.prototype, "horizontal", {
        get: function () { return this.left + this.right; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Offset.prototype, "vertical", {
        get: function () { return this.top + this.bottom; },
        enumerable: true,
        configurable: true
    });
    Offset.prototype.clone = function () { return new Offset(this.left, this.top, this.right, this.bottom); };
    Offset.prototype.transform = function (func) {
        return new Offset(func(this.left), func(this.top), func(this.right), func(this.bottom));
    };
    Offset.prototype.offset = function (offset, increase) {
        var clone = this.clone();
        if (increase) {
            clone.left += offset.left;
            clone.right += offset.right;
            clone.top += offset.top;
            clone.bottom += offset.bottom;
        }
        else {
            clone.left -= offset.left;
            clone.right -= offset.right;
            clone.top -= offset.top;
            clone.bottom -= offset.bottom;
        }
        return clone;
    };
    Offset.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new Offset(this.left * multiplierX, this.top * multiplierY, this.right * multiplierX, this.bottom * multiplierY);
    };
    Offset.prototype.isEmpty = function () {
        return this.left === 0 && this.right === 0 && this.top === 0 && this.bottom === 0;
    };
    Offset.prototype.equals = function (offset) {
        return this.left === offset.left && this.top === offset.top && this.right === offset.right && this.bottom === offset.bottom;
    };
    Offset.prototype.toString = function () {
        return "left: " + this.left + " top: " + this.top + " right: " + this.right + " bottom: " + this.bottom;
    };
    Offset.empty = function () {
        return new Offset(0, 0, 0, 0);
    };
    Offset.fromNumber = function (offset) {
        return new Offset(offset, offset, offset, offset);
    };
    Offset.fromSide = function (horizontal, vertical) {
        return new Offset(horizontal, vertical, horizontal, vertical);
    };
    return Offset;
}());
exports.Offset = Offset;
var Rectangle = /** @class */ (function () {
    function Rectangle(position, size) {
        this.position = position;
        this.size = size;
    }
    Object.defineProperty(Rectangle.prototype, "left", {
        get: function () {
            return this.position.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "top", {
        get: function () {
            return this.position.y;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "right", {
        get: function () {
            return this.position.x + this.size.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "bottom", {
        get: function () {
            return this.position.y + this.size.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "center", {
        get: function () {
            return new Point(this.position.x + this.size.width / 2, this.position.y + this.size.height / 2);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "width", {
        get: function () {
            return this.size.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "height", {
        get: function () {
            return this.size.height;
        },
        enumerable: true,
        configurable: true
    });
    Rectangle.prototype.clone = function () { return new Rectangle(this.position.clone(), this.size.clone()); };
    Rectangle.prototype.toString = function () { return JSON.stringify(this); };
    Rectangle.prototype.contains = function (point) {
        return this.left <= point.x && point.x <= this.right &&
            this.top <= point.y && point.y <= this.bottom;
    };
    Rectangle.prototype.intersectX = function (rect) {
        if (this.left > rect.right || rect.left > this.right)
            return false;
        return true;
    };
    Rectangle.prototype.intersectY = function (rect) {
        if (this.top > rect.bottom || rect.top > this.bottom)
            return false;
        return true;
    };
    Rectangle.prototype.intersect = function (rect) {
        return this.intersectX(rect) && this.intersectY(rect);
    };
    Rectangle.prototype.inflate = function (deltaX, deltaY) {
        deltaY = deltaY === undefined ? deltaX : deltaY;
        return new Rectangle(this.position.offset(-deltaX, -deltaY), this.size.offset(2 * deltaX, 2 * deltaY));
    };
    Rectangle.prototype.resize = function (deltaX, deltaY) {
        return new Rectangle(this.position, this.size.offset(deltaX, deltaY));
    };
    Rectangle.prototype.offset = function (offsetX, offsetY) {
        return new Rectangle(this.position.offset(offsetX, offsetY), this.size);
    };
    Rectangle.prototype.multiply = function (multiplier) {
        return new Rectangle(this.position.multiply(multiplier), this.size.multiply(multiplier));
    };
    Rectangle.prototype.equals = function (rect) {
        return this.left === rect.left && this.top === rect.top && this.width === rect.width && this.height === rect.height;
    };
    Rectangle.prototype.transform = function (func) {
        return new Rectangle(this.position.transform(func), this.size.transform(func));
    };
    Rectangle.create = function (x, y, width, height) {
        return new Rectangle(new Point(x, y), new Size(width, height));
    };
    Rectangle.createByPoints = function (point1, point2) {
        return Rectangle.createByPositions(point1.x, point1.y, point2.x, point2.y);
    };
    Rectangle.createByPositions = function (x1, y1, x2, y2) {
        var x = Math.min(x1, x2);
        var y = Math.min(y1, y2);
        var width = Math.abs(x2 - x1);
        var height = Math.abs(y2 - y1);
        return Rectangle.create(x, y, width, height);
    };
    return Rectangle;
}());
exports.Rectangle = Rectangle;
var Segment = /** @class */ (function () {
    function Segment(startPoint, endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }
    Object.defineProperty(Segment.prototype, "distance", {
        get: function () {
            return GeometryUtils.getDistance(this.startPoint, this.endPoint);
        },
        enumerable: true,
        configurable: true
    });
    Segment.prototype.intersect = function (segment) {
        if (this.startPoint.equals(segment.startPoint) || this.endPoint.equals(segment.startPoint) ||
            this.startPoint.equals(segment.endPoint) || this.endPoint.equals(segment.endPoint))
            return true;
        return this.intersectCore(segment) && segment.intersectCore(this);
    };
    Segment.prototype.intersectRect = function (rectangle) {
        var ltPt = rectangle.position, lbPt = new Point(rectangle.left, rectangle.bottom), rtPt = new Point(rectangle.right, rectangle.top), rbPt = new Point(rectangle.right, rectangle.bottom);
        return rectangle.contains(this.startPoint) || rectangle.contains(this.endPoint) ||
            this.intersect(new Segment(ltPt, lbPt)) || this.intersect(new Segment(lbPt, rbPt)) ||
            this.intersect(new Segment(rbPt, rtPt)) || this.intersect(new Segment(rtPt, ltPt));
    };
    Segment.prototype.intersectCore = function (segment) {
        if (this.startPoint.x === this.endPoint.x) {
            if (this.startPoint.x - segment.endPoint.x !== 0)
                return (this.startPoint.x - segment.startPoint.x) / (this.startPoint.x - segment.endPoint.x) <= 0;
            if (segment.endPoint.y - this.endPoint.y !== 0)
                return (segment.endPoint.y - this.startPoint.y) / (segment.endPoint.y - this.endPoint.y) <= 0;
        }
        if (this.startPoint.y === this.endPoint.y) {
            if (this.startPoint.y - segment.endPoint.y !== 0)
                return (this.startPoint.y - segment.startPoint.y) / (this.startPoint.y - segment.endPoint.y) <= 0;
            if (segment.endPoint.x - this.endPoint.x !== 0)
                return (segment.endPoint.x - this.startPoint.x) / (segment.endPoint.x - this.endPoint.x) <= 0;
        }
        var tg = (this.endPoint.y - this.startPoint.y) / (this.endPoint.x - this.startPoint.x);
        var y1 = this.startPoint.y + (segment.startPoint.x - this.startPoint.x) * tg;
        var y2 = this.startPoint.y + (segment.endPoint.x - this.startPoint.x) * tg;
        var dy1 = segment.startPoint.y - y1;
        var dy2 = segment.endPoint.y - y2;
        if (dy1 === 0 && dy2 === 0) {
            return (this.startPoint.y - y1) / (this.endPoint.y - y1) <= 0 ||
                (this.startPoint.y - y2) / (this.endPoint.y - y2) <= 0;
        }
        return dy1 === 0 || dy2 === 0 || dy1 / dy2 < 0;
    };
    Segment.create = function (x1, y1, x2, y2) {
        return new Segment(new Point(x1, y1), new Point(x2, y2));
    };
    Segment.createByPoints = function (point1, point2) {
        return Segment.create(point1.x, point1.y, point2.x, point2.y);
    };
    return Segment;
}());
exports.Segment = Segment;
var EventDispatcher = /** @class */ (function () {
    function EventDispatcher() {
        this.listeners = [];
    }
    EventDispatcher.prototype.add = function (listener) {
        if (!listener)
            throw new Error("Not Implemented");
        if (!this.hasEventListener(listener))
            this.listeners.push(listener);
    };
    EventDispatcher.prototype.remove = function (listener) {
        for (var i = 0, currentListener; currentListener = this.listeners[i]; i++) {
            if (currentListener === listener) {
                this.listeners.splice(i, 1);
                break;
            }
        }
    };
    EventDispatcher.prototype.raise = function (funcName) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        for (var i = 0, listener; listener = this.listeners[i]; i++) {
            listener[funcName].apply(listener, args);
        }
    };
    EventDispatcher.prototype.raise1 = function (action) {
        for (var i = 0, listener; listener = this.listeners[i]; i++) {
            action(listener);
        }
    };
    EventDispatcher.prototype.hasEventListener = function (listener) {
        for (var i = 0, l = this.listeners.length; i < l; i++)
            if (this.listeners[i] === listener)
                return true;
        return false;
    };
    return EventDispatcher;
}());
exports.EventDispatcher = EventDispatcher;
var Utils = /** @class */ (function () {
    function Utils() {
    }
    //http://workservices01/OpenWiki/ow.asp?ASPxRichEdit_BinarySearch#preview
    // BINARY INDEX 
    // Input array [4, 8, 10]
    // find       binaryIndexOf normedBinaryIndexOf
    // (-inf, 3]     -1            -1
    // 4              0             0
    // [5, 7]        -2             0
    // 8              1             1
    // 9             -3             1
    // 10             2             2
    // [11, +inf)    -4             2
    // case array.length == 0, then return -1
    // don't touch default value  = -2! In some case binaryIndexOf call as ([], ()=>.., 0, [].length - 1)
    Utils.binaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var findFromZeroPosition = minIndex == 0;
        if (maxIndex == -2)
            maxIndex = array.length - 1;
        while (minIndex <= maxIndex) {
            var currentIndex = (minIndex + ((maxIndex - minIndex) >> 1));
            var compare = comparer(array[currentIndex]);
            if (compare < 0)
                minIndex = currentIndex + 1;
            else if (compare > 0)
                maxIndex = currentIndex - 1;
            else
                return currentIndex;
        }
        return findFromZeroPosition ? ~minIndex : -1;
    };
    Utils.normedBinaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var index = Utils.binaryIndexOf(array, comparer, minIndex, maxIndex);
        return Utils.binaryIndexNormalizator(index);
    };
    Utils.binaryIndexNormalizator = function (index) {
        return index < 0 ? ~index - 1 : index;
    };
    return Utils;
}());
exports.Utils = Utils;
var GeometryUtils = /** @class */ (function () {
    function GeometryUtils() {
    }
    GeometryUtils.getCommonRectangle = function (rects) {
        if (!rects.length)
            return Rectangle.create(0, 0, 0, 0);
        var minX = Number.MAX_VALUE;
        var maxX = -Number.MAX_VALUE;
        var minY = Number.MAX_VALUE;
        var maxY = -Number.MAX_VALUE;
        rects.forEach(function (rect) {
            minX = Math.min(minX, rect.left);
            maxX = Math.max(maxX, rect.right);
            minY = Math.min(minY, rect.top);
            maxY = Math.max(maxY, rect.bottom);
        });
        return Rectangle.create(minX, minY, maxX - minX, maxY - minY);
    };
    GeometryUtils.findFreeSpace = function (rects, size, exact, targetRect) {
        var xs = [targetRect ? targetRect.left : 0], xshash;
        var ys = [targetRect ? targetRect.top : 0];
        rects.forEach(function (r) {
            xs.push(r.left);
            xs.push(r.right);
            ys.push(r.top);
            ys.push(r.bottom);
        });
        xs = xs.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (xs[index - 1] !== v && acc.push(v) && acc) || acc; }, []); // magic for distinct
        ys = ys.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (ys[index - 1] !== v && acc.push(v) && acc) || acc; }, []);
        var matrix = ys.map(function (y) { return xs.map(function (x, i) { return xs[i + 1] - x; }); });
        var _loop_1 = function (i, rect) {
            var xi0 = Utils.binaryIndexOf(xs, function (a) { return a - rect.left; });
            var xi1 = Utils.binaryIndexOf(xs, function (a) { return a - rect.right; });
            var yi0 = Utils.binaryIndexOf(ys, function (a) { return a - rect.top; });
            var yi1 = Utils.binaryIndexOf(ys, function (a) { return a - rect.bottom; });
            for (var y = yi0; y < yi1; y++)
                for (var x = xi0; x < xi1; x++)
                    matrix[y][x] *= -1;
        };
        for (var i = 0, rect = void 0; rect = rects[i]; i++) {
            _loop_1(i, rect);
        }
        for (var yi = 0; yi < ys.length; yi++) {
            for (var xi = 0; xi < xs.length - 1; xi++) {
                var checkResult = this.checkRect(matrix, ys, xs, yi, xi, size, exact);
                if (checkResult > 0)
                    xi = checkResult;
                else if (checkResult === 0)
                    return new Point(xs[xi], ys[yi]);
            }
        }
        return null;
    };
    GeometryUtils.checkRect = function (matrix, ys, xs, yimin, ximin, size, exact) {
        var height = 0;
        var width = 0;
        var ximax = xs.length - 2;
        for (var yi = yimin; yi < ys.length; yi++) {
            height = ys[yi + 1] - ys[yimin];
            for (var xi = ximin; xi <= ximax; xi++) {
                if (matrix[yi][xi] < 0)
                    return xi === 0 ? -1 : xi; // move left?
                width = xs[xi + 1] - xs[ximin];
                if (size.width <= width || (!exact && xi === xs.length - 2 && size.width / 2 <= width)) {
                    if (size.height <= height || (!exact && yi === ys.length - 2 && size.height / 2 <= height))
                        return 0;
                    ximax = xi;
                }
            }
        }
    };
    GeometryUtils.getArrowPoints = function (point, directionPoint, arrowHeight, arrowWidth) {
        if (point.x === directionPoint.x && point.y === directionPoint.y)
            return { point1: point.clone(), point2: point.clone() };
        var catX = directionPoint.x - point.x;
        var catY = directionPoint.y - point.y;
        var hypotenuse = Math.sqrt(Math.pow(catX, 2) + Math.pow(catY, 2));
        var cos = catX / hypotenuse;
        var sin = catY / hypotenuse;
        var x1 = point.x + arrowHeight * cos + arrowWidth * sin;
        var y1 = point.y + arrowHeight * sin - arrowWidth * cos;
        var x2 = point.x + arrowHeight * cos - arrowWidth * sin;
        var y2 = point.y + arrowHeight * sin + arrowWidth * cos;
        return { point1: new Point(x1, y1), point2: new Point(x2, y2) };
    };
    GeometryUtils.removeUnnecessaryLinePoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        this.removeDuplicatedPoints(points, removeCallback, checkCallback);
        this.removeOneLinePoints(points, removeCallback, checkCallback);
        this.removeBackwardPoints(points, removeCallback, checkCallback);
    };
    GeometryUtils.removeBackwardPoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            var prevPoint = this.getNextPoint(points, index, false, checkCallback);
            if (prevPoint && nextPoint) {
                if (point.x == prevPoint.x && point.x == nextPoint.x) {
                    if ((point.y > prevPoint.y && point.y > nextPoint.y) ||
                        (point.y < prevPoint.y && point.y < nextPoint.y)) {
                        if (removeCallback(points[index], index))
                            continue;
                    }
                }
                if (point.y == prevPoint.y && point.y == nextPoint.y) {
                    if ((point.x > prevPoint.x && point.x > nextPoint.x) ||
                        (point.x < prevPoint.x && point.x < nextPoint.x)) {
                        if (removeCallback(points[index], index))
                            continue;
                    }
                }
            }
            index++;
        }
    };
    GeometryUtils.removeOneLinePoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            var prevPoint = this.getNextPoint(points, index, false, checkCallback);
            if (prevPoint && nextPoint) {
                if ((point.x == prevPoint.x && point.x == nextPoint.x) ||
                    (point.y == prevPoint.y && point.y == nextPoint.y)) {
                    if (removeCallback(points[index], index))
                        continue;
                }
                var tg = (nextPoint.y - prevPoint.y) / (nextPoint.x - prevPoint.x);
                if (nextPoint.y - points[index].y == (nextPoint.x - points[index].x) * tg) {
                    if (removeCallback(points[index], index))
                        continue;
                }
            }
            index++;
        }
    };
    GeometryUtils.removeDuplicatedPoints = function (points, removeCallback, checkCallback) {
        if (checkCallback === void 0) { checkCallback = (function (pt) { return pt !== undefined; }); }
        var index = 0;
        var point;
        while (point = points[index]) {
            if (points.length <= 2)
                break;
            var nextPoint = this.getNextPoint(points, index, true, checkCallback);
            if (nextPoint) {
                if (point.x == nextPoint.x && point.y == nextPoint.y) {
                    var indexToRemove = index + 1;
                    if (indexToRemove === points.length - 1)
                        indexToRemove--;
                    if (removeCallback(points[indexToRemove], indexToRemove))
                        continue;
                }
            }
            index++;
        }
    };
    GeometryUtils.getNextPoint = function (points, index, direction, checkCallback) {
        var result;
        var newIndex = index + (direction ? 1 : -1);
        while (result = points[newIndex]) {
            if (checkCallback(result))
                return result;
            newIndex = newIndex + (direction ? 1 : -1);
        }
    };
    GeometryUtils.getDistance = function (a, b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
    };
    GeometryUtils.getPathLength = function (points) {
        var length = 0;
        var prevPt;
        points.forEach(function (pt) {
            if (prevPt !== undefined) {
                var lineLength = GeometryUtils.getDistance(pt, prevPt);
                length += lineLength;
            }
            prevPt = pt;
        });
        return length;
    };
    GeometryUtils.getPathPointByPosition = function (points, relativePosition) {
        if (!points.length)
            throw new Error("Invalid points");
        if (0 > relativePosition || relativePosition > 1)
            throw new Error("Invalid relative position");
        var length = this.getPathLength(points);
        if (points.length <= 2 && length === 0)
            return points[0];
        var targetLength = length * relativePosition;
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var lineLength = GeometryUtils.getDistance(points[i], points[i - 1]);
            if (currentLength + lineLength >= targetLength) {
                var delta = targetLength - currentLength;
                var cos = (points[i].x - points[i - 1].x) / lineLength;
                var sin = (points[i].y - points[i - 1].y) / lineLength;
                return new Point(points[i - 1].x + cos * delta, points[i - 1].y + sin * delta);
            }
            currentLength += lineLength;
        }
        ;
        return points[points.length - 1];
    };
    GeometryUtils.getLineAngle = function (beginPoint, endPoint) {
        return Math.atan2(endPoint.y - beginPoint.y, endPoint.x - beginPoint.x);
    };
    GeometryUtils.getTriangleBeginAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var beginPointAngle = this.getLineAngle(beginPoint, point);
        return Math.abs(beginPointAngle - lineAngle);
    };
    GeometryUtils.getTriangleEndAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var endPointAngle = this.getLineAngle(point, endPoint);
        return Math.abs(lineAngle - endPointAngle);
    };
    GeometryUtils.getPathPointByPoint = function (points, point) {
        if (!points.length)
            throw new Error("Invalid points");
        if (points.length === 1)
            return points[0];
        var distance = Number.MAX_VALUE;
        var result;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            if (point.equals(beginPoint)) {
                result = beginPoint.clone();
                break;
            }
            if (point.equals(endPoint)) {
                result = endPoint.clone();
                break;
            }
            var beginAngle = this.getTriangleBeginAngle(beginPoint, endPoint, point);
            var endAngle = this.getTriangleEndAngle(beginPoint, endPoint, point);
            var beginDistance = GeometryUtils.getDistance(point, beginPoint);
            var endDistance = GeometryUtils.getDistance(point, endPoint);
            var orthOffset = beginDistance * Math.sin(beginAngle);
            var currentDistance = void 0;
            if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                currentDistance = beginDistance;
            else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                currentDistance = endDistance;
            else
                currentDistance = Math.abs(orthOffset);
            if (currentDistance < distance) {
                distance = currentDistance;
                if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                    result = beginPoint.clone();
                else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                    result = endPoint.clone();
                else {
                    var lineAngle = this.getLineAngle(beginPoint, endPoint);
                    var offsetX = Math.fround(Math.abs(orthOffset * Math.sin(lineAngle)));
                    var offsetY = Math.fround(Math.abs(orthOffset * Math.cos(lineAngle)));
                    var isAbove = point.y - beginPoint.y < Math.fround((point.x - beginPoint.x) * Math.tan(lineAngle));
                    if (0 <= lineAngle && lineAngle <= Math.PI / 2) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (Math.PI / 2 <= lineAngle && lineAngle <= Math.PI) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (0 >= lineAngle && lineAngle >= -Math.PI / 2) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (-Math.PI / 2 >= lineAngle && lineAngle >= -Math.PI) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    result = point.offset(offsetX, offsetY);
                }
            }
        }
        ;
        return result;
    };
    GeometryUtils.getPathPositionByPoint = function (points, point, maxPositionCount) {
        if (maxPositionCount === void 0) { maxPositionCount = 100; }
        point = this.getPathPointByPoint(points, point);
        var length = this.getPathLength(points);
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            var lineLength = GeometryUtils.getDistance(endPoint, beginPoint);
            var angle = Math.atan((endPoint.y - beginPoint.y) / (endPoint.x - beginPoint.x));
            if ((point.x === endPoint.x && point.x === beginPoint.x) || (point.y === endPoint.y && point.y === beginPoint.y) ||
                Math.fround(point.y - beginPoint.y) === Math.fround((point.x - beginPoint.x) * Math.tan(angle))) {
                if (Math.sin(angle) !== 0)
                    currentLength += Math.abs((point.y - beginPoint.y) / Math.sin(angle));
                else
                    currentLength += Math.abs(point.x - beginPoint.x);
                return Math.round(currentLength * maxPositionCount / length) / maxPositionCount;
            }
            currentLength += lineLength;
        }
        ;
        return 1;
    };
    GeometryUtils.arePointsEqual = function (points1, points2) {
        var count1 = points1.length;
        var count2 = points2.length;
        if (count1 != count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (!points1[i].equals(points2[i]))
                return false;
        return true;
    };
    return GeometryUtils;
}());
exports.GeometryUtils = GeometryUtils;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeCategories = /** @class */ (function () {
    function ShapeCategories() {
    }
    ShapeCategories.General = "general";
    ShapeCategories.Flowchart = "flowchart";
    ShapeCategories.OrgChart = "orgChart";
    ShapeCategories.Containers = "containers";
    ShapeCategories.Custom = "custom";
    return ShapeCategories;
}());
exports.ShapeCategories = ShapeCategories;
var ShapeTypes = /** @class */ (function () {
    function ShapeTypes() {
    }
    // Standard
    ShapeTypes.Text = "text";
    ShapeTypes.Rectangle = "rectangle";
    ShapeTypes.Ellipse = "ellipse";
    ShapeTypes.Cross = "cross";
    ShapeTypes.Triangle = "triangle";
    ShapeTypes.Diamond = "diamond";
    ShapeTypes.Heart = "heart";
    ShapeTypes.Pentagon = "pentagon";
    ShapeTypes.Hexagon = "hexagon";
    ShapeTypes.Octagon = "octagon";
    ShapeTypes.Star = "star";
    ShapeTypes.ArrowLeft = "arrowLeft";
    ShapeTypes.ArrowTop = "arrowTop";
    ShapeTypes.ArrowRight = "arrowRight";
    ShapeTypes.ArrowBottom = "arrowBottom";
    ShapeTypes.ArrowNorthSouth = "arrowNorthSouth";
    ShapeTypes.ArrowEastWest = "arrowEastWest";
    // Flowchart
    ShapeTypes.Process = "process";
    ShapeTypes.Decision = "decision";
    ShapeTypes.Terminator = "terminator";
    ShapeTypes.PredefinedProcess = "predefinedProcess";
    ShapeTypes.Document = "document";
    ShapeTypes.MultipleDocuments = "multipleDocuments";
    ShapeTypes.ManualInput = "manualInput";
    ShapeTypes.Preparation = "preparation";
    ShapeTypes.Data = "data";
    ShapeTypes.Database = "database";
    ShapeTypes.HardDisk = "hardDisk";
    ShapeTypes.InternalStorage = "internalStorage";
    ShapeTypes.PaperTape = "paperTape";
    ShapeTypes.ManualOperation = "manualOperation";
    ShapeTypes.Delay = "delay";
    ShapeTypes.StoredData = "storedData";
    ShapeTypes.Display = "display";
    ShapeTypes.Merge = "merge";
    ShapeTypes.Or = "or";
    ShapeTypes.SummingJunction = "summingJunction";
    // Containers
    ShapeTypes.VerticalContainer = "verticalContainer";
    ShapeTypes.HorizontalContainer = "horizontalContainer";
    // Shapes with images
    ShapeTypes.CardWithImageOnLeft = "cardWithImageOnLeft";
    ShapeTypes.CardWithImageOnTop = "cardWithImageOnTop";
    ShapeTypes.CardWithImageOnRight = "cardWithImageOnRight";
    return ShapeTypes;
}());
exports.ShapeTypes = ShapeTypes;
var ShapeType;
(function (ShapeType) {
    ShapeType[ShapeType["text"] = 0] = "text";
    ShapeType[ShapeType["rectangle"] = 1] = "rectangle";
    ShapeType[ShapeType["ellipse"] = 2] = "ellipse";
    ShapeType[ShapeType["cross"] = 3] = "cross";
    ShapeType[ShapeType["triangle"] = 4] = "triangle";
    ShapeType[ShapeType["diamond"] = 5] = "diamond";
    ShapeType[ShapeType["heart"] = 6] = "heart";
    ShapeType[ShapeType["pentagon"] = 7] = "pentagon";
    ShapeType[ShapeType["hexagon"] = 8] = "hexagon";
    ShapeType[ShapeType["octagon"] = 9] = "octagon";
    ShapeType[ShapeType["star"] = 10] = "star";
    ShapeType[ShapeType["arrowLeft"] = 11] = "arrowLeft";
    ShapeType[ShapeType["arrowTop"] = 12] = "arrowTop";
    ShapeType[ShapeType["arrowRight"] = 13] = "arrowRight";
    ShapeType[ShapeType["arrowBottom"] = 14] = "arrowBottom";
    ShapeType[ShapeType["arrowNorthSouth"] = 15] = "arrowNorthSouth";
    ShapeType[ShapeType["arrowEastWest"] = 16] = "arrowEastWest";
    // Flowchart
    ShapeType[ShapeType["process"] = 17] = "process";
    ShapeType[ShapeType["decision"] = 18] = "decision";
    ShapeType[ShapeType["terminator"] = 19] = "terminator";
    ShapeType[ShapeType["predefinedProcess"] = 20] = "predefinedProcess";
    ShapeType[ShapeType["document"] = 21] = "document";
    ShapeType[ShapeType["multipleDocuments"] = 22] = "multipleDocuments";
    ShapeType[ShapeType["manualInput"] = 23] = "manualInput";
    ShapeType[ShapeType["preparation"] = 24] = "preparation";
    ShapeType[ShapeType["data"] = 25] = "data";
    ShapeType[ShapeType["database"] = 26] = "database";
    ShapeType[ShapeType["hardDisk"] = 27] = "hardDisk";
    ShapeType[ShapeType["internalStorage"] = 28] = "internalStorage";
    ShapeType[ShapeType["paperTape"] = 29] = "paperTape";
    ShapeType[ShapeType["manualOperation"] = 30] = "manualOperation";
    ShapeType[ShapeType["delay"] = 31] = "delay";
    ShapeType[ShapeType["storedData"] = 32] = "storedData";
    ShapeType[ShapeType["display"] = 33] = "display";
    ShapeType[ShapeType["merge"] = 34] = "merge";
    ShapeType[ShapeType["or"] = 35] = "or";
    ShapeType[ShapeType["summingJunction"] = 36] = "summingJunction";
    // Containers
    ShapeType[ShapeType["verticalContainer"] = 37] = "verticalContainer";
    ShapeType[ShapeType["horizontalContainer"] = 38] = "horizontalContainer";
    // Shapes with images
    ShapeType[ShapeType["cardWithImageOnLeft"] = 39] = "cardWithImageOnLeft";
    ShapeType[ShapeType["cardWithImageOnTop"] = 40] = "cardWithImageOnTop";
    ShapeType[ShapeType["cardWithImageOnRight"] = 41] = "cardWithImageOnRight";
})(ShapeType = exports.ShapeType || (exports.ShapeType = {}));


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var PathPrimitive = /** @class */ (function (_super) {
    __extends(PathPrimitive, _super);
    function PathPrimitive(commands, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.commands = commands;
        return _this;
    }
    PathPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "path");
    };
    PathPrimitive.prototype.applyElementProperties = function (element) {
        element.setAttribute("d", this.commands.map(function (c) { return c.toString(); }).join(" "));
        _super.prototype.applyElementProperties.call(this, element);
    };
    return PathPrimitive;
}(Primitive_1.SvgPrimitive));
exports.PathPrimitive = PathPrimitive;
var PathPrimitiveCommand = /** @class */ (function () {
    function PathPrimitiveCommand() {
    }
    PathPrimitiveCommand.prototype.getUnitVaue = function (value) {
        return typeof value === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(value).toString() : value;
    };
    return PathPrimitiveCommand;
}());
exports.PathPrimitiveCommand = PathPrimitiveCommand;
var PathPrimitiveMoveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveMoveToCommand, _super);
    function PathPrimitiveMoveToCommand(x, y) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveMoveToCommand.prototype.toString = function () {
        return "M " + this.getUnitVaue(this.x) + " " + this.getUnitVaue(this.y);
    };
    return PathPrimitiveMoveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveMoveToCommand = PathPrimitiveMoveToCommand;
var PathPrimitiveLineToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveLineToCommand, _super);
    function PathPrimitiveLineToCommand(x, y) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveLineToCommand.prototype.toString = function () {
        return "L " + this.getUnitVaue(this.x) + " " + this.getUnitVaue(this.y);
    };
    return PathPrimitiveLineToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveLineToCommand = PathPrimitiveLineToCommand;
var PathPrimitiveCubicCurveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveCubicCurveToCommand, _super);
    function PathPrimitiveCubicCurveToCommand(x1, y1, x2, y2, x3, y3) {
        var _this = _super.call(this) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        _this.x3 = x3;
        _this.y3 = y3;
        return _this;
    }
    PathPrimitiveCubicCurveToCommand.prototype.toString = function () {
        return "C " + this.getUnitVaue(this.x1) + " " + this.getUnitVaue(this.y1) + "," +
            this.getUnitVaue(this.x2) + " " + this.getUnitVaue(this.y2) + "," +
            this.getUnitVaue(this.x3) + " " + this.getUnitVaue(this.y3);
    };
    return PathPrimitiveCubicCurveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveCubicCurveToCommand = PathPrimitiveCubicCurveToCommand;
var PathPrimitiveQuadraticCurveToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveQuadraticCurveToCommand, _super);
    function PathPrimitiveQuadraticCurveToCommand(x1, y1, x2, y2) {
        var _this = _super.call(this) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        return _this;
    }
    PathPrimitiveQuadraticCurveToCommand.prototype.toString = function () {
        return "Q " + this.getUnitVaue(this.x1) + " " + this.getUnitVaue(this.y1) + "," +
            this.getUnitVaue(this.x2) + " " + this.getUnitVaue(this.y2);
    };
    return PathPrimitiveQuadraticCurveToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveQuadraticCurveToCommand = PathPrimitiveQuadraticCurveToCommand;
var PathPrimitiveArcToCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveArcToCommand, _super);
    function PathPrimitiveArcToCommand(rx, ry, xAxisRotation, largeArcFlag, sweepFag, x, y) {
        var _this = _super.call(this) || this;
        _this.rx = rx;
        _this.ry = ry;
        _this.xAxisRotation = xAxisRotation;
        _this.largeArcFlag = largeArcFlag;
        _this.sweepFag = sweepFag;
        _this.x = x;
        _this.y = y;
        return _this;
    }
    PathPrimitiveArcToCommand.prototype.toString = function () {
        return "A " + this.getUnitVaue(this.rx) + " " + this.getUnitVaue(this.ry) + " " +
            this.getUnitVaue(this.xAxisRotation) + " " +
            (this.largeArcFlag ? "1" : "0") + " " + (this.sweepFag ? "1" : "0") +
            this.getUnitVaue(this.x) + "," + this.getUnitVaue(this.y);
    };
    return PathPrimitiveArcToCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveArcToCommand = PathPrimitiveArcToCommand;
var PathPrimitiveClosePathCommand = /** @class */ (function (_super) {
    __extends(PathPrimitiveClosePathCommand, _super);
    function PathPrimitiveClosePathCommand() {
        return _super.call(this) || this;
    }
    PathPrimitiveClosePathCommand.prototype.toString = function () {
        return "z";
    };
    return PathPrimitiveClosePathCommand;
}(PathPrimitiveCommand));
exports.PathPrimitiveClosePathCommand = PathPrimitiveClosePathCommand;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem = /** @class */ (function () {
    function HistoryItem() {
        this.uniqueId = -1;
    }
    HistoryItem.prototype.changeModified = function () {
        return true;
    };
    HistoryItem.prototype.getName = function () {
        return this.constructor.name;
    };
    return HistoryItem;
}());
exports.HistoryItem = HistoryItem;
var CompositionHistoryItem = /** @class */ (function (_super) {
    __extends(CompositionHistoryItem, _super);
    function CompositionHistoryItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.historyItems = [];
        return _this;
    }
    CompositionHistoryItem.prototype.changeModified = function () {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++) {
            if (item.changeModified())
                return true;
        }
        return false;
    };
    CompositionHistoryItem.prototype.redo = function (manipulator) {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            item.redo(manipulator);
    };
    CompositionHistoryItem.prototype.undo = function (manipulator) {
        var item;
        for (var i = this.historyItems.length - 1; item = this.historyItems[i]; i--)
            item.undo(manipulator);
    };
    CompositionHistoryItem.prototype.add = function (historyItem) {
        if (historyItem == null)
            throw new Error("cannot be null");
        this.historyItems.push(historyItem);
    };
    return CompositionHistoryItem;
}(HistoryItem));
exports.CompositionHistoryItem = CompositionHistoryItem;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Style_1 = __webpack_require__(37);
var ConnectionPointSide;
(function (ConnectionPointSide) {
    ConnectionPointSide[ConnectionPointSide["Undefined"] = -1] = "Undefined";
    ConnectionPointSide[ConnectionPointSide["North"] = 0] = "North";
    ConnectionPointSide[ConnectionPointSide["East"] = 1] = "East";
    ConnectionPointSide[ConnectionPointSide["South"] = 2] = "South";
    ConnectionPointSide[ConnectionPointSide["West"] = 3] = "West";
})(ConnectionPointSide = exports.ConnectionPointSide || (exports.ConnectionPointSide = {}));
;
exports.DEFAULT_ZINDEX = 0;
var DiagramItem = /** @class */ (function () {
    function DiagramItem() {
        this.key = undefined;
        this.dataKey = undefined;
        this.attachedConnectors = [];
        this.zIndex = exports.DEFAULT_ZINDEX;
        this.locked = false;
        this.container = undefined;
        this.containerLocked = false;
        this.style = new Style_1.Style();
        this.styleText = new Style_1.StyleText();
    }
    DiagramItem.prototype.assign = function (item) {
        item.key = this.key;
        item.dataKey = this.dataKey;
        item.locked = this.locked;
        item.attachedConnectors = this.attachedConnectors.slice();
        item.style = this.style.clone();
        item.styleText = this.styleText.clone();
        item.zIndex = this.zIndex;
        item.container = this.container;
        item.containerLocked = this.containerLocked;
    };
    DiagramItem.prototype.invalidatePrimitives = function () {
        this.primitives && this.primitives.forEach(function (element) {
            element.dispose();
        });
        delete this.primitives;
        delete this.selectorPrimitives;
    };
    DiagramItem.prototype.getPrimitives = function () {
        if (!this.primitives)
            this.primitives = this.createPrimitives();
        return this.primitives;
    };
    DiagramItem.prototype.getSelectorPrimitives = function () {
        if (!this.selectorPrimitives)
            this.selectorPrimitives = this.createSelectorPrimitives();
        return this.selectorPrimitives;
    };
    DiagramItem.prototype.getConnectionPointPosition = function (index, targetPoint) {
        return this.getConnectionPoint(index, targetPoint).toPoint();
    };
    DiagramItem.prototype.getConnectionPoint = function (index, targetPoint) {
        if (index < 0 && targetPoint)
            index = this.getNearestConnectionPoint(targetPoint);
        var connectionPoints = this.getConnectionPoints();
        return connectionPoints[index] || connectionPoints[0];
    };
    DiagramItem.prototype.getNearestConnectionPoint = function (targetPoint) {
        var distance = Number.MAX_VALUE;
        var result;
        this.getConnectionPoints().forEach(function (pt, index) {
            var ptDistance = Utils_1.GeometryUtils.getDistance(pt, targetPoint);
            if (ptDistance < distance) {
                distance = ptDistance;
                result = index;
            }
        });
        return result;
    };
    DiagramItem.prototype.getConnectionPointIndex = function (side) {
        var points = this.getConnectionPoints();
        return points.reduce(function (prevIndex, pt, index) {
            if (side === ConnectionPointSide.North && pt.y < points[prevIndex].y)
                return index;
            if (side === ConnectionPointSide.South && pt.y > points[prevIndex].y)
                return index;
            if (side === ConnectionPointSide.West && pt.x < points[prevIndex].x)
                return index;
            if (side === ConnectionPointSide.East && pt.x > points[prevIndex].x)
                return index;
            return prevIndex;
        }, 0);
    };
    DiagramItem.prototype.getConnectionPointSideByIndex = function (index, targetPoint) {
        var point = this.getConnectionPoint(index, targetPoint);
        return this.getConnectionPointSide(point, targetPoint);
    };
    Object.defineProperty(DiagramItem.prototype, "isVisible", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramItem.prototype, "enableText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramItem.prototype, "allowEditText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramItem.prototype, "enableChildren", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramItem.prototype, "isLocked", {
        get: function () { return this.locked || this.containerLocked; },
        enumerable: true,
        configurable: true
    });
    DiagramItem.prototype.intersectedByRect = function (rect) {
        return this.rectangle.intersect(rect);
    };
    return DiagramItem;
}());
exports.DiagramItem = DiagramItem;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var Utils_1 = __webpack_require__(0);
var UnitConverter_1 = __webpack_require__(13);
var LinePrimitive_1 = __webpack_require__(80);
var ConnectorPointsCalculator_1 = __webpack_require__(134);
var ConnectorPointsOrthogonalCalculator_1 = __webpack_require__(135);
var ConnectorProperties_1 = __webpack_require__(25);
var ConnectorTexts_1 = __webpack_require__(141);
var TextPrimitive_1 = __webpack_require__(63);
var Event_1 = __webpack_require__(12);
var Utils_2 = __webpack_require__(15);
var CanvasManagerBase_1 = __webpack_require__(33);
var ConnectorPosition;
(function (ConnectorPosition) {
    ConnectorPosition[ConnectorPosition["Begin"] = 0] = "Begin";
    ConnectorPosition[ConnectorPosition["End"] = 1] = "End";
})(ConnectorPosition = exports.ConnectorPosition || (exports.ConnectorPosition = {}));
exports.CONNECTOR_DEFAULT_TEXT_POSITION = 0.5;
var Connector = /** @class */ (function (_super) {
    __extends(Connector, _super);
    function Connector(points) {
        var _this = _super.call(this) || this;
        _this.beginConnectionPointIndex = -1;
        _this.endConnectionPointIndex = -1;
        _this.properties = new ConnectorProperties_1.ConnectorProperties();
        _this.points = points.map(function (pt) { return pt.clone(); });
        if (points.length < 2)
            throw Error("Points count should be greater than 1");
        _this.texts = new ConnectorTexts_1.ConnectorTexts();
        return _this;
    }
    Connector.prototype.assign = function (item) {
        _super.prototype.assign.call(this, item);
        item.beginItem = this.beginItem;
        item.beginConnectionPointIndex = this.beginConnectionPointIndex;
        item.endItem = this.endItem;
        item.endConnectionPointIndex = this.endConnectionPointIndex;
        item.properties = this.properties.clone();
        item.texts = this.texts.clone();
    };
    Connector.prototype.clone = function () {
        var clone = new Connector(this.points);
        this.assign(clone);
        return clone;
    };
    Connector.prototype.getRenderPoints = function (keepSkipped) {
        if (keepSkipped === void 0) { keepSkipped = false; }
        if (this.renderPoints === undefined) {
            this.renderPoints = this.getCalculator().getPoints();
            this.renderPointsWithoutSkipped = this.renderPoints.filter(function (pt) { return !pt.skipped; });
        }
        return keepSkipped ? this.renderPoints : this.renderPointsWithoutSkipped;
    };
    Connector.prototype.getText = function (position) {
        if (position === void 0) { position = exports.CONNECTOR_DEFAULT_TEXT_POSITION; }
        var textObj = this.texts.get(position);
        return textObj ? textObj.value : "";
    };
    Connector.prototype.setText = function (text, position) {
        if (position === void 0) { position = exports.CONNECTOR_DEFAULT_TEXT_POSITION; }
        if (!text || text === "")
            this.texts.remove(position);
        else
            this.texts.set(position, new ConnectorTexts_1.ConnectorText(position, text));
    };
    Connector.prototype.getTextPoint = function (position) {
        var points = this.getRenderPoints();
        return Utils_1.GeometryUtils.getPathPointByPosition(points, position);
    };
    Connector.prototype.getTextPositionByPoint = function (point) {
        var points = this.getRenderPoints();
        var length = Utils_1.GeometryUtils.getPathLength(points);
        var pos = Utils_1.GeometryUtils.getPathPositionByPoint(points, point);
        var minTextHeight = UnitConverter_1.UnitConverter.pointsToTwips(parseInt(this.styleText["font-size"]));
        if (minTextHeight > pos * length)
            return minTextHeight / length;
        if (minTextHeight > length - pos * length)
            return (length - minTextHeight) / length;
        return pos;
    };
    Connector.prototype.getTextRectangle = function (position) {
        return new Utils_1.Rectangle(this.getTextPoint(position), new Utils_1.Size(0, 0));
    };
    Connector.prototype.getCalculator = function () {
        return (this.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) ?
            new ConnectorPointsCalculator_1.ConnectorPointsCalculator(this) :
            new ConnectorPointsOrthogonalCalculator_1.ConnectorPointsOrthogonalCalculator(this);
    };
    Connector.prototype.invalidateRenderPoints = function () {
        delete this.renderPoints;
        delete this.renderPointsWithoutSkipped;
        this.invalidatePrimitives();
    };
    Connector.prototype.createPrimitives = function () {
        var _this = this;
        var result = [];
        var points = this.getRenderPoints();
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(_this.createSegmentPrimitive(points[index - 1], pt, _this.style, null));
        });
        if (points.length > 1) {
            if (this.properties.startLineEnding !== ConnectorProperties_1.ConnectorLineEnding.None)
                result = result.concat(this.createLineEndingPrimitives(points[0], points[1]));
            if (this.properties.endLineEnding !== ConnectorProperties_1.ConnectorLineEnding.None)
                result = result.concat(this.createLineEndingPrimitives(points[points.length - 1], points[points.length - 2]));
        }
        return result.concat(this.createTextPrimitives());
    };
    Connector.prototype.createSelectorPrimitives = function () {
        var _this = this;
        var result = [];
        var points = this.getRenderPoints();
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(_this.createSegmentPrimitive(points[index - 1], pt, null, "selector"));
        });
        return result;
    };
    Connector.prototype.createTextPrimitives = function () {
        var _this = this;
        if (!this.enableText)
            return [];
        var result = [];
        this.texts.forEach(function (textObj) {
            var text = _this.getText(textObj.position);
            if (text && text !== "") {
                var pt = _this.getTextPoint(textObj.position);
                result = result.concat([
                    new TextPrimitive_1.TextPrimitive(pt.x, pt.y, text, undefined, _this.styleText, true, null, CanvasManagerBase_1.PAGE_BG_TEXTFLOOR_FILTER_ID, false, function (el) {
                        Utils_2.RenderUtils.setElementEventData(el, Event_1.MouseEventElementType.ConnectorText, _this.key, textObj.position);
                    })
                ]);
            }
        });
        return result;
    };
    Connector.prototype.createSegmentPrimitive = function (point1, point2, style, className) {
        return new LinePrimitive_1.LinePrimitive(point1.x, point1.y, point2.x, point2.y, style, className);
    };
    Connector.prototype.createLineEndingPrimitives = function (point, directionPoint) {
        var arrowHeight = Connector.arrowHeight;
        if (point.x === directionPoint.x) {
            var distance = Math.abs(point.y - directionPoint.y);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        if (point.y === directionPoint.y) {
            var distance = Math.abs(point.x - directionPoint.x);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        var arrowPoints = Utils_1.GeometryUtils.getArrowPoints(point, directionPoint, arrowHeight, Connector.arrowWidth);
        return [
            new LinePrimitive_1.LinePrimitive(arrowPoints.point1.x, arrowPoints.point1.y, point.x, point.y, this.style),
            new LinePrimitive_1.LinePrimitive(arrowPoints.point2.x, arrowPoints.point2.y, point.x, point.y, this.style)
        ];
    };
    Connector.prototype.getExtremeItem = function (position) {
        if (position === ConnectorPosition.Begin)
            return this.beginItem;
        if (position === ConnectorPosition.End)
            return this.endItem;
        return null;
    };
    Connector.prototype.getExtremeConnectionPointIndex = function (position) {
        if (position === ConnectorPosition.Begin)
            return this.beginConnectionPointIndex;
        if (position === ConnectorPosition.End)
            return this.endConnectionPointIndex;
        return -1;
    };
    Object.defineProperty(Connector.prototype, "rectangle", {
        get: function () {
            var points = this.getRenderPoints();
            var xarr = points.map(function (p) { return p.x; });
            var yarr = points.map(function (p) { return p.y; });
            var minX = xarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
            var maxX = xarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
            var minY = yarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
            var maxY = yarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
            return Utils_1.Rectangle.create(minX, minY, maxX - minX, maxY - minY);
        },
        enumerable: true,
        configurable: true
    });
    Connector.prototype.getMinX = function () {
        var points = this.getRenderPoints();
        var xarr = points.map(function (p) { return p.x; });
        return xarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
    };
    Connector.prototype.getMinY = function () {
        var points = this.getRenderPoints();
        var yarr = points.map(function (p) { return p.y; });
        return yarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
    };
    Connector.prototype.getConnectionPoints = function () {
        return [];
    };
    Connector.prototype.getConnectionPointsForSelection = function () {
        return [];
    };
    Connector.prototype.getConnectionPointSide = function (point, targetPoint) {
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    Connector.prototype.getConnectionPointForSelectionSide = function (point) {
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    Connector.prototype.getSegments = function () {
        var points = this.getRenderPoints();
        var result = [];
        points.forEach(function (pt, index) {
            if (index > 0)
                result.push(Utils_1.Segment.createByPoints(points[index - 1], pt));
        });
        return result;
    };
    Connector.prototype.intersectedByRect = function (rect) {
        var result = false;
        this.getSegments().forEach(function (s) {
            if (s.intersectRect(rect)) {
                result = true;
                return;
            }
        });
        return result;
    };
    Connector.arrowHeight = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    Connector.arrowWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    Connector.minOffset = UnitConverter_1.UnitConverter.pixelsToTwips(18);
    Connector.minTextHeight = UnitConverter_1.UnitConverter.pixelsToTwips(12);
    return Connector;
}(DiagramItem_1.DiagramItem));
exports.Connector = Connector;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase_1 = __webpack_require__(191);
var CommandStates_1 = __webpack_require__(192);
var ModelUtils_1 = __webpack_require__(7);
var SimpleCommandBase = /** @class */ (function (_super) {
    __extends(SimpleCommandBase, _super);
    function SimpleCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SimpleCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(this.isEnabled(), this.getValue(), this.getItems(), this.isVisible());
    };
    SimpleCommandBase.prototype.isVisible = function () {
        return true;
    };
    SimpleCommandBase.prototype.isEnabled = function () {
        return !this.control.settings.readOnly || this.isEnabledInReadOnlyMode();
    };
    SimpleCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return false;
    };
    SimpleCommandBase.prototype.getValue = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getItems = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getModelUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getModelUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.model.units, this.control.settings.unitItems, this.control.settings.formatUnit, value);
    };
    SimpleCommandBase.prototype.getModelUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getViewUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.settings.viewUnits, value);
    };
    SimpleCommandBase.prototype.getViewUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.settings.viewUnits, this.control.settings.unitItems, this.control.settings.formatUnit, value);
    };
    SimpleCommandBase.prototype.getViewUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.settings.viewUnits, value);
    };
    return SimpleCommandBase;
}(CommandBase_1.CommandBase));
exports.SimpleCommandBase = SimpleCommandBase;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MoveShapeHistoryItem_1 = __webpack_require__(122);
var AddConnectionHistoryItem_1 = __webpack_require__(36);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(50);
var ModelResizeHistoryItem_1 = __webpack_require__(142);
var UpdatePositionsOnPageResizeHistoryItem_1 = __webpack_require__(143);
var Model_1 = __webpack_require__(23);
var Connector_1 = __webpack_require__(5);
var Utils_1 = __webpack_require__(0);
var DeleteConnectorPointHistoryItem_1 = __webpack_require__(144);
var ResizeShapeHistoryItem_1 = __webpack_require__(145);
var DeleteConnectionHistoryItem_1 = __webpack_require__(89);
var DeleteShapeHistoryItem_1 = __webpack_require__(90);
var DeleteConnectorHistoryItem_1 = __webpack_require__(146);
var SetSelectionHistoryItem_1 = __webpack_require__(44);
var Shape_1 = __webpack_require__(9);
var ConnectorProperties_1 = __webpack_require__(25);
var UnitConverter_1 = __webpack_require__(13);
var AddShapeHistoryItem_1 = __webpack_require__(51);
var AddConnectorHistoryItem_1 = __webpack_require__(52);
var Graph_1 = __webpack_require__(53);
var Base_1 = __webpack_require__(19);
var InsertToContainerHistoryItem_1 = __webpack_require__(186);
var RemoveFromContainerHistoryItem_1 = __webpack_require__(187);
var ChangeShapeParametersHistoryItem_1 = __webpack_require__(100);
var ChangeStyleHistoryItem_1 = __webpack_require__(46);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(35);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(54);
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(55);
var ChangeLockedHistoryItem_1 = __webpack_require__(102);
var ChangeContainerLockedHistoryItem_1 = __webpack_require__(188);
var GraphInfo_1 = __webpack_require__(189);
var Structures_1 = __webpack_require__(31);
var ModelUtils = /** @class */ (function () {
    function ModelUtils() {
    }
    ModelUtils.setShapePosition = function (history, model, shape, newPosition) {
        if (!shape.position.equals(newPosition))
            history.addAndRedo(new MoveShapeHistoryItem_1.MoveShapeHistoryItem(shape.key, newPosition));
    };
    ModelUtils.setShapeSize = function (history, model, shape, newPosition, newSize) {
        if (!shape.size.equals(newSize) || !shape.position.equals(newPosition))
            history.addAndRedo(new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(shape.key, newPosition, newSize));
    };
    ModelUtils.setConnectorPoint = function (history, model, connector, pointIndex, newPosition) {
        if (!connector.points[pointIndex].equals(newPosition))
            history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, pointIndex, newPosition));
    };
    ModelUtils.updateConnectorAttachedPoints = function (history, model, connector) {
        history.beginTransaction();
        var beginContainer = connector.beginItem && model.findItemCollapsedContainer(connector.beginItem);
        if (beginContainer && (!connector.endItem || !model.isContainerItem(beginContainer, connector.endItem)))
            this.updateConnectorBeginPoint(history, connector, beginContainer);
        else
            this.updateConnectorBeginPoint(history, connector, connector.beginItem);
        var endContainer = connector.endItem && model.findItemCollapsedContainer(connector.endItem);
        if (endContainer && (!connector.beginItem || !model.isContainerItem(endContainer, connector.beginItem)))
            this.updateConnectorEndPoint(history, connector, endContainer);
        else
            this.updateConnectorEndPoint(history, connector, connector.endItem);
        history.endTransaction();
    };
    ModelUtils.updateConnectorBeginPoint = function (history, connector, beginItem) {
        if (beginItem) {
            var pt = beginItem.getConnectionPointPosition(connector.beginConnectionPointIndex, connector.points[1]);
            if (!connector.points[0].equals(pt))
                history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, 0, pt));
        }
    };
    ModelUtils.updateConnectorEndPoint = function (history, connector, endItem) {
        if (endItem) {
            var pt = endItem.getConnectionPointPosition(connector.endConnectionPointIndex, connector.points[connector.points.length - 2]);
            if (!connector.points[connector.points.length - 1].equals(pt))
                history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, connector.points.length - 1, pt));
        }
    };
    ModelUtils.updateContainerConnectorsAttachedPoints = function (history, model, rootContainer, container) {
        var _this = this;
        if (container === void 0) { container = rootContainer; }
        history.beginTransaction();
        var children = model.getChildren(container);
        children.forEach(function (child) {
            if (child instanceof Shape_1.Shape) {
                child.attachedConnectors.forEach(function (connector) {
                    if (connector.beginItem && model.isContainerItem(container, connector.beginItem)) {
                        if (!connector.endItem || !model.isContainerItem(container, connector.endItem)) {
                            if (rootContainer.expanded)
                                _this.updateConnectorBeginPoint(history, connector, connector.beginItem);
                            else
                                _this.updateConnectorBeginPoint(history, connector, rootContainer);
                        }
                    }
                    if (connector.endItem && model.isContainerItem(container, connector.endItem)) {
                        if (!connector.beginItem || !model.isContainerItem(container, connector.beginItem)) {
                            if (rootContainer.expanded)
                                _this.updateConnectorEndPoint(history, connector, connector.endItem);
                            else
                                _this.updateConnectorEndPoint(history, connector, rootContainer);
                        }
                    }
                });
                _this.updateContainerConnectorsAttachedPoints(history, model, rootContainer, child);
            }
        });
        history.endTransaction();
    };
    ModelUtils.removeUnnecessaryConnectorPoints = function (history, connector, exceptPoints, removeCallback) {
        history.beginTransaction();
        Utils_1.GeometryUtils.removeUnnecessaryLinePoints(connector.points, function (pt, index) {
            var needRemove = true;
            if (exceptPoints) {
                exceptPoints.forEach(function (ept) {
                    if (ept && ept.equals(pt)) {
                        needRemove = false;
                        return;
                    }
                });
            }
            if (needRemove) {
                history.addAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, index));
                if (removeCallback !== undefined)
                    removeCallback(index);
                return true;
            }
        });
        history.endTransaction();
    };
    ModelUtils.removeConnectorIntermediatePoints = function (history, connector) {
        if (connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal || connector.points.length <= 2)
            return;
        history.beginTransaction();
        var removePoints = false;
        if (this.isShapeIntersectConnectorPointsLine(connector.beginItem, connector))
            removePoints = true;
        if (this.isShapeIntersectConnectorPointsLine(connector.endItem, connector))
            removePoints = true;
        if (removePoints) {
            while (connector.points.length > 2) {
                history.addAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, 1));
            }
        }
        history.endTransaction();
    };
    ModelUtils.isShapeIntersectConnectorPointsLine = function (shape, connector) {
        if (shape === undefined)
            return false;
        var offset = Connector_1.Connector.minOffset - UnitConverter_1.UnitConverter.pixelsToTwips(1);
        var rect = shape.rectangle.inflate(offset, offset);
        var prevPt;
        for (var i = 1; i < connector.points.length - 1; i++) {
            if (prevPt !== undefined) {
                if (prevPt.x === connector.points[i].x) {
                    if (rect.left <= prevPt.x && prevPt.x <= rect.right)
                        return true;
                }
                if (prevPt.y === connector.points[i].y) {
                    if (rect.top <= prevPt.y && prevPt.y <= rect.bottom)
                        return true;
                }
            }
            prevPt = connector.points[i];
        }
        return false;
    };
    ModelUtils.getSnappedPos = function (model, gridSize, pos, isHorizontal) {
        var snapOffset = isHorizontal ? model.snapStartPoint.x : model.snapStartPoint.y;
        return Math.round((pos - snapOffset) / gridSize) * gridSize + snapOffset;
    };
    ModelUtils.tryUpdateModelSize = function (history, model, processPoints) {
        var offset = history.modelManipulator.getModelSizeUpdateOffset();
        if (!offset.isEmpty()) {
            history.addAndRedo(new ModelResizeHistoryItem_1.ModelResizeHistoryItem(offset));
            if (offset.left || offset.top) {
                history.addAndRedo(new UpdatePositionsOnPageResizeHistoryItem_1.UpdatePositionsOnPageResizeHistoryItem(offset.left, offset.top));
                if (processPoints !== undefined)
                    processPoints(offset.left, offset.top);
            }
            history.modelManipulator.raiseModelRectangleChanged(model.getRectangle(true));
        }
    };
    ModelUtils.deleteItems = function (history, model, selection, items, deleteLocked) {
        history.beginTransaction();
        this.deleteItemsCore(history, model, items, deleteLocked);
        this.tryUpdateModelSize(history, model);
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, []));
        history.endTransaction();
    };
    ModelUtils.deleteItemsCore = function (history, model, items, deleteLocked) {
        var _this = this;
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                var children = model.getChildren(item);
                if (children.length) {
                    children.forEach(function (child) {
                        history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(child));
                        _this.updateAttachedConnectorsContainer(history, model, child);
                    });
                    _this.deleteItemsCore(history, model, children.filter(function (child) { return !child.locked || deleteLocked; }), deleteLocked);
                }
                if (model.findItem(item.key))
                    _this.deleteShape(history, item);
            }
            if (item instanceof Connector_1.Connector) {
                if (model.findItem(item.key))
                    _this.deleteConnector(history, item);
            }
        });
    };
    ModelUtils.deleteShape = function (history, shape) {
        while (shape.attachedConnectors.length > 0) {
            var connector = shape.attachedConnectors[0];
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, connector.beginItem === shape ? Connector_1.ConnectorPosition.Begin : Connector_1.ConnectorPosition.End));
        }
        history.addAndRedo(new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(shape.key));
    };
    ModelUtils.deleteConnector = function (history, connector) {
        if (connector.beginItem)
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.Begin));
        if (connector.endItem)
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.End));
        history.addAndRedo(new DeleteConnectorHistoryItem_1.DeleteConnectorHistoryItem(connector.key));
    };
    ModelUtils.deleteAllItems = function (history, model, selection) {
        this.deleteItems(history, model, selection, model.items.slice(), true);
    };
    ModelUtils.deleteSelection = function (history, model, selection) {
        this.deleteItems(history, model, selection, selection.getSelectedItems());
    };
    ModelUtils.changeChildrenContainerLocked = function (history, model, item, locked) {
        var _this = this;
        if (item instanceof Shape_1.Shape) {
            var items = model.getChildren(item);
            items.forEach(function (item) {
                history.addAndRedo(new ChangeContainerLockedHistoryItem_1.ChangeContainerLockedHistoryItem(item, locked));
                _this.changeChildrenContainerLocked(history, model, item, locked);
            });
        }
    };
    ModelUtils.changeSelectionLocked = function (history, model, selection, locked) {
        var _this = this;
        history.beginTransaction();
        var items = selection.getSelectedItems(true);
        items.forEach(function (item) {
            history.addAndRedo(new ChangeLockedHistoryItem_1.ChangeLockedHistoryItem(item, locked));
            _this.changeChildrenContainerLocked(history, model, item, locked);
        });
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, selection.getKeys())); // Update canvas
        history.endTransaction();
    };
    ModelUtils.copyStylesToItem = function (history, model, fromItem, newItemKey) {
        var toItem = model.findItem(newItemKey);
        fromItem.styleText.forEach(function (propertyName) {
            if (fromItem.styleText[propertyName] !== toItem.styleText[propertyName])
                history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(newItemKey, propertyName, fromItem.styleText[propertyName]));
        });
        fromItem.style.forEach(function (propertyName) {
            if (fromItem.style[propertyName] !== toItem.style[propertyName])
                history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(newItemKey, propertyName, fromItem.style[propertyName]));
        });
    };
    // Cloning
    ModelUtils.cloneShapeToOffset = function (history, model, shape, dx, dy) {
        history.beginTransaction();
        var newPosition = shape.position.offset(dx, dy);
        var addHistoryItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(shape.description.key, newPosition, shape.text);
        history.addAndRedo(addHistoryItem);
        var newKey = addHistoryItem.shapeKey;
        history.addAndRedo(new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(newKey, newPosition, shape.size.clone()));
        history.addAndRedo(new ChangeShapeParametersHistoryItem_1.ChangeShapeParametersHistoryItem(newKey, shape.parameters.clone()));
        this.copyStylesToItem(history, model, shape, newKey);
        history.endTransaction();
        return newKey;
    };
    ModelUtils.cloneConnectorToOffset = function (history, model, connector, beginItemKey, endItemKey, dx, dy) {
        history.beginTransaction();
        var newPoints = connector.points.map(function (p) { return p.offset(dx, dy); });
        var addHistoryItem = new AddConnectorHistoryItem_1.AddConnectorHistoryItem(newPoints);
        history.addAndRedo(addHistoryItem);
        var newKey = addHistoryItem.connectorKey;
        var newConnector = model.findConnector(newKey);
        connector.properties.forEach(function (propertyName) {
            if (connector.properties[propertyName] !== newConnector.properties[propertyName])
                history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(newKey, propertyName, connector.properties[propertyName]));
        });
        if (beginItemKey) {
            var from = model.findShape(beginItemKey);
            history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(newConnector, from, connector.beginConnectionPointIndex, Connector_1.ConnectorPosition.Begin));
        }
        if (endItemKey) {
            var to = model.findShape(endItemKey);
            history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(newConnector, to, connector.endConnectionPointIndex, Connector_1.ConnectorPosition.End));
        }
        var newTexts = connector.texts.clone();
        newTexts.forEach(function (connectorText) {
            history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(newConnector, connectorText.position, connectorText.value));
        });
        this.copyStylesToItem(history, model, connector, newKey);
        history.endTransaction();
        return newKey;
    };
    ModelUtils.cloneSelectionToOffset = function (history, model, selection, dx, dy) {
        var _this = this;
        history.beginTransaction();
        var newShapes = {};
        var ids = [];
        selection.getSelectedShapes().forEach(function (shape) {
            var newKey = _this.cloneShapeToOffset(history, model, shape, dx, dy);
            newShapes[shape.key] = newKey;
            ids.push(newKey);
        });
        selection.getSelectedConnectors().forEach(function (connector) {
            var beginItemKey = connector.beginItem ? newShapes[connector.beginItem.key] : null;
            var endItemKey = connector.endItem ? newShapes[connector.endItem.key] : null;
            var newKey = _this.cloneConnectorToOffset(history, model, connector, beginItemKey, endItemKey, dx, dy);
            ids.push(newKey);
        });
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, ids));
        ModelUtils.tryUpdateModelSize(history, model);
        history.endTransaction();
    };
    // Containers
    ModelUtils.findContainerByEventKey = function (model, selection, key) {
        var container = model.findContainer(key);
        if (container)
            return container;
        else {
            var shape = model.findShape(key);
            if (shape && shape.container && !selection.hasKey(shape.key))
                return shape.container;
        }
    };
    ModelUtils.canInsertToContainer = function (model, item, container) {
        if (item === container)
            return false;
        if (item instanceof Shape_1.Shape) {
            if (model.findChild(item, container.key))
                return false;
        }
        return true;
    };
    ModelUtils.canInsertSelectionToContainer = function (model, selection, container) {
        var result = true;
        selection.getSelectedItems().forEach(function (item) {
            if (item === container) {
                result = false;
                return;
            }
            if (item instanceof Shape_1.Shape) {
                if (model.findChild(item, container.key)) {
                    result = false;
                    return;
                }
            }
        });
        return result;
    };
    ModelUtils.insertToContainer = function (history, model, item, container) {
        if (!container.enableChildren)
            throw Error("Inpossible to add children to non-container shape.");
        if (!this.canInsertToContainer(model, item, container))
            return;
        var oldContainer = item.container;
        if (oldContainer !== container) {
            history.beginTransaction();
            if (oldContainer)
                history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
            history.addAndRedo(new InsertToContainerHistoryItem_1.InsertToContainerHistoryItem(item, container));
            this.updateAttachedConnectorsContainer(history, model, item);
            history.endTransaction();
        }
    };
    ModelUtils.removeFromContainer = function (history, model, item) {
        if (item.container) {
            history.beginTransaction();
            history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
            this.updateAttachedConnectorsContainer(history, model, item);
            history.endTransaction();
        }
    };
    ModelUtils.insertSelectionToContainer = function (history, model, selection, container) {
        var _this = this;
        history.beginTransaction();
        var selectedItems = selection.getSelectedItems();
        var items = selectedItems.filter(function (item) { return !item.container || selectedItems.indexOf(item.container) === -1; });
        items.forEach(function (item) {
            _this.insertToContainer(history, model, item, container);
        });
        history.endTransaction();
    };
    ModelUtils.removeSelectionFromContainer = function (history, model, selection) {
        var _this = this;
        history.beginTransaction();
        selection.getSelectedItems().forEach(function (item) {
            if (item.container && !selection.hasKey(item.container.key)) {
                history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
                _this.updateAttachedConnectorsContainer(history, model, item);
            }
        });
        history.endTransaction();
    };
    ModelUtils.getConnectorContainer = function (connector) {
        if (connector.beginItem && connector.endItem && connector.beginItem.container === connector.endItem.container)
            return connector.beginItem.container;
    };
    ModelUtils.updateAttachedConnectorsContainer = function (history, model, item) {
        var _this = this;
        history.beginTransaction();
        item.attachedConnectors.forEach(function (connector) {
            _this.updateConnectorContainer(history, model, connector);
        });
        history.endTransaction();
    };
    ModelUtils.updateConnectorContainer = function (history, model, connector) {
        var container = this.getConnectorContainer(connector);
        if (container) {
            history.addAndRedo(new InsertToContainerHistoryItem_1.InsertToContainerHistoryItem(connector, container));
        }
        else if (connector.container) {
            history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(connector));
        }
    };
    // Layout
    ModelUtils.applyLayout = function (history, model, container, graph, layout, settings, snapToGrid, gridSize) {
        history.beginTransaction();
        var nonGraphItems = this.getNonGraphItems(model, container, layout.nodeToLayout);
        var occupiedRectangles = this.getOccupiedRectangles(nonGraphItems, container);
        layout = this.offsetLayoutToFreeSpace(layout, container && container.clientRectangle, occupiedRectangles, settings.columnSpacing);
        if (snapToGrid)
            this.adjustLayoutToSnapGrid(model, layout, gridSize);
        if (container)
            this.resizeContainerOnLayout(history, model, layout, container, settings.columnSpacing);
        this.applyLayoutToNodes(history, model, layout, graph.edges.map(function (e) { return model.findConnector(e.key); }));
        this.applyLayoutToConnectors(history, model, layout, graph.edges.map(function (e) { return model.findConnector(e.key); }));
        history.endTransaction();
    };
    ModelUtils.getNonGraphItems = function (model, container, nodeKeyMap) {
        var allItems = container ? model.getChildren(container) : model.items.filter(function (item) { return !item.container; });
        return allItems.filter(function (i) {
            if (i instanceof Connector_1.Connector)
                return (!i.beginItem || !nodeKeyMap[i.beginItem.key]) && (!i.endItem || !nodeKeyMap[i.endItem.key]);
            return !nodeKeyMap[i.key];
        });
    };
    ModelUtils.getOccupiedRectangles = function (nonGraphItems, container) {
        var occupiedRectangles = nonGraphItems.map(function (i) { return i.rectangle; });
        if (container && occupiedRectangles.length) {
            var rect = container.clientRectangle;
            occupiedRectangles.push(Utils_1.Rectangle.create(rect.right, rect.top, 1, 1));
            occupiedRectangles.push(Utils_1.Rectangle.create(rect.right, rect.bottom, 1, 1));
        }
        return occupiedRectangles;
    };
    ModelUtils.offsetLayoutToFreeSpace = function (layout, containerRect, occupiedRectangles, spacing) {
        var graphItemRect = layout.getRectangle(true);
        var freePoint = Utils_1.GeometryUtils.findFreeSpace(occupiedRectangles, graphItemRect.size.offset(spacing, spacing), false, containerRect);
        if (freePoint) {
            var x = freePoint.x + spacing;
            var y = freePoint.y + spacing;
            return layout.offsetNodes(x, y);
        }
        var maxX = occupiedRectangles && occupiedRectangles.length ?
            occupiedRectangles.reduce(function (max, rect) { return rect.right > max ? rect.right : max; }, 0) :
            (containerRect ? containerRect.left : 0);
        var minY = containerRect ? containerRect.top : Math.max(0, graphItemRect.top);
        return layout.offsetNodes(maxX + spacing, minY + spacing);
    };
    ModelUtils.resizeContainerOnLayout = function (history, model, layout, container, spacing) {
        var rect = layout.getRectangle(true);
        var width = container.rectangle.width;
        if (container.rectangle.right < rect.right + spacing)
            width += rect.right + spacing - container.rectangle.right;
        var height = container.rectangle.height;
        if (container.rectangle.bottom < rect.bottom + spacing)
            height += rect.bottom + spacing - container.rectangle.bottom;
        ModelUtils.setShapeSize(history, model, container, container.position, new Utils_1.Size(width, height));
    };
    ModelUtils.applyLayoutToNodes = function (history, model, layout, connectors) {
        var _this = this;
        var connectorsSet = connectors.reduce(function (acc, c) { return acc[c.key] =  true && acc; }, {});
        layout.forEachNode(function (nl, nk) {
            var shape = model.findShape(nk);
            _this.applyLayoutToNode(history, model, shape, nl.position, connectorsSet);
        });
    };
    ModelUtils.applyLayoutToNode = function (history, model, shape, position, connectorsSet) {
        var _this = this;
        var delta = position.offset(-shape.position.x, -shape.position.y);
        ModelUtils.setShapePosition(history, model, shape, position);
        if (delta.x !== 0 || delta.y !== 0) {
            shape.attachedConnectors
                .filter(function (c) { return !connectorsSet[c.key]; })
                .forEach(function (connector) {
                ModelUtils.updateConnectorAttachedPoints(history, model, connector);
                var beginPointIndex = connector.beginItem ? 1 : 0;
                var endPointIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
                for (var i = beginPointIndex; i <= endPointIndex; i++)
                    history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, i, connector.points[i].offset(delta.x, delta.y)));
            });
            model.getChildren(shape).forEach(function (child) {
                if (child instanceof Shape_1.Shape) {
                    var childPosition = child.position.offset(delta.x, delta.y);
                    _this.applyLayoutToNode(history, model, child, childPosition, connectorsSet);
                }
            });
        }
    };
    ModelUtils.applyLayoutToConnectors = function (history, model, layout, connectors) {
        var _this = this;
        connectors.filter(function (c) { return c.beginItem && c.endItem; }).forEach(function (connector) {
            var edgeLayout = layout.edgeToPosition[connector.key];
            if (edgeLayout) {
                if (edgeLayout.beginIndex !== connector.beginConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, edgeLayout.beginIndex, Connector_1.ConnectorPosition.Begin));
                if (edgeLayout.endIndex !== connector.endConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, edgeLayout.endIndex, Connector_1.ConnectorPosition.End));
            }
            _this.updateConnectorAttachedPoints(history, model, connector);
            if (edgeLayout) {
                while (connector.points.length > 2)
                    history.addAndRedo(new DeleteConnectorPointHistoryItem_1.DeleteConnectorPointHistoryItem(connector.key, 1));
            }
        });
    };
    ModelUtils.adjustLayoutToSnapGrid = function (model, layout, gridSize) {
        var _this = this;
        layout.nodeKeys.forEach(function (key) {
            layout.nodeToLayout[key].position.x = _this.getSnappedPos(model, gridSize, layout.nodeToLayout[key].position.x, true);
            layout.nodeToLayout[key].position.y = _this.getSnappedPos(model, gridSize, layout.nodeToLayout[key].position.y, false);
        });
    };
    ModelUtils.getGraphInfoBySelection = function (model, selection) {
        var shapes = selection.getSelectedShapes(false, true);
        var connectors = selection.getSelectedConnectors(false, true);
        return this.getGraphInfoByItems(model, shapes, connectors);
    };
    ModelUtils.getGraphInfoByItems = function (model, shapes, connectors) {
        var itemsByContainerKey = {};
        var items = [].concat(shapes).concat(connectors);
        items.forEach(function (item) {
            var containerKey = item.container && item.container.key;
            if (!itemsByContainerKey[containerKey])
                itemsByContainerKey[containerKey] = [];
            itemsByContainerKey[containerKey].push(item);
        });
        var result = [];
        for (var key in itemsByContainerKey) {
            if (!itemsByContainerKey.hasOwnProperty(key))
                continue;
            if (itemsByContainerKey[key].length) {
                var container = itemsByContainerKey[key][0].container;
                if (!container || container.expanded) {
                    var containerKey = container && container.key;
                    var graph = this.getGraphByItems(model, itemsByContainerKey[key], containerKey);
                    if (graph.nodes.length > 1)
                        result.push(new GraphInfo_1.GraphInfo(container, graph));
                }
            }
        }
        return result;
    };
    ModelUtils.getGraphByItems = function (model, items, containerKey) {
        var _this = this;
        var graph = new Graph_1.Graph([], []);
        var knownIds = {};
        items.forEach(function (item) {
            _this.extendByConnectedComponents(item, graph, containerKey, knownIds);
        });
        graph.nodes = graph.nodes.sort(function (a, b) { return model.getItemIndex(model.findShape(a)) - model.getItemIndex(model.findShape(b)); });
        return graph;
    };
    ModelUtils.extendByConnectedComponents = function (item, graph, containerKey, knownIds) {
        var _this = this;
        if (!item || item.locked || knownIds[item.key])
            return;
        knownIds[item.key] = true;
        if (item instanceof Connector_1.Connector && (item.container && item.container.key) === containerKey &&
            item.beginItem && !item.beginItem.locked && item.endItem && !item.endItem.locked &&
            item.beginItem !== item.endItem) {
            graph.addEdge(new Structures_1.Edge(item.key, item.beginItem && item.beginItem.key, item.endItem && item.endItem.key));
            this.extendByConnectedComponents(item.beginItem, graph, containerKey, knownIds);
            this.extendByConnectedComponents(item.endItem, graph, containerKey, knownIds);
        }
        else if (item instanceof Shape_1.Shape && (item.container && item.container.key) === containerKey) {
            graph.addNode(item);
            item.attachedConnectors.forEach(function (c) { return _this.extendByConnectedComponents(c, graph, containerKey, knownIds); });
        }
    };
    // Units
    ModelUtils.getlUnitValue = function (units, twipsValue) {
        switch (units) {
            case Model_1.DiagramUnit.Cm:
                return UnitConverter_1.UnitConverter.twipsToCentimeters(twipsValue);
            case Model_1.DiagramUnit.In:
                return UnitConverter_1.UnitConverter.twipsToInches(twipsValue);
            case Model_1.DiagramUnit.Px:
                return UnitConverter_1.UnitConverter.twipsToPixels(twipsValue);
        }
    };
    ModelUtils.getUnitText = function (units, unitItems, formatUnit, twipsValue, fractionDigits) {
        if (fractionDigits === void 0) { fractionDigits = 2; }
        var unitItemText = unitItems[units] ? " " + unitItems[units] : "";
        var unitValue = this.getlUnitValue(units, twipsValue);
        switch (units) {
            case Model_1.DiagramUnit.Cm:
                return formatUnit(+unitValue.toFixed(fractionDigits)) + unitItemText;
            case Model_1.DiagramUnit.In:
                return formatUnit(+unitValue.toFixed(fractionDigits)) + unitItemText;
            case Model_1.DiagramUnit.Px:
                return formatUnit(+unitValue.toFixed(0)) + unitItemText;
        }
    };
    ModelUtils.getTwipsValue = function (units, value) {
        switch (units) {
            case Model_1.DiagramUnit.Cm:
                return UnitConverter_1.UnitConverter.centimetersToTwips(value);
            case Model_1.DiagramUnit.In:
                return UnitConverter_1.UnitConverter.inchesToTwips(value);
            case Model_1.DiagramUnit.Px:
                return UnitConverter_1.UnitConverter.pixelsToTwips(value);
        }
    };
    // Key generation
    ModelUtils.getNextItemKey = function (keys, checkKey, baseKey) {
        if (!keys.length && baseKey === undefined)
            return "0";
        for (var i = keys.length - 1; i >= 0; i--) {
            baseKey = baseKey || keys[i];
            if (baseKey !== undefined && baseKey !== null)
                break;
        }
        var key = this.generateNextItemKey(baseKey || "0");
        while (!checkKey(key)) {
            key = this.generateNextItemKey(key);
        }
        return key;
    };
    ModelUtils.generateNextItemKey = function (key) {
        for (var i = key.length - 1; i >= 0; i--) {
            if (!this.isDigit(key[i])) {
                if (i === key.length - 1)
                    key = key + "0";
                break;
            }
            var code = key.charCodeAt(i);
            var char = String.fromCharCode(code + 1);
            if (char > "9") {
                char = "0";
                if (i === 0 || !this.isDigit(key[i - 1]))
                    char = "1" + char;
            }
            key = key.substr(0, i) + char + key.substr(i + 1);
            if (char !== "0" && char !== "10")
                break;
            else if (char === "10")
                i--;
        }
        return key;
    };
    ModelUtils.isDigit = function (char) {
        return "0" <= char && char <= "9";
    };
    ModelUtils.getGuidItemKey = function () {
        return Base_1.CreateGuid();
    };
    return ModelUtils;
}());
exports.ModelUtils = ModelUtils;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var TextPrimitive_1 = __webpack_require__(63);
var ClipPathPrimitive_1 = __webpack_require__(42);
var RectaglePrimitive_1 = __webpack_require__(18);
var DiagramItem_1 = __webpack_require__(4);
var UnitConverter_1 = __webpack_require__(13);
var Utils_2 = __webpack_require__(15);
var ConnectionPoint_1 = __webpack_require__(34);
exports.ShapeDefaultDimension = 1440;
exports.ShapeDefaultSize = new Utils_1.Size(exports.ShapeDefaultDimension, exports.ShapeDefaultDimension);
var ShapeDescription = /** @class */ (function () {
    function ShapeDescription(title, defaultText, defaultSize, defaultImageUrl) {
        if (defaultSize === void 0) { defaultSize = exports.ShapeDefaultSize.clone(); }
        this.title = title;
        this.defaultText = defaultText;
        this.defaultSize = defaultSize;
        this.defaultImageUrl = defaultImageUrl;
        this.connectionPoints = this.createConnectionPoints();
        this.connectionPointsWhileSelected = this.createConnectionPointsForSelection();
    }
    Object.defineProperty(ShapeDescription.prototype, "enableText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "allowEditText", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "enableImage", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "allowEditImage", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "enableChildren", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    ShapeDescription.prototype.getConnectionPoints = function () {
        return this.connectionPoints;
    };
    ShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ShapeDescription.prototype.getConnectionPointsForSelection = function () {
        return this.connectionPointsWhileSelected;
    };
    ShapeDescription.prototype.createConnectionPointsForSelection = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ShapeDescription.prototype.processConnectionPoint = function (shape, point) {
    };
    ShapeDescription.prototype.createParameters = function (parameters) {
    };
    ShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
    };
    ShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        throw Error("Not implemented");
    };
    ShapeDescription.prototype.changeParameterValue = function (parameters, key, change) {
        var p = parameters.get(key);
        p.value = change(p);
    };
    ShapeDescription.prototype.getParameterPoints = function (shape) {
        return [];
    };
    ShapeDescription.prototype.getExpandedSize = function (size, expandedSize) {
        return size;
    };
    ShapeDescription.prototype.getCollapsedSize = function (size) {
        return size;
    };
    ShapeDescription.prototype.getToolboxHeightToWidthRatio = function (width, height) {
        return height / width;
    };
    ShapeDescription.prototype.allowResizeHorizontally = function (shape) {
        return true;
    };
    ShapeDescription.prototype.allowResizeVertically = function (shape) {
        return true;
    };
    ShapeDescription.prototype.createPrimitives = function (shape, forToolbox) {
        var primitives = [];
        primitives = primitives.concat(this.createShapePrimitives(shape, forToolbox));
        if (this.enableImage)
            primitives = primitives.concat(this.createImagePrimitives(shape, forToolbox));
        if (this.enableText)
            primitives = primitives.concat(this.createTextPrimitives(shape, forToolbox));
        return primitives;
    };
    ShapeDescription.prototype.createImagePrimitives = function (shape, forToolbox) {
        return [];
    };
    ShapeDescription.prototype.createTextPrimitives = function (shape, forToolbox) {
        if (shape.text === undefined || shape.text === "")
            return [];
        var rect = this.getTextRectangle(shape.rectangle);
        var clipPathId = !forToolbox && Utils_2.RenderUtils.generateSvgElementId("clipText");
        var textPoint = this.getTextPosition(rect, shape.styleText["text-anchor"]);
        return [
            new TextPrimitive_1.TextPrimitive(textPoint.x, textPoint.y, shape.text, rect.width, shape.styleText, false, clipPathId, undefined, this.getTextRotated()),
            new ClipPathPrimitive_1.ClipPathPrimitive(clipPathId, [new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.width, rect.height)]),
        ];
    };
    ShapeDescription.prototype.getTextRotated = function () {
        return false;
    };
    ShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect;
    };
    ShapeDescription.prototype.getClientRectangle = function (rect) {
        return rect;
    };
    ShapeDescription.prototype.getTextEditRectangle = function (rect) {
        return this.getTextRectangle(rect);
    };
    ShapeDescription.prototype.createSelectorPrimitives = function (shape) {
        return [
            new RectaglePrimitive_1.RectanglePrimitive(shape.position.x, shape.position.y, shape.size.width, shape.size.height, null, "selector")
        ];
    };
    ShapeDescription.prototype.getTextPosition = function (rect, textAnchor) {
        var result = new Utils_1.Point(rect.left, rect.top + rect.height / 2);
        if (!textAnchor || textAnchor === "middle")
            result.x = rect.left + rect.width / 2;
        else if (textAnchor === "end")
            result.x = rect.left + rect.width - ShapeDescription.textSpacing;
        else if (textAnchor === "start")
            result.x = rect.left + ShapeDescription.textSpacing;
        return result;
    };
    ShapeDescription.textSpacing = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    return ShapeDescription;
}());
exports.ShapeDescription = ShapeDescription;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(28);
var UnitConverter_1 = __webpack_require__(13);
var DiagramItem_1 = __webpack_require__(4);
var ConnectionPoint_1 = __webpack_require__(34);
var ImageInfo_1 = __webpack_require__(40);
var Shape = /** @class */ (function (_super) {
    __extends(Shape, _super);
    function Shape(description, position) {
        var _this = _super.call(this) || this;
        _this.description = description;
        // Containers
        _this.childKeys = [];
        _this.expanded = true;
        _this.expandedSize = undefined;
        if (!description)
            throw Error("Shape type is incorrect");
        _this.position = position.clone();
        _this.size = description.defaultSize.clone();
        _this.text = description.defaultText;
        _this.image = new ImageInfo_1.ImageInfo(description.defaultImageUrl);
        _this.parameters = new ShapeParameters_1.ShapeParameters();
        description.createParameters(_this.parameters);
        return _this;
    }
    Shape.prototype.assign = function (item) {
        _super.prototype.assign.call(this, item);
        item.size = this.size.clone();
        item.text = this.text;
        item.image = this.image.clone();
        item.parameters = this.parameters.clone();
        item.childKeys = this.childKeys.slice();
        item.expanded = this.expanded;
        if (this.expandedSize)
            item.expandedSize = this.expandedSize.clone();
    };
    Shape.prototype.clone = function () {
        var clone = new Shape(this.description, this.position.clone());
        this.assign(clone);
        return clone;
    };
    Object.defineProperty(Shape.prototype, "enableText", {
        get: function () { return this.description.enableText; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "allowEditText", {
        get: function () { return this.description.allowEditText; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "enableChildren", {
        get: function () { return this.description.enableChildren; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "enableImage", {
        get: function () { return this.description.enableImage; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "allowEditImage", {
        get: function () { return this.description.allowEditImage; },
        enumerable: true,
        configurable: true
    });
    Shape.prototype.createPrimitives = function () {
        return this.description.createPrimitives(this);
    };
    Shape.prototype.createSelectorPrimitives = function () {
        return this.description.createSelectorPrimitives(this);
    };
    Shape.prototype.normalizeX = function (x) {
        return Math.max(this.position.x, Math.min(x, this.position.x + this.size.width));
    };
    Shape.prototype.normalizeY = function (y) {
        return Math.max(this.position.y, Math.min(y, this.position.y + this.size.height));
    };
    Shape.prototype.getConnectionPoints = function () {
        var _this = this;
        var result = this.description.getConnectionPoints().map(function (pt) {
            var point = new ConnectionPoint_1.ConnectionPoint(_this.position.x + pt.x * _this.size.width, _this.position.y + pt.y * _this.size.height, pt.side);
            _this.description.processConnectionPoint(_this, point);
            return point;
        });
        return result;
    };
    Shape.prototype.getConnectionPointsForSelection = function () {
        var _this = this;
        var result = this.description.getConnectionPointsForSelection().map(function (pt) {
            var point = new ConnectionPoint_1.ConnectionPoint(_this.position.x + pt.x * _this.size.width, _this.position.y + pt.y * _this.size.height, pt.side);
            return point;
        });
        return result;
    };
    Shape.prototype.getConnectionPointSide = function (point, targetPoint) {
        if (point.side !== DiagramItem_1.ConnectionPointSide.Undefined)
            return point.side;
        return this.getConnectionPointSideByGeometry(point);
    };
    Shape.prototype.getConnectionPointForSelectionSide = function (point) {
        if (point.side !== DiagramItem_1.ConnectionPointSide.Undefined)
            return point.side;
        return this.getConnectionPointSideByGeometry(point);
    };
    Shape.prototype.getConnectionPointSideByGeometry = function (point) {
        var pt = point.offset(-this.position.x, -this.position.y).multiply(1 / this.size.width, 1 / this.size.height);
        if (pt.x >= pt.y && (pt.x > 0 || pt.y > 0)) {
            if (pt.x < 0.5 || (1 - pt.x) >= pt.y)
                return DiagramItem_1.ConnectionPointSide.North;
            return DiagramItem_1.ConnectionPointSide.East;
        }
        else {
            if (pt.x > 0.5 || (1 - pt.x) <= pt.y)
                return DiagramItem_1.ConnectionPointSide.South;
            return DiagramItem_1.ConnectionPointSide.West;
        }
    };
    Shape.prototype.toggleExpandedSize = function () {
        if (!this.expanded) {
            this.expandedSize = this.size.clone();
            this.size = this.getCollapsedSize();
        }
        else {
            this.size = this.getExpandedSize();
            this.expandedSize = undefined;
        }
    };
    Shape.prototype.getExpandedSize = function () {
        return this.description.getExpandedSize(this.size, this.expandedSize);
    };
    Shape.prototype.getCollapsedSize = function () {
        return this.description.getCollapsedSize(this.size);
    };
    Shape.prototype.getToolboxHeightToWidthRatio = function () {
        return this.description.getToolboxHeightToWidthRatio(this.size.width, this.size.height);
    };
    Object.defineProperty(Shape.prototype, "allowResizeHorizontally", {
        get: function () {
            return this.description.allowResizeHorizontally(this);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "allowResizeVertically", {
        get: function () {
            return this.description.allowResizeVertically(this);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "rectangle", {
        get: function () {
            return new Utils_1.Rectangle(this.position, this.size);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "clientRectangle", {
        get: function () {
            return this.description.getClientRectangle(this.rectangle);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "textRectangle", {
        get: function () {
            return this.description.getTextRectangle(this.rectangle);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Shape.prototype, "textEditRectangle", {
        get: function () {
            return this.description.getTextEditRectangle(this.rectangle);
        },
        enumerable: true,
        configurable: true
    });
    Shape.lineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    return Shape;
}(DiagramItem_1.DiagramItem));
exports.Shape = Shape;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CommandManager_1 = __webpack_require__(62);
exports.DiagramCommand = CommandManager_1.DiagramCommand;
var Diagram_1 = __webpack_require__(257);
exports.DiagramControl = Diagram_1.DiagramControl;
var Utils_1 = __webpack_require__(0);
exports.EventDispatcher = Utils_1.EventDispatcher;
var ShapeTypes_1 = __webpack_require__(1);
exports.ShapeTypes = ShapeTypes_1.ShapeTypes;
exports.ShapeCategories = ShapeTypes_1.ShapeCategories;
exports.ShapeType = ShapeTypes_1.ShapeType;
var UnitConverter_1 = __webpack_require__(13);
exports.UnitConverter = UnitConverter_1.UnitConverter;
var Browser_1 = __webpack_require__(24);
exports.Browser = Browser_1.Browser;
var DiagramSettings_1 = __webpack_require__(41);
exports.AutoZoomMode = DiagramSettings_1.AutoZoomMode;
var DataLayoutParameters_1 = __webpack_require__(112);
exports.DataLayoutType = DataLayoutParameters_1.DataLayoutType;
var LayoutSettings_1 = __webpack_require__(21);
exports.DataLayoutOrientation = LayoutSettings_1.DataLayoutOrientation;
__webpack_require__(300);
var Model_1 = __webpack_require__(23);
exports.DiagramUnit = Model_1.DiagramUnit;
exports.PageOrientation = Model_1.PageOrientation;
var ConnectorProperties_1 = __webpack_require__(25);
exports.ConnectorLineEnding = ConnectorProperties_1.ConnectorLineEnding;
exports.ConnectorLineOption = ConnectorProperties_1.ConnectorLineOption;
var Color_1 = __webpack_require__(38);
exports.ColorHelper = Color_1.ColorHelper;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Event_1 = __webpack_require__(12);
var Evt_1 = __webpack_require__(48);
var Utils_1 = __webpack_require__(0);
var Base_1 = __webpack_require__(19);
var KeyCode_1 = __webpack_require__(16);
var Browser_1 = __webpack_require__(24);
var Utils_2 = __webpack_require__(15);
var TouchUIHelper_1 = __webpack_require__(81);
var CanvasItemsManager_1 = __webpack_require__(39);
var ScrollController_1 = __webpack_require__(126);
var DiagramSettings_1 = __webpack_require__(41);
var InputManager_1 = __webpack_require__(127);
var CanvasPageManager_1 = __webpack_require__(128);
var CanvasViewManager_1 = __webpack_require__(130);
var CanvasSelectionManager_1 = __webpack_require__(132);
exports.svgNS = "http://www.w3.org/2000/svg";
var PADDING_NORMALIZATION_TIMEOUT = 500;
var RenderManager = /** @class */ (function () {
    function RenderManager(parent, events, settings) {
        this.moveLocked = false;
        this.normalizationRequired = false;
        var mainElement = RenderManager.createMainElement(parent);
        var svgElement = RenderManager.createSvgElement(mainElement);
        var scroll = settings.scrollView || new ScrollController_1.NativeScrollView(mainElement);
        this.autoScroll = new AutoScrollController(scroll, mainElement);
        this.view = new CanvasViewManager_1.CanvasViewManager(scroll, svgElement, settings.modelSize, settings.zoomLevel, settings.autoZoom, settings.simpleView, settings.rectangle);
        this.input = new InputManager_1.InputManager(parent, mainElement, this.view, events, settings.zoomLevel);
        this.items = new CanvasItemsManager_1.CanvasItemsManager(this.view.canvasElement, settings.zoomLevel);
        this.page = new CanvasPageManager_1.CanvasPageManager(this.view.pageElement, settings);
        this.selection = new CanvasSelectionManager_1.CanvasSelectionManager(this.view.canvasElement, settings.zoomLevel, settings.readOnly);
        this.view.onViewChanged.add(this.page);
        this.view.onViewChanged.add(this.items);
        this.view.onViewChanged.add(this.selection);
        this.view.onViewChanged.add(this.input);
        this.initEvents(svgElement, scroll);
        this.mainElement = mainElement;
        this.events = events;
    }
    RenderManager.prototype.replaceParent = function (parent) {
        if (this.mainElement && this.mainElement.parentNode !== parent)
            parent.appendChild(this.mainElement);
        this.input.replaceParent(parent);
    };
    RenderManager.prototype.update = function (saveScrollPosition) {
        this.view.update({ horizontal: !saveScrollPosition, vertical: !saveScrollPosition });
        this.page.redraw();
    };
    RenderManager.prototype.clear = function () {
        this.items.clear();
        this.selection.clear();
    };
    RenderManager.prototype.initEvents = function (svgElement, scroll) {
        svgElement.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseDownEventName, this.onMouseDown.bind(this));
        svgElement.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseUpEventName, this.onMouseUp.bind(this));
        svgElement.addEventListener("mouseenter", this.onMouseEnter.bind(this));
        svgElement.addEventListener("mouseleave", this.onMouseLeave.bind(this));
        svgElement.addEventListener("wheel", this.onWheel.bind(this));
        svgElement.addEventListener("dblclick", this.onDblClick.bind(this));
        document.addEventListener(TouchUIHelper_1.TouchUIHelper.touchMouseMoveEventName, this.onMouseMove.bind(this));
        window.addEventListener("resize", this.onWindowResize.bind(this));
        scroll.onScroll.add(this);
    };
    RenderManager.prototype.onMouseDown = function (evt) {
        var _this = this;
        this.lockMouseMove();
        this.input.lockFocus();
        this.autoScroll.onMouseDown(evt);
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseDown(e); });
        this.input.captureFocus();
        var srcElement = evt.srcElement;
        var tagName = srcElement && srcElement.tagName;
        if (tagName.toLowerCase() === "img" || tagName.toLowerCase() === "image") // prevent dragging
            return Evt_1.Evt.PreventEventAndBubble(evt);
    };
    RenderManager.prototype.onMouseMove = function (evt) {
        var _this = this;
        if (this.moveLocked)
            return;
        this.tryFinishNormalization(evt);
        this.autoScroll.onMouseMove(evt, function () { return _this.onMouseMoveCore(evt); });
        this.onMouseMoveCore(evt);
        Browser_1.Browser.IE && this.lockMouseMove();
    };
    RenderManager.prototype.onMouseMoveCore = function (evt) {
        var _this = this;
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseMove(e); });
    };
    RenderManager.prototype.onMouseUp = function (evt) {
        var _this = this;
        this.lockMouseMove();
        this.tryFinishNormalization(evt);
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseUp(e); });
        this.autoScroll.onMouseUp(evt);
        this.input.captureFocus();
    };
    RenderManager.prototype.onMouseEnter = function (evt) {
        var _this = this;
        this.autoScroll.onMouseEnter(evt);
        this.tryFinishNormalization(evt);
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseEnter(e); });
    };
    RenderManager.prototype.onMouseLeave = function (evt) {
        var _this = this;
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseLeave(e); });
    };
    RenderManager.prototype.onDblClick = function (evt) {
        var _this = this;
        Utils_2.raiseEvent(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onDblClick(e); });
    };
    RenderManager.prototype.onWindowResize = function () {
        var resetTo = { horizontal: false, vertical: false };
        if (this.view.autoZoom !== DiagramSettings_1.AutoZoomMode.Disabled) {
            resetTo.horizontal = true;
            resetTo.vertical = true;
        }
        else
            resetTo = this.view.checkFitToCanvas();
        this.view.update(resetTo);
    };
    RenderManager.prototype.onWheel = function (evt) {
        var _this = this;
        Utils_2.raiseEvent(evt, this.createDiagramWheelEvent(evt), function (e) { return _this.events.onWheel(e); });
    };
    RenderManager.prototype.notifyModelSizeChanged = function (size, offset) {
        this.view.notifyModelSizeChanged(size, offset);
    };
    RenderManager.prototype.notifyModelRectangleChanged = function (rectangle) {
        this.view.notifyModelRectangleChanged(rectangle);
    };
    RenderManager.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.mainElement.classList.toggle("dxdi-read-only", readOnly);
    };
    RenderManager.prototype.notifyDragStart = function (itemKeys) { };
    RenderManager.prototype.notifyDragEnd = function (itemKeys) { };
    RenderManager.prototype.notifyDragScrollStart = function () {
        this.autoScroll.onDragScrollStart();
    };
    RenderManager.prototype.notifyDragScrollEnd = function () {
        this.autoScroll.onDragScrollEnd();
    };
    RenderManager.prototype.createDiagramMouseEvent = function (evt) {
        var modifiers = KeyCode_1.getKeyModifiers(evt);
        var button = isLeftButtonPressed(evt) ? Event_1.MouseButton.Left : Event_1.MouseButton.Right;
        var offsetPoint = this.getOffsetPoint(evt);
        var layoutPoint = this.getModelPoint(offsetPoint);
        var eventSource = this.getEventSource(evt);
        var isTouch = TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt);
        return new Event_1.DiagramMouseEvent(modifiers, button, offsetPoint, layoutPoint, eventSource, isTouch);
    };
    RenderManager.prototype.createDiagramWheelEvent = function (evt) {
        var modifiers = KeyCode_1.getKeyModifiers(evt);
        var offsetPoint = this.getOffsetPoint(evt);
        var modelPoint = this.view.getModelPoint(offsetPoint);
        var eventSource = this.getEventSource(evt);
        return new Event_1.DiagramWheelEvent(modifiers, evt.deltaX, evt.deltaY, modelPoint, offsetPoint, eventSource);
    };
    RenderManager.prototype.getEventSource = function (evt) {
        var element = evt.srcElement;
        while (element && !this.isDocumentContainer(element)) {
            var src_1 = Utils_2.RenderUtils.getElementEventData(element);
            if (src_1 !== undefined)
                return src_1;
            element = element.parentNode;
        }
        var src = new Event_1.MouseEventSource();
        if (element && this.isDocumentContainer(element))
            src.type = Event_1.MouseEventElementType.Document;
        return src;
    };
    RenderManager.prototype.isDocumentContainer = function (element) {
        return Base_1.ElementHasCssClass(element, "dxdi-control") || Base_1.ElementHasCssClass(element, "dxdi-canvas");
    };
    RenderManager.prototype.lockMouseMove = function () {
        var _this = this;
        this.moveLocked = true;
        setTimeout(function () { return _this.moveLocked = false; }, 10); // because chrome raises 2 events on click: buttonDown and move.
    };
    RenderManager.prototype.getModelPoint = function (offsetPoint) {
        return this.view.getModelPoint(offsetPoint);
    };
    RenderManager.prototype.getOffsetPoint = function (evt) {
        var clientX = Evt_1.Evt.GetEventX(evt);
        var clientY = Evt_1.Evt.GetEventY(evt);
        return this.getOffsetPointByEventPoint(clientX, clientY);
    };
    RenderManager.prototype.getOffsetPointByEventPoint = function (clientX, clientY) {
        var mainElementX = Base_1.GetAbsolutePositionX(this.mainElement);
        var mainElementY = Base_1.GetAbsolutePositionY(this.mainElement);
        return new Utils_1.Point(clientX - mainElementX, clientY - mainElementY);
    };
    RenderManager.prototype.getModelPointByEventPoint = function (clientX, clientY) {
        var offsetPoint = this.getOffsetPointByEventPoint(clientX, clientY);
        return this.view.getModelPoint(offsetPoint);
    };
    RenderManager.prototype.notifyScrollChanged = function () {
        var _this = this;
        if (!this.normalizationRequired) {
            setTimeout(function () {
                _this.normalizationRequired = true;
            }, PADDING_NORMALIZATION_TIMEOUT);
        }
    };
    RenderManager.prototype.tryFinishNormalization = function (evt) {
        if (!this.normalizationRequired)
            return;
        if (!Evt_1.Evt.IsLeftButtonPressed(evt)) {
            this.normalizationRequired = false;
            //this.view.tryNormalizePaddings();
        }
    };
    RenderManager.createSvgElement = function (parent, forExport) {
        if (forExport === void 0) { forExport = false; }
        var svgElement = document.createElementNS(exports.svgNS, "svg");
        svgElement.className.baseVal = "dxdi-canvas" + (forExport ? " export" : "");
        parent && parent.appendChild(svgElement);
        return svgElement;
    };
    RenderManager.createMainElement = function (parent) {
        var element = document.createElement("div");
        element.setAttribute("class", "dxdi-control");
        parent.appendChild(element);
        return element;
    };
    return RenderManager;
}());
exports.RenderManager = RenderManager;
var AutoScrollController = /** @class */ (function () {
    function AutoScrollController(scroll, mainElement) {
        this.scroll = scroll;
        this.mainElement = mainElement;
        this.leftButtonPressed = false;
        this.scrollDragging = false;
        this.scrollTimer = -1;
        this.scrollBarWidth = Base_1.GetVerticalScrollBarWidth();
    }
    AutoScrollController.prototype.onMouseMove = function (evt, raiseMouseMoveFunc) {
        this.clearScrollTimer();
        if (!Evt_1.Evt.IsLeftButtonPressed(evt))
            this.leftButtonPressed = false;
        if (this.canAutoScroll())
            this.changeScrollPosition(evt, raiseMouseMoveFunc, false);
    };
    AutoScrollController.prototype.onMouseDown = function (evt) {
        this.leftButtonPressed = !!Evt_1.Evt.IsLeftButtonPressed(evt);
    };
    AutoScrollController.prototype.onMouseUp = function (evt) {
        this.clearScrollTimer();
        this.leftButtonPressed = false;
    };
    AutoScrollController.prototype.onMouseEnter = function (evt) {
        var _this = this;
        if (Evt_1.Evt.IsLeftButtonPressed(evt)) {
            setTimeout(function () {
                _this.leftButtonPressed = true;
            }, 500);
        }
    };
    AutoScrollController.prototype.onDragScrollStart = function () {
        this.scrollDragging = true;
    };
    AutoScrollController.prototype.onDragScrollEnd = function () {
        this.scrollDragging = false;
    };
    AutoScrollController.prototype.canAutoScroll = function () {
        return this.leftButtonPressed && !this.scrollDragging;
    };
    AutoScrollController.prototype.changeScrollPosition = function (evt, raiseMouseMoveFunc, raiseMouseMove) {
        var _this = this;
        var x = evt.pageX - Base_1.GetAbsolutePositionX(this.mainElement);
        var y = evt.pageY - Base_1.GetAbsolutePositionY(this.mainElement);
        var size = this.scroll.getSize();
        var scrollSize = this.scroll.getScrollSize();
        var width = size.width;
        if (size.width < scrollSize.width)
            width -= this.scrollBarWidth;
        var height = size.height;
        if (size.height < scrollSize.height)
            height -= this.scrollBarWidth;
        var changed = false;
        if (x <= SCROLL_EDGE) {
            this.scroll.offsetScroll(-this.getScrollingOffset(x), 0);
            changed = true;
        }
        else if (width - SCROLL_EDGE <= x) {
            this.scroll.offsetScroll(this.getScrollingOffset(width - x), 0);
            changed = true;
        }
        if (y <= SCROLL_EDGE) {
            this.scroll.offsetScroll(0, -this.getScrollingOffset(y));
            changed = true;
        }
        else if (height - SCROLL_EDGE <= y) {
            this.scroll.offsetScroll(0, this.getScrollingOffset(height - y));
            changed = true;
        }
        if (changed)
            this.scrollTimer = window.setTimeout(function () { return _this.changeScrollPosition(evt, raiseMouseMoveFunc, true); }, SCROLL_DELAY);
        if (raiseMouseMove)
            raiseMouseMoveFunc();
    };
    AutoScrollController.prototype.clearScrollTimer = function () {
        if (this.scrollTimer > -1) {
            window.clearTimeout(this.scrollTimer);
            this.scrollTimer = -1;
        }
    };
    AutoScrollController.prototype.getScrollingOffset = function (edgeOffset) {
        var offset = Math.pow((SCROLL_EDGE - edgeOffset) / SCROLL_RATIO, 2);
        return Math.min(offset, SCROLL_MAXOFFSET);
    };
    AutoScrollController.createMainElement = function (parent) {
        var element = document.createElement("div");
        element.setAttribute("class", "dxdi-control");
        parent.appendChild(element);
        return element;
    };
    AutoScrollController.createSvgElement = function (parent, forExport) {
        if (forExport === void 0) { forExport = false; }
        var svgElement = document.createElementNS(exports.svgNS, "svg");
        svgElement.className.baseVal = "dxdi-canvas" + (forExport ? " export" : "");
        parent.appendChild(svgElement);
        return svgElement;
    };
    return AutoScrollController;
}());
var SCROLL_EDGE = 40, SCROLL_RATIO = 5, SCROLL_MAXOFFSET = 5, SCROLL_DELAY = 50;
function isLeftButtonPressed(evt) {
    return !Browser_1.Browser.MSTouchUI ? Evt_1.Evt.IsLeftButtonPressed(evt) : evt.button != 2;
}


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var KeyCode_1 = __webpack_require__(16);
var MouseButton;
(function (MouseButton) {
    MouseButton[MouseButton["None"] = 0] = "None";
    MouseButton[MouseButton["Left"] = 1] = "Left";
    MouseButton[MouseButton["Right"] = 2] = "Right";
    MouseButton[MouseButton["Middle"] = 4] = "Middle";
})(MouseButton = exports.MouseButton || (exports.MouseButton = {}));
var MouseEventElementType;
(function (MouseEventElementType) {
    MouseEventElementType[MouseEventElementType["Undefined"] = 0] = "Undefined";
    MouseEventElementType[MouseEventElementType["Connector"] = 1] = "Connector";
    MouseEventElementType[MouseEventElementType["ConnectorPoint"] = 2] = "ConnectorPoint";
    MouseEventElementType[MouseEventElementType["ConnectorSide"] = 3] = "ConnectorSide";
    MouseEventElementType[MouseEventElementType["ConnectorOrthogonalSide"] = 4] = "ConnectorOrthogonalSide";
    MouseEventElementType[MouseEventElementType["ConnectorText"] = 5] = "ConnectorText";
    MouseEventElementType[MouseEventElementType["Shape"] = 6] = "Shape";
    MouseEventElementType[MouseEventElementType["ShapeResizeBox"] = 7] = "ShapeResizeBox";
    MouseEventElementType[MouseEventElementType["ShapeParameterBox"] = 8] = "ShapeParameterBox";
    MouseEventElementType[MouseEventElementType["SelectionRect"] = 9] = "SelectionRect";
    MouseEventElementType[MouseEventElementType["ShapeConnectionPoint"] = 10] = "ShapeConnectionPoint";
    MouseEventElementType[MouseEventElementType["ShapeConnection"] = 11] = "ShapeConnection";
    MouseEventElementType[MouseEventElementType["ShapeExpandButton"] = 12] = "ShapeExpandButton";
    MouseEventElementType[MouseEventElementType["Document"] = 13] = "Document";
})(MouseEventElementType = exports.MouseEventElementType || (exports.MouseEventElementType = {}));
var MouseEventSource = /** @class */ (function () {
    function MouseEventSource(type, key, value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }
    return MouseEventSource;
}());
exports.MouseEventSource = MouseEventSource;
var ResizeEventSource;
(function (ResizeEventSource) {
    ResizeEventSource[ResizeEventSource["Undefined"] = 0] = "Undefined";
    ResizeEventSource[ResizeEventSource["ResizeBox_NW"] = 1] = "ResizeBox_NW";
    ResizeEventSource[ResizeEventSource["ResizeBox_NE"] = 2] = "ResizeBox_NE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SE"] = 3] = "ResizeBox_SE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SW"] = 4] = "ResizeBox_SW";
    ResizeEventSource[ResizeEventSource["ResizeBox_N"] = 5] = "ResizeBox_N";
    ResizeEventSource[ResizeEventSource["ResizeBox_E"] = 6] = "ResizeBox_E";
    ResizeEventSource[ResizeEventSource["ResizeBox_S"] = 7] = "ResizeBox_S";
    ResizeEventSource[ResizeEventSource["ResizeBox_W"] = 8] = "ResizeBox_W";
})(ResizeEventSource = exports.ResizeEventSource || (exports.ResizeEventSource = {}));
var DiagramEvent = /** @class */ (function () {
    function DiagramEvent(modifiers) {
        this.modifiers = modifiers;
    }
    return DiagramEvent;
}());
exports.DiagramEvent = DiagramEvent;
var DiagramFocusEvent = /** @class */ (function (_super) {
    __extends(DiagramFocusEvent, _super);
    function DiagramFocusEvent(inputText) {
        var _this = _super.call(this, KeyCode_1.ModifierKey.None) || this;
        _this.inputText = inputText;
        return _this;
    }
    return DiagramFocusEvent;
}(DiagramEvent));
exports.DiagramFocusEvent = DiagramFocusEvent;
var DiagramMouseEvent = /** @class */ (function (_super) {
    __extends(DiagramMouseEvent, _super);
    function DiagramMouseEvent(modifiers, button, absPoint, layoutPoint, source, isTouch) {
        var _this = _super.call(this, modifiers) || this;
        _this.button = button;
        _this.absPoint = absPoint;
        _this.layoutPoint = layoutPoint;
        _this.source = source;
        _this.isTouch = isTouch;
        _this.scrollX = 0;
        _this.scrollY = 0;
        return _this;
    }
    return DiagramMouseEvent;
}(DiagramEvent));
exports.DiagramMouseEvent = DiagramMouseEvent;
var DiagramWheelEvent = /** @class */ (function (_super) {
    __extends(DiagramWheelEvent, _super);
    function DiagramWheelEvent(modifiers, deltaX, deltaY, layoutPoint, absOffset, source) {
        var _this = _super.call(this, modifiers) || this;
        _this.deltaX = deltaX;
        _this.deltaY = deltaY;
        _this.layoutPoint = layoutPoint;
        _this.absOffset = absOffset;
        _this.source = source;
        return _this;
    }
    return DiagramWheelEvent;
}(DiagramEvent));
exports.DiagramWheelEvent = DiagramWheelEvent;
var DiagramKeyboardEvent = /** @class */ (function (_super) {
    __extends(DiagramKeyboardEvent, _super);
    function DiagramKeyboardEvent(modifiers, keyCode, inputText) {
        var _this = _super.call(this, modifiers) || this;
        _this.keyCode = keyCode;
        _this.inputText = inputText;
        return _this;
    }
    DiagramKeyboardEvent.prototype.getShortcutCode = function () {
        return this.modifiers | this.keyCode;
    };
    return DiagramKeyboardEvent;
}(DiagramEvent));
exports.DiagramKeyboardEvent = DiagramKeyboardEvent;
var DiagramClipboardEvent = /** @class */ (function (_super) {
    __extends(DiagramClipboardEvent, _super);
    function DiagramClipboardEvent(clipboardData) {
        var _this = _super.call(this, KeyCode_1.ModifierKey.None) || this;
        _this.clipboardData = clipboardData;
        return _this;
    }
    return DiagramClipboardEvent;
}(DiagramEvent));
exports.DiagramClipboardEvent = DiagramClipboardEvent;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RichEditUnit;
(function (RichEditUnit) {
    RichEditUnit[RichEditUnit["Centimeter"] = 0] = "Centimeter";
    RichEditUnit[RichEditUnit["Inch"] = 1] = "Inch";
})(RichEditUnit = exports.RichEditUnit || (exports.RichEditUnit = {}));
var UnitConverter = /** @class */ (function () {
    function UnitConverter() {
    }
    UnitConverter.getConverter = function (unit) {
        switch (unit) {
            case RichEditUnit.Centimeter: return new UIUnitConverterCentimeter();
            case RichEditUnit.Inch: return new UIUnitConverterInch();
            default: throw new Error();
        }
    };
    // LAYOUT - PIXELS
    // MODEL  - TWIPS
    // FORMS  - CENTIMETERS / INCHES
    // FONT   - POINTS
    // BORDER WIDTH ON UI - POINTS
    // TO TWIPS (round and no round version)
    UnitConverter.pixelsToTwips = function (value) {
        return Math.round(UnitConverter.pixelsToTwipsF(value));
    };
    UnitConverter.inchesToTwips = function (value) {
        return Math.round(UnitConverter.inchesToTwipsF(value));
    };
    UnitConverter.pointsToTwips = function (value) {
        return Math.round(UnitConverter.pointsToTwipsF(value));
    };
    UnitConverter.picasToTwips = function (value) {
        return Math.round(value * 1440 / UnitConverter.PICAS_PER_INCH);
    };
    UnitConverter.centimetersToTwips = function (value) {
        return Math.round(UnitConverter.centimetersToTwipsF(value));
    };
    UnitConverter.pixelsToTwipsF = function (value) {
        return value * 1440 / UnitConverter.DPI;
    };
    UnitConverter.inchesToTwipsF = function (value) {
        return value * 1440;
    };
    UnitConverter.pointsToTwipsF = function (value) {
        return value * 20;
    };
    UnitConverter.centimetersToTwipsF = function (value) {
        return value * 1440 / UnitConverter.CENTIMETERS_PER_INCH;
    };
    UnitConverter.modelUnitsToDegrees = function (value) {
        return value / 60000;
    };
    UnitConverter.modelUnitsToRadians = function (value) {
        return value / 60000 * Math.PI / 180;
    };
    UnitConverter.degreesToModelUnits = function (value) {
        return value * 60000;
    };
    UnitConverter.radiansToModelUnits = function (value) {
        return value * 60000 / Math.PI * 180;
    };
    UnitConverter.radiansToDegrees = function (value) {
        return value / Math.PI * 180;
    };
    UnitConverter.fdToModelUnits = function (value) {
        return Math.round(value * 1875 / 2048);
    };
    UnitConverter.emuToTwips = function (val) {
        return val / 635;
    };
    // TO PIXELS (round)
    UnitConverter.twipsToPixels = function (value) {
        return Math.round(UnitConverter.twipsToPixelsF(value));
    };
    UnitConverter.inchesToPixels = function (value) {
        return Math.round(UnitConverter.DPI * value);
    };
    UnitConverter.centimeterToPixel = function (value) {
        return Math.round(value / (UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI));
    };
    UnitConverter.pointsToPixels = function (value) {
        return Math.round(value * UnitConverter.DPI / 72);
    };
    // TO PIXELS (no round)
    UnitConverter.pointsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 72;
    };
    UnitConverter.twipsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 1440;
    };
    // TO POINTS (round)
    UnitConverter.pixelsToPoints = function (value) {
        return Math.round(value * 72 / UnitConverter.DPI);
    };
    UnitConverter.twipsToPoints = function (value) {
        return Math.round(this.twipsToPointsF(value));
    };
    // TO POINTS (no round)
    UnitConverter.twipsToPointsF = function (value) {
        return value / 20;
    };
    // TO INCHES (no round)
    UnitConverter.twipsToInches = function (value) {
        return value / 1440;
    };
    UnitConverter.pixelsToInches = function (value) {
        return value / UnitConverter.DPI;
    };
    // TO CENTIMETERS (no round)
    UnitConverter.twipsToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / 1440;
    };
    UnitConverter.pixelToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI;
    };
    // ANOTHER
    UnitConverter.hundredthsOfMillimeterToModelUnits = function (value) {
        return 15 * value / 127;
    };
    UnitConverter.twipsToEmu = function (val) {
        return val * 635;
    };
    UnitConverter.twipsToDegree = function (value) {
        return value / 60000;
    };
    UnitConverter.DPI = 96;
    UnitConverter.CENTIMETERS_PER_INCH = 2.54;
    UnitConverter.PICAS_PER_INCH = 6;
    return UnitConverter;
}());
exports.UnitConverter = UnitConverter;
var UIUnitConverterCentimeter = /** @class */ (function (_super) {
    __extends(UIUnitConverterCentimeter, _super);
    function UIUnitConverterCentimeter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIUnitConverterCentimeter.prototype.getUnits = function () {
        return RichEditUnit.Centimeter;
    };
    UIUnitConverterCentimeter.prototype.twipsToUI = function (value) {
        return UnitConverter.twipsToCentimeters(value);
    };
    UIUnitConverterCentimeter.prototype.UIToTwips = function (value) {
        return UnitConverter.centimetersToTwips(value);
    };
    return UIUnitConverterCentimeter;
}(UnitConverter));
exports.UIUnitConverterCentimeter = UIUnitConverterCentimeter;
var UIUnitConverterInch = /** @class */ (function (_super) {
    __extends(UIUnitConverterInch, _super);
    function UIUnitConverterInch() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIUnitConverterInch.prototype.getUnits = function () {
        return RichEditUnit.Inch;
    };
    UIUnitConverterInch.prototype.twipsToUI = function (value) {
        return UnitConverter.twipsToInches(value);
    };
    UIUnitConverterInch.prototype.UIToTwips = function (value) {
        return UnitConverter.inchesToTwips(value);
    };
    return UIUnitConverterInch;
}(UnitConverter));
exports.UIUnitConverterInch = UIUnitConverterInch;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var RectaglePrimitive_1 = __webpack_require__(18);
var ShapeTypes_1 = __webpack_require__(1);
var RectangleShapeDescription = /** @class */ (function (_super) {
    __extends(RectangleShapeDescription, _super);
    function RectangleShapeDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Rectangle"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(RectangleShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Rectangle; },
        enumerable: true,
        configurable: true
    });
    RectangleShapeDescription.prototype.createShapePrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
        return [
            new RectaglePrimitive_1.RectanglePrimitive(left, top, width, height, shape.style),
        ];
    };
    return RectangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.RectangleShapeDescription = RectangleShapeDescription;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Event_1 = __webpack_require__(12);
var __1 = __webpack_require__(10);
var Utils_1 = __webpack_require__(0);
var Base_1 = __webpack_require__(19);
var RenderUtils = /** @class */ (function () {
    function RenderUtils() {
    }
    RenderUtils.updateSvgElementSize = function (svgElement, width, height, forExport) {
        svgElement.style.width = width + "px";
        svgElement.style.height = height + "px";
        svgElement.setAttribute("viewBox", "0 0 " + width + " " + height);
        if (forExport) {
            svgElement.setAttribute("width", width.toString());
            svgElement.setAttribute("height", height.toString());
        }
    };
    RenderUtils.removeContent = function (element) {
        while (element.firstChild)
            element.removeChild(element.firstChild);
    };
    RenderUtils.setElementEventData = function (element, type, key, value) {
        if (type === Event_1.MouseEventElementType.Undefined)
            return;
        element.setAttribute("data-type", type.toString());
        if (key !== undefined)
            element.setAttribute("data-key", key.toString());
        if (value !== undefined)
            element.setAttribute("data-value", value.toString());
    };
    RenderUtils.getElementEventData = function (element) {
        if (element.getAttribute && element.getAttribute("data-type")) {
            return new Event_1.MouseEventSource(parseInt(element.getAttribute("data-type")), element.getAttribute("data-key"), element.getAttribute("data-value"));
        }
    };
    RenderUtils.getHtmlElementStylePropertyName = function (propertyName) {
        switch (propertyName) {
            case "fill":
                return "color";
            case "text-anchor":
                return "text-align";
        }
        return propertyName;
    };
    RenderUtils.getStylePropertyValue = function (propertyName, propertyValue, reverseTextAnchor) {
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        if (propertyName === "text-anchor" && reverseTextAnchor) {
            if (propertyValue === "start")
                return "end";
            if (propertyValue === "end")
                return "start";
        }
        return propertyValue;
    };
    RenderUtils.applyStyleToElement = function (style, element, reverseTextAnchor) {
        var _this = this;
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        var defaultStyle = style.getDefaultInstance();
        style.forEach(function (propertyName) {
            var propertyValue = style[propertyName];
            var elPropertyName = (element instanceof HTMLElement) ? _this.getHtmlElementStylePropertyName(propertyName) : propertyName;
            if (propertyValue !== undefined && propertyValue !== "" && propertyValue !== defaultStyle[propertyName])
                element.style.setProperty(elPropertyName, _this.getStylePropertyValue(propertyName, propertyValue, reverseTextAnchor));
            else
                element.style.setProperty(elPropertyName, "");
        });
    };
    RenderUtils.generateSvgElementId = function (prefix) {
        return prefix + "_" + Base_1.CreateGuid();
    };
    RenderUtils.getSvgTextRectangle = function (textEl, lineWidth) {
        if (lineWidth === void 0) { lineWidth = 0; }
        var bBox;
        try {
            bBox = textEl.getBBox();
        }
        catch (_a) { } // TODO make measure in another way because of FF error
        if (bBox) {
            var x = __1.UnitConverter.pixelsToTwips(Math.round(bBox.x)) - lineWidth;
            var y = __1.UnitConverter.pixelsToTwips(Math.round(bBox.y)) - lineWidth;
            var width = __1.UnitConverter.pixelsToTwips(Math.round(bBox.width)) + 2 * lineWidth;
            var height = __1.UnitConverter.pixelsToTwips(Math.round(bBox.height)) + 2 * lineWidth;
            return Utils_1.Rectangle.create(x, y, width, height);
        }
        return Utils_1.Rectangle.create(0, 0, 0, 0);
    };
    return RenderUtils;
}());
exports.RenderUtils = RenderUtils;
function raiseEvent(evt, _evt, raiseFunc) {
    raiseFunc(_evt);
    if (_evt.preventDefault)
        evt.preventDefault();
}
exports.raiseEvent = raiseEvent;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ModifierKey;
(function (ModifierKey) {
    ModifierKey[ModifierKey["None"] = 0] = "None";
    ModifierKey[ModifierKey["Ctrl"] = 65536] = "Ctrl";
    ModifierKey[ModifierKey["Shift"] = 262144] = "Shift";
    ModifierKey[ModifierKey["Alt"] = 1048576] = "Alt";
    ModifierKey[ModifierKey["Meta"] = 16777216] = "Meta";
})(ModifierKey = exports.ModifierKey || (exports.ModifierKey = {}));
var KeyCode;
(function (KeyCode) {
    KeyCode[KeyCode["Backspace"] = 8] = "Backspace";
    KeyCode[KeyCode["Tab"] = 9] = "Tab";
    KeyCode[KeyCode["Enter"] = 13] = "Enter";
    KeyCode[KeyCode["Pause"] = 19] = "Pause";
    KeyCode[KeyCode["CapsLock"] = 20] = "CapsLock";
    KeyCode[KeyCode["Esc"] = 27] = "Esc";
    KeyCode[KeyCode["Space"] = 32] = "Space";
    KeyCode[KeyCode["PageUp"] = 33] = "PageUp";
    KeyCode[KeyCode["PageDown"] = 34] = "PageDown";
    KeyCode[KeyCode["End"] = 35] = "End";
    KeyCode[KeyCode["Home"] = 36] = "Home";
    KeyCode[KeyCode["Left"] = 37] = "Left";
    KeyCode[KeyCode["Up"] = 38] = "Up";
    KeyCode[KeyCode["Right"] = 39] = "Right";
    KeyCode[KeyCode["Down"] = 40] = "Down";
    KeyCode[KeyCode["Insert"] = 45] = "Insert";
    KeyCode[KeyCode["Delete"] = 46] = "Delete";
    KeyCode[KeyCode["Key_0"] = 48] = "Key_0";
    KeyCode[KeyCode["Key_1"] = 49] = "Key_1";
    KeyCode[KeyCode["Key_2"] = 50] = "Key_2";
    KeyCode[KeyCode["Key_3"] = 51] = "Key_3";
    KeyCode[KeyCode["Key_4"] = 52] = "Key_4";
    KeyCode[KeyCode["Key_5"] = 53] = "Key_5";
    KeyCode[KeyCode["Key_6"] = 54] = "Key_6";
    KeyCode[KeyCode["Key_7"] = 55] = "Key_7";
    KeyCode[KeyCode["Key_8"] = 56] = "Key_8";
    KeyCode[KeyCode["Key_9"] = 57] = "Key_9";
    KeyCode[KeyCode["Key_a"] = 65] = "Key_a";
    KeyCode[KeyCode["Key_b"] = 66] = "Key_b";
    KeyCode[KeyCode["Key_c"] = 67] = "Key_c";
    KeyCode[KeyCode["Key_d"] = 68] = "Key_d";
    KeyCode[KeyCode["Key_e"] = 69] = "Key_e";
    KeyCode[KeyCode["Key_f"] = 70] = "Key_f";
    KeyCode[KeyCode["Key_g"] = 71] = "Key_g";
    KeyCode[KeyCode["Key_h"] = 72] = "Key_h";
    KeyCode[KeyCode["Key_i"] = 73] = "Key_i";
    KeyCode[KeyCode["Key_j"] = 74] = "Key_j";
    KeyCode[KeyCode["Key_k"] = 75] = "Key_k";
    KeyCode[KeyCode["Key_l"] = 76] = "Key_l";
    KeyCode[KeyCode["Key_m"] = 77] = "Key_m";
    KeyCode[KeyCode["Key_n"] = 78] = "Key_n";
    KeyCode[KeyCode["Key_o"] = 79] = "Key_o";
    KeyCode[KeyCode["Key_p"] = 80] = "Key_p";
    KeyCode[KeyCode["Key_q"] = 81] = "Key_q";
    KeyCode[KeyCode["Key_r"] = 82] = "Key_r";
    KeyCode[KeyCode["Key_s"] = 83] = "Key_s";
    KeyCode[KeyCode["Key_t"] = 84] = "Key_t";
    KeyCode[KeyCode["Key_u"] = 85] = "Key_u";
    KeyCode[KeyCode["Key_v"] = 86] = "Key_v";
    KeyCode[KeyCode["Key_w"] = 87] = "Key_w";
    KeyCode[KeyCode["Key_x"] = 88] = "Key_x";
    KeyCode[KeyCode["Key_y"] = 89] = "Key_y";
    KeyCode[KeyCode["Key_z"] = 90] = "Key_z";
    KeyCode[KeyCode["Windows"] = 91] = "Windows";
    KeyCode[KeyCode["ContextMenu"] = 93] = "ContextMenu";
    KeyCode[KeyCode["Numpad_0"] = 96] = "Numpad_0";
    KeyCode[KeyCode["Numpad_1"] = 97] = "Numpad_1";
    KeyCode[KeyCode["Numpad_2"] = 98] = "Numpad_2";
    KeyCode[KeyCode["Numpad_3"] = 99] = "Numpad_3";
    KeyCode[KeyCode["Numpad_4"] = 100] = "Numpad_4";
    KeyCode[KeyCode["Numpad_5"] = 101] = "Numpad_5";
    KeyCode[KeyCode["Numpad_6"] = 102] = "Numpad_6";
    KeyCode[KeyCode["Numpad_7"] = 103] = "Numpad_7";
    KeyCode[KeyCode["Numpad_8"] = 104] = "Numpad_8";
    KeyCode[KeyCode["Numpad_9"] = 105] = "Numpad_9";
    KeyCode[KeyCode["Multiply"] = 106] = "Multiply";
    KeyCode[KeyCode["Add"] = 107] = "Add";
    KeyCode[KeyCode["Subtract"] = 109] = "Subtract";
    KeyCode[KeyCode["Decimal"] = 110] = "Decimal";
    KeyCode[KeyCode["Divide"] = 111] = "Divide";
    KeyCode[KeyCode["F1"] = 112] = "F1";
    KeyCode[KeyCode["F2"] = 113] = "F2";
    KeyCode[KeyCode["F3"] = 114] = "F3";
    KeyCode[KeyCode["F4"] = 115] = "F4";
    KeyCode[KeyCode["F5"] = 116] = "F5";
    KeyCode[KeyCode["F6"] = 117] = "F6";
    KeyCode[KeyCode["F7"] = 118] = "F7";
    KeyCode[KeyCode["F8"] = 119] = "F8";
    KeyCode[KeyCode["F9"] = 120] = "F9";
    KeyCode[KeyCode["F10"] = 121] = "F10";
    KeyCode[KeyCode["F11"] = 122] = "F11";
    KeyCode[KeyCode["F12"] = 123] = "F12";
    KeyCode[KeyCode["NumLock"] = 144] = "NumLock";
    KeyCode[KeyCode["ScrollLock"] = 145] = "ScrollLock";
    KeyCode[KeyCode["Semicolon"] = 186] = "Semicolon";
    KeyCode[KeyCode["Equals"] = 187] = "Equals";
    KeyCode[KeyCode["Comma"] = 188] = "Comma";
    KeyCode[KeyCode["Dash"] = 189] = "Dash";
    KeyCode[KeyCode["Period"] = 190] = "Period";
    KeyCode[KeyCode["ForwardSlash"] = 191] = "ForwardSlash";
    KeyCode[KeyCode["GraveAccent"] = 192] = "GraveAccent";
    KeyCode[KeyCode["OpenBracket"] = 219] = "OpenBracket";
    KeyCode[KeyCode["BackSlash"] = 220] = "BackSlash";
    KeyCode[KeyCode["CloseBracket"] = 221] = "CloseBracket";
    KeyCode[KeyCode["SingleQuote"] = 222] = "SingleQuote";
})(KeyCode = exports.KeyCode || (exports.KeyCode = {}));
function getKeyModifiers(evt) {
    var result = 0;
    if (evt.altKey)
        result |= ModifierKey.Alt;
    if (evt.ctrlKey)
        result |= ModifierKey.Ctrl;
    if (evt.shiftKey)
        result |= ModifierKey.Shift;
    if (evt.metaKey)
        result |= ModifierKey.Meta;
    return result;
}
exports.getKeyModifiers = getKeyModifiers;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var Utils_1 = __webpack_require__(15);
var SvgPrimitive = /** @class */ (function () {
    function SvgPrimitive(style, className, clipPathId, onApplyProperties) {
        this.style = style;
        this.className = className;
        this.clipPathId = clipPathId;
        this.onApplyProperties = onApplyProperties;
        this.children = [];
    }
    SvgPrimitive.prototype.createElement = function () {
        var el = this.createMainElement();
        this.createChildElements(el);
        return el;
    };
    SvgPrimitive.prototype.createChildElements = function (parent) {
        for (var i = 0; i < this.children.length; i++)
            parent.appendChild(this.children[i].createElement());
    };
    SvgPrimitive.prototype.applyElementProperties = function (element) {
        this.applyElementStyleProperties(element);
        if (this.className)
            element.setAttribute("class", this.className);
        if (typeof this.clipPathId === "string") {
            if (this.clipPathId)
                element.setAttribute("clip-path", "url(#" + this.clipPathId + ")");
            else
                element.removeAttribute("clip-path");
        }
        if (this.onApplyProperties)
            this.onApplyProperties(element);
        this.applyChildrenProperties(element);
    };
    SvgPrimitive.prototype.applyChildrenProperties = function (element) {
        for (var i = 0; i < this.children.length; i++)
            this.children[i].applyElementProperties(element.childNodes[i]);
    };
    SvgPrimitive.prototype.applyElementStyleProperties = function (element) {
        this.applyElementStylePropertiesCore(element);
    };
    SvgPrimitive.prototype.applyElementStylePropertiesCore = function (element, reverseTextAnchor) {
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        if (this.style)
            Utils_1.RenderUtils.applyStyleToElement(this.style, element, reverseTextAnchor);
    };
    SvgPrimitive.prototype.setUnitAttribute = function (element, key, value) {
        if (value === undefined || value === null)
            return;
        var valueStr = typeof value === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(value).toString() : value;
        element.setAttribute(key, valueStr);
    };
    SvgPrimitive.prototype.dispose = function () {
        if (this.children)
            this.children.forEach(function (primitive) { return primitive.dispose(); });
    };
    return SvgPrimitive;
}());
exports.SvgPrimitive = SvgPrimitive;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var RectanglePrimitive = /** @class */ (function (_super) {
    __extends(RectanglePrimitive, _super);
    function RectanglePrimitive(x, y, width, height, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    RectanglePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "rect");
    };
    RectanglePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return RectanglePrimitive;
}(Primitive_1.SvgPrimitive));
exports.RectanglePrimitive = RectanglePrimitive;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(24);
var Data_1 = __webpack_require__(82);
var Str_1 = __webpack_require__(124);
var Attr_1 = __webpack_require__(125);
var KeyCode_1 = __webpack_require__(16);
var Evt_1 = __webpack_require__(48);
function IsExists(obj) {
    return (typeof (obj) != "undefined") && (obj != null);
}
exports.IsExists = IsExists;
function IsNumber(str) {
    return !isNaN(parseFloat(str)) && isFinite(str);
}
exports.IsNumber = IsNumber;
;
function SetStyles(element, styles, makeImportant) {
    if (IsExists(styles.cssText))
        element.style.cssText = styles.cssText;
    if (IsExists(styles.className))
        element.className = styles.className;
    for (var property in styles) {
        if (!styles.hasOwnProperty(property))
            continue;
        var value = styles[property];
        switch (property) {
            case "cssText":
            case "className":
                break;
            case "float":
                SetElementFloat(element, value);
                break;
            case "opacity":
                SetElementOpacity(element, value);
                break;
            case "zIndex":
                SetStylesCore(element, property, value, makeImportant);
                break;
            /*jshint -W086 */
            case "fontWeight":
                if (Browser_1.Browser.IE && Browser_1.Browser.Version < 9 && typeof (styles[property]) == "number")
                    value = styles[property].toString();
            default:
                SetStylesCore(element, property, value + (typeof (value) == "number" ? "px" : ""), makeImportant);
            /*jshint +W086 */
        }
    }
}
exports.SetStyles = SetStyles;
;
function SetStylesCore(element, property, value, makeImportant) {
    if (makeImportant) {
        var index = property.search("[A-Z]");
        if (index != -1)
            property = property.replace(property.charAt(index), "-" + property.charAt(index).toLowerCase());
        if (element.style.setProperty)
            element.style.setProperty(property, value, "important");
        else
            element.style.cssText += ";" + property + ":" + value + "!important";
    }
    else
        element.style[property] = value;
}
exports.SetStylesCore = SetStylesCore;
function GetDocumentScrollTop() {
    var isScrollBodyIE = Browser_1.Browser.IE && GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollTop > 0;
    if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge || isScrollBodyIE) {
        if (Browser_1.Browser.MacOSMobilePlatform) //B157267
            return window.pageYOffset;
        if (Browser_1.Browser.WebKitFamily)
            return document.documentElement.scrollTop || document.body.scrollTop;
        return document.body.scrollTop;
    }
    else
        return document.documentElement.scrollTop;
}
exports.GetDocumentScrollTop = GetDocumentScrollTop;
function CloneObject(srcObject) {
    if (typeof (srcObject) != 'object' || srcObject == null)
        return srcObject;
    var newObject = {};
    /* jshint ignore:start */
    for (var i in srcObject)
        newObject[i] = srcObject[i];
    /* jshint ignore:end */
    return newObject;
}
exports.CloneObject = CloneObject;
function GetCurrentStyle(element) {
    if (element.currentStyle)
        return element.currentStyle;
    else if (document.defaultView && document.defaultView.getComputedStyle) {
        var result = document.defaultView.getComputedStyle(element, null);
        if (!result && Browser_1.Browser.Firefox && window.frameElement) {
            var changes = [];
            var curElement = window.frameElement;
            while (!(result = document.defaultView.getComputedStyle(element, null))) {
                changes.push([curElement, curElement.style.display]);
                SetStylesCore(curElement, "display", "block", true);
                curElement = curElement.tagName == "BODY" ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
            }
            result = CloneObject(result);
            for (var ch, i = 0; ch = changes[i]; i++)
                SetStylesCore(ch[0], "display", ch[1], false);
            document.body.offsetWidth; //T334387
        }
        return result;
    }
    return window.getComputedStyle(element, null);
}
exports.GetCurrentStyle = GetCurrentStyle;
function GetDocumentScrollLeft() {
    var isScrollBodyIE = Browser_1.Browser.IE && GetCurrentStyle(document.body).overflow == "hidden" && document.body.scrollLeft > 0;
    if (Browser_1.Browser.Edge || isScrollBodyIE)
        return document.body ? document.body.scrollLeft : document.documentElement.scrollLeft;
    if (Browser_1.Browser.WebKitFamily)
        return document.documentElement.scrollLeft || document.body.scrollLeft;
    return document.documentElement.scrollLeft;
}
exports.GetDocumentScrollLeft = GetDocumentScrollLeft;
exports.focusedElement = null;
function GetFocusedElement() {
    var activeElement = GetActiveElement();
    return activeElement ? activeElement : exports.focusedElement;
}
exports.GetFocusedElement = GetFocusedElement;
function GetActiveElement() {
    try {
        return document.activeElement;
    }
    catch (e) {
        return null;
    }
}
exports.GetActiveElement = GetActiveElement;
;
function focusCore(element, selectAction) {
    try {
        element.focus();
        if (Browser_1.Browser.IE && document.activeElement != element)
            element.focus();
        // Q339238
        if (selectAction) {
            var currentSelection = Selection.GetInfo(element);
            // apply selection only if there is no selection present already
            if (currentSelection.startPos == currentSelection.endPos) {
                switch (selectAction) {
                    case "start":
                        Selection.SetCaretPosition(element, 0);
                        break;
                    case "all":
                        Selection.Set(element);
                        break;
                }
            }
        }
    }
    catch (e) {
    }
}
function SetFocus(element, selectAction) {
    if (Browser_1.Browser.MacOSMobilePlatform) // Q471191
        focusCore(element, selectAction);
    else {
        window.setTimeout(function () {
            focusCore(element, selectAction);
        }, 100);
    }
}
exports.SetFocus = SetFocus;
function GetIsParent(parentElement, element) {
    if (!parentElement || !element)
        return false;
    while (element) {
        if (element === parentElement)
            return true;
        if (element.tagName === "BODY")
            return false;
        element = element.parentNode;
    }
    return false;
}
exports.GetIsParent = GetIsParent;
function ElementContainsCssClass(element, className) {
    //B187659
    try {
        if (!element.className)
            return false;
        return element.className.indexOf(className) != -1;
    }
    catch (e) {
        return false;
    }
}
exports.ElementContainsCssClass = ElementContainsCssClass;
function AddClassNameToElement(element, className) {
    if (!element || typeof (className) !== "string")
        return;
    className = className.trim();
    if (!ElementHasCssClass(element, className) && className !== "")
        element.className = (element.className === "") ? className : element.className + " " + className;
}
exports.AddClassNameToElement = AddClassNameToElement;
function ElementHasCssClass(element, className) {
    //B220674
    try {
        var elementClasses;
        var classList = element.classList;
        if (!classList) {
            if (!element.className)
                return false;
            elementClasses = element.className.split(" ");
        }
        var classNames = className.split(" ");
        for (var i = classNames.length - 1; i >= 0; i--) {
            if (classList) {
                if (!classList.contains(classNames[i]))
                    return false;
                continue;
            }
            if (Data_1.Data.ArrayIndexOf(elementClasses, classNames[i]) < 0)
                return false;
        }
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.ElementHasCssClass = ElementHasCssClass;
function RemoveClassNameFromElement(element, className) {
    if (!element)
        return;
    var updClassName = " " + element.className + " ";
    var newClassName = updClassName.replace(" " + className + " ", " ");
    if (updClassName.length != newClassName.length)
        element.className = Str_1.Str.Trim(newClassName);
}
exports.RemoveClassNameFromElement = RemoveClassNameFromElement;
function GetAbsolutePositionY(element) {
    if (Browser_1.Browser.IE)
        return getAbsolutePositionY_IE(element);
    else if (Browser_1.Browser.Firefox && Browser_1.Browser.Version >= 3)
        return getAbsolutePositionY_FF3(element);
    else if (Browser_1.Browser.Opera)
        return getAbsolutePositionY_Opera(element);
    else if (Browser_1.Browser.NetscapeFamily && (!Browser_1.Browser.Firefox || Browser_1.Browser.Version < 3))
        return getAbsolutePositionY_NS(element);
    else if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge)
        return getAbsolutePositionY_FF3(element);
    else
        return getAbsolutePositionY_Other(element);
}
exports.GetAbsolutePositionY = GetAbsolutePositionY;
function getAbsolutePositionY_Opera(curEl) {
    var isFirstCycle = true;
    if (curEl && curEl.tagName == "TR" && curEl.cells.length > 0)
        curEl = curEl.cells[0];
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle)
            pos -= curEl.scrollTop;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollTop;
    return pos;
}
function getAbsolutePositionY_IE(element) {
    if (element == null || Browser_1.Browser.IE && element.parentNode == null)
        return 0; // B96664
    return element.getBoundingClientRect().top + GetDocumentScrollTop();
}
function getAbsolutePositionY_FF3(element) {
    if (element == null)
        return 0;
    var y = element.getBoundingClientRect().top + GetDocumentScrollTop();
    return Math.round(y);
}
function getAbsolutePositionY_NS(curEl) {
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        if (!isFirstCycle && Browser_1.Browser.Firefox) {
            var style = GetCurrentStyle(curEl);
            if (curEl.tagName == "DIV" && style.overflow != "visible")
                pos += PxToInt(style.borderTopWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsolutePositionY_Other(curEl) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetTop;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollTop;
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        if (curEl.tagName == "BODY")
            break;
        var style = GetCurrentStyle(curEl);
        if (style.position == "absolute")
            break;
        if (!isFirstCycle && curEl.tagName == "DIV" && (style.position == "" || style.position == "static"))
            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        curEl = curEl.parentNode;
        isFirstCycle = false;
    }
    return pos;
}
function PxToInt(px) {
    return pxToNumber(px, parseInt);
}
exports.PxToInt = PxToInt;
;
function PxToFloat(px) {
    return pxToNumber(px, parseFloat);
}
exports.PxToFloat = PxToFloat;
;
function pxToNumber(px, parseFunction) {
    var result = 0;
    if (px != null && px != "") {
        try {
            var indexOfPx = px.indexOf("px");
            if (indexOfPx > -1)
                result = parseFunction(px.substr(0, indexOfPx));
        }
        catch (e) { }
    }
    return result;
}
//function GetAbsolutePositionX(element: HTMLElement): number;
function GetAbsolutePositionX(element) {
    if (Browser_1.Browser.IE)
        return getAbsolutePositionX_IE(element);
    else if (Browser_1.Browser.Firefox && Browser_1.Browser.Version >= 3)
        return getAbsolutePositionX_FF3(element);
    else if (Browser_1.Browser.Opera)
        return getAbsolutePositionX_Opera(element);
    else if (Browser_1.Browser.NetscapeFamily && (!Browser_1.Browser.Firefox || Browser_1.Browser.Version < 3))
        return getAbsolutePositionX_NS(element);
    else if (Browser_1.Browser.WebKitFamily || Browser_1.Browser.Edge)
        return getAbsolutePositionX_FF3(element);
    else
        return getAbsolutePositionX_Other(element);
}
exports.GetAbsolutePositionX = GetAbsolutePositionX;
function getAbsolutePositionX_Opera(curEl) {
    var isFirstCycle = true;
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle)
            pos -= curEl.scrollLeft;
        curEl = curEl.offsetParent;
        isFirstCycle = false;
    }
    pos += document.body.scrollLeft;
    return pos;
}
function getAbsolutePositionX_IE(element) {
    if (element == null || Browser_1.Browser.IE && element.parentNode == null)
        return 0; // B96664
    return element.getBoundingClientRect().left + GetDocumentScrollLeft();
}
function getAbsolutePositionX_FF3(element) {
    if (element == null)
        return 0;
    var x = element.getBoundingClientRect().left + GetDocumentScrollLeft();
    return Math.round(x);
}
function getAbsolutePositionX_NS(curEl) {
    var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        if (!isFirstCycle && Browser_1.Browser.Firefox) {
            var style = GetCurrentStyle(curEl);
            if (curEl.tagName == "DIV" && style.overflow != "visible")
                pos += PxToInt(style.borderLeftWidth);
        }
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function getAbsolutePositionX_Other(curEl) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        pos += curEl.offsetLeft;
        if (!isFirstCycle && curEl.offsetParent != null)
            pos -= curEl.scrollLeft;
        isFirstCycle = false;
        curEl = curEl.offsetParent;
    }
    return pos;
}
function SetAbsoluteX(element, x) {
    element.style.left = prepareClientPosForElement(x, element, true) + "px";
}
exports.SetAbsoluteX = SetAbsoluteX;
;
function SetAbsoluteY(element, y) {
    element.style.top = prepareClientPosForElement(y, element, false) + "px";
}
exports.SetAbsoluteY = SetAbsoluteY;
;
function prepareClientPosForElement(pos, element, isX) {
    pos -= getPositionElementOffset(element, isX);
    return pos;
}
;
function getPositionElementOffset(element, isX) {
    var div = createElementMock(element);
    if (div.style.position == "static")
        div.style.position = "absolute";
    element.parentNode.appendChild(div);
    var realPos = isX ? GetAbsolutePositionX(div) : GetAbsolutePositionY(div);
    element.parentNode.removeChild(div);
    return Math.round(realPos);
}
;
function createElementMock(element) {
    var div = document.createElement('DIV');
    div.style.top = "0px";
    div.style.left = "0px";
    div.style.visibility = "hidden";
    div.style.position = GetCurrentStyle(element).position;
    return div;
}
function IsPercentageSize(size) {
    return size && size.indexOf('%') != -1;
}
exports.IsPercentageSize = IsPercentageSize;
;
function GetChildNodes(parent, predicate) {
    return RetrieveByPredicate(parent.childNodes, predicate);
}
exports.GetChildNodes = GetChildNodes;
;
function GetNodes(parent, predicate) {
    var c = parent.all || parent.getElementsByTagName('*');
    return RetrieveByPredicate(c, predicate);
}
exports.GetNodes = GetNodes;
;
function RetrieveByPredicate(scourceCollection, predicate) {
    var result = [];
    for (var i = 0; i < scourceCollection.length; i++) {
        var element = scourceCollection[i];
        if (!predicate || predicate(element))
            result.push(element);
    }
    return result;
}
exports.RetrieveByPredicate = RetrieveByPredicate;
;
function GetChildNodesByClassName(parent, className) {
    if (!parent)
        return [];
    if (parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);
        return nodeListToArray(children, function (element) {
            return element.parentNode === parent;
        });
    }
    return GetChildNodes(parent, function (elem) { return elem.className && ElementHasCssClass(elem, className); });
}
exports.GetChildNodesByClassName = GetChildNodesByClassName;
function nodeListToArray(nodeList, filter) {
    var result = [];
    for (var i = 0, element; element = nodeList[i]; i++) {
        if (filter && !filter(element))
            continue;
        result.push(element);
    }
    return result;
}
function GetNodesByClassName(parent, className) {
    if (parent.querySelectorAll) {
        var children = parent.querySelectorAll('.' + className);
        return nodeListToArray(children, null);
    }
    return GetNodes(parent, function (elem) { return elem.className && ElementHasCssClass(elem, className); });
}
exports.GetNodesByClassName = GetNodesByClassName;
function GetParentByClassName(element, className) {
    while (element != null) {
        if (element.tagName == "BODY" || element.nodeName == "#document")
            return null;
        if (ElementContainsCssClass(element, className))
            return element;
        element = element.parentNode;
    }
    return null;
}
exports.GetParentByClassName = GetParentByClassName;
function GetParentByTagName(element, tagName) {
    tagName = tagName.toUpperCase();
    while (element) {
        if (element.tagName === "BODY")
            return null;
        if (element.tagName === tagName)
            return element;
        element = element.parentNode;
    }
    return null;
}
exports.GetParentByTagName = GetParentByTagName;
var html2PlainTextFilter = null;
function setInnerHtmlInternal(el, trustedHtmlString) {
    el.innerHTML = trustedHtmlString;
}
exports.setInnerHtmlInternal = setInnerHtmlInternal;
function SetElementDisplay(element, value, checkCurrentStyle, makeInline) {
    if (!element)
        return;
    if (typeof (value) === "string")
        element.style.display = value;
    else if (!value)
        element.style.display = "none";
    else {
        element.style.display = "";
        if (checkCurrentStyle && GetCurrentStyle(element).display === "none") {
            var displayAddon = makeInline ? "inline-" : "";
            switch (element.tagName) {
                case "TABLE": {
                    element.style.display = displayAddon + "table";
                    break;
                }
                default: {
                    element.style.display = displayAddon + "block";
                    break;
                }
            }
        }
    }
}
exports.SetElementDisplay = SetElementDisplay;
function GetInnerText(container) {
    if (Browser_1.Browser.Safari && Browser_1.Browser.MajorVersion <= 5) {
        var filter = getHtml2PlainTextFilter();
        setInnerHtmlInternal(filter, container.innerHTML);
        SetElementDisplay(filter, true, false, false);
        var innerText = filter.innerText;
        SetElementDisplay(filter, false, false, false);
        return innerText;
    }
    else if (Browser_1.Browser.NetscapeFamily || Browser_1.Browser.WebKitFamily || (Browser_1.Browser.IE && Browser_1.Browser.Version >= 9) || Browser_1.Browser.Edge) {
        return container.textContent;
    }
    else
        return container.innerText;
}
exports.GetInnerText = GetInnerText;
function getHtml2PlainTextFilter() {
    if (html2PlainTextFilter == null) {
        html2PlainTextFilter = document.createElement("DIV");
        html2PlainTextFilter.style.width = "0";
        html2PlainTextFilter.style.height = "0";
        html2PlainTextFilter.style.overflow = "visible";
        SetElementDisplay(html2PlainTextFilter, false, false, false);
        document.body.appendChild(html2PlainTextFilter);
    }
    return html2PlainTextFilter;
}
var verticalScrollBarWidth;
function GetVerticalScrollBarWidth() {
    if (typeof (verticalScrollBarWidth) == "undefined") {
        var container = document.createElement("DIV");
        container.style.cssText = "position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box";
        document.body.appendChild(container);
        var child = document.createElement("P");
        container.appendChild(child);
        child.style.cssText = "width: 100%; height: 200px;";
        var widthWithoutScrollBar = child.offsetWidth;
        container.style.overflow = "scroll";
        var widthWithScrollBar = child.offsetWidth;
        if (widthWithoutScrollBar == widthWithScrollBar)
            widthWithScrollBar = container.clientWidth;
        verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
        document.body.removeChild(container);
    }
    return verticalScrollBarWidth;
}
exports.GetVerticalScrollBarWidth = GetVerticalScrollBarWidth;
function GetHorizontalBordersWidth(element, style) {
    if (!IsExists(style))
        style = (Browser_1.Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : GetCurrentStyle(element);
    var res = 0;
    if (style.borderLeftStyle != "none")
        res += PxToFloat(style.borderLeftWidth);
    if (style.borderRightStyle != "none")
        res += PxToFloat(style.borderRightWidth);
    return res;
}
exports.GetHorizontalBordersWidth = GetHorizontalBordersWidth;
function GetVerticalBordersWidth(element, style) {
    if (!IsExists(style))
        style = (Browser_1.Browser.IE && Browser_1.Browser.MajorVersion != 9 && window.getComputedStyle) ? window.getComputedStyle(element) : GetCurrentStyle(element);
    var res = 0;
    if (style.borderTopStyle != "none")
        res += PxToFloat(style.borderTopWidth);
    if (style.borderBottomStyle != "none")
        res += PxToFloat(style.borderBottomWidth);
    return res;
}
exports.GetVerticalBordersWidth = GetVerticalBordersWidth;
function SetElementVisibility(element, value) {
    if (!element)
        return;
    if (typeof (value) === "string")
        element.style.visibility = value;
    else
        element.style.visibility = value ? "visible" : "hidden";
}
exports.SetElementVisibility = SetElementVisibility;
;
function SetElementFloat(element, value) {
    if (IsExists(element.style.cssFloat))
        element.style.cssFloat = value;
    else if (IsExists(element.style.styleFloat))
        element.style.styleFloat = value;
    else
        Attr_1.Attr.SetAttribute(element.style, "float", value);
}
exports.SetElementFloat = SetElementFloat;
;
function SetElementOpacity(element, value) {
    var useOpacityStyle = !Browser_1.Browser.IE || Browser_1.Browser.Version > 8;
    if (useOpacityStyle) {
        element.style.opacity = value;
    }
    else {
        if (typeof (element.filters) === "object" && element.filters["DXImageTransform.Microsoft.Alpha"])
            element.filters.item("DXImageTransform.Microsoft.Alpha").Opacity = value * 100;
        else
            element.style.filter = "alpha(opacity=" + (value * 100) + ")";
    }
}
exports.SetElementOpacity = SetElementOpacity;
function CreateGuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0; // trunc fractional part
        var v = c == 'x' ? r : r & 0x3 | 0x8;
        return v.toString(16);
    });
}
exports.CreateGuid = CreateGuid;
function IsUrlContainsClientScript(url) {
    return url.toLowerCase().indexOf("javascript:") !== -1;
}
exports.IsUrlContainsClientScript = IsUrlContainsClientScript;
function IsExistsElement(element) {
    return element && IsValidElement(element);
}
exports.IsExistsElement = IsExistsElement;
function IsValidElement(element) {
    if (!element)
        return false;
    if (!(Browser_1.Browser.Firefox && Browser_1.Browser.Version < 4)) {
        if (element.ownerDocument && element.ownerDocument.body && element.ownerDocument.body.compareDocumentPosition)
            return element.ownerDocument.body.compareDocumentPosition(element) % 2 === 0;
    }
    if (!Browser_1.Browser.Opera && !(Browser_1.Browser.IE && Browser_1.Browser.Version < 9) && element.offsetParent && element.parentNode.tagName)
        return true;
    while (element != null) {
        if (element.tagName == "BODY")
            return true;
        element = element.parentNode;
    }
    return false;
}
exports.IsValidElement = IsValidElement;
function IsInteractiveControl(element) {
    return Data_1.Data.ArrayIndexOf(["A", "INPUT", "SELECT", "OPTION", "TEXTAREA", "BUTTON", "IFRAME"], element.tagName) > -1;
}
exports.IsInteractiveControl = IsInteractiveControl;
function IsActionElement(element) {
    if (!IsExistsElement(element))
        return false;
    var tabIndex = parseInt(Attr_1.Attr.GetAttribute(element, Attr_1.Attr.GetTabIndexAttributeName()));
    var hasTabIndex = !isNaN(tabIndex);
    var hasNonNegativeTabIndex = hasTabIndex && tabIndex > -1;
    var hasNegativeTabIndex = hasTabIndex && tabIndex < 0;
    var tagName = element.tagName;
    var focusableElementTags = ["BUTTON", "SELECT", "TEXTAREA", "OPTION", "IFRAME"];
    var isFocusableCore = IsFocusable(element);
    var isFocusableTag = focusableElementTags.indexOf(tagName) !== -1;
    var isFocusableLink = tagName === "A" && (!!element.href || hasNonNegativeTabIndex);
    var isFocusableInput = tagName === "INPUT" && element.type.toLowerCase() !== "hidden";
    var isFocusableByTabIndex = tagName !== "INPUT" && hasNonNegativeTabIndex;
    var isEditableDiv = tagName == "DIV" && element.contentEditable === "true";
    return isFocusableCore && !hasNegativeTabIndex && (isFocusableTag || isFocusableLink || isFocusableInput || isFocusableByTabIndex || isEditableDiv);
}
exports.IsActionElement = IsActionElement;
function IsFocusable(element, skipContainerVisibilityCheck) {
    if (skipContainerVisibilityCheck === void 0) { skipContainerVisibilityCheck = function () { return false; }; }
    var current = element;
    while (current && current.nodeType == 1) {
        if (current == element || !skipContainerVisibilityCheck(current)) {
            var tagName = current.tagName.toUpperCase();
            if (tagName == "BODY")
                return true;
            var disabledElementTags = ["INPUT", "BUTTON", "TEXTAREA", "SELECT", "OPTION"];
            if (disabledElementTags.indexOf(tagName) !== -1 && current.disabled || !GetElementDisplay(current, false) || !GetElementVisibility(current, false))
                return false;
        }
        current = current.parentNode;
    }
    return true;
}
exports.IsFocusable = IsFocusable;
function GetElementDisplay(element, isCurrentStyle) {
    if (isCurrentStyle)
        return GetCurrentStyle(element).display != "none";
    return element.style.display != "none";
}
exports.GetElementDisplay = GetElementDisplay;
function GetElementVisibility(element, isCurrentStyle) {
    if (isCurrentStyle)
        return GetCurrentStyle(element).visibility != "hidden";
    return element.style.visibility != "hidden";
}
exports.GetElementVisibility = GetElementVisibility;
function GetClearClientHeight(element) {
    return element.offsetHeight - GetTopBottomBordersAndPaddingsSummaryValue(element);
}
exports.GetClearClientHeight = GetClearClientHeight;
function GetTopBottomBordersAndPaddingsSummaryValue(element, currentStyle) {
    return GetTopBottomPaddings(element, currentStyle) + GetVerticalBordersWidth(element, currentStyle);
}
exports.GetTopBottomBordersAndPaddingsSummaryValue = GetTopBottomBordersAndPaddingsSummaryValue;
;
function GetTopBottomPaddings(element, style) {
    var currentStyle = style ? style : GetCurrentStyle(element);
    return PxToInt(currentStyle.paddingTop) + PxToInt(currentStyle.paddingBottom);
}
exports.GetTopBottomPaddings = GetTopBottomPaddings;
;
function ParseShortcutString(shortcutString) {
    if (!shortcutString)
        return 0;
    var isCtrlKey = false;
    var isShiftKey = false;
    var isAltKey = false;
    var isMetaKey = false;
    var keyCode = null;
    var shcKeys = shortcutString.toString().split("+");
    if (shcKeys.length > 0) {
        for (var i = 0; i < shcKeys.length; i++) {
            var key = Str_1.Str.Trim(shcKeys[i].toUpperCase());
            switch (key) {
                case "CONTROL":
                case "CONTROLKEY":
                case "CTRL":
                    isCtrlKey = true;
                    break;
                case "SHIFT":
                case "SHIFTKEY":
                    isShiftKey = true;
                    break;
                case "ALT":
                    isAltKey = true;
                    break;
                case "CMD":
                    isMetaKey = true;
                    break;
                case "F1":
                    keyCode = KeyCode_1.KeyCode.F1;
                    break;
                case "F2":
                    keyCode = KeyCode_1.KeyCode.F2;
                    break;
                case "F3":
                    keyCode = KeyCode_1.KeyCode.F3;
                    break;
                case "F4":
                    keyCode = KeyCode_1.KeyCode.F4;
                    break;
                case "F5":
                    keyCode = KeyCode_1.KeyCode.F5;
                    break;
                case "F6":
                    keyCode = KeyCode_1.KeyCode.F6;
                    break;
                case "F7":
                    keyCode = KeyCode_1.KeyCode.F7;
                    break;
                case "F8":
                    keyCode = KeyCode_1.KeyCode.F8;
                    break;
                case "F9":
                    keyCode = KeyCode_1.KeyCode.F9;
                    break;
                case "F10":
                    keyCode = KeyCode_1.KeyCode.F10;
                    break;
                case "F11":
                    keyCode = KeyCode_1.KeyCode.F11;
                    break;
                case "F12":
                    keyCode = KeyCode_1.KeyCode.F12;
                    break;
                case "RETURN":
                case "ENTER":
                    keyCode = KeyCode_1.KeyCode.Enter;
                    break;
                case "HOME":
                    keyCode = KeyCode_1.KeyCode.Home;
                    break;
                case "END":
                    keyCode = KeyCode_1.KeyCode.End;
                    break;
                case "LEFT":
                    keyCode = KeyCode_1.KeyCode.Left;
                    break;
                case "RIGHT":
                    keyCode = KeyCode_1.KeyCode.Right;
                    break;
                case "UP":
                    keyCode = KeyCode_1.KeyCode.Up;
                    break;
                case "DOWN":
                    keyCode = KeyCode_1.KeyCode.Down;
                    break;
                case "PAGEUP":
                    keyCode = KeyCode_1.KeyCode.PageUp;
                    break;
                case "PAGEDOWN":
                    keyCode = KeyCode_1.KeyCode.PageDown;
                    break;
                case "SPACE":
                    keyCode = KeyCode_1.KeyCode.Space;
                    break;
                case "TAB":
                    keyCode = KeyCode_1.KeyCode.Tab;
                    break;
                case "BACKSPACE":
                case "BACK":
                    keyCode = KeyCode_1.KeyCode.Backspace;
                    break;
                case "CONTEXT":
                    keyCode = KeyCode_1.KeyCode.ContextMenu;
                    break;
                case "ESCAPE":
                case "ESC":
                    keyCode = KeyCode_1.KeyCode.Esc;
                    break;
                case "DELETE":
                case "DEL":
                    keyCode = KeyCode_1.KeyCode.Delete;
                    break;
                case "INSERT":
                case "INS":
                    keyCode = KeyCode_1.KeyCode.Insert;
                    break;
                case "PLUS":
                    keyCode = "+".charCodeAt(0);
                    break;
                default:
                    keyCode = key.charCodeAt(0);
                    break;
            }
        }
    }
    else
        ShowErrorAlert("Invalid shortcut");
    return GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
}
exports.ParseShortcutString = ParseShortcutString;
function ShowErrorAlert(message) {
    message = Str_1.Str.DecodeHtmlViaTextArea(message);
    if (IsExists(message) && message !== "")
        alert(message);
}
exports.ShowErrorAlert = ShowErrorAlert;
;
function GetShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
    var value = keyCode;
    value |= isCtrlKey ? KeyCode_1.ModifierKey.Ctrl : 0;
    value |= isShiftKey ? KeyCode_1.ModifierKey.Shift : 0;
    value |= isAltKey ? KeyCode_1.ModifierKey.Alt : 0;
    value |= isMetaKey ? KeyCode_1.ModifierKey.Meta : 0;
    return value;
}
exports.GetShortcutCode = GetShortcutCode;
;
function GetShortcutCodeByEvent(evt) {
    return GetShortcutCode(Evt_1.Evt.GetKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, Browser_1.Browser.MacOSPlatform ? evt.metaKey : false);
}
exports.GetShortcutCodeByEvent = GetShortcutCodeByEvent;
;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeParameterPoint = /** @class */ (function () {
    function ShapeParameterPoint(key, point) {
        this.key = key;
        this.point = point;
    }
    return ShapeParameterPoint;
}());
exports.ShapeParameterPoint = ShapeParameterPoint;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var LayoutSettings = /** @class */ (function () {
    function LayoutSettings(gridSize) {
        this.orientation = DataLayoutOrientation.Vertical;
        this.direction = LogicalDirectionKind.Forward;
        this.componentSpacing = (gridSize && gridSize * 2 > 720) ? gridSize * 2 : 720;
        this.columnSpacing = (gridSize && gridSize * 2 > Connector_1.Connector.minOffset) ? gridSize * 2 : Connector_1.Connector.minOffset;
        this.layerSpacing = this.columnSpacing * 2;
    }
    return LayoutSettings;
}());
exports.LayoutSettings = LayoutSettings;
var TreeLayoutSettings = /** @class */ (function (_super) {
    __extends(TreeLayoutSettings, _super);
    function TreeLayoutSettings(gridSize) {
        var _this = _super.call(this, gridSize) || this;
        _this.alignment = Alignment.Center;
        _this.subTreeColumnSpacing = _this.componentSpacing / 2;
        return _this;
    }
    return TreeLayoutSettings;
}(LayoutSettings));
exports.TreeLayoutSettings = TreeLayoutSettings;
var LogicalDirectionKind;
(function (LogicalDirectionKind) {
    LogicalDirectionKind[LogicalDirectionKind["Backward"] = 0] = "Backward";
    LogicalDirectionKind[LogicalDirectionKind["Forward"] = 1] = "Forward";
})(LogicalDirectionKind = exports.LogicalDirectionKind || (exports.LogicalDirectionKind = {}));
var DataLayoutOrientation;
(function (DataLayoutOrientation) {
    DataLayoutOrientation[DataLayoutOrientation["Horizontal"] = 0] = "Horizontal";
    DataLayoutOrientation[DataLayoutOrientation["Vertical"] = 1] = "Vertical";
})(DataLayoutOrientation = exports.DataLayoutOrientation || (exports.DataLayoutOrientation = {}));
var Alignment;
(function (Alignment) {
    Alignment[Alignment["Left"] = 0] = "Left";
    Alignment[Alignment["Center"] = 1] = "Center";
})(Alignment = exports.Alignment || (exports.Alignment = {}));


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var GroupPrimitive = /** @class */ (function (_super) {
    __extends(GroupPrimitive, _super);
    function GroupPrimitive(children, className, zIndex, clipPathId, onApplyProperties) {
        var _this = _super.call(this, null, className, clipPathId, onApplyProperties) || this;
        _this.zIndex = zIndex;
        _this.children = children;
        return _this;
    }
    GroupPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "g");
    };
    GroupPrimitive.prototype.applyElementProperties = function (element) {
        if (this.zIndex || this.zIndex === 0)
            element.style.setProperty("z-index", this.zIndex.toString());
        _super.prototype.applyElementProperties.call(this, element);
    };
    return GroupPrimitive;
}(Primitive_1.SvgPrimitive));
exports.GroupPrimitive = GroupPrimitive;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Utils_1 = __webpack_require__(0);
var ModelUtils_1 = __webpack_require__(7);
var ImageCache_1 = __webpack_require__(49);
var Color_1 = __webpack_require__(38);
var DiagramUnit;
(function (DiagramUnit) {
    DiagramUnit[DiagramUnit["In"] = 0] = "In";
    DiagramUnit[DiagramUnit["Cm"] = 1] = "Cm";
    DiagramUnit[DiagramUnit["Px"] = 2] = "Px";
})(DiagramUnit = exports.DiagramUnit || (exports.DiagramUnit = {}));
var PageOrientation;
(function (PageOrientation) {
    PageOrientation[PageOrientation["Portrait"] = 0] = "Portrait";
    PageOrientation[PageOrientation["Landscape"] = 1] = "Landscape";
})(PageOrientation = exports.PageOrientation || (exports.PageOrientation = {}));
var DiagramModel = /** @class */ (function () {
    function DiagramModel(pageSize) {
        if (pageSize === void 0) { pageSize = new Utils_1.Size(8391, 11906); }
        this.items = [];
        this.itemIndexByKey = {};
        this.pageSize = new Utils_1.Size(8391, 11906);
        this.pageLandscape = false;
        this.pageColor = DiagramModel.defaultPageColor;
        this.units = DiagramUnit.In;
        this.snapStartPoint = new Utils_1.Point(0, 0);
        this.pageSize = pageSize;
        this.size = this.pageSize.clone();
        this.rectangle = new Utils_1.Rectangle(new Utils_1.Point(0, 0), new Utils_1.Size(0, 0));
    }
    Object.defineProperty(DiagramModel.prototype, "pageWidth", {
        get: function () {
            return this.pageLandscape ? this.pageSize.height : this.pageSize.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramModel.prototype, "pageHeight", {
        get: function () {
            return this.pageLandscape ? this.pageSize.width : this.pageSize.height;
        },
        enumerable: true,
        configurable: true
    });
    DiagramModel.prototype.getRectangle = function (forceUpdate) {
        if (forceUpdate)
            this.rectangle = Utils_1.GeometryUtils.getCommonRectangle(this.items.map(function (i) { return i.rectangle; }));
        return this.rectangle;
    };
    DiagramModel.getRectangle = function (items) {
        return Utils_1.GeometryUtils.getCommonRectangle(items.map(function (i) { return i.rectangle; }));
    };
    DiagramModel.prototype.pushItem = function (item) {
        var index = this.items.push(item);
        this.itemIndexByKey[item.key] = index - 1;
        if (item instanceof Shape_1.Shape && !item.image.isEmpty)
            this.cacheShapeImage(item);
    };
    DiagramModel.prototype.removeItem = function (item) {
        var index = this.getItemIndex(item);
        delete this.itemIndexByKey[item.key];
        this.items.splice(index, 1);
        this.updateIndicesHash(index);
    };
    DiagramModel.prototype.updateIndicesHash = function (startIndex) {
        for (var i = startIndex; i < this.items.length; i++)
            this.itemIndexByKey[this.items[i].key] = i;
    };
    DiagramModel.prototype.getItemIndex = function (item) {
        return this.itemIndexByKey[item.key];
    };
    DiagramModel.prototype.findShape = function (key) {
        var shape = this.findItem(key);
        return shape instanceof Shape_1.Shape ? shape : undefined;
    };
    DiagramModel.prototype.findShapesCore = function (callback) {
        var shapes;
        shapes = [];
        this.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                if (callback(item)) {
                    shapes.push(item);
                    return;
                }
            }
        });
        return shapes;
    };
    DiagramModel.prototype.findShapeCore = function (callback) {
        var shape;
        this.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                if (callback(item)) {
                    shape = item;
                    return;
                }
            }
        });
        return shape;
    };
    DiagramModel.prototype.findShapeAtPosition = function (position) {
        return this.findShapeCore(function (shape) { return shape.position.equals(position); });
    };
    DiagramModel.prototype.findShapeByDataKey = function (key) {
        return this.findShapeCore(function (shape) { return shape.dataKey === key; });
    };
    DiagramModel.prototype.findShapesByImageUrl = function (imageUrl) {
        return this.findShapesCore(function (shape) { return shape.image.url === imageUrl; });
    };
    DiagramModel.prototype.cacheShapeImage = function (shape) {
        var cacheImageInfo = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(shape.image);
        if (cacheImageInfo.isLoaded)
            shape.image.loadBase64Content(cacheImageInfo.base64);
    };
    DiagramModel.prototype.loadAllImages = function (imageLoader) {
        ImageCache_1.ImageCache.instance.loadAllImages(imageLoader);
    };
    DiagramModel.prototype.findContainer = function (key) {
        var shape = this.findShape(key);
        return shape && shape.enableChildren ? shape : undefined;
    };
    DiagramModel.prototype.getChildren = function (container) {
        var _this = this;
        return container.childKeys.map(function (key) { return _this.findItem(key); }).filter(function (item) { return item; });
    };
    DiagramModel.prototype.findChild = function (container, key, recursive) {
        var _this = this;
        if (recursive === void 0) { recursive = true; }
        var result;
        container.childKeys.forEach(function (childKey) {
            if (result)
                return;
            var child = _this.findItem(childKey);
            if (childKey === key) {
                result = child;
                return;
            }
            if (recursive && child instanceof Shape_1.Shape) {
                result = _this.findChild(child, key, recursive);
                if (result)
                    return;
            }
        });
        return result;
    };
    DiagramModel.prototype.findItemContainerCore = function (item, callback) {
        var container = item.container;
        while (container) {
            if (!callback || callback(container))
                return container;
            container = container.container;
        }
    };
    DiagramModel.prototype.findItemContainer = function (item) {
        return this.findItemContainerCore(item);
    };
    DiagramModel.prototype.findItemCollapsedContainer = function (item) {
        return this.findItemContainerCore(item, function (c) { return !c.expanded; });
    };
    DiagramModel.prototype.isContainerItem = function (container, item) {
        return this.findItemContainerCore(item, function (c) { return c.key === container.key; }) !== undefined;
    };
    DiagramModel.prototype.findConnector = function (key) {
        var connector = this.findItem(key);
        return connector instanceof Connector_1.Connector ? connector : undefined;
    };
    DiagramModel.prototype.findConnectorCore = function (callback) {
        var connector;
        this.items.forEach(function (item) {
            if (item instanceof Connector_1.Connector) {
                if (callback(item)) {
                    connector = item;
                    return;
                }
            }
        });
        return connector;
    };
    DiagramModel.prototype.findConnectorAtPoints = function (points) {
        return this.findConnectorCore(function (connector) { return Utils_1.GeometryUtils.arePointsEqual(connector.points, points); });
    };
    DiagramModel.prototype.findConnectorByDataKey = function (key) {
        return this.findConnectorCore(function (connector) { return connector.dataKey === key; });
    };
    DiagramModel.prototype.findItem = function (key) {
        return this.items[this.itemIndexByKey[key]];
    };
    DiagramModel.isIntersectedItems = function (item1, item2) {
        var result = false;
        if (item1 instanceof Shape_1.Shape)
            result = item2.intersectedByRect(item1.rectangle);
        else if (item1 instanceof Connector_1.Connector) {
            item1.getSegments().forEach(function (s1) {
                if (item2 instanceof Shape_1.Shape)
                    result = result || s1.intersectRect(item2.rectangle);
                else if (item2 instanceof Connector_1.Connector) {
                    item2.getSegments().forEach(function (s2) {
                        result = result || s1.intersect(s2);
                    });
                }
            });
        }
        return result;
    };
    DiagramModel.prototype.getIntersectItems = function (item) {
        var result = [];
        this.items.forEach(function (i) {
            if (i.container !== item.container)
                return;
            if (item !== i && (!(i instanceof Connector_1.Connector) || item.attachedConnectors.indexOf(i) === -1) &&
                DiagramModel.isIntersectedItems(i, item))
                result.push(i);
        });
        return result;
    };
    DiagramModel.prototype.getIntersectItemsMinZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
    };
    DiagramModel.prototype.getIntersectItemsMaxZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
    };
    DiagramModel.prototype.iterateItems = function (callback) {
        this.items.forEach(callback);
    };
    DiagramModel.prototype.invalidateItems = function () {
        this.iterateItems(function (item) {
            item.invalidatePrimitives();
            if (item instanceof Connector_1.Connector)
                item.invalidateRenderPoints();
        });
    };
    DiagramModel.prototype.getNextKey = function (baseKey) {
        var _this = this;
        return ModelUtils_1.ModelUtils.getNextItemKey(this.items.map(function (item) { return item.key; }), function (key) { return _this.itemIndexByKey[key] === undefined; }, baseKey);
    };
    DiagramModel.defaultPageColor = Color_1.ColorHelper.LIGHT_COLOR;
    return DiagramModel;
}());
exports.DiagramModel = DiagramModel;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser = /** @class */ (function () {
    function Browser() {
    }
    Browser.IdentUserAgent = function (userAgent, ignoreDocumentMode) {
        if (ignoreDocumentMode === void 0) { ignoreDocumentMode = false; }
        var browserTypesOrderedList = ["Mozilla", "IE", "Firefox", "Netscape", "Safari", "Chrome", "Opera", "Opera10", "Edge"];
        var defaultBrowserType = "IE";
        var defaultPlatform = "Win";
        var defaultVersions = { Safari: 2, Chrome: 0.1, Mozilla: 1.9, Netscape: 8, Firefox: 2, Opera: 9, IE: 6, Edge: 12 };
        if (!userAgent || userAgent.length == 0) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
            return;
        }
        userAgent = userAgent.toLowerCase();
        Browser.indentPlatformMajorVersion(userAgent);
        try {
            var platformIdentStrings = {
                "Windows": "Win",
                "Macintosh": "Mac",
                "Mac OS": "Mac",
                "Mac_PowerPC": "Mac",
                "cpu os": "MacMobile",
                "cpu iphone os": "MacMobile",
                "Android": "Android",
                "!Windows Phone": "WinPhone",
                "!WPDesktop": "WinPhone",
                "!ZuneWP": "WinPhone"
            };
            var optSlashOrSpace = "(?:/|\\s*)?";
            var versionString = "(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?";
            var optVersion = "(?:" + versionString + ")?";
            var patterns = {
                Safari: "applewebkit(?:.*?(?:version/" + versionString + "[\\.\\w\\d]*?(?:\\s+mobile\/\\S*)?\\s+safari))?",
                Chrome: "(?:chrome|crios)(?!frame)" + optSlashOrSpace + optVersion,
                Mozilla: "mozilla(?:.*rv:" + optVersion + ".*Gecko)?",
                Netscape: "(?:netscape|navigator)\\d*/?\\s*" + optVersion,
                Firefox: "firefox" + optSlashOrSpace + optVersion,
                Opera: "(?:opera|\sopr)" + optSlashOrSpace + optVersion,
                Opera10: "opera.*\\s*version" + optSlashOrSpace + optVersion,
                IE: "msie\\s*" + optVersion,
                Edge: "edge" + optSlashOrSpace + optVersion
            };
            var browserType;
            var version = -1;
            for (var i = 0; i < browserTypesOrderedList.length; i++) {
                var browserTypeCandidate = browserTypesOrderedList[i];
                var regExp = new RegExp(patterns[browserTypeCandidate], "i");
                if (regExp.compile)
                    regExp.compile(patterns[browserTypeCandidate], "i");
                var matches = regExp.exec(userAgent);
                if (matches && matches.index >= 0) {
                    if (browserType == "IE" && version >= 11 && browserTypeCandidate == "Safari") // WinPhone8.1 update
                        continue;
                    browserType = browserTypeCandidate;
                    if (browserType == "Opera10")
                        browserType = "Opera";
                    var tridentPattern = "trident" + optSlashOrSpace + optVersion;
                    version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, Browser.getIECompatibleVersionString());
                    if (browserType == "Mozilla" && version >= 11)
                        browserType = "IE";
                }
            }
            if (!browserType)
                browserType = defaultBrowserType;
            var browserVersionDetected = version != -1;
            if (!browserVersionDetected)
                version = defaultVersions[browserType];
            var platform;
            var minOccurenceIndex = Number.MAX_VALUE;
            for (var identStr in platformIdentStrings) {
                if (!platformIdentStrings.hasOwnProperty(identStr))
                    continue;
                var importantIdent = identStr.substr(0, 1) == "!";
                var occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
                if (occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent)) {
                    minOccurenceIndex = importantIdent ? 0 : occurenceIndex;
                    platform = platformIdentStrings[identStr];
                }
            }
            var samsungPattern = "SM-[A-Z]";
            var m = userAgent.toUpperCase().match(samsungPattern);
            var isSamsungAndroidDevice = m && m.length > 0;
            if (platform == "WinPhone" && version < 9)
                version = Math.floor(Browser.getVersionFromTrident(userAgent, "trident" + optSlashOrSpace + optVersion));
            if (!ignoreDocumentMode && browserType == "IE" && version > 7 && document.documentMode < version)
                version = document.documentMode;
            if (platform == "WinPhone")
                version = Math.max(9, version);
            if (!platform)
                platform = defaultPlatform;
            if (platform == platformIdentStrings["cpu os"] && !browserVersionDetected) // Terra browser
                version = 4;
            Browser.fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
        }
        catch (e) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
        }
    };
    Browser.GetBrowserVersion = function (userAgent, matches, tridentPattern, ieCompatibleVersionString) {
        var version = Browser.getVersionFromMatches(matches);
        if (ieCompatibleVersionString) {
            var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
            if (ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
                return versionFromTrident;
        }
        return version;
    };
    Browser.getIECompatibleVersionString = function () {
        if (document.compatible) {
            for (var i = 0; i < document.compatible.length; i++)
                if (document.compatible[i].userAgent === "IE" && document.compatible[i].version)
                    return document.compatible[i].version.toLowerCase();
        }
        return "";
    };
    Browser.fillUserAgentInfo = function (browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
        if (isSamsungAndroidDevice === void 0) { isSamsungAndroidDevice = false; }
        for (var i = 0; i < browserTypesOrderedList.length; i++) {
            var type = browserTypesOrderedList[i];
            Browser[type] = type == browserType;
        }
        Browser.Version = Math.floor(10.0 * version) / 10.0;
        Browser.MajorVersion = Math.floor(Browser.Version);
        Browser.WindowsPlatform = platform == "Win" || platform == "WinPhone";
        Browser.MacOSPlatform = platform == "Mac";
        Browser.MacOSMobilePlatform = platform == "MacMobile";
        Browser.AndroidMobilePlatform = platform == "Android";
        Browser.WindowsPhonePlatform = platform == "WinPhone";
        Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15;
        Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox;
        Browser.HardwareAcceleration = (Browser.IE && Browser.MajorVersion >= 9) || (Browser.Firefox && Browser.MajorVersion >= 4) ||
            (Browser.AndroidMobilePlatform && Browser.Chrome) || (Browser.Chrome && Browser.MajorVersion >= 37) ||
            (Browser.Safari && !Browser.WindowsPlatform) || Browser.Edge || (Browser.Opera && Browser.MajorVersion >= 46);
        Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
        var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf("touch") >= 0;
        Browser.MSTouchUI = isIETouchUI || (Browser.Edge && !!window.navigator.maxTouchPoints);
        Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI;
        Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform;
        Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome;
        Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome;
        if (isSamsungAndroidDevice)
            Browser.SamsungAndroidDevice = isSamsungAndroidDevice;
        if (Browser.MSTouchUI) {
            var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf("arm;") > -1;
            Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;
        }
        else {
            Browser.VirtualKeyboardSupported = Browser.WebKitTouchUI;
        }
        Browser.fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
    };
    Browser.indentPlatformMajorVersion = function (userAgent) {
        var regex = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/;
        var matches = regex.exec(userAgent);
        if (matches)
            Browser.PlaformMajorVersion = matches[1];
    };
    Browser.prototype.GetBrowserVersion = function (userAgent, matches, tridentPattern, ieCompatibleVersionString) {
        var version = Browser.getVersionFromMatches(matches);
        if (ieCompatibleVersionString) {
            var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
            if (ieCompatibleVersionString === "edge" || parseInt(ieCompatibleVersionString) === versionFromTrident)
                return versionFromTrident;
        }
        return version;
    };
    Browser.getVersionFromMatches = function (matches) {
        var result = -1;
        var versionStr = "";
        if (matches[1]) {
            versionStr += matches[1];
            if (matches[2])
                versionStr += "." + matches[2];
        }
        if (versionStr != "") {
            result = parseFloat(versionStr);
            if (isNaN(result))
                result = -1;
        }
        return result;
    };
    Browser.getVersionFromTrident = function (userAgent, tridentPattern) {
        var tridentDiffFromVersion = 4;
        var matches = new RegExp(tridentPattern, "i").exec(userAgent);
        return Browser.getVersionFromMatches(matches) + tridentDiffFromVersion;
    };
    Browser.fillDocumentElementBrowserTypeClassNames = function (browserTypesOrderedList) {
        var documentElementClassName = "";
        var browserTypeslist = browserTypesOrderedList.concat(["WindowsPlatform", "MacOSPlatform", "MacOSMobilePlatform", "AndroidMobilePlatform",
            "WindowsPhonePlatform", "WebKitFamily", "WebKitTouchUI", "MSTouchUI", "TouchUI", "AndroidDefaultBrowser"]);
        for (var i = 0; i < browserTypeslist.length; i++) {
            var type = browserTypeslist[i];
            if (Browser[type])
                documentElementClassName += "dx" + type + " ";
        }
        documentElementClassName += "dxBrowserVersion-" + Browser.MajorVersion;
        if (document && document.documentElement) {
            if (document.documentElement.className != "")
                documentElementClassName = " " + documentElementClassName;
            document.documentElement.className += documentElementClassName;
            Browser.Info = documentElementClassName;
        }
    };
    Browser.UserAgent = window.navigator.userAgent.toLowerCase();
    Browser._foo = Browser.IdentUserAgent(Browser.UserAgent); // to init
    return Browser;
}());
exports.Browser = Browser;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorLineOption;
(function (ConnectorLineOption) {
    ConnectorLineOption[ConnectorLineOption["Straight"] = 0] = "Straight";
    ConnectorLineOption[ConnectorLineOption["Orthogonal"] = 1] = "Orthogonal";
})(ConnectorLineOption = exports.ConnectorLineOption || (exports.ConnectorLineOption = {}));
var ConnectorLineEnding;
(function (ConnectorLineEnding) {
    ConnectorLineEnding[ConnectorLineEnding["None"] = 0] = "None";
    ConnectorLineEnding[ConnectorLineEnding["Arrow"] = 1] = "Arrow";
})(ConnectorLineEnding = exports.ConnectorLineEnding || (exports.ConnectorLineEnding = {}));
exports.DEFAULT_CONNECTOR_LINEOPTION = ConnectorLineOption.Orthogonal;
exports.DEFAULT_CONNECTOR_STARTLINEENDING = ConnectorLineEnding.None;
exports.DEFAULT_CONNECTOR_ENDLINEENDING = ConnectorLineEnding.Arrow;
var ConnectorProperties = /** @class */ (function () {
    function ConnectorProperties() {
        this.lineOption = exports.DEFAULT_CONNECTOR_LINEOPTION;
        this.startLineEnding = exports.DEFAULT_CONNECTOR_STARTLINEENDING;
        this.endLineEnding = exports.DEFAULT_CONNECTOR_ENDLINEENDING;
    }
    ConnectorProperties.prototype.clone = function () {
        var clone = new ConnectorProperties();
        clone.lineOption = this.lineOption;
        clone.startLineEnding = this.startLineEnding;
        clone.endLineEnding = this.endLineEnding;
        return clone;
    };
    ConnectorProperties.prototype.forEach = function (callback) {
        for (var propertyName in this) {
            if (this.hasOwnProperty(propertyName))
                callback(propertyName);
        }
    };
    ConnectorProperties.prototype.toObject = function () {
        var result = {};
        var modified = false;
        if (this.lineOption !== exports.DEFAULT_CONNECTOR_LINEOPTION) {
            result["lineOption"] = this.lineOption;
            modified = true;
        }
        if (this.startLineEnding !== exports.DEFAULT_CONNECTOR_STARTLINEENDING) {
            result["startLineEnding"] = this.startLineEnding;
            modified = true;
        }
        if (this.endLineEnding !== exports.DEFAULT_CONNECTOR_ENDLINEENDING) {
            result["endLineEnding"] = this.endLineEnding;
            modified = true;
        }
        return modified ? result : null;
    };
    ConnectorProperties.prototype.fromObject = function (obj) {
        if (typeof obj["lineOption"] === "number")
            this.lineOption = obj["lineOption"];
        if (typeof obj["startLineEnding"] === "number")
            this.startLineEnding = obj["startLineEnding"];
        if (typeof obj["endLineEnding"] === "number")
            this.endLineEnding = obj["endLineEnding"];
    };
    return ConnectorProperties;
}());
exports.ConnectorProperties = ConnectorProperties;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ProcessShapeDescription_1 = __webpack_require__(147);
var DecisionShapeDescription_1 = __webpack_require__(148);
var ManualInputShapeDescription_1 = __webpack_require__(149);
var DataShapeDescription_1 = __webpack_require__(150);
var TerminatorShapeDescription_1 = __webpack_require__(151);
var PredefinedProcessShapeDescription_1 = __webpack_require__(152);
var ArrowNorthSouthShapeDescription_1 = __webpack_require__(153);
var ArrowRightShapeDescription_1 = __webpack_require__(154);
var ArrowTopShapeDescription_1 = __webpack_require__(155);
var CrossShapeDescription_1 = __webpack_require__(156);
var DiamondShapeDescription_1 = __webpack_require__(91);
var EllipseShapeDescription_1 = __webpack_require__(66);
var HeartShapeDescription_1 = __webpack_require__(157);
var RectangleShapeDescription_1 = __webpack_require__(14);
var TextShapeDescription_1 = __webpack_require__(92);
var PentagonShapeDescription_1 = __webpack_require__(93);
var HexagonShapeDescription_1 = __webpack_require__(94);
var OctagonShapeDescription_1 = __webpack_require__(158);
var StarShapeDescription_1 = __webpack_require__(159);
var ArrowBottomShapeDescription_1 = __webpack_require__(160);
var ArrowEastWestShapeDescription_1 = __webpack_require__(161);
var ArrowLeftShapeDescription_1 = __webpack_require__(162);
var TriangleShapeDescription_1 = __webpack_require__(95);
var DocumentShapeDescription_1 = __webpack_require__(96);
var MultipleDocumentsShapeDescription_1 = __webpack_require__(163);
var PreparationShapeDescription_1 = __webpack_require__(164);
var HardDiskShapeDescription_1 = __webpack_require__(165);
var DatabaseShapeDescription_1 = __webpack_require__(166);
var InternalStorageShapeDescription_1 = __webpack_require__(167);
var PaperTapeShapeDescription_1 = __webpack_require__(168);
var ManualOperationShapeDescription_1 = __webpack_require__(169);
var DelayShapeDescription_1 = __webpack_require__(170);
var StoredDataShapeDescription_1 = __webpack_require__(171);
var MergeShapeDescription_1 = __webpack_require__(172);
var DisplayShapeDescription_1 = __webpack_require__(173);
var OrShapeDescription_1 = __webpack_require__(174);
var SummingJunctionShapeDescription_1 = __webpack_require__(175);
var CustomShapeDescription_1 = __webpack_require__(176);
var VerticalContainerDescription_1 = __webpack_require__(180);
var HorizontalContainerDescription_1 = __webpack_require__(181);
var CardWithImageOnLeftDescription_1 = __webpack_require__(182);
var CardWithImageOnRightDescription_1 = __webpack_require__(184);
var CardWithImageOnTopDescription_1 = __webpack_require__(185);
var ShapeTypes_1 = __webpack_require__(1);
var ShapeDescriptionManager = /** @class */ (function () {
    function ShapeDescriptionManager() {
    }
    ShapeDescriptionManager.get = function (type) {
        return this.descriptions[type];
    };
    ShapeDescriptionManager.rectangle = function () {
        return this.descriptions[ShapeTypes_1.ShapeTypes.Rectangle];
    };
    ShapeDescriptionManager.getTypesByCategory = function (category) {
        var _this = this;
        return Object.keys(this.descriptionCategories).filter(function (key) { return _this.descriptionCategories[key] === category; });
    };
    ShapeDescriptionManager.register = function (description, category, type) {
        if (type === void 0) { type = description.key; }
        if (this.descriptions[type] !== undefined)
            throw Error("Description key is duplicated");
        this.descriptions[type] = description;
        this.descriptionCategories[type] = category;
    };
    ShapeDescriptionManager.registerCustomShape = function (shape) {
        if (shape.type === undefined)
            throw Error("Custom shape type is not defined");
        if (this.descriptions[shape.type] !== undefined)
            throw Error("Custom shape type is duplicated");
        var baseDescription = shape.baseType && this.descriptions[shape.baseType];
        this.register(new CustomShapeDescription_1.CustomShapeDescription(shape, baseDescription), shape.category || ShapeTypes_1.ShapeCategories.Custom);
    };
    ShapeDescriptionManager.unregisterCustomShape = function (shapeType) {
        var description = this.descriptions[shapeType];
        if (description instanceof CustomShapeDescription_1.CustomShapeDescription) {
            delete this.descriptions[shapeType];
            delete this.descriptionCategories[shapeType];
        }
    };
    ShapeDescriptionManager.descriptions = {};
    ShapeDescriptionManager.descriptionCategories = {};
    return ShapeDescriptionManager;
}());
exports.ShapeDescriptionManager = ShapeDescriptionManager;
ShapeDescriptionManager.register(new TextShapeDescription_1.TextShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new RectangleShapeDescription_1.RectangleShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new EllipseShapeDescription_1.EllipseShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new CrossShapeDescription_1.CrossShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new TriangleShapeDescription_1.TriangleShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new DiamondShapeDescription_1.DiamondShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new HeartShapeDescription_1.HeartShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new PentagonShapeDescription_1.PentagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new HexagonShapeDescription_1.HexagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new OctagonShapeDescription_1.OctagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new StarShapeDescription_1.StarShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowTopShapeDescription_1.ArrowTopShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowBottomShapeDescription_1.ArrowBottomShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowLeftShapeDescription_1.ArrowLeftShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowRightShapeDescription_1.ArrowRightShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowNorthSouthShapeDescription_1.ArrowNorthSouthShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ArrowEastWestShapeDescription_1.ArrowEastWestShapeDescription(), ShapeTypes_1.ShapeCategories.General);
ShapeDescriptionManager.register(new ProcessShapeDescription_1.ProcessShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DecisionShapeDescription_1.DecisionShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new TerminatorShapeDescription_1.TerminatorShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new PredefinedProcessShapeDescription_1.PredefinedProcessShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DocumentShapeDescription_1.DocumentShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new MultipleDocumentsShapeDescription_1.MultipleDocumentsShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new ManualInputShapeDescription_1.ManualInputShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new PreparationShapeDescription_1.PreparationShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DataShapeDescription_1.DataShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DatabaseShapeDescription_1.DatabaseShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new HardDiskShapeDescription_1.HardDiskShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new InternalStorageShapeDescription_1.InternalStorageShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new PaperTapeShapeDescription_1.PaperTapeShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new ManualOperationShapeDescription_1.ManualOperationShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DelayShapeDescription_1.DelayShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new StoredDataShapeDescription_1.StoredDataShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new DisplayShapeDescription_1.DisplayShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new MergeShapeDescription_1.MergeShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new OrShapeDescription_1.OrShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new SummingJunctionShapeDescription_1.SummingJunctionShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
ShapeDescriptionManager.register(new CardWithImageOnLeftDescription_1.CardWithImageOnLeftDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
ShapeDescriptionManager.register(new CardWithImageOnRightDescription_1.CardWithImageOnRightDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
ShapeDescriptionManager.register(new CardWithImageOnTopDescription_1.CardWithImageOnTopDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
ShapeDescriptionManager.register(new VerticalContainerDescription_1.VerticalContainerDescription(), ShapeTypes_1.ShapeCategories.Containers);
ShapeDescriptionManager.register(new HorizontalContainerDescription_1.HorizontalContainerDescription(), ShapeTypes_1.ShapeCategories.Containers);


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerStateBase_1 = __webpack_require__(32);
var Event_1 = __webpack_require__(12);
var UnitConverter_1 = __webpack_require__(13);
var MouseHandlerDraggingState = /** @class */ (function (_super) {
    __extends(MouseHandlerDraggingState, _super);
    function MouseHandlerDraggingState(handler, history) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        return _this;
    }
    MouseHandlerDraggingState.prototype.onMouseDown = function (evt) {
        this.mouseDownPoint = evt.layoutPoint.clone();
    };
    MouseHandlerDraggingState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
        }
        else if (!this.mouseDownPoint ||
            Math.abs(this.mouseDownPoint.x - evt.layoutPoint.x) > MouseHandlerDraggingState.dragStartLimit ||
            Math.abs(this.mouseDownPoint.y - evt.layoutPoint.y) > MouseHandlerDraggingState.dragStartLimit) {
            this.onApplyChanges(evt);
            if (!this.modified)
                this.handler.raiseDragStart(this.getDraggingElementKeys());
            this.modified = true;
            this.mouseDownPoint = undefined;
        }
    };
    MouseHandlerDraggingState.prototype.cancelChanges = function () {
        this.history.undoTransaction();
        if (this.modified)
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        this.modified = false;
    };
    MouseHandlerDraggingState.prototype.onMouseUp = function (evt) {
        this.mouseDownPoint = undefined;
        this.handler.switchToDefaultState();
    };
    MouseHandlerDraggingState.prototype.start = function () {
        this.history.beginTransaction();
    };
    MouseHandlerDraggingState.prototype.finish = function () {
        if (this.modified) {
            this.onFinishWithChanges();
            this.modified = false;
            this.history.endTransaction();
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        }
        else
            this.history.endTransaction();
    };
    MouseHandlerDraggingState.prototype.onFinishWithChanges = function () { };
    MouseHandlerDraggingState.prototype.getSnappedPoint = function (evt, point) {
        return this.handler.getSnappedPoint(evt, point);
    };
    MouseHandlerDraggingState.dragStartLimit = UnitConverter_1.UnitConverter.pixelsToTwips(4);
    return MouseHandlerDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerDraggingState = MouseHandlerDraggingState;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ShapeParameter = /** @class */ (function () {
    function ShapeParameter(key, value) {
        this.key = key;
        this.value = value;
    }
    return ShapeParameter;
}());
exports.ShapeParameter = ShapeParameter;
var ShapeParameters = /** @class */ (function () {
    function ShapeParameters() {
        this.items = {};
    }
    ShapeParameters.prototype.add = function (parameter) {
        this.items[parameter.key] = parameter;
    };
    ShapeParameters.prototype.addRange = function (parameters) {
        for (var i = 0; i < parameters.length; i++)
            this.add(parameters[i]);
    };
    ShapeParameters.prototype.get = function (key) {
        return this.items[key];
    };
    ShapeParameters.prototype.forEach = function (callback) {
        for (var key in this.items)
            if (this.items.hasOwnProperty(key))
                callback(this.items[key]);
    };
    ShapeParameters.prototype.clone = function () {
        var result = new ShapeParameters();
        this.forEach(function (p) { result.add(new ShapeParameter(p.key, p.value)); });
        return result;
    };
    ShapeParameters.prototype.toObject = function () {
        var result = {};
        var modified = false;
        this.forEach(function (p) {
            result[p.key] = { 'value': p.value };
            modified = true;
        });
        return modified ? result : null;
    };
    ShapeParameters.prototype.fromObject = function (obj) {
        this.forEach(function (p) {
            var paramObj = obj[p.key];
            if (paramObj) {
                if (typeof paramObj["value"] === "number")
                    p.value = paramObj["value"];
            }
        });
    };
    return ShapeParameters;
}());
exports.ShapeParameters = ShapeParameters;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var EllipsePrimitive = /** @class */ (function (_super) {
    __extends(EllipsePrimitive, _super);
    function EllipsePrimitive(cx, cy, rx, ry, style, className) {
        var _this = _super.call(this, style, className) || this;
        _this.cx = cx;
        _this.cy = cy;
        _this.rx = rx;
        _this.ry = ry;
        return _this;
    }
    EllipsePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "ellipse");
    };
    EllipsePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "cx", this.cx);
        this.setUnitAttribute(element, "cy", this.cy);
        this.setUnitAttribute(element, "rx", this.rx);
        this.setUnitAttribute(element, "ry", this.ry);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return EllipsePrimitive;
}(Primitive_1.SvgPrimitive));
exports.EllipsePrimitive = EllipsePrimitive;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var ConnectorRenderPoint = /** @class */ (function (_super) {
    __extends(ConnectorRenderPoint, _super);
    function ConnectorRenderPoint(x, y, pointIndex, skipped) {
        if (pointIndex === void 0) { pointIndex = -1; }
        if (skipped === void 0) { skipped = false; }
        var _this = _super.call(this, x, y) || this;
        _this.pointIndex = pointIndex;
        _this.skipped = skipped;
        return _this;
    }
    ConnectorRenderPoint.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new ConnectorRenderPoint(this.x + offsetX, this.y + offsetY);
    };
    ConnectorRenderPoint.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new ConnectorRenderPoint(this.x * multiplierX, this.y * multiplierY);
    };
    ConnectorRenderPoint.prototype.clone = function () { return new ConnectorRenderPoint(this.x, this.y, this.pointIndex); };
    return ConnectorRenderPoint;
}(Utils_1.Point));
exports.ConnectorRenderPoint = ConnectorRenderPoint;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Edge = /** @class */ (function () {
    function Edge(key, from, to, weight) {
        if (weight === void 0) { weight = 1; }
        this.weight = weight;
        this.key = key;
        this.from = from;
        this.to = to;
    }
    Edge.prototype.getHashKey = function () {
        return this.from + "_" + this.to;
    };
    Edge.prototype.reverse = function () {
        return new Edge(this.key, this.to, this.from, this.weight);
    };
    return Edge;
}());
exports.Edge = Edge;
var PositionInfo = /** @class */ (function () {
    function PositionInfo(item, position) {
        this.item = item;
        this.position = position;
    }
    return PositionInfo;
}());
exports.PositionInfo = PositionInfo;
var ConnectionMode;
(function (ConnectionMode) {
    ConnectionMode[ConnectionMode["Outgoing"] = 1] = "Outgoing";
    ConnectionMode[ConnectionMode["Incoming"] = 2] = "Incoming";
    ConnectionMode[ConnectionMode["OutgoingAndIncoming"] = 3] = "OutgoingAndIncoming";
})(ConnectionMode = exports.ConnectionMode || (exports.ConnectionMode = {}));


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerStateBase = /** @class */ (function () {
    function MouseHandlerStateBase(handler) {
        this.handler = handler;
    }
    MouseHandlerStateBase.prototype.start = function () { };
    MouseHandlerStateBase.prototype.finish = function () { };
    MouseHandlerStateBase.prototype.onMouseDoubleClick = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseDown = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseUp = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseMove = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseWheel = function (_evt) { return false; };
    MouseHandlerStateBase.prototype.onDragStart = function (_evt) { };
    MouseHandlerStateBase.prototype.onDragEnd = function (_evt) { };
    MouseHandlerStateBase.prototype.onShortcut = function (_shortcutCode) { return false; };
    return MouseHandlerStateBase;
}());
exports.MouseHandlerStateBase = MouseHandlerStateBase;
var MouseHandlerCancellableState = /** @class */ (function (_super) {
    __extends(MouseHandlerCancellableState, _super);
    function MouseHandlerCancellableState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerCancellableState.prototype.onShortcut = function (code) {
        if (code === KeyCode_1.KeyCode.Esc) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
            return true;
        }
        return false;
    };
    return MouseHandlerCancellableState;
}(MouseHandlerStateBase));
exports.MouseHandlerCancellableState = MouseHandlerCancellableState;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var TextFilterPrimitive_1 = __webpack_require__(84);
exports.PAGE_BG_TEXTFLOOR_FILTER_ID = "page-text-flood";
var CanvasManagerBase = /** @class */ (function () {
    function CanvasManagerBase(actualZoom) {
        this.elements = {};
        this.actualZoom = actualZoom;
    }
    CanvasManagerBase.prototype.createAndChangePrimitivesElements = function (primitives, parent) {
        var _this = this;
        primitives.forEach(function (primitive) {
            _this.createAndChangePrimitiveElement(primitive, parent);
        });
    };
    CanvasManagerBase.prototype.changePrimitivesElements = function (primitives, parent) {
        var _this = this;
        primitives.forEach(function (primitive, index) {
            var element = parent.childNodes[index];
            _this.changePrimitiveElement(primitive, element);
        });
    };
    CanvasManagerBase.prototype.createPrimitiveElement = function (primitive, parent, sibling) {
        var element = primitive.createElement();
        if (parent != null) {
            if (sibling !== undefined)
                parent.insertBefore(element, sibling);
            else
                parent.appendChild(element);
        }
        return element;
    };
    CanvasManagerBase.prototype.createAndChangePrimitiveElement = function (primitive, parent, sibling) {
        var element = this.createPrimitiveElement(primitive, parent, sibling);
        this.changePrimitiveElement(primitive, element);
        return element;
    };
    CanvasManagerBase.prototype.changePrimitiveElement = function (primitive, element) {
        primitive.applyElementProperties(element);
    };
    CanvasManagerBase.prototype.getOrCreateElement = function (key, primitive, parent, sibling) {
        var element = (key && this.elements[key]) || (this.elements[key] = this.createPrimitiveElement(primitive, parent, sibling));
        this.changePrimitiveElement(primitive, element);
        return element;
    };
    CanvasManagerBase.prototype.createTextFloodFilter = function (key, parent, pageColor) {
        this.getOrCreateElement(key, new TextFilterPrimitive_1.TextFloodFilterPrimitive(exports.PAGE_BG_TEXTFLOOR_FILTER_ID, pageColor), parent);
    };
    return CanvasManagerBase;
}());
exports.CanvasManagerBase = CanvasManagerBase;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(4);
var ConnectionPoint = /** @class */ (function (_super) {
    __extends(ConnectionPoint, _super);
    function ConnectionPoint(x, y, side) {
        if (side === void 0) { side = DiagramItem_1.ConnectionPointSide.Undefined; }
        var _this = _super.call(this, x, y) || this;
        _this.side = side;
        return _this;
    }
    ConnectionPoint.prototype.offset = function (offsetX, offsetY) {
        if (offsetX === void 0) { offsetX = 0; }
        if (offsetY === void 0) { offsetY = 0; }
        return new ConnectionPoint(this.x + offsetX, this.y + offsetY);
    };
    ConnectionPoint.prototype.multiply = function (multiplierX, multiplierY) {
        if (multiplierX === void 0) { multiplierX = 1; }
        if (multiplierY === void 0) { multiplierY = multiplierX; }
        return new ConnectionPoint(this.x * multiplierX, this.y * multiplierY);
    };
    ConnectionPoint.prototype.clone = function () { return new ConnectionPoint(this.x, this.y, this.side); };
    ConnectionPoint.prototype.toPoint = function () { return new Utils_1.Point(this.x, this.y); };
    return ConnectionPoint;
}(Utils_1.Point));
exports.ConnectionPoint = ConnectionPoint;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleHistoryItemBase_1 = __webpack_require__(101);
var ChangeStyleTextHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeStyleTextHistoryItem, _super);
    function ChangeStyleTextHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleTextHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.styleText[this.styleProperty];
        manipulator.changeStyleText(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleTextHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyleText(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleTextHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleTextHistoryItem = ChangeStyleTextHistoryItem;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var Connector_1 = __webpack_require__(5);
var AddConnectionHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectionHistoryItem, _super);
    function AddConnectionHistoryItem(connector, item, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.itemKey = item.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    AddConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.connectionPointIndex, this.position);
    };
    AddConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnection(connector, this.position);
    };
    return AddConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectionHistoryItem = AddConnectionHistoryItem;
var SetConnectionPointIndexHistoryItem = /** @class */ (function (_super) {
    __extends(SetConnectionPointIndexHistoryItem, _super);
    function SetConnectionPointIndexHistoryItem(connector, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    SetConnectionPointIndexHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.setConnectionPointIndex(connector, this.connectionPointIndex, this.position);
    };
    SetConnectionPointIndexHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.setConnectionPointIndex(connector, this.oldConnectionPointIndex, this.position);
    };
    return SetConnectionPointIndexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetConnectionPointIndexHistoryItem = SetConnectionPointIndexHistoryItem;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Color_1 = __webpack_require__(38);
var Svg_1 = __webpack_require__(79);
var StyleBase = /** @class */ (function () {
    function StyleBase() {
    }
    StyleBase.prototype.clone = function () {
        var _this = this;
        var style = this.createInstance();
        this.forEach(function (propertyName) { style[propertyName] = _this[propertyName]; });
        return style;
    };
    StyleBase.prototype.forEach = function (callback) {
        for (var propertyName in this) {
            if (this.hasOwnProperty(propertyName))
                callback(propertyName);
        }
    };
    StyleBase.prototype.toObject = function () {
        var _this = this;
        var result = {};
        var modified = false;
        var defaultStyle = this.getDefaultInstance();
        this.forEach(function (key) {
            if (_this[key] !== defaultStyle[key]) {
                result[key] = _this[key];
                modified = true;
            }
        });
        return modified ? result : null;
    };
    StyleBase.prototype.fromObject = function (obj) {
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (this[key] !== undefined) {
                    var value = Svg_1.isColorProperty(key) ? Color_1.ColorHelper.stringToHash(obj[key]) : obj[key];
                    this[key] = value;
                }
            }
        }
    };
    return StyleBase;
}());
exports.StyleBase = StyleBase;
var EmptyStyle = /** @class */ (function (_super) {
    __extends(EmptyStyle, _super);
    function EmptyStyle(styles) {
        var _this = _super.call(this) || this;
        if (styles)
            Object.keys(styles).forEach(function (k) { return _this[k] = styles[k]; });
        return _this;
    }
    EmptyStyle.prototype.createInstance = function () {
        return new EmptyStyle();
    };
    EmptyStyle.prototype.getDefaultInstance = function () {
        return Style.defaultInstace;
    };
    return EmptyStyle;
}(StyleBase));
exports.EmptyStyle = EmptyStyle;
var Style = /** @class */ (function (_super) {
    __extends(Style, _super);
    function Style() {
        var _this = _super.call(this) || this;
        // Default values must be the same with css
        _this["fill"] = "#ffffff";
        _this["stroke"] = "#000000";
        return _this;
    }
    Style.prototype.createInstance = function () {
        return new Style();
    };
    Style.prototype.getDefaultInstance = function () {
        return Style.defaultInstace;
    };
    Style.defaultInstace = new Style();
    return Style;
}(StyleBase));
exports.Style = Style;
var StyleText = /** @class */ (function (_super) {
    __extends(StyleText, _super);
    function StyleText() {
        var _this = _super.call(this) || this;
        // Default values must be the same with css
        _this["fill"] = "#000000";
        _this["font-family"] = "Arial";
        _this["font-size"] = "10pt";
        _this["font-weight"] = "";
        _this["font-style"] = "";
        _this["text-decoration"] = "";
        _this["text-anchor"] = "middle";
        return _this;
    }
    StyleText.prototype.createInstance = function () {
        return new StyleText();
    };
    StyleText.prototype.getDefaultInstance = function () {
        return StyleText.defaultInstace;
    };
    StyleText.defaultInstace = new StyleText();
    return StyleText;
}(StyleBase));
exports.StyleText = StyleText;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var StringUtils_1 = __webpack_require__(123);
var ColorHelper = /** @class */ (function () {
    function ColorHelper() {
    }
    ColorHelper.constructFromArgbNumber = function (alpha, red, green, blue) {
        return (alpha << 24) | (red << 16) | (green << 8) | blue;
    };
    ColorHelper.getPredefinedColor = function (color) {
        return ColorHelper.hashToColor(color, 0);
    };
    ColorHelper.isGray = function (color) {
        var red = ColorHelper.getRed(color);
        return red == ColorHelper.getGreen(color) && red == ColorHelper.getBlue(color);
    };
    ColorHelper.getAlpha = function (color) {
        return (color >> 24) & 255;
    };
    ColorHelper.getRed = function (color) {
        return (color >> 16) & 255;
    };
    ColorHelper.getGreen = function (color) {
        return (color >> 8) & 255;
    };
    ColorHelper.getBlue = function (color) {
        return color & 255;
    };
    ColorHelper.redPartToString = function (color) {
        var redStr = ColorHelper.getRed(color).toString(16);
        return redStr.length > 1 ? redStr : "0" + redStr;
    };
    ColorHelper.greenPartToString = function (color) {
        var greenStr = ColorHelper.getGreen(color).toString(16);
        return greenStr.length > 1 ? greenStr : "0" + greenStr;
    };
    ColorHelper.bluePartToString = function (color) {
        var blueStr = ColorHelper.getBlue(color).toString(16);
        return blueStr.length > 1 ? blueStr : "0" + blueStr;
    };
    ColorHelper.colorToHash = function (color) {
        return "#" + ColorHelper.redPartToString(color) + ColorHelper.greenPartToString(color) + ColorHelper.bluePartToString(color);
    };
    // static anyToColor(value: any, defaultValue: number): number {
    //     if (typeof value === "number" && !isNaN(value))
    //         return value;
    //     if (typeof value === "string") {
    //         var intValue = parseInt(value);
    //         return !isNaN(intValue) && value == <any>intValue ? intValue : ColorHelper.hashToColor(value);
    //     }
    //     return defaultValue;
    // }
    ColorHelper.hashToColor = function (hash, alpha) {
        if (alpha === void 0) { alpha = 255; }
        hash = hash.charAt(0) == "#" ? hash.substr(1) : hash;
        if (hash.length === 3)
            hash = StringUtils_1.StringUtils.repeat(hash.charAt(0), 2) + StringUtils_1.StringUtils.repeat(hash.charAt(1), 2) + StringUtils_1.StringUtils.repeat(hash.charAt(2), 2);
        return parseInt(hash, 16) | (alpha << 24);
    };
    ColorHelper.getActualForeColor = function (foreColor, backColor) {
        if (foreColor == ColorHelper.AUTOMATIC_COLOR) {
            var backColorIsLight = backColor == ColorHelper.AUTOMATIC_COLOR ||
                backColor == ColorHelper.NO_COLOR ||
                ColorHelper.calculateLumaY(backColor) >= ColorHelper.DEFAULT_BOUNDARY_LUMA;
            foreColor = backColorIsLight ? ColorHelper.DARK_COLOR : ColorHelper.LIGHT_COLOR;
        }
        return ColorHelper.getCssString(foreColor, true);
    };
    ColorHelper.getCssString = function (color, isAutoColorTranslateToDark) {
        if (color == ColorHelper.AUTOMATIC_COLOR)
            return ColorHelper.colorToHash(isAutoColorTranslateToDark ? ColorHelper.DARK_COLOR : ColorHelper.LIGHT_COLOR);
        return ColorHelper.getCssStringInternal(color);
    };
    ColorHelper.stringToHash = function (color) {
        return this.colorToHash(this.stringToColor(color));
    };
    ColorHelper.stringToColor = function (color) {
        var foreColorMatchesRGB = this.getRGBAByString(color);
        var hashColor = "";
        if (foreColorMatchesRGB) {
            return ((foreColorMatchesRGB[0] & 255) << 16) | ((foreColorMatchesRGB[1] & 255) << 8) | (foreColorMatchesRGB[2] & 255) |
                (((foreColorMatchesRGB.length > 3 ? foreColorMatchesRGB[3] : 255) & 255) << 24);
        }
        else {
            if (/^#([0-9a-f]{6})$/i.test(color) || /^#([0-9a-f]{3})$/i.test(color))
                hashColor = color;
            else if (/^[a-z]+$/i.test(color))
                hashColor = ColorHelper.colorNames[color.toLowerCase()];
        }
        if (hashColor)
            return ColorHelper.hashToColor(hashColor);
        return null;
    };
    ColorHelper.getRGBAByString = function (color) {
        var matchesRGBA = color.replace(/ +/g, '').match(/(rgba?)|(\d+(\.\d+)?%?)|(\.\d+)/g);
        if (matchesRGBA && matchesRGBA.length > 3) {
            var i = 0, itm;
            var result = [];
            while (i < matchesRGBA.length - 1) {
                itm = matchesRGBA[++i];
                if (itm.indexOf('%') != -1)
                    itm = Math.round(parseFloat(itm) * 2.55);
                else
                    itm = parseInt(itm);
                if (itm < 0 || itm > 255)
                    return null;
                result.push(itm);
            }
            if (color.indexOf('rgba') === 0) {
                if (isNaN(result[3]) || result[3] < 0 || result[3] > 1)
                    return null;
                else if (result[3] <= 1)
                    result[3] = Math.round(result[3] * 255);
            }
            else if (result[3])
                return null;
            return result;
        }
        return null;
    };
    ColorHelper.IsDarkColor = function (color) {
        return ColorHelper.calculateLumaY(color) < ColorHelper.DEFAULT_BOUNDARY_LUMA;
    };
    ColorHelper.getCssStringInternal = function (color) {
        var alpfa = ColorHelper.getAlpha(color);
        switch (alpfa) {
            case 0: return "transparent";
            case 255: return ColorHelper.colorToHash(color);
            default: return "rgba(" + ColorHelper.getRed(color) + "," + ColorHelper.getGreen(color) + "," + ColorHelper.getBlue(color) + "," + (alpfa / 255) + ")";
        }
    };
    ColorHelper.isEmptyBgColor = function (color) {
        return color === this.AUTOMATIC_COLOR || color === this.NO_COLOR;
    };
    ColorHelper.calculateLumaY = function (color) {
        //ITU 601:
        //Y' = 0.299 * R + 0.587 * G + 0.114 * B
        //Word boundary: 60.762 (possible not very accurate). All tests based on MSWord results
        //y = Y' * 65536
        return ColorHelper.DEFAULT_BOUNDARY_LUMA_RED * ColorHelper.getRed(color) +
            ColorHelper.DEFAULT_BOUNDARY_LUMA_GREEN * ColorHelper.getGreen(color) +
            ColorHelper.DEFAULT_BOUNDARY_LUMA_BLUE * ColorHelper.getBlue(color);
    };
    ColorHelper.colorNames = {
        aliceblue: '#f0f8ff', antiquewhite: '#faebd7', aqua: '#00ffff',
        aquamarine: '#7fffd4', azure: '#f0ffff', beige: '#f5f5dc',
        bisque: '#ffe4c4', black: '#000000', blanchedalmond: '#ffebcd',
        blue: '#0000ff', blueviolet: '#8a2be2', brown: '#a52a2a',
        burlywood: '#deb887', cadetblue: '#5f9ea0', chartreuse: '#7fff00',
        chocolate: '#d2691e', coral: '#ff7f50', cornflowerblue: '#6495ed',
        cornsilk: '#fff8dc', crimson: '#dc143c', cyan: '#00ffff',
        darkblue: '#00008b', darkcyan: '#008b8b', darkgoldenrod: '#b8860b',
        darkgray: '#a9a9a9', darkgreen: '#006400', darkkhaki: '#bdb76b',
        darkmagenta: '#8b008b', darkolivegreen: '#556b2f', darkorange: '#ff8c00',
        darkorchid: '#9932cc', darkred: '#8b0000', darksalmon: '#e9967a',
        darkseagreen: '#8fbc8f', darkslateblue: '#483d8b', darkslategray: '#2f4f4f',
        darkturquoise: '#00ced1', darkviolet: '#9400d3', deeppink: '#ff1493',
        deepskyblue: '#00bfff', dimgray: '#696969', dodgerblue: '#1e90ff',
        feldspar: '#d19275', firebrick: '#b22222', floralwhite: '#fffaf0',
        forestgreen: '#228b22', fuchsia: '#ff00ff', gainsboro: '#dcdcdc',
        ghostwhite: '#f8f8ff', gold: '#ffd700', goldenrod: '#daa520', gray: '#808080',
        green: '#00ff00', /* in winFroms green = 008000 */ greenyellow: '#adff2f', honeydew: '#f0fff0', hotpink: '#ff69b4',
        indianred: '#cd5c5c', indigo: '#4b0082', ivory: '#fffff0', khaki: '#f0e68c',
        lavender: '#e6e6fa', lavenderblush: '#fff0f5', lawngreen: '#7cfc00',
        lemonchiffon: '#fffacd', lightblue: '#add8e6', lightcoral: '#f08080',
        lightcyan: '#e0ffff', lightgoldenrodyellow: '#fafad2', lightgray: '#d3d3d3',
        lightgreen: '#90ee90', lightpink: '#ffb6c1', lightsalmon: '#ffa07a',
        lightseagreen: '#20b2aa', lightskyblue: '#87cefa', lightslateblue: '#8470ff',
        lightslategray: '#778899', lightsteelblue: '#b0c4de', lightyellow: '#ffffe0',
        lime: '#00ff00', limegreen: '#32cd32', linen: '#faf0e6', magenta: '#ff00ff',
        maroon: '#800000', mediumaquamarine: '#66cdaa', mediumblue: '#0000cd',
        mediumorchid: '#ba55d3', mediumpurple: '#9370d8', mediumseagreen: '#3cb371',
        mediumslateblue: '#7b68ee', mediumspringgreen: '#00fa9a', mediumturquoise: '#48d1cc',
        mediumvioletred: '#c71585', midnightblue: '#191970', mintcream: '#f5fffa',
        mistyrose: '#ffe4e1', moccasin: '#ffe4b5', navajowhite: '#ffdead', navy: '#000080',
        oldlace: '#fdf5e6', olive: '#808000', olivedrab: '#6b8e23', orange: '#ffa500',
        orangered: '#ff4500', orchid: '#da70d6', palegoldenrod: '#eee8aa', palegreen: '#98fb98',
        paleturquoise: '#afeeee', palevioletred: '#d87093', papayawhip: '#ffefd5',
        peachpuff: '#ffdab9', peru: '#cd853f', pink: '#ffc0cb', plum: '#dda0dd',
        powderblue: '#b0e0e6', purple: '#800080', red: '#ff0000', rosybrown: '#bc8f8f',
        royalblue: '#4169e1', saddlebrown: '#8b4513', salmon: '#fa8072', sandybrown: '#f4a460',
        seagreen: '#2e8b57', seashell: '#fff5ee', sienna: '#a0522d', silver: '#c0c0c0',
        skyblue: '#87ceeb', slateblue: '#6a5acd', slategray: '#708090', snow: '#fffafa',
        springgreen: '#00ff7f', steelblue: '#4682b4', tan: '#d2b48c', teal: '#008080',
        thistle: '#d8bfd8', tomato: '#ff6347', turquoise: '#40e0d0', violet: '#ee82ee',
        violetred: '#d02090', wheat: '#f5deb3', white: '#ffffff', whitesmoke: '#f5f5f5',
        yellow: '#ffff00', yellowgreen: '#9acd32', windowtext: '#000000'
    };
    //ITU 601:
    //Y' = 0.299 * R + 0.587 * G + 0.114 * B
    ColorHelper.DEFAULT_BOUNDARY_LUMA = 60.762 * 65536; // exeprimental value;
    ColorHelper.DEFAULT_BOUNDARY_LUMA_RED = 0.299 * 65536;
    ColorHelper.DEFAULT_BOUNDARY_LUMA_BLUE = 0.114 * 65536;
    ColorHelper.DEFAULT_BOUNDARY_LUMA_GREEN = 0.587 * 65536;
    ColorHelper.DARK_COLOR = -16777216; // FFFFFFFFFF000000
    ColorHelper.LIGHT_COLOR = -1; // FFFFFFFFFFFFFFFF
    ColorHelper.BLACK_COLOR = -16777216; // FFFFFFFFFF000000 // todo delete
    // here need get color, that different from back color. (back color that table, paragraph, box back colors)
    ColorHelper.AUTOMATIC_COLOR = 0; // for text color, text strikeout, text underline. Character back color don't affect fore color, bot paragraph - affect
    ColorHelper.NO_COLOR = 16777215; // 00000000FFFFFF for back color
    return ColorHelper;
}());
exports.ColorHelper = ColorHelper;


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelChange_1 = __webpack_require__(83);
var Event_1 = __webpack_require__(12);
var UnitConverter_1 = __webpack_require__(13);
var GroupPrimitive_1 = __webpack_require__(22);
var Utils_1 = __webpack_require__(15);
var CanvasManagerBase_1 = __webpack_require__(33);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var CanvasItemsManager = /** @class */ (function (_super) {
    __extends(CanvasItemsManager, _super);
    function CanvasItemsManager(viewElement, zoomLevel) {
        var _this = _super.call(this, zoomLevel) || this;
        _this.itemSelectorGroupContainers = {};
        _this.itemSelectorElements = {};
        _this.itemGroupContainers = {};
        _this.itemElements = {};
        _this.itemChildElements = {};
        _this.pendingChanges = {};
        _this.updatesLock = 0;
        _this.initializeContainerElements(viewElement);
        return _this;
    }
    CanvasItemsManager.prototype.initializeContainerElements = function (view) {
        this.itemSelectorsContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), view);
        this.itemsContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), view);
    };
    CanvasItemsManager.prototype.clear = function () {
        Utils_1.RenderUtils.removeContent(this.itemSelectorsContainer);
        Utils_1.RenderUtils.removeContent(this.itemsContainer);
        this.itemSelectorGroupContainers = {};
        this.itemSelectorElements = {};
        this.itemGroupContainers = {};
        this.itemElements = {};
        this.itemChildElements = {};
    };
    CanvasItemsManager.prototype.beginUpdate = function () {
        this.updatesLock++;
    };
    CanvasItemsManager.prototype.endUpdate = function () {
        this.updatesLock--;
        if (this.updatesLock === 0)
            this.applyPendingChanges();
    };
    CanvasItemsManager.prototype.getPendingChanges = function () {
        var _this = this;
        return Object.keys(this.pendingChanges).map(function (key) { return _this.pendingChanges[key]; });
    };
    CanvasItemsManager.prototype.applyPendingChanges = function () {
        var changes = this.getPendingChanges();
        while (changes.length) {
            var changesCount = changes.length;
            this.applyPendingChangesCore(changes);
            changes = this.getPendingChanges();
            if (changesCount === changes.length)
                break;
        }
        this.pendingChanges = {};
    };
    CanvasItemsManager.prototype.applyPendingChangesCore = function (changes) {
        var _this = this;
        changes.forEach(function (change) {
            if (_this.applyChange(change))
                delete _this.pendingChanges[change.item.key];
        });
    };
    CanvasItemsManager.prototype.applyChange = function (change) {
        var item = change.item;
        var itemParent = this.getItemParent(item.zIndex, item.container && item.container.key);
        if (!itemParent)
            return false;
        if (item instanceof Shape_1.Shape)
            this.applyShapeChange(item, change.type);
        else if (item instanceof Connector_1.Connector)
            this.applyConnectorChange(item, change.type);
        return true;
    };
    CanvasItemsManager.prototype.postponeChanges = function (changes) {
        var _this = this;
        changes.forEach(function (change) {
            if (!_this.pendingChanges[change.key])
                _this.pendingChanges[change.key] = change;
            else {
                if (change.type === ModelChange_1.ItemChangeType.Create || change.type === ModelChange_1.ItemChangeType.Remove)
                    _this.pendingChanges[change.key] = change;
                else if (change.type === ModelChange_1.ItemChangeType.UpdateStructure) {
                    if (_this.pendingChanges[change.key].type === ModelChange_1.ItemChangeType.Update)
                        _this.pendingChanges[change.key] = change;
                }
            }
        });
    };
    // Notifications
    CanvasItemsManager.prototype.notifyModelChanged = function (changes) {
        var _this = this;
        if (this.updatesLock === 0) {
            changes.forEach(function (change) {
                _this.applyChange(change);
            });
        }
        else
            this.postponeChanges(changes);
    };
    CanvasItemsManager.prototype.notifyPageColorChanged = function (color) { };
    CanvasItemsManager.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) { };
    CanvasItemsManager.prototype.notifyDragStart = function (itemKeys) {
        var _this = this;
        itemKeys.forEach(function (itemKey) {
            if (_this.itemElements[itemKey])
                _this.itemElements[itemKey].style.pointerEvents = "none";
            if (_this.itemChildElements[itemKey])
                _this.itemChildElements[itemKey].style.pointerEvents = "none";
            if (_this.itemSelectorElements[itemKey])
                _this.itemSelectorElements[itemKey].style.display = "none";
        });
    };
    CanvasItemsManager.prototype.notifyDragEnd = function (itemKeys) {
        var _this = this;
        itemKeys.forEach(function (itemKey) {
            if (_this.itemElements[itemKey])
                _this.itemElements[itemKey].style.pointerEvents = "";
            if (_this.itemChildElements[itemKey])
                _this.itemChildElements[itemKey].style.pointerEvents = "";
            if (_this.itemSelectorElements[itemKey])
                _this.itemSelectorElements[itemKey].style.display = "";
        });
    };
    CanvasItemsManager.prototype.notifyDragScrollStart = function () { };
    CanvasItemsManager.prototype.notifyDragScrollEnd = function () { };
    CanvasItemsManager.prototype.notifyTextInputStart = function (item, text, position, size) {
        var element = this.itemElements[item.key];
        var className = element.getAttribute("class");
        element.setAttribute("class", className + " text-input");
    };
    CanvasItemsManager.prototype.notifyTextInputEnd = function (item) {
        var element = this.itemElements[item.key];
        var className = element.getAttribute("class");
        element.setAttribute("class", className.replace(" text-input", ""));
    };
    CanvasItemsManager.prototype.notifyActualZoomChanged = function (actualZoom) {
        var scale = "scale(" + actualZoom + ")";
        this.itemsContainer.setAttribute('transform', scale);
        this.itemSelectorsContainer.setAttribute('transform', scale);
        this.actualZoom = actualZoom;
    };
    CanvasItemsManager.prototype.notifyViewAdjusted = function (canvasOffset) { };
    // Drawing
    CanvasItemsManager.prototype.applyShapeChange = function (shape, type) {
        var key = shape.key;
        var containerKey = shape.container && shape.container.key;
        var itemSelectorParent = this.getItemSelectorGroupContainer(shape.zIndex, containerKey);
        var itemParent = this.getItemGroupContainer(shape.zIndex, containerKey);
        var className = "shape";
        if (shape.enableChildren)
            className += " container";
        switch (type) {
            case ModelChange_1.ItemChangeType.Create:
                this.itemSelectorElements[key] = this.createItemElements(key, shape.getSelectorPrimitives(), itemSelectorParent, className, Event_1.MouseEventElementType.Shape);
                this.itemElements[key] = this.createItemElements(key, shape.getPrimitives(), itemParent, className, Event_1.MouseEventElementType.Shape);
                if (shape.enableChildren) {
                    this.itemChildElements[key] = this.createItemElements(key, [], itemParent, "container-children", Event_1.MouseEventElementType.Undefined);
                    this.changeItemChildrenVisibility(this.itemChildElements[key], shape.expanded);
                }
                break;
            case ModelChange_1.ItemChangeType.Remove:
                this.removeItemElements(this.itemSelectorElements[key]);
                delete this.itemSelectorElements[key];
                this.removeItemElements(this.itemElements[key]);
                delete this.itemElements[key];
                if (this.itemChildElements[key]) {
                    this.removeItemElements(this.itemChildElements[key]);
                    delete this.itemChildElements[key];
                    delete this.itemGroupContainers[key];
                    delete this.itemSelectorGroupContainers[key];
                }
                break;
            case ModelChange_1.ItemChangeType.UpdateStructure:
            case ModelChange_1.ItemChangeType.Update:
                this.changeItemElements(shape.getSelectorPrimitives(), this.itemSelectorElements[key], type === ModelChange_1.ItemChangeType.UpdateStructure);
                this.changeItemElements(shape.getPrimitives(), this.itemElements[key], type === ModelChange_1.ItemChangeType.UpdateStructure);
                if (this.itemChildElements[key]) {
                    this.changeItemChildrenVisibility(this.itemChildElements[key], shape.expanded);
                }
                if (itemSelectorParent !== (this.itemSelectorElements[key] && this.itemSelectorElements[key].parentNode))
                    this.moveItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                if (itemParent !== (this.itemElements[key] && this.itemElements[key].parentNode))
                    this.moveItemElements(itemParent, this.itemElements[key]);
                if (this.itemChildElements[key] && (itemParent !== this.itemChildElements[key].parentNode))
                    this.moveItemElements(itemParent, this.itemChildElements[key]);
                break;
        }
    };
    CanvasItemsManager.prototype.applyConnectorChange = function (connector, type) {
        var key = connector.key;
        var containerKey = connector.container && connector.container.key;
        var itemSelectorParent = this.getItemSelectorGroupContainer(connector.zIndex, containerKey);
        var itemParent = this.getItemGroupContainer(connector.zIndex, containerKey);
        var className = "connector";
        switch (type) {
            case ModelChange_1.ItemChangeType.Create:
                this.itemSelectorElements[key] = this.createItemElements(key, connector.getSelectorPrimitives(), itemSelectorParent, className, Event_1.MouseEventElementType.Connector);
                this.itemElements[key] = this.createItemElements(key, connector.getPrimitives(), itemParent, className, Event_1.MouseEventElementType.Connector);
                break;
            case ModelChange_1.ItemChangeType.Remove:
                this.removeItemElements(this.itemSelectorElements[key]);
                delete this.itemSelectorElements[key];
                this.removeItemElements(this.itemElements[key]);
                delete this.itemElements[key];
                break;
            case ModelChange_1.ItemChangeType.UpdateStructure:
            case ModelChange_1.ItemChangeType.Update:
                this.changeItemElements(connector.getSelectorPrimitives(), this.itemSelectorElements[key], type === ModelChange_1.ItemChangeType.UpdateStructure);
                this.changeItemElements(connector.getPrimitives(), this.itemElements[key], type === ModelChange_1.ItemChangeType.UpdateStructure);
                if (itemSelectorParent !== (this.itemSelectorElements[key] && this.itemSelectorElements[key].parentNode))
                    this.moveItemElements(itemSelectorParent, this.itemSelectorElements[key]);
                if (itemParent !== (this.itemElements[key] && this.itemElements[key].parentNode))
                    this.moveItemElements(itemParent, this.itemElements[key]);
                break;
        }
    };
    CanvasItemsManager.prototype.createItemElements = function (key, primitives, parent, className, type) {
        var gEl = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], className), parent);
        Utils_1.RenderUtils.setElementEventData(gEl, type, key);
        this.createAndChangePrimitivesElements(primitives, gEl);
        return gEl;
    };
    CanvasItemsManager.prototype.changeItemElements = function (primitives, element, updateStructure) {
        if (updateStructure === void 0) { updateStructure = false; }
        if (updateStructure) {
            Utils_1.RenderUtils.removeContent(element);
            this.createAndChangePrimitivesElements(primitives, element);
        }
        else
            this.changePrimitivesElements(primitives, element);
    };
    CanvasItemsManager.prototype.removeItemElements = function (element) {
        if (element && element.parentNode)
            element.parentNode.removeChild(element);
    };
    CanvasItemsManager.prototype.moveItemElements = function (parent, element, sibling) {
        if (element && parent) {
            if (sibling)
                parent.insertBefore(element, sibling);
            else
                parent.appendChild(element);
        }
    };
    CanvasItemsManager.prototype.changeItemChildrenVisibility = function (element, expanded) {
        element.style.display = expanded ? "" : "none";
    };
    CanvasItemsManager.prototype.getItemGroupContainerKey = function (zIndex, parentContainerKey) {
        return parentContainerKey !== undefined ? zIndex + "_" + parentContainerKey : zIndex.toString();
    };
    CanvasItemsManager.prototype.getItemGroupContainer = function (zIndex, parentContainerKey) {
        var parent = parentContainerKey !== undefined ? this.getItemParent(zIndex, parentContainerKey) : this.itemsContainer;
        var key = parentContainerKey || "Main";
        if (this.itemGroupContainers[key] === undefined || this.itemGroupContainers[key][zIndex] === undefined) {
            if (this.itemGroupContainers[key] === undefined)
                this.itemGroupContainers[key] = [];
            this.itemGroupContainers[key][zIndex] = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null, zIndex), parent, this.itemGroupContainers[key][zIndex + 1]);
        }
        return this.itemGroupContainers[key][zIndex];
    };
    CanvasItemsManager.prototype.getItemSelectorGroupContainer = function (zIndex, parentContainerKey) {
        var parent = parentContainerKey !== undefined ? this.getItemSelectorParent(zIndex, parentContainerKey) : this.itemSelectorsContainer;
        var key = parentContainerKey || "Main";
        if (this.itemSelectorGroupContainers[key] === undefined || this.itemSelectorGroupContainers[key][zIndex] === undefined) {
            if (this.itemSelectorGroupContainers[key] === undefined)
                this.itemSelectorGroupContainers[key] = [];
            this.itemSelectorGroupContainers[key][zIndex] = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null, zIndex), parent, this.itemSelectorGroupContainers[key][zIndex + 1]);
        }
        return this.itemSelectorGroupContainers[key][zIndex];
    };
    CanvasItemsManager.prototype.getItemParent = function (zIndex, parentContainerKey) {
        return parentContainerKey !== undefined ?
            this.itemChildElements[parentContainerKey] :
            this.getItemGroupContainer(zIndex);
    };
    CanvasItemsManager.prototype.getItemSelectorParent = function (zIndex, parentContainerKey) {
        return parentContainerKey !== undefined ?
            this.itemChildElements[parentContainerKey] :
            this.getItemSelectorGroupContainer(zIndex);
    };
    CanvasItemsManager.selectionMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(10);
    CanvasItemsManager.lockedSelectionMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasItemsManager.selectionRectLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasItemsManager.multiSelectionRectLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasItemsManager.connectionPointSmallSize = UnitConverter_1.UnitConverter.pixelsToTwips(5);
    CanvasItemsManager.connectionPointLargeSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasItemsManager.connectionMarkSmallSize = UnitConverter_1.UnitConverter.pixelsToTwips(12);
    CanvasItemsManager.connectionMarkLargeSize = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasItemsManager.connectionMarkShift = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasItemsManager.connectionTargetBorderWidth = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    CanvasItemsManager.connectorSelectionLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasItemsManager.connectorSelectionWidth = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasItemsManager.geomertyMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(8);
    CanvasItemsManager.connectorPointMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasItemsManager.connectorSideMarkSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasItemsManager.extensionLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasItemsManager.extensionLineOffset = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    CanvasItemsManager.extensionLineEndingSize = UnitConverter_1.UnitConverter.pixelsToTwips(6);
    CanvasItemsManager.resizeInfoOffset = UnitConverter_1.UnitConverter.pixelsToTwips(16);
    CanvasItemsManager.resizeInfoTextOffset = UnitConverter_1.UnitConverter.pixelsToTwips(2);
    CanvasItemsManager.resizeInfoLineWidth = UnitConverter_1.UnitConverter.pixelsToTwips(1);
    return CanvasItemsManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasItemsManager = CanvasItemsManager;


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base64_1 = __webpack_require__(86);
var ImageInfo = /** @class */ (function () {
    function ImageInfo(imageUrlOrBase64) {
        this.url = undefined;
        this.base64 = undefined;
        if (imageUrlOrBase64) {
            if (Base64_1.Base64Utils.checkPrependDataUrl(imageUrlOrBase64))
                this.base64 = imageUrlOrBase64;
            else
                this.url = imageUrlOrBase64;
        }
        this.loadFailed = false;
    }
    ImageInfo.prototype.clone = function () {
        var result = new ImageInfo();
        result.url = this.url;
        result.base64 = this.base64;
        return result;
    };
    Object.defineProperty(ImageInfo.prototype, "isEmpty", {
        get: function () { return this.url === undefined && this.base64 === undefined; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "unableToLoad", {
        get: function () { return this.loadFailed; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "renderUrl", {
        get: function () { return this.base64 || ""; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "exportUrl", {
        get: function () { return this.base64 ? this.base64 : this.url; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ImageInfo, "transparentOnePixelImage", {
        get: function () { return this.transparentWhiteImage1_1; },
        enumerable: true,
        configurable: true
    });
    ImageInfo.prototype.loadBase64Content = function (base64Content) {
        this.base64 = Base64_1.Base64Utils.normalize(base64Content);
    };
    ImageInfo.prototype.setUnableToLoadFlag = function () {
        this.loadFailed = true;
    };
    ImageInfo.transparentWhiteImage1_1 = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAANSURBVBhXY/j///9/AAn7A/0FQ0XKAAAAAElFTkSuQmCC';
    return ImageInfo;
}());
exports.ImageInfo = ImageInfo;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var _1 = __webpack_require__(10);
var Model_1 = __webpack_require__(23);
var Utils_1 = __webpack_require__(0);
var DiagramSettings = /** @class */ (function () {
    function DiagramSettings() {
        this.onZoomChanged = new _1.EventDispatcher();
        this.onViewChanged = new _1.EventDispatcher();
        this.onReadOnlyChanged = new _1.EventDispatcher();
        this._zoomLevel = 1;
        this._zoomLevelItems = [0.5, 0.75, 1, 1.25, 1.5, 2, 3];
        this._simpleView = false;
        this._fullscreen = false;
        this._readOnly = false;
        this._autoZoom = AutoZoomMode.Disabled;
        this._snapToGrid = true;
        this._showGrid = true;
        this._gridSize = 180;
        this._gridSizeItems = [90, 180, 360, 720];
        this._pageSizeItems = [
            { size: new Utils_1.Size(12240, 15840), text: "US-Letter ({width} x {height})" },
            { size: new Utils_1.Size(12240, 20160), text: "US-Legal ({width} x {height})" },
            { size: new Utils_1.Size(15817, 24491), text: "US-Tabloid ({width} x {height})" },
            { size: new Utils_1.Size(47679, 67408), text: "A0 ({width} x {height})" },
            { size: new Utils_1.Size(33676, 47679), text: "A1 ({width} x {height})" },
            { size: new Utils_1.Size(23811, 33676), text: "A2 ({width} x {height})" },
            { size: new Utils_1.Size(16838, 23811), text: "A3 ({width} x {height})" },
            { size: new Utils_1.Size(11906, 16838), text: "A4 ({width} x {height})" },
            { size: new Utils_1.Size(8391, 11906), text: "A5 ({width} x {height})" },
            { size: new Utils_1.Size(5953, 8391), text: "A6 ({width} x {height})" },
            { size: new Utils_1.Size(4195, 5953), text: "A7 ({width} x {height})" }
        ];
        this._viewUnits = Model_1.DiagramUnit.In;
        this.unitItems = {};
        this.formatUnit = function (value) { return value.toString(); };
        this.unitItems[Model_1.DiagramUnit.In] = "in";
        this.unitItems[Model_1.DiagramUnit.Cm] = "cm";
        this.unitItems[Model_1.DiagramUnit.Px] = "px";
    }
    Object.defineProperty(DiagramSettings.prototype, "zoomLevel", {
        get: function () { return this._zoomLevel; },
        set: function (value) {
            var _this = this;
            value = DiagramSettings.correctZoomLevel(value);
            if (value !== this._zoomLevel) {
                this._zoomLevel = value;
                this.onZoomChanged.raise1(function (listener) { return listener.notifyZoomChanged(value, _this._autoZoom); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "zoomLevelItems", {
        get: function () { return this._zoomLevelItems; },
        set: function (value) {
            value = value.map(function (l) { return DiagramSettings.correctZoomLevel(l); });
            if (value !== this._zoomLevelItems) {
                this._zoomLevelItems = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "autoZoom", {
        get: function () { return this._autoZoom; },
        set: function (value) {
            var _this = this;
            if (value !== this._autoZoom) {
                this._autoZoom = value;
                this.onZoomChanged.raise1(function (l) { return l.notifyZoomChanged(_this._zoomLevel, value); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "simpleView", {
        get: function () { return this._simpleView; },
        set: function (value) {
            if (value !== this._simpleView) {
                this._simpleView = value;
                this.onViewChanged.raise1(function (listener) { return listener.notifyViewChanged(value); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "readOnly", {
        get: function () { return this._readOnly; },
        set: function (value) {
            if (value !== this._readOnly) {
                this._readOnly = value;
                this.onReadOnlyChanged.raise1(function (listener) { return listener.notifyReadOnlyChanged(value); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "fullscreen", {
        get: function () { return this._fullscreen; },
        set: function (value) { this._fullscreen = value; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "snapToGrid", {
        get: function () { return this._snapToGrid; },
        set: function (value) { this._snapToGrid = value; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "showGrid", {
        get: function () { return this._showGrid; },
        set: function (value) {
            var _this = this;
            if (value !== this._showGrid) {
                this._showGrid = value;
                this.onViewChanged.raise1(function (l) { return l.notifyGridChanged(_this.showGrid, _this.gridSize); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "gridSize", {
        get: function () { return this._gridSize; },
        set: function (value) {
            var _this = this;
            if (value !== this._gridSize) {
                this._gridSize = value;
                this.onViewChanged.raise1(function (l) { return l.notifyGridChanged(_this.showGrid, _this.gridSize); });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "gridSizeItems", {
        get: function () { return this._gridSizeItems; },
        set: function (value) {
            if (value !== this._gridSizeItems) {
                this._gridSizeItems = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "pageSizeItems", {
        get: function () { return this._pageSizeItems; },
        set: function (value) {
            if (value !== this._pageSizeItems) {
                this._pageSizeItems = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DiagramSettings.prototype, "viewUnits", {
        get: function () { return this._viewUnits; },
        set: function (value) { this._viewUnits = value; },
        enumerable: true,
        configurable: true
    });
    DiagramSettings.correctZoomLevel = function (level) {
        return Math.min(10, Math.max(level, 0.01));
    };
    return DiagramSettings;
}());
exports.DiagramSettings = DiagramSettings;
var AutoZoomMode;
(function (AutoZoomMode) {
    AutoZoomMode[AutoZoomMode["Disabled"] = 0] = "Disabled";
    AutoZoomMode[AutoZoomMode["FitContent"] = 1] = "FitContent";
    AutoZoomMode[AutoZoomMode["FitToWidth"] = 2] = "FitToWidth";
})(AutoZoomMode = exports.AutoZoomMode || (exports.AutoZoomMode = {}));


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var ClipPathPrimitive = /** @class */ (function (_super) {
    __extends(ClipPathPrimitive, _super);
    function ClipPathPrimitive(id, children) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.children = children;
        return _this;
    }
    ClipPathPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "clipPath");
    };
    ClipPathPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return ClipPathPrimitive;
}(Primitive_1.SvgPrimitive));
exports.ClipPathPrimitive = ClipPathPrimitive;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var Connector_1 = __webpack_require__(5);
var ConnectorPointsOrthogonalSideCalculatorBase = /** @class */ (function () {
    function ConnectorPointsOrthogonalSideCalculatorBase(parent) {
        this.parent = parent;
    }
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "connector", {
        get: function () { return this.parent.connector; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "beginRect", {
        get: function () { return this.parent.beginRect; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "endRect", {
        get: function () { return this.parent.endRect; },
        enumerable: true,
        configurable: true
    });
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getBeginOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(originPoint, targetPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getBeginOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getBeginOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getBeginOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getEndOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(targetPoint, originPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getEndOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getEndOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getEndOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSide = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY) {
            if (targetPoint.x > originPoint.x)
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.West;
        }
        else {
            if (targetPoint.y > originPoint.y)
                return DiagramItem_1.ConnectionPointSide.South;
            else
                return DiagramItem_1.ConnectionPointSide.North;
        }
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSideCalculator = function (originPoint, targetPoint) {
        return this.parent.getSideCalculator(this.getSide(originPoint, targetPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getMinOffset = function () {
        return Connector_1.Connector.minOffset;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndSame = function () {
        return this.connector.beginItem === this.connector.endItem;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlapped = function () {
        return this.beginRect && this.endRect && this.beginRect.intersect(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedX = function () {
        return this.beginRect && this.endRect && this.beginRect.intersectX(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedY = function () {
        return this.beginRect && this.endRect && this.beginRect.intersectY(this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedPoints = function (beginPoint, endPoint) {
        return this.beginRect && this.endRect && (this.beginRect.contains(endPoint) || this.endRect.contains(beginPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isOriginRectContainsTargetPoint = function (originRect, targetPoint) {
        return originRect && originRect.contains(targetPoint);
    };
    return ConnectorPointsOrthogonalSideCalculatorBase;
}());
exports.ConnectorPointsOrthogonalSideCalculatorBase = ConnectorPointsOrthogonalSideCalculatorBase;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var SetSelectionHistoryItem = /** @class */ (function (_super) {
    __extends(SetSelectionHistoryItem, _super);
    function SetSelectionHistoryItem(selection, selectedKeys) {
        var _this = _super.call(this) || this;
        _this.selectedKeys = selectedKeys;
        _this.selection = selection;
        return _this;
    }
    SetSelectionHistoryItem.prototype.redo = function () {
        this.oldSelection = this.selection.getKeys().slice(0);
        this.selection.set(this.selectedKeys);
    };
    SetSelectionHistoryItem.prototype.undo = function () {
        this.selection.set(this.oldSelection);
    };
    return SetSelectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetSelectionHistoryItem = SetSelectionHistoryItem;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var UnitConverter_1 = __webpack_require__(13);
var ImagePrimitive_1 = __webpack_require__(97);
var ShapeDescription_1 = __webpack_require__(8);
var RectaglePrimitive_1 = __webpack_require__(18);
var GroupPrimitive_1 = __webpack_require__(22);
var Utils_2 = __webpack_require__(15);
var ClipPathPrimitive_1 = __webpack_require__(42);
var LoadingIndicator_1 = __webpack_require__(177);
var UserPrimitive_1 = __webpack_require__(178);
var WarningPrimitive_1 = __webpack_require__(179);
exports.ShapeDefaultDimension = 1440;
exports.ShapeDefaultSize = new Utils_1.Size(exports.ShapeDefaultDimension, exports.ShapeDefaultDimension);
exports.SHAPE_IMAGE_CLASSNAMES = {
    IMAGE: "dxdi-image",
    IMAGE_PLACEHOLDER: "dxdi-image-placeholder",
    LOADING_INDICATOR: "dxdi-spinner",
    USER_PIC: "dxdi-user",
    WARNING_MARK: "dxdi-warning"
};
var ShapeWithImageDescription = /** @class */ (function (_super) {
    __extends(ShapeWithImageDescription, _super);
    function ShapeWithImageDescription(title, defaultText, defaultSize, defaultImageUrl) {
        if (defaultSize === void 0) { defaultSize = exports.ShapeDefaultSize.clone(); }
        var _this = _super.call(this, title, defaultText, defaultSize, defaultImageUrl) || this;
        _this.title = title;
        _this.defaultText = defaultText;
        _this.defaultSize = defaultSize;
        _this.defaultImageUrl = defaultImageUrl;
        return _this;
    }
    Object.defineProperty(ShapeWithImageDescription.prototype, "enableImage", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    ShapeWithImageDescription.getImageMargins = function (forToolbox) {
        return UnitConverter_1.UnitConverter.pixelsToTwips(3);
    };
    ShapeWithImageDescription.prototype.createImagePrimitives = function (shape, forToolbox) {
        if (!this.enableImage)
            return [];
        var rect = this.getImagePlacementRectangle(shape.rectangle, forToolbox);
        if (forToolbox)
            return this.createImagePlaceholder(rect);
        var imagePrimitives = [];
        if (shape.image.isEmpty || shape.image.unableToLoad)
            imagePrimitives = imagePrimitives.concat(this.createEmptyImagePrimitives(rect, shape.image.unableToLoad));
        else if (shape.image.renderUrl === "")
            imagePrimitives = imagePrimitives.concat(this.createLoadingImagePrimitives(rect));
        else
            imagePrimitives = imagePrimitives.concat(this.createLoadedImagePrimitives(rect, shape.image.renderUrl));
        if (shape.image.renderUrl === "") {
            var clipPathId = Utils_2.RenderUtils.generateSvgElementId("clipImage");
            return [
                new GroupPrimitive_1.GroupPrimitive(imagePrimitives, exports.SHAPE_IMAGE_CLASSNAMES.IMAGE, undefined, clipPathId),
                new ClipPathPrimitive_1.ClipPathPrimitive(clipPathId, [new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.width, rect.height)])
            ];
        }
        else
            return imagePrimitives;
    };
    ShapeWithImageDescription.prototype.createImagePlaceholder = function (rect) {
        return [];
    };
    ShapeWithImageDescription.prototype.createLoadedImagePrimitives = function (rect, imageUrl) {
        return [
            new ImagePrimitive_1.ImagePrimitive(rect.left, rect.top, rect.width, rect.height, imageUrl, ShapeWithImageDescription.imageScalingRule, undefined, exports.SHAPE_IMAGE_CLASSNAMES.IMAGE)
        ];
    };
    ShapeWithImageDescription.prototype.createLoadingImagePrimitives = function (rect) {
        var loadingRect = this.getIconPlacementRectangle(rect);
        return [
            new LoadingIndicator_1.LoadingIndicatorPrimitive(loadingRect.left, loadingRect.top, 240, UnitConverter_1.UnitConverter.pixelsToTwips(5), exports.SHAPE_IMAGE_CLASSNAMES.LOADING_INDICATOR)
        ];
    };
    ShapeWithImageDescription.prototype.createEmptyImagePrimitives = function (rect, showWarning) {
        var loadingRect = this.getIconPlacementRectangle(rect);
        var primitives = [];
        primitives = primitives.concat(new UserPrimitive_1.UserPrimitive(loadingRect.left, loadingRect.top, 480, UnitConverter_1.UnitConverter.pixelsToTwips(1), exports.SHAPE_IMAGE_CLASSNAMES.USER_PIC));
        if (showWarning)
            primitives = primitives.concat(new WarningPrimitive_1.WarningPrimitive(loadingRect.left + 240 + UnitConverter_1.UnitConverter.pixelsToTwips(1), loadingRect.top + 240, 240, exports.SHAPE_IMAGE_CLASSNAMES.WARNING_MARK));
        return primitives;
    };
    ShapeWithImageDescription.prototype.getIconPlacementRectangle = function (rect) {
        var iconRect = new Utils_1.Rectangle(new Utils_1.Point(rect.left, rect.top), new Utils_1.Size(480, 480));
        if (iconRect.width < rect.width)
            iconRect.position.x = rect.left + (rect.width - iconRect.width) / 2;
        if (iconRect.height < rect.height)
            iconRect.position.y = rect.top + (rect.height - iconRect.height) / 2;
        return iconRect;
    };
    ShapeWithImageDescription.prototype.getImagePlacementRectangle = function (rect, forToolbox) {
        var imageSize = this.getImageSize(rect, forToolbox);
        var imageRectangle = Utils_1.Rectangle.create(rect.left, rect.top, imageSize.width, imageSize.height);
        var textBlockOffset = this.getTextBlockOffset(rect, forToolbox);
        if (textBlockOffset.right > 0)
            imageRectangle.position.x = rect.right - textBlockOffset.right - ShapeWithImageDescription.getImageMargins(forToolbox);
        else if (textBlockOffset.left > 0)
            imageRectangle.position.x += ShapeWithImageDescription.getImageMargins(forToolbox);
        if (textBlockOffset.bottom > 0)
            imageRectangle.position.y = rect.bottom - textBlockOffset.bottom - ShapeWithImageDescription.getImageMargins(forToolbox);
        else
            imageRectangle.position.y += ShapeWithImageDescription.getImageMargins(forToolbox);
        if (textBlockOffset.top > 0 || textBlockOffset.bottom > 0)
            imageRectangle.position.x = imageRectangle.left + (rect.width - imageRectangle.width) / 2;
        return imageRectangle;
    };
    ShapeWithImageDescription.prototype.getImageSize = function (rect, forToolbox) {
        var imageSize = this.getRawImageSize(rect, forToolbox);
        return this.correctImageSize(imageSize);
    };
    ShapeWithImageDescription.prototype.getRawImageSize = function (rect, forToolbox) {
        return new Utils_1.Size(0, 0);
    };
    ShapeWithImageDescription.prototype.correctImageSize = function (imageSize) {
        imageSize.width = Math.max(imageSize.width, 0);
        imageSize.height = Math.max(imageSize.height, 0);
        return imageSize;
    };
    ShapeWithImageDescription.prototype.getTextBlockOffset = function (rect, forToolbox) {
        return Utils_1.Offset.empty();
    };
    ShapeWithImageDescription.imageScalingRule = "xMidYMid meet";
    return ShapeWithImageDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ShapeWithImageDescription = ShapeWithImageDescription;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleHistoryItemBase_1 = __webpack_require__(101);
var ChangeStyleHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeStyleHistoryItem, _super);
    function ChangeStyleHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleHistoryItem = ChangeStyleHistoryItem;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var ExportImportCommandBase = /** @class */ (function (_super) {
    __extends(ExportImportCommandBase, _super);
    function ExportImportCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportImportCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    return ExportImportCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ExportImportCommandBase = ExportImportCommandBase;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(24);
var TouchUIHelper_1 = __webpack_require__(81);
var Base_1 = __webpack_require__(19);
var Evt = /** @class */ (function () {
    function Evt() {
    }
    Evt.GetEvent = function (evt) {
        return (typeof (event) != "undefined" && event != null && Browser_1.Browser.IE) ? event : evt;
    };
    Evt.AttachEventToElement = function (element, eventName, handler, onlyBubbling) {
        if (onlyBubbling === void 0) { onlyBubbling = false; }
        if (element.addEventListener)
            element.addEventListener(eventName, handler, !onlyBubbling);
        else
            element.attachEvent("on" + eventName, handler);
    };
    Evt.AttachEventToDocument = function (eventName, handler) {
        var attachingAllowed = TouchUIHelper_1.TouchUIHelper.onEventAttachingToDocument(eventName, handler);
        if (attachingAllowed)
            Evt.AttachEventToElement(document, eventName, handler);
    };
    Evt.PreventEvent = function (evt) {
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
        return false;
    };
    Evt.GetKeyCode = function (evt) {
        return Browser_1.Browser.NetscapeFamily || Browser_1.Browser.Opera ? evt.which : evt.keyCode;
    };
    Evt.GetEventSource = function (evt) {
        if (!Base_1.IsExists(evt))
            return null;
        return evt.srcElement ? evt.srcElement : evt.target;
    };
    Evt.GetMouseWheelEventName = function () {
        if (Browser_1.Browser.Safari)
            return "mousewheel";
        if (Browser_1.Browser.NetscapeFamily && Browser_1.Browser.MajorVersion < 17)
            return "DOMMouseScroll";
        return "wheel";
    };
    Evt.IsLeftButtonPressed = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return true;
        evt = Evt.GetEvent(evt);
        if (!evt)
            return false;
        if (Browser_1.Browser.IE && Browser_1.Browser.Version < 11) {
            if (Browser_1.Browser.MSTouchUI)
                return true;
            return evt.button % 2 == 1; // B213431
        }
        else if (Browser_1.Browser.WebKitFamily) {
            if (evt.type === "pointermove")
                return evt.buttons === 1;
            return evt.which == 1;
        }
        else if (Browser_1.Browser.NetscapeFamily || Browser_1.Browser.Edge || (Browser_1.Browser.IE && Browser_1.Browser.Version >= 11)) {
            if (evt.type === TouchUIHelper_1.TouchUIHelper.touchMouseMoveEventName)
                return evt.buttons === 1;
            return evt.which == 1;
        }
        else if (Browser_1.Browser.Opera)
            return evt.button == 0;
        return true;
    };
    Evt.PreventEventAndBubble = function (evt) {
        Evt.PreventEvent(evt);
        if (evt.stopPropagation)
            evt.stopPropagation();
        evt.cancelBubble = true;
        return false;
    };
    Evt.clientEventRequiresDocScrollCorrection = function () {
        var isSafariVerLess3 = Browser_1.Browser.Safari && Browser_1.Browser.Version < 3, isMacOSMobileVerLess51 = Browser_1.Browser.MacOSMobilePlatform && Browser_1.Browser.Version < 5.1;
        return Browser_1.Browser.AndroidDefaultBrowser || Browser_1.Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
    };
    Evt.GetEventX = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return TouchUIHelper_1.TouchUIHelper.getEventX(evt);
        return evt.clientX + (Evt.clientEventRequiresDocScrollCorrection() ? Base_1.GetDocumentScrollLeft() : 0);
    };
    Evt.GetEventY = function (evt) {
        if (TouchUIHelper_1.TouchUIHelper.isTouchEvent(evt))
            return TouchUIHelper_1.TouchUIHelper.getEventY(evt);
        return evt.clientY + (Evt.clientEventRequiresDocScrollCorrection() ? Base_1.GetDocumentScrollTop() : 0);
    };
    Evt.CancelBubble = function (evt) {
        evt.cancelBubble = true;
        return false;
    };
    return Evt;
}());
exports.Evt = Evt;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base64_1 = __webpack_require__(86);
var ImageInfo_1 = __webpack_require__(40);
var CacheImageInfo = /** @class */ (function () {
    function CacheImageInfo(base64, actualId, imageUrl, referenceInfo, isLoaded) {
        this._base64 = base64 !== undefined ? Base64_1.Base64Utils.normalize(base64) : undefined;
        this.actualId = actualId;
        this._referenceInfo = referenceInfo;
        this._isLoaded = isLoaded !== undefined ? isLoaded : false;
        this.imageUrl = imageUrl;
    }
    Object.defineProperty(CacheImageInfo.prototype, "isLoaded", {
        get: function () { return this._referenceInfo ? this._referenceInfo._isLoaded : this._isLoaded; },
        set: function (val) { this._isLoaded = val; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "base64", {
        get: function () { return this._base64; },
        set: function (val) { this._base64 = Base64_1.Base64Utils.normalize(val); },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "referenceInfo", {
        get: function () { return this._referenceInfo; },
        set: function (val) {
            this._referenceInfo = val;
            this._base64 = undefined;
            this._isLoaded = undefined;
        },
        enumerable: true,
        configurable: true
    });
    return CacheImageInfo;
}());
exports.CacheImageInfo = CacheImageInfo;
var ImageCache = /** @class */ (function () {
    function ImageCache() {
        this.emptyImageId = 0;
        this.lastActualId = 0;
        this.cache = [];
        var emptyImage = this.createUnloadedInfoByBase64(ImageInfo_1.ImageInfo.transparentOnePixelImage);
        emptyImage.isLoaded = true;
    }
    ImageCache.prototype.reset = function () {
        this.cache.splice(1);
        this.lastActualId = 1;
    };
    Object.defineProperty(ImageCache.prototype, "emptyImage", {
        get: function () { return this.cache[this.emptyImageId]; },
        enumerable: true,
        configurable: true
    });
    ImageCache.prototype.getImageData = function (id) {
        return this.cache[id];
    };
    ImageCache.prototype.createUnloadedInfoByUrl = function (imageUrl) {
        var info = this.findInfoByUrl(imageUrl);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(undefined, this.getNextActualId(), imageUrl));
    };
    ImageCache.prototype.createUnloadedInfoByBase64 = function (base64) {
        var info = this.findInfoByBase64(base64);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(base64, this.getNextActualId()));
    };
    ImageCache.prototype.createUnloadedInfoByShapeImageInfo = function (imageInfo) {
        var data = imageInfo.exportUrl;
        return Base64_1.Base64Utils.checkPrependDataUrl(data) ?
            this.createUnloadedInfoByBase64(data) :
            this.createUnloadedInfoByUrl(data);
    };
    ImageCache.prototype.registerImageData = function (data) {
        var existingData = this.cache[data.actualId];
        if (!existingData)
            existingData = data;
        if (data.actualId !== undefined)
            this.cache[data.actualId] = existingData;
        return existingData;
    };
    ImageCache.prototype.loadAllImages = function (loader) {
        var _this = this;
        this.cache.forEach(function (cacheInfo) {
            if (_this.emptyImageId != cacheInfo.actualId && !cacheInfo.isLoaded)
                loader.load(cacheInfo);
        });
    };
    ImageCache.prototype.finalizeLoading = function (existingInfo, loadedInfo) {
        existingInfo.isLoaded = true;
        if (existingInfo.referenceInfo)
            return;
        if (loadedInfo.base64) {
            var base64_1 = Base64_1.Base64Utils.normalize(loadedInfo.base64);
            this.cache.forEach(function (cacheElem) {
                var isReference = cacheElem.base64 == base64_1 && cacheElem !== existingInfo && cacheElem.isLoaded;
                if (isReference)
                    existingInfo.referenceInfo = cacheElem.referenceInfo ? cacheElem.referenceInfo : cacheElem;
                return isReference;
            });
            existingInfo.base64 = base64_1;
        }
    };
    ImageCache.prototype.getNextActualId = function () {
        return this.lastActualId++;
    };
    ImageCache.prototype.findInfoByBase64 = function (base64) {
        base64 = Base64_1.Base64Utils.normalize(base64);
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.base64 === base64; });
    };
    ImageCache.prototype.findInfoByUrl = function (imageUrl) {
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.imageUrl === imageUrl; });
    };
    ImageCache.prototype.findInfoCore = function (callback) {
        var cacheInfo;
        this.cache.forEach(function (item) {
            if (callback(item))
                cacheInfo = item;
        });
        return cacheInfo;
    };
    ImageCache.instance = new ImageCache();
    return ImageCache;
}());
exports.ImageCache = ImageCache;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var MoveConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(MoveConnectorPointHistoryItem, _super);
    function MoveConnectorPointHistoryItem(connectorKey, pointIndex, point) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.point = point;
        return _this;
    }
    MoveConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldPoint = connector.points[this.pointIndex].clone();
        manipulator.moveConnectorPoint(connector, this.pointIndex, this.point);
    };
    MoveConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.moveConnectorPoint(connector, this.pointIndex, this.oldPoint);
    };
    return MoveConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveConnectorPointHistoryItem = MoveConnectorPointHistoryItem;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ShapeDescriptionManager_1 = __webpack_require__(26);
var Shape_1 = __webpack_require__(9);
var AddShapeHistoryItem = /** @class */ (function (_super) {
    __extends(AddShapeHistoryItem, _super);
    function AddShapeHistoryItem(shapeType, position, text, dataKey) {
        var _this = _super.call(this) || this;
        _this.shapeType = shapeType;
        _this.position = position;
        _this.text = text;
        _this.dataKey = dataKey;
        return _this;
    }
    AddShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = new Shape_1.Shape(ShapeDescriptionManager_1.ShapeDescriptionManager.get(this.shapeType), this.position);
        if (typeof this.text === "string")
            shape.text = this.text;
        if (this.dataKey !== undefined)
            shape.dataKey = this.dataKey;
        manipulator.addShape(shape, this.shapeKey);
        this.shapeKey = shape.key;
    };
    AddShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.deleteShape(manipulator.model.findShape(this.shapeKey));
    };
    return AddShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddShapeHistoryItem = AddShapeHistoryItem;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var Connector_1 = __webpack_require__(5);
var AddConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectorHistoryItem, _super);
    function AddConnectorHistoryItem(points, dataKey) {
        var _this = _super.call(this) || this;
        _this.points = points;
        _this.dataKey = dataKey;
        return _this;
    }
    AddConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = new Connector_1.Connector(this.points);
        if (this.dataKey !== undefined)
            connector.dataKey = this.dataKey;
        manipulator.addConnector(connector, this.connectorKey);
        this.connectorKey = connector.key;
    };
    AddConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnector(connector);
    };
    return AddConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorHistoryItem = AddConnectorHistoryItem;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Structures_1 = __webpack_require__(31);
var Shape_1 = __webpack_require__(9);
var Utils_1 = __webpack_require__(0);
var ListUtils_1 = __webpack_require__(69);
var GraphBase = /** @class */ (function () {
    function GraphBase(nodes, edges) {
        this.nodeMap = {};
        this.edgeMap = {};
        this.nodes = [];
        this.edges = [];
        this.onInit();
        nodes.forEach(this.addNode.bind(this));
        edges.forEach(this.addEdge.bind(this));
    }
    Object.defineProperty(GraphBase.prototype, "items", {
        get: function () {
            return this.nodes.map(this.getNode.bind(this));
        },
        enumerable: true,
        configurable: true
    });
    GraphBase.prototype.onInit = function () { };
    GraphBase.prototype.addEdge = function (edge) {
        this.edgeMap[edge.key] = edge;
        this.edges.push(edge);
    };
    GraphBase.prototype.addNode = function (node) {
        this.nodeMap[node.key] = node;
        this.nodes.push(node.key);
    };
    GraphBase.prototype.getNode = function (key) {
        return this.nodeMap[key];
    };
    GraphBase.prototype.getEdge = function (key) {
        return this.edgeMap[key];
    };
    GraphBase.prototype.isEmpty = function () {
        return !this.nodes.length && !this.edges.length;
    };
    GraphBase.prototype.getAdjacentEdges = function (nodeKey, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        return this.edges.filter(function (e) {
            return connectionMode & Structures_1.ConnectionMode.Incoming && e.to === nodeKey ||
                connectionMode & Structures_1.ConnectionMode.Outgoing && e.from === nodeKey;
        });
    };
    return GraphBase;
}());
var Graph = /** @class */ (function (_super) {
    __extends(Graph, _super);
    function Graph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Graph.prototype.cast = function (castNode, castEdge) {
        var _this = this;
        var newNodes = this.nodes.map(function (nk) { return castNode(_this.getNode(nk)); });
        var newEdges = this.edges.map(function (e) { return castEdge ? castEdge(e) : e; });
        return new Graph(newNodes, newEdges);
    };
    Graph.prototype.getConnectedComponents = function () {
        var iterator = this.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = true;
        var components = [];
        var _loop_1 = function (i) {
            var nodes = [];
            var edges = [];
            iterator.onNode = function (n) { return nodes.push(n); };
            iterator.onEdge = function (e) { return edges.push(e); };
            iterator.iterate(this_1.nodes[i]);
            if (nodes.length)
                components.push(new Graph(nodes, edges));
        };
        var this_1 = this;
        for (var i = 0; i < this.nodes.length; i++) {
            _loop_1(i);
        }
        return components;
    };
    Graph.prototype.createIterator = function (connectionMode) {
        var iterator = new GraphIterator(this, connectionMode);
        iterator.comparer = function (a, b) { return a.weight - b.weight; };
        return iterator;
    };
    Graph.prototype.getSpanningGraph = function (rootKey, connectionMode, edgeWeightFunc) {
        var _this = this;
        if (edgeWeightFunc === void 0) { edgeWeightFunc = undefined; }
        if (!this.nodes.length)
            return new Graph([], []);
        if (!edgeWeightFunc)
            edgeWeightFunc = function (e) { return e.weight; };
        var sortedAdjacentEdges = [];
        var spanningTreeNodesSet = new ListUtils_1.HashSet();
        var spanningTreeEdgesSet = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        this.addNodeToSpanningGraph(rootKey, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
        while (sortedAdjacentEdges.length && spanningTreeNodesSet.length !== this.nodes.length) {
            var minWeighedEdge = sortedAdjacentEdges.shift();
            spanningTreeEdgesSet.tryPush(minWeighedEdge);
            var node = spanningTreeNodesSet.contains(minWeighedEdge.from) ? minWeighedEdge.to : minWeighedEdge.from;
            this.addNodeToSpanningGraph(node, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
            sortedAdjacentEdges = sortedAdjacentEdges.filter(function (e) { return !spanningTreeNodesSet.contains(e.from) || !spanningTreeNodesSet.contains(e.to); });
        }
        return new Graph(spanningTreeNodesSet.list().map(function (nk) { return _this.getNode(nk); }), spanningTreeEdgesSet.list());
    };
    Graph.prototype.addNodeToSpanningGraph = function (nodeKey, connectionMode, adjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc) {
        spanningTreeNodesSet.tryPush(nodeKey);
        this.getAdjacentEdges(nodeKey, connectionMode)
            .filter(function (e) { return !spanningTreeEdgesSet.contains(e); })
            .forEach(function (e) {
            var weight = edgeWeightFunc(e);
            var pos = Utils_1.Utils.binaryIndexOf(adjacentEdges, function (a) { return a.weight - weight; });
            pos = pos < 0 ? ~pos : pos;
            while (pos < adjacentEdges.length && edgeWeightFunc(adjacentEdges[pos]) === weight)
                pos++;
            adjacentEdges.splice(pos, 0, new Structures_1.Edge(e.key, e.from, e.to, weight));
        });
    };
    Graph.create = function (shapes, connectors) {
        var nodes = shapes;
        var edges = connectors
            .filter(function (i) { return i.beginItem && i.endItem instanceof Shape_1.Shape && i.endItem && i.endItem instanceof Shape_1.Shape && i.beginItem !== i.endItem; }) // TBD: ShapeItem?
            .map(function (i) { return new Structures_1.Edge(i.key, i.beginItem && i.beginItem.key, i.endItem && i.endItem.key); });
        return new Graph(nodes, edges);
    };
    return Graph;
}(GraphBase));
exports.Graph = Graph;
var FastGraph = /** @class */ (function (_super) {
    __extends(FastGraph, _super);
    function FastGraph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FastGraph.prototype.onInit = function () {
        this.parentToChildren = {};
        this.childToParents = {};
    };
    FastGraph.prototype.addEdge = function (edge) {
        _super.prototype.addEdge.call(this, edge);
        (this.parentToChildren[edge.from] || (this.parentToChildren[edge.from] = [])).push(edge.to);
        (this.childToParents[edge.to] || (this.childToParents[edge.to] = [])).push(edge.from);
    };
    FastGraph.prototype.getChildren = function (parent) {
        return this.parentToChildren[parent] || [];
    };
    FastGraph.prototype.getParents = function (child) {
        return this.childToParents[child] || [];
    };
    FastGraph.prototype.createIterator = function (connectionMode) {
        return new GraphIterator(this, connectionMode);
    };
    return FastGraph;
}(GraphBase));
exports.FastGraph = FastGraph;
var GraphIterator = /** @class */ (function () {
    function GraphIterator(graph, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        this.graph = graph;
        this.connectionMode = connectionMode;
        this.visitEachEdgeOnce = true;
        this.visitEachNodeOnce = true;
        this.visitedNodes = {};
        this.visitedEdges = {};
    }
    GraphIterator.prototype.iterate = function (nodeKey) {
        if (!this.visitEachNodeOnce && !this.visitEachEdgeOnce && !this.skipNode)
            throw "skipNode or visitEachNodeOnce or visitEachEdgeOnce must be set to avoid SOF";
        this.iterateCore(nodeKey);
    };
    GraphIterator.prototype.iterateCore = function (nodeKey) {
        var _this = this;
        var node = this.graph.getNode(nodeKey);
        if (this.skipNode && this.skipNode(node) || (this.visitEachNodeOnce && this.isNodeVisited(nodeKey)))
            return;
        this.visitedNodes[nodeKey] = true;
        this.onNode && this.onNode(node);
        var edges = this.graph.getAdjacentEdges(nodeKey, this.connectionMode);
        if (this.skipEdge)
            edges = edges.filter(function (e) { return !_this.skipEdge(e); });
        if (this.connectionMode & Structures_1.ConnectionMode.Outgoing) {
            var outgoing = edges.filter(function (e) { return e.from === nodeKey; });
            if (this.comparer)
                outgoing.sort(this.comparer);
            outgoing.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, true);
                _this.iterateCore(e.to);
                _this.onAfterEdge && _this.onAfterEdge(e, true);
            });
        }
        this.onAllEdges && this.onAllEdges(node, true);
        if (this.connectionMode & Structures_1.ConnectionMode.Incoming) {
            var incoming = edges.filter(function (e) { return e.to === nodeKey; });
            if (this.comparer)
                incoming.sort(this.comparer);
            incoming.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, false);
                _this.iterateCore(e.from);
                _this.onAfterEdge && _this.onAfterEdge(e, false);
            });
        }
        this.onAllEdges && this.onAllEdges(node, false);
    };
    GraphIterator.prototype.isNodeVisited = function (nodeKey) {
        return !!this.visitedNodes[nodeKey];
    };
    GraphIterator.prototype.isEdgeVisited = function (edgeKey) {
        return !!this.visitedEdges[edgeKey];
    };
    return GraphIterator;
}());
exports.GraphIterator = GraphIterator;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeConnectorTextHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeConnectorTextHistoryItem, _super);
    function ChangeConnectorTextHistoryItem(connector, position, text) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.text = text;
        _this.position = position;
        return _this;
    }
    ChangeConnectorTextHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldText = connector.getText(this.position);
        manipulator.changeConnectorText(connector, this.text, this.position);
    };
    ChangeConnectorTextHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorText(connector, this.oldText, this.position);
    };
    return ChangeConnectorTextHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextHistoryItem = ChangeConnectorTextHistoryItem;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeConnectorPropertyHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeConnectorPropertyHistoryItem, _super);
    function ChangeConnectorPropertyHistoryItem(connectorKey, propertyName, value) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.propertyName = propertyName;
        _this.value = value;
        return _this;
    }
    ChangeConnectorPropertyHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldValue = connector.properties[this.propertyName];
        manipulator.changeConnectorProperty(connector, this.propertyName, this.value);
    };
    ChangeConnectorPropertyHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorProperty(connector, this.propertyName, this.oldValue);
    };
    return ChangeConnectorPropertyHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorPropertyHistoryItem = ChangeConnectorPropertyHistoryItem;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var NodeInfo = /** @class */ (function () {
    function NodeInfo(key, margin, size, connectionPoints) {
        if (connectionPoints === void 0) { connectionPoints = []; }
        this.key = key;
        this.margin = margin;
        this.size = size;
        this.connectionPoints = connectionPoints;
    }
    return NodeInfo;
}());
exports.NodeInfo = NodeInfo;
var NodeLayout = /** @class */ (function () {
    function NodeLayout(info, position) {
        this.info = info;
        this.position = position;
    }
    Object.defineProperty(NodeLayout.prototype, "key", {
        get: function () { return this.info.key; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NodeLayout.prototype, "rectangle", {
        get: function () {
            return new Utils_1.Rectangle(this.position, this.info.size);
        },
        enumerable: true,
        configurable: true
    });
    return NodeLayout;
}());
exports.NodeLayout = NodeLayout;
var EdgeLayout = /** @class */ (function () {
    function EdgeLayout(key, beginIndex, endIndex) {
        this.key = key;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }
    return EdgeLayout;
}());
exports.EdgeLayout = EdgeLayout;
var Margin = /** @class */ (function () {
    function Margin(top, right, bottom, left) {
        if (right === void 0) { right = top; }
        if (bottom === void 0) { bottom = top; }
        if (left === void 0) { left = top; }
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }
    Margin.empty = function () {
        return new Margin(0);
    };
    return Margin;
}());
exports.Margin = Margin;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Exporter = /** @class */ (function () {
    function Exporter() {
    }
    Exporter.prototype.export = function (model) {
        var obj = {
            page: {},
            connectors: [],
            shapes: []
        };
        obj.page = {
            "width": model.size.width,
            "height": model.size.height,
            "pageColor": model.pageColor,
            "pageWidth": model.pageSize.width,
            "pageHeight": model.pageSize.height,
            "pageLandscape": model.pageLandscape,
            "units": model.units
        };
        this.exportItemsCore(model.items, obj);
        return JSON.stringify(obj);
    };
    Exporter.prototype.exportItems = function (items) {
        var obj = {
            connectors: [],
            shapes: []
        };
        this.exportItemsCore(items, obj);
        return JSON.stringify(obj);
    };
    Exporter.prototype.exportItemsCore = function (items, obj) {
        var _this = this;
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                obj.shapes.push(_this.exportShape(item));
            }
            else if (item instanceof Connector_1.Connector) {
                var connectorObj = _this.exportConnector(item);
                if (item.beginItem) {
                    connectorObj["beginItemKey"] = item.beginItem.key;
                    connectorObj["beginConnectionPointIndex"] = item.beginConnectionPointIndex;
                }
                if (item.endItem) {
                    connectorObj["endItemKey"] = item.endItem.key;
                    connectorObj["endConnectionPointIndex"] = item.endConnectionPointIndex;
                }
                obj.connectors.push(connectorObj);
            }
        });
    };
    Exporter.prototype.exportItem = function (item) {
        return {
            "key": item.key,
            "dataKey": item.dataKey,
            "locked": item.locked,
            "zIndex": item.zIndex
        };
    };
    Exporter.prototype.exportShape = function (shape) {
        var result = this.exportItem(shape);
        result["type"] = shape.description.key;
        result["text"] = shape.text;
        if (!shape.image.isEmpty)
            result["imageUrl"] = shape.image.exportUrl;
        result["x"] = shape.position.x;
        result["y"] = shape.position.y;
        result["width"] = shape.size.width;
        result["height"] = shape.size.height;
        var paramsObj = shape.parameters.toObject();
        if (paramsObj)
            result["parameters"] = paramsObj;
        var styleObj = shape.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = shape.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        if (shape.childKeys.length)
            result["childKeys"] = shape.childKeys.slice();
        if (!shape.expanded)
            result["expanded"] = false;
        if (shape.expandedSize) {
            result["expandedWidth"] = shape.expandedSize.width;
            result["expandedHeight"] = shape.expandedSize.height;
        }
        return result;
    };
    Exporter.prototype.exportConnector = function (connector) {
        var result = this.exportItem(connector);
        result["points"] = connector.points.map(function (p) { return { "x": p.x, "y": p.y }; });
        var textObj = connector.texts.toObject();
        if (textObj)
            result["texts"] = textObj;
        var propsObj = connector.properties.toObject();
        if (propsObj)
            result["properties"] = propsObj;
        var styleObj = connector.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = connector.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        return result;
    };
    // Images
    Exporter.prototype.exportSvg = function (modelSize, pageColor, exportManager, callback) {
        exportManager.exportSvgImage(modelSize, pageColor, callback);
    };
    Exporter.prototype.exportPng = function (modelSize, pageColor, exportManager, callback) {
        exportManager.exportPngImage(modelSize, pageColor, callback);
    };
    Exporter.prototype.exportJpg = function (modelSize, pageColor, exportManager, callback) {
        exportManager.exportJpgImage(modelSize, pageColor, callback);
    };
    return Exporter;
}());
exports.Exporter = Exporter;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StylePropertyCommandBase_1 = __webpack_require__(105);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(35);
var Style_1 = __webpack_require__(37);
var ToggleStyleTextPropertyCommand = /** @class */ (function (_super) {
    __extends(ToggleStyleTextPropertyCommand, _super);
    function ToggleStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleStyleTextPropertyCommand.prototype.getValue = function () {
        var value = this.control.selection.inputPosition.getStyleTextPropertyValue(this.getStyleProperty());
        return value === this.getStylePropertyValue();
    };
    ToggleStyleTextPropertyCommand.prototype.executeCore = function (state) {
        var _this = this;
        this.control.history.beginTransaction();
        var styleProperty = this.getStyleProperty();
        var styleValue = state.value ? Style_1.StyleText.defaultInstace[styleProperty] : this.getStylePropertyValue();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            _this.control.history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue));
        });
        this.control.selection.inputPosition.setStyleTextPropertyValue(this.getStyleProperty(), styleValue);
        this.control.history.endTransaction();
        return true;
    };
    ToggleStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    return ToggleStyleTextPropertyCommand;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ToggleStyleTextPropertyCommand = ToggleStyleTextPropertyCommand;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(7);
var SimpleCommandBase_1 = __webpack_require__(6);
var AutoLayoutCommandBase = /** @class */ (function (_super) {
    __extends(AutoLayoutCommandBase, _super);
    function AutoLayoutCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutCommandBase.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !this.control.selection.isEmpty();
    };
    AutoLayoutCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var graphInfo = ModelUtils_1.ModelUtils.getGraphInfoBySelection(this.control.model, this.control.selection);
        var settings = this.createLayoutSettings();
        graphInfo.forEach(function (info) {
            var graph = info.getNodeInfoGraph();
            var layout = _this.createLayout(settings, graph);
            ModelUtils_1.ModelUtils.applyLayout(_this.control.history, _this.control.model, info.container, graph, layout, settings, _this.control.settings.snapToGrid, _this.control.settings.gridSize);
        });
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.endTransaction();
        return true;
    };
    return AutoLayoutCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.AutoLayoutCommandBase = AutoLayoutCommandBase;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(7);
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangePagePropertyCommand = /** @class */ (function (_super) {
    __extends(ChangePagePropertyCommand, _super);
    function ChangePagePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePagePropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.createHistoryItems(parameter);
        items.forEach(function (item) { _this.control.history.addAndRedo(item); });
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.endTransaction();
        return true;
    };
    ChangePagePropertyCommand.prototype.getItems = function () {
        return null;
    };
    return ChangePagePropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangePagePropertyCommand = ChangePagePropertyCommand;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var BaseBuilder_1 = __webpack_require__(110);
var Graph_1 = __webpack_require__(53);
var NodeLayout_1 = __webpack_require__(56);
var Structures_1 = __webpack_require__(31);
var ListUtils_1 = __webpack_require__(69);
var Utils_1 = __webpack_require__(0);
var LayoutSettings_1 = __webpack_require__(21);
var GraphLayout_1 = __webpack_require__(109);
var Connector_1 = __webpack_require__(5);
var CycleRemover_1 = __webpack_require__(229);
var SugiyamaLayoutBuilder = /** @class */ (function (_super) {
    __extends(SugiyamaLayoutBuilder, _super);
    function SugiyamaLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SugiyamaLayoutBuilder.prototype.build = function () {
        var _this = this;
        var offset = 0;
        var layout = new GraphLayout_1.GraphLayout();
        var nodeOrderer = new SugiyamaNodesOrderer();
        this.graph.getConnectedComponents()
            .forEach(function (component) {
            var acyclicGraphInfo = CycleRemover_1.CycleRemover.removeCycles(component);
            var layers = SugiyamaLayerDistributor.getLayers(acyclicGraphInfo.graph);
            var orderedGraph = nodeOrderer.orderNodes(acyclicGraphInfo.graph, layers);
            var removedEdges = Object.keys(acyclicGraphInfo.removedEdges).map(function (ek) { return component.getEdge(ek); });
            var coordinatedGraph = nodeOrderer.assignAbsCoordinates(orderedGraph);
            var componentLayout = _this.createInfoGraphLayout(coordinatedGraph, acyclicGraphInfo.reversedEdges, removedEdges);
            layout.extend(_this.setComponentOffset(componentLayout, offset));
            offset += _this.getComponentOffset(componentLayout);
        });
        return layout;
    };
    // Order Nodes
    SugiyamaLayoutBuilder.prototype.createInfoGraphLayout = function (coordinatedGraph, reversedEdges, removedEdges) {
        var _this = this;
        var currentPosition = new Utils_1.Point(0, 0);
        var items = coordinatedGraph.items;
        var sortedLayers = new ListUtils_1.HashSet(items.map(function (n) { return n.layer; }).sort());
        var absOffsetInfo = this.getAbsOffsetInfo(coordinatedGraph.items);
        var positions = {};
        var totalDepth = 0;
        var leftEdge = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var rightEdge = Number.MIN_SAFE_INTEGER || Number.MAX_VALUE;
        var _loop_1 = function (i) {
            var layer = sortedLayers.item(i);
            var maxDepthLayer = 0;
            items
                .filter(function (n) { return n.layer === layer; })
                .sort(function (a, b) { return a.position - b.position; })
                .forEach(function (n) {
                var depthNodeSize = _this.getDepthNodeSize(n);
                var directionOffset = _this.chooseDirectionValue(0, depthNodeSize);
                var absPosition = _this.getAbsPosition(n.position, _this.getBreadthNodeSize(n), absOffsetInfo);
                currentPosition = _this.setBreadth(currentPosition, absPosition);
                var nodePosition = _this.setDepthOffset(currentPosition, -directionOffset);
                positions[n.key] = nodePosition;
                if (n.isDummy)
                    return;
                var breadth = _this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal ? nodePosition.y : nodePosition.x;
                leftEdge = Math.min(leftEdge, breadth);
                rightEdge = Math.max(rightEdge, breadth + _this.getBreadthNodeSize(n));
                maxDepthLayer = Math.max(maxDepthLayer, _this.getDepthNodeSize(n));
            });
            totalDepth += maxDepthLayer;
            currentPosition = this_1.setBreadth(currentPosition, 0);
            currentPosition = this_1.setDepthOffset(currentPosition, this_1.getDirectionValue(maxDepthLayer + this_1.settings.layerSpacing));
        };
        var this_1 = this;
        for (var i = 0; i < sortedLayers.length; i++) {
            _loop_1(i);
        }
        totalDepth += (sortedLayers.length - 1) * this.settings.layerSpacing;
        var layout = new GraphLayout_1.GraphLayout();
        this.createNodesLayout(coordinatedGraph, layout, leftEdge, totalDepth, positions);
        this.createEdgesLayout(coordinatedGraph, layout, reversedEdges, removedEdges);
        return layout;
        //this.getDummyEdgesRoutes(infoGraph);
    };
    SugiyamaLayoutBuilder.prototype.createNodesLayout = function (infoGraph, layout, leftEdge, totalDepth, positions) {
        var _this = this;
        var offset = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            new Utils_1.Point(-leftEdge, this.chooseDirectionValue(0, totalDepth)) :
            new Utils_1.Point(this.chooseDirectionValue(0, totalDepth), -leftEdge);
        infoGraph.items.forEach(function (n) {
            if (!n.isDummy) {
                var node = _this.graph.getNode(n.key);
                layout.addNode(new NodeLayout_1.NodeLayout(node, positions[n.key].offset(offset.x, offset.y)));
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.createEdgesLayout = function (infoGraph, layout, reversedEdges, removedEdges) {
        var DIRECT = this.getDirectEdgeLayout();
        var TOP_TO_BOTTOM = this.getDiffLevelEdgeLayout(true);
        var BOTTOM_TO_TOP = this.getDiffLevelEdgeLayout(false);
        var TOP_TO_TOP = this.getSameLevelEdgeLayout(true);
        var BOTTOM_TO_BOTTOM = this.getSameLevelEdgeLayout(false);
        var occupied = {};
        infoGraph.edges
            .filter(function (e) { return !e.isDummy; })
            .concat(removedEdges.map(function (e) { return new EdgeOnLayer(e.key, false, e.from, e.to); }))
            .sort(function (a, b) {
            return (infoGraph.getNode(a.originFrom).layer - infoGraph.getNode(b.originFrom).layer) ||
                (infoGraph.getNode(a.to).layer - infoGraph.getNode(b.to).layer);
        })
            .forEach(function (e) {
            var isReversed = reversedEdges[e.key];
            var from = infoGraph.getNode(isReversed ? e.to : e.originFrom);
            var to = infoGraph.getNode(isReversed ? e.originFrom : e.to);
            if (to.layer - from.layer === 1)
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, DIRECT.from, DIRECT.to));
            else {
                var candidates_1 = [];
                if (to.position - from.position >= 1) {
                    candidates_1.push(TOP_TO_BOTTOM);
                    candidates_1.push({ from: DIRECT.from, to: TOP_TO_BOTTOM.to });
                    candidates_1.push({ from: TOP_TO_BOTTOM.from, to: DIRECT.to });
                }
                else if (to.position - from.position <= -1) {
                    candidates_1.push(BOTTOM_TO_TOP);
                    candidates_1.push({ from: DIRECT.from, to: BOTTOM_TO_TOP.to });
                    candidates_1.push({ from: BOTTOM_TO_TOP.from, to: DIRECT.to });
                }
                else {
                    var oneliner = from.position === to.position && to.position === 0 ? [TOP_TO_TOP, BOTTOM_TO_BOTTOM] : [BOTTOM_TO_BOTTOM, TOP_TO_TOP];
                    oneliner.forEach(function (c) { return candidates_1.push(c); });
                    oneliner.forEach(function (c) {
                        candidates_1.push({ from: c.from, to: DIRECT.to });
                        candidates_1.push({ from: DIRECT.from, to: c.to });
                    });
                }
                candidates_1.push(DIRECT);
                for (var i = 0, candidate = void 0; candidate = candidates_1[i]; i++) {
                    var fromKey = from.key + "_" + candidate.from;
                    var toKey = to.key + "_" + candidate.to;
                    if (occupied[fromKey] !== Connector_1.ConnectorPosition.End && occupied[toKey] !== Connector_1.ConnectorPosition.Begin) {
                        layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, candidate.from, candidate.to));
                        occupied[fromKey] = Connector_1.ConnectorPosition.Begin;
                        occupied[toKey] = Connector_1.ConnectorPosition.End;
                        break;
                    }
                }
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.getDirectEdgeLayout = function () {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 1, to: 3 } : { from: 3, to: 1 };
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 2, to: 0 } : { from: 0, to: 2 };
    };
    SugiyamaLayoutBuilder.prototype.getDiffLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 2, to: 0 } : { from: 0, to: 2 };
        return topToBottom ? { from: 3, to: 1 } : { from: 1, to: 3 };
    };
    SugiyamaLayoutBuilder.prototype.getSameLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 0, to: 0 } : { from: 2, to: 2 };
        return topToBottom ? { from: 3, to: 3 } : { from: 1, to: 1 };
    };
    // private getDummyEdgesRoutes(infoGraph: FastGraph<NodeOnLayer, EdgeOnLayer>): {[nodeKey: string]: NodeOnLayer[]} {
    //     let resultRoutes: {[nodeKey: string]: NodeOnLayer[]} = {};
    //     let dummyEdgeRoutes: {[edgeHash: string]: NodeOnLayer[]} = {};
    //     infoGraph.edges
    //         .filter(e => !infoGraph.getNode(e.from).isDummy && infoGraph.getNode(e.to).isDummy)
    //         .forEach(rootEdge => {
    //             let edgeHash = rootEdge.getHashCode();
    //             dummyEdgeRoutes[edgeHash] = [];
    //             let iterator = infoGraph.createIterator(ConnectionMode.Outgoing);
    //             iterator.visitEachEdgeOnce = false;
    //             iterator.onNode = (n) => dummyEdgeRoutes[edgeHash].push(n);
    //             iterator.skipNode = (n) => !n.isDummy;
    //             iterator.skipEdge = (e) => false;
    //             iterator.onEdge = (e, out) => {
    //                 if(!infoGraph.getNode(e.to).isDummy)
    //                     resultRoutes[new EdgeOnLayer(e.key, e.isDummy, rootEdge.from, e.to).getHashCode()] = dummyEdgeRoutes[edgeHash];
    //             };
    //             iterator.iterate(rootEdge.to);
    //         });
    //     return resultRoutes;
    // }
    SugiyamaLayoutBuilder.prototype.getAbsOffsetInfo = function (nodesInfos) {
        var _this = this;
        var absOffsetMatrix = {};
        var addCell = function (n, intAbsCoord) {
            if (absOffsetMatrix[intAbsCoord] === undefined)
                absOffsetMatrix[intAbsCoord] = _this.getBreadthNodeSize(n);
            absOffsetMatrix[intAbsCoord] = Math.max(absOffsetMatrix[intAbsCoord], _this.getBreadthNodeSize(n));
        };
        nodesInfos.forEach(function (n) {
            var intAbsCoord = trunc(n.position);
            addCell(n, intAbsCoord);
            if (absOffsetMatrix[intAbsCoord] % 1 !== 0)
                addCell(n, intAbsCoord + 1);
        });
        var absOffsetInfo = {};
        var leftOffset = 0;
        Object.keys(absOffsetMatrix).sort().forEach(function (coord) {
            absOffsetInfo[coord] = { leftOffset: leftOffset, width: absOffsetMatrix[coord] };
            leftOffset += absOffsetMatrix[coord] + _this.settings.columnSpacing;
        });
        return absOffsetInfo;
    };
    SugiyamaLayoutBuilder.prototype.setBreadth = function (position, breadthPosition) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical)
            return new Utils_1.Point(breadthPosition, position.y);
        return new Utils_1.Point(position.x, breadthPosition);
    };
    SugiyamaLayoutBuilder.prototype.setDepthOffset = function (position, offset) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return new Utils_1.Point(position.x + offset, position.y);
        return new Utils_1.Point(position.x, position.y + offset);
    };
    SugiyamaLayoutBuilder.prototype.getAbsPosition = function (absCoordinate, itemSize, absoluteOffsetInfo) {
        var intAbsCoord = trunc(absCoordinate);
        var absLeftOffset = absoluteOffsetInfo[intAbsCoord].leftOffset;
        var cellWidth = absoluteOffsetInfo[intAbsCoord].width;
        if (absCoordinate % 1 === 0)
            return absLeftOffset + (cellWidth - itemSize) / 2;
        return absLeftOffset + cellWidth - (itemSize - this.settings.columnSpacing) / 2;
    };
    SugiyamaLayoutBuilder.prototype.getBreadthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getBreadthNodeSizeCore(this.graph.getNode(node.key));
    };
    SugiyamaLayoutBuilder.prototype.getDepthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getDepthNodeSizeCore(this.graph.getNode(node.key));
    };
    return SugiyamaLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.SugiyamaLayoutBuilder = SugiyamaLayoutBuilder;
var SugiyamaLayerDistributor = /** @class */ (function () {
    function SugiyamaLayerDistributor() {
    }
    SugiyamaLayerDistributor.getLayers = function (acyclicGraph) {
        var feasibleTree = this.getFeasibleTree(acyclicGraph);
        return this.calcNodesLayers(feasibleTree);
    };
    SugiyamaLayerDistributor.getFeasibleTree = function (graph) {
        var layers = this.initLayerAssignment(graph);
        return graph.getSpanningGraph(graph.nodes[0], Structures_1.ConnectionMode.OutgoingAndIncoming, function (e) { return layers[e.to] - layers[e.from]; });
    };
    SugiyamaLayerDistributor.initLayerAssignment = function (graph) {
        var layers = {};
        var currentLayer = 0;
        var actualAssignedNodes = {};
        var assigningNodes = graph.nodes.filter(function (n) { return !graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).length; });
        var _loop_2 = function () {
            assigningNodes.forEach(function (n) {
                layers[n] = currentLayer;
                actualAssignedNodes[n] = true;
            });
            Object.keys(actualAssignedNodes).forEach(function (n) {
                if (graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing).filter(function (e) { return layers[e.to] === undefined; }).length === 0)
                    delete actualAssignedNodes[n];
            });
            var assigningNodesSet = {};
            Object.keys(actualAssignedNodes).forEach(function (n) {
                graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing)
                    .map(function (e) { return e.to; })
                    .filter(function (n) { return layers[n] === undefined && graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).reduce(function (acc, e) { return acc && layers[e.from] !== undefined; }, true); })
                    .forEach(function (n) { return assigningNodesSet[n] = true; });
            });
            assigningNodes = Object.keys(assigningNodesSet);
            currentLayer++;
        };
        while (assigningNodes.length) {
            _loop_2();
        }
        return layers;
    };
    SugiyamaLayerDistributor.calcNodesLayers = function (graph) {
        var layers = {};
        var minLayer = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var currentLevel = 0;
        var iterator = graph.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            layers[n.key] = currentLevel;
            minLayer = Math.min(minLayer, currentLevel);
        };
        iterator.skipNode = function (n) { return layers[n.key] !== undefined; };
        iterator.skipEdge = function (e) { return layers[e.from] !== undefined && layers[e.to] !== undefined; };
        iterator.onEdge = function (e, out) {
            if (out)
                currentLevel = layers[e.from] + 1;
            else
                currentLevel = layers[e.to] - 1;
        };
        iterator.iterate(graph.nodes[0]);
        for (var key in layers) {
            if (!layers.hasOwnProperty(key))
                continue;
            layers[key] -= minLayer;
        }
        return layers;
    };
    return SugiyamaLayerDistributor;
}());
exports.SugiyamaLayerDistributor = SugiyamaLayerDistributor;
var SugiyamaNodesOrderer = /** @class */ (function () {
    function SugiyamaNodesOrderer() {
        this.idCounter = -10000;
    }
    SugiyamaNodesOrderer.prototype.orderNodes = function (graph, layers) {
        var maxIteration = 14; //magic number - http://www.graphviz.org/Documentation/TSE93.pdf PAGE (14)
        var currentIteration = 1;
        var graphInfo = this.initGraphInfo(graph, layers);
        var nodeInfos = graphInfo.items;
        var orderInfo = this.initOrder(nodeInfos);
        var bestNodesPositions = this.getNodeToPositionMap(nodeInfos);
        var bestCrossCount = this.getCrossCount(orderInfo, graphInfo);
        var isParentToChildren = true;
        while (currentIteration < maxIteration && bestCrossCount != 0) {
            orderInfo = this.getNodesOrder(orderInfo, graphInfo, isParentToChildren);
            var crossCount = this.getCrossCount(orderInfo, graphInfo);
            if (crossCount < bestCrossCount) {
                bestNodesPositions = this.getNodeToPositionMap(graphInfo.items);
                bestCrossCount = crossCount;
            }
            isParentToChildren = !isParentToChildren;
            currentIteration++;
        }
        //transpose() procedure doesn`t implement.
        //http://www.graphviz.org/Documentation/TSE93.pdf PAGE(16)
        graphInfo.items.forEach(function (n) { return n.position = bestNodesPositions[n.key]; });
        return graphInfo;
    };
    SugiyamaNodesOrderer.prototype.getNodesOrder = function (current, graph, isParentToChildren) {
        var _this = this;
        var order = {};
        var _loop_3 = function (layer) {
            if (!current.hasOwnProperty(layer))
                return "continue";
            var nodePositions = {};
            current[layer].forEach(function (ni) {
                var adjacentNodesPositions = (isParentToChildren ? graph.getChildren(ni.key) : graph.getParents(ni.key))
                    .map(function (nk) { return graph.getNode(nk).position; });
                nodePositions[ni.key] = _this.getNodePosition(adjacentNodesPositions);
            });
            order[layer] = this_2.sortNodes(nodePositions, graph);
        };
        var this_2 = this;
        for (var layer in current) {
            _loop_3(layer);
        }
        return order;
    };
    SugiyamaNodesOrderer.prototype.sortNodes = function (nodePositions, graph) {
        return Object.keys(nodePositions)
            .sort(function (a, b) { return nodePositions[a] - nodePositions[b]; })
            .map(function (nk, index) {
            var node = graph.getNode(nk);
            node.position = index;
            return node;
        });
    };
    SugiyamaNodesOrderer.prototype.getNodePosition = function (adjacentNodesPositions) {
        adjacentNodesPositions = adjacentNodesPositions.sort();
        if (!adjacentNodesPositions.length)
            return 0;
        var medianIndex = Math.floor(adjacentNodesPositions.length / 2);
        if (adjacentNodesPositions.length === 2 || adjacentNodesPositions.length % 2 === 1)
            return adjacentNodesPositions[medianIndex];
        var leftMedianPosition = adjacentNodesPositions[medianIndex - 1] - adjacentNodesPositions[0];
        var rightMedianPosition = adjacentNodesPositions[adjacentNodesPositions.length - 1] - adjacentNodesPositions[medianIndex];
        return Math.floor((adjacentNodesPositions[medianIndex - 1] * rightMedianPosition + adjacentNodesPositions[medianIndex] * leftMedianPosition) /
            (leftMedianPosition + rightMedianPosition));
    };
    SugiyamaNodesOrderer.prototype.initOrder = function (nodeInfos) {
        var result = {};
        nodeInfos.forEach(function (ni) { return (result[ni.layer] || (result[ni.layer] = [])).push(ni); });
        return result;
    };
    SugiyamaNodesOrderer.prototype.getCrossCount = function (orderInfo, graph) {
        var count = 0;
        var _loop_4 = function (layer) {
            if (!orderInfo.hasOwnProperty(layer))
                return "continue";
            var viewedAdjacentNodesPositions = [];
            orderInfo[layer].forEach(function (n) {
                var positions = graph.getChildren(n.key).map(function (c) { return graph.getNode(c).position; });
                positions.forEach(function (p) {
                    count += viewedAdjacentNodesPositions.filter(function (vp) { return p < vp; }).length;
                });
                viewedAdjacentNodesPositions.push.apply(viewedAdjacentNodesPositions, positions);
            });
        };
        for (var layer in orderInfo) {
            _loop_4(layer);
        }
        return count;
    };
    SugiyamaNodesOrderer.prototype.initGraphInfo = function (graph, layers) {
        var _this = this;
        var countNodesOnLayer = {};
        var nodesInfoMap = {};
        var nodeInfos = [];
        var edgeInfos = [];
        graph.nodes.forEach(function (n) {
            var layer = layers[n];
            if (countNodesOnLayer[layer] === undefined)
                countNodesOnLayer[layer] = 0;
            var info = new NodeOnLayer(n, false, layer, countNodesOnLayer[layer]++);
            nodesInfoMap[n] = info;
            nodeInfos.push(info);
        });
        graph.edges.forEach(function (e) {
            var span = layers[e.to] - layers[e.from];
            if (span > 1) {
                var prevNodeInfo = nodesInfoMap[e.from];
                for (var delta = 1; delta < span; delta++) {
                    var dNodeInfo = new NodeOnLayer(_this.createDummyID(), true, layers[e.from] + delta, countNodesOnLayer[layers[e.from] + delta]++);
                    edgeInfos.push(new EdgeOnLayer(_this.createDummyID(), true, prevNodeInfo.key, dNodeInfo.key));
                    nodeInfos.push(dNodeInfo);
                    prevNodeInfo = dNodeInfo;
                }
                edgeInfos.push(new EdgeOnLayer(e.key, false, prevNodeInfo.key, nodesInfoMap[e.to].key, nodesInfoMap[e.from].key));
            }
            else
                edgeInfos.push(new EdgeOnLayer(e.key, false, nodesInfoMap[e.from].key, nodesInfoMap[e.to].key));
        });
        return new Graph_1.FastGraph(nodeInfos, edgeInfos);
    };
    SugiyamaNodesOrderer.prototype.createDummyID = function () {
        return "dummy_" + --this.idCounter;
    };
    SugiyamaNodesOrderer.prototype.getNodeToPositionMap = function (nodeInfos) {
        return nodeInfos.reduce(function (acc, ni) {
            acc[ni.key] = ni.position;
            return acc;
        }, {});
    };
    // absolute positioning
    SugiyamaNodesOrderer.prototype.assignAbsCoordinates = function (graph) {
        var absCoordinates = this.getAbsCoodinate(graph);
        return new Graph_1.FastGraph(graph.items.map(function (n) { return new NodeOnLayer(n.key, n.isDummy, n.layer, absCoordinates[n.key]); }), graph.edges.slice(0));
    };
    SugiyamaNodesOrderer.prototype.getAbsCoodinate = function (graph) {
        var _this = this;
        var orderInfo = graph.items.reduce(function (acc, n) {
            acc[n.layer] = acc[n.layer] || [];
            var pos = Utils_1.Utils.binaryIndexOf(acc[n.layer], function (ni) { return ni.position - n.position; });
            acc[n.layer].splice(pos < 0 ? ~pos : pos, 0, n);
            return acc;
        }, {});
        var medianPositions = [MedianAlignmentMode.TopLeft, MedianAlignmentMode.TopRight, MedianAlignmentMode.BottomLeft, MedianAlignmentMode.BottomRight]
            .map(function (alignment) { return _this.getPositionByMedian(graph, alignment, orderInfo); });
        var nodeToPosition = {};
        graph.items.forEach(function (n) {
            var posList = medianPositions.map(function (positions) { return positions[n.key]; }).sort();
            nodeToPosition[n.key] = (posList[1] + posList[2]) / 2;
        });
        return nodeToPosition;
    };
    SugiyamaNodesOrderer.prototype.getPositionByMedian = function (graph, alignment, orderInfo) {
        var nodeInfos = graph.items;
        var positions = this.getNodeToPositionMap(nodeInfos);
        var medians = this.getMedians(graph, nodeInfos, alignment);
        medians = this.resolveMedianConflicts(graph, orderInfo, medians, alignment);
        this.getSortedBlocks(graph, nodeInfos, medians, alignment)
            .forEach(function (block) {
            var maxPos = block.reduce(function (acc, n) { return positions[n.key] > acc ? positions[n.key] : acc; }, -2);
            block.forEach(function (n) {
                var delta = maxPos - positions[n.key];
                if (delta > 0) {
                    orderInfo[n.layer]
                        .filter(function (ln) { return ln.position > n.position; })
                        .forEach(function (ln) { return positions[ln.key] += delta; });
                }
                positions[n.key] = maxPos;
            });
        });
        return positions;
    };
    SugiyamaNodesOrderer.prototype.getSortedBlocks = function (graph, nodeInfos, medians, alignment) {
        var blocks = [];
        var isBottom = alignment === MedianAlignmentMode.BottomLeft || alignment === MedianAlignmentMode.BottomRight;
        var allNodesInfo = new ListUtils_1.HashSet(nodeInfos.slice(0).sort(function (a, b) { return isBottom ? (a.layer - b.layer) : (b.layer - a.layer); }), function (n) { return n.key; });
        while (allNodesInfo.length) {
            var firstNode = allNodesInfo.item(0);
            var block = this.getBlock(graph, firstNode, medians, alignment);
            blocks.push(block);
            block.forEach(function (n) { return allNodesInfo.remove(n); });
        }
        blocks.sort(function (x, y) {
            var xMinNodeInfo = x.reduce(function (min, n) { return n.position < min.position ? n : min; }, x[0]);
            var yOnMinXLayer = y.filter(function (n) { return n.layer == xMinNodeInfo.layer; })[0];
            if (yOnMinXLayer)
                return xMinNodeInfo.position - yOnMinXLayer.position;
            var yMinNodeInfo = y.reduce(function (min, n) { return n.position < min.position ? n : min; }, y[0]);
            var xOnMinXLayer = x.filter(function (n) { return n.layer == yMinNodeInfo.layer; })[0];
            if (xOnMinXLayer)
                return xOnMinXLayer.position - yMinNodeInfo.position;
            return xMinNodeInfo.layer - yMinNodeInfo.layer;
        });
        return blocks;
    };
    SugiyamaNodesOrderer.prototype.getBlock = function (graph, root, medians, alignment) {
        var block = [];
        var median = null;
        do {
            if (median)
                root = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? graph.getNode(median.from) : graph.getNode(median.to);
            block.push(root);
            median = medians[root.key];
        } while (median);
        return block;
    };
    SugiyamaNodesOrderer.prototype.resolveMedianConflicts = function (graph, layers, medians, alignment) {
        var _this = this;
        var filteredMedians = {};
        var _loop_5 = function (layer) {
            var minPos = undefined, maxPos = undefined;
            if (!layers.hasOwnProperty(layer))
                return "continue";
            var nodeInfos = layers[layer];
            if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
                nodeInfos = nodeInfos.slice(0).sort(function (a, b) { return b.position - a.position; }); // sorted descending
            nodeInfos.forEach(function (n) {
                var median = medians[n.key];
                if (!median)
                    filteredMedians[n.key] = null;
                else {
                    var medianItemKey = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? median.from : median.to;
                    var medianPosition = graph.getNode(medianItemKey).position;
                    if (_this.checkMedianConfict(minPos, maxPos, medianPosition, alignment))
                        filteredMedians[n.key] = null;
                    else {
                        minPos = minPos === undefined ? medianPosition : Math.min(minPos, medianPosition);
                        maxPos = maxPos === undefined ? medianPosition : Math.max(maxPos, medianPosition);
                        filteredMedians[n.key] = median;
                    }
                }
            });
        };
        for (var layer in layers) {
            _loop_5(layer);
        }
        return filteredMedians;
    };
    SugiyamaNodesOrderer.prototype.checkMedianConfict = function (min, max, medianPosition, alignment) {
        if (min === undefined || max === undefined)
            return false;
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return max >= medianPosition;
        return min <= medianPosition;
    };
    SugiyamaNodesOrderer.prototype.getMedians = function (graph, nodeInfos, alignment) {
        var _this = this;
        var medians = {};
        nodeInfos.forEach(function (n) {
            var actualAdjacentEdges = _this.getActualAdjacentEdges(graph, n, alignment);
            var medianPosition = _this.getMedianPosition(actualAdjacentEdges.length, alignment);
            medians[n.key] = actualAdjacentEdges[medianPosition];
        });
        return medians;
    };
    SugiyamaNodesOrderer.prototype.getMedianPosition = function (length, alignment) {
        if (length === 0)
            return -1;
        if (length % 2 !== 0)
            return Math.floor(length / 2);
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return Math.floor(length / 2) - 1;
        if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
            return Math.floor(length / 2);
        throw new Error("Invalid Operation");
    };
    SugiyamaNodesOrderer.prototype.getActualAdjacentEdges = function (graph, node, alignment) {
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight)
            return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Incoming).sort(function (a, b) { return graph.getNode(a.from).position - graph.getNode(b.from).position; });
        return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Outgoing).sort(function (a, b) { return graph.getNode(a.to).position - graph.getNode(b.to).position; });
    };
    return SugiyamaNodesOrderer;
}());
exports.SugiyamaNodesOrderer = SugiyamaNodesOrderer;
var NodeOnLayer = /** @class */ (function () {
    function NodeOnLayer(key, isDummy, layer, position) {
        this.key = key;
        this.isDummy = isDummy;
        this.layer = layer;
        this.position = position;
    }
    NodeOnLayer.prototype.getHashCode = function () {
        return this.key.toString();
    };
    return NodeOnLayer;
}());
exports.NodeOnLayer = NodeOnLayer;
var EdgeOnLayer = /** @class */ (function () {
    function EdgeOnLayer(key, isDummy, from, to, originFrom) {
        this.key = key;
        this.isDummy = isDummy;
        this.from = from;
        this.to = to;
        this._originFrom = originFrom;
    }
    EdgeOnLayer.prototype.getHashCode = function () {
        return this.from + "-" + this.to;
    };
    Object.defineProperty(EdgeOnLayer.prototype, "originFrom", {
        get: function () {
            return this._originFrom !== undefined ? this._originFrom : this.from;
        },
        enumerable: true,
        configurable: true
    });
    return EdgeOnLayer;
}());
exports.EdgeOnLayer = EdgeOnLayer;
var MedianAlignmentMode;
(function (MedianAlignmentMode) {
    MedianAlignmentMode[MedianAlignmentMode["TopLeft"] = 0] = "TopLeft";
    MedianAlignmentMode[MedianAlignmentMode["TopRight"] = 1] = "TopRight";
    MedianAlignmentMode[MedianAlignmentMode["BottomLeft"] = 2] = "BottomLeft";
    MedianAlignmentMode[MedianAlignmentMode["BottomRight"] = 3] = "BottomRight";
})(MedianAlignmentMode || (MedianAlignmentMode = {}));
function trunc(val) {
    if (Math.trunc)
        return Math.trunc(val);
    if (!isFinite(val))
        return val;
    return (val - val % 1) || (val < 0 ? -0 : val === 0 ? val : 0);
}


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DeleteCommand_1 = __webpack_require__(121);
var UndoCommand_1 = __webpack_require__(193);
var RedoCommand_1 = __webpack_require__(194);
var ImportCommand_1 = __webpack_require__(195);
var ExportCommand_1 = __webpack_require__(196);
var ToggleFontBoldCommand_1 = __webpack_require__(197);
var ToggleFontItalicCommand_1 = __webpack_require__(198);
var ToggleFontUnderlineCommand_1 = __webpack_require__(199);
var ChangeFontNameCommand_1 = __webpack_require__(200);
var ChangeFontSizeCommand_1 = __webpack_require__(201);
var ChangeFontColorCommand_1 = __webpack_require__(202);
var ChangeFillColorCommand_1 = __webpack_require__(203);
var ChangeStrokeColorCommand_1 = __webpack_require__(204);
var ChangeTextAlignCommand_1 = __webpack_require__(205);
var ChangeConnectorLineEndingCommand_1 = __webpack_require__(206);
var ChangeConnectorLineOptionCommand_1 = __webpack_require__(207);
var SelectAllCommand_1 = __webpack_require__(208);
var KeyCode_1 = __webpack_require__(16);
var AutoLayoutTreeVerticalCommand_1 = __webpack_require__(209);
var ChangeSnapToGridCommand_1 = __webpack_require__(212);
var ChangeGridSizeCommand_1 = __webpack_require__(213);
var ChangePageLandscapeCommand_1 = __webpack_require__(214);
var ChangePageSizeCommand_1 = __webpack_require__(216);
var ExportPngCommand_1 = __webpack_require__(218);
var ExportSvgCommand_1 = __webpack_require__(220);
var ExportJpgCommand_1 = __webpack_require__(221);
var CopySelectionCommand_1 = __webpack_require__(222);
var CutSelectionCommand_1 = __webpack_require__(223);
var PasteSelectionCommand_1 = __webpack_require__(224);
var ImportBPMNCommand_1 = __webpack_require__(227);
var SendToBackCommand_1 = __webpack_require__(230);
var BringToFrontCommand_1 = __webpack_require__(231);
var AutoLayoutLayeredHorizontalCommand_1 = __webpack_require__(232);
var MoveCommands_1 = __webpack_require__(233);
var ChangeZoomLevelCommand_1 = __webpack_require__(234);
var BindDocumentCommand_1 = __webpack_require__(235);
var UnbindDocumentCommand_1 = __webpack_require__(237);
var AutoLayoutTreeHorizontalCommand_1 = __webpack_require__(238);
var AutoLayoutLayeredVerticalCommand_1 = __webpack_require__(239);
var LockCommand_1 = __webpack_require__(240);
var UnlockCommand_1 = __webpack_require__(241);
var CloneCommand_1 = __webpack_require__(242);
var ChangeUnitsCommand_1 = __webpack_require__(243);
var ChangePageColorCommand_1 = __webpack_require__(245);
var ChangeShowGridCommand_1 = __webpack_require__(247);
var ToggleFullscreenCommand_1 = __webpack_require__(248);
var ToggleSimpleViewCommand_1 = __webpack_require__(249);
var ToggleReadOnlyCommand_1 = __webpack_require__(250);
var EditShapeImageCommand_1 = __webpack_require__(251);
var PasteSelectionInPosition_1 = __webpack_require__(252);
var ImportXMLCommand_1 = __webpack_require__(253);
var InsertShapeImageCommand_1 = __webpack_require__(255);
var DeleteShapeImageCommand_1 = __webpack_require__(256);
var DiagramCommand;
(function (DiagramCommand) {
    DiagramCommand[DiagramCommand["Undo"] = 0] = "Undo";
    DiagramCommand[DiagramCommand["Redo"] = 1] = "Redo";
    DiagramCommand[DiagramCommand["Cut"] = 2] = "Cut";
    DiagramCommand[DiagramCommand["Copy"] = 3] = "Copy";
    DiagramCommand[DiagramCommand["Paste"] = 4] = "Paste";
    DiagramCommand[DiagramCommand["PasteInPosition"] = 5] = "PasteInPosition";
    DiagramCommand[DiagramCommand["SelectAll"] = 6] = "SelectAll";
    DiagramCommand[DiagramCommand["Delete"] = 7] = "Delete";
    DiagramCommand[DiagramCommand["Import"] = 8] = "Import";
    DiagramCommand[DiagramCommand["ImportBPMN"] = 9] = "ImportBPMN";
    DiagramCommand[DiagramCommand["Export"] = 10] = "Export";
    DiagramCommand[DiagramCommand["ExportSvg"] = 11] = "ExportSvg";
    DiagramCommand[DiagramCommand["ExportPng"] = 12] = "ExportPng";
    DiagramCommand[DiagramCommand["ExportJpg"] = 13] = "ExportJpg";
    DiagramCommand[DiagramCommand["BindDocument"] = 14] = "BindDocument";
    DiagramCommand[DiagramCommand["UnbindDocument"] = 15] = "UnbindDocument";
    DiagramCommand[DiagramCommand["Bold"] = 16] = "Bold";
    DiagramCommand[DiagramCommand["Italic"] = 17] = "Italic";
    DiagramCommand[DiagramCommand["Underline"] = 18] = "Underline";
    DiagramCommand[DiagramCommand["FontName"] = 19] = "FontName";
    DiagramCommand[DiagramCommand["FontSize"] = 20] = "FontSize";
    DiagramCommand[DiagramCommand["FontColor"] = 21] = "FontColor";
    DiagramCommand[DiagramCommand["FillColor"] = 22] = "FillColor";
    DiagramCommand[DiagramCommand["StrokeColor"] = 23] = "StrokeColor";
    DiagramCommand[DiagramCommand["TextLeftAlign"] = 24] = "TextLeftAlign";
    DiagramCommand[DiagramCommand["TextCenterAlign"] = 25] = "TextCenterAlign";
    DiagramCommand[DiagramCommand["TextRightAlign"] = 26] = "TextRightAlign";
    DiagramCommand[DiagramCommand["ConnectorLineOption"] = 27] = "ConnectorLineOption";
    DiagramCommand[DiagramCommand["ConnectorStartLineEnding"] = 28] = "ConnectorStartLineEnding";
    DiagramCommand[DiagramCommand["ConnectorEndLineEnding"] = 29] = "ConnectorEndLineEnding";
    DiagramCommand[DiagramCommand["BringToFront"] = 30] = "BringToFront";
    DiagramCommand[DiagramCommand["SendToBack"] = 31] = "SendToBack";
    DiagramCommand[DiagramCommand["MoveLeft"] = 32] = "MoveLeft";
    DiagramCommand[DiagramCommand["MoveStepLeft"] = 33] = "MoveStepLeft";
    DiagramCommand[DiagramCommand["MoveRight"] = 34] = "MoveRight";
    DiagramCommand[DiagramCommand["MoveStepRight"] = 35] = "MoveStepRight";
    DiagramCommand[DiagramCommand["MoveUp"] = 36] = "MoveUp";
    DiagramCommand[DiagramCommand["MoveStepUp"] = 37] = "MoveStepUp";
    DiagramCommand[DiagramCommand["MoveDown"] = 38] = "MoveDown";
    DiagramCommand[DiagramCommand["MoveStepDown"] = 39] = "MoveStepDown";
    DiagramCommand[DiagramCommand["CloneLeft"] = 40] = "CloneLeft";
    DiagramCommand[DiagramCommand["CloneRight"] = 41] = "CloneRight";
    DiagramCommand[DiagramCommand["CloneUp"] = 42] = "CloneUp";
    DiagramCommand[DiagramCommand["CloneDown"] = 43] = "CloneDown";
    DiagramCommand[DiagramCommand["AutoLayoutTree"] = 44] = "AutoLayoutTree";
    DiagramCommand[DiagramCommand["AutoLayoutFlow"] = 45] = "AutoLayoutFlow";
    DiagramCommand[DiagramCommand["AutoLayoutTreeVertical"] = 46] = "AutoLayoutTreeVertical";
    DiagramCommand[DiagramCommand["AutoLayoutTreeHorizontal"] = 47] = "AutoLayoutTreeHorizontal";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredVertical"] = 48] = "AutoLayoutLayeredVertical";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredHorizontal"] = 49] = "AutoLayoutLayeredHorizontal";
    DiagramCommand[DiagramCommand["Lock"] = 50] = "Lock";
    DiagramCommand[DiagramCommand["Unlock"] = 51] = "Unlock";
    DiagramCommand[DiagramCommand["Units"] = 52] = "Units";
    DiagramCommand[DiagramCommand["ViewUnits"] = 53] = "ViewUnits";
    DiagramCommand[DiagramCommand["PageSize"] = 54] = "PageSize";
    DiagramCommand[DiagramCommand["PageLandscape"] = 55] = "PageLandscape";
    DiagramCommand[DiagramCommand["PageColor"] = 56] = "PageColor";
    DiagramCommand[DiagramCommand["GridSize"] = 57] = "GridSize";
    DiagramCommand[DiagramCommand["ShowGrid"] = 58] = "ShowGrid";
    DiagramCommand[DiagramCommand["SnapToGrid"] = 59] = "SnapToGrid";
    DiagramCommand[DiagramCommand["ZoomLevel"] = 60] = "ZoomLevel";
    DiagramCommand[DiagramCommand["Fullscreen"] = 61] = "Fullscreen";
    DiagramCommand[DiagramCommand["ToggleSimpleView"] = 62] = "ToggleSimpleView";
    DiagramCommand[DiagramCommand["ToggleReadOnly"] = 63] = "ToggleReadOnly";
    DiagramCommand[DiagramCommand["EditShapeImage"] = 64] = "EditShapeImage";
    DiagramCommand[DiagramCommand["FitToScreen"] = 65] = "FitToScreen";
    DiagramCommand[DiagramCommand["SwitchAutoZoom"] = 66] = "SwitchAutoZoom";
    DiagramCommand[DiagramCommand["ToggleAutoZoom"] = 67] = "ToggleAutoZoom";
    DiagramCommand[DiagramCommand["FitToWidth"] = 68] = "FitToWidth";
    DiagramCommand[DiagramCommand["ZoomLevelItems"] = 69] = "ZoomLevelItems";
    DiagramCommand[DiagramCommand["GridSizeItems"] = 70] = "GridSizeItems";
    DiagramCommand[DiagramCommand["PageSizeItems"] = 71] = "PageSizeItems";
    DiagramCommand[DiagramCommand["ImportXML"] = 72] = "ImportXML";
    DiagramCommand[DiagramCommand["InsertShapeImage"] = 73] = "InsertShapeImage";
    DiagramCommand[DiagramCommand["DeleteShapeImage"] = 74] = "DeleteShapeImage";
})(DiagramCommand = exports.DiagramCommand || (exports.DiagramCommand = {}));
var CommandManager = /** @class */ (function () {
    function CommandManager(control) {
        this.commands = {};
        this.shortcutsToCommand = {};
        this.lastCommandsChain = [];
        this.executingCommandsChain = [];
        this.executingCommandCounter = 0;
        this.isPublicApiCall = false;
        this.createCommand(control, DiagramCommand.Undo, UndoCommand_1.UndoCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_z, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Redo, RedoCommand_1.RedoCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_y, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Key_z, KeyCode_1.ModifierKey.Meta | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Cut, CutSelectionCommand_1.CutSelectionCommand, KeyCode_1.KeyCode.Key_x | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_x | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Copy, CopySelectionCommand_1.CopySelectionCommand, KeyCode_1.KeyCode.Key_c | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_c | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Paste, PasteSelectionCommand_1.PasteSelectionCommand);
        this.createCommand(control, DiagramCommand.PasteInPosition, PasteSelectionInPosition_1.PasteSelectionInPositionCommand);
        this.createCommand(control, DiagramCommand.SelectAll, SelectAllCommand_1.SelectAllCommand, KeyCode_1.KeyCode.Key_a | KeyCode_1.ModifierKey.Ctrl, KeyCode_1.KeyCode.Key_a | KeyCode_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Delete, DeleteCommand_1.DeleteCommand, KeyCode_1.KeyCode.Delete, KeyCode_1.KeyCode.Backspace);
        this.createCommand(control, DiagramCommand.Import, ImportCommand_1.ImportCommand);
        this.createCommand(control, DiagramCommand.ImportBPMN, ImportBPMNCommand_1.ImportBPMNCommand);
        this.createCommand(control, DiagramCommand.ImportXML, ImportXMLCommand_1.ImportXMLCommand);
        this.createCommand(control, DiagramCommand.Export, ExportCommand_1.ExportCommand);
        this.createCommand(control, DiagramCommand.ExportSvg, ExportSvgCommand_1.ExportSvgCommand);
        this.createCommand(control, DiagramCommand.ExportPng, ExportPngCommand_1.ExportPngCommand);
        this.createCommand(control, DiagramCommand.ExportJpg, ExportJpgCommand_1.ExportJpgCommand);
        this.createCommand(control, DiagramCommand.BindDocument, BindDocumentCommand_1.BindDocumentCommand);
        this.createCommand(control, DiagramCommand.UnbindDocument, UnbindDocumentCommand_1.UnbindDocumentCommand);
        this.createCommand(control, DiagramCommand.Bold, ToggleFontBoldCommand_1.ToggleFontBoldCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_b, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_b);
        this.createCommand(control, DiagramCommand.Italic, ToggleFontItalicCommand_1.ToggleFontItalicCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_i, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_i);
        this.createCommand(control, DiagramCommand.Underline, ToggleFontUnderlineCommand_1.ToggleFontUnderlineCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.KeyCode.Key_u, KeyCode_1.ModifierKey.Meta | KeyCode_1.KeyCode.Key_u);
        this.createCommand(control, DiagramCommand.FontName, ChangeFontNameCommand_1.ChangeFontNameCommand);
        this.createCommand(control, DiagramCommand.FontSize, ChangeFontSizeCommand_1.ChangeFontSizeCommand);
        this.createCommand(control, DiagramCommand.FontColor, ChangeFontColorCommand_1.ChangeFontColorCommand);
        this.createCommand(control, DiagramCommand.FillColor, ChangeFillColorCommand_1.ChangeFillColorCommand);
        this.createCommand(control, DiagramCommand.StrokeColor, ChangeStrokeColorCommand_1.ChangeStrokeColorCommand);
        this.createCommand(control, DiagramCommand.TextLeftAlign, ChangeTextAlignCommand_1.TextLeftAlignCommand);
        this.createCommand(control, DiagramCommand.TextCenterAlign, ChangeTextAlignCommand_1.TextCenterAlignCommand);
        this.createCommand(control, DiagramCommand.TextRightAlign, ChangeTextAlignCommand_1.TextRightAlignCommand);
        this.createCommand(control, DiagramCommand.ConnectorLineOption, ChangeConnectorLineOptionCommand_1.ChangeConnectorLineOptionCommand);
        this.createCommand(control, DiagramCommand.ConnectorStartLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorStartLineEndingCommand);
        this.createCommand(control, DiagramCommand.ConnectorEndLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorEndLineEndingCommand);
        this.createCommand(control, DiagramCommand.BringToFront, BringToFrontCommand_1.BringToFrontCommand);
        this.createCommand(control, DiagramCommand.SendToBack, SendToBackCommand_1.SendToBackCommand);
        this.createCommand(control, DiagramCommand.MoveLeft, MoveCommands_1.MoveLeftCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveStepLeft, MoveCommands_1.MoveStepLeftCommand, KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveRight, MoveCommands_1.MoveRightCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveStepRight, MoveCommands_1.MoveStepRightCommand, KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveUp, MoveCommands_1.MoveUpCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveStepUp, MoveCommands_1.MoveStepUpCommand, KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveDown, MoveCommands_1.MoveDownCommand, KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.MoveStepDown, MoveCommands_1.MoveStepDownCommand, KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.CloneLeft, CloneCommand_1.CloneLeftCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.CloneRight, CloneCommand_1.CloneRightCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.CloneUp, CloneCommand_1.CloneUpCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.CloneDown, CloneCommand_1.CloneDownCommand, KeyCode_1.ModifierKey.Ctrl | KeyCode_1.ModifierKey.Shift | KeyCode_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.Lock, LockCommand_1.LockCommand);
        this.createCommand(control, DiagramCommand.Unlock, UnlockCommand_1.UnLockCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTree, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand); // TODO: remove after, need for BC
        this.createCommand(control, DiagramCommand.AutoLayoutFlow, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand); // TODO: remove after, need for BC
        this.createCommand(control, DiagramCommand.Units, ChangeUnitsCommand_1.ChangeUnitsCommand);
        this.createCommand(control, DiagramCommand.ViewUnits, ChangeUnitsCommand_1.ChangeViewUnitsCommand);
        this.createCommand(control, DiagramCommand.PageSize, ChangePageSizeCommand_1.ChangePageSizeCommand);
        this.createCommand(control, DiagramCommand.PageLandscape, ChangePageLandscapeCommand_1.ChangePageLandscapeCommand);
        this.createCommand(control, DiagramCommand.PageColor, ChangePageColorCommand_1.ChangePageColorCommand);
        this.createCommand(control, DiagramCommand.GridSize, ChangeGridSizeCommand_1.ChangeGridSizeCommand);
        this.createCommand(control, DiagramCommand.ShowGrid, ChangeShowGridCommand_1.ChangeShowGridCommand);
        this.createCommand(control, DiagramCommand.SnapToGrid, ChangeSnapToGridCommand_1.ChangeSnapToGridCommand);
        this.createCommand(control, DiagramCommand.ZoomLevel, ChangeZoomLevelCommand_1.ChangeZoomLevelCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeVertical, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeHorizontal, AutoLayoutTreeHorizontalCommand_1.AutoLayoutTreeHorizontalCommand); // Not Implemented
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredVertical, AutoLayoutLayeredVerticalCommand_1.AutoLayoutLayeredVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredHorizontal, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand);
        this.createCommand(control, DiagramCommand.Fullscreen, ToggleFullscreenCommand_1.ToggleFullscreenCommand, KeyCode_1.KeyCode.F11);
        this.createCommand(control, DiagramCommand.ToggleSimpleView, ToggleSimpleViewCommand_1.ToggleSimpleViewCommand);
        this.createCommand(control, DiagramCommand.ToggleReadOnly, ToggleReadOnlyCommand_1.ToggleReadOnlyCommand);
        this.createCommand(control, DiagramCommand.InsertShapeImage, InsertShapeImageCommand_1.InsertShapeImageCommand);
        this.createCommand(control, DiagramCommand.EditShapeImage, EditShapeImageCommand_1.EditShapeImageCommand);
        this.createCommand(control, DiagramCommand.DeleteShapeImage, DeleteShapeImageCommand_1.DeleteShapeImageCommand);
        this.createCommand(control, DiagramCommand.FitToScreen, ChangeZoomLevelCommand_1.FitToScreenCommand);
        this.createCommand(control, DiagramCommand.FitToWidth, ChangeZoomLevelCommand_1.FitToWidthCommand);
        this.createCommand(control, DiagramCommand.SwitchAutoZoom, ChangeZoomLevelCommand_1.SwitchAutoZoomCommand);
        this.createCommand(control, DiagramCommand.ToggleAutoZoom, ChangeZoomLevelCommand_1.ToggleAutoZoomCommand);
        this.createCommand(control, DiagramCommand.ZoomLevelItems, ChangeZoomLevelCommand_1.ChangeZoomLevelItemsCommand);
        this.createCommand(control, DiagramCommand.GridSizeItems, ChangeGridSizeCommand_1.ChangeGridSizeItemsCommand);
        this.createCommand(control, DiagramCommand.PageSizeItems, ChangePageSizeCommand_1.ChangePageSizeItemsCommand);
    }
    CommandManager.prototype.getCommand = function (key) {
        return this.commands[key];
    };
    CommandManager.prototype.beforeExecuting = function (command) {
        this.executingCommandsChain.push(command);
        this.executingCommandCounter++;
    };
    CommandManager.prototype.afterExecuting = function () {
        this.executingCommandCounter--;
        if (this.executingCommandCounter === 0) {
            this.lastCommandsChain = this.executingCommandsChain;
            this.executingCommandsChain = [];
        }
    };
    CommandManager.prototype.assertLastExecutedCommandsChain = function (checkLength) {
        var types = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            types[_i - 1] = arguments[_i];
        }
        if (checkLength && this.lastCommandsChain.length !== types.length)
            return false;
        for (var i = 0, type; type = types[i]; i++) {
            if (!this.lastCommandsChain[i] || !(this.lastCommandsChain[i] instanceof type))
                return false;
        }
        return true;
    };
    CommandManager.prototype.processShortcut = function (code) {
        var command = this.shortcutsToCommand[code];
        if (command)
            return command.execute();
        return false;
    };
    CommandManager.prototype.processPaste = function (clipboardData) {
        var command = this.getCommand(DiagramCommand.Paste);
        if (command)
            command.performPaste(clipboardData);
        return true;
    };
    // ISelectionChangesListener
    CommandManager.prototype.notifySelectionChanged = function (_selection) {
        this.lastCommandsChain = [];
    };
    CommandManager.prototype.notifyScrollPositionChanged = function () { };
    CommandManager.prototype.createCommand = function (control, commandId, commandType) {
        var shortcuts = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            shortcuts[_i - 3] = arguments[_i];
        }
        this.commands[commandId] = new commandType(control);
        for (var i = 0; i < shortcuts.length; i++) {
            var shortcut = shortcuts[i];
            if (typeof shortcut === "number")
                this.shortcutsToCommand[shortcut] = this.commands[commandId];
        }
    };
    return CommandManager;
}());
exports.CommandManager = CommandManager;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var Utils_1 = __webpack_require__(15);
var TextPrimitive = /** @class */ (function (_super) {
    __extends(TextPrimitive, _super);
    function TextPrimitive(x, y, text, width, style, reverseTextAhchor, clipPathId, filterId, rotated, onApplyProperties) {
        var _this = _super.call(this, style, "", clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.text = text;
        _this.width = width;
        _this.reverseTextAhchor = reverseTextAhchor;
        _this.rotated = rotated;
        _this.filterId = filterId;
        _this.textSegmens = _this.text.split("\n").filter(function (s) { return s; });
        return _this;
    }
    TextPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "text");
    };
    TextPrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        if (this.filterId)
            element.setAttribute("filter", "url(#" + this.filterId + ")");
        _super.prototype.applyElementProperties.call(this, element);
        this.applyElementText(element);
        if (this.rotated) {
            element.setAttribute("class", "rotated");
            element.style.setProperty("transform-origin", (typeof this.x === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(this.x) + "px" : this.x) + " " +
                (typeof this.y === "number" ? UnitConverter_1.UnitConverter.twipsToPixels(this.y) + "px" : this.y));
        }
    };
    TextPrimitive.prototype.applyElementText = function (element) {
        var _this = this;
        Utils_1.RenderUtils.removeContent(element);
        var lineCount = 0;
        this.textSegmens.forEach(function (txt, index) {
            var tspan = _this.createTSpanElement(element);
            lineCount++;
            if (_this.width) {
                var words = txt.split(" ");
                var line = "", prevLine = "";
                for (var i = 0; i < words.length; i++) {
                    line += (line.length ? " " : "") + words[i];
                    tspan.textContent = line;
                    var lineWidth = Utils_1.RenderUtils.getSvgTextRectangle(element).width;
                    if (lineWidth >= _this.width && prevLine !== "") {
                        tspan.textContent = prevLine;
                        prevLine = line = words[i];
                        tspan = _this.createTSpanElement(element);
                        tspan.textContent = line;
                        lineCount++;
                    }
                    else {
                        prevLine = line;
                    }
                }
            }
            else {
                tspan.textContent = txt;
            }
        });
        var firstTSpan = element.firstChild;
        if (firstTSpan) {
            var dy = -((lineCount - 1) / 2) + TextPrimitive.baselineCorrection;
            firstTSpan.setAttribute("dy", dy.toFixed(2) + "em");
        }
    };
    TextPrimitive.prototype.createTSpanElement = function (parent) {
        var tspan = document.createElementNS(RenderManager_1.svgNS, "tspan");
        parent.appendChild(tspan);
        this.setUnitAttribute(tspan, "x", this.x);
        tspan.setAttribute("dy", "1.05em");
        return tspan;
    };
    TextPrimitive.prototype.applyElementStyleProperties = function (element) {
        this.applyElementStylePropertiesCore(element, this.reverseTextAhchor);
    };
    TextPrimitive.baselineCorrection = 0.35;
    return TextPrimitive;
}(Primitive_1.SvgPrimitive));
exports.TextPrimitive = TextPrimitive;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(28);
var DiagramItem_1 = __webpack_require__(4);
exports.ArrowVerticalTriangleHeightParameterName = "th";
exports.ArrowVerticalLineWidthParameterName = "lw";
var ArrowVerticalShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowVerticalShapeDescription, _super);
    function ArrowVerticalShapeDescription(title) {
        return _super.call(this, title, "", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.375, ShapeDescription_1.ShapeDefaultDimension)) || this;
    }
    ArrowVerticalShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalTriangleHeightParameterName, Math.sqrt(Math.pow(this.defaultSize.width, 2) - Math.pow(this.defaultSize.width / 2, 2))),
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalLineWidthParameterName, this.defaultSize.width / 3)
        ]);
    };
    ArrowVerticalShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.ArrowVerticalTriangleHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
        this.changeParameterValue(parameters, exports.ArrowVerticalLineWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
    };
    ArrowVerticalShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var delta = (shape.size.width - shape.parameters.get(exports.ArrowVerticalLineWidthParameterName).value) / 2;
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= delta;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += delta;
    };
    return ArrowVerticalShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ArrowVerticalShapeDescription = ArrowVerticalShapeDescription;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(28);
var DiagramItem_1 = __webpack_require__(4);
exports.ArrowVerticalTriangleWidthParameterName = "tw";
exports.ArrowVerticalLineHeightParameterName = "lh";
var ArrowHorizontalShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowHorizontalShapeDescription, _super);
    function ArrowHorizontalShapeDescription(title) {
        return _super.call(this, title, "", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.375)) || this;
    }
    ArrowHorizontalShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalTriangleWidthParameterName, Math.sqrt(Math.pow(this.defaultSize.height, 2) - Math.pow(this.defaultSize.height / 2, 2))),
            new ShapeParameters_1.ShapeParameter(exports.ArrowVerticalLineHeightParameterName, this.defaultSize.height / 3)
        ]);
    };
    ArrowHorizontalShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.ArrowVerticalTriangleWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
        this.changeParameterValue(parameters, exports.ArrowVerticalLineHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    ArrowHorizontalShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var delta = (shape.size.height - shape.parameters.get(exports.ArrowVerticalLineHeightParameterName).value) / 2;
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += delta;
        else if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= delta;
    };
    return ArrowHorizontalShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ArrowHorizontalShapeDescription = ArrowHorizontalShapeDescription;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var EllipsePrimitive_1 = __webpack_require__(29);
var ShapeTypes_1 = __webpack_require__(1);
var EllipseShapeDescription = /** @class */ (function (_super) {
    __extends(EllipseShapeDescription, _super);
    function EllipseShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Ellipse"; }
        if (defaultText === void 0) { defaultText = ""; }
        return _super.call(this, title, defaultText, new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75)) || this;
    }
    Object.defineProperty(EllipseShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Ellipse; },
        enumerable: true,
        configurable: true
    });
    EllipseShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var width = rect.width, height = rect.height;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        return [
            new EllipsePrimitive_1.EllipsePrimitive(cx, cy, width / 2, height / 2, shape.style),
        ];
    };
    return EllipseShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.EllipseShapeDescription = EllipseShapeDescription;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var PolygonShapeDescription = /** @class */ (function (_super) {
    __extends(PolygonShapeDescription, _super);
    function PolygonShapeDescription(title, defaultText) {
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultSize.height = _this.calculateHeight(ShapeDescription_1.ShapeDefaultDimension);
        return _this;
    }
    Object.defineProperty(PolygonShapeDescription.prototype, "angle", {
        get: function () {
            return Math.PI * (this.angleCount - 2) / this.angleCount;
        },
        enumerable: true,
        configurable: true
    });
    return PolygonShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.PolygonShapeDescription = PolygonShapeDescription;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeWithImageDescription_1 = __webpack_require__(45);
var RoundedRectanglePrimitive_1 = __webpack_require__(183);
var __1 = __webpack_require__(10);
var PathPrimitive_1 = __webpack_require__(2);
var GroupPrimitive_1 = __webpack_require__(22);
var CardBaseDescription = /** @class */ (function (_super) {
    __extends(CardBaseDescription, _super);
    function CardBaseDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Card Base"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, 26 / 46 * ShapeDescription_1.ShapeDefaultDimension); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    CardBaseDescription.getTextMargins = function () {
        return ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins();
    };
    CardBaseDescription.prototype.createShapePrimitives = function (shape, forToolbox) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
        return [
            new RoundedRectanglePrimitive_1.RoundedRectanglePrimitive(left, top, width, height, (forToolbox) ? 30 : 60, (forToolbox) ? 30 : 60, shape.style)
        ];
    };
    CardBaseDescription.prototype.createImagePlaceholder = function (rect) {
        return [
            new RoundedRectanglePrimitive_1.RoundedRectanglePrimitive(rect.left, rect.top, rect.width, rect.height, __1.UnitConverter.pixelsToTwips(2), __1.UnitConverter.pixelsToTwips(2), undefined, ShapeWithImageDescription_1.SHAPE_IMAGE_CLASSNAMES.IMAGE_PLACEHOLDER)
        ];
    };
    CardBaseDescription.prototype.getTextRectangle = function (rect) {
        var textRectangle = rect.clone();
        var textBlockOffset = this.getTextBlockOffset(rect);
        if (textBlockOffset.left > 0)
            textRectangle.position.x = textRectangle.left + textBlockOffset.left + CardBaseDescription.getTextMargins();
        if (textBlockOffset.top > 0)
            textRectangle.position.y = textRectangle.top + textBlockOffset.top + CardBaseDescription.getTextMargins();
        textRectangle.size.width = textRectangle.width - textBlockOffset.right - textBlockOffset.left - CardBaseDescription.getTextMargins() * 2;
        textRectangle.size.height = textRectangle.height - textBlockOffset.bottom - textBlockOffset.top - CardBaseDescription.getTextMargins() * 2;
        textRectangle.position.x += CardBaseDescription.getTextMargins();
        textRectangle.position.y += CardBaseDescription.getTextMargins();
        if (textBlockOffset.left > 0 || textBlockOffset.right > 0)
            textRectangle.size.width = Math.max(textRectangle.width - CardBaseDescription.getTextMargins(), 0);
        if (textBlockOffset.top > 0 || textBlockOffset.bottom > 0)
            textRectangle.size.height = Math.max(textRectangle.height - CardBaseDescription.getTextMargins(), 0);
        return textRectangle;
    };
    CardBaseDescription.prototype.createTextPrimitives = function (shape, forToolbox) {
        if (forToolbox)
            return this.createGraphicalTextRepresentation(shape.rectangle);
        else
            return _super.prototype.createTextPrimitives.call(this, shape, forToolbox);
    };
    CardBaseDescription.prototype.createGraphicalTextRepresentation = function (rect) {
        var textRect = Utils_1.Rectangle.create(0, 0, 0, 0);
        var textBlockOffset = this.getTextBlockOffset(rect, true);
        if (textBlockOffset.left > 0 || textBlockOffset.right > 0) {
            var horizontalShift = (textBlockOffset.left > 0) ? rect.width / 2 : 0;
            textRect.position.x = rect.left + horizontalShift + 1.5 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
            textRect.position.y = rect.top + 2.5 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
            textRect.size.width = (textBlockOffset.left || textBlockOffset.right) - 2 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
            textRect.size.height = rect.height - 4 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
        }
        else {
            var verticalShift = (textBlockOffset.top > 0) ? rect.height / 2 : 0;
            textRect.position.x = rect.left + rect.width / 2 - (rect.width / 2 + 1) / 2;
            textRect.position.y = rect.top + verticalShift + 1.5 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
            textRect.size.width = rect.width / 2 + 1;
            textRect.size.height = (textBlockOffset.top || textBlockOffset.bottom) - 2 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(true);
        }
        return this.createTextRepresentationPrimitives(textRect);
    };
    CardBaseDescription.prototype.createTextRepresentationPrimitives = function (rect) {
        var lineHeight = __1.UnitConverter.pixelsToTwips(__1.UnitConverter.twipsToPixels(rect.height / 3));
        return [
            new GroupPrimitive_1.GroupPrimitive([
                new PathPrimitive_1.PathPrimitive([
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.left, rect.top),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(rect.left + rect.width, rect.top)
                ]),
                new PathPrimitive_1.PathPrimitive([
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.left, rect.top + lineHeight),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(rect.left + rect.width, rect.top + lineHeight)
                ]),
                new PathPrimitive_1.PathPrimitive([
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.left, rect.top + lineHeight * 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(rect.left + rect.width * 0.66, rect.top + lineHeight * 2)
                ])
            ], "dxdi-shape-text")
        ];
    };
    return CardBaseDescription;
}(ShapeWithImageDescription_1.ShapeWithImageDescription));
exports.CardBaseDescription = CardBaseDescription;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var HashSet = /** @class */ (function () {
    function HashSet(list, getHashCode) {
        if (list === void 0) { list = []; }
        if (getHashCode === void 0) { getHashCode = function (item) { return item.toString(); }; }
        var _this = this;
        this.items = [];
        this.map = {};
        this.getHashCode = getHashCode;
        list.forEach(function (i) { return _this.tryPush(i); });
    }
    HashSet.prototype.tryPush = function (item) {
        var code = this.getHashCode(item);
        if (this.map[code] === undefined) {
            this.map[code] = this.items.push(item) - 1;
            return true;
        }
        return false;
    };
    HashSet.prototype.contains = function (item) {
        return this.map[this.getHashCode(item)] !== undefined;
    };
    HashSet.prototype.forEach = function (callback) {
        this.items.forEach(callback);
    };
    HashSet.prototype.filter = function (predicate) {
        return this.items.filter(predicate);
    };
    HashSet.prototype.list = function () {
        return this.items.slice(0);
    };
    HashSet.prototype.item = function (index) {
        return this.items[index];
    };
    HashSet.prototype.first = function () {
        return this.items[0];
    };
    HashSet.prototype.remove = function (item) {
        var code = this.getHashCode(item);
        var index = this.map[code];
        if (typeof index === "number") {
            delete this.map[code];
            this.items.splice(index, 1);
            for (var i = index; i < this.items.length; i++)
                this.map[this.getHashCode(this.items[i])]--;
        }
        else
            throw "Item not found";
    };
    Object.defineProperty(HashSet.prototype, "length", {
        get: function () { return this.items.length; },
        enumerable: true,
        configurable: true
    });
    return HashSet;
}());
exports.HashSet = HashSet;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ImportUtils = /** @class */ (function () {
    function ImportUtils() {
    }
    ImportUtils.parseJSON = function (json) {
        if (!json || json === "")
            return {};
        try {
            return JSON.parse(json);
        }
        catch (_a) {
            return {};
        }
    };
    ImportUtils.createDocument = function (xml) {
        var parser = new DOMParser();
        return parser.parseFromString(xml, "application/xml");
    };
    return ImportUtils;
}());
exports.ImportUtils = ImportUtils;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommandBase_1 = __webpack_require__(106);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(35);
var ChangeStyleTextPropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeStyleTextPropertyCommand, _super);
    function ChangeStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStyleTextPropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getStyleTextPropertyValue(this.getStyleProperty());
    };
    ChangeStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    ChangeStyleTextPropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStyleTextPropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setStyleTextPropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStyleTextPropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStyleTextPropertyCommand = ChangeStyleTextPropertyCommand;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Forest_1 = __webpack_require__(210);
var GraphLayout_1 = __webpack_require__(109);
var NodeLayout_1 = __webpack_require__(56);
var Utils_1 = __webpack_require__(0);
var BaseBuilder_1 = __webpack_require__(110);
var Structures_1 = __webpack_require__(31);
var DiagramItem_1 = __webpack_require__(4);
var LayoutSettings_1 = __webpack_require__(21);
var TreeLayoutBuilder = /** @class */ (function (_super) {
    __extends(TreeLayoutBuilder, _super);
    function TreeLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TreeLayoutBuilder.prototype.build = function () {
        var forest = Forest_1.Forest.create(this.graph);
        var layouts = [];
        for (var tree = void 0, i = 0; tree = forest.trees[i]; i++) {
            var layout_1 = this.processTree(tree);
            layouts.push(layout_1);
        }
        var offset = 0, layout = new GraphLayout_1.GraphLayout();
        for (var layoutComponent = void 0, i = 0; layoutComponent = layouts[i]; i++) {
            layout.extend(this.setComponentOffset(layoutComponent, offset));
            offset += this.getComponentOffset(layoutComponent);
        }
        return layout;
    };
    TreeLayoutBuilder.prototype.processTree = function (tree) {
        var layout = new GraphLayout_1.GraphLayout();
        var rootLayout = new NodeLayout_1.NodeLayout(tree.root, new Utils_1.Point(tree.root.margin.left, tree.root.margin.top));
        layout.addNode(rootLayout);
        this.processChildren(rootLayout, tree, layout, 0);
        if (this.settings.alignment === LayoutSettings_1.Alignment.Center)
            this.processParents(layout, rootLayout, tree);
        return layout;
    };
    TreeLayoutBuilder.prototype.processChildren = function (parent, tree, layout, nearbyPoint) {
        var _this = this;
        var children = tree.getChildren(parent.info);
        var edges = this.graph.getAdjacentEdges(parent.key, Structures_1.ConnectionMode.Outgoing);
        var distantPoint = nearbyPoint;
        var prevSiblingLayout;
        var _loop_1 = function (child, i) {
            var nearbyMargin = this_1.isVertical() ? child.margin.left : child.margin.top;
            if (prevSiblingLayout) {
                var prevSiblingDistantPoint = this_1.getChangingCoordinateForLayer(prevSiblingLayout.position) + this_1.getSizeMeasurement(prevSiblingLayout.info.size);
                var actualNearbyMargin = distantPoint - prevSiblingDistantPoint;
                nearbyMargin = Math.max(0, nearbyMargin - actualNearbyMargin);
                nearbyMargin += this_1.settings.columnSpacing;
            }
            var layerStartingPoint = this_1.isVertical() ? Math.max(parent.info.margin.bottom, child.margin.top) : Math.max(parent.info.margin.right, child.margin.left);
            var nodePosition = this_1.isVertical() ?
                new Utils_1.Point(distantPoint + nearbyMargin, parent.position.y + parent.info.size.height + layerStartingPoint + this_1.settings.layerSpacing) :
                new Utils_1.Point(parent.position.x + parent.info.size.width + layerStartingPoint + this_1.settings.layerSpacing, distantPoint + nearbyMargin);
            var childLayout = new NodeLayout_1.NodeLayout(child, nodePosition);
            distantPoint = Math.max(this_1.getChangingCoordinateForLayer(childLayout.position) + this_1.getSizeMeasurement(childLayout.info.size), this_1.processChildren(childLayout, tree, layout, distantPoint));
            layout.addNode(childLayout);
            edges.filter(function (e) { return e.to === child.key; }).forEach(function (e) {
                var beginIndex = _this.isVertical() ? DiagramItem_1.ConnectionPointSide.South : DiagramItem_1.ConnectionPointSide.East;
                var endIndex = _this.isVertical() ? DiagramItem_1.ConnectionPointSide.North : DiagramItem_1.ConnectionPointSide.West;
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, beginIndex, endIndex));
            });
            prevSiblingLayout = childLayout;
        };
        var this_1 = this;
        for (var child = void 0, i = 0; child = children[i]; i++) {
            _loop_1(child, i);
        }
        return distantPoint + this.settings.subTreeColumnSpacing;
    };
    TreeLayoutBuilder.prototype.processParents = function (layout, parent, tree, parentNextSibling) {
        var children = tree.getChildren(parent.info);
        for (var child = void 0, i = children.length - 1; child = children[i]; i--)
            this.processParents(layout, layout.nodeToLayout[child.key], tree, children[i + 1]);
        if (children.length) {
            var nearbyPoint = this.getChangingCoordinateForLayer(layout.nodeToLayout[children[0].key].position);
            var distantPoint = this.getRectangleDistantEdge(layout.nodeToLayout[children[children.length - 1].key].rectangle);
            var position = nearbyPoint + (distantPoint - nearbyPoint) / 2 - this.getSizeMeasurement(parent.info.size) / 2;
            position = Math.max(this.getChangingCoordinateForLayer(parent.position), this.correctByMargin(position, parent, parentNextSibling && layout.nodeToLayout[parentNextSibling.key]));
            if (this.isVertical())
                parent.position.x = position;
            else
                parent.position.y = position;
        }
    };
    TreeLayoutBuilder.prototype.getChangingCoordinateForLayer = function (point) {
        return this.isVertical() ? point.x : point.y;
    };
    TreeLayoutBuilder.prototype.getRectangleDistantEdge = function (rectangle) {
        return this.isVertical() ? rectangle.right : rectangle.bottom;
    };
    TreeLayoutBuilder.prototype.getSizeMeasurement = function (size) {
        return this.isVertical() ? size.width : size.height;
    };
    TreeLayoutBuilder.prototype.correctByMargin = function (position, element, distant) {
        if (distant) {
            var distantPoint = this.isVertical() ? Math.max(distant.info.margin.left, element.info.margin.right) : Math.max(distant.info.margin.top, element.info.margin.bottom);
            position = Math.min(position, this.getChangingCoordinateForLayer(distant.position) - distantPoint - this.getSizeMeasurement(element.info.size));
        }
        return position;
    };
    TreeLayoutBuilder.prototype.isVertical = function () {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical;
    };
    return TreeLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.TreeLayoutBuilder = TreeLayoutBuilder;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CanvasItemsManager_1 = __webpack_require__(39);
var RenderManager_1 = __webpack_require__(11);
var CanvasExportManager_1 = __webpack_require__(219);
var ExportImportCommandBase_1 = __webpack_require__(47);
var Exporter_1 = __webpack_require__(57);
var ExportImageCommand = /** @class */ (function (_super) {
    __extends(ExportImageCommand, _super);
    function ExportImageCommand(control) {
        var _this = _super.call(this, control) || this;
        _this.exporter = new Exporter_1.Exporter();
        return _this;
    }
    ExportImageCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        try {
            var exportManager = this.getExportManager();
            var exportFunc = this.getExportFunc();
            exportFunc(this.control.model.size.clone(), this.control.model.pageColor, exportManager, function (url) {
                parameter(url, _this.getExtension());
                _this.tryDispose();
            });
        }
        catch (e) {
            this.tryDispose();
            throw e;
        }
        return true;
    };
    ExportImageCommand.prototype.getExportManager = function () {
        var itemsManager = (this.control.render && this.control.render.items) || this.createItemsManager();
        return this.exportManager || (this.exportManager = new CanvasExportManager_1.CanvasExportManager(itemsManager.itemsContainer));
    };
    ExportImageCommand.prototype.createItemsManager = function () {
        this.svgElement = RenderManager_1.RenderManager.createSvgElement(document.body, true);
        var canvasManager = new CanvasItemsManager_1.CanvasItemsManager(this.svgElement, 1);
        this.control.modelManipulator.onModelChanged.add(canvasManager);
        this.control.modelManipulator.onLoad();
        return canvasManager;
    };
    ExportImageCommand.prototype.tryDispose = function () {
        if (this.svgElement) {
            document.body.removeChild(this.svgElement);
            delete this.svgElement;
            this.exportManager = undefined;
        }
    };
    return ExportImageCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ExportImageCommand = ExportImageCommand;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var ClipboardCommand = /** @class */ (function (_super) {
    __extends(ClipboardCommand, _super);
    function ClipboardCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClipboardCommand.prototype.setClipboardData = function (data) {
        if (this.control.render)
            this.control.render.input.setClipboardData(data);
        else
            ClipboardCommand.clipboardData = data;
    };
    ClipboardCommand.prototype.getClipboardData = function (callback) {
        if (this.control.render)
            this.control.render.input.getClipboardData(callback);
        else
            callback(ClipboardCommand.clipboardData);
    };
    return ClipboardCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ClipboardCommand = ClipboardCommand;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeZindexHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeZindexHistoryItem, _super);
    function ChangeZindexHistoryItem(item, zIndex) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.zIndex = zIndex;
        return _this;
    }
    ChangeZindexHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldZIndex = item.zIndex;
        manipulator.changeZIndex(item, this.zIndex);
    };
    ChangeZindexHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeZIndex(item, this.oldZIndex);
    };
    return ChangeZindexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeZindexHistoryItem = ChangeZindexHistoryItem;


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeShapeImageHistoryItem_1 = __webpack_require__(114);
var SimpleCommandBase_1 = __webpack_require__(6);
var EditShapeImageCommandBase = /** @class */ (function (_super) {
    __extends(EditShapeImageCommandBase, _super);
    function EditShapeImageCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EditShapeImageCommandBase.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && selectedShape && !selectedShape.locked && selectedShape.enableImage && selectedShape.allowEditImage;
    };
    EditShapeImageCommandBase.prototype.getValue = function () {
        var selectedShape = this.getSelectedShape();
        var imageUrl = (selectedShape) ? selectedShape.image.exportUrl : undefined;
        return imageUrl;
    };
    EditShapeImageCommandBase.prototype.getSelectedShape = function () {
        var selectedShapes = this.control.selection.getSelectedShapes(true);
        return (selectedShapes.length === 1) ? selectedShapes[0] : undefined;
    };
    EditShapeImageCommandBase.prototype.executeCore = function (state, parameter) {
        this.control.history.beginTransaction();
        var selectedUnlockedShapes = this.control.selection.getSelectedShapes(false);
        this.control.history.addAndRedo(new ChangeShapeImageHistoryItem_1.ChangeShapeImageHistoryItem(selectedUnlockedShapes[0], parameter));
        this.control.history.endTransaction();
        return true;
    };
    return EditShapeImageCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.EditShapeImageCommandBase = EditShapeImageCommandBase;


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(7);
var MouseHandlerMoveShapeStateBase_1 = __webpack_require__(117);
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerMoveClonedShapeState = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveClonedShapeState, _super);
    function MouseHandlerMoveClonedShapeState(handler, history, model, selection, moveStartPoint) {
        var _this = _super.call(this, handler, history, model, selection) || this;
        _this.model = model;
        _this.selection = selection;
        _this.moveStartPoint = moveStartPoint;
        return _this;
    }
    MouseHandlerMoveClonedShapeState.prototype.onMouseDown = function (evt) {
        var dx = this.moveStartPoint ? evt.layoutPoint.x - this.moveStartPoint.x : 0;
        var dy = this.moveStartPoint ? evt.layoutPoint.y - this.moveStartPoint.y : 0;
        ModelUtils_1.ModelUtils.cloneSelectionToOffset(this.history, this.model, this.selection, dx, dy);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveClonedShapeState.isMoveClonedShapeEvent = function (evt) {
        return evt.modifiers & KeyCode_1.ModifierKey.Ctrl && evt.modifiers & KeyCode_1.ModifierKey.Shift;
    };
    return MouseHandlerMoveClonedShapeState;
}(MouseHandlerMoveShapeStateBase_1.MouseHandlerMoveShapeStateBase));
exports.MouseHandlerMoveClonedShapeState = MouseHandlerMoveClonedShapeState;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectionPointInfo = /** @class */ (function () {
    function ConnectionPointInfo(point, side) {
        this.point = point;
        this.side = side;
    }
    return ConnectionPointInfo;
}());
exports.ConnectionPointInfo = ConnectionPointInfo;
var ConnectionPointsVisualizerBase = /** @class */ (function () {
    function ConnectionPointsVisualizerBase(dispatcher) {
        this.dispatcher = dispatcher;
    }
    ConnectionPointsVisualizerBase.prototype.getKey = function () {
        return this.key;
    };
    ConnectionPointsVisualizerBase.prototype.setPoints = function (key, points, pointIndex) {
        if (this.key !== key || this.pointIndex !== pointIndex) {
            this.key = key;
            this.points = points;
            this.pointIndex = pointIndex;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizerBase.prototype.setPointIndex = function (pointIndex) {
        if (0 <= pointIndex && pointIndex < this.points.length && this.pointIndex !== pointIndex) {
            this.pointIndex = pointIndex;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizerBase.prototype.update = function () {
        this.raiseShow();
    };
    ConnectionPointsVisualizerBase.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.points = [];
            this.pointIndex = -1;
            this.raiseHide();
        }
    };
    return ConnectionPointsVisualizerBase;
}());
exports.ConnectionPointsVisualizerBase = ConnectionPointsVisualizerBase;


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var COLOR_PROPERTIES = { "stroke": true, "fill": true };
function isColorProperty(propName) {
    return COLOR_PROPERTIES[propName];
}
exports.isColorProperty = isColorProperty;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var LinePrimitive = /** @class */ (function (_super) {
    __extends(LinePrimitive, _super);
    function LinePrimitive(x1, y1, x2, y2, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        return _this;
    }
    LinePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "line");
    };
    LinePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x1", this.x1);
        this.setUnitAttribute(element, "y1", this.y1);
        this.setUnitAttribute(element, "x2", this.x2);
        this.setUnitAttribute(element, "y2", this.y2);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return LinePrimitive;
}(Primitive_1.SvgPrimitive));
exports.LinePrimitive = LinePrimitive;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(24);
var Base_1 = __webpack_require__(19);
var TouchUIHelper = /** @class */ (function () {
    function TouchUIHelper() {
    }
    TouchUIHelper.onEventAttachingToDocument = function (eventName, func) {
        if (Browser_1.Browser.MacOSMobilePlatform && TouchUIHelper.isTouchEventName(eventName)) {
            if (!TouchUIHelper.documentTouchHandlers[eventName])
                TouchUIHelper.documentTouchHandlers[eventName] = [];
            TouchUIHelper.documentTouchHandlers[eventName].push(func);
            return TouchUIHelper.documentEventAttachingAllowed;
        }
        return true;
    };
    TouchUIHelper.isTouchEventName = function (eventName) {
        return Browser_1.Browser.WebKitTouchUI && (eventName.indexOf("touch") > -1 || eventName.indexOf("gesture") > -1);
    };
    TouchUIHelper.isTouchEvent = function (evt) {
        if (!evt)
            return false;
        return Browser_1.Browser.WebKitTouchUI && Base_1.IsExists(evt.changedTouches);
    };
    TouchUIHelper.getEventX = function (evt) {
        return Browser_1.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
    };
    TouchUIHelper.getEventY = function (evt) {
        return Browser_1.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
    };
    TouchUIHelper.touchMouseDownEventName = Browser_1.Browser.WebKitTouchUI ? "touchstart" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerdown" : "mousedown");
    TouchUIHelper.touchMouseUpEventName = Browser_1.Browser.WebKitTouchUI ? "touchend" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerup" : "mouseup");
    TouchUIHelper.touchMouseMoveEventName = Browser_1.Browser.WebKitTouchUI ? "touchmove" : (Browser_1.Browser.Edge && Browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointermove" : "mousemove");
    TouchUIHelper.msTouchDraggableClassName = "dxMSTouchDraggable";
    TouchUIHelper.documentTouchHandlers = {};
    TouchUIHelper.documentEventAttachingAllowed = true;
    return TouchUIHelper;
}());
exports.TouchUIHelper = TouchUIHelper;
//export class TouchUIHelper {
//    isGesture: false;
//    isMouseEventFromScrolling: false;
//    isNativeScrollingAllowed: true;
//    clickSensetivity: 10;
//    documentTouchHandlers: {};
//    documentEventAttachingAllowed: true;
//    isTouchEvent(evt) {
//        if (!evt)
//            return false;
//        return ASPx.Browser.WebKitTouchUI && ASPx.IsExists(evt.changedTouches);
//    }
//    getEventX(evt) {
//        return ASPx.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
//    }
//    getEventY (evt) {
//        return ASPx.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
//    }
//    getWebkitMajorVersion() {
//        if (!this.webkitMajorVersion) {
//            var regExp = new RegExp("applewebkit/(\\d+)", "i");
//            var matches = regExp.exec(ASPx.Browser.UserAgent);
//            if (matches && matches.index >= 1)
//                this.webkitMajorVersion = matches[1];
//        }
//        return this.webkitMajorVersion;
//    }
//    getIsLandscapeOrientation() {
//        if (ASPx.Browser.MacOSMobilePlatform || ASPx.Browser.AndroidMobilePlatform)
//            return Math.abs(window.orientation) == 90;
//        return ASPx.GetDocumentClientWidth() > ASPx.GetDocumentClientHeight();
//    }
//    nativeScrollingSupported() {
//        var allowedSafariVersion = ASPx.Browser.Version >= 5.1 && ASPx.Browser.Version < 8; //T250059
//        var allowedWebKitVersion = this.getWebkitMajorVersion() > 533 && (ASPx.Browser.Chrome || this.getWebkitMajorVersion() < 600);
//        return (ASPx.Browser.MacOSMobilePlatform && (allowedSafariVersion || allowedWebKitVersion))
//            || (ASPx.Browser.AndroidMobilePlatform && ASPx.Browser.PlaformMajorVersion >= 3) || (ASPx.Browser.MSTouchUI && (!ASPx.Browser.WindowsPhonePlatform || !ASPx.Browser.IE));
//    }
//    makeScrollableIfRequired(element, options) {
//        if (ASPx.Browser.WebKitTouchUI && element) {
//            var overflow = ASPx.GetCurrentStyle(element).overflow;
//            if (element.tagName == "DIV" && overflow != "hidden" && overflow != "visible") {
//                return this.MakeScrollable(element);
//            }
//        }
//    }
//    preventScrollOnEvent(evt) {
//    }
//    handleFastTapIfRequired(evt, action, preventCommonClickEvents) {
//        if (ASPx.Browser.WebKitTouchUI && evt.type == 'touchstart' && action) {
//            this.FastTapHelper.HandleFastTap(evt, action, preventCommonClickEvents);
//            return true;
//        }
//        return false;
//    }
//    ensureDocumentSizesCorrect () {
//        return (document.documentElement.clientWidth - document.documentElement.clientHeight) / (screen.width - screen.height) > 0;
//    }
//    ensureOrientationChanged(onOrientationChangedFunction) {
//        if (ASPxClientUtils.iOSPlatform || this.ensureDocumentSizesCorrect())
//            onOrientationChangedFunction();
//        else {
//            window.setTimeout(function () {
//                this.ensureOrientationChanged(onOrientationChangedFunction);
//            }.aspxBind(this), 100);
//        }
//    }
//    onEventAttachingToDocument(eventName, func) {
//        if (ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
//            if (!this.documentTouchHandlers[eventName])
//                this.documentTouchHandlers[eventName] = [];
//            this.documentTouchHandlers[eventName].push(func);
//            return this.documentEventAttachingAllowed;
//        }
//        return true;
//    }
//    onEventDettachedFromDocument(eventName, func) {
//        if (ASPx.Browser.MacOSMobilePlatform && this.isTouchEventName(eventName)) {
//            var handlers = this.documentTouchHandlers[eventName];
//            if (handlers)
//                ASPx.Data.ArrayRemove(handlers, func);
//        }
//    }
//    processDocumentTouchEventHandlers(proc) {
//        var touchEventNames = ["touchstart", "touchend", "touchmove", "gesturestart", "gestureend"];
//        for (var i = 0; i < touchEventNames.length; i++) {
//            var eventName = touchEventNames[i];
//            var handlers = this.documentTouchHandlers[eventName];
//            if (handlers) {
//                for (var j = 0; j < handlers.length; j++) {
//                    proc(eventName, handlers[j]);
//                }
//            }
//        }
//    }
//    removeDocumentTouchEventHandlers() {
//        if (ASPx.Browser.MacOSMobilePlatform) {
//            this.documentEventAttachingAllowed = false;
//            this.processDocumentTouchEventHandlers(ASPx.Evt.DetachEventFromDocumentCore);
//        }
//    }
//    restoreDocumentTouchEventHandlers () {
//        if (ASPx.Browser.MacOSMobilePlatform) {
//            this.documentEventAttachingAllowed = true;
//            this.processDocumentTouchEventHandlers(ASPx.Evt.AttachEventToDocumentCore);
//        }
//    }
//    IsNativeScrolling() {
//        return TouchUIHelper.nativeScrollingSupported() && TouchUIHelper.isNativeScrollingAllowed;
//    }
//    pointerEnabled: !!(window.PointerEvent || window.MSPointerEvent);
//    pointerDownEventName: window.PointerEvent ? "pointerdown" : "MSPointerDown",
//            pointerUpEventName: window.PointerEvent ? "pointerup" : "MSPointerUp",
//                pointerCancelEventName: window.PointerEvent ? "pointercancel" : "MSPointerCancel",
//                    pointerMoveEventName: window.PointerEvent ? "pointermove" : "MSPointerMove",
//                        pointerOverEventName: window.PointerEvent ? "pointerover" : "MSPointerOver",
//                            pointerOutEventName: window.PointerEvent ? "pointerout" : "MSPointerOut",
//                                pointerType: {
//        Touch: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 2 : "touch",
//            Pen: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 3 : "pen",
//                Mouse: (ASPx.Browser.IE && ASPx.Browser.Version == 10) ? 4 : "mouse"
//    }
//    msGestureEnabled: !!(window.PointerEvent || window.MSPointerEvent) && typeof (MSGesture) != "undefined";
//    msTouchCreateGesturesWrapper(element, onTap) {
//        if (!TouchUIHelper.msGestureEnabled)
//            return;
//        var gesture = new MSGesture();
//        gesture.target = element;
//        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerDownEventName, function (evt) {
//            gesture.addPointer(evt.pointerId);
//        });
//        ASPx.Evt.AttachEventToElement(element, TouchUIHelper.pointerUpEventName, function (evt) {
//            gesture.stop();
//        });
//        if (onTap)
//            ASPx.Evt.AttachEventToElement(element, "MSGestureTap", onTap);
//        return gesture;
//    }
//}


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base_1 = __webpack_require__(19);
var Data = /** @class */ (function () {
    function Data() {
    }
    Data.ArrayInsert = function (array, element, position) {
        if (0 <= position && position < array.length) {
            for (var i = array.length; i > position; i--)
                array[i] = array[i - 1];
            array[position] = element;
        }
        else
            array.push(element);
    };
    Data.ArrayRemove = function (array, element) {
        var index = Data.ArrayIndexOf(array, element);
        if (index > -1)
            Data.ArrayRemoveAt(array, index);
    };
    Data.ArrayRemoveAt = function (array, index) {
        if (index >= 0 && index < array.length) {
            for (var i = index; i < array.length - 1; i++)
                array[i] = array[i + 1];
            array.pop();
        }
    };
    Data.ArrayClear = function (array) {
        while (array.length > 0)
            array.pop();
    };
    Data.ArrayIndexOf = function (array, element, comparer) {
        if (!comparer) {
            for (var i = 0; i < array.length; i++) {
                if (array[i] == element)
                    return i;
            }
        }
        else {
            for (var i = 0; i < array.length; i++) {
                if (comparer(array[i], element))
                    return i;
            }
        }
        return -1;
    };
    Data.ArrayContains = function (array, element) {
        return Data.ArrayIndexOf(array, element) >= 0;
    };
    Data.ArrayEqual = function (array1, array2) {
        var count1 = array1.length;
        var count2 = array2.length;
        if (count1 != count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (array1[i] != array2[i])
                return false;
        return true;
    };
    Data.ArraySame = function (array1, array2) {
        if (array1.length !== array2.length)
            return false;
        return array1.every(function (elem) { return Data.ArrayContains(array2, elem); });
    };
    Data.ArrayGetIntegerEdgeValues = function (array) {
        var arrayToSort = Data.CollectionToArray(array);
        Data.ArrayIntegerAscendingSort(arrayToSort);
        return {
            start: arrayToSort[0],
            end: arrayToSort[arrayToSort.length - 1]
        };
    };
    Data.ArrayIntegerAscendingSort = function (array) {
        Data.ArrayIntegerSort(array, false);
    };
    Data.ArrayIntegerSort = function (array, desc) {
        array.sort(function (i1, i2) {
            var res = 0;
            if (i1 > i2)
                res = 1;
            else if (i1 < i2)
                res = -1;
            if (desc)
                res *= -1;
            return res;
        });
    };
    Data.CollectionsUnionToArray = function (firstCollection, secondCollection) {
        var result = [];
        var firstCollectionLength = firstCollection.length;
        var secondCollectionLength = secondCollection.length;
        for (var i = 0; i < firstCollectionLength + secondCollectionLength; i++) {
            if (i < firstCollectionLength)
                result.push(firstCollection[i]);
            else
                result.push(secondCollection[i - firstCollectionLength]);
        }
        return result;
    };
    Data.CollectionToArray = function (collection) {
        var array = [];
        for (var i = 0; i < collection.length; i++)
            array.push(collection[i]);
        return array;
    };
    Data.CreateHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = 1;
        return hash;
    };
    Data.CreateIndexHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = i;
        return hash;
    };
    Data.ArrayToHash = function (array, getKeyFunc, getValueFunc) {
        if (!(array instanceof Array))
            return {};
        return array.reduce(function (map, element, index) {
            var key = getKeyFunc(element, index);
            var value = getValueFunc(element, index);
            map[key] = value;
            return map;
        }, {});
    };
    Data.Sum = function (array, getValueFunc) {
        if (!(array instanceof Array))
            return 0;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!Base_1.IsNumber(value))
                value = 0;
            return prevValue + value;
        }, 0);
    };
    Data.Min = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, false); };
    ;
    Data.Max = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, true); };
    ;
    Data.NearestLeftBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        var leftPoint = arrayElement < value;
        var lastLeftPoint = leftPoint && index == array.length - 1;
        var nearestLeftPoint = lastLeftPoint || (leftPoint && array[index + 1] >= value);
        if (nearestLeftPoint)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    Data.ArrayBinarySearch = function (array, value, binarySearchComparer, startIndex, length) {
        if (!binarySearchComparer)
            binarySearchComparer = Data.defaultBinarySearchComparer;
        if (!Base_1.IsExists(startIndex))
            startIndex = 0;
        if (!Base_1.IsExists(length))
            length = array.length - startIndex;
        var endIndex = (startIndex + length) - 1;
        while (startIndex <= endIndex) {
            var middle = (startIndex + ((endIndex - startIndex) >> 1));
            var compareResult = binarySearchComparer(array, middle, value);
            if (compareResult == 0)
                return middle;
            if (compareResult < 0)
                startIndex = middle + 1;
            else
                endIndex = middle - 1;
        }
        return -(startIndex + 1);
    };
    Data.ArrayFlatten = function (arrayOfArrays) {
        return [].concat.apply([], arrayOfArrays);
    };
    Data.GetDistinctArray = function (array) {
        var resultArray = [];
        for (var i = 0; i < array.length; i++) {
            var currentEntry = array[i];
            if (Data.ArrayIndexOf(resultArray, currentEntry) == -1) {
                resultArray.push(currentEntry);
            }
        }
        return resultArray;
    };
    Data.ForEach = function (arr, callback) {
        if (Array.prototype.forEach) {
            Array.prototype.forEach.call(arr, callback);
        }
        else {
            for (var i = 0, len = arr.length; i < len; i++) {
                callback(arr[i], i, arr);
            }
        }
    };
    Data.MergeHashTables = function (target, object) {
        if (!object || typeof (object) == "string")
            return target;
        if (!target)
            target = {};
        for (var key in object)
            if (key && !(key in target))
                target[key] = object[key];
        return target;
    };
    Data.Range = function (count, start) {
        count = parseInt(count) || 0;
        start = parseInt(start) || 0;
        if (count < 0)
            count = 0;
        if (start < 0)
            start = 0;
        return Array.apply(null, Array(count)).map(function (_val, i) { return start + i; });
    };
    Data.CalculateArrayMinMax = function (array, getValueFunc, isMax) {
        if (!(array instanceof Array))
            return 0;
        var startValue = isMax ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!Base_1.IsNumber(value))
                value = startValue;
            var func = isMax ? Math.max : Math.min;
            return func(value, prevValue);
        }, startValue);
    };
    Data.defaultBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        if (arrayElement == value)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    return Data;
}());
exports.Data = Data;


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ItemChangeType;
(function (ItemChangeType) {
    ItemChangeType[ItemChangeType["Create"] = 0] = "Create";
    ItemChangeType[ItemChangeType["Update"] = 1] = "Update";
    ItemChangeType[ItemChangeType["UpdateStructure"] = 2] = "UpdateStructure";
    ItemChangeType[ItemChangeType["Remove"] = 3] = "Remove";
})(ItemChangeType = exports.ItemChangeType || (exports.ItemChangeType = {}));
var ItemChange = /** @class */ (function () {
    function ItemChange(item, type) {
        this.item = item;
        this.type = type;
    }
    Object.defineProperty(ItemChange.prototype, "key", {
        get: function () { return this.item.key; },
        enumerable: true,
        configurable: true
    });
    return ItemChange;
}());
exports.ItemChange = ItemChange;


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var FilterPrimitive_1 = __webpack_require__(85);
var Model_1 = __webpack_require__(23);
var __1 = __webpack_require__(10);
var TextFilterPrimitive = /** @class */ (function (_super) {
    __extends(TextFilterPrimitive, _super);
    function TextFilterPrimitive(id, x, y, width, height) {
        if (x === void 0) { x = "-0.05"; }
        if (y === void 0) { y = "-0.05"; }
        if (width === void 0) { width = "1.1"; }
        if (height === void 0) { height = "1.1"; }
        var _this = _super.call(this, id, x, y, width, height) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    TextFilterPrimitive.prototype.createChildElements = function (parent) {
        var feFlood = document.createElementNS(RenderManager_1.svgNS, "feFlood");
        parent.appendChild(feFlood);
        var feComposite = document.createElementNS(RenderManager_1.svgNS, "feComposite");
        feComposite.setAttribute("in", "SourceGraphic");
        feComposite.setAttribute("operator", "atop");
        parent.appendChild(feComposite);
    };
    return TextFilterPrimitive;
}(FilterPrimitive_1.FilterPrimitive));
exports.TextFilterPrimitive = TextFilterPrimitive;
var TextFloodFilterPrimitive = /** @class */ (function (_super) {
    __extends(TextFloodFilterPrimitive, _super);
    function TextFloodFilterPrimitive(id, floodColor, x, y, width, height) {
        if (x === void 0) { x = "-0.05"; }
        if (y === void 0) { y = "-0.05"; }
        if (width === void 0) { width = "1.1"; }
        if (height === void 0) { height = "1.1"; }
        var _this = _super.call(this, id, x, y, width, height) || this;
        _this.id = id;
        _this.floodColor = floodColor;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    TextFloodFilterPrimitive.prototype.applyChildrenProperties = function (element) {
        for (var child = void 0, i = 0; child = element.childNodes[i]; i++) {
            if (child.nodeName && child.nodeName.toUpperCase() === "FEFLOOD") {
                this.prepareFEFloodNode(child);
                break;
            }
        }
    };
    TextFloodFilterPrimitive.prototype.prepareFEFloodNode = function (node) {
        var colorHash = __1.ColorHelper.colorToHash(this.floodColor);
        node.setAttribute("flood-color", colorHash);
        node.setAttribute("class", "text-filter-flood");
        if (this.floodColor !== Model_1.DiagramModel.defaultPageColor)
            node.style.setProperty("flood-color", colorHash);
    };
    return TextFloodFilterPrimitive;
}(TextFilterPrimitive));
exports.TextFloodFilterPrimitive = TextFloodFilterPrimitive;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var FilterPrimitive = /** @class */ (function (_super) {
    __extends(FilterPrimitive, _super);
    function FilterPrimitive(id, x, y, width, height) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    FilterPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "filter");
    };
    FilterPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return FilterPrimitive;
}(Primitive_1.SvgPrimitive));
exports.FilterPrimitive = FilterPrimitive;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base64Utils = /** @class */ (function () {
    function Base64Utils() {
    }
    Base64Utils.normalize = function (base64, mimeType) {
        if (mimeType === void 0) { mimeType = "image/png"; }
        if (!Base64Utils.checkPrependDataUrl(base64))
            base64 = Base64Utils.prepend(base64, mimeType);
        return base64;
    };
    Base64Utils.prepend = function (base64, mimeType) {
        if (mimeType === void 0) { mimeType = "image/png"; }
        return "data:" + mimeType + ";base64," + base64;
    };
    Base64Utils.checkPrependDataUrl = function (base64) {
        return Base64Utils.dataUrl.test(base64);
    };
    Base64Utils.dataUrl = /data:(.*)(;(.*))?(;base64)?,/;
    return Base64Utils;
}());
exports.Base64Utils = Base64Utils;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ExtensionLineType;
(function (ExtensionLineType) {
    ExtensionLineType[ExtensionLineType["LeftToLeftAbove"] = 0] = "LeftToLeftAbove";
    ExtensionLineType[ExtensionLineType["LeftToLeftBelow"] = 1] = "LeftToLeftBelow";
    ExtensionLineType[ExtensionLineType["RightToRightAbove"] = 2] = "RightToRightAbove";
    ExtensionLineType[ExtensionLineType["RightToRightBelow"] = 3] = "RightToRightBelow";
    ExtensionLineType[ExtensionLineType["LeftToRightAbove"] = 4] = "LeftToRightAbove";
    ExtensionLineType[ExtensionLineType["LeftToRightBelow"] = 5] = "LeftToRightBelow";
    ExtensionLineType[ExtensionLineType["RightToLeftAbove"] = 6] = "RightToLeftAbove";
    ExtensionLineType[ExtensionLineType["RightToLeftBelow"] = 7] = "RightToLeftBelow";
    ExtensionLineType[ExtensionLineType["TopToTopBefore"] = 8] = "TopToTopBefore";
    ExtensionLineType[ExtensionLineType["TopToTopAfter"] = 9] = "TopToTopAfter";
    ExtensionLineType[ExtensionLineType["BottomToBottomBefore"] = 10] = "BottomToBottomBefore";
    ExtensionLineType[ExtensionLineType["BottomToBottomAfter"] = 11] = "BottomToBottomAfter";
    ExtensionLineType[ExtensionLineType["TopToBottomBefore"] = 12] = "TopToBottomBefore";
    ExtensionLineType[ExtensionLineType["TopToBottomAfter"] = 13] = "TopToBottomAfter";
    ExtensionLineType[ExtensionLineType["BottomToTopBefore"] = 14] = "BottomToTopBefore";
    ExtensionLineType[ExtensionLineType["BottomToTopAfter"] = 15] = "BottomToTopAfter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterAbove"] = 16] = "HorizontalCenterAbove";
    ExtensionLineType[ExtensionLineType["HorizontalCenterBelow"] = 17] = "HorizontalCenterBelow";
    ExtensionLineType[ExtensionLineType["VerticalCenterBefore"] = 18] = "VerticalCenterBefore";
    ExtensionLineType[ExtensionLineType["VerticalCenterAfter"] = 19] = "VerticalCenterAfter";
    ExtensionLineType[ExtensionLineType["VerticalCenterToPageCenter"] = 20] = "VerticalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterToPageCenter"] = 21] = "HorizontalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["LeftToPageCenter"] = 22] = "LeftToPageCenter";
    ExtensionLineType[ExtensionLineType["RightToPageCenter"] = 23] = "RightToPageCenter";
    ExtensionLineType[ExtensionLineType["TopToPageCenter"] = 24] = "TopToPageCenter";
    ExtensionLineType[ExtensionLineType["BottomToPageCenter"] = 25] = "BottomToPageCenter";
})(ExtensionLineType = exports.ExtensionLineType || (exports.ExtensionLineType = {}));
var ExtensionLine = /** @class */ (function () {
    function ExtensionLine(type, segment, text) {
        this.type = type;
        this.segment = segment;
        this.text = text;
    }
    return ExtensionLine;
}());
exports.ExtensionLine = ExtensionLine;
var ExtensionLinesVisualizer = /** @class */ (function () {
    function ExtensionLinesVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
        this.lines = [];
        this.lineIndexByType = {};
    }
    ExtensionLinesVisualizer.prototype.addSegment = function (type, segment, text) {
        var curIndex = this.lineIndexByType[type];
        if (curIndex === undefined) {
            var line = new ExtensionLine(type, segment, text);
            var index = this.lines.push(line);
            this.lineIndexByType[line.type] = index - 1;
            this.raiseShow();
        }
        else if (segment.distance < this.lines[curIndex].segment.distance) {
            var line = new ExtensionLine(type, segment, text);
            this.lines.splice(curIndex, 1, line);
            this.raiseShow();
        }
    };
    ExtensionLinesVisualizer.prototype.update = function () {
        this.raiseShow();
    };
    ExtensionLinesVisualizer.prototype.reset = function () {
        if (this.lines.length) {
            this.lines = [];
            this.lineIndexByType = {};
            this.raiseHide();
        }
    };
    ExtensionLinesVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesShow(_this.lines); });
    };
    ExtensionLinesVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesHide(); });
    };
    return ExtensionLinesVisualizer;
}());
exports.ExtensionLinesVisualizer = ExtensionLinesVisualizer;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsCalculatorBase = /** @class */ (function () {
    function ConnectorPointsCalculatorBase(connector) {
        this.connector = connector;
    }
    return ConnectorPointsCalculatorBase;
}());
exports.ConnectorPointsCalculatorBase = ConnectorPointsCalculatorBase;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var Connector_1 = __webpack_require__(5);
var DeleteConnectionHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectionHistoryItem, _super);
    function DeleteConnectionHistoryItem(connector, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.position = position;
        _this.itemKey = connector.getExtremeItem(_this.position).key;
        return _this;
    }
    DeleteConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.deleteConnection(connector, this.position);
    };
    DeleteConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.oldConnectionPointIndex, this.position);
    };
    return DeleteConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectionHistoryItem = DeleteConnectionHistoryItem;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var DeleteShapeHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteShapeHistoryItem, _super);
    function DeleteShapeHistoryItem(shapeKey) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        return _this;
    }
    DeleteShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.shape = shape.clone();
        manipulator.deleteShape(shape);
    };
    DeleteShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addShape(this.shape, this.shape.key);
    };
    return DeleteShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteShapeHistoryItem = DeleteShapeHistoryItem;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var DiamondShapeDescription = /** @class */ (function (_super) {
    __extends(DiamondShapeDescription, _super);
    function DiamondShapeDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Diamond"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = ShapeDescription_1.ShapeDefaultSize.clone(); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(DiamondShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Diamond; },
        enumerable: true,
        configurable: true
    });
    DiamondShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    return DiamondShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.DiamondShapeDescription = DiamondShapeDescription;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var TextShapeDescription = /** @class */ (function (_super) {
    __extends(TextShapeDescription, _super);
    function TextShapeDescription() {
        return _super.call(this, "Text", "Text", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.5)) || this;
    }
    Object.defineProperty(TextShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Text; },
        enumerable: true,
        configurable: true
    });
    TextShapeDescription.prototype.createShapePrimitives = function (shape, forToolbox) {
        return [];
    };
    return TextShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.TextShapeDescription = TextShapeDescription;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(67);
var DiagramItem_1 = __webpack_require__(4);
var PentagonShapeDescription = /** @class */ (function (_super) {
    __extends(PentagonShapeDescription, _super);
    function PentagonShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Pentagon"; }
        if (defaultText === void 0) { defaultText = ""; }
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultRatio = _this.defaultSize.height / _this.defaultSize.width;
        return _this;
    }
    Object.defineProperty(PentagonShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Pentagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PentagonShapeDescription.prototype, "angleCount", {
        get: function () { return 5; },
        enumerable: true,
        configurable: true
    });
    PentagonShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var ratio = height / width / this.defaultRatio;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var px = (height - py) / Math.tan(angle) / ratio;
        var x1 = left + px;
        var x2 = right - px;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    PentagonShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East || side === DiagramItem_1.ConnectionPointSide.West) {
            var rect = shape.rectangle;
            var top_1 = rect.top, width = rect.width, height = rect.height;
            var ratio = height / width / this.defaultRatio;
            var angle = Math.PI - this.angle;
            var py = width / 2 * Math.tan(angle / 2) * ratio;
            var y = top_1 + py;
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.y = y;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.y = y;
        }
    };
    PentagonShapeDescription.prototype.calculateHeight = function (width) {
        var angle = Math.PI - this.angle;
        var h1 = width / 2 * Math.tan(angle / 2);
        var side = width / 2 / Math.cos(angle / 2);
        var h2 = side * Math.sin(angle);
        return h1 + h2;
    };
    return PentagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.PentagonShapeDescription = PentagonShapeDescription;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(67);
var HexagonShapeDescription = /** @class */ (function (_super) {
    __extends(HexagonShapeDescription, _super);
    function HexagonShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Hexagon"; }
        if (defaultText === void 0) { defaultText = ""; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(HexagonShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Hexagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(HexagonShapeDescription.prototype, "angleCount", {
        get: function () { return 6; },
        enumerable: true,
        configurable: true
    });
    HexagonShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        var x1 = left + (width - sideX) / 2;
        var x2 = x1 + sideX;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    HexagonShapeDescription.prototype.calculateHeight = function (width) {
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        return 2 * sideX * Math.sin(angle);
    };
    return HexagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.HexagonShapeDescription = HexagonShapeDescription;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var ConnectionPoint_1 = __webpack_require__(34);
var DiagramItem_1 = __webpack_require__(4);
var TriangleShapeDescription = /** @class */ (function (_super) {
    __extends(TriangleShapeDescription, _super);
    function TriangleShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Triangle"; }
        if (defaultText === void 0) { defaultText = ""; }
        var _this = _super.call(this, title, defaultText) || this;
        _this.defaultSize.height = _this.calculateHeight(ShapeDescription_1.ShapeDefaultDimension);
        return _this;
    }
    Object.defineProperty(TriangleShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Triangle; },
        enumerable: true,
        configurable: true
    });
    TriangleShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(0.75, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0.25, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    TriangleShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.center.x, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    TriangleShapeDescription.prototype.calculateHeight = function (width) {
        return Math.sqrt(Math.pow(width, 2) - Math.pow(width / 2, 2));
    };
    return TriangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.TriangleShapeDescription = TriangleShapeDescription;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(4);
var DocumentShapeDescription = /** @class */ (function (_super) {
    __extends(DocumentShapeDescription, _super);
    function DocumentShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Document"; }
        if (defaultText === void 0) { defaultText = "Document"; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(DocumentShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Document; },
        enumerable: true,
        configurable: true
    });
    DocumentShapeDescription.prototype.createShapePrimitives = function (shape) {
        return this.createDocumentPrimitives(shape.rectangle, shape.style);
    };
    DocumentShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DocumentShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    DocumentShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * DocumentShapeDescription.curveOffsetRatio;
    };
    DocumentShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.resize(0, -rect.height * DocumentShapeDescription.curveOffsetRatio);
    };
    DocumentShapeDescription.curveOffsetRatio = 0.1;
    return DocumentShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DocumentShapeDescription = DocumentShapeDescription;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var ImagePrimitive = /** @class */ (function (_super) {
    __extends(ImagePrimitive, _super);
    function ImagePrimitive(x, y, width, height, url, preserveAspectRatio, style, className) {
        if (preserveAspectRatio === void 0) { preserveAspectRatio = "none"; }
        var _this = _super.call(this, style, className) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.url = url;
        _this.preserveAspectRatio = preserveAspectRatio;
        return _this;
    }
    ImagePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "image");
    };
    ImagePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        this.setUnitAttribute(element, "href", this.url);
        this.setUnitAttribute(element, "preserveAspectRatio", this.preserveAspectRatio);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return ImagePrimitive;
}(Primitive_1.SvgPrimitive));
exports.ImagePrimitive = ImagePrimitive;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ImageCache_1 = __webpack_require__(49);
var ImageLoader = /** @class */ (function () {
    function ImageLoader(loadedCallback) {
        this.loadedCallback = loadedCallback;
    }
    ImageLoader.prototype.load = function (data) {
        if (data.isLoaded) {
            this.loadedCallback(data);
            return;
        }
        this.loadInner(data);
    };
    ImageLoader.prototype.loadInner = function (data) {
        var _this = this;
        if (data.imageUrl)
            this.loadPictureByUrl(data, function () { return _this.finalizeLoading(data, data); });
        else if (data.base64)
            this.loadPictureByBase64(data, function () { return _this.finalizeLoading(data, data); });
        return data;
    };
    ImageLoader.prototype.finalizeLoading = function (loadedData, existingInfo) {
        if (!existingInfo)
            existingInfo = ImageCache_1.ImageCache.instance.getImageData(loadedData.actualId);
        if (!existingInfo.isLoaded)
            ImageCache_1.ImageCache.instance.finalizeLoading(existingInfo, loadedData);
        this.loadedCallback(existingInfo);
    };
    ImageLoader.prototype.loadPictureByBase64 = function (data, imageLoaded) {
        var img = new Image();
        img.onload = function () {
            imageLoaded(data);
        };
        img.src = data.base64;
    };
    ImageLoader.prototype.loadPictureByUrl = function (data, imageLoaded) {
        var _this = this;
        var xhr = new XMLHttpRequest();
        try {
            xhr.onload = function () {
                var reader = new FileReader();
                reader.onloadend = function () {
                    data.base64 = reader.result;
                    _this.loadPictureByBase64(data, function (data) { return imageLoaded(data); });
                };
                reader.readAsDataURL(xhr.response);
            };
            // Access to XMLHttpRequest at 'https://url.jpg' from origin 'http://myurl' has been blocked by CORS policy: 
            // No 'Access-Control-Allow-Origin' header is present on the requested resource.
            xhr.onerror = function ( /*this: XMLHttpRequest*/) { return imageLoaded(data); };
            xhr.onloadend = function () {
                if (xhr.status === 404)
                    imageLoaded(data);
            };
            xhr.open('GET', data.imageUrl, true);
            xhr.responseType = 'blob';
            xhr.send();
        }
        catch (_a) { }
    };
    return ImageLoader;
}());
exports.ImageLoader = ImageLoader;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var RectaglePrimitive_1 = __webpack_require__(18);
var PathPrimitive_1 = __webpack_require__(2);
var Utils_2 = __webpack_require__(15);
var Event_1 = __webpack_require__(12);
var GroupPrimitive_1 = __webpack_require__(22);
var ConnectionPoint_1 = __webpack_require__(34);
var DiagramItem_1 = __webpack_require__(4);
var ContainerDescription = /** @class */ (function (_super) {
    __extends(ContainerDescription, _super);
    function ContainerDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Container"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 2, ShapeDescription_1.ShapeDefaultDimension * 1.5); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(ContainerDescription.prototype, "enableChildren", {
        get: function () { return true; },
        enumerable: true,
        configurable: true
    });
    ContainerDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.25, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(0.75, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.25, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(1, 0.75, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.75, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0.25, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.75, DiagramItem_1.ConnectionPointSide.West),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West),
            new ConnectionPoint_1.ConnectionPoint(0, 0.25, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ContainerDescription.prototype.createShapePrimitives = function (shape, forToolbox) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
        var primitives = [];
        if (shape.expanded) {
            primitives = primitives.concat([
                new RectaglePrimitive_1.RectanglePrimitive(left, top, width, height, shape.style)
            ]);
        }
        return primitives.concat(this.createHeaderPrimitives(shape, forToolbox));
    };
    ContainerDescription.prototype.createExpandButtonPrimitives = function (shape, rect) {
        var commands = [
            new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.left + rect.width * ((1 - ContainerDescription.expandButtonSignRatio) / 2), rect.center.y),
            new PathPrimitive_1.PathPrimitiveLineToCommand(rect.left + rect.width * ((1 - ContainerDescription.expandButtonSignRatio) / 2 + ContainerDescription.expandButtonSignRatio), rect.center.y)
        ];
        if (!shape.expanded) {
            commands = commands.concat([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.center.x, rect.top + rect.height * ((1 - ContainerDescription.expandButtonSignRatio) / 2)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(rect.center.x, rect.top + rect.height * ((1 - ContainerDescription.expandButtonSignRatio) / 2 + ContainerDescription.expandButtonSignRatio)),
            ]);
        }
        var buttonRect = rect.inflate(-rect.width * (1 - ContainerDescription.expandButtonRectRatio) / 2, -rect.height * (1 - ContainerDescription.expandButtonRectRatio) / 2);
        return [
            new GroupPrimitive_1.GroupPrimitive([
                new RectaglePrimitive_1.RectanglePrimitive(buttonRect.left, buttonRect.top, buttonRect.width, buttonRect.height, shape.style),
                new PathPrimitive_1.PathPrimitive(commands, shape.style)
            ], "shape-expand-btn", null, null, function (el) {
                Utils_2.RenderUtils.setElementEventData(el, Event_1.MouseEventElementType.ShapeExpandButton, shape.key);
            })
        ];
    };
    ContainerDescription.headerSize = 360;
    ContainerDescription.headerToolboxSizeRatio = 0.2;
    ContainerDescription.expandButtonRectRatio = 0.5;
    ContainerDescription.expandButtonSignRatio = 0.3;
    return ContainerDescription;
}(ShapeDescription_1.ShapeDescription));
exports.ContainerDescription = ContainerDescription;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeShapeParametersHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeShapeParametersHistoryItem, _super);
    function ChangeShapeParametersHistoryItem(shapeKey, parameters) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.parameters = parameters;
        return _this;
    }
    ChangeShapeParametersHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldParameters = shape.parameters.clone();
        manipulator.changeShapeParameters(shape, this.parameters);
    };
    ChangeShapeParametersHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeParameters(shape, this.oldParameters);
    };
    return ChangeShapeParametersHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeParametersHistoryItem = ChangeShapeParametersHistoryItem;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeStyleHistoryItemBase = /** @class */ (function (_super) {
    __extends(ChangeStyleHistoryItemBase, _super);
    function ChangeStyleHistoryItemBase(itemKey, styleProperty, styleValue) {
        var _this = _super.call(this) || this;
        _this.itemKey = itemKey;
        _this.styleProperty = styleProperty;
        _this.styleValue = styleValue;
        return _this;
    }
    ChangeStyleHistoryItemBase.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItemBase.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItemBase;
}(HistoryItem_1.HistoryItem));
exports.ChangeStyleHistoryItemBase = ChangeStyleHistoryItemBase;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeLockedHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeLockedHistoryItem, _super);
    function ChangeLockedHistoryItem(item, locked) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.locked = locked;
        return _this;
    }
    ChangeLockedHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldLocked = item.locked;
        manipulator.changeLocked(item, this.locked);
    };
    ChangeLockedHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeLocked(item, this.oldLocked);
    };
    return ChangeLockedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeLockedHistoryItem = ChangeLockedHistoryItem;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var Utils_1 = __webpack_require__(0);
var ShapeDescriptionManager_1 = __webpack_require__(26);
var Connector_1 = __webpack_require__(5);
var ShapeTypes_1 = __webpack_require__(1);
var ImageInfo_1 = __webpack_require__(40);
var ImporterBase_1 = __webpack_require__(104);
var ImportUtils_1 = __webpack_require__(70);
var __1 = __webpack_require__(10);
var Importer = /** @class */ (function (_super) {
    __extends(Importer, _super);
    function Importer(json) {
        var _this = _super.call(this) || this;
        _this.obj = ImportUtils_1.ImportUtils.parseJSON(json);
        return _this;
    }
    Importer.prototype.getObject = function () {
        return this.obj;
    };
    Importer.prototype.getPageObject = function (obj) {
        return obj["page"];
    };
    Importer.prototype.getShapeObjects = function (obj) {
        return obj["shapes"];
    };
    Importer.prototype.getConnectorObjects = function (obj) {
        return obj["connectors"];
    };
    Importer.prototype.importPageSettings = function (model, pageObj) {
        if (!pageObj)
            return;
        this.assert(pageObj["width"], "number");
        this.assert(pageObj["height"], "number");
        if (typeof pageObj["width"] === "number")
            model.size.width = pageObj["width"];
        if (typeof pageObj["height"] === "number")
            model.size.height = pageObj["height"];
        if (typeof pageObj["pageColor"] === "number")
            model.pageColor = pageObj["pageColor"];
        else if (typeof pageObj["pageColor"] === "string")
            model.pageColor = __1.ColorHelper.stringToColor(pageObj["pageColor"]);
        if (typeof pageObj["pageWidth"] === "number")
            model.pageSize.width = pageObj["pageWidth"];
        if (typeof pageObj["pageHeight"] === "number")
            model.pageSize.height = pageObj["pageHeight"];
        if (typeof pageObj["pageLandscape"] === "boolean")
            model.pageLandscape = pageObj["pageLandscape"];
        if (typeof pageObj["units"] === "number")
            model.units = pageObj["units"];
    };
    Importer.prototype.importShape = function (shapeObj) {
        this.assert(shapeObj["key"], "string");
        this.assert(shapeObj["x"], "number");
        this.assert(shapeObj["y"], "number");
        this.assert(shapeObj["type"], "string");
        var shapeType = shapeObj["type"];
        var description = ShapeDescriptionManager_1.ShapeDescriptionManager.get(shapeType);
        var position = new Utils_1.Point(shapeObj["x"], shapeObj["y"]);
        var shape = new Shape_1.Shape(description || ShapeDescriptionManager_1.ShapeDescriptionManager.get(ShapeTypes_1.ShapeTypes.Rectangle), position);
        shape.key = shapeObj["key"];
        if (typeof shapeObj["dataKey"] === "string")
            shape.dataKey = shapeObj["dataKey"];
        if (typeof shapeObj["locked"] === "boolean")
            shape.locked = shapeObj["locked"];
        if (typeof shapeObj["width"] === "number")
            shape.size.width = shapeObj["width"];
        if (typeof shapeObj["height"] === "number")
            shape.size.height = shapeObj["height"];
        if (typeof shapeObj["text"] === "string")
            shape.text = shapeObj["text"];
        if (typeof shapeObj["imageUrl"] === "string")
            shape.image = new ImageInfo_1.ImageInfo(shapeObj["imageUrl"]);
        if (shapeObj["parameters"]) {
            shape.parameters.fromObject(shapeObj["parameters"]);
            shape.description.normalizeParameters(shape, shape.parameters);
        }
        if (shapeObj["style"])
            shape.style.fromObject(shapeObj["style"]);
        if (shapeObj["styleText"])
            shape.styleText.fromObject(shapeObj["styleText"]);
        if (typeof shapeObj["zIndex"] === "number")
            shape.zIndex = shapeObj["zIndex"];
        if (Array.isArray(shapeObj["childKeys"]))
            shape.childKeys = shapeObj["childKeys"].slice();
        if (typeof shapeObj["expanded"] === "boolean")
            shape.expanded = shapeObj["expanded"];
        if (typeof shapeObj["expandedWidth"] === "number" && typeof shapeObj["expandedHeight"] === "number")
            shape.expandedSize = new Utils_1.Size(shapeObj["expandedWidth"], shapeObj["expandedHeight"]);
        return shape;
    };
    Importer.prototype.importShapeChildren = function (shapeObj, shape) {
        return [];
    };
    Importer.prototype.importConnector = function (connectorObj) {
        var _this = this;
        this.assert(connectorObj["key"], "string");
        if (!Array.isArray(connectorObj["points"]))
            throw Error("Invalid Format");
        var points = connectorObj["points"].map(function (pt) {
            _this.assert(pt["x"], "number");
            _this.assert(pt["y"], "number");
            return new Utils_1.Point(pt["x"], pt["y"]);
        });
        var connector = new Connector_1.Connector(points);
        connector.key = connectorObj["key"];
        if (typeof connectorObj["dataKey"] === "string")
            connector.dataKey = connectorObj["dataKey"];
        if (typeof connectorObj["locked"] === "boolean")
            connector.locked = connectorObj["locked"];
        connector.endConnectionPointIndex = typeof connectorObj["endConnectionPointIndex"] === "number" ? connectorObj["endConnectionPointIndex"] : -1;
        connector.beginConnectionPointIndex = typeof connectorObj["beginConnectionPointIndex"] === "number" ? connectorObj["beginConnectionPointIndex"] : -1;
        if (connectorObj["endItemKey"] !== undefined)
            this.assert(connectorObj["endItemKey"], "string");
        if (connectorObj["beginItemKey"] !== undefined)
            this.assert(connectorObj["beginItemKey"], "string");
        connector["endItemKey"] = connectorObj["endItemKey"];
        connector["beginItemKey"] = connectorObj["beginItemKey"];
        if (connectorObj["texts"])
            connector.texts.fromObject(connectorObj["texts"]);
        if (connectorObj["properties"])
            connector.properties.fromObject(connectorObj["properties"]);
        if (connectorObj["style"])
            connector.style.fromObject(connectorObj["style"]);
        if (connectorObj["styleText"])
            connector.styleText.fromObject(connectorObj["styleText"]);
        if (typeof connectorObj["zIndex"] === "number")
            connector.zIndex = connectorObj["zIndex"];
        return connector;
    };
    return Importer;
}(ImporterBase_1.ImporterBase));
exports.Importer = Importer;


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Model_1 = __webpack_require__(23);
var Shape_1 = __webpack_require__(9);
var ImporterBase = /** @class */ (function () {
    function ImporterBase() {
    }
    ImporterBase.prototype.import = function () {
        var model = new Model_1.DiagramModel();
        var obj = this.getObject();
        this.importPageSettings(model, this.getPageObject(obj));
        var shapes = this.importShapes(this.getShapeObjects(obj));
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            if (model.findItem(shape.key))
                throw Error("Item key is duplicated");
            model.pushItem(shape);
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            connector.endItem = model.findItem(connector["endItemKey"]) || undefined;
            delete connector["endItemKey"];
            connector.beginItem = model.findItem(connector["beginItemKey"]) || undefined;
            delete connector["beginItemKey"];
            if (model.findItem(connector.key))
                throw Error("Item key is duplicated");
            model.pushItem(connector);
            this.updateConnections(connector);
        }
        model.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                item.childKeys.forEach(function (childKey) {
                    var child = model.findItem(childKey);
                    if (child) {
                        child.container = item;
                        child.containerLocked = item.locked;
                    }
                });
            }
        });
        return model;
    };
    ImporterBase.prototype.importItems = function (model) {
        var result = [];
        var obj = this.getObject();
        var itemHash = {};
        var shapes = this.importShapes(this.getShapeObjects(obj));
        var key;
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            var oldKey = shape.key;
            key = model.getNextKey(key);
            shape.key = key;
            itemHash[oldKey] = shape;
            result.push(shape);
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            var oldKey = connector.key;
            key = model.getNextKey(key);
            connector.key = key;
            itemHash[oldKey] = connector;
            var endItemKey = connector["endItemKey"];
            connector.endItem = itemHash[endItemKey];
            delete connector["endItemKey"];
            var beginItemKey = connector["beginItemKey"];
            connector.beginItem = itemHash[beginItemKey];
            delete connector["beginItemKey"];
            result.push(connector);
            this.updateConnections(connector);
        }
        result.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                item.childKeys.forEach(function (childKey) {
                    var child = itemHash[childKey];
                    if (child) {
                        child.container = item;
                        child.containerLocked = item.locked;
                    }
                });
                item.childKeys = item.childKeys
                    .map(function (childKey) { return itemHash[childKey] && itemHash[childKey].key; })
                    .filter(function (childKey) { return childKey; });
            }
        });
        return result;
    };
    ImporterBase.prototype.importItemsData = function (model) {
        var obj = this.getObject();
        var shapes = this.importShapes(this.getShapeObjects(obj));
        for (var i = 0; i < shapes.length; i++) {
            var srcShape = shapes[i];
            var destShape = void 0;
            if (srcShape.dataKey !== undefined)
                destShape = model.findShapeByDataKey(srcShape.dataKey);
            if (!destShape)
                destShape = model.findShape(srcShape.key);
            if (destShape) {
                destShape.dataKey = srcShape.dataKey;
                destShape.locked = srcShape.locked;
                destShape.position = srcShape.position.clone();
                destShape.size = srcShape.size.clone();
                destShape.parameters = srcShape.parameters.clone();
                destShape.style = srcShape.style.clone();
                destShape.styleText = srcShape.styleText.clone();
                destShape.zIndex = srcShape.zIndex;
            }
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var srcConnector = connectors[i];
            var destConnector = void 0;
            if (srcConnector.dataKey !== undefined)
                destConnector = model.findConnectorByDataKey(srcConnector.dataKey);
            if (!destConnector)
                destConnector = model.findConnector(srcConnector.key);
            if (destConnector) {
                destConnector.dataKey = srcConnector.dataKey;
                destConnector.locked = srcConnector.locked;
                destConnector.points = srcConnector.points.slice();
                destConnector.properties = srcConnector.properties.clone();
                destConnector.style = srcConnector.style.clone();
                destConnector.styleText = srcConnector.styleText.clone();
                destConnector.zIndex = srcConnector.zIndex;
            }
        }
    };
    ImporterBase.prototype.importShapes = function (shapeObjs) {
        var result = [];
        if (!shapeObjs)
            return result;
        if (!Array.isArray(shapeObjs))
            throw Error("Invalid Format");
        for (var i = 0; i < shapeObjs.length; i++) {
            var shapeObj = shapeObjs[i];
            var shape = this.importShape(shapeObj);
            result.push(shape);
            result = result.concat(this.importShapeChildren(shapeObj, shape));
        }
        return result;
    };
    ImporterBase.prototype.importConnectors = function (connectorObjs) {
        var result = [];
        if (!connectorObjs)
            return result;
        if (!Array.isArray(connectorObjs))
            throw Error("Invalid Format");
        for (var i = 0; i < connectorObjs.length; i++) {
            var shapeObj = connectorObjs[i];
            result.push(this.importConnector(shapeObj));
        }
        return result;
    };
    ImporterBase.prototype.updateConnections = function (connector) {
        if (connector.endItem) {
            if (connector.endItem instanceof Shape_1.Shape) {
                connector.endItem.attachedConnectors.push(connector);
                connector.points[connector.points.length - 1] = connector.endItem.getConnectionPointPosition(connector.endConnectionPointIndex, connector.points[connector.points.length - 2]);
            }
            else {
                connector.endItem = undefined;
                connector.endConnectionPointIndex = -1;
            }
        }
        if (connector.beginItem) {
            if (connector.beginItem instanceof Shape_1.Shape) {
                connector.beginItem.attachedConnectors.push(connector);
                connector.points[0] = connector.beginItem.getConnectionPointPosition(connector.beginConnectionPointIndex, connector.points[1]);
            }
            else {
                connector.beginItem = undefined;
                connector.beginConnectionPointIndex = -1;
            }
        }
    };
    ImporterBase.prototype.assert = function (value, type) {
        if (value === undefined)
            throw Error("Invalid Format");
        if (type !== undefined && typeof value !== type)
            throw Error("Invalid Format");
    };
    return ImporterBase;
}());
exports.ImporterBase = ImporterBase;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var StylePropertyCommandBase = /** @class */ (function (_super) {
    __extends(StylePropertyCommandBase, _super);
    function StylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return StylePropertyCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.StylePropertyCommandBase = StylePropertyCommandBase;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var StylePropertyCommandBase_1 = __webpack_require__(105);
var ChangeStylePropertyCommandBase = /** @class */ (function (_super) {
    __extends(ChangeStylePropertyCommandBase, _super);
    function ChangeStylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        parameter = this.processParameter(parameter);
        items.forEach(function (item) {
            var styleProperty = _this.getStyleProperty();
            _this.control.history.addAndRedo(_this.createHistoryItem(item, styleProperty, parameter));
        });
        this.updateInputPosition(parameter);
        this.control.history.endTransaction();
        return true;
    };
    ChangeStylePropertyCommandBase.prototype.processParameter = function (parameter) {
        return parameter;
    };
    return ChangeStylePropertyCommandBase;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ChangeStylePropertyCommandBase = ChangeStylePropertyCommandBase;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommandBase_1 = __webpack_require__(106);
var ChangeStyleHistoryItem_1 = __webpack_require__(46);
var ChangeStylePropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeStylePropertyCommand, _super);
    function ChangeStylePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getStylePropertyValue(this.getStyleProperty());
    };
    ChangeStylePropertyCommand.prototype.getStyleObj = function (item) {
        return item.style;
    };
    ChangeStylePropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStylePropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setStylePropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStylePropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStylePropertyCommand = ChangeStylePropertyCommand;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(55);
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangeConnectorPropertyCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorPropertyCommand, _super);
    function ChangeConnectorPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorPropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getConnectorPropertyValue(this.getPropertyName());
    };
    ChangeConnectorPropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var connectors = this.control.selection.getSelectedConnectors();
        connectors.forEach(function (connector) {
            var propertyName = _this.getPropertyName();
            _this.control.history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, propertyName, parameter));
        });
        this.control.selection.inputPosition.setConnectorPropertyValue(this.getPropertyName(), parameter);
        this.control.history.endTransaction();
        return true;
    };
    return ChangeConnectorPropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeConnectorPropertyCommand = ChangeConnectorPropertyCommand;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var NodeLayout_1 = __webpack_require__(56);
var GraphLayout = /** @class */ (function () {
    function GraphLayout() {
        this.nodeKeys = [];
        this.nodeToLayout = {};
        this.edgeToPosition = {};
    }
    GraphLayout.prototype.forEachNode = function (callback) {
        var _this = this;
        this.nodeKeys.forEach(function (nk) { return callback(_this.nodeToLayout[nk], nk); });
    };
    GraphLayout.prototype.addNode = function (nodeLayout) {
        if (this.nodeToLayout[nodeLayout.key])
            throw Error("Node layout is already registered");
        this.nodeKeys.push(nodeLayout.key);
        this.nodeToLayout[nodeLayout.key] = nodeLayout;
    };
    GraphLayout.prototype.addEdge = function (edgeLayout) {
        if (this.edgeToPosition[edgeLayout.key])
            throw Error("Edge layout is already registered");
        this.edgeToPosition[edgeLayout.key] = edgeLayout;
    };
    GraphLayout.prototype.getRectangle = function (includeMargins) {
        var _this = this;
        return Utils_1.GeometryUtils.getCommonRectangle(this.nodeKeys.map(function (nk) { return _this.nodeToLayout[nk].rectangle; }));
    };
    GraphLayout.prototype.offsetNodes = function (deltaX, deltaY) {
        var _this = this;
        if (deltaX === void 0) { deltaX = 0; }
        if (deltaY === void 0) { deltaY = 0; }
        var layout = new GraphLayout();
        this.nodeKeys.forEach(function (nk) {
            var nl = _this.nodeToLayout[nk];
            layout.addNode(new NodeLayout_1.NodeLayout(nl.info, nl.position.offset(deltaX, deltaY)));
        });
        layout.copyEdges(this);
        return layout;
    };
    GraphLayout.prototype.extend = function (layout) {
        var _this = this;
        layout.forEachNode(function (nl) { return _this.addNode(nl); });
        this.copyEdges(layout);
    };
    GraphLayout.prototype.copyEdges = function (source) {
        var _this = this;
        Object.keys(source.edgeToPosition).forEach(function (e) {
            var edge = source.edgeToPosition[e];
            _this.addEdge(new NodeLayout_1.EdgeLayout(edge.key, edge.beginIndex, edge.endIndex));
        });
    };
    return GraphLayout;
}());
exports.GraphLayout = GraphLayout;


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var LayoutSettings_1 = __webpack_require__(21);
var LayoutBuilder = /** @class */ (function () {
    function LayoutBuilder(settings, graph) {
        this.settings = settings;
        this.graph = graph;
    }
    LayoutBuilder.prototype.getBreadthNodeSizeCore = function (node) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            (node.size.width + node.margin.left + node.margin.right) :
            (node.size.height + node.margin.top + node.margin.bottom);
    };
    LayoutBuilder.prototype.getDepthNodeSizeCore = function (node) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal ?
            (node.size.width + node.margin.left + node.margin.right) :
            (node.size.height + node.margin.top + node.margin.bottom);
    };
    LayoutBuilder.prototype.chooseDirectionValue = function (near, far) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? near : far;
    };
    LayoutBuilder.prototype.getDirectionValue = function (value) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? value : -value;
    };
    LayoutBuilder.prototype.getComponentOffset = function (graphLayout) {
        var rect = graphLayout.getRectangle(true);
        var offset = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? rect.width : rect.height;
        return offset + this.settings.componentSpacing;
    };
    LayoutBuilder.prototype.setComponentOffset = function (graphLayout, offset) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            graphLayout.offsetNodes(offset) :
            graphLayout.offsetNodes(0, offset);
    };
    return LayoutBuilder;
}());
exports.LayoutBuilder = LayoutBuilder;


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ClipboardCommand_1 = __webpack_require__(74);
var __1 = __webpack_require__(10);
var Importer_1 = __webpack_require__(103);
var Shape_1 = __webpack_require__(9);
var ImportShapeHistoryItem_1 = __webpack_require__(225);
var Connector_1 = __webpack_require__(5);
var ImportConnectorHistoryItem_1 = __webpack_require__(226);
var ModelUtils_1 = __webpack_require__(7);
var SetSelectionHistoryItem_1 = __webpack_require__(44);
var PasteSelectionCommandBase = /** @class */ (function (_super) {
    __extends(PasteSelectionCommandBase, _super);
    function PasteSelectionCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionCommandBase.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && this.isPasteSupportedByBrowser();
    };
    PasteSelectionCommandBase.prototype.isVisible = function () {
        return this.isPasteSupportedByBrowser();
    };
    PasteSelectionCommandBase.prototype.isPasteSupportedByBrowser = function () {
        return __1.Browser.IE || (__1.Browser.WebKitFamily && navigator && navigator["clipboard"] !== undefined);
    };
    PasteSelectionCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.getClipboardData(function (data) {
            _this.performPaste(data, parameter);
        });
        return true;
    };
    PasteSelectionCommandBase.prototype.performPaste = function (data, parameter) {
        this.control.beginUpdate(true);
        this.control.history.beginTransaction();
        var ids = [];
        var importer = new Importer_1.Importer(data);
        var items = importer.importItems(this.control.model);
        this.calculateSelectionOffset(items, parameter);
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item instanceof Shape_1.Shape) {
                item.position = this.getShapeNewPosition(item.position);
                this.control.history.addAndRedo(new ImportShapeHistoryItem_1.ImportShapeHistoryItem(item));
            }
            else if (item instanceof Connector_1.Connector) {
                this.changeConnectorPoints(item);
                this.control.history.addAndRedo(new ImportConnectorHistoryItem_1.ImportConnectorHistoryItem(item));
            }
            var containerKey = item.container && item.container.key;
            if (!containerKey || ids.indexOf(containerKey) === -1)
                ids.push(item.key);
        }
        ModelUtils_1.ModelUtils.tryUpdateModelSize(this.control.history, this.control.model);
        this.control.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.control.selection, ids));
        this.control.history.endTransaction();
        this.control.endUpdate(true);
    };
    PasteSelectionCommandBase.prototype.calculateSelectionOffset = function (items, position) { };
    return PasteSelectionCommandBase;
}(ClipboardCommand_1.ClipboardCommand));
exports.PasteSelectionCommandBase = PasteSelectionCommandBase;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var LayoutSettings_1 = __webpack_require__(21);
var WideTree_1 = __webpack_require__(72);
var Sugiyama_1 = __webpack_require__(61);
var DataLayoutType;
(function (DataLayoutType) {
    DataLayoutType[DataLayoutType["Tree"] = 0] = "Tree";
    DataLayoutType[DataLayoutType["Sugiyama"] = 1] = "Sugiyama";
})(DataLayoutType = exports.DataLayoutType || (exports.DataLayoutType = {}));
var DataLayoutParameters = /** @class */ (function () {
    function DataLayoutParameters(parameter) {
        this.layoutType = parameter !== undefined && parameter.type || DataLayoutType.Tree;
        this.layoutSettings = (this.layoutType === DataLayoutType.Sugiyama) ? new LayoutSettings_1.LayoutSettings() : new LayoutSettings_1.TreeLayoutSettings();
        if (parameter !== undefined && parameter.orientation !== undefined)
            this.layoutSettings.orientation = parameter.orientation;
    }
    DataLayoutParameters.prototype.getLayoutBuilder = function (graph) {
        return (this.layoutType === DataLayoutType.Tree) ?
            new WideTree_1.TreeLayoutBuilder(this.layoutSettings, graph) :
            new Sugiyama_1.SugiyamaLayoutBuilder(this.layoutSettings, graph);
    };
    return DataLayoutParameters;
}());
exports.DataLayoutParameters = DataLayoutParameters;


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(7);
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangeLockedCommand = /** @class */ (function (_super) {
    __extends(ChangeLockedCommand, _super);
    function ChangeLockedCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeLockedCommand.prototype.isEnabled = function () {
        var _this = this;
        var items = this.control.selection.getSelectedItems(true);
        var enabled = false;
        items.forEach(function (item) { if (item.locked !== _this.getLockState())
            enabled = true; });
        return _super.prototype.isEnabled.call(this) && enabled;
    };
    ChangeLockedCommand.prototype.executeCore = function (state, parameter) {
        ModelUtils_1.ModelUtils.changeSelectionLocked(this.control.history, this.control.model, this.control.selection, this.getLockState());
        return true;
    };
    return ChangeLockedCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeLockedCommand = ChangeLockedCommand;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ImageInfo_1 = __webpack_require__(40);
var ChangeShapeImageHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeShapeImageHistoryItem, _super);
    function ChangeShapeImageHistoryItem(item, imageUrl) {
        var _this = _super.call(this) || this;
        _this.shapeKey = item.key;
        _this.imageUrl = imageUrl;
        return _this;
    }
    ChangeShapeImageHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        this.oldImage = item.image;
        manipulator.changeShapeImage(item, new ImageInfo_1.ImageInfo(this.imageUrl));
    };
    ChangeShapeImageHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeImage(item, this.oldImage);
    };
    return ChangeShapeImageHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeImageHistoryItem = ChangeShapeImageHistoryItem;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var Event_1 = __webpack_require__(12);
var MouseHandlerDraggingState_1 = __webpack_require__(27);
var DeleteConnectionHistoryItem_1 = __webpack_require__(89);
var AddConnectionHistoryItem_1 = __webpack_require__(36);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(50);
var ModelUtils_1 = __webpack_require__(7);
var MouseHandlerMoveConnectorPointStateBase = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveConnectorPointStateBase, _super);
    function MouseHandlerMoveConnectorPointStateBase(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorPointStateBase.prototype.finish = function () {
        this.handler.resetConnectionTarget();
        this.handler.resetConnectionPoints();
        _super.prototype.finish.call(this);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        if (this.connector) {
            var item = this.connector.getExtremeItem(this.pointPosition);
            this.handler.setConnectionTarget(item, evt.source.type);
            var pointIndex = this.connector.getExtremeConnectionPointIndex(this.pointPosition);
            if (!item && this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition) !== -1)
                item = this.model.findItem(evt.source.key);
            this.handler.setConnectionPoints(item, evt.source.type, pointIndex);
        }
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.layoutPoint);
        if (this.pointPosition !== undefined) {
            var item = this.model.findItem(evt.source.key);
            var connectionPointIndex = -1;
            if (evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint)
                connectionPointIndex = parseInt(evt.source.value);
            if (item && !item.isLocked && (evt.source.type === Event_1.MouseEventElementType.Shape || evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint) &&
                (this.connector.getExtremeItem(this.oppositePointPosition) !== item ||
                    (connectionPointIndex !== -1 && this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition) !== -1 &&
                        connectionPointIndex !== this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition)))) {
                if (this.connector.getExtremeItem(this.pointPosition) !== item ||
                    this.connector.getExtremeConnectionPointIndex(this.pointPosition) !== connectionPointIndex) {
                    if (this.connector.getExtremeItem(this.pointPosition))
                        this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
                    this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, item, connectionPointIndex, this.pointPosition));
                }
                point = item.getConnectionPointPosition(connectionPointIndex, this.connector.points[this.pointIndex + (this.pointPosition === Connector_1.ConnectorPosition.End ? -1 : 1)]);
                this.handler.setConnectionPointIndex(connectionPointIndex);
            }
            else if (this.connector.getExtremeItem(this.pointPosition)) {
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
            }
        }
        this.history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(this.connector.key, this.pointIndex, point));
        ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(this.history, this.model, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.updateConnectorContainer(this.history, this.model, this.connector);
        ModelUtils_1.ModelUtils.removeUnnecessaryConnectorPoints(this.history, this.connector);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.getDraggingElementKeys = function () {
        return this.connector ? [this.connector.key] : [];
    };
    Object.defineProperty(MouseHandlerMoveConnectorPointStateBase.prototype, "oppositePointPosition", {
        get: function () {
            return this.pointPosition === Connector_1.ConnectorPosition.Begin ? Connector_1.ConnectorPosition.End : Connector_1.ConnectorPosition.Begin;
        },
        enumerable: true,
        configurable: true
    });
    return MouseHandlerMoveConnectorPointStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorPointStateBase = MouseHandlerMoveConnectorPointStateBase;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var AddConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(AddConnectorPointHistoryItem, _super);
    function AddConnectorPointHistoryItem(connectorKey, pointIndex, point) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.point = point;
        return _this;
    }
    AddConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.addConnectorPoint(connector, this.pointIndex, this.point.clone());
    };
    AddConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnectorPoint(connector, this.pointIndex);
    };
    return AddConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorPointHistoryItem = AddConnectorPointHistoryItem;


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var MouseHandlerDraggingState_1 = __webpack_require__(27);
var ModelUtils_1 = __webpack_require__(7);
var MouseHandlerMoveShapeStateBase = /** @class */ (function (_super) {
    __extends(MouseHandlerMoveShapeStateBase, _super);
    function MouseHandlerMoveShapeStateBase(handler, history, model, selection) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        return _this;
    }
    MouseHandlerMoveShapeStateBase.prototype.finish = function () {
        this.handler.resetExtensionLines();
        this.handler.resetContainerTarget();
        _super.prototype.finish.call(this);
    };
    MouseHandlerMoveShapeStateBase.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.layoutPoint;
        this.shapes = this.selection.getSelectedShapes(false, true);
        this.connectors = this.selection.getSelectedConnectors(false, true);
        if (this.shapes.length === 0) {
            this.handler.switchToDefaultState();
            return;
        }
        this.startShapePositions = this.shapes.map(function (shape) { return shape.position.clone(); });
        this.startConnectorPoints = this.connectors.map(function (c) { return c.points.map(function (p) { return p.clone(); }); });
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveShapeStateBase.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        this.handler.setExtensionLines(this.selection.getSelectedShapes(false, true));
        var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
        if (container && ModelUtils_1.ModelUtils.canInsertSelectionToContainer(this.model, this.selection, container))
            this.handler.setContainerTarget(container, evt.source.type);
        else
            this.handler.resetContainerTarget();
    };
    MouseHandlerMoveShapeStateBase.prototype.onApplyChanges = function (evt) {
        var _this = this;
        this.shapes.forEach(function (shape, index) {
            var pos = _this.getPosition(evt, _this.startShapePositions[index]);
            ModelUtils_1.ModelUtils.setShapePosition(_this.history, _this.model, shape, pos);
            shape.attachedConnectors.forEach(function (connector) {
                ModelUtils_1.ModelUtils.removeConnectorIntermediatePoints(_this.history, connector);
                ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(_this.history, _this.model, connector);
            });
        });
        this.connectors.forEach(function (connector, index) {
            var delta = _this.startShapePositions[0].offset(-_this.shapes[0].position.x, -_this.shapes[0].position.y);
            if (delta.x !== 0 || delta.y !== 0) {
                var startPtIndex = connector.beginItem ? 1 : 0;
                var endPtIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
                for (var i = startPtIndex; i <= endPtIndex; i++)
                    ModelUtils_1.ModelUtils.setConnectorPoint(_this.history, _this.model, connector, i, _this.startConnectorPoints[index][i].offset(-delta.x, -delta.y));
            }
        });
        var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
        if (container && ModelUtils_1.ModelUtils.canInsertSelectionToContainer(this.model, this.selection, container))
            ModelUtils_1.ModelUtils.insertSelectionToContainer(this.history, this.model, this.selection, container);
        else
            ModelUtils_1.ModelUtils.removeSelectionFromContainer(this.history, this.model, this.selection);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveShapeStateBase.prototype.getDraggingElementKeys = function () {
        return this.shapes.map(function (shape) { return shape.key; });
    };
    MouseHandlerMoveShapeStateBase.prototype.getXPosition = function (evt, baseX) {
        return baseX + evt.layoutPoint.x - this.startPoint.x;
    };
    MouseHandlerMoveShapeStateBase.prototype.getYPosition = function (evt, baseY) {
        return baseY + evt.layoutPoint.y - this.startPoint.y;
    };
    MouseHandlerMoveShapeStateBase.prototype.getPosition = function (evt, basePoint) {
        return new Utils_1.Point(this.handler.getSnappedPos(evt, this.getXPosition(evt, basePoint.x), true), this.handler.getSnappedPos(evt, this.getYPosition(evt, basePoint.y), false));
    };
    return MouseHandlerMoveShapeStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveShapeStateBase = MouseHandlerMoveShapeStateBase;


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MouseHandlerStateBase_1 = __webpack_require__(32);
var Event_1 = __webpack_require__(12);
var KeyCode_1 = __webpack_require__(16);
var MouseHandlerToggleShapeExpandedState_1 = __webpack_require__(272);
var MouseHandlerSelectionState_1 = __webpack_require__(274);
var MouseHandlerZoomOnWheelState_1 = __webpack_require__(276);
var MouseHandlerScrollingState_1 = __webpack_require__(277);
var MouseHandlerDefaultStateBase = /** @class */ (function (_super) {
    __extends(MouseHandlerDefaultStateBase, _super);
    function MouseHandlerDefaultStateBase(handler, history, selection, model, view, settings, bars) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.selection = selection;
        _this.model = model;
        _this.view = view;
        _this.settings = settings;
        _this.bars = bars;
        return _this;
    }
    MouseHandlerDefaultStateBase.prototype.onMouseDown = function (evt) {
        if (evt.modifiers === KeyCode_1.ModifierKey.Ctrl)
            this.startScrolling(evt);
        else if (evt.source.type === Event_1.MouseEventElementType.Shape)
            this.onShapeMouseDown(evt);
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeExpandButton)
            this.onShapeExpandBtnMouseDown(evt);
        else if (evt.source.type === Event_1.MouseEventElementType.Connector)
            this.onConnectorMouseDown(evt);
        else if (evt.isTouch)
            this.startScrolling(evt);
        else
            this.startSelection(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseWheel = function (evt) {
        if (evt.modifiers & KeyCode_1.ModifierKey.Ctrl) {
            this.handler.switchState(new MouseHandlerZoomOnWheelState_1.MouseHandlerZoomOnWheelState(this.handler, this.settings, this.view, this.bars));
            this.handler.state.onMouseWheel(evt);
            return true;
        }
        return false;
    };
    MouseHandlerDefaultStateBase.prototype.onConnectorMouseDown = function (evt) {
        var connectorKey = evt.source.key;
        this.modifySelection(evt, connectorKey);
    };
    MouseHandlerDefaultStateBase.prototype.onShapeExpandBtnMouseDown = function (evt) {
        var shapeKey = evt.source.key;
        this.modifySelection(evt, shapeKey);
        this.handler.switchState(new MouseHandlerToggleShapeExpandedState_1.MouseHandlerToggleShapeExpandedState(this.handler, this.history, this.model));
        this.handler.state.onMouseDown(evt);
    };
    MouseHandlerDefaultStateBase.prototype.startSelection = function (evt) {
        this.handler.switchState(new MouseHandlerSelectionState_1.MouseHandlerSelectionState(this.handler, this.selection));
        this.handler.state.onMouseDown(evt);
    };
    MouseHandlerDefaultStateBase.prototype.startScrolling = function (evt) {
        this.handler.switchState(new MouseHandlerScrollingState_1.MouseHandlerScrollingState(this.handler, this.view, this.selection));
        this.handler.state.onMouseDown(evt);
    };
    MouseHandlerDefaultStateBase.prototype.modifySelection = function (evt, key) {
        if (this.isMultipleSelectionModifier(evt)) {
            if (this.selection.hasKey(key))
                this.selection.remove(key);
            else
                this.selection.add(key);
        }
        else if (!this.selection.hasKey(key))
            this.selection.set([key]);
    };
    MouseHandlerDefaultStateBase.prototype.isMultipleSelectionModifier = function (evt) {
        return evt.modifiers & KeyCode_1.ModifierKey.Ctrl || evt.modifiers & KeyCode_1.ModifierKey.Shift;
    };
    return MouseHandlerDefaultStateBase;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerDefaultStateBase = MouseHandlerDefaultStateBase;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var TargetVisualizerBase = /** @class */ (function () {
    function TargetVisualizerBase(dispatcher) {
        this.dispatcher = dispatcher;
    }
    TargetVisualizerBase.prototype.getKey = function () {
        return this.key;
    };
    TargetVisualizerBase.prototype.setTargetRect = function (key, targetRect) {
        if (this.key !== key) {
            this.key = key;
            this.targetRect = targetRect;
            this.raiseShow();
        }
    };
    TargetVisualizerBase.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.targetRect = undefined;
            this.raiseHide();
        }
    };
    return TargetVisualizerBase;
}());
exports.TargetVisualizerBase = TargetVisualizerBase;


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Evt_1 = __webpack_require__(48);
var Base_1 = __webpack_require__(19);
var DRAGGING_OFFSET = 4;
var TOOLBOX_CSSCLASS = "dxdi-toolbox";
var Toolbox = /** @class */ (function () {
    function Toolbox(parent, readonly, options) {
        this.readonly = readonly;
        this.options = options;
        this.onDragOperation = new Utils_1.EventDispatcher();
        if (!parent)
            return;
        this.mainElement = this.createMainElement(parent);
    }
    Toolbox.prototype.createMainElement = function (parent) {
        var element = document.createElement("div");
        element.setAttribute("class", TOOLBOX_CSSCLASS);
        parent.appendChild(element);
        this.attachHandlers(element);
        return element;
    };
    Toolbox.prototype.attachHandlers = function (element) {
        element.addEventListener("mousedown", this.onMouseDown.bind(this));
        document.addEventListener("mousemove", this.onMouseMove.bind(this));
        document.addEventListener("mouseup", this.onMouseUp.bind(this));
    };
    Toolbox.prototype.render = function (filter) {
        if (this.mainElement.childNodes)
            this.mainElement.innerHTML = "";
        var shapeTypes = filter ? this.options.shapeTypes.filter(filter) : this.options.shapeTypes;
        if (shapeTypes.length)
            this.createElements(this.mainElement, shapeTypes);
        return !!shapeTypes.length;
    };
    Toolbox.prototype.createDraggingObject = function (srcElement) {
        var shapeType = this.getDragShapeType(srcElement);
        if (shapeType !== undefined) {
            var evt = new DiagramDraggingEvent();
            evt.data = shapeType;
            return new ToolboxDraggingObject(evt);
        }
        return undefined;
    };
    Toolbox.prototype.getDragShapeType = function (element) {
        while (element && !Base_1.ElementHasCssClass(element, TOOLBOX_CSSCLASS)) {
            if (element.getAttribute("data-tb-type"))
                return element.getAttribute("data-tb-type");
            element = element.parentNode;
        }
        return undefined;
    };
    Toolbox.prototype.onMouseDown = function (evt) {
        if (this.readonly)
            return;
        this.mouseDownPoint = new Utils_1.Point(evt.pageX, evt.pageY);
        this.draggingObject = this.createDraggingObject(evt.target);
        if (this.draggingObject) {
            this.draggingObject.evt.onFinishDragging = this.finishDragging.bind(this);
            this.draggingObject.evt.onCaptured = this.capture.bind(this);
            this.onDragStart();
        }
        return Evt_1.Evt.PreventEventAndBubble(evt);
    };
    Toolbox.prototype.onMouseMove = function (evt) {
        if (!Evt_1.Evt.IsLeftButtonPressed(evt))
            this.finishDragging();
        else if (this.draggingObject) {
            if (!this.draggingObject.element &&
                (Math.abs(evt.pageX - this.mouseDownPoint.x) > DRAGGING_OFFSET ||
                    Math.abs(evt.pageY - this.mouseDownPoint.y) > DRAGGING_OFFSET)) {
                this.draggingObject.element = this.createDraggingElement(this.draggingObject);
                if (this.draggingObject.captured !== undefined)
                    this.capture(this.draggingObject.captured, true);
            }
            if (this.draggingObject.element)
                this.updateDraggingElementPosition(evt);
        }
    };
    Toolbox.prototype.onMouseUp = function (evt) {
        this.finishDragging();
    };
    Toolbox.prototype.updateDraggingElementPosition = function (evt) {
        var element = this.draggingObject.element;
        var xPos = (evt.pageX - element.offsetWidth / 2);
        var yPos = (evt.pageY - element.offsetHeight / 2);
        Base_1.SetAbsoluteX(element, xPos);
        Base_1.SetAbsoluteY(element, yPos);
    };
    Toolbox.prototype.finishDragging = function () {
        if (this.draggingObject) {
            this.onDragEnd();
            var element = this.draggingObject.element;
            if (element)
                element.parentNode.removeChild(element);
        }
        delete this.draggingObject;
    };
    Toolbox.prototype.capture = function (captured, forced) {
        if (this.draggingObject && (this.draggingObject.captured !== captured || forced)) {
            this.draggingObject.captured = captured;
            if (this.draggingObject.element)
                this.draggingObject.element.classList.toggle("dxdi-tb-drag-captured", captured);
        }
    };
    Toolbox.prototype.onDragEnd = function () {
        this.onDragOperation.raise("notifyToolboxDragEnd");
    };
    Toolbox.prototype.onDragStart = function () {
        this.onDragOperation.raise("notifyToolboxDragStart");
    };
    Toolbox.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.readonly = readOnly;
    };
    return Toolbox;
}());
exports.Toolbox = Toolbox;
var ToolboxDraggingObject = /** @class */ (function () {
    function ToolboxDraggingObject(evt) {
        this.evt = evt;
    }
    return ToolboxDraggingObject;
}());
exports.ToolboxDraggingObject = ToolboxDraggingObject;
var DiagramDraggingEvent = /** @class */ (function () {
    function DiagramDraggingEvent() {
    }
    return DiagramDraggingEvent;
}());
exports.DiagramDraggingEvent = DiagramDraggingEvent;


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ModelUtils_1 = __webpack_require__(7);
var SimpleCommandBase_1 = __webpack_require__(6);
var DeleteCommand = /** @class */ (function (_super) {
    __extends(DeleteCommand, _super);
    function DeleteCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DeleteCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !this.control.selection.isEmpty();
    };
    DeleteCommand.prototype.executeCore = function (state) {
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        return true;
    };
    return DeleteCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.DeleteCommand = DeleteCommand;


/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var MoveShapeHistoryItem = /** @class */ (function (_super) {
    __extends(MoveShapeHistoryItem, _super);
    function MoveShapeHistoryItem(shapeKey, position) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        return _this;
    }
    MoveShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        manipulator.moveShape(shape, this.position);
    };
    MoveShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.moveShape(shape, this.oldPosition);
    };
    return MoveShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveShapeHistoryItem = MoveShapeHistoryItem;


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var StringUtils = /** @class */ (function () {
    function StringUtils() {
    }
    // to compare with ignore case use ~StrUtils.strCompare
    StringUtils.stringCompare = function (a, b) {
        return ((a == b) ? 0 : ((a > b) ? 1 : -1));
    };
    StringUtils.stringHashCode = function (str) {
        var hash = 0;
        if (str.length === 0)
            return hash;
        var strLen = str.length;
        for (var i = 0; i < strLen; i++) {
            hash = ((hash << 5) - hash) + str.charCodeAt(i);
            hash |= 0; // Convert to 32bit integer
        }
        return hash;
    };
    ;
    StringUtils.endsAt = function (str, template) {
        var strInd = str.length - 1;
        var tmplInd = template.length - 1;
        var strStartInd = strInd - tmplInd;
        if (strStartInd < 0)
            return false;
        for (; strInd >= strStartInd; strInd--, tmplInd--)
            if (str[strInd] != template[tmplInd])
                return false;
        return true;
    };
    StringUtils.startsAt = function (str, template) {
        return str.substr(0, template.length) == template;
    };
    StringUtils.stringInLowerCase = function (str) {
        return str.toLowerCase() == str;
    };
    StringUtils.stringInUpperCase = function (str) {
        return str.toUpperCase() == str;
    };
    StringUtils.inStringAtLeastOneSymbolInUpperCase = function (str) {
        for (var i = 0, char; char = str[i]; i++)
            if (StringUtils.stringInUpperCase(char) && !StringUtils.stringInLowerCase(char))
                return true;
        return false;
    };
    StringUtils.getSymbolFromEnd = function (text, posFromEnd) {
        return text[text.length - posFromEnd];
    };
    StringUtils.stringTrim = function (str, trimChars) {
        if (trimChars === void 0) { trimChars = ["\\s"]; }
        var joinedChars = trimChars.join("");
        return str.replace(new RegExp("(^[" + joinedChars + "]*)|([" + joinedChars + "]*$)", 'g'), '');
    };
    StringUtils.stringTrimStart = function (str) {
        return str.replace(/(^\s*)/g, '');
    };
    StringUtils.stringTrimEnd = function (str, trimChar) {
        if (trimChar === void 0) { trimChar = "\\s"; }
        return str.replace(new RegExp(trimChar + "*$"), '');
    };
    //todo and test it
    StringUtils.stringCustomTrim = function (str, trimChars) {
        for (var _i = 0, trimChars_1 = trimChars; _i < trimChars_1.length; _i++) {
            var template = trimChars_1[_i];
            str = str.replace(new RegExp("(^" + template + "*)|(" + template + "*)$", "g"), '');
        }
        return str;
    };
    // mergeStringNTimes("&nbsp;", 1) = "&nbsp;"
    // mergeStringNTimes("&nbsp;", 3) = "&nbsp;&nbsp;&nbsp;"
    StringUtils.mergeStringNTimes = function (str, times) {
        return new Array(times <= 0 ? 0 : times + 1).join(str);
    };
    StringUtils.getDecimalSeparator = function () {
        return (1.1).toLocaleString().substr(1, 1);
    };
    StringUtils.strCompare = function (a, b, ignoreCase) {
        if (ignoreCase === void 0) { ignoreCase = false; }
        if (ignoreCase) {
            a = a.toLowerCase();
            b = b.toLowerCase();
        }
        return ((a == b) ? 0 : ((a > b) ? 1 : -1));
    };
    StringUtils.repeat = function (str, count) {
        var result = "";
        for (var i = 1; i <= count; i++)
            result += str;
        return result;
    };
    StringUtils.isNullOrEmpty = function (str) {
        return !str || !str.length;
    };
    StringUtils.padLeft = function (str, totalWidth, paddingChar) {
        return StringUtils.mergeStringNTimes(paddingChar, Math.max(0, totalWidth - str.length)) + str;
    };
    return StringUtils;
}());
exports.StringUtils = StringUtils;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base_1 = __webpack_require__(19);
var Str = /** @class */ (function () {
    function Str() {
    }
    Str.TrimStart = function (str) {
        return Str.trimInternal(str, true, false);
    };
    Str.TrimEnd = function (str) {
        return Str.trimInternal(str, false, true);
    };
    Str.Trim = function (str) {
        return Str.trimInternal(str, true, true);
    };
    Str.EncodeHtml = function (html) {
        return Str.ApplyReplacement(html, [
            [/&amp;/g, '&ampx;'], [/&/g, '&amp;'],
            [/&quot;/g, '&quotx;'], [/"/g, '&quot;'],
            [/&lt;/g, '&ltx;'], [/</g, '&lt;'],
            [/&gt;/g, '&gtx;'], [/>/g, '&gt;']
        ]);
    };
    Str.trimInternal = function (source, trimStart, trimEnd) {
        var len = source.length;
        if (!len)
            return source;
        if (len < 0xBABA1) { // B181394        
            var result = source;
            if (trimStart) {
                result = result.replace(/^\s+/, "");
            }
            if (trimEnd) {
                result = result.replace(/\s+$/, "");
            }
            return result;
        }
        else {
            var start = 0;
            if (trimEnd) {
                while (len > 0 && Str.whiteSpaces[source.charCodeAt(len - 1)]) {
                    len--;
                }
            }
            if (trimStart && len > 0) {
                while (start < len && Str.whiteSpaces[source.charCodeAt(start)]) {
                    start++;
                }
            }
            return source.substring(start, len);
        }
    };
    Str.ApplyReplacement = function (text, replecementTable) {
        //if (typeof (text) != "string")
        //    text = text.toString();
        for (var i = 0; i < replecementTable.length; i++) {
            var replacement = replecementTable[i];
            text = text.replace(replacement[0], replacement[1]);
        }
        return text;
    };
    Str.DecodeHtmlViaTextArea = function (html) {
        var textArea = document.createElement("TEXTAREA");
        Base_1.setInnerHtmlInternal(textArea, html);
        return textArea.value;
    };
    Str.whiteSpaces = {
        0x0009: 1, 0x000a: 1, 0x000b: 1, 0x000c: 1, 0x000d: 1, 0x0020: 1, 0x0085: 1,
        0x00a0: 1, 0x1680: 1, 0x180e: 1, 0x2000: 1, 0x2001: 1, 0x2002: 1, 0x2003: 1,
        0x2004: 1, 0x2005: 1, 0x2006: 1, 0x2007: 1, 0x2008: 1, 0x2009: 1, 0x200a: 1,
        0x200b: 1, 0x2028: 1, 0x2029: 1, 0x202f: 1, 0x205f: 1, 0x3000: 1
    };
    return Str;
}());
exports.Str = Str;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Browser_1 = __webpack_require__(24);
var Attr = /** @class */ (function () {
    function Attr() {
    }
    Attr.SetAttribute = function (obj, attrName, value) {
        if (obj.setAttribute) {
            if (Attr.isSourceResetRequired() && attrName.toLowerCase() === "src") // T481593
                obj.setAttribute(attrName, "");
            obj.setAttribute(attrName, value);
        }
        else if (obj.setProperty)
            obj.setProperty(attrName, value, "");
    };
    Attr.GetAttribute = function (obj, attrName) {
        if (obj.getAttribute)
            return obj.getAttribute(attrName);
        else if (obj.getPropertyValue) {
            if (Browser_1.Browser.Firefox) { //T644613
                try {
                    return obj.getPropertyValue(attrName);
                }
                catch (e) {
                    return obj[attrName];
                }
            }
            return obj.getPropertyValue(attrName);
        }
        return null;
    };
    Attr.GetTabIndexAttributeName = function () {
        return Browser_1.Browser.IE ? "tabIndex" : "tabindex";
    };
    Attr.ChangeStyleAttribute = function (obj, attrName, newValue) {
        Attr.ChangeAttributeExtended(obj.style, attrName, obj, "saved" + attrName, newValue);
    };
    Attr.ChangeAttributeExtended = function (obj, attrName, savedObj, savedAttrName, newValue) {
        Attr.SaveAttribute(obj, attrName, savedObj, savedAttrName);
        Attr.SetAttribute(obj, attrName, newValue);
    };
    Attr.SaveAttribute = function (obj, attrName, savedObj, savedAttrName) {
        if (!Attr.IsExistsAttribute(savedObj, savedAttrName)) {
            var oldValue = Attr.IsExistsAttribute(obj, attrName) ? Attr.GetAttribute(obj, attrName) : Attr.EmptyObject;
            Attr.SetAttribute(savedObj, savedAttrName, oldValue);
        }
    };
    Attr.RestoreAttributeExtended = function (obj, attrName, savedObj, savedAttrName) {
        if (Attr.IsExistsAttribute(savedObj, savedAttrName)) {
            var oldValue = Attr.GetAttribute(savedObj, savedAttrName);
            if (oldValue != Attr.EmptyObject)
                Attr.SetAttribute(obj, attrName, oldValue);
            else
                Attr.RemoveAttribute(obj, attrName);
            Attr.RemoveAttribute(savedObj, savedAttrName);
            return true;
        }
        return false;
    };
    Attr.RemoveAttribute = function (obj, attrName) {
        if (obj.removeAttribute)
            obj.removeAttribute(attrName);
        else if (obj.removeProperty)
            obj.removeProperty(attrName);
    };
    Attr.IsExistsAttribute = function (obj, attrName) {
        var value = Attr.GetAttribute(obj, attrName);
        return (value != null) && (value !== "");
    };
    Attr.isSourceResetRequired = function () {
        return Browser_1.Browser.IE && Browser_1.Browser.MajorVersion >= 11;
    };
    Attr.EmptyObject = {};
    Attr.RestoreStyleAttribute = function (obj, attrName) {
        return Attr.RestoreAttributeExtended(obj.style, attrName, obj, "saved" + attrName);
    };
    return Attr;
}());
exports.Attr = Attr;


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var Base_1 = __webpack_require__(19);
var NativeScrollView = /** @class */ (function () {
    function NativeScrollView(mainElement) {
        var _this = this;
        this.onScroll = new Utils_1.EventDispatcher();
        this.scrollBarWidth = Base_1.GetVerticalScrollBarWidth();
        this.mainElement = mainElement;
        mainElement.addEventListener("scroll", function () { return _this.onScroll.raise1(function (l) { return l.notifyScrollChanged(); }); });
    }
    NativeScrollView.prototype.setScroll = function (left, top) {
        this.mainElement.style.overflow = "scroll";
        this.mainElement.scrollLeft = left;
        this.mainElement.scrollTop = top;
        this.mainElement.style.overflow = "";
    };
    NativeScrollView.prototype.offsetScroll = function (left, top) {
        if (left)
            this.mainElement.scrollLeft += left;
        if (top)
            this.mainElement.scrollTop += top;
    };
    NativeScrollView.prototype.getScroll = function () {
        return new Utils_1.Point(this.mainElement.scrollLeft, this.mainElement.scrollTop);
    };
    NativeScrollView.prototype.getSize = function () {
        return new Utils_1.Size(this.mainElement.offsetWidth, this.mainElement.offsetHeight);
    };
    NativeScrollView.prototype.getScrollBarWidth = function () {
        return this.scrollBarWidth;
    };
    NativeScrollView.prototype.getScrollSize = function () {
        return new Utils_1.Size(this.mainElement.scrollWidth, this.mainElement.scrollHeight);
    };
    return NativeScrollView;
}());
exports.NativeScrollView = NativeScrollView;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Base_1 = __webpack_require__(19);
var __1 = __webpack_require__(10);
var Utils_1 = __webpack_require__(15);
var Event_1 = __webpack_require__(12);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var Evt_1 = __webpack_require__(48);
var KeyCode_1 = __webpack_require__(16);
var InputManager = /** @class */ (function () {
    function InputManager(parent, mainElement, layoutPointResolver, eventManager, actualZoom) {
        this.mainElement = mainElement;
        this.layoutPointResolver = layoutPointResolver;
        this.eventManager = eventManager;
        this.actualZoom = actualZoom;
        this.focused = false;
        this.focusLocked = false;
        this.createElements(parent);
        document.addEventListener("paste", this.onPaste.bind(this));
    }
    InputManager.prototype.isFocused = function () {
        return this.focused;
    };
    InputManager.prototype.captureFocus = function (selectAll) {
        if (selectAll === void 0) { selectAll = false; }
        this.inputElement.focus({
            preventScroll: true
        });
        if (selectAll) {
            var element = this.inputElement;
            window.setTimeout(function () {
                if (window.getSelection) { // doesn't work in unit tests, see https://github.com/jsdom/jsdom/issues/317
                    var selection = window.getSelection();
                    var range = document.createRange();
                    range.selectNodeContents(element);
                    selection.removeAllRanges();
                    selection.addRange(range);
                }
            }, 100);
        }
    };
    InputManager.prototype.setClipboardData = function (data) {
        this.clipboardInputElement.value = data;
        this.clipboardInputElement.focus({
            preventScroll: true
        });
        this.clipboardInputElement.select();
        document.execCommand('copy');
        this.captureFocus();
    };
    InputManager.prototype.getClipboardData = function (callback) {
        var _this = this;
        if (navigator && navigator["clipboard"]) {
            navigator["clipboard"].readText().then(function (clipText) {
                callback(clipText);
                _this.captureFocus();
            }).catch(function () {
                callback("");
                _this.captureFocus();
            });
        }
        else {
            this.clipboardInputElement.value = "";
            this.clipboardInputElement.focus({
                preventScroll: true
            });
            this.clipboardInputElement.select();
            document.execCommand('Paste');
            callback(this.clipboardInputElement.value);
            this.captureFocus();
        }
    };
    InputManager.prototype.createElements = function (parent) {
        this.createInputElement(parent);
        this.createClipboardInputElement(parent);
        this.setInputElementFocusHandlerMode();
    };
    InputManager.prototype.setInputElementFocusHandlerMode = function () {
        this.inputElementContainer.setAttribute("class", "dxdi-input focus");
    };
    InputManager.prototype.setInputElementTextInputMode = function (text, position, size, style, className) {
        this.inputElementContainer.setAttribute("class", "dxdi-input " + className);
        this.inputElement.innerText = text;
        this.setTextInputElementBounds(position, size);
        this.setTextInputElementStyle(style);
        this.captureFocus(true);
    };
    InputManager.prototype.setTextInputElementBounds = function (position, size) {
        var abs = this.layoutPointResolver.getAbsolutePoint(position);
        size = size && size.transform(__1.UnitConverter.twipsToPixels);
        Base_1.SetAbsoluteX(this.inputElementContainer, Base_1.GetAbsolutePositionX(this.mainElement) + abs.x);
        Base_1.SetAbsoluteY(this.inputElementContainer, Base_1.GetAbsolutePositionY(this.mainElement) + abs.y);
        this.inputElementContainer.style.width = (size !== undefined) ? size.width + "px" : "0px";
        this.inputElementContainer.style.height = (size !== undefined) ? size.height + "px" : "0px";
        this.inputElementContainer.style.transform = "scale(" + this.actualZoom + ")";
        this.inputElement.style.width = (size !== undefined) ? size.width + "px" : "";
        this.inputElement.style.height = (size !== undefined) ? size.height + "px" : "auto";
    };
    InputManager.prototype.setTextInputElementStyle = function (style) {
        Utils_1.RenderUtils.applyStyleToElement(style, this.inputElement);
    };
    InputManager.prototype.createInputElement = function (parent) {
        this.inputElementContainer = document.createElement("div");
        parent.appendChild(this.inputElementContainer);
        this.inputElement = document.createElement("div");
        this.inputElement.setAttribute("contenteditable", "true");
        this.inputElementContainer.appendChild(this.inputElement);
        this.inputElement.addEventListener("blur", this.onInputBlur.bind(this));
        this.inputElement.addEventListener("focus", this.onInputFocus.bind(this));
        this.inputElement.addEventListener("keydown", this.onKeyDown.bind(this));
    };
    InputManager.prototype.createClipboardInputElement = function (parent) {
        this.clipboardInputElement = document.createElement("textarea");
        this.clipboardInputElement.setAttribute("class", "dxdi-clipboard-input");
        parent.appendChild(this.clipboardInputElement);
    };
    InputManager.prototype.onInputBlur = function (evt) {
        var _this = this;
        if (!this.focusLocked) {
            this.focused = false;
            Base_1.RemoveClassNameFromElement(this.mainElement, "focused");
        }
        Utils_1.raiseEvent(evt, this.getDiagramFocusEvent(evt), function (e) { return _this.eventManager.onInputBlur(e); });
    };
    InputManager.prototype.onInputFocus = function (evt) {
        var _this = this;
        this.focused = true;
        this.focusLocked = false;
        Base_1.AddClassNameToElement(this.mainElement, "focused");
        Utils_1.raiseEvent(evt, this.getDiagramFocusEvent(evt), function (e) { return _this.eventManager.onInputFocus(e); });
    };
    InputManager.prototype.onKeyDown = function (evt) {
        var _this = this;
        Utils_1.raiseEvent(evt, this.getDiagramKeyboardEvent(evt), function (e) { return _this.eventManager.onKeyDown(e); });
    };
    InputManager.prototype.getDiagramKeyboardEvent = function (evt) {
        return new Event_1.DiagramKeyboardEvent(KeyCode_1.getKeyModifiers(evt), Evt_1.Evt.GetKeyCode(evt), evt.srcElement.innerText); // TODO: check it
    };
    InputManager.prototype.lockFocus = function () {
        var _this = this;
        this.focusLocked = true;
        setTimeout(function () { return _this.focusLocked = false; }, 10);
    };
    InputManager.prototype.replaceParent = function (parent) {
        if (this.inputElementContainer && this.inputElementContainer.parentNode !== parent)
            parent.appendChild(this.inputElementContainer);
        if (this.clipboardInputElement && this.clipboardInputElement.parentNode !== parent)
            parent.appendChild(this.clipboardInputElement);
    };
    InputManager.prototype.getDiagramFocusEvent = function (evt) {
        return new Event_1.DiagramFocusEvent(evt.target.innerText);
    };
    InputManager.prototype.onPaste = function (evt) {
        var _this = this;
        Utils_1.raiseEvent(evt, this.getDiagramClipboardEvent(evt), function (e) { return _this.eventManager.onPaste(e); });
    };
    InputManager.prototype.getDiagramClipboardEvent = function (evt) {
        var clipboardData;
        if (evt.clipboardData !== undefined)
            clipboardData = evt.clipboardData.getData('text/plain');
        else
            clipboardData = window["clipboardData"].getData('Text');
        return new Event_1.DiagramClipboardEvent(clipboardData);
    };
    InputManager.prototype.notifyViewAdjusted = function (canvasOffset) { };
    InputManager.prototype.notifyActualZoomChanged = function (actualZoom) {
        this.actualZoom = actualZoom;
    };
    InputManager.prototype.notifyTextInputStart = function (item, text, position, size) {
        var className = "";
        if (item instanceof Shape_1.Shape)
            className = "shape-text";
        else if (item instanceof Connector_1.Connector)
            className = "connector-text";
        this.setInputElementTextInputMode(text, position, size, item.styleText, className);
    };
    InputManager.prototype.notifyTextInputEnd = function (item) {
        this.setInputElementFocusHandlerMode();
    };
    return InputManager;
}());
exports.InputManager = InputManager;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = __webpack_require__(10);
var Style_1 = __webpack_require__(37);
var RectaglePrimitive_1 = __webpack_require__(18);
var PathPrimitive_1 = __webpack_require__(2);
var PatternPrimitive_1 = __webpack_require__(129);
var ClipPathPrimitive_1 = __webpack_require__(42);
var CanvasManagerBase_1 = __webpack_require__(33);
var Utils_1 = __webpack_require__(0);
var Utils_2 = __webpack_require__(15);
var GRID_PAGES_LINEWIDTH = 2;
var CanvasPageManager = /** @class */ (function (_super) {
    __extends(CanvasPageManager, _super);
    function CanvasPageManager(parent, settings) {
        var _this = _super.call(this, settings.zoomLevel) || this;
        _this.snapPoint = new Utils_1.Point(0, 0);
        _this.gridPatternId = Utils_2.RenderUtils.generateSvgElementId("gridPattern");
        _this.pagesGridPatternId = Utils_2.RenderUtils.generateSvgElementId("pagesGridPattern");
        _this.pagesGridClipId = Utils_2.RenderUtils.generateSvgElementId("pagesGridClip");
        _this.pageColor = settings.pageColor;
        _this.modelSize = settings.modelSize;
        _this.simpleView = settings.simpleView;
        _this.gridSize = settings.gridSize;
        _this.gridVisible = settings.gridVisible;
        _this.pageSize = settings.pageLandscape ? new Utils_1.Size(settings.pageSize.height, settings.pageSize.width) : settings.pageSize;
        _this.canvasViewOffset = new Utils_1.Point(0, 0);
        _this.initContainers(parent);
        return _this;
    }
    CanvasPageManager.prototype.initContainers = function (parent) {
        this.backgroundContainer = parent;
    };
    CanvasPageManager.prototype.redraw = function () {
        this.redrawPage(this.pageColor);
        this.redrawGrid();
    };
    CanvasPageManager.prototype.redrawPage = function (color) {
        var style = new Style_1.Style();
        style["fill"] = __1.ColorHelper.colorToHash(color);
        this.getOrCreateElement("page-bg", new RectaglePrimitive_1.RectanglePrimitive(0, 0, "100%", "100%", style, "page"), this.backgroundContainer);
        this.createTextFloodFilter("page-bg-textflood-filter", this.backgroundContainer, color);
    };
    CanvasPageManager.prototype.redrawGrid = function () {
        this.updateGridElements(this.gridVisible, __1.UnitConverter.twipsToPixelsF(this.gridSize) * this.actualZoom);
        this.updatePagesGridElements(this.simpleView, this.pageSize.transform(__1.UnitConverter.twipsToPixelsF).multiply(this.actualZoom));
    };
    CanvasPageManager.prototype.getGridRectElement = function (primitive) {
        if (this.gridRectElement === undefined)
            this.gridRectElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridRectElement;
    };
    CanvasPageManager.prototype.getGridPatternElement = function (primitive) {
        if (this.gridPatternElement === undefined)
            this.gridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridPatternElement;
    };
    CanvasPageManager.prototype.updateGridElements = function (visible, absGridSize) {
        var _this = this;
        var gridRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "grid", null, function (element) {
            element.style.setProperty("fill", "url('#" + _this.gridPatternId + "')");
        });
        var rectEl = this.getGridRectElement(gridRectPrimitive);
        if (!visible)
            rectEl.style.display = "none";
        else {
            rectEl.style.display = "";
            this.changePrimitiveElement(gridRectPrimitive, rectEl);
            var sizes = [0, 1, 2, 3, 4].map(function (i) { return Math.round(absGridSize * i); });
            var outerPathCommands = [
                new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[4].toString(), "0"),
                new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[4].toString()),
                new PathPrimitive_1.PathPrimitiveLineToCommand("0", sizes[4].toString())
            ];
            var innerPathCommands = [];
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[i].toString(), "0"));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[i].toString(), sizes[4].toString()));
            }
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand("0", sizes[i].toString()));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[i].toString()));
            }
            var commonSize = absGridSize * 4;
            var canvasViewOffset = this.simpleView ? this.canvasViewOffset : Utils_1.Point.empty();
            var gridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.gridPatternId, [
                new PathPrimitive_1.PathPrimitive(outerPathCommands, null, "grid-outer-line"),
                new PathPrimitive_1.PathPrimitive(innerPathCommands, null, "grid-inner-line")
            ], (((canvasViewOffset.x + this.snapPoint.x) % commonSize - commonSize) % commonSize).toString(), (((canvasViewOffset.y + this.snapPoint.y) % commonSize - commonSize) % commonSize).toString(), commonSize.toString(), commonSize.toString());
            this.changePrimitiveElement(gridPatternPrimitive, this.getGridPatternElement(gridPatternPrimitive));
        }
    };
    CanvasPageManager.prototype.getPagesGridRectElement = function (primitive) {
        return this.getOrCreateElement("grid-pages-rect", primitive, this.backgroundContainer);
    };
    CanvasPageManager.prototype.getPagesGridClipPathElement = function (primitive) {
        if (this.pagesGridClipPathElement === undefined)
            this.pagesGridClipPathElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridClipPathElement;
    };
    CanvasPageManager.prototype.getPagesGridPatternElement = function (primitive) {
        if (this.pagesGridPatternElement === undefined)
            this.pagesGridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridPatternElement;
    };
    CanvasPageManager.prototype.updatePagesGridElements = function (simpleView, pageAbsSize) {
        var _this = this;
        var rectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "grid-page", this.pagesGridClipId, function (element) {
            element.style.setProperty("fill", "url('#" + _this.pagesGridPatternId + "')");
            element.style.setProperty("display", simpleView ? "none" : "");
        });
        this.getPagesGridRectElement(rectPrimitive);
        if (!simpleView) {
            var modelSize = this.modelSize.multiply(this.actualZoom);
            var pageGridPathCommands = [
                new PathPrimitive_1.PathPrimitiveMoveToCommand((pageAbsSize.width - GRID_PAGES_LINEWIDTH / 2).toString(), "0"),
                new PathPrimitive_1.PathPrimitiveLineToCommand((pageAbsSize.width - GRID_PAGES_LINEWIDTH / 2).toString(), (pageAbsSize.height - GRID_PAGES_LINEWIDTH / 2).toString()),
                new PathPrimitive_1.PathPrimitiveLineToCommand("0", (pageAbsSize.height - GRID_PAGES_LINEWIDTH / 2).toString())
            ];
            var pagesGridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.pagesGridPatternId, [
                new PathPrimitive_1.PathPrimitive(pageGridPathCommands, null, "pages-grid-line")
            ], 0, 0, pageAbsSize.width.toString(), pageAbsSize.height.toString());
            this.changePrimitiveElement(pagesGridPatternPrimitive, this.getPagesGridPatternElement(pagesGridPatternPrimitive));
            var pagesGridClipPathPrimitive = new ClipPathPrimitive_1.ClipPathPrimitive(this.pagesGridClipId, [
                new RectaglePrimitive_1.RectanglePrimitive(0, 0, (__1.UnitConverter.twipsToPixelsF(modelSize.width) - GRID_PAGES_LINEWIDTH * 2).toString(), (__1.UnitConverter.twipsToPixelsF(modelSize.height) - GRID_PAGES_LINEWIDTH * 2).toString())
            ]);
            this.changePrimitiveElement(pagesGridClipPathPrimitive, this.getPagesGridClipPathElement(pagesGridClipPathPrimitive));
        }
    };
    CanvasPageManager.prototype.notifyModelSizeChanged = function (size, offset) {
        this.modelSize = size.clone();
        this.redraw();
    };
    CanvasPageManager.prototype.notifyModelRectangleChanged = function (rectangle) { };
    CanvasPageManager.prototype.notifySnapPointPositionChanged = function (point) {
        this.snapPoint = point.transform(__1.UnitConverter.twipsToPixelsF);
        this.redrawGrid();
    };
    CanvasPageManager.prototype.notifyPageColorChanged = function (color) {
        this.pageColor = color;
        this.redrawPage(this.pageColor);
    };
    CanvasPageManager.prototype.notifyModelChanged = function (changes) { };
    CanvasPageManager.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) {
        this.pageSize = pageLandscape ? new Utils_1.Size(pageSize.height, pageSize.width) : pageSize.clone();
        this.redraw();
    };
    CanvasPageManager.prototype.notifyActualZoomChanged = function (actualZoom) {
        this.actualZoom = actualZoom;
        this.redraw();
    };
    CanvasPageManager.prototype.notifyViewAdjusted = function (canvasViewOffset) {
        if (!this.canvasViewOffset.equals(canvasViewOffset)) {
            this.canvasViewOffset = canvasViewOffset;
            if (this.simpleView)
                this.redraw();
        }
    };
    CanvasPageManager.prototype.notifyViewChanged = function (simpleView) {
        this.simpleView = simpleView;
        this.redraw();
    };
    CanvasPageManager.prototype.notifyGridChanged = function (showGrid, gridSize) {
        this.gridVisible = showGrid;
        this.gridSize = gridSize;
        this.redraw();
    };
    return CanvasPageManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasPageManager = CanvasPageManager;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var PatternPrimitive = /** @class */ (function (_super) {
    __extends(PatternPrimitive, _super);
    function PatternPrimitive(id, children, x, y, width, height) {
        var _this = _super.call(this) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.children = children;
        return _this;
    }
    PatternPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "pattern");
    };
    PatternPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        element.setAttribute("patternUnits", "userSpaceOnUse");
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return PatternPrimitive;
}(Primitive_1.SvgPrimitive));
exports.PatternPrimitive = PatternPrimitive;


/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CanvasManagerBase_1 = __webpack_require__(33);
var DiagramSettings_1 = __webpack_require__(41);
var Utils_1 = __webpack_require__(0);
var __1 = __webpack_require__(10);
var GroupPrimitive_1 = __webpack_require__(22);
var ClipPathPrimitive_1 = __webpack_require__(42);
var RectaglePrimitive_1 = __webpack_require__(18);
var Utils_2 = __webpack_require__(15);
var ShadowFilterPrimitive_1 = __webpack_require__(131);
var Style_1 = __webpack_require__(37);
exports.CANVAS_MIN_PADDING = 12;
exports.CROP_OFFSET = 40;
var PAGE_CLIPPATH_ID = "page-clip", PAGE_SHADOW_ID = "page-shadow", DRAG_SCROLL_CSSCLASS = "dxdi-dragging";
var CanvasViewManager = /** @class */ (function (_super) {
    __extends(CanvasViewManager, _super);
    function CanvasViewManager(scroll, svgElement, modelSize, fixedZoomLevel, autoZoom, simpleView, rectangle) {
        var _this = _super.call(this, fixedZoomLevel) || this;
        _this.scroll = scroll;
        _this.svgElement = svgElement;
        _this.paddings = new Utils_1.Offset(0, 0, 0, 0);
        _this.crop = Utils_1.Offset.empty();
        _this.lockAutoZoom = false;
        _this.onViewChanged = new __1.EventDispatcher();
        modelSize = modelSize.transform(__1.UnitConverter.twipsToPixelsF);
        _this.modelSize = modelSize;
        _this.simpleView = simpleView;
        _this.fixedZoomLevel = fixedZoomLevel;
        _this.autoZoom = autoZoom;
        _this.crop = _this.rectangleToCrop(rectangle, modelSize);
        _this.updateElements(modelSize.multiply(fixedZoomLevel), Utils_1.Point.empty(), simpleView); // TODO: remove?
        _this.getOrCreateElement("shadow", new ShadowFilterPrimitive_1.ShadowFilterPrimitive(PAGE_SHADOW_ID), _this.svgElement);
        return _this;
    }
    CanvasViewManager.prototype.update = function (toReset) {
        this.adjust(this.modelSize, this.fixedZoomLevel, this.autoZoom, this.simpleView, this.crop, toReset ? undefined : Utils_1.Offset.empty(), toReset);
    };
    CanvasViewManager.prototype.notifyModelSizeChanged = function (size, offset) {
        size = size.transform(__1.UnitConverter.twipsToPixelsF);
        this.adjust(size, this.fixedZoomLevel, this.autoZoom, this.simpleView, this.crop, offset && offset.transform(__1.UnitConverter.twipsToPixelsF));
        this.modelSize = size;
    };
    CanvasViewManager.prototype.notifyModelRectangleChanged = function (rectangle) {
        var crop = this.rectangleToCrop(rectangle, this.modelSize, this.crop);
        if (!this.crop || !this.crop.equals(crop)) {
            if (this.simpleView)
                this.adjust(this.modelSize, this.fixedZoomLevel, this.autoZoom, this.simpleView, crop, Utils_1.Offset.empty());
            this.crop = crop;
        }
    };
    CanvasViewManager.prototype.notifySnapPointPositionChanged = function (point) { };
    CanvasViewManager.prototype.notifyZoomChanged = function (fixedZoomLevel, autoZoom) {
        this.adjust(this.modelSize, fixedZoomLevel, autoZoom, this.simpleView, this.crop);
        this.fixedZoomLevel = fixedZoomLevel;
        this.autoZoom = autoZoom;
    };
    CanvasViewManager.prototype.notifyViewChanged = function (simpleView) {
        this.adjust(this.modelSize, this.fixedZoomLevel, this.autoZoom, simpleView, this.crop);
        this.simpleView = simpleView;
    };
    CanvasViewManager.prototype.notifyGridChanged = function (showGrid, gridSize) { };
    CanvasViewManager.prototype.notifyDragStart = function (itemKeys) {
        this.lockAutoZoom = true;
    };
    CanvasViewManager.prototype.notifyDragEnd = function (itemKeys) {
        this.lockAutoZoom = false;
        if (this.autoZoom)
            this.update({ horizontal: true, vertical: true });
    };
    CanvasViewManager.prototype.notifyDragScrollStart = function () {
        var className = this.svgElement.getAttribute("class") + " " + DRAG_SCROLL_CSSCLASS;
        this.svgElement.setAttribute("class", className);
    };
    CanvasViewManager.prototype.notifyDragScrollEnd = function () {
        var className = this.svgElement.getAttribute("class").replace(" " + DRAG_SCROLL_CSSCLASS, "");
        this.svgElement.setAttribute("class", className);
    };
    CanvasViewManager.prototype.checkFitToCanvas = function () {
        var scrollSize = this.scroll.getScrollBarWidth();
        var containerSize = this.scroll.getSize().offset(-exports.CANVAS_MIN_PADDING * 2, -exports.CANVAS_MIN_PADDING * 2);
        var modelAbsSize = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop).multiply(this.actualZoom);
        var scrollbars = this.checkScrollBars(containerSize, scrollSize, modelAbsSize, Utils_1.Offset.empty());
        containerSize = containerSize.offset(scrollbars.vertical ? -scrollSize : 0, scrollbars.horizontal ? -scrollSize : 0);
        return {
            vertical: containerSize.height >= modelAbsSize.height,
            horizontal: containerSize.width >= modelAbsSize.width
        };
    };
    CanvasViewManager.prototype.rectangleToCrop = function (rectangle, modelSize, oldCrop) {
        var absRectangle = rectangle.transform(__1.UnitConverter.twipsToPixelsF);
        return new Utils_1.Offset(this.correctCrop(absRectangle.left), this.correctCrop(absRectangle.top), this.correctCrop(modelSize.width - absRectangle.right), this.correctCrop(modelSize.height - absRectangle.bottom));
    };
    CanvasViewManager.prototype.correctCrop = function (newVal) {
        return exports.CROP_OFFSET * Math.floor(newVal / exports.CROP_OFFSET);
    };
    CanvasViewManager.prototype.setActualZoom = function (actualZoom) {
        if (this.actualZoom !== actualZoom) {
            this.actualZoom = actualZoom;
            this.onViewChanged.raise1(function (l) { return l.notifyActualZoomChanged(actualZoom); });
        }
    };
    CanvasViewManager.prototype.getActualAutoZoomLevel = function (autoZoom) {
        if (autoZoom === DiagramSettings_1.AutoZoomMode.Disabled)
            return this.actualZoom;
        var containerSize = this.scroll.getSize();
        var scrollbarWidth = this.scroll.getScrollBarWidth();
        var actualModelSizeWithoutZoom = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop);
        return this.getActualAutoZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom);
    };
    CanvasViewManager.prototype.getActualZoom = function (containerSize, scrollbarWidth, actualModelSizeWithoutZoom, fixedZoom, autoZoom) {
        return this.lockAutoZoom ? this.actualZoom :
            autoZoom === DiagramSettings_1.AutoZoomMode.Disabled ? fixedZoom : this.getActualAutoZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom);
    };
    CanvasViewManager.prototype.getActualAutoZoom = function (containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom) {
        if (autoZoom === DiagramSettings_1.AutoZoomMode.FitContent) {
            return Math.min((containerSize.width - exports.CANVAS_MIN_PADDING * 2) / actualModelSizeWithoutZoom.width, (containerSize.height - exports.CANVAS_MIN_PADDING * 2) / actualModelSizeWithoutZoom.height, 1);
        }
        return Math.min((containerSize.width - exports.CANVAS_MIN_PADDING * 2 - scrollbarWidth) / actualModelSizeWithoutZoom.width, 1);
    };
    CanvasViewManager.prototype.tryNormalizePaddings = function () { };
    CanvasViewManager.prototype.scrollBy = function (offset) {
        var _a, _b, _c;
        var scroll = this.scroll.getScroll();
        var containerSize = this.scroll.getSize();
        var scrollbarWidth = this.scroll.getScrollBarWidth();
        var actualModelSize = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop).multiply(this.actualZoom);
        var scrollbars = this.checkScrollBars(containerSize, scrollbarWidth, actualModelSize, this.paddings);
        var translate = new Utils_1.Point(this.paddings.left, this.paddings.top);
        var tail = new Utils_1.Size(this.paddings.right, this.paddings.bottom);
        (_a = this.changeScrollByOffset(translate, scroll, tail, actualModelSize, offset, containerSize, scrollbars), scroll = _a.scroll, offset = _a.offset);
        (_b = this.changeTranslateByOffset(translate, tail, offset, scrollbars), translate = _b.translate, offset = _b.offset);
        (_c = this.cropHiddenHead(translate, scroll), translate = _c.translate, scroll = _c.scroll);
        tail = this.getTailSpace(translate, scroll, actualModelSize, containerSize, scrollbarWidth);
        this.applyChanges(new Utils_1.Offset(translate.x, translate.y, tail.width, tail.height), actualModelSize, this.simpleView, this.crop, scroll);
        return offset;
    };
    CanvasViewManager.prototype.changeScrollByOffset = function (curTranslate, curScroll, curTail, modelSize, curOffset, containerSize, scrollbars) {
        var scroll = curScroll.clone();
        var offset = curOffset.clone();
        if (curOffset.x && scrollbars.horizontal)
            scroll.x -= (offset.x = -this.getScrollDeltaByOffset(curOffset.x, curScroll.x, curTranslate.x + modelSize.width + curTail.width, containerSize.width, scrollbars.vertical));
        if (curOffset.y && scrollbars.vertical)
            scroll.y -= (offset.y = -this.getScrollDeltaByOffset(curOffset.y, curScroll.y, curTranslate.y + modelSize.height + curTail.height, containerSize.height, scrollbars.horizontal));
        return { scroll: scroll, offset: offset };
    };
    CanvasViewManager.prototype.changeTranslateByOffset = function (curTranslate, curTail, curOffset, scrollbars) {
        var translate = curTranslate.clone();
        var offset = curOffset.clone();
        if (curOffset.x && !scrollbars.horizontal)
            translate.x += (offset.x = this.getTranslateDeltaByOffset(curOffset.x, translate.x, curTail.width));
        if (curOffset.y && !scrollbars.vertical)
            translate.y += (offset.y = this.getTranslateDeltaByOffset(curOffset.y, translate.y, curTail.height));
        return { translate: translate, offset: offset };
    };
    CanvasViewManager.prototype.getScrollDeltaByOffset = function (offset, scroll, commonWidth, containerWidth, hasScrollbar) {
        if (offset > 0)
            return -Math.min(scroll, offset);
        var maxScroll = commonWidth - (containerWidth - (hasScrollbar ? this.scroll.getScrollBarWidth() : 0));
        return Math.min(maxScroll - scroll, -offset);
    };
    CanvasViewManager.prototype.getTranslateDeltaByOffset = function (offset, headPadding, tailPadding) {
        if (!offset)
            return 0;
        return offset < 0 ?
            -Math.min(headPadding - exports.CANVAS_MIN_PADDING, -offset) :
            Math.min(tailPadding - exports.CANVAS_MIN_PADDING, offset);
    };
    CanvasViewManager.prototype.getActualModelSizeWithoutZoom = function (originModelSize, simpleView, crop) {
        return simpleView && crop ? originModelSize.offset(-crop.horizontal, -crop.vertical) : originModelSize;
    };
    CanvasViewManager.prototype.setScrollTo = function (modelPoint, offsetPoint) {
        var containerSize = this.scroll.getSize();
        var shift = this.getVisibileAreaAbsShift();
        var absPoint = modelPoint
            .transform(__1.UnitConverter.twipsToPixelsF)
            .multiply(this.actualZoom)
            .offset(shift.x, shift.y);
        var scroll = this.scroll.getScroll();
        if (!offsetPoint) {
            if (absPoint.x < 0)
                scroll.x += absPoint.x - exports.CANVAS_MIN_PADDING;
            if (absPoint.y < 0)
                scroll.y += absPoint.y - exports.CANVAS_MIN_PADDING;
            if (absPoint.x > containerSize.width)
                scroll.x += (absPoint.x - containerSize.width + exports.CANVAS_MIN_PADDING);
            if (absPoint.y > containerSize.height)
                scroll.y += (absPoint.y - containerSize.height + exports.CANVAS_MIN_PADDING);
        }
        else {
            scroll.x += absPoint.x - offsetPoint.x;
            scroll.y += absPoint.y - offsetPoint.y;
        }
        var modelAbsSize = this.modelSize.multiply(this.actualZoom);
        scroll.x = Math.max(0, Math.min(scroll.x, modelAbsSize.width + this.paddings.horizontal - containerSize.width));
        scroll.y = Math.max(0, Math.min(scroll.y, modelAbsSize.height + this.paddings.vertical - containerSize.height));
        this.scroll.setScroll(scroll.x, scroll.y);
    };
    CanvasViewManager.prototype.updateElements = function (modelAbsSize, translate, simpleView) {
        this.updatePageElement(modelAbsSize, translate, simpleView);
        this.updateCanvasElement(translate);
    };
    CanvasViewManager.prototype.updateCanvasElement = function (translate) {
        this.canvasElement = this.getOrCreateElement("dxdi-main", new GroupPrimitive_1.GroupPrimitive([], "dxdi-main", null, null, function (el) {
            el.setAttribute("transform", "translate(" + Math.round(translate.x) + ", " + Math.round(translate.y) + ")");
        }), this.svgElement);
    };
    CanvasViewManager.prototype.updatePageElement = function (modelAbsSize, translate, simpleView) {
        if (!simpleView) {
            this.getOrCreateElement("pageShadowRect", new RectaglePrimitive_1.RectanglePrimitive(translate.x.toString(), translate.y.toString(), modelAbsSize.width.toString(), modelAbsSize.height.toString(), new Style_1.EmptyStyle({
                "filter": "url(#" + PAGE_SHADOW_ID + ")"
            }), "dxdi-page-shadow"), this.svgElement);
        }
        this.pageElement = this.getOrCreateElement("page", new GroupPrimitive_1.GroupPrimitive([], "dxdi-page", null, !simpleView ? PAGE_CLIPPATH_ID : "", function (el) {
            el.setAttribute("transform", "translate(" + (simpleView ? 0 : Math.round(translate.x)) + ", " + (simpleView ? 0 : Math.round(translate.y)) + ")");
        }), this.svgElement);
        this.getOrCreateElement("pageClip", this.createPageClipPathPrimitive(modelAbsSize), this.svgElement);
    };
    CanvasViewManager.prototype.createPageClipPathPrimitive = function (modelAbsSize) {
        var children = [];
        children.push(new RectaglePrimitive_1.RectanglePrimitive(0, 0, modelAbsSize.width.toString(), modelAbsSize.height.toString()));
        return new ClipPathPrimitive_1.ClipPathPrimitive(PAGE_CLIPPATH_ID, children);
    };
    CanvasViewManager.prototype.adjust = function (newModelSize, fixedZoomLevel, autoZoom, simpleView, crop, offset, toReset) {
        var containerSize = this.scroll.getSize();
        var actualModelSizeWithoutZoom = this.getActualModelSizeWithoutZoom(newModelSize, simpleView, crop);
        if (!this.lockAutoZoom && (autoZoom || !offset || !this.modelSize)) {
            var scrollbarWidth = this.scroll.getScrollBarWidth();
            var actualZoom = this.getActualZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, fixedZoomLevel, autoZoom);
            if (autoZoom && actualZoom === this.actualZoom)
                this.resizeView(actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, crop, offset || Utils_1.Offset.empty());
            else {
                this.resetView(actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, crop, toReset);
                this.setActualZoom(actualZoom);
            }
        }
        else
            this.resizeView(actualModelSizeWithoutZoom, this.actualZoom, containerSize, simpleView, crop, offset);
    };
    CanvasViewManager.prototype.resetView = function (actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, cropWithoutZoom, toReset) {
        var actualModelSize = actualModelSizeWithoutZoom.multiply(actualZoom);
        var paddings = Utils_1.Offset.fromNumber(exports.CANVAS_MIN_PADDING);
        toReset = toReset || { horizontal: true, vertical: true };
        if (!toReset.horizontal && this.paddings) {
            paddings.left = this.paddings.left;
            paddings.right = this.paddings.right;
        }
        if (!toReset.vertical && this.paddings) {
            paddings.top = this.paddings.top;
            paddings.bottom = this.paddings.bottom;
        }
        var scrollbars = this.checkScrollBars(containerSize, this.scroll.getScrollBarWidth(), actualModelSize, paddings);
        var scrollBarWidth = this.scroll.getScrollBarWidth();
        var scroll = this.scroll.getScroll();
        if (toReset.horizontal) {
            var paddingsH = Math.max((containerSize.width - (scrollbars.vertical ? scrollBarWidth : 0) - actualModelSize.width) / 2, exports.CANVAS_MIN_PADDING);
            paddings.left = paddingsH;
            paddings.right = paddingsH;
            scroll.x = 0;
        }
        if (toReset.vertical) {
            var paddingsV = Math.max((containerSize.height - (scrollbars.horizontal ? scrollBarWidth : 0) - actualModelSize.height) / 2, exports.CANVAS_MIN_PADDING);
            paddings.top = paddingsV;
            paddings.bottom = paddingsV;
            scroll.y = 0;
        }
        this.applyChanges(paddings, actualModelSize, simpleView, cropWithoutZoom.multiply(actualZoom), scroll);
    };
    CanvasViewManager.prototype.resizeView = function (actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, cropWithoutZoom, offset) {
        var _a, _b;
        var oldZoom = this.actualZoom;
        var oldCrop = this.simpleView && this.crop ? this.crop.multiply(oldZoom) : Utils_1.Offset.empty();
        var actualModelSize = actualModelSizeWithoutZoom.multiply(actualZoom);
        offset = offset.multiply(actualZoom);
        var newCrop = simpleView && cropWithoutZoom ? cropWithoutZoom.multiply(actualZoom) : Utils_1.Offset.empty();
        var translate = new Utils_1.Point(this.paddings.left, this.paddings.top), scroll = this.scroll.getScroll();
        (_a = this.applyOffset(translate, scroll, oldCrop, newCrop, offset), translate = _a.translate, scroll = _a.scroll);
        (_b = this.cropHiddenHead(translate, scroll), translate = _b.translate, scroll = _b.scroll);
        var tailSpace = this.getTailSpace(translate, scroll, actualModelSize, containerSize, this.scroll.getScrollBarWidth());
        var newPaddings = new Utils_1.Offset(translate.x, translate.y, tailSpace.width, tailSpace.height);
        this.applyChanges(newPaddings, actualModelSize, simpleView, newCrop, scroll);
    };
    CanvasViewManager.prototype.applyChanges = function (paddings, actualModelSize, simpleView, crop, scroll) {
        var translate = new Utils_1.Point(paddings.left, paddings.top);
        if (simpleView && crop)
            translate = translate.offset(-crop.left, -crop.top);
        this.updateElements(actualModelSize, translate, simpleView);
        this.setSvgSize(actualModelSize.width + paddings.horizontal, actualModelSize.height + paddings.vertical);
        this.onViewChanged.raise1(function (l) { return l.notifyViewAdjusted(new Utils_1.Point(translate.x, translate.y)); });
        scroll && this.scroll.setScroll(scroll.x, scroll.y);
        this.paddings = paddings;
    };
    CanvasViewManager.prototype.applyOffset = function (curTranslate, curScroll, oldCrop, newCrop, modelOffset) {
        var translate = curTranslate.clone();
        var scroll = curScroll.clone();
        var offset = this.getActualOffset(oldCrop, newCrop, modelOffset);
        if (offset.left) {
            translate.x = Math.max(exports.CANVAS_MIN_PADDING, translate.x - offset.left);
            scroll.x += offset.left - (curTranslate.x - translate.x);
        }
        if (offset.top) {
            translate.y = Math.max(exports.CANVAS_MIN_PADDING, translate.y - offset.top);
            scroll.y += offset.top - (curTranslate.y - translate.y);
        }
        return { translate: translate, scroll: scroll };
    };
    CanvasViewManager.prototype.cropHiddenHead = function (curTranslate, curScroll) {
        var scroll = curScroll.clone();
        var translate = curTranslate.clone();
        if (scroll.x && translate.x > exports.CANVAS_MIN_PADDING) {
            var delta = translate.x - Math.max(exports.CANVAS_MIN_PADDING, translate.x - scroll.x);
            translate.x -= delta;
            scroll.x -= delta;
        }
        if (scroll.y && translate.y > exports.CANVAS_MIN_PADDING) {
            var delta = translate.y - Math.max(exports.CANVAS_MIN_PADDING, translate.y - scroll.y);
            translate.y -= delta;
            scroll.y -= delta;
        }
        return { translate: translate, scroll: scroll };
    };
    CanvasViewManager.prototype.getTailSpace = function (curTranslate, curScroll, newModelAbsSize, containerSize, scrollbarWidth) {
        var translate = curTranslate.clone();
        var scroll = curScroll.clone();
        var right = Math.max(containerSize.width + scroll.x - (translate.x + newModelAbsSize.width), exports.CANVAS_MIN_PADDING);
        var bottom = Math.max(containerSize.height + scroll.y - (translate.y + newModelAbsSize.height), exports.CANVAS_MIN_PADDING);
        var scrollbars = this.checkScrollBars(containerSize, scrollbarWidth, newModelAbsSize, new Utils_1.Offset(translate.x, translate.y, right, bottom));
        if (scrollbars.vertical)
            right = Math.max(exports.CANVAS_MIN_PADDING, right - scrollbarWidth);
        if (scrollbars.horizontal)
            bottom = Math.max(exports.CANVAS_MIN_PADDING, bottom - scrollbarWidth);
        return new Utils_1.Size(right, bottom);
    };
    CanvasViewManager.prototype.getActualOffset = function (oldCrop, newCrop, docOffset) {
        return new Utils_1.Offset(-(newCrop.left - oldCrop.left) + docOffset.left, -(newCrop.top - oldCrop.top) + docOffset.top, -(newCrop.right - oldCrop.right) + docOffset.right, -(newCrop.bottom - oldCrop.bottom) + docOffset.bottom);
    };
    CanvasViewManager.prototype.checkScrollBars = function (containerSize, scrollBarWidth, modelAbsSize, paddings) {
        var hasHorizontalScroll = containerSize.width < modelAbsSize.width + paddings.horizontal;
        var hasVerticalScroll = containerSize.height < modelAbsSize.height + paddings.vertical;
        if (hasHorizontalScroll && !hasVerticalScroll)
            hasVerticalScroll = containerSize.height - scrollBarWidth < modelAbsSize.height + paddings.vertical;
        if (hasVerticalScroll && !hasHorizontalScroll)
            hasHorizontalScroll = containerSize.width - scrollBarWidth < modelAbsSize.width + paddings.horizontal;
        return { horizontal: hasHorizontalScroll, vertical: hasVerticalScroll };
    };
    CanvasViewManager.prototype.setSvgSize = function (width, height) {
        Utils_2.RenderUtils.updateSvgElementSize(this.svgElement, width, height);
    };
    CanvasViewManager.prototype.getVisibileAreaAbsShift = function () {
        var scroll = this.scroll.getScroll();
        var paddings = this.paddings.clone();
        var simpleView = this.simpleView;
        var cropLeft = simpleView && this.crop ? this.crop.left * this.actualZoom : 0;
        var cropTop = simpleView && this.crop ? this.crop.top * this.actualZoom : 0;
        return new Utils_1.Point(paddings.left - cropLeft - scroll.x, paddings.top - cropTop - scroll.y);
    };
    /* ILayoutPointResolver */
    CanvasViewManager.prototype.getModelPoint = function (absolutePoint, checkScrollArea) {
        var shift = this.getVisibileAreaAbsShift();
        var modelPoint = absolutePoint
            .offset(-shift.x, -shift.y)
            .multiply(1 / this.actualZoom);
        if (checkScrollArea) {
            var scrollSize = this.scroll.getSize();
            if (absolutePoint.x < 0 || absolutePoint.y < 0 || absolutePoint.x > scrollSize.width || absolutePoint.y > scrollSize.height)
                return null;
            if (modelPoint.x < 0 || modelPoint.y < 0)
                return null;
            if (modelPoint.x > this.modelSize.width || modelPoint.y > this.modelSize.height)
                return null;
        }
        return modelPoint.transform(__1.UnitConverter.pixelsToTwips);
    };
    CanvasViewManager.prototype.getAbsolutePoint = function (modelPoint, checkScrollArea) {
        var shift = this.getVisibileAreaAbsShift();
        var absPoint = modelPoint
            .transform(__1.UnitConverter.twipsToPixelsF)
            .multiply(this.actualZoom)
            .offset(shift.x, shift.y);
        if (checkScrollArea) {
            if (absPoint.x < 0 || absPoint.y < 0)
                return null;
            var scrollSize = this.scroll.getSize();
            if (absPoint.x > scrollSize.width || absPoint.y > scrollSize.height)
                return null;
        }
        return absPoint;
    };
    return CanvasViewManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasViewManager = CanvasViewManager;


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var FilterPrimitive_1 = __webpack_require__(85);
var RenderManager_1 = __webpack_require__(11);
var ShadowFilterPrimitive = /** @class */ (function (_super) {
    __extends(ShadowFilterPrimitive, _super);
    function ShadowFilterPrimitive() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ShadowFilterPrimitive.prototype.createChildElements = function (parent) {
        var feGaussianBlur = document.createElementNS(RenderManager_1.svgNS, "feGaussianBlur");
        feGaussianBlur.setAttribute("in", "SourceGraphic");
        feGaussianBlur.setAttribute("stdDeviation", "4.6");
        parent.appendChild(feGaussianBlur);
        var feOffset = document.createElementNS(RenderManager_1.svgNS, "feOffset");
        feOffset.setAttribute("dx", "0");
        feOffset.setAttribute("dy", "0");
        parent.appendChild(feOffset);
        var feMerge = document.createElementNS(RenderManager_1.svgNS, "feMerge");
        parent.appendChild(feMerge);
        var feMergeNode1 = document.createElementNS(RenderManager_1.svgNS, "feMergeNode");
        feMerge.appendChild(feMergeNode1);
        var feMergeNode2 = document.createElementNS(RenderManager_1.svgNS, "feMergeNode");
        feMergeNode2.setAttribute("in", "SourceGraphic");
        feMerge.appendChild(feMergeNode2);
    };
    return ShadowFilterPrimitive;
}(FilterPrimitive_1.FilterPrimitive));
exports.ShadowFilterPrimitive = ShadowFilterPrimitive;


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var CanvasManagerBase_1 = __webpack_require__(33);
var GroupPrimitive_1 = __webpack_require__(22);
var Utils_1 = __webpack_require__(15);
var Event_1 = __webpack_require__(12);
var DiagramItem_1 = __webpack_require__(4);
var CanvasItemsManager_1 = __webpack_require__(39);
var Utils_2 = __webpack_require__(0);
var ExtensionLinesVisualizer_1 = __webpack_require__(87);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var ConnectorProperties_1 = __webpack_require__(25);
var RectaglePrimitive_1 = __webpack_require__(18);
var PathPrimitive_1 = __webpack_require__(2);
var TextPrimitive_1 = __webpack_require__(63);
var MaskPrimitive_1 = __webpack_require__(133);
var TextFilterPrimitive_1 = __webpack_require__(84);
var EllipsePrimitive_1 = __webpack_require__(29);
var LinePrimitive_1 = __webpack_require__(80);
var MULTIPLE_SELECTION_KEY = "-1";
exports.SELECTION_ELEMENT_CLASSNAMES = {
    SELECTION_RECTANGLE: "selection-rect",
    CONNECTION_POINT: "connection-point",
    ACTIVE: "active",
    CONTAINER_TARGET: "container-target",
    CONNECTION_TARGET: "connection-target",
    EXTENSION_LINE: "extension-line",
    CONNECTION_MARK: "connection-mark",
    SELECTION_MARK: "selection-mark",
    LOCKED_SELECTION_MARK: "locked-selection-mark",
    ITEMS_SELECTION_RECT: "items-selection-rect",
    CONNECTOR_MULTI_SELECTION: "connector-multi-selection",
    CONNECTOR_SELECTION: "connector-selection",
    CONNECTOR_POINT_MARK: "connector-point-mark",
    CONNECTOR_SELECTION_MASK: "connector-selection-mask",
    CONNECTOR_SIDE_MARK: "connector-side-mark",
    ITEM_SELECTION_RECT: "item-selection-rect",
    ITEM_MULTI_SELECTION: "item-multi-selection-rect"
};
var CanvasSelectionManager = /** @class */ (function (_super) {
    __extends(CanvasSelectionManager, _super);
    function CanvasSelectionManager(parent, zoomLevel, readOnly) {
        var _this = _super.call(this, zoomLevel) || this;
        _this.readOnly = readOnly;
        _this.connectionPointElements = [];
        _this.connectionMarkElements = [];
        _this.extensionLineElements = [];
        _this.selectionMap = {};
        _this.initializeContainerElements(parent);
        return _this;
    }
    CanvasSelectionManager.prototype.initializeContainerElements = function (parent) {
        this.itemSelectionContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), parent);
        this.visualizersContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), parent);
        this.selectionMarksContainer = this.createAndChangePrimitiveElement(new GroupPrimitive_1.GroupPrimitive([], null), parent);
    };
    CanvasSelectionManager.prototype.clear = function () {
        Utils_1.RenderUtils.removeContent(this.itemSelectionContainer);
        Utils_1.RenderUtils.removeContent(this.selectionMarksContainer);
        Utils_1.RenderUtils.removeContent(this.visualizersContainer);
        this.selectionRectElement = undefined;
        this.resizeInfoElement = undefined;
        this.connectionPointElements = [];
        this.connectionTargetElement = undefined;
        this.containerTargetElement = undefined;
        this.connectionMarkElements = [];
        this.extensionLineElements = [];
        this.selectionMap = {};
    };
    CanvasSelectionManager.prototype.showSelectionRect = function (rect) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(rect.left, rect.top, rect.size.width, rect.size.height, null, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_RECTANGLE);
        var rectEl = this.getSelectionRectElement(primitive);
        this.changePrimitiveElement(primitive, rectEl);
    };
    CanvasSelectionManager.prototype.hideSelectionRect = function () {
        if (this.selectionRectElement !== undefined)
            this.selectionRectElement.style.display = "none";
    };
    CanvasSelectionManager.prototype.getSelectionRectElement = function (primitive) {
        if (this.selectionRectElement !== undefined)
            this.selectionRectElement.style.display = "";
        else
            this.selectionRectElement = this.createPrimitiveElement(primitive, this.visualizersContainer);
        return this.selectionRectElement;
    };
    CanvasSelectionManager.prototype.showResizeInfo = function (point, text) {
        var rectPrimitive = new RectaglePrimitive_1.RectanglePrimitive(point.x, point.y, 0, 0);
        var primitive = new GroupPrimitive_1.GroupPrimitive([
            rectPrimitive,
            new TextPrimitive_1.TextPrimitive(point.x, point.y, text)
        ], "resize-info");
        var groupEl = this.getResizeInfoElement(primitive);
        this.changePrimitiveElement(primitive, groupEl);
        var textRect = Utils_1.RenderUtils.getSvgTextRectangle(groupEl.childNodes[1], CanvasItemsManager_1.CanvasItemsManager.resizeInfoLineWidth)
            .inflate(CanvasItemsManager_1.CanvasItemsManager.resizeInfoTextOffset, CanvasItemsManager_1.CanvasItemsManager.resizeInfoTextOffset);
        rectPrimitive.x = textRect.left;
        rectPrimitive.y = textRect.top;
        rectPrimitive.width = textRect.width;
        rectPrimitive.height = textRect.height;
        this.changePrimitiveElement(primitive, groupEl);
    };
    CanvasSelectionManager.prototype.hideResizeInfo = function () {
        if (this.resizeInfoElement !== undefined)
            this.resizeInfoElement.style.display = "none";
    };
    CanvasSelectionManager.prototype.getResizeInfoElement = function (primitive) {
        if (this.resizeInfoElement !== undefined)
            this.resizeInfoElement.style.display = "";
        else
            this.resizeInfoElement = this.createPrimitiveElement(primitive, this.visualizersContainer);
        return this.resizeInfoElement;
    };
    CanvasSelectionManager.prototype.showConnectionPoint = function (index, point, side, key, value, active) {
        this.showConnectionPointCore(index * 2, point.x, point.y, CanvasItemsManager_1.CanvasItemsManager.connectionPointLargeSize, CanvasItemsManager_1.CanvasItemsManager.connectionPointLargeSize, Event_1.MouseEventElementType.ShapeConnectionPoint, key, value, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTION_POINT + " selector");
        this.showConnectionPointCore(index * 2 + 1, point.x, point.y, CanvasItemsManager_1.CanvasItemsManager.connectionPointSmallSize, CanvasItemsManager_1.CanvasItemsManager.connectionPointSmallSize, Event_1.MouseEventElementType.ShapeConnectionPoint, key, value, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTION_POINT + (active ? (" " + exports.SELECTION_ELEMENT_CLASSNAMES.ACTIVE) : ""));
    };
    CanvasSelectionManager.prototype.showConnectionPointCore = function (index, cx, cy, rx, ry, type, key, value, className) {
        var primitive = new EllipsePrimitive_1.EllipsePrimitive(cx, cy, rx, ry, null, className);
        var ellEl = this.getConnectionPointElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_1.RenderUtils.setElementEventData(ellEl, type, key, value);
    };
    CanvasSelectionManager.prototype.hideConnectionPoints = function () {
        for (var i = 0; i < this.connectionPointElements.length; i++)
            this.connectionPointElements[i].style.display = "none";
    };
    CanvasSelectionManager.prototype.getConnectionPointElement = function (primitive, index) {
        var ellEl = this.connectionPointElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.connectionPointElements[index] = ellEl;
        }
        return ellEl;
    };
    CanvasSelectionManager.prototype.showContainerTarget = function (index, targetRect) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(targetRect.left, targetRect.top, targetRect.width, targetRect.height, null, exports.SELECTION_ELEMENT_CLASSNAMES.CONTAINER_TARGET);
        var rectEl = this.getContainerTargetElement(primitive, index);
        this.changePrimitiveElement(primitive, rectEl);
    };
    CanvasSelectionManager.prototype.hideContainerTarget = function () {
        if (this.containerTargetElement)
            this.containerTargetElement.style.display = "none";
    };
    CanvasSelectionManager.prototype.getContainerTargetElement = function (primitive, index) {
        if (this.containerTargetElement !== undefined)
            this.containerTargetElement.style.display = "";
        else {
            this.containerTargetElement = this.createPrimitiveElement(primitive, this.itemSelectionContainer);
        }
        return this.containerTargetElement;
    };
    CanvasSelectionManager.prototype.showConnectionTarget = function (index, targetRect) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(targetRect.left, targetRect.top, targetRect.width, targetRect.height, null, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTION_TARGET);
        var rectEl = this.getConnectionTargetElement(primitive, index);
        this.changePrimitiveElement(primitive, rectEl);
    };
    CanvasSelectionManager.prototype.hideConnectionTarget = function () {
        if (this.connectionTargetElement)
            this.connectionTargetElement.style.display = "none";
    };
    CanvasSelectionManager.prototype.getConnectionTargetElement = function (primitive, index) {
        if (this.connectionTargetElement !== undefined)
            this.connectionTargetElement.style.display = "";
        else {
            this.connectionTargetElement = this.createPrimitiveElement(primitive, this.itemSelectionContainer);
        }
        return this.connectionTargetElement;
    };
    CanvasSelectionManager.prototype.showConnectionMark = function (index, point, side, key, value, active) {
        this.showConnectionMarkSelector(index * 2, point.x - CanvasItemsManager_1.CanvasItemsManager.connectionMarkLargeSize / 2, point.y - CanvasItemsManager_1.CanvasItemsManager.connectionMarkLargeSize / 2, CanvasItemsManager_1.CanvasItemsManager.connectionMarkLargeSize, CanvasItemsManager_1.CanvasItemsManager.connectionMarkLargeSize, Event_1.MouseEventElementType.ShapeConnection, key, value, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTION_MARK + " selector");
        this.showConnectionMarkArrow(index * 2 + 1, point.x - CanvasItemsManager_1.CanvasItemsManager.connectionMarkSmallSize / 2, point.y - CanvasItemsManager_1.CanvasItemsManager.connectionMarkSmallSize / 2, CanvasItemsManager_1.CanvasItemsManager.connectionMarkSmallSize, CanvasItemsManager_1.CanvasItemsManager.connectionMarkSmallSize, side, Event_1.MouseEventElementType.ShapeConnection, key, value, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTION_MARK + (active ? (" " + exports.SELECTION_ELEMENT_CLASSNAMES.ACTIVE) : ""));
    };
    CanvasSelectionManager.prototype.showConnectionMarkArrow = function (index, x, y, width, height, side, type, key, value, className) {
        var pathCommands = [];
        switch (side) {
            case DiagramItem_1.ConnectionPointSide.East:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height * 2 / 3),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.South:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width * 2 / 3, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                pathCommands = [
                    new PathPrimitive_1.PathPrimitiveMoveToCommand(x + width / 3, y + height),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width / 2, y),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height / 2),
                    new PathPrimitive_1.PathPrimitiveLineToCommand(x + width * 2 / 3, y + height),
                    new PathPrimitive_1.PathPrimitiveClosePathCommand()
                ];
                break;
        }
        var primitive = new PathPrimitive_1.PathPrimitive(pathCommands, null, className);
        var ellEl = this.getConnectionMarkElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_1.RenderUtils.setElementEventData(ellEl, Event_1.MouseEventElementType.ShapeConnection, key, value);
    };
    CanvasSelectionManager.prototype.showConnectionMarkSelector = function (index, x, y, width, height, type, key, value, className) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(x, y, width, height, null, className);
        var ellEl = this.getConnectionMarkElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
        Utils_1.RenderUtils.setElementEventData(ellEl, Event_1.MouseEventElementType.ShapeConnection, key, value);
    };
    CanvasSelectionManager.prototype.hideConnectionMarks = function () {
        for (var i = 0; i < this.connectionMarkElements.length; i++)
            this.connectionMarkElements[i].style.display = "none";
    };
    CanvasSelectionManager.prototype.getConnectionMarkElement = function (primitive, index) {
        var ellEl = this.connectionMarkElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.connectionMarkElements[index] = ellEl;
        }
        return ellEl;
    };
    CanvasSelectionManager.prototype.showExtensionLine = function (index, type, startPoint, endPoint, text) {
        var className = exports.SELECTION_ELEMENT_CLASSNAMES.EXTENSION_LINE;
        if (type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterAfter || type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterBefore ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterAbove || type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterBelow)
            className += " center";
        if (type === ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterToPageCenter ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.LeftToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.RightToPageCenter ||
            type === ExtensionLinesVisualizer_1.ExtensionLineType.TopToPageCenter || type === ExtensionLinesVisualizer_1.ExtensionLineType.BottomToPageCenter)
            className += " page";
        var x1_1 = 0, y1_1 = 0, x1_2 = 0, y1_2 = 0, x2_1 = 0, y2_1 = 0, x2_2 = 0, y2_2 = 0;
        if (startPoint.y === endPoint.y) {
            x1_1 = startPoint.x;
            y1_1 = startPoint.y - CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            x1_2 = startPoint.x;
            y1_2 = startPoint.y + CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            x2_1 = endPoint.x;
            y2_1 = startPoint.y - CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            x2_2 = endPoint.x;
            y2_2 = startPoint.y + CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
        }
        else if (startPoint.x === endPoint.x) {
            x1_1 = startPoint.x - CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            y1_1 = startPoint.y;
            x1_2 = startPoint.x + CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            y1_2 = startPoint.y;
            x2_1 = startPoint.x - CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            y2_1 = endPoint.y;
            x2_2 = startPoint.x + CanvasItemsManager_1.CanvasItemsManager.extensionLineEndingSize;
            y2_2 = endPoint.y;
        }
        var linePrimitives = [
            new LinePrimitive_1.LinePrimitive(startPoint.x, startPoint.y, endPoint.x, endPoint.y),
            new LinePrimitive_1.LinePrimitive(x1_1, y1_1, x1_2, y1_2),
            new LinePrimitive_1.LinePrimitive(x2_1, y2_1, x2_2, y2_2),
            new TextPrimitive_1.TextPrimitive((endPoint.x + startPoint.x) / 2, (endPoint.y + startPoint.y) / 2, text, undefined, null, false, null, CanvasManagerBase_1.PAGE_BG_TEXTFLOOR_FILTER_ID, false, function (el) {
                el.style.display = text && text !== "" ? "inherit" : "none";
            })
        ];
        var primitive = new GroupPrimitive_1.GroupPrimitive(linePrimitives, className);
        var ellEl = this.getExtensionLineElement(primitive, index);
        this.changePrimitiveElement(primitive, ellEl);
    };
    CanvasSelectionManager.prototype.hideExtensionLines = function () {
        for (var i = 0; i < this.extensionLineElements.length; i++) {
            if (this.extensionLineElements[i])
                this.extensionLineElements[i].style.display = "none";
        }
    };
    CanvasSelectionManager.prototype.getExtensionLineElement = function (primitive, index) {
        var ellEl = this.extensionLineElements[index];
        if (ellEl !== undefined)
            ellEl.style.display = "";
        else {
            ellEl = this.createPrimitiveElement(primitive, this.visualizersContainer);
            this.extensionLineElements[index] = (ellEl);
        }
        return ellEl;
    };
    CanvasSelectionManager.prototype.getOrCreateShapeSelection = function (shape, usedItems) {
        var element = this.selectionMap[shape.key];
        if (!element) {
            element = new ShapeSelectionElement(this.itemSelectionContainer, this.selectionMarksContainer, this.actualZoom, this.readOnly, shape.key, shape.isLocked, shape.rectangle, shape.allowResizeHorizontally, shape.allowResizeVertically, shape.description.getParameterPoints(shape));
            this.selectionMap[shape.key] = element;
        }
        usedItems && (usedItems[shape.key] = true);
        return element;
    };
    CanvasSelectionManager.prototype.getOrCreateConnectorSelection = function (connector, usedItems) {
        var element = this.selectionMap[connector.key];
        if (!element) {
            element = new ConnectorSelectionElement(this.itemSelectionContainer, this.selectionMarksContainer, this.actualZoom, this.readOnly, connector.key, connector.isLocked, connector.rectangle, connector.getRenderPoints(), connector.styleText, connector.enableText, connector.texts.map(function (t) {
                return {
                    text: connector.getText(t.position),
                    point: connector.getTextPoint(t.position)
                };
            }), connector.points, connector.properties.lineOption);
            this.selectionMap[connector.key] = element;
        }
        usedItems && (usedItems[connector.key] = true);
        return element;
    };
    CanvasSelectionManager.prototype.getOrCreateMultipleSelection = function (usedItems) {
        var element = this.selectionMap[MULTIPLE_SELECTION_KEY];
        if (!element) {
            element = new MultipleSelectionElement(this.itemSelectionContainer, this.selectionMarksContainer, this.actualZoom, this.readOnly);
            this.selectionMap[MULTIPLE_SELECTION_KEY] = element;
        }
        usedItems[MULTIPLE_SELECTION_KEY] = true;
        return element;
    };
    CanvasSelectionManager.prototype.getMultipleSelection = function () {
        return this.selectionMap[MULTIPLE_SELECTION_KEY];
    };
    CanvasSelectionManager.prototype.updateShapeSelection = function (shape, multipleSelection) {
        if (shape.key in this.selectionMap) {
            var rect = shape.rectangle;
            this.getOrCreateShapeSelection(shape)
                .onModelChanged(shape.isLocked, rect, shape.allowResizeHorizontally, shape.allowResizeVertically, shape.description.getParameterPoints(shape));
            multipleSelection && multipleSelection.onModelItemChanged(shape.key, rect);
        }
    };
    CanvasSelectionManager.prototype.updateConnectorSelection = function (connector, multipleSelection) {
        if (connector.key in this.selectionMap) {
            var rect = connector.rectangle;
            this.getOrCreateConnectorSelection(connector)
                .onModelChanged(connector.isLocked, rect, connector.getRenderPoints(), connector.styleText, connector.enableText, connector.texts.map(function (t) {
                return {
                    text: connector.getText(t.position),
                    point: connector.getTextPoint(t.position)
                };
            }), connector.points, connector.properties.lineOption);
            multipleSelection && multipleSelection.onModelItemChanged(connector.key, rect);
        }
    };
    CanvasSelectionManager.prototype.hideOutdatedSelection = function (updated) {
        var _this = this;
        Object.keys(this.selectionMap)
            .filter(function (k) { return !updated[k]; })
            .forEach(function (k) {
            _this.selectionMap[k].destroy();
            delete _this.selectionMap[k];
        });
    };
    CanvasSelectionManager.prototype.notifySelectionChanged = function (selection) {
        var _this = this;
        var items = selection.getSelectedItems(true);
        var changedItems = {};
        var isMultipleSelection = items.length > 1;
        var shapes = selection.getSelectedShapes(true);
        var connectors = selection.getSelectedConnectors(true);
        shapes.forEach(function (shape) { return _this.getOrCreateShapeSelection(shape, changedItems).onSelectionChanged(isMultipleSelection); });
        connectors.forEach(function (connector) { return _this.getOrCreateConnectorSelection(connector, changedItems).onSelectionChanged(isMultipleSelection); });
        if (isMultipleSelection)
            this.getOrCreateMultipleSelection(changedItems).onSelectionChanged(!!shapes.length, items.filter(function (item) { return item.isVisible; }));
        this.hideOutdatedSelection(changedItems);
    };
    CanvasSelectionManager.prototype.notifyModelChanged = function (changes) {
        var _this = this;
        var multipleSelection = this.getMultipleSelection();
        changes.forEach(function (change) {
            if (change.item instanceof Shape_1.Shape)
                _this.updateShapeSelection(change.item, multipleSelection);
            else if (change.item instanceof Connector_1.Connector)
                _this.updateConnectorSelection(change.item, multipleSelection);
        });
        multipleSelection && multipleSelection.onModelChanged();
    };
    CanvasSelectionManager.prototype.notifyPageColorChanged = function (color) { };
    CanvasSelectionManager.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) { };
    CanvasSelectionManager.prototype.notifyActualZoomChanged = function (actualZoom) {
        var _this = this;
        Object.keys(this.selectionMap).forEach(function (k) { return _this.selectionMap[k].notifyZoomChanged(actualZoom); });
        this.actualZoom = actualZoom;
    };
    CanvasSelectionManager.prototype.notifyViewAdjusted = function (canvasOffset) { };
    CanvasSelectionManager.prototype.notifyReadOnlyChanged = function (readOnly) {
        var _this = this;
        this.readOnly = readOnly;
        Object.keys(this.selectionMap).forEach(function (k) { return _this.selectionMap[k].notifyReadOnlyChanged(readOnly); });
    };
    CanvasSelectionManager.prototype.notifySelectionRectShow = function (rect) {
        this.showSelectionRect(rect.multiply(this.actualZoom));
    };
    CanvasSelectionManager.prototype.notifySelectionRectHide = function () {
        this.hideSelectionRect();
    };
    CanvasSelectionManager.prototype.notifyResizeInfoShow = function (point, text) {
        this.showResizeInfo(point.multiply(this.actualZoom), text);
    };
    CanvasSelectionManager.prototype.notifyResizeInfoHide = function () {
        this.hideResizeInfo();
    };
    CanvasSelectionManager.prototype.notifyConnectionPointsShow = function (key, points, activePointIndex) {
        var _this = this;
        points.forEach(function (p, index) {
            _this.showConnectionPoint(index, p.point.multiply(_this.actualZoom), p.side, key, index, index === activePointIndex);
        });
    };
    CanvasSelectionManager.prototype.notifyConnectionPointsHide = function () {
        this.hideConnectionPoints();
    };
    CanvasSelectionManager.prototype.notifyConnectionMarksShow = function (key, points, activePointIndex) {
        var _this = this;
        points.forEach(function (p, index) {
            var point = p.point.multiply(_this.actualZoom);
            switch (p.side) {
                case DiagramItem_1.ConnectionPointSide.North:
                    point.y -= CanvasItemsManager_1.CanvasItemsManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.South:
                    point.y += CanvasItemsManager_1.CanvasItemsManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.East:
                    point.x += CanvasItemsManager_1.CanvasItemsManager.connectionMarkShift;
                    break;
                case DiagramItem_1.ConnectionPointSide.West:
                    point.x -= CanvasItemsManager_1.CanvasItemsManager.connectionMarkShift;
                    break;
            }
            _this.showConnectionMark(index, point, p.side, key, index, index === activePointIndex);
        });
    };
    CanvasSelectionManager.prototype.notifyConnectionMarksHide = function () {
        this.hideConnectionMarks();
    };
    CanvasSelectionManager.prototype.notifyConnectionTargetShow = function (key, targetRect) {
        var rect = CanvasSelectionManager.correctShapeSelectionRect(targetRect.multiply(this.actualZoom), CanvasItemsManager_1.CanvasItemsManager.connectionTargetBorderWidth, this.actualZoom);
        this.showConnectionTarget(0, rect);
    };
    CanvasSelectionManager.prototype.notifyConnectionTargetHide = function () {
        this.hideConnectionTarget();
    };
    CanvasSelectionManager.prototype.notifyContainerTargetShow = function (key, targetRect) {
        var rect = CanvasSelectionManager.correctShapeSelectionRect(targetRect.multiply(this.actualZoom), CanvasItemsManager_1.CanvasItemsManager.connectionTargetBorderWidth, this.actualZoom);
        this.showContainerTarget(0, rect);
    };
    CanvasSelectionManager.prototype.notifyContainerTargetHide = function () {
        this.hideContainerTarget();
    };
    CanvasSelectionManager.prototype.notifyExtensionLinesShow = function (lines) {
        var _this = this;
        this.hideExtensionLines();
        lines.forEach(function (line, index) {
            _this.showExtensionLine(index, line.type, line.segment.startPoint.multiply(_this.actualZoom), line.segment.endPoint.multiply(_this.actualZoom), line.text);
        });
    };
    CanvasSelectionManager.prototype.notifyExtensionLinesHide = function () {
        this.hideExtensionLines();
    };
    CanvasSelectionManager.prototype.notifyDragStart = function (itemKeys) {
        this.selectionMarksContainer.style.display = "none";
    };
    CanvasSelectionManager.prototype.notifyDragEnd = function (itemKeys) {
        this.selectionMarksContainer.style.display = "";
    };
    CanvasSelectionManager.prototype.notifyDragScrollStart = function () { };
    CanvasSelectionManager.prototype.notifyDragScrollEnd = function () { };
    CanvasSelectionManager.prototype.notifyTextInputStart = function (item, text, position, size) {
        this.visualizersContainer.style.display = "none";
    };
    CanvasSelectionManager.prototype.notifyTextInputEnd = function (item) {
        this.visualizersContainer.style.display = "";
    };
    CanvasSelectionManager.correctShapeSelectionRect = function (rect, lineWidth, zoomLevel) {
        var corr = Math.ceil(Shape_1.Shape.lineWidth / 2 * zoomLevel);
        rect = rect.inflate(corr, corr);
        var lwCorr = Math.floor(lineWidth / 2);
        rect.position.x -= lwCorr;
        rect.position.y -= lwCorr;
        rect.size.width += lineWidth;
        rect.size.height += lineWidth;
        return rect;
    };
    return CanvasSelectionManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasSelectionManager = CanvasSelectionManager;
var CanvasElement = /** @class */ (function () {
    function CanvasElement(rectsContainer, marksContainer, key, zoomLevel, readOnly) {
        this.rectsContainer = rectsContainer;
        this.marksContainer = marksContainer;
        this.key = key;
        this.zoomLevel = zoomLevel;
        this.readOnly = readOnly;
        this.elements = {};
        this.updatedElements = {};
    }
    CanvasElement.prototype.notifyZoomChanged = function (zoom) {
        if (this.zoomLevel !== zoom) {
            this.zoomLevel = zoom;
            this.redraw();
        }
    };
    CanvasElement.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.readOnly = readOnly;
        this.redraw();
    };
    CanvasElement.prototype.destroy = function () {
        var _this = this;
        Object.keys(this.elements)
            .forEach(function (key) {
            _this.elements[key].parentNode.removeChild(_this.elements[key]);
            delete _this.elements[key];
        });
    };
    CanvasElement.prototype.redraw = function () {
        var _this = this;
        this.updatedElements = {};
        this.redrawCore();
        Object.keys(this.elements)
            .filter(function (key) { return !_this.updatedElements[key]; })
            .forEach(function (key) {
            _this.elements[key].parentNode.removeChild(_this.elements[key]);
            delete _this.elements[key];
        });
        this.updatedElements = {};
    };
    CanvasElement.prototype.drawSelectionMarks = function (rect, allowResizeHorizontally, allowResizeVertically) {
        if (this.readOnly)
            return;
        var canFitAllMarks = !allowResizeHorizontally || !allowResizeVertically || Math.min(rect.width, rect.height) > CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize * 5;
        if (allowResizeHorizontally && allowResizeVertically)
            this.drawSelectionMark(0, new Utils_2.Point(rect.left, rect.top), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_NW, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeVertically && canFitAllMarks)
            this.drawSelectionMark(1, new Utils_2.Point(rect.left + rect.size.width / 2, rect.top), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_N, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeHorizontally && allowResizeVertically)
            this.drawSelectionMark(2, new Utils_2.Point(rect.right, rect.top), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_NE, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeHorizontally && canFitAllMarks)
            this.drawSelectionMark(3, new Utils_2.Point(rect.right, rect.top + rect.size.height / 2), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_E, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeHorizontally && allowResizeVertically)
            this.drawSelectionMark(4, new Utils_2.Point(rect.right, rect.bottom), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_SE, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeVertically && canFitAllMarks)
            this.drawSelectionMark(5, new Utils_2.Point(rect.left + rect.size.width / 2, rect.bottom), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_S, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeHorizontally && allowResizeVertically)
            this.drawSelectionMark(6, new Utils_2.Point(rect.left, rect.bottom), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_SW, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
        if (allowResizeHorizontally && canFitAllMarks)
            this.drawSelectionMark(7, new Utils_2.Point(rect.left, rect.top + rect.size.height / 2), CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize, Event_1.MouseEventElementType.ShapeResizeBox, Event_1.ResizeEventSource.ResizeBox_W, exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK);
    };
    CanvasElement.prototype.drawSelectionMark = function (index, point, size, type, value, className) {
        var _this = this;
        this.getOrCreateElement("SM" + index, new RectaglePrimitive_1.RectanglePrimitive(point.x - size / 2, point.y - size / 2, size, size, null, className, undefined, function (el) {
            Utils_1.RenderUtils.setElementEventData(el, type, _this.key, value);
        }), this.marksContainer);
    };
    CanvasElement.prototype.drawSelectionRect = function (rectangle, type, className) {
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(rectangle.left, rectangle.top, rectangle.width, rectangle.height, null, className, undefined, function (el) {
            Utils_1.RenderUtils.setElementEventData(el, type, "-1", -1);
        });
        this.getOrCreateElement("shapeSelection", primitive, this.rectsContainer);
    };
    CanvasElement.prototype.getOrCreateElement = function (cacheKey, primitive, container) {
        var element = this.elements[cacheKey];
        if (!element) {
            element = primitive.createElement();
            this.elements[cacheKey] = element;
            container.appendChild(element);
        }
        this.updatedElements[cacheKey] = true;
        primitive.applyElementProperties(element);
        return element;
    };
    return CanvasElement;
}());
var ItemSelectionElement = /** @class */ (function (_super) {
    __extends(ItemSelectionElement, _super);
    function ItemSelectionElement(rectsContainer, marksContainer, key, zoomLevel, readOnly, isLocked, rectangle) {
        var _this = _super.call(this, rectsContainer, marksContainer, key, zoomLevel, readOnly) || this;
        _this.isLocked = isLocked;
        _this.rectangle = rectangle;
        return _this;
    }
    ItemSelectionElement.prototype.onSelectionChanged = function (isMultipleSelection) {
        if (this.isMultipleSelection !== isMultipleSelection) {
            this.isMultipleSelection = isMultipleSelection;
            this.redraw();
        }
    };
    ItemSelectionElement.prototype.redrawCore = function () {
        var rect = this.rectangle.multiply(this.zoomLevel);
        if (this.isLockedRender())
            this.drawLockedSelection(rect);
        else
            this.drawUnlockedSelection(rect);
    };
    ItemSelectionElement.prototype.isLockedRender = function () {
        return this.isLocked && !this.readOnly;
    };
    ItemSelectionElement.prototype.drawLockedSelection = function (rect) {
        this.drawLockedSelectionMark(0, new Utils_2.Point(rect.left, rect.top), CanvasItemsManager_1.CanvasItemsManager.lockedSelectionMarkSize, exports.SELECTION_ELEMENT_CLASSNAMES.LOCKED_SELECTION_MARK);
        this.drawLockedSelectionMark(1, new Utils_2.Point(rect.right, rect.top), CanvasItemsManager_1.CanvasItemsManager.lockedSelectionMarkSize, exports.SELECTION_ELEMENT_CLASSNAMES.LOCKED_SELECTION_MARK);
        this.drawLockedSelectionMark(2, new Utils_2.Point(rect.right, rect.bottom), CanvasItemsManager_1.CanvasItemsManager.lockedSelectionMarkSize, exports.SELECTION_ELEMENT_CLASSNAMES.LOCKED_SELECTION_MARK);
        this.drawLockedSelectionMark(3, new Utils_2.Point(rect.left, rect.bottom), CanvasItemsManager_1.CanvasItemsManager.lockedSelectionMarkSize, exports.SELECTION_ELEMENT_CLASSNAMES.LOCKED_SELECTION_MARK);
    };
    ItemSelectionElement.prototype.drawLockedSelectionMark = function (index, point, size, className) {
        var primitive = new PathPrimitive_1.PathPrimitive([
            new PathPrimitive_1.PathPrimitiveMoveToCommand(point.x - size / 2, point.y - size / 2),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x + size / 2, point.y + size / 2),
            new PathPrimitive_1.PathPrimitiveMoveToCommand(point.x + size / 2, point.y - size / 2),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x - size / 2, point.y + size / 2)
        ], null, className);
        this.getOrCreateElement("LSM" + index, primitive, this.marksContainer);
    };
    return ItemSelectionElement;
}(CanvasElement));
var MultipleSelectionElement = /** @class */ (function (_super) {
    __extends(MultipleSelectionElement, _super);
    function MultipleSelectionElement(rectsContainer, marksContainer, zoomLevel, readOnly) {
        var _this = _super.call(this, rectsContainer, marksContainer, "-1", zoomLevel, readOnly) || this;
        _this.items = {};
        return _this;
    }
    MultipleSelectionElement.prototype.onModelItemChanged = function (itemKey, rectangle) {
        if (itemKey in this.items)
            this.items[itemKey] = rectangle;
    };
    MultipleSelectionElement.prototype.onModelChanged = function () {
        this.redraw();
    };
    MultipleSelectionElement.prototype.onSelectionChanged = function (containsShapes, items) {
        var _this = this;
        this.containsShapes = containsShapes;
        this.items = {};
        items.forEach(function (i) { return _this.items[i.key] = i.rectangle; });
        this.redraw();
    };
    MultipleSelectionElement.prototype.redrawCore = function () {
        var _this = this;
        var rectangle = Utils_2.GeometryUtils.getCommonRectangle(Object.keys(this.items).map(function (key) { return _this.items[key]; }));
        var rect = CanvasSelectionManager.correctShapeSelectionRect(rectangle.multiply(this.zoomLevel), CanvasItemsManager_1.CanvasItemsManager.selectionRectLineWidth, this.zoomLevel);
        this.drawSelectionRect(rect, Event_1.MouseEventElementType.SelectionRect, exports.SELECTION_ELEMENT_CLASSNAMES.ITEMS_SELECTION_RECT);
        if (this.containsShapes)
            this.drawSelectionMarks(rect, true, true);
    };
    return MultipleSelectionElement;
}(CanvasElement));
var ShapeSelectionElement = /** @class */ (function (_super) {
    __extends(ShapeSelectionElement, _super);
    function ShapeSelectionElement(rectsContainer, marksContainer, zoomLevel, readOnly, key, isLocked, rectangle, allowResizeHorizontally, allowResizeVertically, shapeParameterPoints) {
        var _this = _super.call(this, rectsContainer, marksContainer, key, zoomLevel, readOnly, isLocked, rectangle) || this;
        _this.allowResizeHorizontally = allowResizeHorizontally;
        _this.allowResizeVertically = allowResizeVertically;
        _this.shapeParameterPoints = shapeParameterPoints;
        return _this;
    }
    ShapeSelectionElement.prototype.onModelChanged = function (isLocked, rectangle, allowResizeHorizontally, allowResizeVertically, shapeParameterPoints) {
        this.isLocked = isLocked;
        this.rectangle = rectangle;
        this.allowResizeHorizontally = allowResizeHorizontally;
        this.allowResizeVertically = allowResizeVertically;
        this.shapeParameterPoints = shapeParameterPoints;
        this.redraw();
    };
    ShapeSelectionElement.prototype.drawUnlockedSelection = function (rect) {
        var shapeRect = CanvasSelectionManager.correctShapeSelectionRect(rect, CanvasItemsManager_1.CanvasItemsManager.selectionRectLineWidth, this.zoomLevel);
        this.drawSelectionRect(shapeRect, Event_1.MouseEventElementType.SelectionRect, this.isMultipleSelection ? exports.SELECTION_ELEMENT_CLASSNAMES.ITEM_MULTI_SELECTION : exports.SELECTION_ELEMENT_CLASSNAMES.ITEM_SELECTION_RECT);
        if (!this.isMultipleSelection)
            this.drawSelectionMarks(rect, this.allowResizeHorizontally, this.allowResizeVertically);
        this.drawShapeParameterPoints();
    };
    ShapeSelectionElement.prototype.drawShapeParameterPoints = function () {
        var _this = this;
        if (this.readOnly)
            return;
        this.shapeParameterPoints.forEach(function (pp, index) {
            var point = pp.point.multiply(_this.zoomLevel);
            _this.drawShapeParameterPoint(point, index, pp.key);
        });
    };
    ShapeSelectionElement.prototype.drawShapeParameterPoint = function (point, index, pointKey) {
        var _this = this;
        var size = CanvasItemsManager_1.CanvasItemsManager.geomertyMarkSize;
        var primitive = new RectaglePrimitive_1.RectanglePrimitive(point.x - size / 2, point.y - size / 2, size, size, null, "geometry-mark", undefined, function (el) {
            Utils_1.RenderUtils.setElementEventData(el, Event_1.MouseEventElementType.ShapeParameterBox, _this.key, pointKey);
        });
        this.getOrCreateElement("pp" + index.toString(), primitive, this.marksContainer);
    };
    return ShapeSelectionElement;
}(ItemSelectionElement));
var ConnectorSelectionElement = /** @class */ (function (_super) {
    __extends(ConnectorSelectionElement, _super);
    function ConnectorSelectionElement(rectsContainer, marksContainer, zoomLevel, readOnly, key, isLocked, rectangle, renderPoints, styleText, enableText, texts, points, lineType) {
        var _this = _super.call(this, rectsContainer, marksContainer, key, zoomLevel, readOnly, isLocked, rectangle) || this;
        _this.renderPoints = renderPoints;
        _this.styleText = styleText;
        _this.enableText = enableText;
        _this.texts = texts;
        _this.points = points;
        _this.lineType = lineType;
        return _this;
    }
    ConnectorSelectionElement.prototype.onModelChanged = function (isLocked, rectangle, renderPoints, styleText, enableText, texts, points, lineType) {
        this.isLocked = isLocked;
        this.rectangle = rectangle;
        this.renderPoints = renderPoints;
        this.styleText = styleText;
        this.enableText = enableText;
        this.texts = texts;
        this.points = points;
        this.lineType = lineType;
        this.redraw();
    };
    ConnectorSelectionElement.prototype.drawUnlockedSelection = function (rect) {
        this.drawConnectorSelection(this.isMultipleSelection ? exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTOR_MULTI_SELECTION : exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTOR_SELECTION);
        if (!this.isMultipleSelection && !this.readOnly)
            this.drawConnectorSelectionMarks();
    };
    ConnectorSelectionElement.prototype.drawConnectorSelection = function (className) {
        var _this = this;
        var points = this.renderPoints;
        var pathCommands = [];
        var prevPt, firstPt, lastPt;
        var difX = 0, difY = 0;
        points.forEach(function (pt) {
            pt = pt.multiply(_this.zoomLevel);
            if (prevPt === undefined) {
                firstPt = pt;
                pathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand(pt.x, pt.y));
            }
            else {
                pathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(pt.x, pt.y));
                difX = Math.max(difX, Math.abs(prevPt.x - pt.x));
                difY = Math.max(difY, Math.abs(prevPt.y - pt.y));
            }
            prevPt = pt;
        });
        lastPt = prevPt;
        if (difX < CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth || difY < CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth) {
            // Increase mask size
            var offsetX = difX < CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth ? CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth : 0;
            var offsetY = (difY < CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth ? CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth : 0);
            pathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(lastPt.x - offsetX, lastPt.y - offsetY));
        }
        var maskId = Utils_1.RenderUtils.generateSvgElementId("maskSel");
        var cliPathId = Utils_1.RenderUtils.generateSvgElementId("clipSel");
        var primitive = new GroupPrimitive_1.GroupPrimitive([
            new PathPrimitive_1.PathPrimitive(pathCommands, null, className, cliPathId, function (el) {
                el.setAttribute("mask", "url(#" + maskId + ")");
            }),
            new MaskPrimitive_1.MaskPrimitive(maskId, [
                new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "background"),
                new PathPrimitive_1.PathPrimitive(pathCommands),
                new RectaglePrimitive_1.RectanglePrimitive(firstPt.x - CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth / 2, firstPt.y - CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth / 2, CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth, CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth),
                new RectaglePrimitive_1.RectanglePrimitive(lastPt.x - CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth / 2, lastPt.y - CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth / 2, CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth, CanvasItemsManager_1.CanvasItemsManager.connectorSelectionWidth),
                new GroupPrimitive_1.GroupPrimitive([])
            ], exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTOR_SELECTION_MASK, "-1000%", "-1000%", "2100%", "2100%")
        ]);
        var csElement = this.getOrCreateElement("CS", primitive, this.rectsContainer);
        this.drawConnectorTextsSelection(csElement, csElement.querySelector("g"), className, maskId);
    };
    ConnectorSelectionElement.prototype.drawConnectorTextsSelection = function (parent, maskParent, className, maskId) {
        var _this = this;
        var textRects = [];
        if (maskParent && this.enableText) {
            this.texts.forEach(function (textObj, index) {
                if (textObj.text) {
                    var filterId = Utils_1.RenderUtils.generateSvgElementId("filterSel");
                    var textPrimitive = new GroupPrimitive_1.GroupPrimitive([
                        new TextPrimitive_1.TextPrimitive(textObj.point.x, textObj.point.y, textObj.text, undefined, _this.styleText, true, null, filterId),
                        new TextFilterPrimitive_1.TextFilterPrimitive(filterId)
                    ]);
                    var gTextEl = _this.getOrCreateElement("FSE" + index, textPrimitive, maskParent);
                    var textEl = gTextEl.querySelector("text");
                    var textRect = Utils_1.RenderUtils.getSvgTextRectangle(textEl, CanvasItemsManager_1.CanvasItemsManager.connectorSelectionLineWidth);
                    if (textRect)
                        textRects.push(textRect.multiply(_this.zoomLevel));
                }
            });
        }
        for (var i = 0; i < textRects.length; i++) {
            var textRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive(textRects[i].left, textRects[i].top, textRects[i].width, textRects[i].height, null, className + " text", null);
            this.getOrCreateElement("TR" + i, textRectPrimitive, parent);
        }
    };
    ConnectorSelectionElement.prototype.drawConnectorSelectionMarks = function () {
        var _this = this;
        var pointsCount = this.points.length - 1;
        this.points.forEach(function (pt, index) {
            var isEdgePoint = index === 0 || index === pointsCount;
            var className = isEdgePoint ? exports.SELECTION_ELEMENT_CLASSNAMES.SELECTION_MARK : exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTOR_POINT_MARK;
            var markSize = isEdgePoint ? CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize : CanvasItemsManager_1.CanvasItemsManager.connectorPointMarkSize;
            if (isEdgePoint || _this.lineType === ConnectorProperties_1.ConnectorLineOption.Straight) {
                _this.drawSelectionMark(index, pt.multiply(_this.zoomLevel), markSize, Event_1.MouseEventElementType.ConnectorPoint, index, className);
            }
            else {
                _this.drawSelectionMark(index, pt.multiply(_this.zoomLevel), markSize, Event_1.MouseEventElementType.Undefined, -1, className + " disabled");
            }
        });
        this.drawConnectorSideMarks();
    };
    ConnectorSelectionElement.prototype.drawConnectorSideMarks = function () {
        var _this = this;
        var type = (this.lineType === ConnectorProperties_1.ConnectorLineOption.Straight) ?
            Event_1.MouseEventElementType.ConnectorSide : Event_1.MouseEventElementType.ConnectorOrthogonalSide;
        var prevPt, prevPtIndex;
        this.renderPoints.filter(function (rp) { return !rp.skipped; }).forEach(function (pt, index) {
            if (pt.skipped)
                return;
            if (prevPt !== undefined) {
                if (_this.canDrawConnectorSideMark(pt, prevPt)) {
                    var classNameSuffix = _this.lineType === ConnectorProperties_1.ConnectorLineOption.Orthogonal ?
                        (pt.x - prevPt.x === 0 ? "vertical" : "horizontal") : "";
                    _this.drawSelectionMark(_this.points.length + index - 1, new Utils_2.Point(prevPt.x + (pt.x - prevPt.x) / 2, prevPt.y + (pt.y - prevPt.y) / 2).multiply(_this.zoomLevel), CanvasItemsManager_1.CanvasItemsManager.connectorSideMarkSize, type, prevPtIndex + "_" + index, exports.SELECTION_ELEMENT_CLASSNAMES.CONNECTOR_SIDE_MARK + " " + classNameSuffix);
                }
            }
            prevPt = pt;
            prevPtIndex = index;
        });
    };
    ConnectorSelectionElement.prototype.canDrawConnectorSideMark = function (point1, point2) {
        if (this.lineType === ConnectorProperties_1.ConnectorLineOption.Straight) {
            var minSize = CanvasItemsManager_1.CanvasItemsManager.selectionMarkSize + CanvasItemsManager_1.CanvasItemsManager.connectorSideMarkSize;
            return Utils_2.GeometryUtils.getDistance(point1, point2) > minSize;
        }
        if (this.lineType === ConnectorProperties_1.ConnectorLineOption.Orthogonal) {
            return ((point1.x - point2.x === 0 || Math.abs(point1.x - point2.x) > Connector_1.Connector.minOffset) &&
                (point1.y - point2.y === 0 || Math.abs(point1.y - point2.y) > Connector_1.Connector.minOffset));
        }
        return false;
    };
    return ConnectorSelectionElement;
}(ItemSelectionElement));


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var Primitive_1 = __webpack_require__(17);
var MaskPrimitive = /** @class */ (function (_super) {
    __extends(MaskPrimitive, _super);
    function MaskPrimitive(id, children, className, x, y, width, height) {
        var _this = _super.call(this, null, className) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.children = children;
        return _this;
    }
    MaskPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "mask");
    };
    MaskPrimitive.prototype.applyElementProperties = function (element) {
        if (this.id)
            element.setAttribute("id", this.id);
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return MaskPrimitive;
}(Primitive_1.SvgPrimitive));
exports.MaskPrimitive = MaskPrimitive;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsCalculatorBase_1 = __webpack_require__(88);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsCalculator, _super);
    function ConnectorPointsCalculator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorPointsCalculator.prototype.getPoints = function () {
        return this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
    };
    return ConnectorPointsCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsCalculator = ConnectorPointsCalculator;


/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(4);
var ConnectorPointsCalculatorBase_1 = __webpack_require__(88);
var ConnectorPointsOrthogonalUndefinedSideCalculator_1 = __webpack_require__(136);
var ConnectorPointsOrthogonalSouthSideCalculator_1 = __webpack_require__(137);
var ConnectorPointsOrthogonalNorthSideCalculator_1 = __webpack_require__(138);
var ConnectorPointsOrthogonalEastSideCalculator_1 = __webpack_require__(139);
var ConnectorPointsOrthogonalWestSideCalculator_1 = __webpack_require__(140);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalCalculator, _super);
    function ConnectorPointsOrthogonalCalculator(connector) {
        var _this = _super.call(this, connector) || this;
        _this.sideCalculators = {};
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.Undefined] = new ConnectorPointsOrthogonalUndefinedSideCalculator_1.ConnectorPointsOrthogonalUndefinedSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.South] = new ConnectorPointsOrthogonalSouthSideCalculator_1.ConnectorPointsOrthogonalSouthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.North] = new ConnectorPointsOrthogonalNorthSideCalculator_1.ConnectorPointsOrthogonalNorthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.East] = new ConnectorPointsOrthogonalEastSideCalculator_1.ConnectorPointsOrthogonalEastSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.West] = new ConnectorPointsOrthogonalWestSideCalculator_1.ConnectorPointsOrthogonalWestSideCalculator(_this);
        return _this;
    }
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "beginRect", {
        get: function () { return this.connector.beginItem ? this.connector.beginItem.rectangle : undefined; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "endRect", {
        get: function () { return this.connector.endItem ? this.connector.endItem.rectangle : undefined; },
        enumerable: true,
        configurable: true
    });
    ConnectorPointsOrthogonalCalculator.prototype.getPoints = function () {
        var points = this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
        this.removeUnnecessaryLinePoints(points);
        var beginIndex = 0, endIndex = points.length - 1;
        var beginSide = this.getPointSide(points, 0);
        var beginNextSide = this.getPointSide(points, 1);
        var endSide = this.getPointSide(points, points.length - 1);
        var endPrevSide = this.getPointSide(points, points.length - 1 - 1);
        var beginSideCalculator = this.getSideCalculator(beginSide);
        var endSideCalculator = this.getSideCalculator(endSide);
        var originRect = this.beginRect;
        var originPoint = beginSideCalculator.getCorrectOriginPoint(points[beginIndex], originRect);
        var targetPoint = points[beginIndex + 1];
        if (points.length === 2 && beginSideCalculator.isOnSidePoint(originPoint, targetPoint) &&
            beginSideCalculator.isDirectConnectionAllowed(beginNextSide, originPoint, targetPoint)) {
            var directConnectionPoints = beginSideCalculator.getDirectConnectionPoints(originPoint, targetPoint);
            directConnectionPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
                beginIndex++;
                endIndex++;
            });
        }
        else {
            var bOffsetPoints = beginSideCalculator.getBeginOffsetPoints(beginNextSide, points[beginIndex], points[beginIndex + 1], this.beginRect);
            bOffsetPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
            });
            beginIndex += bOffsetPoints.length;
            endIndex += bOffsetPoints.length;
            var eOffsetPoints = endSideCalculator.getEndOffsetPoints(endPrevSide, points[endIndex], points[endIndex - 1], this.endRect);
            eOffsetPoints.forEach(function (pt, index) {
                points.splice(endIndex + index, 0, pt);
            });
            for (var index = beginIndex; index < endIndex; index++) {
                var nextIndex = index + 1;
                var middlePoint = this.getMiddlePoint(points[index], points[index - 1], index - 1 === 0, points[nextIndex], points[nextIndex + 1], nextIndex + 1 === points.length - 1);
                if (middlePoint !== undefined) {
                    points.splice(index + 1, 0, middlePoint);
                    index++;
                    endIndex++;
                }
            }
        }
        this.removeUnnecessaryLinePoints(points);
        return points;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getSideCalculator = function (side) {
        return this.sideCalculators[side];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getPointSide = function (points, index) {
        if (index === 0 && this.connector.beginItem) {
            var connectionPointIndex = this.connector.beginConnectionPointIndex;
            return this.connector.beginItem.getConnectionPointSideByIndex(connectionPointIndex, points[1]);
        }
        if (index === points.length - 1 && this.connector.endItem) {
            var connectionPointIndex = this.connector.endConnectionPointIndex;
            return this.connector.endItem.getConnectionPointSideByIndex(connectionPointIndex, points[points.length - 2]);
        }
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoints = function (point1, point2) {
        if (point1.x === point2.x || point1.y === point2.y)
            return [];
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point1.x, point2.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point2.x, point1.y)
        ];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoint = function (point1, directionPoint1, nextToBegin, point2, directionPoint2, nextToEnd) {
        var _this = this;
        var point;
        var points = this.getMiddlePoints(point1, point2);
        points.forEach(function (pt) {
            var rect1 = _this.createPointsRect(point1, pt);
            var rect2 = _this.createPointsRect(pt, point2);
            var itemRect1 = _this.connector.beginItem ? _this.connector.beginItem.rectangle : undefined;
            var itemRect2 = _this.connector.endItem ? _this.connector.endItem.rectangle : undefined;
            if (itemRect1) {
                if (itemRect1.intersect(rect1) || itemRect1.intersect(rect2))
                    return;
            }
            if (itemRect2) {
                if (itemRect2.intersect(rect1) || itemRect2.intersect(rect2))
                    return;
            }
            if ((!_this.isReturnPoint(pt, point1, directionPoint1) || _this.isIntermediatePoints(point1, directionPoint1)) &&
                (!_this.isReturnPoint(pt, point2, directionPoint2) || _this.isIntermediatePoints(point2, directionPoint2))) {
                if (point === undefined)
                    point = pt;
                else if (_this.isPriorMiddlePoint(pt, point1, directionPoint1, point2, directionPoint2))
                    point = pt;
            }
        });
        if (point === undefined && points.length > 0)
            point = points[0];
        return point;
    };
    ConnectorPointsOrthogonalCalculator.prototype.createPointsRect = function (point1, point2) {
        var result = Utils_1.Rectangle.createByPoints(point1, point2);
        if (result.width > 0)
            result = result.inflate(-1, 0);
        if (result.height > 0)
            result = result.inflate(0, -1);
        return result;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isPriorMiddlePoint = function (point, point1, directionPoint1, point2, directionPoint2) {
        if (directionPoint1) {
            if (point.x === directionPoint1.x || point.y === directionPoint1.y)
                return true;
        }
        if (directionPoint2) {
            if (point.x === directionPoint2.x || point.y === directionPoint2.y)
                return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isReturnPoint = function (point, point1, point2) {
        if (point1 !== undefined && point2 !== undefined) {
            if (point.x === point2.x)
                if (point1.y < point.y && point.y < point2.y || point1.y > point.y && point.y > point2.y)
                    return true;
            if (point.y === point2.y)
                if (point1.x < point.x && point.x < point2.x || point1.x > point.x && point.x > point2.x)
                    return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isIntermediatePoints = function (point1, point2) {
        return 0 < point1.pointIndex && point1.pointIndex < this.connector.points.length - 1 &&
            0 < point2.pointIndex && point2.pointIndex < this.connector.points.length - 1;
    };
    ConnectorPointsOrthogonalCalculator.prototype.removeUnnecessaryLinePoints = function (points) {
        Utils_1.GeometryUtils.removeUnnecessaryLinePoints(points, function (pt, index) {
            if (pt.pointIndex === -1) {
                points.splice(index, 1);
                return true;
            }
            else {
                pt.skipped = true;
                return false;
            }
        }, function (pt) {
            return pt !== undefined && !pt.skipped;
        });
    };
    return ConnectorPointsOrthogonalCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsOrthogonalCalculator = ConnectorPointsOrthogonalCalculator;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(43);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalUndefinedSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalUndefinedSideCalculator, _super);
    function ConnectorPointsOrthogonalUndefinedSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        return originPoint;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [];
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return true;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        var calculator = this.getSideCalculator(originPoint, targetPoint);
        if (calculator !== undefined)
            return calculator.isDirectConnectionAllowed(targetSide, originPoint, targetPoint);
        return true;
    };
    ConnectorPointsOrthogonalUndefinedSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY) {
            var minX = Math.min(originPoint.x, targetPoint.x);
            var cx = minX + diffX / 2;
            return [
                new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
                new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
            ];
        }
        else {
            var minY = Math.min(originPoint.y, targetPoint.y);
            var cy = minY + diffY / 2;
            return [
                new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
                new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
            ];
        }
    };
    return ConnectorPointsOrthogonalUndefinedSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalUndefinedSideCalculator = ConnectorPointsOrthogonalUndefinedSideCalculator;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(43);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalSouthSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalSouthSideCalculator, _super);
    function ConnectorPointsOrthogonalSouthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y < originRect.bottom)
            originPoint = originPoint.offset(0, originRect.bottom - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y < targetPoint.y) {
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, this.getMinOffset())];
                }
                if (originPoint.y > this.endRect.bottom)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y < targetPoint.y) {
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, this.getMinOffset())];
                }
                if (originPoint.y > this.endRect.bottom)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y < originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.offset(0, this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y < originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.offset(0, this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                var offset = this.getMinOffset();
                if (this.beginRect.bottom > originPoint.y)
                    offset += this.beginRect.bottom - originPoint.y;
                return [originPoint.offset(0, offset)];
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(0, this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.offset(-(originPoint.x - originRect.left + asideOffset), offset));
            else
                points.push(originPoint.offset((originRect.right - originPoint.x + asideOffset), offset));
        }
        points.push(originPoint.offset(0, offset));
        return points;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.left - this.endRect.right;
                else
                    distance = this.endRect.left - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? this.beginRect.top - originPoint.y : this.endRect.top - originPoint.y;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y > originPoint.y;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.North || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = originPoint.y + (targetPoint.y - originPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalSouthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalSouthSideCalculator = ConnectorPointsOrthogonalSouthSideCalculator;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(43);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalNorthSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalNorthSideCalculator, _super);
    function ConnectorPointsOrthogonalNorthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y > originRect.top)
            originPoint = originPoint.offset(0, originRect.top - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y > targetPoint.y) {
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, -this.getMinOffset())];
                }
                if (originPoint.y < this.endRect.top)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y > targetPoint.y) {
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.offset(0, -this.getMinOffset())];
                }
                if (originPoint.y < this.endRect.top)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                var offset = -this.getMinOffset();
                if (this.beginRect.top < originPoint.y)
                    offset -= originPoint.y - this.beginRect.top;
                return [originPoint.offset(0, offset)];
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.offset(-(originPoint.x - originRect.left + asideOffset), -offset));
            else
                points.push(originPoint.offset((originRect.right - originPoint.x + asideOffset), -offset));
        }
        points.push(originPoint.offset(0, -offset));
        return points;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.left - this.endRect.right;
                else
                    distance = this.endRect.left - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.y - this.beginRect.bottom : originPoint.y - this.endRect.bottom;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y < originPoint.y;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.South || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = targetPoint.y + (originPoint.y - targetPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalNorthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalNorthSideCalculator = ConnectorPointsOrthogonalNorthSideCalculator;


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(43);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalEastSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalEastSideCalculator, _super);
    function ConnectorPointsOrthogonalEastSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x < originRect.right)
            originPoint = originPoint.offset(originRect.right - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x < targetPoint.x) {
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(this.getMinOffset(), 0)];
                }
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x < targetPoint.x) {
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(this.getMinOffset(), 0)];
                }
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                var offset = this.getMinOffset();
                if (this.beginRect.right > originPoint.x)
                    offset += this.beginRect.right - originPoint.x;
                return [originPoint.offset(offset, 0)];
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.offset(this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.offset(this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.offset(offset, -(originPoint.y - originRect.top + asideOffset)));
            else
                points.push(originPoint.offset(offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.offset(offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? this.beginRect.left - originPoint.x : this.endRect.left - originPoint.x;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.top - this.endRect.bottom;
                else
                    distance = this.endRect.top - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x > originPoint.x;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.West || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = originPoint.x + (targetPoint.x - originPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalEastSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalEastSideCalculator = ConnectorPointsOrthogonalEastSideCalculator;


/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiagramItem_1 = __webpack_require__(4);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(43);
var ConnectorRenderPoint_1 = __webpack_require__(30);
var ConnectorPointsOrthogonalWestSideCalculator = /** @class */ (function (_super) {
    __extends(ConnectorPointsOrthogonalWestSideCalculator, _super);
    function ConnectorPointsOrthogonalWestSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x > originRect.left)
            originPoint = originPoint.offset(originRect.left - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x > targetPoint.x) {
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(-this.getMinOffset(), 0)];
                }
                if (originPoint.x < this.endRect.left)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x > targetPoint.x) {
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.offset(-this.getMinOffset(), 0)];
                }
                if (originPoint.x < this.endRect.left)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                var offset = -this.getMinOffset();
                if (this.beginRect.left < originPoint.x)
                    offset -= originPoint.x - this.beginRect.left;
                return [originPoint.offset(offset, 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.offset(-this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.offset(-this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.offset(-this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.offset(-offset, -(originPoint.y - originRect.top + asideOffset)));
            else
                points.push(originPoint.offset(-offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.offset(-offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.x - this.beginRect.right : originPoint.x - this.endRect.right;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.top - this.endRect.bottom;
                else
                    distance = this.endRect.top - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x < originPoint.x;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.East || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = targetPoint.x + (originPoint.x - targetPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalWestSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalWestSideCalculator = ConnectorPointsOrthogonalWestSideCalculator;


/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConnectorText = /** @class */ (function () {
    function ConnectorText(position, value) {
        this.position = position;
        this.value = value;
    }
    return ConnectorText;
}());
exports.ConnectorText = ConnectorText;
var ConnectorTexts = /** @class */ (function () {
    function ConnectorTexts() {
        this.items = {};
    }
    ConnectorTexts.prototype.get = function (position) {
        return this.items[position];
    };
    ConnectorTexts.prototype.set = function (position, text) {
        this.items[position] = text;
    };
    ConnectorTexts.prototype.remove = function (position) {
        delete this.items[position];
    };
    ConnectorTexts.prototype.map = function (callback) {
        var list = [];
        this.forEach(function (t) { return list.push(callback(t)); });
        return list;
    };
    ConnectorTexts.prototype.forEach = function (callback) {
        for (var key in this.items)
            if (this.items.hasOwnProperty(key))
                callback(this.items[key]);
    };
    ConnectorTexts.prototype.clone = function () {
        var result = new ConnectorTexts();
        this.forEach(function (t) { result.set(t.position, new ConnectorText(t.position, t.value)); });
        return result;
    };
    ConnectorTexts.prototype.toObject = function () {
        var result = {};
        var modified = false;
        this.forEach(function (t) {
            result[t.position] = t.value;
            modified = true;
        });
        return modified ? result : null;
    };
    ConnectorTexts.prototype.fromObject = function (obj) {
        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                var position = parseFloat(key);
                if (!isNaN(position) && typeof obj[key] === "string") {
                    this.set(position, new ConnectorText(position, obj[key]));
                }
            }
        }
    };
    return ConnectorTexts;
}());
exports.ConnectorTexts = ConnectorTexts;


/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var Utils_1 = __webpack_require__(0);
var ModelResizeHistoryItem = /** @class */ (function (_super) {
    __extends(ModelResizeHistoryItem, _super);
    function ModelResizeHistoryItem(offset) {
        var _this = _super.call(this) || this;
        _this.offset = offset;
        return _this;
    }
    ModelResizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.size.clone();
        this.backOffset = new Utils_1.Offset(-this.offset.left, -this.offset.top, -this.offset.right, -this.offset.bottom);
        var newWidth = Math.max(this.oldSize.width + this.offset.left + this.offset.right, manipulator.model.pageWidth);
        var newHeight = Math.max(this.oldSize.height + this.offset.top + this.offset.bottom, manipulator.model.pageHeight);
        manipulator.changeModelSize(new Utils_1.Size(newWidth, newHeight), this.offset);
    };
    ModelResizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changeModelSize(this.oldSize, this.backOffset);
    };
    return ModelResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ModelResizeHistoryItem = ModelResizeHistoryItem;


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var Shape_1 = __webpack_require__(9);
var Connector_1 = __webpack_require__(5);
var UpdatePositionsOnPageResizeHistoryItem = /** @class */ (function (_super) {
    __extends(UpdatePositionsOnPageResizeHistoryItem, _super);
    function UpdatePositionsOnPageResizeHistoryItem(offsetX, offsetY) {
        var _this = _super.call(this) || this;
        _this.offsetX = offsetX;
        _this.offsetY = offsetY;
        return _this;
    }
    UpdatePositionsOnPageResizeHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, item.position.offset(_this.offsetX, _this.offsetY));
            if (item instanceof Connector_1.Connector)
                item.points.forEach(function (p, index) { return manipulator.moveConnectorPoint(item, index, p.offset(_this.offsetX, _this.offsetY)); });
        });
    };
    UpdatePositionsOnPageResizeHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, item.position.offset(-_this.offsetX, -_this.offsetY));
            if (item instanceof Connector_1.Connector)
                item.points.forEach(function (p, index) { return manipulator.moveConnectorPoint(item, index, p.offset(-_this.offsetX, -_this.offsetY)); });
        });
    };
    return UpdatePositionsOnPageResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.UpdatePositionsOnPageResizeHistoryItem = UpdatePositionsOnPageResizeHistoryItem;


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var DeleteConnectorPointHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectorPointHistoryItem, _super);
    function DeleteConnectorPointHistoryItem(connectorKey, pointIndex) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        return _this;
    }
    DeleteConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.point = connector.points[this.pointIndex].clone();
        manipulator.deleteConnectorPoint(connector, this.pointIndex);
    };
    DeleteConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.addConnectorPoint(connector, this.pointIndex, this.point);
    };
    return DeleteConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectorPointHistoryItem = DeleteConnectorPointHistoryItem;


/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ResizeShapeHistoryItem = /** @class */ (function (_super) {
    __extends(ResizeShapeHistoryItem, _super);
    function ResizeShapeHistoryItem(shapeKey, position, size) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        _this.size = size;
        return _this;
    }
    ResizeShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        this.oldSize = shape.size.clone();
        manipulator.resizeShape(shape, this.position, this.size);
    };
    ResizeShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.resizeShape(shape, this.oldPosition, this.oldSize);
    };
    return ResizeShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ResizeShapeHistoryItem = ResizeShapeHistoryItem;


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var DeleteConnectorHistoryItem = /** @class */ (function (_super) {
    __extends(DeleteConnectorHistoryItem, _super);
    function DeleteConnectorHistoryItem(connectorKey) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        return _this;
    }
    DeleteConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.connector = connector.clone();
        manipulator.deleteConnector(connector);
    };
    DeleteConnectorHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addConnector(this.connector, this.connector.key);
    };
    return DeleteConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectorHistoryItem = DeleteConnectorHistoryItem;


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var ProcessShapeDescription = /** @class */ (function (_super) {
    __extends(ProcessShapeDescription, _super);
    function ProcessShapeDescription() {
        return _super.call(this, "Process", "Process") || this;
    }
    Object.defineProperty(ProcessShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Process; },
        enumerable: true,
        configurable: true
    });
    return ProcessShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ProcessShapeDescription = ProcessShapeDescription;


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DiamondShapeDescription_1 = __webpack_require__(91);
var ShapeTypes_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(8);
var DecisionShapeDescription = /** @class */ (function (_super) {
    __extends(DecisionShapeDescription, _super);
    function DecisionShapeDescription() {
        return _super.call(this, "Decision", "Decision", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75)) || this;
    }
    Object.defineProperty(DecisionShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Decision; },
        enumerable: true,
        configurable: true
    });
    return DecisionShapeDescription;
}(DiamondShapeDescription_1.DiamondShapeDescription));
exports.DecisionShapeDescription = DecisionShapeDescription;


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(4);
var ManualInputShapeDescription = /** @class */ (function (_super) {
    __extends(ManualInputShapeDescription, _super);
    function ManualInputShapeDescription() {
        return _super.call(this, "Manual Input", "Manual Input") || this;
    }
    Object.defineProperty(ManualInputShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ManualInput; },
        enumerable: true,
        configurable: true
    });
    ManualInputShapeDescription.prototype.createShapePrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var y1 = top + height * ManualInputShapeDescription.slopeHeightRatio;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ManualInputShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += ManualInputShapeDescription.slopeHeightRatio / 2 * shape.size.height;
    };
    ManualInputShapeDescription.slopeHeightRatio = 0.1;
    return ManualInputShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ManualInputShapeDescription = ManualInputShapeDescription;


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(4);
var DataShapeDescription = /** @class */ (function (_super) {
    __extends(DataShapeDescription, _super);
    function DataShapeDescription() {
        return _super.call(this, "Data", "Data") || this;
    }
    Object.defineProperty(DataShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Data; },
        enumerable: true,
        configurable: true
    });
    DataShapeDescription.prototype.createShapePrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(DataShapeDescription.slopeAngle)), width);
        var x1 = left + px;
        var x2 = right - px;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    DataShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var offset = shape.size.height / Math.tan(DataShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    DataShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return DataShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DataShapeDescription = DataShapeDescription;


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(8);
var TerminatorShapeDescription = /** @class */ (function (_super) {
    __extends(TerminatorShapeDescription, _super);
    function TerminatorShapeDescription() {
        return _super.call(this, "Terminator", "Terminator", new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.5)) || this;
    }
    Object.defineProperty(TerminatorShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Terminator; },
        enumerable: true,
        configurable: true
    });
    TerminatorShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var x1 = left + width * TerminatorShapeDescription.curveWidthRatio;
        var x2 = left + width * (1 - TerminatorShapeDescription.curveWidthRatio);
        var ratio = height / width;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right, top, right, cy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right, bottom, x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left, bottom, left, cy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left, top, x1, top),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    TerminatorShapeDescription.curveWidthRatio = 0.3;
    return TerminatorShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.TerminatorShapeDescription = TerminatorShapeDescription;


/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var ShapeParameters_1 = __webpack_require__(28);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var PathPrimitive_1 = __webpack_require__(2);
exports.PredefinedProcessEdgeParameterName = "e";
var PredefinedProcessShapeDescription = /** @class */ (function (_super) {
    __extends(PredefinedProcessShapeDescription, _super);
    function PredefinedProcessShapeDescription() {
        return _super.call(this, "Predefined Process", "Predefined\nProcess") || this;
    }
    Object.defineProperty(PredefinedProcessShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.PredefinedProcess; },
        enumerable: true,
        configurable: true
    });
    PredefinedProcessShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var x1 = left + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var x2 = right - shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var primitives = _super.prototype.createShapePrimitives.call(this, shape);
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom)
            ], shape.style)
        ]);
    };
    PredefinedProcessShapeDescription.prototype.createParameters = function (parameters) {
        parameters.add(new ShapeParameters_1.ShapeParameter(exports.PredefinedProcessEdgeParameterName, this.defaultSize.width * 0.1));
    };
    PredefinedProcessShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return Math.max(PredefinedProcessShapeDescription.minEdge, Math.min(shape.size.width * 0.3, p.value)); });
    };
    PredefinedProcessShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return p.value + deltaX; });
        this.normalizeParameters(shape, parameters);
    };
    PredefinedProcessShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value), shape.position.y))
        ];
    };
    PredefinedProcessShapeDescription.minEdge = 72;
    return PredefinedProcessShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PredefinedProcessShapeDescription = PredefinedProcessShapeDescription;


/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(64);
var ShapeTypes_1 = __webpack_require__(1);
var ArrowNorthSouthShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowNorthSouthShapeDescription, _super);
    function ArrowNorthSouthShapeDescription() {
        return _super.call(this, "North-South Arrow") || this;
    }
    Object.defineProperty(ArrowNorthSouthShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowNorthSouth; },
        enumerable: true,
        configurable: true
    });
    ArrowNorthSouthShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        var p0y2 = shape.normalizeY(bottom - p0dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowNorthSouthShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height / 2 - 2 * Shape_1.Shape.lineWidth, p.value)); });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
    };
    ArrowNorthSouthShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value + deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowNorthSouthShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    return ArrowNorthSouthShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowNorthSouthShapeDescription = ArrowNorthSouthShapeDescription;


/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(65);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(4);
var ArrowRightShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowRightShapeDescription, _super);
    function ArrowRightShapeDescription() {
        return _super.call(this, "Right Arrow") || this;
    }
    Object.defineProperty(ArrowRightShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowRight; },
        enumerable: true,
        configurable: true
    });
    ArrowRightShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowRightShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value - deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowRightShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.size.width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    ArrowRightShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleWidth = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        if (point.x > shape.position.x + shape.size.width - triangleWidth) {
            var tg = shape.size.height / 2 / triangleWidth;
            var delta = (point.x - (shape.position.x + shape.size.width - triangleWidth)) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.North)
                point.y += delta;
            else if (side === DiagramItem_1.ConnectionPointSide.South)
                point.y -= delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowRightShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowRightShapeDescription = ArrowRightShapeDescription;


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(64);
var ShapeTypes_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(4);
var ArrowTopShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowTopShapeDescription, _super);
    function ArrowTopShapeDescription() {
        return _super.call(this, "Top Arrow") || this;
    }
    Object.defineProperty(ArrowTopShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowTop; },
        enumerable: true,
        configurable: true
    });
    ArrowTopShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowTopShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value + deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowTopShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    ArrowTopShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleHeight = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        if (point.y < shape.position.y + triangleHeight) {
            var tg = shape.size.width / 2 / triangleHeight;
            var delta = (shape.position.y + triangleHeight - point.y) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.x -= delta;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.x += delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowTopShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowTopShapeDescription = ArrowTopShapeDescription;


/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeParameters_1 = __webpack_require__(28);
var ShapeParameterPoint_1 = __webpack_require__(20);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
exports.CrossHorizontalWidthParameterName = "chw";
exports.CrossVerticalWidthParameterName = "cvw";
var CrossShapeDescription = /** @class */ (function (_super) {
    __extends(CrossShapeDescription, _super);
    function CrossShapeDescription() {
        return _super.call(this, "Cross", "") || this;
    }
    Object.defineProperty(CrossShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Cross; },
        enumerable: true,
        configurable: true
    });
    CrossShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var p0dx = (width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2;
        var p1dy = (height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    CrossShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.CrossHorizontalWidthParameterName, this.defaultSize.width * 0.2),
            new ShapeParameters_1.ShapeParameter(exports.CrossVerticalWidthParameterName, this.defaultSize.height * 0.2)
        ]);
    };
    CrossShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    CrossShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    CrossShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2)))
        ];
    };
    return CrossShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.CrossShapeDescription = CrossShapeDescription;


/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var ConnectionPoint_1 = __webpack_require__(34);
var DiagramItem_1 = __webpack_require__(4);
var HeartShapeDescription = /** @class */ (function (_super) {
    __extends(HeartShapeDescription, _super);
    function HeartShapeDescription() {
        return _super.call(this, "Heart", "") || this;
    }
    Object.defineProperty(HeartShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Heart; },
        enumerable: true,
        configurable: true
    });
    HeartShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0.15, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.25, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.25, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    HeartShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right - width * 0.15, top, right, top + height * 0.1, right, top + height * 0.25),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right, top + height * 0.3, right - width * 0.02, top + height * 0.35, right - width * 0.05, top + height * 0.4),
                new PathPrimitive_1.PathPrimitiveLineToCommand(rect.center.x, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + width * 0.05, top + height * 0.4),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left + width * 0.02, top + height * 0.35, left, top + height * 0.3, left, top + height * 0.25),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left, top + height * 0.1, left + width * 0.15, top, left + width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(left + width * 0.3, top, left + width * 0.45, top + height * 0.03, left + width * 0.5, top + height * 0.15),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(right - width * 0.45, top + height * 0.03, right - width * 0.3, top, right - width * 0.25, top),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    return HeartShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.HeartShapeDescription = HeartShapeDescription;


/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var PolygonShapeDescription_1 = __webpack_require__(67);
var OctagonShapeDescription = /** @class */ (function (_super) {
    __extends(OctagonShapeDescription, _super);
    function OctagonShapeDescription() {
        return _super.call(this, "Octagon", "") || this;
    }
    Object.defineProperty(OctagonShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Octagon; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(OctagonShapeDescription.prototype, "angleCount", {
        get: function () { return 8; },
        enumerable: true,
        configurable: true
    });
    OctagonShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var angle = Math.PI - this.angle;
        var sideX = width / (1 + 2 * Math.cos(angle));
        var sideY = height / (1 + 2 * Math.cos(angle));
        var x1 = left + (width - sideX) / 2;
        var x2 = x1 + sideX;
        var y1 = top + (height - sideY) / 2;
        var y2 = y1 + sideY;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    OctagonShapeDescription.prototype.calculateHeight = function (width) {
        return width;
    };
    return OctagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.OctagonShapeDescription = OctagonShapeDescription;


/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeTypes_1 = __webpack_require__(1);
var PentagonShapeDescription_1 = __webpack_require__(93);
var ShapeParameters_1 = __webpack_require__(28);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var DiagramItem_1 = __webpack_require__(4);
exports.StarConvexParameterName = "sc";
var StarShapeDescription = /** @class */ (function (_super) {
    __extends(StarShapeDescription, _super);
    function StarShapeDescription() {
        return _super.call(this, "Star", "") || this;
    }
    Object.defineProperty(StarShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Star; },
        enumerable: true,
        configurable: true
    });
    StarShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var px = (height - py) / Math.tan(angle) / ratio;
        var x1 = left + px;
        var x2 = right - px;
        var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, cx, right, pDistance, distance), this.getInnerPointPos(cy, top, y, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, right, x2, pDistance, distance), this.getInnerPointPos(cy, y, bottom, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, x2, x1, pDistance, distance), this.getInnerPointPos(cy, bottom, bottom, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, x1, left, pDistance, distance), this.getInnerPointPos(cy, bottom, y, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(this.getInnerPointPos(cx, left, cx, pDistance, distance), this.getInnerPointPos(cy, y, top, pDistance, distance)),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    StarShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.StarConvexParameterName, 300)
        ]);
    };
    StarShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        var rect = shape.rectangle;
        var top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        this.changeParameterValue(parameters, exports.StarConvexParameterName, function (p) { return Math.max(0, Math.min(distance, p.value)); });
    };
    StarShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        var distance = Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
        if (deltaX < 0 || deltaY > 0)
            distance = -distance;
        this.changeParameterValue(parameters, exports.StarConvexParameterName, function (p) { return p.value + distance; });
        this.normalizeParameters(shape, parameters);
    };
    StarShapeDescription.prototype.getParameterPoints = function (shape) {
        var rect = shape.rectangle;
        var top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        bottom = this.getActualBottom(top, bottom, width, height);
        var cx = rect.center.x;
        var cy = top + (bottom - top) / 2;
        var ratio = height / width;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
        var distance = this.getInnerPointDistance(cx, cx, right, cy, top, y);
        var innerPointX = this.getInnerPointPos(cx, cx, right, pDistance, distance);
        var innerPointY = this.getInnerPointPos(cy, top, y, pDistance, distance);
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(innerPointX, innerPointY))
        ];
    };
    StarShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        _super.prototype.processConnectionPoint.call(this, shape, point);
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.South) {
            var rect = shape.rectangle;
            var top_1 = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
            bottom = this.getActualBottom(top_1, bottom, width, height);
            var cx = rect.center.x;
            var cy = top_1 + (bottom - top_1) / 2;
            var ratio = height / width;
            var angle = Math.PI - this.angle;
            var py = width / 2 * Math.tan(angle / 2) * ratio;
            var y = top_1 + py;
            var pDistance = shape.parameters.get(exports.StarConvexParameterName).value;
            var distance = this.getInnerPointDistance(cx, cx, right, cy, top_1, y);
            point.y = this.getInnerPointPos(cy, bottom, bottom, pDistance, distance);
        }
    };
    StarShapeDescription.prototype.getInnerPointDistanceByAxis = function (center, edge1, edge2) {
        var edgeX = Math.min(edge1, edge2) + Math.abs(edge1 - edge2) / 2;
        return edgeX - center;
    };
    StarShapeDescription.prototype.getInnerPointPos = function (center, edge1, edge2, pDistance, distance) {
        var ratio = Math.min(1, pDistance / distance);
        return center + this.getInnerPointDistanceByAxis(center, edge1, edge2) * ratio;
    };
    StarShapeDescription.prototype.getInnerPointDistance = function (centerX, edgeX1, edgeX2, centerY, edgeY1, edgeY2) {
        var disX = this.getInnerPointDistanceByAxis(centerX, edgeX1, edgeX2);
        var disY = this.getInnerPointDistanceByAxis(centerY, edgeY1, edgeY2);
        return Math.sqrt(Math.pow(disX, 2) + Math.pow(disY, 2));
    };
    StarShapeDescription.prototype.getActualBottom = function (top, bottom, width, height) {
        var result = top + _super.prototype.calculateHeight.call(this, width) * height / width;
        return result < bottom ? result : bottom;
    };
    StarShapeDescription.prototype.calculateHeight = function (width) {
        return width;
    };
    return StarShapeDescription;
}(PentagonShapeDescription_1.PentagonShapeDescription));
exports.StarShapeDescription = StarShapeDescription;


/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ArrowVerticalShapeDescription_1 = __webpack_require__(64);
var ShapeTypes_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(4);
var ArrowBottomShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowBottomShapeDescription, _super);
    function ArrowBottomShapeDescription() {
        return _super.call(this, "Bottom Arrow") || this;
    }
    Object.defineProperty(ArrowBottomShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowBottom; },
        enumerable: true,
        configurable: true
    });
    ArrowBottomShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(p1x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowBottomShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value - deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowBottomShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.size.height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    ArrowBottomShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleHeight = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        if (point.y > shape.position.y + shape.size.height - triangleHeight) {
            var tg = shape.size.width / 2 / triangleHeight;
            var delta = (point.y - (shape.position.y + shape.size.height - triangleHeight)) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.x -= delta;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.x += delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowBottomShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowBottomShapeDescription = ArrowBottomShapeDescription;


/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(65);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var ArrowEastWestShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowEastWestShapeDescription, _super);
    function ArrowEastWestShapeDescription() {
        return _super.call(this, "East-West Arrow") || this;
    }
    Object.defineProperty(ArrowEastWestShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowEastWest; },
        enumerable: true,
        configurable: true
    });
    ArrowEastWestShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowEastWestShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width / 2 - 2 * Shape_1.Shape.lineWidth, p.value)); });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    ArrowEastWestShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowEastWestShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    return ArrowEastWestShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowEastWestShapeDescription = ArrowEastWestShapeDescription;


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var PathPrimitive_1 = __webpack_require__(2);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(65);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var DiagramItem_1 = __webpack_require__(4);
var ArrowLeftShapeDescription = /** @class */ (function (_super) {
    __extends(ArrowLeftShapeDescription, _super);
    function ArrowLeftShapeDescription() {
        return _super.call(this, "Left Arrow") || this;
    }
    Object.defineProperty(ArrowLeftShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowLeft; },
        enumerable: true,
        configurable: true
    });
    ArrowLeftShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowLeftShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowLeftShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    ArrowLeftShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleWidth = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        if (point.x < shape.position.x + triangleWidth) {
            var tg = shape.size.height / 2 / triangleWidth;
            var delta = (shape.position.x + triangleWidth - point.x) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.North)
                point.y += delta;
            else if (side === DiagramItem_1.ConnectionPointSide.South)
                point.y -= delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowLeftShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowLeftShapeDescription = ArrowLeftShapeDescription;


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeTypes_1 = __webpack_require__(1);
var Shape_1 = __webpack_require__(9);
var PathPrimitive_1 = __webpack_require__(2);
var DocumentShapeDescription_1 = __webpack_require__(96);
var ClipPathPrimitive_1 = __webpack_require__(42);
var Utils_1 = __webpack_require__(15);
var MultipleDocumentsShapeDescription = /** @class */ (function (_super) {
    __extends(MultipleDocumentsShapeDescription, _super);
    function MultipleDocumentsShapeDescription() {
        return _super.call(this, "Multiple Documents", "Multiple\nDocuments") || this;
    }
    Object.defineProperty(MultipleDocumentsShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.MultipleDocuments; },
        enumerable: true,
        configurable: true
    });
    MultipleDocumentsShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var documentOffsetX = width * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        var documentOffsetY = height * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        rect = rect.inflate(-documentOffsetX, -documentOffsetY).offset(-documentOffsetX, -documentOffsetY);
        var rect1 = rect.offset(documentOffsetX, documentOffsetY);
        var rect2 = rect.offset(2 * documentOffsetX, 2 * documentOffsetY);
        var clipPathId = Utils_1.RenderUtils.generateSvgElementId("clipRect");
        var primitives = [];
        return primitives
            .concat(this.createDocumentPrimitives(rect, shape.style, clipPathId + "1", rect1))
            .concat(this.createDocumentPrimitives(rect1, shape.style, clipPathId + "2", rect2))
            .concat(this.createDocumentPrimitives(rect2, shape.style));
    };
    MultipleDocumentsShapeDescription.prototype.createDocumentPrimitives = function (rect, style, clipPathId, clipRect) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DocumentShapeDescription_1.DocumentShapeDescription.curveOffsetRatio;
        var primitives = [];
        primitives = primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style, undefined, clipRect && clipPathId)
        ]);
        if (clipRect && clipPathId) {
            primitives = primitives.concat([
                new ClipPathPrimitive_1.ClipPathPrimitive(clipPathId, [
                    new PathPrimitive_1.PathPrimitive([
                        new PathPrimitive_1.PathPrimitiveMoveToCommand(left - Shape_1.Shape.lineWidth, top - Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(right + Shape_1.Shape.lineWidth, top - Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(right + Shape_1.Shape.lineWidth, clipRect.top),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(clipRect.left, clipRect.top),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(clipRect.left, bottom + Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveLineToCommand(left - Shape_1.Shape.lineWidth, bottom + Shape_1.Shape.lineWidth),
                        new PathPrimitive_1.PathPrimitiveClosePathCommand()
                    ])
                ])
            ]);
        }
        return primitives;
    };
    MultipleDocumentsShapeDescription.prototype.getTextRectangle = function (rect) {
        var documentOffsetX = rect.width * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        var documentOffsetY = rect.height * MultipleDocumentsShapeDescription.documentsOffsetRatio;
        rect = rect.inflate(-documentOffsetX, -documentOffsetY).offset(-documentOffsetX, -documentOffsetY);
        var innerRect = rect.offset(2 * documentOffsetX, 2 * documentOffsetY);
        return innerRect.resize(0, -rect.height * DocumentShapeDescription_1.DocumentShapeDescription.curveOffsetRatio);
    };
    MultipleDocumentsShapeDescription.documentsOffsetRatio = 0.1;
    return MultipleDocumentsShapeDescription;
}(DocumentShapeDescription_1.DocumentShapeDescription));
exports.MultipleDocumentsShapeDescription = MultipleDocumentsShapeDescription;


/***/ }),
/* 164 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeTypes_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(8);
var HexagonShapeDescription_1 = __webpack_require__(94);
var PreparationShapeDescription = /** @class */ (function (_super) {
    __extends(PreparationShapeDescription, _super);
    function PreparationShapeDescription() {
        var _this = _super.call(this, "Preparation", "Preparation") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75);
        return _this;
    }
    Object.defineProperty(PreparationShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Preparation; },
        enumerable: true,
        configurable: true
    });
    return PreparationShapeDescription;
}(HexagonShapeDescription_1.HexagonShapeDescription));
exports.PreparationShapeDescription = PreparationShapeDescription;


/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var EllipsePrimitive_1 = __webpack_require__(29);
var HardDiskShapeDescription = /** @class */ (function (_super) {
    __extends(HardDiskShapeDescription, _super);
    function HardDiskShapeDescription() {
        return _super.call(this, "Hard Disk", "Hard Disk") || this;
    }
    Object.defineProperty(HardDiskShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.HardDisk; },
        enumerable: true,
        configurable: true
    });
    HardDiskShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * HardDiskShapeDescription.arcWidthRatio;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right - dx / 2, bottom),
            ], shape.style),
            new EllipsePrimitive_1.EllipsePrimitive(right - dx / 2, cy, dx / 2, (bottom - top) / 2, shape.style)
        ];
    };
    HardDiskShapeDescription.prototype.getTextRectangle = function (rect) {
        var dx = rect.width * HardDiskShapeDescription.arcWidthRatio;
        return rect.resize(-dx, 0);
    };
    HardDiskShapeDescription.arcWidthRatio = 0.2;
    return HardDiskShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.HardDiskShapeDescription = HardDiskShapeDescription;


/***/ }),
/* 166 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var EllipsePrimitive_1 = __webpack_require__(29);
var DatabaseShapeDescription = /** @class */ (function (_super) {
    __extends(DatabaseShapeDescription, _super);
    function DatabaseShapeDescription() {
        var _this = _super.call(this, "Database", "Database") || this;
        _this.defaultSize.width = _this.defaultSize.height;
        return _this;
    }
    Object.defineProperty(DatabaseShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Database; },
        enumerable: true,
        configurable: true
    });
    DatabaseShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DatabaseShapeDescription.arcWidthRatio;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right, top + dy / 2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom - dy / 2),
                new PathPrimitive_1.PathPrimitiveArcToCommand((right - left) / 2, dy / 2, 0, false, true, left, bottom - dy / 2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, top + dy / 2),
            ], shape.style),
            new EllipsePrimitive_1.EllipsePrimitive(cx, top + dy / 2, (right - left) / 2, dy / 2, shape.style)
        ];
    };
    DatabaseShapeDescription.prototype.getTextRectangle = function (rect) {
        var dy = rect.height * DatabaseShapeDescription.arcWidthRatio;
        return rect.resize(0, -dy).offset(0, dy);
    };
    DatabaseShapeDescription.arcWidthRatio = 0.2;
    return DatabaseShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DatabaseShapeDescription = DatabaseShapeDescription;


/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var ShapeParameters_1 = __webpack_require__(28);
var ShapeParameterPoint_1 = __webpack_require__(20);
var Utils_1 = __webpack_require__(0);
var PathPrimitive_1 = __webpack_require__(2);
exports.InternalStorageHorizontalEdgeParameterName = "he";
exports.InternalStorageVerticalEdgeParameterName = "ve";
var InternalStorageShapeDescription = /** @class */ (function (_super) {
    __extends(InternalStorageShapeDescription, _super);
    function InternalStorageShapeDescription() {
        return _super.call(this, "Internal Storage", "Internal\nStorage") || this;
    }
    Object.defineProperty(InternalStorageShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.InternalStorage; },
        enumerable: true,
        configurable: true
    });
    InternalStorageShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var x = left + shape.parameters.get(exports.InternalStorageHorizontalEdgeParameterName).value;
        var y = top + shape.parameters.get(exports.InternalStorageVerticalEdgeParameterName).value;
        var primitives = _super.prototype.createShapePrimitives.call(this, shape);
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y)
            ], shape.style)
        ]);
    };
    InternalStorageShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRange([
            new ShapeParameters_1.ShapeParameter(exports.InternalStorageHorizontalEdgeParameterName, this.defaultSize.width * 0.1),
            new ShapeParameters_1.ShapeParameter(exports.InternalStorageVerticalEdgeParameterName, this.defaultSize.width * 0.1)
        ]);
    };
    InternalStorageShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.InternalStorageHorizontalEdgeParameterName, function (p) { return Math.max(InternalStorageShapeDescription.minEdge, Math.min(shape.size.width * 0.3, p.value)); });
        this.changeParameterValue(parameters, exports.InternalStorageVerticalEdgeParameterName, function (p) { return Math.max(InternalStorageShapeDescription.minEdge, Math.min(shape.size.height * 0.3, p.value)); });
    };
    InternalStorageShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.InternalStorageHorizontalEdgeParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, exports.InternalStorageVerticalEdgeParameterName, function (p) { return p.value + deltaY; });
        this.normalizeParameters(shape, parameters);
    };
    InternalStorageShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new Utils_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(exports.InternalStorageHorizontalEdgeParameterName).value), shape.normalizeY(shape.position.y + shape.parameters.get(exports.InternalStorageVerticalEdgeParameterName).value)))
        ];
    };
    InternalStorageShapeDescription.minEdge = 72;
    return InternalStorageShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.InternalStorageShapeDescription = InternalStorageShapeDescription;


/***/ }),
/* 168 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(4);
var PaperTapeShapeDescription = /** @class */ (function (_super) {
    __extends(PaperTapeShapeDescription, _super);
    function PaperTapeShapeDescription(title, defaultText) {
        if (title === void 0) { title = "Paper Tape"; }
        if (defaultText === void 0) { defaultText = "Paper Tape"; }
        return _super.call(this, title, defaultText) || this;
    }
    Object.defineProperty(PaperTapeShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.PaperTape; },
        enumerable: true,
        configurable: true
    });
    PaperTapeShapeDescription.prototype.createShapePrimitives = function (shape) {
        return this.createDocumentPrimitives(shape.rectangle, shape.style);
    };
    PaperTapeShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * PaperTapeShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, top + 2 * dy, cx, top + dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, top - dy, right, top + dy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    PaperTapeShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
    };
    PaperTapeShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.inflate(0, -rect.height * PaperTapeShapeDescription.curveOffsetRatio);
    };
    PaperTapeShapeDescription.curveOffsetRatio = 0.1;
    return PaperTapeShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PaperTapeShapeDescription = PaperTapeShapeDescription;


/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DiagramItem_1 = __webpack_require__(4);
var ManualOperationShapeDescription = /** @class */ (function (_super) {
    __extends(ManualOperationShapeDescription, _super);
    function ManualOperationShapeDescription() {
        return _super.call(this, "Manual Operation", "Manual\nOperation") || this;
    }
    Object.defineProperty(ManualOperationShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ManualOperation; },
        enumerable: true,
        configurable: true
    });
    ManualOperationShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var _a = shape.rectangle, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(ManualOperationShapeDescription.slopeAngle)), width);
        var cx = rect.center.x;
        var x1 = Math.min(left + px, cx);
        var x2 = Math.max(right - px, cx);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ManualOperationShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var offset = shape.size.height / Math.tan(ManualOperationShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    ManualOperationShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return ManualOperationShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ManualOperationShapeDescription = ManualOperationShapeDescription;


/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DelayShapeDescription = /** @class */ (function (_super) {
    __extends(DelayShapeDescription, _super);
    function DelayShapeDescription() {
        var _this = _super.call(this, "Delay", "Delay") || this;
        _this.defaultSize.width = _this.defaultSize.height;
        return _this;
    }
    Object.defineProperty(DelayShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Delay; },
        enumerable: true,
        configurable: true
    });
    DelayShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var cx = rect.center.x;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand((right - left) / 2, (bottom - top) / 2, 0, false, true, cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    DelayShapeDescription.arcWidthRatio = 0.2;
    return DelayShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DelayShapeDescription = DelayShapeDescription;


/***/ }),
/* 171 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var StoredDataShapeDescription = /** @class */ (function (_super) {
    __extends(StoredDataShapeDescription, _super);
    function StoredDataShapeDescription() {
        return _super.call(this, "Stored Data", "Stored Data") || this;
    }
    Object.defineProperty(StoredDataShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.StoredData; },
        enumerable: true,
        configurable: true
    });
    StoredDataShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * StoredDataShapeDescription.arcWidthRatio;
        var primitives = [];
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, true, right, top)
            ], shape.style)
        ];
    };
    StoredDataShapeDescription.prototype.getTextRectangle = function (rect) {
        var dx = rect.width * StoredDataShapeDescription.arcWidthRatio;
        return rect.resize(-dx, 0);
    };
    StoredDataShapeDescription.arcWidthRatio = 0.2;
    return StoredDataShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.StoredDataShapeDescription = StoredDataShapeDescription;


/***/ }),
/* 172 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeTypes_1 = __webpack_require__(1);
var TriangleShapeDescription_1 = __webpack_require__(95);
var PathPrimitive_1 = __webpack_require__(2);
var MergeShapeDescription = /** @class */ (function (_super) {
    __extends(MergeShapeDescription, _super);
    function MergeShapeDescription() {
        return _super.call(this, "Merge", "Merge") || this;
    }
    Object.defineProperty(MergeShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Merge; },
        enumerable: true,
        configurable: true
    });
    MergeShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(rect.center.x, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    MergeShapeDescription.prototype.calculateHeight = function (width) {
        return width * 0.75;
    };
    MergeShapeDescription.prototype.getTextRectangle = function (rect) {
        return rect.resize(0, -rect.width * 0.25);
    };
    return MergeShapeDescription;
}(TriangleShapeDescription_1.TriangleShapeDescription));
exports.MergeShapeDescription = MergeShapeDescription;


/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RectangleShapeDescription_1 = __webpack_require__(14);
var ShapeTypes_1 = __webpack_require__(1);
var PathPrimitive_1 = __webpack_require__(2);
var DisplayShapeDescription = /** @class */ (function (_super) {
    __extends(DisplayShapeDescription, _super);
    function DisplayShapeDescription() {
        return _super.call(this, "Display", "Display") || this;
    }
    Object.defineProperty(DisplayShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Display; },
        enumerable: true,
        configurable: true
    });
    DisplayShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var dx = width * DisplayShapeDescription.arcWidthRatio;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right - dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, right - dx / 2, top)
            ], shape.style),
        ];
    };
    DisplayShapeDescription.arcWidthRatio = 0.2;
    return DisplayShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DisplayShapeDescription = DisplayShapeDescription;


/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeTypes_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(8);
var EllipseShapeDescription_1 = __webpack_require__(66);
var PathPrimitive_1 = __webpack_require__(2);
var OrShapeDescription = /** @class */ (function (_super) {
    __extends(OrShapeDescription, _super);
    function OrShapeDescription() {
        var _this = _super.call(this, "Or", "") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(OrShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Or; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(OrShapeDescription.prototype, "enableText", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    OrShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var primitives = [];
        return primitives
            .concat(_super.prototype.createShapePrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy)
            ], shape.style)
        ]);
    };
    return OrShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.OrShapeDescription = OrShapeDescription;


/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeTypes_1 = __webpack_require__(1);
var Utils_1 = __webpack_require__(0);
var ShapeDescription_1 = __webpack_require__(8);
var EllipseShapeDescription_1 = __webpack_require__(66);
var PathPrimitive_1 = __webpack_require__(2);
var SummingJunctionShapeDescription = /** @class */ (function (_super) {
    __extends(SummingJunctionShapeDescription, _super);
    function SummingJunctionShapeDescription() {
        var _this = _super.call(this, "Summing Junction", "") || this;
        _this.defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.SummingJunction; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "enableText", {
        get: function () { return false; },
        enumerable: true,
        configurable: true
    });
    SummingJunctionShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var rx = width / 2;
        var ry = height / 2;
        var angle = Math.atan(ry / rx);
        var ex = 1 / Math.sqrt(1 / Math.pow(rx, 2) + Math.pow(Math.tan(angle), 2) / Math.pow(ry, 2));
        var ey = ex * Math.tan(angle);
        var primitives = [];
        return primitives
            .concat(_super.prototype.createShapePrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy - ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy - ey)
            ], shape.style)
        ]);
    };
    return SummingJunctionShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.SummingJunctionShapeDescription = SummingJunctionShapeDescription;


/***/ }),
/* 176 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ImagePrimitive_1 = __webpack_require__(97);
var Utils_1 = __webpack_require__(0);
var ConnectionPoint_1 = __webpack_require__(34);
var DiagramItem_1 = __webpack_require__(4);
var ShapeWithImageDescription_1 = __webpack_require__(45);
var ImageInfo_1 = __webpack_require__(40);
var ImageCache_1 = __webpack_require__(49);
var ImageLoader_1 = __webpack_require__(98);
var CustomShapeDescription = /** @class */ (function (_super) {
    __extends(CustomShapeDescription, _super);
    function CustomShapeDescription(properties, baseDescription) {
        var _this = _super.call(this, properties.title || baseDescription && baseDescription.title, properties.defaultText || baseDescription && baseDescription.defaultText, new Utils_1.Size(properties.defaultWidth || baseDescription && baseDescription.defaultSize.width || 1440, properties.defaultHeight || baseDescription && baseDescription.defaultSize.height || 1440), properties.defaultImageUrl || baseDescription && baseDescription.defaultImageUrl) || this;
        _this.properties = properties;
        _this.baseDescription = baseDescription;
        _this.imageLoader = new ImageLoader_1.ImageLoader(_this.updateSvgImage.bind(_this));
        _this.connectionPoints = _this.createConnectionPoints();
        _this.svgImage = new ImageInfo_1.ImageInfo(properties.svgUrl);
        var cachedImage = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(_this.svgImage);
        _this.imageLoader.load(cachedImage);
        return _this;
    }
    Object.defineProperty(CustomShapeDescription.prototype, "key", {
        get: function () { return this.properties.type; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "allowEditText", {
        get: function () { return !!this.properties.allowEditText; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "allowEditImage", {
        get: function () { return !!this.properties.allowEditImage; },
        enumerable: true,
        configurable: true
    });
    CustomShapeDescription.prototype.createConnectionPoints = function () {
        if (this.properties && this.properties.connectionPoints && this.properties.connectionPoints.length)
            return this.properties.connectionPoints.map(function (ptObj) {
                if (ptObj && typeof ptObj["x"] === "number" && typeof ptObj["y"] === "number") {
                    var side = typeof ptObj["side"] === "number" ? ptObj["side"] : DiagramItem_1.ConnectionPointSide.Undefined;
                    return new ConnectionPoint_1.ConnectionPoint(ptObj["x"], ptObj["y"], side);
                }
            }).filter(function (pt) { return pt; });
        return _super.prototype.createConnectionPoints.call(this);
    };
    CustomShapeDescription.prototype.createImagePrimitives = function (shape, forToolbox) {
        if (this.baseDescription)
            return this.baseDescription.createImagePrimitives(shape, forToolbox);
        return _super.prototype.createImagePrimitives.call(this, shape, forToolbox);
    };
    CustomShapeDescription.prototype.createShapePrimitives = function (shape, forToolbox) {
        if (this.baseDescription)
            return this.baseDescription.createShapePrimitives(shape, forToolbox);
        else {
            var _a = shape.rectangle, left = _a.left, top_1 = _a.top, width = _a.width, height = _a.height;
            return [
                new ImagePrimitive_1.ImagePrimitive(left + (this.properties.svgLeft && !forToolbox ? this.properties.svgLeft * width : 0), top_1 + (this.properties.svgTop && !forToolbox ? this.properties.svgTop * height : 0), this.properties.svgWidth && !forToolbox ? this.properties.svgWidth * width : width, this.properties.svgHeight && !forToolbox ? this.properties.svgHeight * height : height, this.svgImage.exportUrl)
            ];
        }
    };
    CustomShapeDescription.prototype.getTextRectangle = function (rect) {
        var left = rect.left, top = rect.top, width = rect.width, height = rect.height;
        return Utils_1.Rectangle.create(left + (this.properties.textLeft ? this.properties.textLeft * width : 0), top + (this.properties.textTop ? this.properties.textTop * height : 0), this.properties.textWidth ? this.properties.textWidth * width : width, this.properties.textHeight ? this.properties.textHeight * height : height);
    };
    CustomShapeDescription.prototype.getRawImageSize = function (rect) {
        var left = rect.left, top = rect.top, width = rect.width, height = rect.height;
        return new Utils_1.Size(this.properties.imageWidth ? this.properties.imageWidth * width : width, this.properties.imageHeight ? this.properties.imageHeight * height : height);
    };
    CustomShapeDescription.prototype.getImagePlacementRectangle = function (rect, forToolbox) {
        var left = rect.left, top = rect.top, width = rect.width, height = rect.height;
        return Utils_1.Rectangle.create(left + (this.properties.imageLeft && !forToolbox ? this.properties.imageLeft * width : 0), top + (this.properties.imageTop && !forToolbox ? this.properties.imageTop * height : 0), this.properties.imageWidth && !forToolbox ? this.properties.imageWidth * width : 0, this.properties.imageHeight && !forToolbox ? this.properties.imageHeight * height : 0);
    };
    CustomShapeDescription.prototype.updateSvgImage = function (cacheImageInfo) {
        if (cacheImageInfo.base64)
            this.svgImage.loadBase64Content(cacheImageInfo.base64);
        else
            this.svgImage.setUnableToLoadFlag();
    };
    return CustomShapeDescription;
}(ShapeWithImageDescription_1.ShapeWithImageDescription));
exports.CustomShapeDescription = CustomShapeDescription;


/***/ }),
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var EllipsePrimitive_1 = __webpack_require__(29);
var PathPrimitive_1 = __webpack_require__(2);
var __1 = __webpack_require__(10);
var GroupPrimitive_1 = __webpack_require__(22);
var Browser_1 = __webpack_require__(24);
var LoadingIndicatorPrimitive = /** @class */ (function (_super) {
    __extends(LoadingIndicatorPrimitive, _super);
    function LoadingIndicatorPrimitive(x, y, r, thickness, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, [], className, undefined, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.r = r;
        _this.thickness = thickness;
        _this.animationStarted = false;
        _this.createChildren();
        return _this;
    }
    LoadingIndicatorPrimitive.prototype.createChildren = function () {
        var _a = this.center, centerX = _a[0], centerY = _a[1], radius = __1.UnitConverter.twipsToPixelsF(this.r - this.thickness / 2);
        this.children = [
            new EllipsePrimitive_1.EllipsePrimitive(centerX + "", centerY + "", radius + "", radius + ""),
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand((centerX + radius) + "", centerY + ""),
                new PathPrimitive_1.PathPrimitiveArcToCommand(radius + "", radius + "", 0, false, false, centerX + "", (centerY - radius) + "")
            ])
        ];
    };
    Object.defineProperty(LoadingIndicatorPrimitive.prototype, "center", {
        get: function () {
            return [__1.UnitConverter.twipsToPixelsF(this.x + this.r), __1.UnitConverter.twipsToPixelsF(this.y + this.r)];
        },
        enumerable: true,
        configurable: true
    });
    LoadingIndicatorPrimitive.prototype.applyElementProperties = function (element) {
        this.setupAnimation(element);
        _super.prototype.applyElementProperties.call(this, element);
    };
    LoadingIndicatorPrimitive.prototype.setupAnimation = function (element) {
        var _a = this.center, centerX = _a[0], centerY = _a[1];
        if (Browser_1.Browser.IE) {
            this.animationRequestId = requestAnimationFrame(function (timestamp) {
                this.rotate(element, centerX, centerY, timestamp);
            }.bind(this));
            this.animationStarted = true;
        }
        else
            element.style.setProperty("transform-origin", centerX + "px " + centerY + "px");
    };
    LoadingIndicatorPrimitive.prototype.rotate = function (element, centerX, centerY, timestamp) {
        if (!this.animationStarted)
            return;
        var angle = (Math.round(timestamp) % 1080) / 3;
        var transformAttributeValue = "rotate(" + angle + " " + centerX + " " + centerY + ")";
        element.setAttribute("transform", transformAttributeValue);
        this.animationRequestId = requestAnimationFrame(function (timestamp) {
            this.rotate(element, centerX, centerY, timestamp);
        }.bind(this));
    };
    LoadingIndicatorPrimitive.prototype.dispose = function () {
        if (this.animationRequestId)
            cancelAnimationFrame(this.animationRequestId);
        this.animationStarted = false;
        _super.prototype.dispose.call(this);
    };
    return LoadingIndicatorPrimitive;
}(GroupPrimitive_1.GroupPrimitive));
exports.LoadingIndicatorPrimitive = LoadingIndicatorPrimitive;


/***/ }),
/* 178 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var EllipsePrimitive_1 = __webpack_require__(29);
var PathPrimitive_1 = __webpack_require__(2);
var __1 = __webpack_require__(10);
var GroupPrimitive_1 = __webpack_require__(22);
var UserPrimitive = /** @class */ (function (_super) {
    __extends(UserPrimitive, _super);
    function UserPrimitive(x, y, size, thickness, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, [], className, undefined, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.size = size;
        _this.thickness = thickness;
        _this.createChildren();
        return _this;
    }
    UserPrimitive.prototype.createChildren = function () {
        var _a = this.center, centerX = _a[0], centerY = _a[1], radius = __1.UnitConverter.twipsToPixelsF(this.size / 2 - this.thickness / 2), sizeInPixels = __1.UnitConverter.twipsToPixelsF(this.size);
        this.children = [
            new EllipsePrimitive_1.EllipsePrimitive(centerX + "", centerY + "", radius + "", radius + "", undefined, "dxdi-background"),
            new EllipsePrimitive_1.EllipsePrimitive(centerX + "", centerY - sizeInPixels / 8 + "", sizeInPixels / 8 + "", sizeInPixels / 8 + ""),
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(centerX + "", centerY + sizeInPixels / 16 + ""),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(centerX + 0.1375 * sizeInPixels + "", centerY + sizeInPixels / 16 + "", centerX + sizeInPixels / 4 + "", centerY
                    + 0.11875 * sizeInPixels + "", centerX + sizeInPixels / 4 + "", centerY + 0.1875 * sizeInPixels + ""),
                new PathPrimitive_1.PathPrimitiveLineToCommand(centerX + sizeInPixels / 4 + "", centerY + sizeInPixels / 4 + ""),
                new PathPrimitive_1.PathPrimitiveLineToCommand(centerX - sizeInPixels / 4 + "", centerY + sizeInPixels / 4 + ""),
                new PathPrimitive_1.PathPrimitiveLineToCommand(centerX - sizeInPixels / 4 + "", centerY + 0.1875 * sizeInPixels + ""),
                new PathPrimitive_1.PathPrimitiveCubicCurveToCommand(centerX - sizeInPixels / 4 + "", centerY + 0.11875 * sizeInPixels + "", centerX - 0.1375 * sizeInPixels + "", centerY
                    + sizeInPixels / 16 + "", centerX + "", centerY + sizeInPixels / 16 + ""),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ])
        ];
    };
    Object.defineProperty(UserPrimitive.prototype, "center", {
        get: function () {
            return [__1.UnitConverter.twipsToPixelsF(this.x + this.size / 2), __1.UnitConverter.twipsToPixelsF(this.y + this.size / 2)];
        },
        enumerable: true,
        configurable: true
    });
    return UserPrimitive;
}(GroupPrimitive_1.GroupPrimitive));
exports.UserPrimitive = UserPrimitive;


/***/ }),
/* 179 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var EllipsePrimitive_1 = __webpack_require__(29);
var __1 = __webpack_require__(10);
var GroupPrimitive_1 = __webpack_require__(22);
var RectaglePrimitive_1 = __webpack_require__(18);
var WarningPrimitive = /** @class */ (function (_super) {
    __extends(WarningPrimitive, _super);
    function WarningPrimitive(x, y, size, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, [], className, undefined, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.size = size;
        _this.createChildren();
        return _this;
    }
    WarningPrimitive.prototype.createChildren = function () {
        var _a = this.center, centerX = _a[0], centerY = _a[1], radius = __1.UnitConverter.twipsToPixelsF(this.size / 2) - 1, exclamationLineWidth = __1.UnitConverter.twipsToPixelsF(this.size / 8);
        this.children = [
            new EllipsePrimitive_1.EllipsePrimitive(centerX + "", centerY + "", radius + "", radius + ""),
            new RectaglePrimitive_1.RectanglePrimitive(centerX - exclamationLineWidth / 2 + 0.5 + "", centerY + radius - __1.UnitConverter.twipsToPixelsF(this.size / 4) + "", exclamationLineWidth + "", exclamationLineWidth + ""),
            new RectaglePrimitive_1.RectanglePrimitive(centerX - exclamationLineWidth / 2 + 0.5 + "", centerY - radius + __1.UnitConverter.twipsToPixelsF(this.size / 4) - exclamationLineWidth + "", exclamationLineWidth + "", radius + "")
        ];
    };
    Object.defineProperty(WarningPrimitive.prototype, "center", {
        get: function () {
            return [__1.UnitConverter.twipsToPixelsF(this.x + this.size / 2), __1.UnitConverter.twipsToPixelsF(this.y + this.size / 2)];
        },
        enumerable: true,
        configurable: true
    });
    return WarningPrimitive;
}(GroupPrimitive_1.GroupPrimitive));
exports.WarningPrimitive = WarningPrimitive;


/***/ }),
/* 180 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var ContainerDescription_1 = __webpack_require__(99);
var RectaglePrimitive_1 = __webpack_require__(18);
var VerticalContainerDescription = /** @class */ (function (_super) {
    __extends(VerticalContainerDescription, _super);
    function VerticalContainerDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Vertical Container"; }
        if (defaultText === void 0) { defaultText = "Container"; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 2, ShapeDescription_1.ShapeDefaultDimension * 1.5); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(VerticalContainerDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.VerticalContainer; },
        enumerable: true,
        configurable: true
    });
    VerticalContainerDescription.prototype.getExpandedSize = function (size, expandedSize) {
        return new Utils_1.Size(size.width, expandedSize.height);
    };
    VerticalContainerDescription.prototype.getCollapsedSize = function (size) {
        return new Utils_1.Size(size.width, ContainerDescription_1.ContainerDescription.headerSize);
    };
    VerticalContainerDescription.prototype.allowResizeVertically = function (shape) {
        return shape.expanded;
    };
    VerticalContainerDescription.prototype.createHeaderPrimitives = function (shape, forToolbox) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, width = rect.width;
        var headerSize = this.getHeaderSize(rect, forToolbox);
        var primitives = [];
        primitives = primitives.concat([
            new RectaglePrimitive_1.RectanglePrimitive(left, top, width, headerSize, shape.style)
        ]);
        if (!forToolbox) {
            primitives = primitives.concat(this.createExpandButtonPrimitives(shape, Utils_1.Rectangle.create(left, top, headerSize, headerSize)));
        }
        return primitives;
    };
    VerticalContainerDescription.prototype.getClientRectangle = function (rect) {
        var headerSize = this.getHeaderSize(rect);
        return new Utils_1.Rectangle(new Utils_1.Point(rect.left, rect.top + headerSize), new Utils_1.Size(rect.width, rect.height - headerSize));
    };
    VerticalContainerDescription.prototype.getTextRectangle = function (rect) {
        var headerSize = this.getHeaderSize(rect);
        return new Utils_1.Rectangle(new Utils_1.Point(rect.left + headerSize, rect.top), new Utils_1.Size(rect.width - headerSize, headerSize));
    };
    VerticalContainerDescription.prototype.getHeaderSize = function (rect, forToolbox) {
        return forToolbox ? rect.height * ContainerDescription_1.ContainerDescription.headerToolboxSizeRatio : ContainerDescription_1.ContainerDescription.headerSize;
    };
    return VerticalContainerDescription;
}(ContainerDescription_1.ContainerDescription));
exports.VerticalContainerDescription = VerticalContainerDescription;


/***/ }),
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var ContainerDescription_1 = __webpack_require__(99);
var RectaglePrimitive_1 = __webpack_require__(18);
var HorizontalContainerDescription = /** @class */ (function (_super) {
    __extends(HorizontalContainerDescription, _super);
    function HorizontalContainerDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Horizontal Container"; }
        if (defaultText === void 0) { defaultText = "Container"; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(ShapeDescription_1.ShapeDefaultDimension * 2, ShapeDescription_1.ShapeDefaultDimension * 1.5); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(HorizontalContainerDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.HorizontalContainer; },
        enumerable: true,
        configurable: true
    });
    HorizontalContainerDescription.prototype.getExpandedSize = function (size, expandedSize) {
        return new Utils_1.Size(expandedSize.width, size.height);
    };
    HorizontalContainerDescription.prototype.getCollapsedSize = function (size) {
        return new Utils_1.Size(ContainerDescription_1.ContainerDescription.headerSize, size.height);
    };
    HorizontalContainerDescription.prototype.allowResizeHorizontally = function (shape) {
        return shape.expanded;
    };
    HorizontalContainerDescription.prototype.createHeaderPrimitives = function (shape, forToolbox) {
        var rect = shape.rectangle;
        var left = rect.left, top = rect.top, height = rect.height;
        var headerSize = this.getHeaderSize(rect, forToolbox);
        var primitives = [];
        primitives = primitives.concat([
            new RectaglePrimitive_1.RectanglePrimitive(left, top, headerSize, height, shape.style)
        ]);
        if (!forToolbox) {
            primitives = primitives.concat(this.createExpandButtonPrimitives(shape, Utils_1.Rectangle.create(left, top, headerSize, headerSize)));
        }
        return primitives;
    };
    HorizontalContainerDescription.prototype.getClientRectangle = function (rect) {
        var headerSize = this.getHeaderSize(rect);
        return new Utils_1.Rectangle(new Utils_1.Point(rect.left + headerSize, rect.top), new Utils_1.Size(rect.width - headerSize, rect.height));
    };
    HorizontalContainerDescription.prototype.getTextRectangle = function (rect) {
        var headerSize = this.getHeaderSize(rect);
        return new Utils_1.Rectangle(new Utils_1.Point(rect.left, rect.top + headerSize), new Utils_1.Size(headerSize, rect.height - headerSize));
    };
    HorizontalContainerDescription.prototype.getTextEditRectangle = function (rect) {
        return new Utils_1.Rectangle(rect.position, new Utils_1.Size(rect.width, this.getHeaderSize(rect)));
    };
    HorizontalContainerDescription.prototype.getTextRotated = function () {
        return true;
    };
    HorizontalContainerDescription.prototype.getHeaderSize = function (rect, forToolbox) {
        return forToolbox ? rect.height * ContainerDescription_1.ContainerDescription.headerToolboxSizeRatio : ContainerDescription_1.ContainerDescription.headerSize;
    };
    return HorizontalContainerDescription;
}(ContainerDescription_1.ContainerDescription));
exports.HorizontalContainerDescription = HorizontalContainerDescription;


/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var CardBaseDescription_1 = __webpack_require__(68);
var ShapeWithImageDescription_1 = __webpack_require__(45);
var CardWithImageOnLeftDescription = /** @class */ (function (_super) {
    __extends(CardWithImageOnLeftDescription, _super);
    function CardWithImageOnLeftDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Card with Image on the Left"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(1.5 * ShapeDescription_1.ShapeDefaultDimension, 0.5 * ShapeDescription_1.ShapeDefaultDimension); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(CardWithImageOnLeftDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.CardWithImageOnLeft; },
        enumerable: true,
        configurable: true
    });
    CardWithImageOnLeftDescription.prototype.getToolboxHeightToWidthRatio = function (width, height) {
        return 26 / 46;
    };
    CardWithImageOnLeftDescription.prototype.getRawImageSize = function (rect, forToolbox) {
        var imageSize = Math.min(rect.height, rect.width) - 2 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(forToolbox);
        return new Utils_1.Size(imageSize, imageSize);
    };
    CardWithImageOnLeftDescription.prototype.getTextBlockOffset = function (rect, forToolbox) {
        return new Utils_1.Offset(this.getImageSize(rect, forToolbox).width, 0, 0, 0);
    };
    return CardWithImageOnLeftDescription;
}(CardBaseDescription_1.CardBaseDescription));
exports.CardWithImageOnLeftDescription = CardWithImageOnLeftDescription;


/***/ }),
/* 183 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RenderManager_1 = __webpack_require__(11);
var RectaglePrimitive_1 = __webpack_require__(18);
var RoundedRectanglePrimitive = /** @class */ (function (_super) {
    __extends(RoundedRectanglePrimitive, _super);
    function RoundedRectanglePrimitive(x, y, width, height, rx, ry, style, className, clipPathId, onApplyProperties) {
        if (rx === void 0) { rx = 0; }
        if (ry === void 0) { ry = 0; }
        var _this = _super.call(this, x, y, width, height, style, className, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.rx = rx;
        _this.ry = ry;
        return _this;
    }
    RoundedRectanglePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderManager_1.svgNS, "rect");
    };
    RoundedRectanglePrimitive.prototype.applyElementProperties = function (element) {
        this.setUnitAttribute(element, "rx", this.rx);
        this.setUnitAttribute(element, "ry", this.ry);
        _super.prototype.applyElementProperties.call(this, element);
    };
    return RoundedRectanglePrimitive;
}(RectaglePrimitive_1.RectanglePrimitive));
exports.RoundedRectanglePrimitive = RoundedRectanglePrimitive;


/***/ }),
/* 184 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var CardBaseDescription_1 = __webpack_require__(68);
var ShapeWithImageDescription_1 = __webpack_require__(45);
var CardWithImageOnRightDescription = /** @class */ (function (_super) {
    __extends(CardWithImageOnRightDescription, _super);
    function CardWithImageOnRightDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Card with Image on the Right"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(1.5 * ShapeDescription_1.ShapeDefaultDimension, 0.5 * ShapeDescription_1.ShapeDefaultDimension); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(CardWithImageOnRightDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.CardWithImageOnRight; },
        enumerable: true,
        configurable: true
    });
    CardWithImageOnRightDescription.prototype.getToolboxHeightToWidthRatio = function (width, height) {
        return 26 / 46;
    };
    CardWithImageOnRightDescription.prototype.getRawImageSize = function (rect, forToolbox) {
        var imageSize = Math.min(rect.height, rect.width) - 2 * ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(forToolbox);
        return new Utils_1.Size(imageSize, imageSize);
    };
    CardWithImageOnRightDescription.prototype.getTextBlockOffset = function (rect, forToolbox) {
        return new Utils_1.Offset(0, 0, this.getImageSize(rect, forToolbox).width, 0);
    };
    return CardWithImageOnRightDescription;
}(CardBaseDescription_1.CardBaseDescription));
exports.CardWithImageOnRightDescription = CardWithImageOnRightDescription;


/***/ }),
/* 185 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ShapeDescription_1 = __webpack_require__(8);
var Utils_1 = __webpack_require__(0);
var ShapeTypes_1 = __webpack_require__(1);
var CardBaseDescription_1 = __webpack_require__(68);
var ShapeWithImageDescription_1 = __webpack_require__(45);
var CardWithImageOnTopDescription = /** @class */ (function (_super) {
    __extends(CardWithImageOnTopDescription, _super);
    function CardWithImageOnTopDescription(title, defaultText, defaultSize) {
        if (title === void 0) { title = "Card with Image on the Top"; }
        if (defaultText === void 0) { defaultText = ""; }
        if (defaultSize === void 0) { defaultSize = new Utils_1.Size(32 / 40 * ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension); }
        return _super.call(this, title, defaultText, defaultSize) || this;
    }
    Object.defineProperty(CardWithImageOnTopDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.CardWithImageOnTop; },
        enumerable: true,
        configurable: true
    });
    CardWithImageOnTopDescription.prototype.getRawImageSize = function (rect, forToolbox) {
        var imageSize = Math.min(rect.width / 2 + 1, rect.height - ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(forToolbox) * 2);
        return new Utils_1.Size(imageSize, imageSize);
    };
    CardWithImageOnTopDescription.prototype.getTextBlockOffset = function (rect, forToolbox) {
        return new Utils_1.Offset(0, this.getImageSize(rect).height + ShapeWithImageDescription_1.ShapeWithImageDescription.getImageMargins(forToolbox), 0, 0);
    };
    return CardWithImageOnTopDescription;
}(CardBaseDescription_1.CardBaseDescription));
exports.CardWithImageOnTopDescription = CardWithImageOnTopDescription;


/***/ }),
/* 186 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var InsertToContainerHistoryItem = /** @class */ (function (_super) {
    __extends(InsertToContainerHistoryItem, _super);
    function InsertToContainerHistoryItem(item, container) {
        var _this = _super.call(this) || this;
        _this.containerKey = container.key;
        _this.itemKey = item.key;
        return _this;
    }
    InsertToContainerHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        var container = manipulator.model.findShape(this.containerKey);
        manipulator.insertToContainer(item, container);
    };
    InsertToContainerHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.removeFromContainer(item);
    };
    return InsertToContainerHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.InsertToContainerHistoryItem = InsertToContainerHistoryItem;


/***/ }),
/* 187 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var RemoveFromContainerHistoryItem = /** @class */ (function (_super) {
    __extends(RemoveFromContainerHistoryItem, _super);
    function RemoveFromContainerHistoryItem(item) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        return _this;
    }
    RemoveFromContainerHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.containerKey = item.container && item.container.key;
        manipulator.removeFromContainer(item);
    };
    RemoveFromContainerHistoryItem.prototype.undo = function (manipulator) {
        var container = manipulator.model.findContainer(this.containerKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.insertToContainer(item, container);
    };
    return RemoveFromContainerHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.RemoveFromContainerHistoryItem = RemoveFromContainerHistoryItem;


/***/ }),
/* 188 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangeContainerLockedHistoryItem = /** @class */ (function (_super) {
    __extends(ChangeContainerLockedHistoryItem, _super);
    function ChangeContainerLockedHistoryItem(item, locked) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.containerLocked = locked;
        return _this;
    }
    ChangeContainerLockedHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldContainerLocked = item.containerLocked;
        manipulator.changeContainerLocked(item, this.containerLocked);
    };
    ChangeContainerLockedHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeContainerLocked(item, this.oldContainerLocked);
    };
    return ChangeContainerLockedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeContainerLockedHistoryItem = ChangeContainerLockedHistoryItem;


/***/ }),
/* 189 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var LayoutUtils_1 = __webpack_require__(190);
var GraphInfo = /** @class */ (function () {
    function GraphInfo(container, graph) {
        this.container = container;
        this.graph = graph;
    }
    GraphInfo.prototype.getNodeInfoGraph = function () {
        return this.graph.cast(LayoutUtils_1.LayoutUtils.shapeToLayout);
    };
    return GraphInfo;
}());
exports.GraphInfo = GraphInfo;


/***/ }),
/* 190 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Connector_1 = __webpack_require__(5);
var NodeLayout_1 = __webpack_require__(56);
var LayoutUtils = /** @class */ (function () {
    function LayoutUtils() {
    }
    LayoutUtils.shapeToLayout = function (shape) {
        var margin = new NodeLayout_1.Margin(0);
        var shapeRect = shape.rectangle;
        shape.attachedConnectors.filter(function (c) { return !c.beginItem || !c.endItem; }).forEach(function (c) {
            var connRect = c.rectangle;
            margin.left = Math.max(margin.left, shapeRect.left - connRect.left + Connector_1.Connector.minOffset);
            margin.right = Math.max(margin.right, connRect.right - shapeRect.right + Connector_1.Connector.minOffset);
            margin.top = Math.max(margin.top, shapeRect.top - connRect.top + Connector_1.Connector.minOffset);
            margin.bottom = Math.max(margin.bottom, connRect.bottom - shapeRect.bottom + Connector_1.Connector.minOffset);
        });
        var layout = new NodeLayout_1.NodeInfo(shape.key, margin, shape.size.clone());
        layout.connectionPoints = shape.description.getConnectionPoints();
        return layout;
    };
    return LayoutUtils;
}());
exports.LayoutUtils = LayoutUtils;


/***/ }),
/* 191 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CommandBase = /** @class */ (function () {
    function CommandBase(control) {
        this.control = control;
    }
    CommandBase.prototype.execute = function (parameter) {
        var state = this.getState();
        if (!state.enabled)
            return false;
        this.control.beginUpdate();
        var executed = this.executeCore(state, parameter);
        this.control.endUpdate();
        return executed;
    };
    CommandBase.prototype.updateControlState = function () {
        if (!this.lockUIUpdating()) {
            this.control.barManager.updateItemsState();
        }
    };
    CommandBase.prototype.lockUIUpdating = function () {
        return false;
    };
    return CommandBase;
}());
exports.CommandBase = CommandBase;


/***/ }),
/* 192 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandState = /** @class */ (function () {
    function SimpleCommandState(enabled, value, items, visible) {
        this.visible = true;
        this.denyUpdateValue = false;
        this.enabled = enabled;
        this.value = value;
        this.items = items;
        this.visible = visible;
    }
    return SimpleCommandState;
}());
exports.SimpleCommandState = SimpleCommandState;


/***/ }),
/* 193 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var UndoCommand = /** @class */ (function (_super) {
    __extends(UndoCommand, _super);
    function UndoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UndoCommand.prototype.executeCore = function (state) {
        this.control.beginUpdate(true);
        this.control.history.undo();
        this.control.endUpdate(true);
        return true;
    };
    UndoCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && this.control.history.canUndo();
    };
    return UndoCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.UndoCommand = UndoCommand;


/***/ }),
/* 194 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var RedoCommand = /** @class */ (function (_super) {
    __extends(RedoCommand, _super);
    function RedoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RedoCommand.prototype.executeCore = function (state) {
        this.control.beginUpdate(true);
        this.control.history.redo();
        this.control.endUpdate(true);
        return true;
    };
    RedoCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && this.control.history.canRedo();
    };
    return RedoCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.RedoCommand = RedoCommand;


/***/ }),
/* 195 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Importer_1 = __webpack_require__(103);
var ExportImportCommandBase_1 = __webpack_require__(47);
var ImportCommand = /** @class */ (function (_super) {
    __extends(ImportCommand, _super);
    function ImportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportCommand.prototype.executeCore = function (state, parameter) {
        var data = parameter["data"] ? parameter["data"] : parameter;
        var importer = new Importer_1.Importer(data);
        if (parameter["keepExistingItems"] === true) {
            importer.importItemsData(this.control.model);
            this.control.importItemsData();
        }
        else {
            var model = importer.import();
            this.control.importModel(model);
        }
        return true;
    };
    return ImportCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ImportCommand = ImportCommand;


/***/ }),
/* 196 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Exporter_1 = __webpack_require__(57);
var ExportImportCommandBase_1 = __webpack_require__(47);
var ExportCommand = /** @class */ (function (_super) {
    __extends(ExportCommand, _super);
    function ExportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportCommand.prototype.executeCore = function (state, parameter) {
        var exporter = new Exporter_1.Exporter();
        var data = exporter.export(this.control.model);
        parameter(data);
        return true;
    };
    return ExportCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ExportCommand = ExportCommand;


/***/ }),
/* 197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(58);
var ToggleFontBoldCommand = /** @class */ (function (_super) {
    __extends(ToggleFontBoldCommand, _super);
    function ToggleFontBoldCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontBoldCommand.prototype.getStyleProperty = function () {
        return "font-weight";
    };
    ToggleFontBoldCommand.prototype.getStylePropertyValue = function () {
        return "bold";
    };
    return ToggleFontBoldCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontBoldCommand = ToggleFontBoldCommand;


/***/ }),
/* 198 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(58);
var ToggleFontItalicCommand = /** @class */ (function (_super) {
    __extends(ToggleFontItalicCommand, _super);
    function ToggleFontItalicCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontItalicCommand.prototype.getStyleProperty = function () {
        return "font-style";
    };
    ToggleFontItalicCommand.prototype.getStylePropertyValue = function () {
        return "italic";
    };
    return ToggleFontItalicCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontItalicCommand = ToggleFontItalicCommand;


/***/ }),
/* 199 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(58);
var ToggleFontUnderlineCommand = /** @class */ (function (_super) {
    __extends(ToggleFontUnderlineCommand, _super);
    function ToggleFontUnderlineCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontUnderlineCommand.prototype.getStyleProperty = function () {
        return "text-decoration";
    };
    ToggleFontUnderlineCommand.prototype.getStylePropertyValue = function () {
        return "underline";
    };
    return ToggleFontUnderlineCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontUnderlineCommand = ToggleFontUnderlineCommand;


/***/ }),
/* 200 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(71);
var ChangeFontNameCommand = /** @class */ (function (_super) {
    __extends(ChangeFontNameCommand, _super);
    function ChangeFontNameCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontNameCommand.prototype.getStyleProperty = function () {
        return "font-family";
    };
    return ChangeFontNameCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontNameCommand = ChangeFontNameCommand;


/***/ }),
/* 201 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(71);
var ChangeFontSizeCommand = /** @class */ (function (_super) {
    __extends(ChangeFontSizeCommand, _super);
    function ChangeFontSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontSizeCommand.prototype.getStyleProperty = function () {
        return "font-size";
    };
    return ChangeFontSizeCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontSizeCommand = ChangeFontSizeCommand;


/***/ }),
/* 202 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(71);
var __1 = __webpack_require__(10);
var ChangeFontColorCommand = /** @class */ (function (_super) {
    __extends(ChangeFontColorCommand, _super);
    function ChangeFontColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontColorCommand.prototype.processParameter = function (parameter) {
        return __1.ColorHelper.stringToHash(parameter);
    };
    ChangeFontColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFontColorCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontColorCommand = ChangeFontColorCommand;


/***/ }),
/* 203 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommand_1 = __webpack_require__(107);
var __1 = __webpack_require__(10);
var ChangeFillColorCommand = /** @class */ (function (_super) {
    __extends(ChangeFillColorCommand, _super);
    function ChangeFillColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFillColorCommand.prototype.processParameter = function (parameter) {
        return __1.ColorHelper.stringToHash(parameter);
    };
    ChangeFillColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFillColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeFillColorCommand = ChangeFillColorCommand;


/***/ }),
/* 204 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeStylePropertyCommand_1 = __webpack_require__(107);
var __1 = __webpack_require__(10);
var ChangeStrokeColorCommand = /** @class */ (function (_super) {
    __extends(ChangeStrokeColorCommand, _super);
    function ChangeStrokeColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeColorCommand.prototype.processParameter = function (parameter) {
        return __1.ColorHelper.stringToHash(parameter);
    };
    ChangeStrokeColorCommand.prototype.getStyleProperty = function () {
        return "stroke";
    };
    return ChangeStrokeColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeColorCommand = ChangeStrokeColorCommand;


/***/ }),
/* 205 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(58);
var ChangeTextAlignCommand = /** @class */ (function (_super) {
    __extends(ChangeTextAlignCommand, _super);
    function ChangeTextAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeTextAlignCommand.prototype.getStyleProperty = function () {
        return "text-anchor";
    };
    return ChangeTextAlignCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ChangeTextAlignCommand = ChangeTextAlignCommand;
var TextLeftAlignCommand = /** @class */ (function (_super) {
    __extends(TextLeftAlignCommand, _super);
    function TextLeftAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextLeftAlignCommand.prototype.getStylePropertyValue = function () {
        return "start";
    };
    return TextLeftAlignCommand;
}(ChangeTextAlignCommand));
exports.TextLeftAlignCommand = TextLeftAlignCommand;
var TextCenterAlignCommand = /** @class */ (function (_super) {
    __extends(TextCenterAlignCommand, _super);
    function TextCenterAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextCenterAlignCommand.prototype.getStylePropertyValue = function () {
        return "middle";
    };
    return TextCenterAlignCommand;
}(ChangeTextAlignCommand));
exports.TextCenterAlignCommand = TextCenterAlignCommand;
var TextRightAlignCommand = /** @class */ (function (_super) {
    __extends(TextRightAlignCommand, _super);
    function TextRightAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextRightAlignCommand.prototype.getStylePropertyValue = function () {
        return "end";
    };
    return TextRightAlignCommand;
}(ChangeTextAlignCommand));
exports.TextRightAlignCommand = TextRightAlignCommand;


/***/ }),
/* 206 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeConnectorPropertyCommand_1 = __webpack_require__(108);
var ConnectorProperties_1 = __webpack_require__(25);
var ChangeConnectorStartLineEndingCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorStartLineEndingCommand, _super);
    function ChangeConnectorStartLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyName = function () {
        return "startLineEnding";
    };
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.None;
    };
    return ChangeConnectorStartLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorStartLineEndingCommand = ChangeConnectorStartLineEndingCommand;
var ChangeConnectorEndLineEndingCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorEndLineEndingCommand, _super);
    function ChangeConnectorEndLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyName = function () {
        return "endLineEnding";
    };
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.Arrow;
    };
    return ChangeConnectorEndLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorEndLineEndingCommand = ChangeConnectorEndLineEndingCommand;


/***/ }),
/* 207 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangeConnectorPropertyCommand_1 = __webpack_require__(108);
var ConnectorProperties_1 = __webpack_require__(25);
var ChangeConnectorLineOptionCommand = /** @class */ (function (_super) {
    __extends(ChangeConnectorLineOptionCommand, _super);
    function ChangeConnectorLineOptionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorLineOptionCommand.prototype.getPropertyName = function () {
        return "lineOption";
    };
    ChangeConnectorLineOptionCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineOption.Straight;
    };
    return ChangeConnectorLineOptionCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorLineOptionCommand = ChangeConnectorLineOptionCommand;


/***/ }),
/* 208 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var SelectAllCommand = /** @class */ (function (_super) {
    __extends(SelectAllCommand, _super);
    function SelectAllCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SelectAllCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    SelectAllCommand.prototype.executeCore = function (state, parameter) {
        var itemKeys = [];
        this.control.model.iterateItems(function (i) { return itemKeys.push(i.key); });
        this.control.selection.set(itemKeys);
        return true;
    };
    return SelectAllCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SelectAllCommand = SelectAllCommand;


/***/ }),
/* 209 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var AutoLayoutCommandBase_1 = __webpack_require__(59);
var WideTree_1 = __webpack_require__(72);
var LayoutSettings_1 = __webpack_require__(21);
var AutoLayoutTreeVerticalCommand = /** @class */ (function (_super) {
    __extends(AutoLayoutTreeVerticalCommand, _super);
    function AutoLayoutTreeVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalCommand.prototype.createLayoutSettings = function () {
        var gridSize = this.control.settings.snapToGrid ? this.control.settings.gridSize : undefined;
        var settings = new LayoutSettings_1.TreeLayoutSettings(gridSize);
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Vertical;
        return settings;
    };
    AutoLayoutTreeVerticalCommand.prototype.createLayout = function (settings, graph) {
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeVerticalCommand = AutoLayoutTreeVerticalCommand;


/***/ }),
/* 210 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tree_1 = __webpack_require__(211);
var Forest = /** @class */ (function () {
    function Forest(trees) {
        this.trees = trees;
    }
    Forest.create = function (graph) {
        var components = graph.getConnectedComponents();
        return new Forest(components.map(Tree_1.Tree.createSpanningTree));
    };
    return Forest;
}());
exports.Forest = Forest;


/***/ }),
/* 211 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Structures_1 = __webpack_require__(31);
var Tree = /** @class */ (function () {
    function Tree(root, parentToChildren) {
        var _this = this;
        this.childToParent = {};
        this.root = root;
        this.parentToChildren = parentToChildren;
        var _loop_1 = function (key) {
            if (!parentToChildren.hasOwnProperty(key))
                return "continue";
            parentToChildren[key].forEach(function (c) { return _this.childToParent[c.key] = key; });
        };
        for (var key in parentToChildren) {
            _loop_1(key);
        }
    }
    Tree.prototype.getChildren = function (node) {
        return node && this.parentToChildren[node.key] ? this.parentToChildren[node.key] : [];
    };
    Tree.prototype.hasChildren = function (node) {
        return this.parentToChildren[node.key] && this.parentToChildren[node.key].length > 0;
    };
    Tree.prototype.iterate = function (callback) {
        this.iterateCore(this.root, 0, callback);
    };
    Tree.createSpanningTree = function (component) {
        var rootKey = Tree.findRoot(component);
        var iterator = component.createIterator(Structures_1.ConnectionMode.Outgoing);
        var parentToChildren = {};
        iterator.skipEdge = (function (e) { return e.to === undefined || iterator.isNodeVisited(e.to); });
        iterator.onNode = function (n) { return parentToChildren[n.key] = []; };
        iterator.onEdge = function (e) { return parentToChildren[e.from].push(component.getNode(e.to)); };
        iterator.iterate(rootKey);
        return new Tree(component.getNode(rootKey), parentToChildren);
    };
    Tree.prototype.iterateCore = function (node, level, callback) {
        var _this = this;
        callback(node, level);
        this.getChildren(node).forEach(function (n) { return _this.iterateCore(n, level + 1, callback); });
    };
    Tree.findRoot = function (component) {
        return component.nodes.reduce(function (aggregator, cur) {
            var edges = component.getAdjacentEdges(cur);
            var inc = edges.filter(function (l) { return l.to === cur; }).length;
            var out = edges.filter(function (l) { return l.from === cur; }).length;
            if (aggregator.candidate === undefined || (inc === 0 && aggregator.inc > 0) || (aggregator.inc !== 0 && aggregator.out - aggregator.inc < out - inc)) {
                aggregator.candidate = cur;
                aggregator.inc = inc;
                aggregator.out = out;
            }
            return aggregator;
        }, { inc: -1, out: -1, candidate: undefined }).candidate;
    };
    return Tree;
}());
exports.Tree = Tree;


/***/ }),
/* 212 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangeSnapToGridCommand = /** @class */ (function (_super) {
    __extends(ChangeSnapToGridCommand, _super);
    function ChangeSnapToGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeSnapToGridCommand.prototype.executeCore = function (state, parameter) {
        var newValue = parameter === undefined ? !this.control.settings.snapToGrid : !!parameter;
        if (this.control.settings.snapToGrid !== newValue) {
            this.control.settings.snapToGrid = newValue;
            return true;
        }
        return false;
    };
    ChangeSnapToGridCommand.prototype.getValue = function () {
        return this.control.settings.snapToGrid;
    };
    return ChangeSnapToGridCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeSnapToGridCommand = ChangeSnapToGridCommand;


/***/ }),
/* 213 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangeGridSizeCommand = /** @class */ (function (_super) {
    __extends(ChangeGridSizeCommand, _super);
    function ChangeGridSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeGridSizeCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeGridSizeCommand.prototype.getValue = function () {
        return this.getModelUnit(this.control.settings.gridSize);
    };
    ChangeGridSizeCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.gridSize = this.getModelUnitTwipsValue(parameter);
        return true;
    };
    ChangeGridSizeCommand.prototype.getItems = function () {
        var _this = this;
        return this.control.settings.gridSizeItems.map(function (s) {
            return { value: _this.getModelUnit(s), text: _this.getViewUnitText(s) };
        });
    };
    return ChangeGridSizeCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeGridSizeCommand = ChangeGridSizeCommand;
var ChangeGridSizeItemsCommand = /** @class */ (function (_super) {
    __extends(ChangeGridSizeItemsCommand, _super);
    function ChangeGridSizeItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeGridSizeItemsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeGridSizeItemsCommand.prototype.getValue = function () {
        var _this = this;
        return this.control.settings.gridSizeItems.map(function (s) { return _this.getModelUnit(s); });
    };
    ChangeGridSizeItemsCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.settings.gridSizeItems = parameter.map(function (s) { return _this.getModelUnitTwipsValue(s); });
        return true;
    };
    return ChangeGridSizeItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeGridSizeItemsCommand = ChangeGridSizeItemsCommand;


/***/ }),
/* 214 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(60);
var ChangePageLandscapeHistoryItem_1 = __webpack_require__(215);
var ChangePageLandscapeCommand = /** @class */ (function (_super) {
    __extends(ChangePageLandscapeCommand, _super);
    function ChangePageLandscapeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageLandscapeCommand.prototype.getValue = function () {
        return this.control.model.pageLandscape;
    };
    ChangePageLandscapeCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageLandscapeHistoryItem_1.ChangePageLandscapeHistoryItem(parameter)];
    };
    return ChangePageLandscapeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageLandscapeCommand = ChangePageLandscapeCommand;


/***/ }),
/* 215 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangePageLandscapeHistoryItem = /** @class */ (function (_super) {
    __extends(ChangePageLandscapeHistoryItem, _super);
    function ChangePageLandscapeHistoryItem(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    ChangePageLandscapeHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model.pageLandscape;
        manipulator.changePageLandscape(this.value);
    };
    ChangePageLandscapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageLandscape(this.oldValue);
    };
    return ChangePageLandscapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageLandscapeHistoryItem = ChangePageLandscapeHistoryItem;


/***/ }),
/* 216 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ChangePagePropertyCommand_1 = __webpack_require__(60);
var Utils_1 = __webpack_require__(0);
var ChangePageSizeHistoryItem_1 = __webpack_require__(217);
var SimpleCommandBase_1 = __webpack_require__(6);
var ChangePageSizeCommand = /** @class */ (function (_super) {
    __extends(ChangePageSizeCommand, _super);
    function ChangePageSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageSizeCommand.prototype.getValue = function () {
        return this.getModelUnitSize(this.control.model.pageSize);
    };
    ChangePageSizeCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageSizeHistoryItem_1.ChangePageSizeHistoryItem(new Utils_1.Size(this.getModelUnitTwipsValue(parameter.width), this.getModelUnitTwipsValue(parameter.height)))];
    };
    ChangePageSizeCommand.prototype.getItems = function () {
        var _this = this;
        return this.control.settings.pageSizeItems.map(function (i) {
            return {
                value: _this.getModelUnitSize(i.size),
                text: i.text.replace("{width}", _this.getViewUnitText(i.size.width)).replace("{height}", _this.getViewUnitText(i.size.height))
            };
        });
    };
    ChangePageSizeCommand.prototype.getModelUnitSize = function (size) {
        return new Utils_1.Size(this.getModelUnit(size.width), this.getModelUnit(size.height));
    };
    return ChangePageSizeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageSizeCommand = ChangePageSizeCommand;
var ChangePageSizeItemsCommand = /** @class */ (function (_super) {
    __extends(ChangePageSizeItemsCommand, _super);
    function ChangePageSizeItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageSizeItemsCommand.prototype.isEnabled = function () {
        return true;
    };
    ChangePageSizeItemsCommand.prototype.getValue = function () {
        var _this = this;
        return this.control.settings.pageSizeItems.map(function (i) {
            return {
                size: new Utils_1.Size(_this.getModelUnit(i.width), _this.getModelUnit(i.height)),
                text: i.text
            };
        });
    };
    ChangePageSizeItemsCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.settings.pageSizeItems = parameter.map(function (i) {
            return {
                size: new Utils_1.Size(_this.getModelUnitTwipsValue(i.width), _this.getModelUnitTwipsValue(i.height)),
                text: i.text
            };
        });
        return true;
    };
    return ChangePageSizeItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangePageSizeItemsCommand = ChangePageSizeItemsCommand;


/***/ }),
/* 217 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var HistoryItem_1 = __webpack_require__(3);
var ChangePageSizeHistoryItem = /** @class */ (function (_super) {
    __extends(ChangePageSizeHistoryItem, _super);
    function ChangePageSizeHistoryItem(size) {
        var _this = _super.call(this) || this;
        _this.size = size;
        return _this;
    }
    ChangePageSizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.pageSize;
        manipulator.changePageSize(this.size);
    };
    ChangePageSizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageSize(this.oldSize);
    };
    return ChangePageSizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageSizeHistoryItem = ChangePageSizeHistoryItem;


/***/ }),
/* 218 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ExportImageCommand_1 = __webpack_require__(73);
var ExportPngCommand = /** @class */ (function (_super) {
    __extends(ExportPngCommand, _super);
    function ExportPngCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportPngCommand.prototype.getExtension = function () { return "png"; };
    ExportPngCommand.prototype.getExportFunc = function () {
        return this.exporter.exportPng;
    };
    return ExportPngCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportPngCommand = ExportPngCommand;


/***/ }),
/* 219 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var UnitConverter_1 = __webpack_require__(13);
var RenderManager_1 = __webpack_require__(11);
var Browser_1 = __webpack_require__(24);
var Utils_1 = __webpack_require__(15);
var CanvasManagerBase_1 = __webpack_require__(33);
var __1 = __webpack_require__(10);
var EXPORT_IMAGE_QUALITY = 1;
var CanvasExportManager = /** @class */ (function (_super) {
    __extends(CanvasExportManager, _super);
    function CanvasExportManager(itemsContainer) {
        var _this = _super.call(this, 1) || this;
        _this.itemsContainer = itemsContainer;
        return _this;
    }
    CanvasExportManager.prototype.getSvgImage = function (modelSize, pageColor) {
        var svgEl = RenderManager_1.RenderManager.createSvgElement(null);
        var modelAbsSize = modelSize.transform(UnitConverter_1.UnitConverter.twipsToPixelsF);
        Utils_1.RenderUtils.updateSvgElementSize(svgEl, modelAbsSize.width, modelAbsSize.height, true);
        svgEl.style.backgroundColor = __1.ColorHelper.colorToHash(pageColor);
        this.createTextFloodFilter(undefined, svgEl, pageColor);
        var exportCssRules = this.getExportCssRules();
        var useCssRules = exportCssRules && !Browser_1.Browser.IE;
        if (useCssRules) {
            var style = document.createElementNS(RenderManager_1.svgNS, "style");
            style.innerHTML = exportCssRules;
            svgEl.appendChild(style);
        }
        for (var i = 0; i < this.itemsContainer.childNodes.length; i++) {
            var node = this.itemsContainer.childNodes[i].cloneNode(true);
            if (!useCssRules) {
                this.inlineStyle(node, this.itemsContainer.childNodes[i]);
            }
            svgEl.appendChild(node);
        }
        return svgEl;
    };
    CanvasExportManager.prototype.getSvgImageUrl = function (modelSize, pageColor) {
        var svgEl = this.getSvgImage(modelSize, pageColor);
        return this.getSvgBase64String(svgEl);
    };
    CanvasExportManager.prototype.getSvgString = function (svgElement) {
        return new XMLSerializer().serializeToString(svgElement);
    };
    CanvasExportManager.prototype.getSvgBase64String = function (svgElement) {
        var xml = this.getSvgString(svgElement);
        return CanvasExportManager.base64Start + this.getBase64EncodeUnicode(xml);
    };
    CanvasExportManager.prototype.getBase64EncodeUnicode = function (s) {
        return btoa(encodeURIComponent(s).replace(/%([0-9A-F]{2})/g, function (match, p1) { return String.fromCharCode(parseInt("0x" + p1, 16)); }));
    };
    CanvasExportManager.prototype.getExportCssRules = function () {
        for (var i = 0; i < document.styleSheets.length; i++) {
            var rules = this.getRules(document.styleSheets[i]);
            if (rules) {
                var cssText = "";
                for (var j = 0; j < rules.length; j++) {
                    var rule = rules[j];
                    var selectorText = this.isCSSStyleRule(rule) ? rule.selectorText : null;
                    if (selectorText && this.checkSelector(selectorText))
                        cssText += rule.cssText + "\n";
                }
                if (cssText.length > 0)
                    return "\n" + cssText;
            }
        }
    };
    CanvasExportManager.prototype.checkSelector = function (selectorText) {
        for (var i = 0; i < CanvasExportManager.exportStyleRules.length; i++) {
            if (selectorText.indexOf(CanvasExportManager.exportStyleRules[i]) === 0)
                return true;
        }
        return false;
    };
    CanvasExportManager.prototype.getRules = function (styleSheet) {
        try {
            return this.isCSSStyleSheet(styleSheet) ? styleSheet.rules || styleSheet.cssRules : null;
        }
        catch (_a) { } // Catch access dinied exception
    };
    CanvasExportManager.prototype.isCSSStyleSheet = function (stylesheet) {
        return stylesheet.rules !== undefined;
    };
    CanvasExportManager.prototype.isCSSStyleRule = function (rule) {
        return rule.selectorText !== undefined;
    };
    CanvasExportManager.prototype.inlineStyle = function (destNode, srcNode) {
        for (var i = 0; i < destNode.childNodes.length; i++) {
            var child = destNode.childNodes[i];
            if (!child.tagName)
                continue;
            if (child.tagName === "g")
                this.inlineStyle(child, srcNode.childNodes[i]);
            else if (child.style) {
                var style = window.getComputedStyle(srcNode.childNodes[i]);
                if (style !== undefined) {
                    for (var index = 0; index < CanvasExportManager.exportStyleAttributes.length; index++) {
                        var styleProperty = CanvasExportManager.exportStyleAttributes[index];
                        child.style.setProperty(styleProperty, style.getPropertyValue(styleProperty));
                    }
                }
            }
        }
    };
    CanvasExportManager.prototype.exportSvgImage = function (modelSize, pageColor, callback) {
        callback(this.getSvgImageUrl(modelSize, pageColor));
    };
    CanvasExportManager.prototype.exportBinaryImage = function (modelSize, pageColor, mimeType, callback) {
        var modelAbsSize = modelSize.transform(UnitConverter_1.UnitConverter.twipsToPixelsF).multiply(this.actualZoom);
        var canvasEl = document.createElement('canvas');
        canvasEl.width = modelAbsSize.width;
        canvasEl.height = modelAbsSize.height;
        var ctx = canvasEl.getContext("2d");
        ctx.fillStyle = __1.ColorHelper.colorToHash(pageColor);
        ctx.fillRect(0, 0, modelAbsSize.width, modelAbsSize.height);
        if (Browser_1.Browser.IE && typeof window["canvg"] === "function") {
            var svgEl = this.getSvgImage(modelSize, pageColor);
            var svgStr = this.getSvgString(svgEl);
            ctx["drawSvg"](svgStr, 0, 0, null, null, {
                renderCallback: function () {
                    callback(canvasEl.toDataURL(mimeType, EXPORT_IMAGE_QUALITY));
                }
            });
        }
        else {
            var imgEl = new Image();
            imgEl.width = modelAbsSize.width;
            imgEl.height = modelAbsSize.height;
            imgEl.setAttribute('crossOrigin', 'anonymous');
            imgEl.onload = function () {
                ctx.drawImage(imgEl, 0, 0);
                callback(canvasEl.toDataURL(mimeType, EXPORT_IMAGE_QUALITY));
            };
            imgEl.src = this.getSvgImageUrl(modelSize, pageColor);
        }
    };
    CanvasExportManager.prototype.exportPngImage = function (modelSize, pageColor, callback) {
        this.exportBinaryImage(modelSize, pageColor, "image/png", callback);
    };
    CanvasExportManager.prototype.exportJpgImage = function (modelSize, pageColor, callback) {
        this.exportBinaryImage(modelSize, pageColor, "image/jpeg", callback);
    };
    CanvasExportManager.prototype.notifyModelChanged = function (changes) { };
    CanvasExportManager.prototype.notifyPageColorChanged = function (color) { };
    CanvasExportManager.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) { };
    CanvasExportManager.base64Start = 'data:image/svg+xml;base64,';
    CanvasExportManager.exportStyleRules = [
        ".dxdi-canvas .shape ", ".dxdi-canvas .connector ", ".dxdi-canvas text"
    ];
    CanvasExportManager.exportStyleAttributes = [
        "fill", "stroke", "stroke-width", "shape-rendering",
        "font-family", "font-size", "font-weight", "font-style", "text-decoration", "text-anchor"
    ];
    return CanvasExportManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasExportManager = CanvasExportManager;


/***/ }),
/* 220 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ExportImageCommand_1 = __webpack_require__(73);
var ExportSvgCommand = /** @class */ (function (_super) {
    __extends(ExportSvgCommand, _super);
    function ExportSvgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportSvgCommand.prototype.getExtension = function () { return "svg"; };
    ExportSvgCommand.prototype.getExportFunc = function () {
        return this.exporter.exportSvg;
    };
    return ExportSvgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportSvgCommand = ExportSvgCommand;


/***/ }),
/* 221 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ExportImageCommand_1 = __webpack_require__(73);
var ExportJpgCommand = /** @class */ (function (_super) {
    __extends(ExportJpgCommand, _super);
    function ExportJpgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportJpgCommand.prototype.getExtension = function () { return "jpg"; };
    ExportJpgCommand.prototype.getExportFunc = function () {
        return this.exporter.exportJpg;
    };
    return ExportJpgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportJpgCommand = ExportJpgCommand;


/***/ }),
/* 222 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
    