/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { ElementRef, NgZone, PLATFORM_ID, Inject, EventEmitter } from '@angular/core';
import { isPlatformServer } from '@angular/common';
import { TransferState, makeStateKey } from '@angular/platform-browser';
import { DxTemplateHost } from './template-host';
import { EmitterHelper, NgEventsStrategy } from './events-strategy';
import { WatcherHelper } from './watcher-helper';
import * as domAdapter from 'devextreme/core/dom_adapter';
import * as events from 'devextreme/events';
import { CollectionNestedOptionContainerImpl } from './nested-option';
export var IS_PLATFORM_SERVER = makeStateKey('DX_isPlatformServer');
var DxComponent = /** @class */ (function () {
    function DxComponent(element, ngZone, templateHost, watcherHelper, transferState, platformId) {
        this.element = element;
        this.watcherHelper = watcherHelper;
        this.transferState = transferState;
        this.platformId = platformId;
        this._initialOptions = {};
        this._optionsToUpdate = {};
        this.optionChangedHandlers = new EventEmitter();
        this.isLinked = true;
        this.changedOptions = {};
        this.createInstanceOnInit = true;
        this.widgetUpdateLocked = false;
        this.templates = [];
        templateHost.setHost(this);
        this._collectionContainerImpl = new CollectionNestedOptionContainerImpl(this._setOption.bind(this));
        this.eventHelper = new EmitterHelper(ngZone, this);
    }
    DxComponent.prototype._initTemplates = function () {
        if (this.templates.length) {
            var initialTemplates_1 = {};
            this.templates.forEach(function (template) {
                initialTemplates_1[template.name] = template;
            });
            this.instance.option('integrationOptions.templates', initialTemplates_1);
        }
    };
    DxComponent.prototype._initEvents = function () {
        var _this = this;
        this.instance.on('optionChanged', function (e) {
            _this.changedOptions[e.name] = e.value;
            var value = e.name === e.fullName ? e.value : e.component.option(e.name);
            _this.eventHelper.fireNgEvent(e.name + 'Change', [value]);
            _this.optionChangedHandlers.emit(e);
        });
    };
    DxComponent.prototype._initOptions = function () {
        this._initialOptions.integrationOptions.watchMethod = this.watcherHelper.getWatchMethod();
    };
    DxComponent.prototype._initPlatform = function () {
        if (this.transferState.hasKey(IS_PLATFORM_SERVER)) {
            this._initialOptions.integrationOptions.renderedOnServer = this.transferState.get(IS_PLATFORM_SERVER, null);
        }
        else if (isPlatformServer(this.platformId)) {
            this.transferState.set(IS_PLATFORM_SERVER, true);
        }
    };
    DxComponent.prototype._createEventEmitters = function (events) {
        var _this = this;
        this.eventHelper.createEmitters(events);
        this._initialOptions.eventsStrategy = function (instance) {
            var strategy = new NgEventsStrategy(instance);
            events.filter(function (event) { return event.subscribe; }).forEach(function (event) {
                strategy.addEmitter(event.subscribe, _this[event.emit]);
            });
            return strategy;
        };
        this._initialOptions.nestedComponentOptions = function (component) {
            return {
                eventsStrategy: function (instance) { return new NgEventsStrategy(instance); },
                nestedComponentOptions: component.option('nestedComponentOptions')
            };
        };
    };
    DxComponent.prototype._shouldOptionChange = function (name, value) {
        if (this.changedOptions.hasOwnProperty(name)) {
            var prevValue = this.changedOptions[name];
            delete this.changedOptions[name];
            return value !== prevValue;
        }
        return true;
    };
    DxComponent.prototype.clearChangedOptions = function () {
        this.changedOptions = {};
    };
    DxComponent.prototype._getOption = function (name) {
        return this.instance ?
            this.instance.option(name) :
            this._initialOptions[name];
    };
    DxComponent.prototype.lockWidgetUpdate = function () {
        if (!this.widgetUpdateLocked && this.instance) {
            this.instance.beginUpdate();
            this.widgetUpdateLocked = true;
        }
    };
    DxComponent.prototype.unlockWidgetUpdate = function () {
        if (this.widgetUpdateLocked) {
            this.widgetUpdateLocked = false;
            this.instance.endUpdate();
        }
    };
    DxComponent.prototype._setOption = function (name, value) {
        this.lockWidgetUpdate();
        if (!this._shouldOptionChange(name, value)) {
            return;
        }
        if (this.instance) {
            this.instance.option(name, value);
        }
        else {
            this._initialOptions[name] = value;
        }
    };
    DxComponent.prototype._createWidget = function (element) {
        this._initialOptions.integrationOptions = {};
        this._initPlatform();
        this._initOptions();
        var createInstanceOnInit = this.createInstanceOnInit;
        this._initialOptions.onInitializing = function () {
            if (createInstanceOnInit) {
                this.beginUpdate();
            }
        };
        this.instance = this._createInstance(element, this._initialOptions);
        this._initEvents();
        this._initialOptions = {};
    };
    DxComponent.prototype._destroyWidget = function () {
        if (this.instance) {
            var element = this.instance.element();
            events.triggerHandler(element, 'dxremove', { _angularIntegration: true });
            this.instance.dispose();
            domAdapter.removeElement(element);
        }
    };
    DxComponent.prototype.ngOnChanges = function (changes) {
        for (var key in changes) {
            var change = changes[key];
            if (change.currentValue !== this[key]) {
                this._optionsToUpdate[key] = changes[key].currentValue;
            }
        }
    };
    DxComponent.prototype.ngOnInit = function () {
        if (this.createInstanceOnInit) {
            this._createWidget(this.element.nativeElement);
        }
    };
    DxComponent.prototype.ngDoCheck = function () {
        this.applyOptions();
    };
    DxComponent.prototype.ngAfterContentChecked = function () {
        this.applyOptions();
        this.unlockWidgetUpdate();
    };
    DxComponent.prototype.ngAfterViewInit = function () {
        this._initTemplates();
        if (this.createInstanceOnInit) {
            this.instance.endUpdate();
        }
    };
    DxComponent.prototype.applyOptions = function () {
        if (Object.keys(this._optionsToUpdate).length) {
            if (this.instance) {
                this.instance.option(this._optionsToUpdate);
            }
            this._optionsToUpdate = {};
        }
    };
    DxComponent.prototype.setTemplate = function (template) {
        this.templates.push(template);
    };
    DxComponent.prototype.setChildren = function (propertyName, items) {
        return this._collectionContainerImpl.setChildren(propertyName, items);
    };
    /** @nocollapse */
    DxComponent.ctorParameters = function () { return [
        { type: ElementRef },
        { type: NgZone },
        { type: DxTemplateHost },
        { type: WatcherHelper },
        { type: TransferState },
        { type: undefined, decorators: [{ type: Inject, args: [PLATFORM_ID,] }] }
    ]; };
    return DxComponent;
}());
export { DxComponent };
var DxComponentExtension = /** @class */ (function (_super) {
    __extends(DxComponentExtension, _super);
    function DxComponentExtension() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DxComponentExtension.prototype.createInstance = function (element) {
        this._createWidget(element);
    };
    return DxComponentExtension;
}(DxComponent));
export { DxComponentExtension };

//# sourceMappingURL=data:application/json;base64,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