/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { Injectable, IterableDiffers } from '@angular/core';
var IterableDifferHelper = /** @class */ (function () {
    function IterableDifferHelper(_differs) {
        this._differs = _differs;
        this._propertyDiffers = {};
    }
    IterableDifferHelper.prototype.setHost = function (host) {
        this._host = host;
    };
    IterableDifferHelper.prototype.setup = function (prop, changes) {
        if (prop in changes) {
            var value = changes[prop].currentValue;
            this.setupSingle(prop, value);
        }
    };
    IterableDifferHelper.prototype.setupSingle = function (prop, value) {
        if (value && Array.isArray(value)) {
            if (!this._propertyDiffers[prop]) {
                try {
                    this._propertyDiffers[prop] = this._differs.find(value).create(null);
                    return true;
                }
                catch (e) { }
            }
        }
        else {
            delete this._propertyDiffers[prop];
        }
        return false;
    };
    IterableDifferHelper.prototype.getChanges = function (prop, value) {
        if (this._propertyDiffers[prop]) {
            return this._propertyDiffers[prop].diff(value);
        }
    };
    IterableDifferHelper.prototype.checkChangedOptions = function (propName, hostValue) {
        return this._host.changedOptions[propName] === hostValue;
    };
    ;
    IterableDifferHelper.prototype.doCheck = function (prop) {
        if (this._propertyDiffers[prop]) {
            var hostValue = this._host[prop], isChangedOption = this.checkChangedOptions(prop, hostValue);
            var changes = this.getChanges(prop, hostValue);
            if (changes && this._host.instance && !isChangedOption) {
                this._host.lockWidgetUpdate();
                this._host.instance.option(prop, hostValue);
            }
        }
    };
    IterableDifferHelper.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    IterableDifferHelper.ctorParameters = function () { return [
        { type: IterableDiffers }
    ]; };
    return IterableDifferHelper;
}());
export { IterableDifferHelper };

//# sourceMappingURL=data:application/json;base64,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