/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-line-length */
/* tslint:disable:use-input-property-decorator */
import { Component, NgModule, Host, SkipSelf, Output, EventEmitter, ContentChildren, forwardRef, QueryList } from '@angular/core';
import { NestedOptionHost } from '../../core/nested-option';
import { DxoTextBoxOptions } from './base/text-box-options';
import { DxiButtonComponent } from './button-dxi';
var DxoSearchEditorOptionsComponent = /** @class */ (function (_super) {
    __extends(DxoSearchEditorOptionsComponent, _super);
    function DxoSearchEditorOptionsComponent(parentOptionHost, optionHost) {
        var _this = _super.call(this) || this;
        _this._createEventEmitters([
            { emit: 'textChange' },
            { emit: 'valueChange' }
        ]);
        parentOptionHost.setNestedOption(_this);
        optionHost.setHost(_this, _this._fullOptionPath.bind(_this));
        return _this;
    }
    Object.defineProperty(DxoSearchEditorOptionsComponent.prototype, "_optionPath", {
        get: function () {
            return 'searchEditorOptions';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoSearchEditorOptionsComponent.prototype, "buttonsChildren", {
        get: function () {
            return this._getOption('buttons');
        },
        set: function (value) {
            this.setChildren('buttons', value);
        },
        enumerable: true,
        configurable: true
    });
    DxoSearchEditorOptionsComponent.decorators = [
        { type: Component, args: [{
                    selector: 'dxo-search-editor-options',
                    template: '',
                    styles: [''],
                    providers: [NestedOptionHost],
                    inputs: [
                        'accessKey',
                        'activeStateEnabled',
                        'buttons',
                        'disabled',
                        'elementAttr',
                        'focusStateEnabled',
                        'height',
                        'hint',
                        'hoverStateEnabled',
                        'inputAttr',
                        'isValid',
                        'mask',
                        'maskChar',
                        'maskInvalidMessage',
                        'maskRules',
                        'maxLength',
                        'mode',
                        'name',
                        'onChange',
                        'onContentReady',
                        'onCopy',
                        'onCut',
                        'onDisposing',
                        'onEnterKey',
                        'onFocusIn',
                        'onFocusOut',
                        'onInitialized',
                        'onInput',
                        'onKeyDown',
                        'onKeyPress',
                        'onKeyUp',
                        'onOptionChanged',
                        'onPaste',
                        'onValueChanged',
                        'placeholder',
                        'readOnly',
                        'rtlEnabled',
                        'showClearButton',
                        'showMaskMode',
                        'spellcheck',
                        'stylingMode',
                        'tabIndex',
                        'text',
                        'useMaskedValue',
                        'validationError',
                        'validationErrors',
                        'validationMessageMode',
                        'validationStatus',
                        'value',
                        'valueChangeEvent',
                        'visible',
                        'width'
                    ]
                },] },
    ];
    /** @nocollapse */
    DxoSearchEditorOptionsComponent.ctorParameters = function () { return [
        { type: NestedOptionHost, decorators: [{ type: SkipSelf }, { type: Host }] },
        { type: NestedOptionHost, decorators: [{ type: Host }] }
    ]; };
    DxoSearchEditorOptionsComponent.propDecorators = {
        textChange: [{ type: Output }],
        valueChange: [{ type: Output }],
        buttonsChildren: [{ type: ContentChildren, args: [forwardRef(function () { return DxiButtonComponent; }),] }]
    };
    return DxoSearchEditorOptionsComponent;
}(DxoTextBoxOptions));
export { DxoSearchEditorOptionsComponent };
var DxoSearchEditorOptionsModule = /** @class */ (function () {
    function DxoSearchEditorOptionsModule() {
    }
    DxoSearchEditorOptionsModule.decorators = [
        { type: NgModule, args: [{
                    declarations: [
                        DxoSearchEditorOptionsComponent
                    ],
                    exports: [
                        DxoSearchEditorOptionsComponent
                    ],
                },] },
    ];
    return DxoSearchEditorOptionsModule;
}());
export { DxoSearchEditorOptionsModule };

//# sourceMappingURL=data:application/json;base64,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